<?php

    function template_images($tabUrlImage){
        /*Grosse premiere image */
        if (count($tabUrlImage) > 0 ) {
            $sortie = '<div class="gal-bigone">
                    <a href="'.$tabUrlImage[0]['url'].'" data-fancybox="images" data-caption="'.$tabUrlImage[0]['legende'].'">
                        <img src="'.$tabUrlImage[0]['url'].'" alt=""/>
                    </a>
                </div>';
            
            array_splice($tabUrlImage,0,1);
            
            if (count($tabUrlImage) > 0 ) {
            //images suivantes
                $sortie .='<ul id="galerie_photo">';
                foreach($tabUrlImage as $imageData){
                    $sortie .='<li style="background-color: #ccc;">
                                <a href="'.$imageData['url'].'"
                                    data-fancybox="images"
                                    data-caption="'.str_replace('"', '&quot;', utf8_decode($imageData['legende'])).'"
                                    style="background-image:url(\''.$imageData['url'].'\')">
                                </a></li>';            
                }
                $sortie .='</ul>';
            }
        }
        
        return $sortie;
    }
    
    function b_icon_file($name, $file, $classplus="") {
        $extension = strrchr($name,'.');
        switch ($extension) {
            case ".gif":
            case ".png":
            case ".jpg":
            case ".jpeg":
            case ".ai":
            case ".dxf":
            case ".tif":
            case ".tiff":
            case ".wmf":
            case ".ps":
            case ".eps":
                $icon = "fa fa-file-image-o fa-fw";
                break;
            case ".json":
            case ".php":
            case ".js":
            case ".css":
            case ".htm":
            case ".html":
                $icon = "fa fa-file-code-o fa-fw";
                break;
            case ".xls":
            case ".xlsx":
            case ".csv":
            case ".dbf":
            case ".ods":
            case ".sql":
                $icon = "fa fa-file-excel-o fa-fw";
                break;
            case ".ppt":
            case ".pptx":
            case ".pps":
            case ".pot":
            case ".potx":
            case ".odp":
                $icon = "fa fa-file-powerpoint-o fa-fw";
                break;
            case ".doc":
            case ".docx":
            case ".rtf":
            case ".odt":
            case ".pages":
                $icon = "fa fa-file-word-o fa-fw";
                break;
            case ".txt":
            case ".md":
                $icon = "fa fa-file-text-o fa-fw";
                break;
            case ".o":
            case ".og":
            case ".mp4":
            case ".webm":
            case ".mg":
            case ".mpg":
            case ".mov":
            case ".3gp":
                $icon = "fa fa-file-video-o fa-fw";
                break;
            case ".mp3":
            case ".wav":
            case ".m4a":
                $icon = "fa fa-file-audio-o fa-fw";
                break;
            case ".pdf":
                $icon = "fa fa-file-pdf-o fa-fw";
                break;
            case ".zip":
            case ".gz":
            case ".7z":
            case ".tar":
            case ".tgz":
            case ".rar":
                $icon = "fa fa-file-archive-o fa-fw";
                break;
            default:
                $icon = "fa fa-file-o fa-fw";;
                break;
        }
        return '<a href="'.$file.'" target="_blank"><i class="'.$icon." ".$classplus.' fa-lg" data-original-title="'.str_replace('"', '\"', $name).'" data-placement="bottom" data-toggle="tooltip"></i></a>';
    }
    
    function add_infos_bib($texte, $sep = ", ", $classe = "") {
        $sortie = "";
        
        if ($texte != "") {
            $sortie = $sep.$texte;
            if ($classe != "") {
                $sortie = '<span class="'.$classe.'">'.$sortie.'</span>';
            }
        }
        
        return $sortie;
    }
    function template_biblio($biblios) {
        global $currentlang;
        
        $sortie = '';
        if (count($biblios) > 0 ) {
            if ($currentlang == "french") {
                $sortie .= '<h4>Bibliographie</h4>';
            }
            if ($currentlang == "italian") {
                $sortie .= '<h4>Bibliografia</h4>';
            }
            $sortie .='<ul id="biblio">';
            foreach($biblios as $biblio) {
                $sortie .= '<li>';
                $sortie .= add_infos_bib(utf8_decode($biblio["auteur"]), "");
                $sortie .= add_infos_bib(utf8_decode($biblio["annee"]), ", ");
                $sortie .= add_infos_bib(utf8_decode($biblio["titre"]), " - ", "em");
                $sortie .= add_infos_bib(utf8_decode($biblio["journal"]).((utf8_decode($biblio["journal"]) != "" && utf8_decode($biblio["editeur"]) != "") ? " - " : "" ).utf8_decode($biblio["editeur"]), ". ");
                if ($biblio["tome"] != "" && $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib($biblio["tome"]." (".utf8_decode($biblio["volume"].")"));
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["tome"]));
                    $sortie .=  add_infos_bib(utf8_decode($biblio["volume"]));
                }
                if ($biblio["tome"] != "" || $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]),":");
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]));
                }
                if (count($biblio["fichiers"]) > 0) {
                    $sortie .= '&nbsp;';
                    $fichiers = $biblio["fichiers"];
                    foreach ($fichiers as $unficher) {
                        $sortie .= b_icon_file($unficher["nom"], $unficher["url"]);
                    }
                }
                $sortie .= '</li>';
            }
            $sortie .= '</ul>';
        }
        return $sortie;
    }
    
    function conv2iso($texte) {
        $sortie = $texte;
        $sortie = str_replace("\\u2019", "'", $sortie);
        return $sortie;
    }
    
    function template_obs($observations) {
        $sortie = 'var dataset = [';
        if (count($observations) > 0 ) {
            foreach($observations as $observation) {
                $sortie .= ($sortie != "") ? "," : "";
                $sortie .= '
				{
					"date": "'.$observation["date"].'",
                    "centre" : "'.$observation["geom"].'",
                    "nombre" : "'.$observation["nombre"].'"
				}';
            }
        }
        $sortie .= '];';
        return $sortie;
    }
    
    function template_taxon_index($taxon) {
        global $currentlang;
        
        $sortie = "";
        
        $nomvern = "";
        if ($taxon["nom_vernaculaire"] != "") {
            $nomvern = ' - '.utf8_decode($taxon["nom_vernaculaire"]);
        }
        if ($currentlang == "french") {
            $idmodele = "224";
        }
        if ($currentlang == "italian") {
            $idmodele = "262";
        }
        $sortie .= '<a href="'.normalize_name(utf8_decode($taxon["nom_scientifique"])).'_mpage_'.$idmodele.'_idtaxon,'.$taxon["id_taxon"].'.htm">
<div class="grid_2 mb10 fiche">
<div class="img" style="background-image: url(\''.$taxon["photos"][0]["url"].'\')"></div>
<p class="titrefiche"><em>'.utf8_decode($taxon["nom_scientifique"]).'</em>'.$nomvern.'
</div>
</a>';
        return $sortie;
    }


/* les boutons pr�c�dent et suivant devront �tre repris si je dois m'en servir */
    $scriptsmap = "";
    
    global $idtaxon;
    if (!isset($idtaxon) || $idtaxon == "") {
        $idtaxon="";
        if (preg_match("#({id_taxon=)([0-9]+)(})#imsU", $article["content"], $matches)) {
            $idtaxon = $matches[2];
            $article["content"] = str_replace($matches[0], "", $article["content"]);
        }
    }
    
/* fiche esp�ce invasive */
    if (isset($idtaxon) && $idtaxon != "") {
        $temp = json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_especes&key=fea9a667df9db40499ebf94e5b6a07f6&ids_taxon=".$idtaxon)), true);
        $taxon =  $temp["result"]["data"][0];
        
        //var_dump($taxon);
        $nom_scientifique = utf8_decode($taxon["nom_scientifique"]);
        $nom_vernaculaire = utf8_decode($taxon["nom_vernaculaire"]);
        $regne = utf8_decode($taxon["regne"]);
        $embranchement = utf8_decode($taxon["embranchement"]);
        $classe = utf8_decode($taxon["classe"]);
        $ordre = utf8_decode($taxon["ordre"]);
        $famille = utf8_decode($taxon["famille"]);
        $genre = utf8_decode($taxon["genre"]);
        $origine = utf8_decode($taxon["origine"]);
        $photos = template_images($taxon["photos"]);
        $bibliographie = template_biblio($taxon["bibliographies"]);
        $observation = template_obs($taxon["observations"]);
        
        $scriptsmap = '
    <link rel="stylesheet" href="themes/sdpweb/style/map.css">
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/leaflet/leaflet.css" />
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/Leaflet.EasyButton/easy-button.css" />
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/Leaflet.fullscreen/leaflet.fullscreen.css" />
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/map_arob-UImap_arob/map_arob.editmap/editmap.css" />
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/map_arob-UImap_arob/map_arob.screenshot/screenshot.css" />
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/UImap_arob.proj.css">
    <link rel="stylesheet" href="themes/sdpweb/js/Leaflet.markercluster/dist/MarkerCluster.css">
    <link rel="stylesheet" href="themes/sdpweb/js/Leaflet.markercluster/dist/MarkerCluster.Default.css">
    <link rel="stylesheet" href="themes/sdpweb/js/map_arob/map_arob-UImap_arob/map_arob.editLayerProperties/editLayerProperties.css">
';
    }
    
/* liste esp�ces invasives */
    global $invasif, $list;
    if (isset($invasif) && $invasif == "true") {
        $temp = json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_especes_inv&list=".$list."&key=fea9a667df9db40499ebf94e5b6a07f6")), true);
        $taxons =  $temp["result"]["data"];
        $compteur = 0;
        $liste_taxons = '<div class="row">';
        foreach($taxons as $taxon) {
            if ($compteur == 6) {
                $liste_taxons .= '</div><div class="row">';
                $compteur == 0;
            }
            $liste_taxons .= template_taxon_index($taxon);
            $compteur++;
        }
        $liste_taxons .= '</div>';
    }
	
	require_once('themes/'.$Default_Theme.'/btn_retour.php');
	global $scripts_extra;
	$scripts_extra .= '<link rel="stylesheet" href="themes/sdpweb/style/jquery.fancybox.min.css" />
    <script src="themes/sdpweb/js/jquery.fancybox.min.js"></script>
    '.$scriptsmap;

	/*if ($highlite != "") {
		$matches = array();
		$matchessortie = array();
		if (preg_match_all("#(<script[^>]*>)(.*)(</script)#imsU", $article["content"], $matches)) {
			for ($i=1;$i<count($matches); $i++) {
				$matchessortie[$i] = preg_replace("#$highlite#im", "_codearemplaceravanthilite_", $matches[$i]);
				if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
					$matchessortie[$i] = preg_replace("#".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1")."#im", "_codearemplaceravanthilite2_", $matchessortie[$i]);
				}
				$article["content"] = str_replace($matches[$i], $matchessortie[$i], $article["content"]);
			}
		}
		
		$article["content"] = preg_replace("#(>[^<]*)($highlite)#i","\\1<span class=\"highlite\">\\2</span>" ,$article["content"]);
		if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
			$article["content"] = preg_replace("#(>[^<]*)(".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1").")#i","\\1<span class=\"highlite\">\\2</span>" ,$article["content"]);
		}
		
		$article["content"] = str_replace("_codearemplaceravanthilite_", $highlite, $article["content"]);
		$article["content"] = str_replace("_codearemplaceravanthilite2_", htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1"), $article["content"]);
	}*/
	 
	if ((($article["status"]=="P") && (is_user_group($article["view"]))) || is_admin($admin)) {
	    $contentpages = preg_split("#((<!--pagebreak-->)|(<div style=\"page-break-after: always(;?)\"><span style=\"display:( ?)none(;?)\">( |&nbsp;)</span></div>))#mi",$article["content"],-1);
		$pageno = count($contentpages);
		if ( $page=="" || $page < 1 ) {
			$page = 1;
		}
		if ( $page > $pageno ) {
			$page = $pageno;
		}
		$arrayelement = (int)$page;
		$arrayelement --;
		if ($pageno > 1) {
			$curpage = ""._PAGE.": $page/$pageno";
		}
		
		global $section_data;
		if (file_exists("themes/$Default_Theme/section_data.php")){
			include("themes/$Default_Theme/section_data.php");
		}
		$contentpages[$arrayelement] = addslashes($contentpages[$arrayelement]);
		$contentpages[$arrayelement] = "\$contentpages[$arrayelement]=\"".$contentpages[$arrayelement]."\";";
		eval($contentpages[$arrayelement]);
		$contentpages[$arrayelement] = stripslashes($contentpages[$arrayelement]);
		
		if ($highlite != "") {
		    $matches = array();
		    $matchessortie = array();
		    if (preg_match_all("#(<script[^>]*>)(.*)(</script)#imsU", $contentpages[$arrayelement], $matches)) {
		        for ($i=1;$i<count($matches); $i++) {
		            $matchessortie[$i] = preg_replace("#$highlite#im", "_codearemplaceravanthilite_", $matches[$i]);
		            if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
		                $matchessortie[$i] = preg_replace("#".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1")."#im", "_codearemplaceravanthilite2_", $matchessortie[$i]);
		            }
		            $contentpages[$arrayelement] = str_replace($matches[$i], $matchessortie[$i], $contentpages[$arrayelement]);
		        }
		    }
		    
		    $contentpages[$arrayelement] = preg_replace("#(>[^<]*)($highlite)#i","\\1<span class=\"highlite\">\\2</span>" ,$contentpages[$arrayelement]);
		    if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
		        $contentpages[$arrayelement] = preg_replace("#(>[^<]*)(".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1").")#i","\\1<span class=\"highlite\">\\2</span>" ,$contentpages[$arrayelement]);
		    }
		    
		    $contentpages[$arrayelement] = str_replace("_codearemplaceravanthilite_", $highlite, $contentpages[$arrayelement]);
		    $contentpages[$arrayelement] = str_replace("_codearemplaceravanthilite2_", htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1"), $contentpages[$arrayelement]);
		}

		$contentpages[$arrayelement] = insert_video_player($contentpages[$arrayelement],true);
		$contentpages[$arrayelement] = insert_simple_map($contentpages[$arrayelement],true);
		$contentpages[$arrayelement] = insert_photo_zoom($contentpages[$arrayelement], true);
		
		if (!$useTheme) {
			$contentpages[$arrayelement] = str_replace("=viewarticle&", "=viewarticlenotheme&",$contentpages[$arrayelement]);
			$contentpages[$arrayelement] = str_replace("=viewarticle\"", "=viewarticlenotheme\"",$contentpages[$arrayelement]);
		}
		$sortie .= "$contentpages[$arrayelement]";
		
		//si il y a des sauts de page
		$menu_en_cours = "";
		if($pageno > 1) {
			if (file_exists("modules/becmsDynMenu/lib/g_params.php")) {
				require("modules/becmsDynMenu/lib/g_params.php");
				if ($GLOBALS[$modmenu["Menu"]] != "") {
					$menu_en_cours = "&".$modmenu["Menu"]."=".$GLOBALS[$modmenu["Menu"]];
				}
			}
		}
		
		if($page >= $pageno) {
	  		$next_page = "";
		} 
		else {
			$next_pagenumber = $page + 1;
			$next_page .= "<a href=\"mobiles.php?name=Sections&sop=viewarticle&artid=".$article["artid"]."&page=$next_pagenumber$menu_en_cours\">"._NEXT."</a>";
		}
		if($page <= 1) {
			$previous_page = "";
		}
		else {
			$previous_pagenumber = $page - 1;
			$previous_page = "<a href=\"mobiles.php?name=Sections&sop=viewarticle&artid=".$article["artid"]."&page=$previous_pagenumber$menu_en_cours\">"._PREVIOUS."</a>&nbsp;&nbsp;";
		}
		if ($curpage != "") {
			$sortie .= "<div class=\"prevnext\">"
			."$curpage  - $previous_page $next_page"
			."</div>";
		}
		
		if (isset($idtaxon) && $idtaxon != "") {
		    $sortie .= '
    <script src="themes/sdpweb/js/wkx/dist/wkx.min.js"></script>
    
    <script src="themes/sdpweb/js/map_arob/leaflet/leaflet.js"></script>
    <script src="themes/sdpweb/js/map_arob/Editable/Leaflet.Editable.js"></script>
    <script src="themes/sdpweb/js/map_arob/leaflet.filelayer/togeojson.js"></script>
    <script src="themes/sdpweb/js/map_arob/leaflet.filelayer/leaflet.filelayer.js"></script>
    <script src="themes/sdpweb/js/map_arob/Leaflet.EasyButton/easy-button.js"></script>
    <script src="themes/sdpweb/js/map_arob/Leaflet.leaflet-image/leaflet-image.js"></script>
    <script src="themes/sdpweb/js/map_arob/Leaflet.fullscreen/Leaflet.fullscreen.min.js"></script>
    <script src="themes/sdpweb/js/map_arob/Leaflet.TileLayer.Fallback/leaflet.tilelayer.fallback.js"></script>
    <script src="themes/sdpweb/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/proj4js-2.5.0/dist/proj4-src.js"></script>
    <script src="themes/sdpweb/js/map_arob/map_arob-UImap_arob/map_arob.map-only.full.js"></script>
    <script src="themes/sdpweb/js/map_arob/lang_fr.js"></script>
    
    <script src="themes/sdpweb/js/Leaflet.markercluster/dist/leaflet.markercluster.js"></script>

<script>
$(function() {
        /* donn�es � afficher*/
'.$observation.'
        /* init propri�t�s de la map */
        map_arob.layer_tile.init({
            // obligatoire
            "mburl" : "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", 
            // optionnel, par d�fault tous les tuiles suivantes sont integr�es
            "tiles" : [
            	{
	                "id" : "vincent2b/ckacgndr602if1iloq3zpxoif",
	                "nom" : "Outdoors",
	                "url_zxy" : "mapbox_zxy"
				},
            	/*{
	                "id" : "openstreetmap",
	                "nom" : "openstreetmap",
	                "url_zxy" : "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
	                "attribution" : "&copy; <a href=\'https://www.openstreetmap.org/copyright\'>OpenStreetMap</a> contributors"
				},*/
				{
	                "id" : "opentopomap",
	                "nom" : "opentopomap",
	                "url_zxy" : "https://c.tile.opentopomap.org/{z}/{x}/{y}.png",
	                "attribution" : "� OpenStreetMap contributors, SRTM | map style: � OpenTopoMap (CC-BY-SA)"
	            },
	            /*{
					id : "arobase_BDORTHO",
					nom : "BD-ORTHO corse",
					url_zxy : "https://bdortho.arobase.corsica/corsica/{z}/{x}/{y}.jpg",
					attribution : "Carte BD-ORTHO _ arobase.fr"
				},*/
	            {
	                "id" : "vincent2b/ckadls8ql0l7k1ilo0lps4swq",
	                "nom" : "Satellite monde",
	                "url_zxy" : "mapbox_zxy"
				},
	            {
	                "id" : "vincent2b/ckadl6ni406ou1irtli71fwll",
	                "nom" : "Light",
	                "url_zxy" : "mapbox_zxy"
				}
			]
        });

        map_arob.CustomIconMarker.setCustomRootPath("themes/sdpweb/js/map_arob/");
        /*if(map_arob.screenshot){
            map_arob.screenshot.init({
                strings : arob_map_langfr
            })
        }*/
        (map_arob.editmap = new editmap(true)).init({
            stylePolygonDefault: {
                color: "#111111",
                weight: 2,
                fillColor: "#111111",
                fillOpacity: 0.2
            },
            styleBackgroundPolygonDefault : {
                color: "#2e6da4",
                weight: 2,
                fillColor: "#049fff",
                fillOpacity: 0.4
            },
            styleLineStringDefault : {
                color: "#FF2600",
                weight: 5
            },
            buttonsEdition : [],
            displayControlBackground : false
        });
        map_arob.editLayerProperties.init({
            "disable" : true,  //masque les boutons d\'�dition de donn�es 
            "allowStyleJsonEdit" :  true
        });
        /*map_arob.screenshot.setNameFile("carto_aliem.png");
        //map_arob.screenshot.imgToDom = function(img){download(img.src, map_arob.screenshot._nameFile );}


        map_arob.screenshot.imgToDom = function(img){}*/

        /* init carto avec les valeurs converties sous forme geojson */
        if (dataset.length > 0) {
            var Buffer = require("buffer").Buffer;
            var wkx = require("wkx");
            var wkbBuffer = null;
            var geometry = null;
            dataset.forEach(function(item){
                wkbBuffer = new Buffer(item.centre, "hex");
                geometry = wkx.Geometry.parse(wkbBuffer);
                item.geometry = geometry.toGeoJSON();
            });
            var mon_geo_json_init = {
                                        "type": "FeatureCollection",
                                        "name" : "Observations trouv�es",
                                        "features": []
                                    };
            dataset.forEach(function(item){
                mon_geo_json_init.features.push({ 
                                                    "type": "Feature",
                                                    "geometry": item.geometry,
                                                    "properties": {
                                                                    "date":item.date,
                                                                    "nombre": item.nombre
                                                                }
                                                });
            });
            map_arob.editmap.SET_backgroundGeojson(mon_geo_json_init);
            var map_bound = map_arob.editmap.BGLayers.getLayers()[map_arob.editmap.BGLayers.getLayers().length - 1].getBounds();
            if (map_bound.isValid()) {
                map_arob.map.fitBounds(map_bound, {"maxZoom" : 15});
            }
            else {
                map_arob.map.panTo(new L.latLng(43.5,7));
                map_arob.map.setZoom(4);
            }
        }
        else {
            map_arob.map.panTo(new L.latLng(43.5,7));
            map_arob.map.setZoom(6);
        }
        map_arob.map.setMinZoom(3);

        /* personnalisation des icones */
        map_arob.map.eachLayer(function (layer) {
            var icon_file = "themes/sdpweb/js/map_arob/map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-green.png"
            if (typeof layer.feature != "undefined") {
                if (typeof layer.feature.properties != "undefined") {
                    var taille_icone = tailleIcone(layer.feature.properties);
                    var new_icon = L.Icon.extend({
                                                   options :{
                                                              iconUrl: icon_file,
                                                              iconSize: taille_icone,
                                                              iconAnchor: ancre_icone(taille_icone)
                                                            }
                                                });
                    layer.setIcon(new new_icon);
                }
            }
        });


        /* regroupement des observations en clusters */
        var markers_grouped = L.markerClusterGroup();
        map_arob.map.eachLayer(function (layer) {
            if (typeof layer.feature != "undefined") {
                markers_grouped.addLayer(layer);
                map_arob.map.removeLayer(layer);//pour �viter d\'avoir des doublons
            }
        });
        map_arob.map.addLayer(markers_grouped);

    });
    function ancre_icone(taille_icone) {
        var y = taille_icone[1];
        var x = Math.floor(taille_icone[0]/2);
        return [x,y];
    }
    function tailleIcone(properties) {
        return [20, 33];
    }
</script>
';
		}
	} 
	else {
		$sortie .= '
<div class="container">
	<div class="row">
		<div class="grid_12">
			<p>'._MESSAGE_PAGE_NOTAVALAIBLE.'</p>
		</div>
	</div>
</div>';
	}
	global $sop;
	/*if ($sop == "viewarticlenotheme") {
	    $btn_retour = "";
	}*/
	$sortie .= $btn_retour;
	
?>