//arobase platform
if (typeof map_arob == "undefined") {
    map_arob = {
        map : L.map("map", {
          center: [42, 9],
          zoom:10,
          zoomSnap : 0.1,
          preferCanvas : true
        }),
      __credits: "arobase.fr",
      layerControl : null,
      langue : "fr"
    };
}
(function () {
  function layer_tile() {    

    /**
     * Ajoute un type de tuile provenant de mapbox
     * Identifiant carte mapbox 
     * Nom affiché à l'écran
     * @param {string} tileName 
     * @param {string} tileDisplayName 
     */
    this.pushTile = function(tileName, tileDisplayName){
      var t = L.tileLayer(this.mbUrl, {
          id: tileName,
          attribution: this.mbAttr_mapbox_osm,
          noWrap: true
      });

      var canpush = true;
      for(var i = 0, len = map_arob.layer_tile.listTile.length; i < len ; i++){
          if(map_arob.layer_tile.listTile[i].options.id == tileName){
              canpush = false;
          }
      }
      if(canpush){
          map_arob.layer_tile.listTile.push(t);
          map_arob.layerControl.addBaseLayer(map_arob.layer_tile.listTile[(map_arob.layer_tile.listTile.length - 1)], tileDisplayName, {collapsed: false});
      }
    };
    this.listTile = [];

    this.init = function(o) {
      /**
       * License pour satelite OpenStreetMap
       */
      this.mbAttr_mapbox_osm =
        'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, ' +
        '<a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, ' +
        'Imagery &copy; <a href="https://www.mapbox.com/">Mapbox</a>';

      /**
       * URL Satellite OpenStreetMap
       */
      this.mbUrl = o.mburl;      


      this.baseLayers = {};

      if(typeof o.tiles == "undefined"){
        o["tiles"] = [
        	{
                id : "openstreetmap",
                nom : "openstreetmap",
                url_zxy : "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
                attribution : "&copy; <a href='https://www.openstreetmap.org/copyright'>OpenStreetMap</a> contributors"
			},
        	{
				id : "arobase_BDORTHO",
				nom : "BD-ORTHO corse",
				url_zxy : "https://bdortho.arobase.corsica/corsica/{z}/{x}/{y}.jpg",
				attribution : "Carte BD-ORTHO _ arobase.fr"
			},
			{
				id : "opentopomap",
				nom : "opentopomap",
				url_zxy : "https://c.tile.opentopomap.org/{z}/{x}/{y}.png",
				attribution : "© OpenStreetMap contributors, SRTM | map style: © OpenTopoMap (CC-BY-SA)"
			}
        ];
      }
      for(var i = 0; i < o.tiles.length; i++){
        if(o.tiles[i].url_zxy == "mapbox_zxy"){
          // Source mapbox
          this.baseLayers[o.tiles[i].nom] = L.tileLayer(this.mbUrl, {
            id: o.tiles[i].id,
            tileSize: 512,
        	maxZoom: 20,
        	zoomOffset: -1,
            attribution: this.mbAttr_mapbox_osm,
            noWrap: true
          });

          map_arob.layer_tile.listTile.push(this.baseLayers[o.tiles[i].nom]);

        }else{            
          // Autre source
          this.baseLayers[o.tiles[i].nom] =  L.tileLayer.fallback(o.tiles[i].url_zxy, {
            id: o.tiles[i].id ,position:"bottomleft", attribution: o.tiles[i].attribution, noWrap: true});
          
            map_arob.layer_tile.listTile.push(this.baseLayers[o.tiles[i].nom]);
        }
      }

      map_arob.layerControl = L.control.layers(this.baseLayers).addTo(map_arob.map);
      if(typeof o.tileDefault != "undefined"){
        var f = false;
        for(var i = 0; i < o.tiles.length; i++){
          if(o.tiles[i].id == o.tileDefault){
            map_arob.map.addLayer(map_arob.layer_tile.listTile[i]);
            f = true;
          }
        }
        if(!f){
          map_arob.map.addLayer(map_arob.layer_tile.listTile[0]);
          console.error("id fond cartho inconnu");
        }
        
      }else{
        map_arob.map.addLayer(map_arob.layer_tile.listTile[0]);
      }

      
      
    };
  }
  map_arob.layer_tile = new layer_tile();
  
  
})();