
(function () {
	/**
	 * Module pour la création de screenshot (LeafletImage), génère un bouton caméra (EasyButton)
	 * Functions redéfinissables (imgToDom, clickScreenshot);
	 */
    function Screenshot(){
		var _this = this;
		
		/**
		 * Fichier de langue du module
		 */
        this._strings = {
            fr : {
            	titlePrendrePhoto : "Prendre une photo",
				telecharger : "Télécharger la capture"
            }
		};

		/**
		 * 
		 * @param {string} s retourne un label dans la langue courrante (map_arob.langue) 
		 */
        this.getString = function(s){
            return _this._strings[map_arob.langue][s];
		};
		
		/**
		 * Liste des layersGroups, utilisée pour leur desactivation disableEdit
		 */
		this.editableLayers = null;

		/**
		 * Désactive le mode edition des "editableLayers" afin de pouvoir screenshot sinon bug
		 */
		this.disableEdit = function(){
			if(_this.editableLayers != null){
				for(var i=0, l = _this.editableLayers.length; i < l; i++){
					_this.editableLayers[i].getLayers().forEach(function(l){        
						l.disableEdit();
					});
				}
			}
		}

		this._nameFile = "screenshot_map";

		/**
		 * Fonction appelé une fois que l'img est generée.
		 * Ne pas oublier d'unBind l'evenement click sur map_arobscreenshotdownload
		 * @param {img} img 
		 */
		this.imgToDom = function(img){
			if($("#map_arobscreenshot").length == 0){
				$("body").append("<div id='map_arobscreenshot_popup'><div id='map_arobscreenshot'></div></div>");
			}
			
			$("#map_arobscreenshot").html(img);
			$("#map_arobscreenshot").append("<button id='map_arobscreenshotdownload'>"+_this.getString("telecharger")+"</button>");

			$("#map_arobscreenshotdownload").click(function(){
				download(img.src, _this._nameFile );
			})
		}
		/**
		 * Remplace le nom du fichier par défaut qui sera généré au click sur le bouton telechargement. 
		 * @param {string} nameFile 
		 */
		this.setNameFile = function(nameFile){
			_this._nameFile = nameFile;
		}

		this.clickScreenshot = function(){
			_this.disableEdit();
			map_arob.map.setZoom(Math.round(map_arob.map.getZoom()), {animate:false});
			leafletImage(map_arob.map, function(err, canvas) {
				// now you have canvas
				// example thing to do with that canvas:
				var img = document.createElement('img');
				img.src = canvas.toDataURL();	
				_this.imgToDom(img);
			});
		}

		/**
		 * Genere le bouton grâce à la plugin leaflet easyButton
		 * Desactive le mode edition
		 * Met un niveau de zoom arrondie (niveau de zoom décimal fait bugger le screenshot)
		 * Genere l'image en jpg
		 * Insert l'image dans la div avec l'id #map_arobscreenshot
		 * Div composé d'un bouton pour telecharger l'image.
		 */
        this.private = function(){
			L.easyButton( 
				'<span class="screenshot"></span>', 
				_this.clickScreenshot, _this.getString("titlePrendrePhoto")
            ).addTo(map_arob.map);
		}
		this.init = function(options){
			if (typeof options == "object") {
				if(typeof options.strings == "object"){
					for (var k in options.strings){
					  for(var kk in options.strings[k]){
						_this._strings[k][kk] = options.strings[k][kk];
					  };
					}
				  }
			}
			_this.private();
		}
    }

    map_arob.screenshot = new Screenshot();
})();

