(function () {
    /**
     * Necessite le plugin leaflet fullscreen
     * Ce plugin ajoute un bouton toggle fullscreen aux controls de la map
     * @constructor
     */
    function editLayerProperties(){
        /**
         * Init le plugin, ajoute Fullscreen aux controls de la map
         */

        this._layerid = null;
        this._l = null;
        this._isEditionFromUI = false;

        this._template = '\
            <div id="layerPropertiesArobControl"  class="leaflet-control editmap" style="display:none">\
                <div style="text-align: center; max-height: 300px;overflow: auto;">\
                    <div>\
                    <b><i class="fa fa-database" style="padding-top: 3px;" aria-hidden="true"></i>&nbsp;&nbsp;Donnée(s) Attributaire(s)</b>\
                    </div>\
                </div>\
                <div class="zoneButton">\
                    <button type="button" class="btn btn-default btn-xs _toggleEdit" indexfeature="0" style="margin-right: 5px;"><i class="fa fa-pencil-square" aria-hidden="true"></i>&nbsp;Modifier</button>\
                    <button type="button" class="btn btn-default btn-xs _add" indexfeature="0"><i class="fa fa-plus-square" aria-hidden="true"></i>&nbsp;Ajouter propriété</button>\
                    <button type="button" class="btn btn-xs btn-primary _save" style="float:right"><i class="fa fa-floppy-o" aria-hidden="true"></i>&nbsp;Valider</button>&nbsp;\
                    <button type="button" class="btn btn-xs btn-danger _cancel" style="float:right;margin-right: 5px;"><i class="fa fa-window-close" aria-hidden="true"></i>&nbspFermer</button>\
                    <div style="clear:both"></div>\
                </div>\
                <div style="max-height: 423px;overflow-y: auto;">\
                    <table id="tableProperties" class="table">\
                        <thead>\
                            <tr>\
                                <th scope="col" width="30%">Nom</th>\
                                <th scope="col" >Valeur</th>\
                                <th scope="col" width="30px"></th>\
                            </tr>\
                        </thead>\
                        <tbody>\
                        </tbody>\
                    </table>\
                </div>\
            </div>';

        this.isEditingTheLayers = function(e){
            console.log(e);
        }
        
        this._isEditingTheLayers = function(){
            var a = false;
            if(map_arob.editLayerProperties._layerid != null){
                a = true;
            }
            this.isEditingTheLayers(a);
        }
        
        this._addRowToTableProperties = function(key, value, disabled){

            
            var self = map_arob.editLayerProperties;

            var valueCleaned = value;
            if(typeof value == "object"){
                valueCleaned = JSON.stringify(value);
            }            

            var tr = $('<tr>');

            
            var input1 = $('<input>').attr('type', 'text').val(key);
            var td1 = $('<td>').attr('scope', 'row').attr('width', '30%').append();
            

            var input2 = $('<input>').attr('type', 'text').val(valueCleaned);
            var td2 = $('<td>').attr('scope', 'row').css('padding-right', '0px');

            var td3 = $('<td>').attr('scope', 'row').attr('width', '30px').css('padding-right', '0px');;
            td3.html('<button title="Supprimer la propriété" type="button" class="btn btn-danger btn-xs  _deleteProp" currentKey="'+key+'" style="outline: none;"><i class="fa fa-trash-o fa-fw" aria-hidden="true"></i></button>')
            if(disabled){
                input1.attr('disabled', true);
                input2.attr('disabled', true);
            }

            if(key === "style" && !self._options.allowStyleJsonEdit){
               return;
            }

            td1.append(input1);
            td2.append(input2);

            // 

            tr.append(td1, td2, td3);
            $("#layerPropertiesArobControl #tableProperties tbody").append(tr);
            
            /*$("#layerPropertiesArobControl #tableProperties tbody").append(
                '<tr>\
                    <td scope="row" width="30%">  <input type="text" value="'+key+'"> </td>\
                    <td scope="row" width="70%">  <input type="text" value="'+valueCleaned+'"> </td>\
                </tr>'
            )*/
        }

        this._deleteRow = function(){
            var parent = $(this).parents('tr');
            if(confirm("Êtes-vous sur de vouloir supprimer cette propriété : "+parent.find('input').val())){
                $(this).parents('tr').remove();
            }
        }

        /**
         * Affiche l'interface d'edition des proprietés d'un layer
         * @param {int} idLayer identifiant du layer la map 
         */
        this.openLayerProperties = function(_leaflet_id){
            var self =  map_arob.editLayerProperties;
            var l = map_arob.editmap.theLayers.getLayer(_leaflet_id);
            if(typeof l == "undefined"){
              //c'est un newlayer
              var l = map_arob.editmap.newLayers.getLayer(_leaflet_id);
            }

            if(typeof l != "undefined"){
                if(typeof l.feature != "undefined"){
                    if(typeof l.feature.properties != "undefined"){
                        // On reset l\'ancien layer 
                        $("#layerPropertiesArobControl #tableProperties tbody").html("");
                        self._layerid = _leaflet_id;
                        self._l = l;
                        self._isEditionFromUI = false;
                        $.each(l.feature.properties, function(key, value){
                            map_arob.editLayerProperties._addRowToTableProperties(key, value, true);
                        });
                        map_arob.editmap.hideRowsLeaftletControlEditmap();
                        $("#layerPropertiesArobControl").show();
                    }else{
                        self._l = null;
                        tgus._layerid = null;
                    }
                } 
            }
            $("#layerPropertiesArobControl ._deleteProp").on('click',map_arob.editLayerProperties._deleteRow);
            map_arob.editLayerProperties._isEditingTheLayers();     
        }

        this.openLayerPropertiesFromObject = function(id, feature){
            var self =  map_arob.editLayerProperties;
            $("#layerPropertiesArobControl #tableProperties tbody").html("");
            self._layerid = id;
            self._l ={"feature" : feature};
            self._isEditionFromUI = true;
            $.each(self._l.feature.properties, function(key, value){
                map_arob.editLayerProperties._addRowToTableProperties(key, value, true);
            });
            map_arob.editmap.hideRowsLeaftletControlEditmap();
            $("#layerPropertiesArobControl").show();
        }

        this._toggleEdit = function(){
            

            if(!jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing")){
                $("#tableProperties input").each(function(){
                    $(this).removeAttr("disabled")
                })
            }else{
                $("#tableProperties input").each(function(){
                    $(this).attr("disabled", "true");
                })
            }

            jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing", !jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing"))
        }

        this._saveCurrent = function(){
            var self =  map_arob.editLayerProperties;
            function checkValues(inputJQ){
                if(inputJQ.val() === ""){
                    inputJQ.css('border-color', '#dc3545');
                    return false;
                }else{
                    inputJQ.css('border-color', '')
                    return true;
                }
            }

            var properties = [];
            var error = false;
            $("#tableProperties tr input").each(function(){
                if(!checkValues($(this))){
                    error = true;
                };
                var lastCouple = properties[properties.length - 1];
                if(typeof lastCouple == "undefined"){  // premier couple                  
                    properties.push([$(this).val()]);
                }else
                if(lastCouple.length === 2){  // nouveau couple
                    properties.push([$(this).val()]);
                }else
                if(lastCouple.length === 1){ // ajout deuxieme valeur au couple
                    lastCouple.push($(this).val());
                }
            })

            function save(){

                var style = null;
                //supprime toutes les anciennes sauf style 
                if(typeof self._l.feature.properties.style !="undefined"){
                    style = self._l.feature.properties.style;
                }
                self._l.feature.properties = {};
                if(style != null){
                    self._l.feature.properties["style"] = style;
                }                



                for(var i = 0, l = properties.length; i < l ; i++){
                    if(properties[i][0] != ""){
                        if(typeof properties[i][1] != "undefined"){
                            if(typeof properties[i][1] != null){                                
                                self._l.feature.properties[properties[i][0]] = properties[i][1];
                            }
                        }
                    }
                }

                if(self._isEditionFromUI){
                    UImap_arob.Editmap.refreshMap(map_arob.editLayerProperties._layerid);
                    self.openLayerPropertiesFromObject(map_arob.editLayerProperties._layerid, map_arob.editLayerProperties._l.feature);
                }else{
                    self.openLayerProperties(self._layerid);
                }
                
                
            }

            setTimeout(function(){
                if(error){
                    if(window.confirm("Certains champs des données attributaire sont vides, êtes-vous sur de vouloir sauvegarder ? ")){
                        save();
                        jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing", false);
                    }
                }else{
                    save()
                    jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing", false);
                }
            },50)
            
        }

        this.cancel = function(){
            $("#layerPropertiesArobControl").hide();
            this._layerid = null;
            this._l = null;
            map_arob.editLayerProperties._isEditingTheLayers();
            jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing", false);
        }
        
        this.private = function(){
            var mmap = map_arob.map;    
            $(".leaflet-top.leaflet-right").append(this._template);
            
            var info = document.getElementById("layerPropertiesArobControl");
            // Disable dragging when user's cursor enters the element
            info.addEventListener('mouseover', function () {
                mmap.dragging.disable();
                map_arob.map.scrollWheelZoom.disable()
                map_arob.map.doubleClickZoom.disable()
            });

            // Re-enable dragging when user's cursor leaves the element
            info.addEventListener('mouseout', function () {
                mmap.dragging.enable();
                map_arob.map.scrollWheelZoom.enable()
                map_arob.map.doubleClickZoom.enable()
            });
            jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing", false);
            $("#layerPropertiesArobControl ._toggleEdit").click(this._toggleEdit);
            $("#layerPropertiesArobControl ._save").click(this._saveCurrent);
            $("#layerPropertiesArobControl ._cancel").click(function(){
                map_arob.editLayerProperties.cancel();
            });

            
            $("#layerPropertiesArobControl ._add").click(function(){                
                if(!jQuery.data($("#layerPropertiesArobControl ._toggleEdit")[0], "editing")){
                    return;
                }
                map_arob.editLayerProperties._addRowToTableProperties("","", false);
            });
            

            
        }

        this._options = {
            "disable" : false,
            "allowStyleJsonEdit" : false,
        }

        function init(options){
            $.each(options, function(key, value){
                var self = map_arob.editLayerProperties;
                if(self._options[key] != "undefined"){
                    if(typeof self._options[key] === typeof value){
                        self._options[key] = value;
                    }                    
                }
            })

            if(this._options.disable){
                var css = '._editionLayerProp, .editionLayerPropInEditMap {display:none !important;}',
                    head = document.head || document.getElementsByTagName('head')[0],
                    style = document.createElement('style');

                    head.appendChild(style);

                    style.type = 'text/css';
                    if (style.styleSheet){
                        style.styleSheet.cssText = css;
                    } else {
                        style.appendChild(document.createTextNode(css));
                    }
            }
        }
        this.init = init;
    }

    map_arob.editLayerProperties = new editLayerProperties();
    map_arob.editLayerProperties.private();
})();

