(function () {
	
    function Proj(){
        var _this = this;
        _this.latlng = null;
        _this.point = null;
        this._strings = {
            fr : {
            	titlePrendrePhoto : "Prendre une photo",
				telecharger : "Télécharger la capture"
            }
		};

		/**
		 * 
		 * @param {string} s retourne un label dans la langue courrante (map_arob.langue) 
		 */
        this.getString = function(s){
            return _this._strings[UImap_arob.langue][s];
        };	

        /**
         * A redefinir dans la page
         */
        this.changed = function(){
          
            UImap_arob.Editmap.updateAjoutPoint(UImap_arob.Proj.latlng[1],UImap_arob.Proj.latlng[0]);
            UImap_arob.Proj.clearForms();
            UImap_arob.Proj.disableForms();
             
        }

          

        function submitDD(event) {
            event.preventDefault();
            var data = $("#UImap_arob_proj_DDFORM :input").serializeArray();
            var proj = $("#UImap_arob_proj_DDFORM_projection").val();
            data[0].value = data[0].value.replace(",", ".");
            data[1].value = data[1].value.replace(",", ".");

            var tabLongLat = [ parseFloat(data[0].value), parseFloat(data[1].value)];
            if(proj == "EPSG:2154"){
                tabLongLat = [ parseFloat(data[1].value), parseFloat(data[0].value)];
            }
            
            _this.latlng = (proj4(proj4(proj), proj4('EPSG:4326'), tabLongLat));

            if(proj == "EPSG:2154"){
                var t0 =  _this.latlng[0];
                var t1 =  _this.latlng[1];
                _this.latlng[0] = t1;
                _this.latlng[1] = t0;
            }

            //var lamb1 = (proj4(proj4(proj), proj4('EPSG:2154'), [ parseFloat(data[0].value), parseFloat(data[1].value)]));
            //var lamb2 = (proj4(proj4(proj), proj4('EPSG:2154'), [ parseFloat(data[1].value), parseFloat(data[0].value)]));
            
            _this.latlng[0] = parseFloat(_this.latlng[0].toFixed(8))
            _this.latlng[1] = parseFloat(_this.latlng[1].toFixed(8))            

            var latDMS = lonlat_to_decimal.ConvertDDToDMS(_this.latlng[0], false);
            var longDMS = lonlat_to_decimal.ConvertDDToDMS(_this.latlng[1], true);

            $("input[name='latnordsud'][value='"+latDMS.dir+"']").prop('checked', true);
            $("#latitude_degres").val(latDMS.deg);
            $("#latitude_minutes").val(latDMS.min);
            $("#latitude_secondes").val(latDMS.sec);

            $("input[name='lngestouest'][value='"+longDMS.dir+"']").prop('checked', true);
            $("#longitude_degres").val(longDMS.deg);
            $("#longitude_minutes").val(longDMS.min);
            $("#longitude_secondes").val(longDMS.sec);

            if(_this.point != null){
                //Le point est une référence du point dans la linestring
                _this.point.setLatitude(_this.latlng[0]);
                _this.point.setLongitude(_this.latlng[1]);
            }

            
            _this.changed();
           
        }

        function submitDMS(event){
            event.preventDefault();
            var d = $("#UImap_arob_proj_DMSFORM :input").serializeArray();
            
            var lat = lonlat_to_decimal.ConvertDMSToDD(d[1].value, d[2].value, d[3].value, d[0].value);
            var lon = lonlat_to_decimal.ConvertDMSToDD(d[5].value, d[6].value, d[7].value, d[4].value);

            $("#UImap_arob_proj_DDFORM #latitude").val(lat);
            $("#UImap_arob_proj_DDFORM #longitude").val(lon);
            $("#UImap_arob_proj_DDFORM").submit();

        }

        function V_reducedDMS(event){
            if($("#UImap_arob_proj_DMSFORM").hasClass("reduced")){
                $("#UImap_arob_proj_DMSFORM").removeClass("reduced");

                $("form#UImap_arob_proj_DMSFORM h4 i").removeClass("fa-chevron-circle-down");
                $("form#UImap_arob_proj_DMSFORM h4 i").addClass("fa-chevron-circle-up")
            }else{
                $("#UImap_arob_proj_DMSFORM").addClass("reduced");
                $("form#UImap_arob_proj_DMSFORM h4 i").removeClass("fa-chevron-circle-up");
                $("form#UImap_arob_proj_DMSFORM h4 i").addClass("fa-chevron-circle-down");
            }
        }

        this.clearForms = function(){
            _this.point = null;
            $("#UImap_arob_proj_DDFORM #latitude").val("");
            $("#UImap_arob_proj_DDFORM #longitude").val("");
            
            $("#UImap_arob_proj_DMSFORM #latitude_degres").val("");
            $("#UImap_arob_proj_DMSFORM #latitude_minutes").val("");
            $("#UImap_arob_proj_DMSFORM #latitude_secondes").val("");

            $("#UImap_arob_proj_DMSFORM #longitude_degres").val("");
            $("#UImap_arob_proj_DMSFORM #longitude_minutes").val("");
            $("#UImap_arob_proj_DMSFORM #longitude_secondes").val("");
        }

        this.enableForms = function(){
            $("#UImap_arob_proj input, #UImap_arob_proj select, #UImap_arob_proj button").each(function(){
                $(this).removeAttr("disabled")
            });
            $("#UImap_arob_proj").show();
        }

        this.setLatLng = function(lat, lon){
            $("#UImap_arob_proj_DDFORM #latitude").val(lat);
            $("#UImap_arob_proj_DDFORM #longitude").val(lon);


            var DMSLAT = lonlat_to_decimal.ConvertDDToDMS(lat, false); 
            var DMSLONG = lonlat_to_decimal.ConvertDDToDMS(lon, true); 

            $("input[name='latnordsud'][value='"+DMSLAT.dir+"']").prop('checked', true);
            $("#latitude_degres").val(DMSLAT.deg);
            $("#latitude_minutes").val(DMSLAT.min);
            $("#latitude_secondes").val(DMSLAT.sec);

            $("input[name='lngestouest'][value='"+DMSLONG.dir+"']").prop('checked', true);
            $("#longitude_degres").val(DMSLONG.deg);
            $("#longitude_minutes").val(DMSLONG.min);
            $("#longitude_secondes").val(DMSLONG.sec);
        }

        this.disableForms = function(){
            $("#UImap_arob_proj input, #UImap_arob_proj select, #UImap_arob_proj button").each(function(){
                $(this).attr("disabled", "")
            })

            $("#UImap_arob_proj").hide();
           
        }
        
        this.private = function(){
            $("body").on("submit", "#UImap_arob_proj_DDFORM", submitDD);
            $("body").on("submit", "#UImap_arob_proj_DMSFORM", submitDMS);
            $("body").on("click", "form#UImap_arob_proj_DMSFORM h4", V_reducedDMS);
        }
		       
    }

    UImap_arob.Proj = new Proj();
    UImap_arob.Proj.private();
})();