<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* Enhanced with NukeStats Module Version 1.0                           */
/* ==========================================                           */
/* Copyright 2002 by Harry Mangindaan (sens@indosat.net) and           */
/*                    Sudirman (sudirman@akademika.net)                 */
/* http://www.nuketest.com                                              */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }


/************************** Onglet definition ***********************/
		$ongletDef=array("Main"=> array( "text"=>"Basic",
                                   "url"=>"system.php?op=StatsMain"),
						 "Advanced"=> array( "text"=>"Avanced",
                                   "url"=>"system.php?op=Stats")
                                   );


require_once("core/becms_mainlib_lib.php");
include("includes/jpgraph/jpgraph.php");
include("includes/jpgraph/jpgraph_bar.php");
include("includes/jpgraph/jpgraph_pie.php");
include("includes/jpgraph/jpgraph_pie3d.php");
setPath(_TXT_System,0);
setPath(_STATISTICS,1);
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$pagetitle = "- "._STATS."";


 $ThemeSel = "System";


$now = date("d-m-Y");
$dot = explode ("-",$now);
$nowdate = $dot[0];
$nowmonth = $dot[1];
$nowyear = $dot[2];

/**
 * Stats_Main()
 * Display main page stats
 */
function Stats_Main() {
    global $prefix, $db, $startdate, $sitename, $ThemeSel, $user_prefix, $Version_Num, $ongletDef;
    include("system/header_system.php");
	GraphicAdmin("$sitename "._STATS."");
    $result = $db->sql_query("select type, var, count from ".$prefix."_counter order by type desc");
    while(list($type, $var, $count) = $db->sql_fetchrow($result)) {
	if(($type == "total") && ($var == "hits")) {
		$total = $count;
	} elseif($type == "browser") {
		if($var == "Netscape") {
			$netscape[] = $count;
			$netscape[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "MSIE") {
			$msie[] = $count;
			$msie[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Konqueror") {
			$konqueror[] = $count;
			$konqueror[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Opera") {
			$opera[] = $count;
			$opera[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Lynx") {
			$lynx[] = $count;
			$lynx[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Bot") {
			$bot[] = $count;
			$bot[] =  substr(100 * $count / $total, 0, 5);
		} elseif(($type == "browser") && ($var == "Other")) {
			$b_other[] = $count;
			$b_other[] =  substr(100 * $count / $total, 0, 5);
		}
	} elseif($type == "os") {
		if($var == "Windows") {
			$windows[] = $count;
			$windows[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Mac") {
			$mac[] = $count;
			$mac[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "Linux") {
			$linux[] = $count;
			$linux[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "FreeBSD") {
			$freebsd[] = $count;
			$freebsd[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "SunOS") {
			$sunos[] = $count;
			$sunos[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "IRIX") {
			$irix[] = $count;
			$irix[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "BeOS") {
			$beos[] = $count;
			$beos[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "OS/2") {
			$os2[] = $count;
			$os2[] =  substr(100 * $count / $total, 0, 5);
		} elseif($var == "AIX") {
			$aix[] = $count;
			$aix[] =  substr(100 * $count / $total, 0, 5);
		} elseif(($type == "os") && ($var == "Other")) {
			$os_other[] = $count;
			$os_other[] =  substr(100 * $count / $total, 0, 5);
		}
	}
    }
    $db->sql_freeresult($result);
    
    OpenOngletTable();
   
	echo "<table class=lisTable><tr align=\"right\"><td>";
	displayOngletBar("Main",$sitename._STATS, $ongletDef);

	echo " "._WERECEIVED." <b>$total</b> "._PAGESVIEWS." $startdate<br>";
   
    $l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
    $m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
    $r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
    // setting for graph
     $statGraphDef['data']= array ($netscape[0],$msie[0],$konqueror[0],$opera[0],$lynx[0],$bot[0],$b_other[0] );
     $statGraphDef['label']=array ("Internet Explorer","Netscape","Opera","Konqueror (KDE)","Lynx",_SEARCHENGINES,_UNKNOWN);
     $statGraphDef['title']=_BROWSERS;
     setGraphData($statGraphDef,1);
    
    OpenOngletTable();
    echo "<table class=lisTable><tr class=systemTabHeader ><td class=systemTabHeader colspan=\"3\">\n";
    echo "<center>"._BROWSERS."</td></tr>\n";
    echo "<tr><td width=10%><img src=\"images/stats/explorer.gif\" border=\"0\" alt=\"\">&nbsp;MSIE: </td>"
    	."<td>$msie[1] % ($msie[0])</td>"
    	."<td rowspan=10 align=right><img src=\"system.php?op=draw_bar&dataid=1\" border=0> <img src=\"system.php?op=draw_pie&dataid=1\" border=0></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/netscape.gif\" border=\"0\" alt=\"\">&nbsp;Netscape: </td>"
    ."<td>$netscape[1] % ($netscape[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/opera.gif\" border=\"0\" alt=\"\">&nbsp;Opera: </td>"
    ."<td> $opera[1] % ($opera[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/konqueror.gif\" border=\"0\" alt=\"\">&nbsp;Konqueror: </td>"
    ."<td> $konqueror[1] % ($konqueror[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/lynx.gif\" border=\"0\" alt=\"\">&nbsp;Lynx: </td>"
    ."<td> $lynx[1] % ($lynx[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/altavista.gif\" border=\"0\" alt=\"\">&nbsp;"._SEARCHENGINES.": </td>"
    ."<td> $bot[1] % ($bot[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/question.gif\" border=\"0\" alt=\"\">&nbsp;"._UNKNOWN.": </td>"
    ."<td> $b_other[1] % ($b_other[0])\n";
    echo "</td></tr></table>";
    CloseOngletTable();
    echo "<br><br>\n";
    
     $statGraphDef['data']= array ($windows[0],$linux[0],$mac[0],$freebsd[0],$sunos[0],$irix[0],$beos[0],$os2[0],$aix[0],$os_other[0]);
     $statGraphDef['label']=array ("Windows","Linux","Mac/PPC","FreeBSD","SunOS","IRIX","BeOS","OS/2","AIX",_UNKNOWN);
     $statGraphDef['title']=_BROWSERS;
     setGraphData($statGraphDef,2);
   
    OpenOngletTable();
    echo "<table class=lisTable><tr class=systemTabHeader><td class=systemTabHeader colspan=3>\n";
    echo "<center>"._OPERATINGSYS."</center></td></tr>\n";
    echo "<tr><td td width=10%><img src=\"images/stats/windows.gif\" border=\"0\" alt=\"\">&nbsp;Windows:</td>"
    ."<td> $windows[1] % ($windows[0])</td>"
    ."<td rowspan=7 align=right><img src=\"system.php?op=draw_bar&dataid=2\" border=0> <img src=\"system.php?op=draw_pie&dataid=2\" border=0></td></tr>\n";"\n";
    echo "<tr><td><img src=\"images/stats/linux.gif\" border=\"0\" alt=\"\">&nbsp;Linux:</td>"
    ."<td> $linux[1] % ($linux[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/mac.gif\" border=\"0\" alt=\"\">&nbsp;Mac/PPC:</td>"
    ."<td> $mac[1] % ($mac[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/bsd.gif\" border=\"0\" alt=\"\">&nbsp;FreeBSD:</td>"
    ."<td> $freebsd[1] % ($freebsd[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/sun.gif\" border=\"0\" alt=\"\">&nbsp;SunOS:</td>"
    ."<td> $sunos[1] % ($sunos[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/irix.gif\" border=\"0\" alt=\"\">&nbsp;IRIX:</td>"
    ."<td> $irix[1] % ($irix[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/be.gif\" border=\"0\" alt=\"\">&nbsp;BeOS:</td>"
    ."<td> $beos[1] % ($beos[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/os2.gif\" border=\"0\" alt=\"\">&nbsp;OS/2:</td>"
    ."<td> $os2[1] % ($os2[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/aix.gif\" border=\"0\" alt=\"\">&nbsp;AIX:</td>"
    ."<td> $aix[1] % ($aix[0])</td></tr>\n";
    echo "<tr><td><img src=\"images/stats/question.gif\" border=\"0\" alt=\"\">&nbsp;"._UNKNOWN.":</td>"
    ."<td> $os_other[1] % ($os_other[0])\n";
    echo "</td></tr></table>\n";
    CloseOngletTable();

    $unum = $db->sql_numrows($db->sql_query("select * from ".$user_prefix."_users"));
    $anum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_authors" ));
    $snum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_stories" ));
    $cnum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_comments" ));
    $secnum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_sections" ));
    $secanum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_seccont" ));
    $subnum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_queue" ));
    $tnum = $db->sql_numrows($db->sql_query("select * from ".$prefix."_topics" ));
    $links = $db->sql_numrows($db->sql_query("select * from ".$prefix."_links_links" ));
    $cat = $db->sql_numrows($db->sql_query("select * from ".$prefix."_links_categories"));
echo "<br><br>\n";
    OpenOngletTable();
    echo "<table class=lisTable><tr class=systemTabHeader><td class=systemTabHeader colspan=\"2\">\n";
    echo "<center>"._MISCSTATS."</center></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/users.gif\" border=\"0\" alt=\"\">&nbsp;"._REGUSERS."</td><td><b>$unum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/authors.gif\" border=\"0\" alt=\"\">&nbsp;"._ACTIVEAUTHORS."</td><td><b>$anum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/news.gif\" border=\"0\" alt=\"\">&nbsp;"._STORIESPUBLISHED."</td><td><b>$snum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/topics.gif\" border=\"0\" alt=\"\">&nbsp;"._SACTIVETOPICS."</td><td><b>$tnum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/comments.gif\" border=\"0\" alt=\"\">&nbsp;"._COMMENTSPOSTED."</td><td><b>$cnum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/sections.gif\" border=\"0\" alt=\"\">&nbsp;"._SSPECIALSECT."</td><td><b>$secnum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/articles.gif\" border=\"0\" alt=\"\">&nbsp;"._ARTICLESSEC."</td><td><b>$secanum</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/topics.gif\" border=\"0\" alt=\"\">&nbsp;"._LINKSINLINKS."</td><td><b>$links</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/sections.gif\" border=\"0\" alt=\"\">&nbsp;"._LINKSCAT."</td><td><b>$cat</b></td></tr>\n";
    echo "<tr><td><img src=\"images/stats/waiting.gif\" border=\"0\" alt=\"\">&nbsp;"._NEWSWAITING."</td><td><b>$subnum</b></td></tr>\n";

    /* Do not Remove the following line! */
    echo "<tr><td><img src=\"images/stats/sections.gif\" border=\"0\" alt=\"\">&nbsp;"._BECMSVERSION."</td><td><b>$Version_Num</b>\n";

    echo "</td></tr></table>\n";
	echo "</td></tr></table>";
    CloseOngletTable();
    CloseOngletTable();

    include("system/footer_system.php");
}

function Stats($total) {
    global $hlpfile,$nowyear,$nowmonth,$nowdate,$nowhour, $sitename, $startdate, $prefix, $db, $now, $ongletDef;
    $result = $db->sql_query("select count from ".$prefix."_counter order by type desc");
    list($total) = $db->sql_fetchrow($result);
    include("system/header_system.php");
	GraphicAdmin("$sitename "._STATS."");

    OpenOngletTable();
    displayOngletBar("Advanced",$sitename._STATS, $ongletDef);

    echo "<table class=lisTable ><tr align=\"right\"><td>";

    echo " "._WERECEIVED." <b>$total</b> "._PAGESVIEWS." $startdate<br>"._TODAYIS.": $now[0]/$now[1]/$now[2]<br><br>";

    $result = $db->sql_query("select year, month, hits from ".$prefix."_stats_month order by hits DESC limit 0,1");
    list($year, $month, $hits) = $db->sql_fetchrow($result);
    if ($month == 1) {$month = _JANUARY;} elseif ($month == 2) {$month = _FEBRUARY;} elseif ($month == 3) {$month = _MARCH;} elseif ($month == 4) {$month = _APRIL;} elseif ($month == 5) {$month = _MAY;} elseif ($month == 6) {$month = _JUNE;} elseif ($month == 7) {$month = _JULY;} elseif ($month == 8) {$month = _AUGUST;} elseif ($month == 9) {$month = _OCTOBER;} elseif ($month == 10) {$month = _SEPTEMBER;} elseif ($month == 11) {$month = _NOVEMBER;} elseif ($month == 12) {$month = _DECEMBER;}
    echo ""._MOSTMONTH.": $month $year ($hits "._HITS.")<br>";

    $result = $db->sql_query("select year, month, date, hits from ".$prefix."_stats_date order by hits DESC limit 0,1");
    list($year, $month, $date, $hits) = $db->sql_fetchrow($result);
    if ($month == 1) {$month = _JANUARY;} elseif ($month == 2) {$month = _FEBRUARY;} elseif ($month == 3) {$month = _MARCH;} elseif ($month == 4) {$month = _APRIL;} elseif ($month == 5) {$month = _MAY;} elseif ($month == 6) {$month = _JUNE;} elseif ($month == 7) {$month = _JULY;} elseif ($month == 8) {$month = _AUGUST;} elseif ($month == 9) {$month = _OCTOBER;} elseif ($month == 10) {$month = _SEPTEMBER;} elseif ($month == 11) {$month = _NOVEMBER;} elseif ($month == 12) {$month = _DECEMBER;}
    echo ""._MOSTDAY.": $date $month $year ($hits "._HITS.")<br>";

    $result = $db->sql_query("select year, month, date, hour, hits from ".$prefix."_stats_hour order by hits DESC limit 0,1");
    list($year, $month, $date, $hour, $hits) = $db->sql_fetchrow($result);
    if ($month == 1) {$month = _JANUARY;} elseif ($month == 2) {$month = _FEBRUARY;} elseif ($month == 3) {$month = _MARCH;} elseif ($month == 4) {$month = _APRIL;} elseif ($month == 5) {$month = _MAY;} elseif ($month == 6) {$month = _JUNE;} elseif ($month == 7) {$month = _JULY;} elseif ($month == 8) {$month = _AUGUST;} elseif ($month == 9) {$month = _OCTOBER;} elseif ($month == 10) {$month = _SEPTEMBER;} elseif ($month == 11) {$month = _NOVEMBER;} elseif ($month == 12) {$month = _DECEMBER;}
    if ($hour < 10) {
	$hour = "0$hour:00 - 0$hour:59";
    } else {
	$hour = "$hour:00 - $hour:59";
    }
    echo ""._MOSTHOUR.": $hour "._ON." $month $date, $year ($hits "._HITS.")<br><br>";

    OpenOngletTable();
    showYearStats($nowyear);
    echo "<BR><BR>";
    showMonthStats($nowyear,$nowmonth);
    echo "<BR><BR>";
    showDailyStats($nowyear,$nowmonth,$nowdate);
    echo "<BR><BR>";
    showHourlyStats($nowyear,$nowmonth,$nowdate);
    echo "<br><br><center>"._GOBACK."</center><br><br>";
    CloseOngletTable();
    echo "</td></tr></table>";
    closeOngletTable();
    include ("footer.php");
}

function YearlyStats($year){
    global $hlpfile,$nowyear,$nowmonth,$nowdate, $sitename;
    include("system/header_system.php");
	GraphicAdmin("$sitename "._STATS."");
    title("$sitename "._STATS."");
    openSystable();
    showMonthStats($year,$nowmonth);
    echo "<BR>";
    echo "<center>[ <a href=\"system.php?op=StatsMain\">"._BACKTOMAIN."</a> | <a href=\"modules.php?name=Statistics&amp;op=Stats\">"._BACKTODETSTATS."</a> ]</center>";
    closeSystable();
    include ("footer.php");
}

function MonthlyStats($year,$month){
    global $sitename;
    include("system/header_system.php");
	GraphicAdmin("$sitename "._STATS."");
    title("$sitename "._STATS."");
    openSystable();
    showDailyStats($year,$month,$nowdate);
    echo "<BR>";
    echo "<center>[ <a href=\"system.php?op=StatsMain\">"._BACKTOMAIN."</a> | <a href=\"modules.php?name=Statistics&amp;op=Stats\">"._BACKTODETSTATS."</a> ]</center>";
    closeSystable();
    include ("footer.php");
}

function DailyStats($year,$month,$date){
    global $sitename;
    include("system/header_system.php");
	GraphicAdmin("$sitename "._STATS."");
    title("$sitename "._STATS."");
    openSystable();
    showHourlyStats($year,$month,$date);
    echo "<BR>";
    echo "<center>[ <a href=\"system.php?op=StatsMain\">"._BACKTOMAIN."</a> | <a href=\"modules.php?name=Statistics&amp;op=Stats\">"._BACKTODETSTATS."</a> ]</center>";
    closeSystable();
    include ("footer.php");
}


function showYearStats($nowyear){
    global $db,$prefix,$bgcolor1,$bgcolor2,$bgcolor2, $ThemeSel;
    $l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
    $m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
    $r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
    $resulttotal = $db->sql_query("select sum(hits) as TotalHitsYear from ".$prefix."_stats_year");
    list($TotalHitsYear) = $db->sql_fetchrow($resulttotal);
    $db->sql_freeresult($resulttotal);
    $result = $db->sql_query("select year,hits from ".$prefix."_stats_year order by year");
    echo "<center><b>"._YEARLYSTATS."</b></center><br>";
    echo "<table align=\"center\" bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"3\" border=\"0\">";
    echo "<tr><td width=\"25%\" class=systemTabHeader>"._YEAR."</td><td class=systemTabHeader>"._SPAGESVIEWS."</td></tr>";
    while (list($year,$hits) = $db->sql_fetchrow($result)){
	echo "<tr class=listTableNone><td>";
	if ($year != $nowyear) {
	    echo "<a href=\"system.php?op=YearlyStats&amp;year=$year\">$year</a>";
	} else {
	    echo "$year";
	}
	echo "</td><td>";
	$WidthIMG = round(100 * $hits/$TotalHitsYear,0);
	echo "<img src=\"themes/$ThemeSel/images/leftbar.gif\" Alt=\"\" width=\"$l_size[0]\" height=\"$l_size[1]\"><img src=\"themes/$ThemeSel/images/mainbar.gif\" height=\"$m_size[1]\" width=",$WidthIMG * 2," Alt=\"\">"
	    ."<img src=\"themes/$ThemeSel/images/rightbar.gif\" Alt=\"\" width=\"$r_size[0]\" height=\"$r_size[1]\"> ($hits)</td></tr>";
    }
    $db->sql_freeresult($result);
    echo "</table>";
}
/**
 * showMonthStats()
 * 
 */
function showMonthStats($nowyear,$nowmonth){
    global $prefix,$db, $ThemeSel;
    $resultmonth = $db->sql_query("select sum(hits) as TotalHitsMonth from ".$prefix."_stats_month where year='$nowyear'");
    list($TotalHitsMonth) = $db->sql_fetchrow($resultmonth);
    $db->sql_freeresult($resultmonth);
    $result = $db->sql_query("select month,hits from ".$prefix."_stats_month where year='$nowyear'");
    echo "<center><b>"._MONTLYSTATS." $nowyear</b></center><br>";
    echo "<table align=center cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr><td>";
    // result table
    echo "<table bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\">";
    echo "<tr><td class=systemTabHeader>"._UMONTH."</td><td class=systemTabHeader>"._SPAGESVIEWS."</td></tr>";
    $count=0;
    while (list($month,$hits) = $db->sql_fetchrow($result)){
		$statGraphDef['data'][$count]= $hits;     
     	$statGraphDef['label'][$count]= getmonth($month,0);
     	$statGraphDef['title']=_MONTLYSTATS." ".$nowyear;
    	$count++; 
		echo "<tr class=listTableNone><td>";
		if ($month != $nowmonth) {
	    	echo "<a href=\"system.php?&amp;op=MonthlyStats&amp;year=$nowyear&amp;month=$month\" class=\"hover_orange\">";
	    	getmonth($month);
	    	echo "</a>";
		} else {
	    	getmonth($month);
		}
		echo "</td><td align=center > $hits</td></tr>";
		echo "</td></tr>";
    	}
    	 echo "</table>";
    $db->sql_freeresult($result);
    echo "</td><td>";
    // graph    
     setGraphData($statGraphDef,1); 
     echo "<table><tr><td rowspan=10 align=right><img src=\"system.php?op=draw_bar&dataid=1\" border=0><img src=\"system.php?op=draw_pie&dataid=1\" border=0></td></tr></table>\n";
     echo "</td></tr></table>";
}
/**
 * showDailyStats()
 * 
 */
function showDailyStats($year,$month,$nowdate){
    global $prefix,$db, $ThemeSel;
    $resulttotal = $db->sql_query("select sum(hits) as TotalHitsDate from ".$prefix."_stats_date where year='$year' and month='$month'");
    list($TotalHitsDate) = $db->sql_fetchrow($resulttotal);
    $db->sql_freeresult($resulttotal);
    $result = $db->sql_query("select year,month,date,hits from ".$prefix."_stats_date where year='$year' and month='$month' order by date");
    $total = $db->sql_numrows($result);
    echo "<center><b>"._DAILYSTATS." ";
    getmonth($month);
    echo ", $year</b></center><br>";
    echo "<table align=center cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr><td>";
    // result table
    echo "<table align=\"center\" bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\">";
    echo "<tr><td width=\"25%\" class=systemTabHeader>"._DATE."</td><td class=systemTabHeader>"._SPAGESVIEWS."</td></tr>";
    $count=0;
    while (list($year,$month,$date,$hits) = $db->sql_fetchrow($result)){
		$statGraphDef['data'][$count]= $hits;     
     	$statGraphDef['label'][$count]= $date." ".getmonth($month,0);
     	$statGraphDef['title']=_DAILYSTATS." ".getmonth($month,0)." ".$year;
		echo "<tr class=listTableNone><td>";
		if ($date != $nowdate) {
	    	echo "<a href=\"system.php?&amp;op=DailyStats&amp;year=$year&amp;month=$month&amp;date=$date\" class=\"hover_orange\">";
	    	echo $date;
	    	echo "</a>";
		} else {
	    	echo $date;
		}
		echo "</td><td align=center>";
		if ($hits == 0) {
	    	$WidthIMG = 0;
	    	$d_percent = 0;
		} else {
	    	$WidthIMG = round(100 * $hits/$TotalHitsDate,0);
	    	$d_percent = substr(100 * $hits / $TotalHitsDate, 0, 5);
		}
		echo " $d_percent% ($hits)</td></tr>"
	    	."</td></tr>";
	$count++;    	
    }
    $db->sql_freeresult($result);
    echo "</table>";
    echo "</td><td >";
    // graph    
     setGraphData($statGraphDef,2);
     echo "<table><tr><td rowspan=10 align=right><img src=\"system.php?op=draw_bar&dataid=2&graph_width=700&graph_height=300\" border=0></td></tr></table>\n";
 	echo "</td></tr></table>";
}
/**
 * showHourlyStats()
 * 
 */
function showHourlyStats($year,$month,$date){
    global $prefix,$bgcolor1,$bgcolor2,$db, $ThemeSel;
    $l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
    $m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
    $r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
    $resulttotal = $db->sql_query("select sum(hits) as TotalHitsHour from ".$prefix."_stats_hour where year='$year' and month='$month' and date='$date'");
    list ($TotalHitsHour) = $db->sql_fetchrow($resulttotal);
    $db->sql_freeresult($resulttotal);
    $nowdate = date("d-m-Y");
    $nowdate_arr = explode("-",$nowdate);
    echo "<center><b>"._HOURLYSTATS." ";
    echo getmonth($month)." ".$date.", " .$year."</b></center><br>";
    echo "<table align=center cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr><td>";
    // result table
    echo "<table align=\"center\" bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\">";
    echo "<tr><td class=systemTabHeader>"._HOUR."</td><td class=systemTabHeader >"._SPAGESVIEWS."</td></tr>";
    $count=0;
    for ($k = 0;$k<=23;$k++) {
		$result = $db->sql_query("select hour,hits from ".$prefix."_stats_hour where year='$year' and month='$month' and date='$date' and hour='$k'");
		if ($db->sql_numrows($result) == 0){
	    	$hits=0;
		} else {
	    	list($hour,$hits) = $db->sql_fetchrow($result);
		}
		echo "<tr class=listTableNone><td >";
		if ($k < 10) {
	    	$a = "0$k";
		} else {
	    	$a = $k;
		}		
		$graph_hour="$a:00 - $a:59";
		echo $graph_hour;
		$a = "";
		echo "</td><td align=center>";
		if ($hits == 0) {
	    	$WidthIMG = 0;
	    	$d_percent = 0;
		} else {
	    	$WidthIMG = round(100 * $hits/$TotalHitsHour,0);
	    	$d_percent = substr(100 * $hits / $TotalHitsHour, 0, 5);
		}		
	    echo " $d_percent% ($hits)</td></tr>"
	    ."</td></tr>";
	    $statGraphDef['data'][$count]= $hits;     
     	$statGraphDef['label'][$count]= $graph_hour;
     	$statGraphDef['title']=" "._HOURLYSTATS." ".getmonth($month,0)." ".$date.", " .$year;
     	$count++;
    }
    $db->sql_freeresult($result);
    echo "</table>";
    echo "</td><td>";
    // graph 
    setGraphData($statGraphDef,3);
     echo "<table><tr><td rowspan=10 align=right><img src=\"system.php?op=draw_bar&dataid=3&graph_width=700&graph_height=300\" border=0></td></tr></table>\n";
echo "</td></tr></table>";
}
/**
 * getmonth()
 * return month string associated to month number
 * @param int month number
 * @param int 1 (default) will echo month, 0 will only return month string
 * @return String month
 */
function getmonth($month,$display=1){
	
$themonth="";
    if ($month == 1) $themonth= ""._JANUARY."";
    if ($month == 2) $themonth= ""._FEBRUARY."";
    if ($month == 3) $themonth= ""._MARCH."";
    if ($month == 4) $themonth= ""._APRIL."";
    if ($month == 5) $themonth= ""._MAY."";
    if ($month == 6) $themonth= ""._JUNE."";
    if ($month == 7) $themonth= ""._JULY."";
    if ($month == 8) $themonth= ""._AUGUST."";
    if ($month == 9) $themonth= ""._SEPTEMBER."";
    if ($month == 10) $themonth= ""._OCTOBER."";
    if ($month == 11) $themonth= ""._NOVEMBER."";
    if ($month == 12) $themonth= ""._DECEMBER."";
    
    if ($display) echo $themonth;    	  
    
return $themonth;    
}


/**
 * drawBarGraph();
 * @param array with data
 */
function drawBarGraph($dataid, $graph_width=300, $graph_height=200){
    session_start();
	settype($graph_width, "int");
	settype($graph_height, "int");
	if( isset( $_SESSION['ecmsgraphstat'] ) ) {
	    
	    $statGraphDef= $_SESSION['ecmsgraphstat'];
	    $statGraphDef=$statGraphDef[$dataid];
	    $mydata=$statGraphDef['data'];
	    $mylabel=$statGraphDef['label'];
		// Creation du graphique
		$graph = new Graph($graph_width,$graph_height);
		$graph->SetScale("textlin");    	
    	//$graph->xaxis->SetMajTickPositions($tickPositions,$tickLabels);
    	$graph->title->SetFont(FF_VERDANA, FS_NORMAL, 8);
    	$graph->title->Set($statGraphDef['title']);
    	$graph->xaxis->SetTickLabels($mylabel);
    	$graph->xaxis->SetFont(FF_VERDANA, FS_NORMAL, 6);
		$graph->xaxis->SetLabelAngle(90);
		//$graph->SetMargin(50,10,5,70);
		$graph->SetMargin(50,10,5,100); 
		$graph->SetMarginColor('white');
		$graph->SetShadow();
		// Cration du systme de points
		$lineplot=new BarPlot($mydata);
		$lineplot->value->Show();
				
		// On rajoute les points au graphique
		$graph->Add($lineplot);
		// Affichage
		$graph->Stroke();
	}
}
/**
 * drawBarGraph();
 * @param array with data
 */
function drawPieGraph($dataid){
    session_start();
	
	if( isset( $_SESSION['ecmsgraphstat'] ) ) {
	    
	    $statGraphDef= $_SESSION['ecmsgraphstat'];
	    $statGraphDef=$statGraphDef[$dataid];
	    $mydata=$statGraphDef['data'];
	    $mylabel=$statGraphDef['label'];
	    
		// Creation du graphique
		$graph = new PieGraph(400,200,"auto");
		//$graph->SetScale("textlin");    	
    	$graph->title->SetFont(FF_VERDANA, FS_NORMAL, 8);
    	$graph->title->Set($statGraphDef['title']);
		$graph->SetMargin(20,20,0,40); 
		$graph->SetMarginColor('white');
		$graph->SetShadow();
		$graph->legend->Pos(0.02,0.02,"right","top");
		$graph->legend->SetFont(FF_VERDANA, FS_NORMAL, 6);
		// Cration du systme de points
		$pieplot=new PiePlot3D($mydata);
		$pieplot->SetCenter(0.35);
		$pieplot->SetLegends($mylabel);
		//$pieplot->SetLabels($mylabel);
		$pieplot->SetAngle(50);
		$pieplot->ExplodeSlice(1);
		$pieplot->value->Show();
				
		// On rajoute les points au graphique
		$graph->Add($pieplot);
		// Affichage
		$graph->Stroke();
	}
}
function setGraphData($mydata,$graphId=0){
	if( ! isset( $_SESSION['ecmsgraphstat'] ) ) {
		$_SESSION['ecmsgraphstat'] = array();
		//$sessionData[$graphId]=$mydata;
		//$_SESSION['ecmsgraphstat'] = $sessionData;
		}
	$sessionData=$_SESSION['ecmsgraphstat'];
	$sessionData[$graphId]=$mydata;
	$_SESSION['ecmsgraphstat'] = $sessionData;
	return true;
}



switch($op) {

    default:
    Stats_Main();
    break;

	case "StatsMain":
     Stats_Main();
    break;

    case "Stats":
    Stats($total);
    break;

    case "YearlyStats":
    YearlyStats($year);
    break;

    case "MonthlyStats":
    MonthlyStats($year,$month);
    break;

    case "DailyStats":
    DailyStats($year,$month,$date);
    break;

    case "convert_month":
    convert_month($month);
    break;
    
    case "draw_bar":
    if (isset($graph_width) && isset($graph_height)){
    drawBarGraph($dataid,$graph_width,$graph_height);
    } else {
    	drawBarGraph($dataid);
    }
    break;
    case "draw_pie":
    drawPieGraph($dataid);
    break;

}

?>