<?php
if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	
	require_once 'modules/'.$module_name.'/system/params.php';
	require_once 'modules/'.$module_name.'/system/fonctions.php';
	require_once 'modules/'.$module_name.'/utils.php';
	require_once "core/becms_ui_component.php";
	
	$theItineraire = array(
			"id" => $Id,
			"nom_french" => $nom_french,
			"nom_corsican" => $nom_corsican,
			"description_french" => $description_french,
			"description_corsican" => $description_corsican,
			"commune" => $commune,
			"longueur" => $longueur,
			"difficulte_french" => $difficulte_french,
    	    "difficulte_corsican" => $difficulte_corsican,
    	    "difficulte_italian" => $difficulte_italian,
    	    "difficulte_english" => $difficulte_english,
			"etat_french" => $etat_french,
	        "etat_corsican" => $etat_corsican,
    	    "etat_italian" => $etat_italian,
    	    "etat_english" => $etat_english,
			"id_album" => $id_album,
			"id_album_travaux" => $id_album_travaux,
			"id_meteo" => $id_meteo,
			"id_download" => $download,
			"commentaire" => $commentaire,
			"latitude" => $latitude,
			"longitude" => $longitude,
			"en_travaux" => $en_travaux
	);
	
	function list_index($nbreFiches, $page, $ligne_par_page,$url, $txtfound=_COMSPACE_ELTS_FOUND, $txtnotfound = _COMSPACE_ELTS_NOTFOUND, $txtpage = _COMSPACE_ELTS_PAGES, $extraurl="") {
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);
	
	
		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$txtfound;
			$indexPages .= $txtpage;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				} else {
					$indexPages .= "<div class=\"page\">";
					$extraurl = str_replace("<!--page-->",$min,$extraurl);
					if ($url != "") {
						$indexPages .= "<a href=\"$url&page=$min"."\"$extraurl)>$min</a>";
					} else {
						$indexPages .= "<a href=\"#\"".$extraurl.")>$min</a>";
					}
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				} else {
					$indexPages .= "<div class=\"page\">";
					$extraurl = str_replace("<!--page-->",$i,$extraurl);
					if ($url != "") {
						$indexPages .= "<a href=\"$url&page=$i"."\"$extraurl>$i</a>";
					} else {
						$indexPages .= "<a href=\"#\"".$extraurl.")>$i</a>";
					}
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				} else {
					$indexPages .= "<div class=\"page\">";
					$extraurl = str_replace("<!--page-->",$max,$extraurl);
					if ($url != "") {
						$indexPages .= "<a href=\"$url&page=$max"."\"$extraurl>$max</a>";
					} else {
						$indexPages .= "<a href=\"#\"".$extraurl.")>$max</a>";
					}
					$indexPages .= "</div>";
				}
	
			}
		} else {
			$indexPages .= $txtnotfound;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}
	
	function listItineraires($page) {
		global $prefix, $db, $onglet;
		global $name_table_itineraire;
		
		$sql = "SELECT count(id) FROM `".$prefix.$name_table_itineraire."` ";
		$result = $db->sql_query($sql);
		list($nbreFiches) = $db->sql_fetchrow($result);
		$ligne_par_page = 20;
		if ($page == "-1") {
			$page = ceil($nbreFiches / $ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbreFiches, $page, $ligne_par_page, "?op=sdp&action=list_itineraire&onglet=".$onglet, _SDPFOUND, _SDPNOTFOUND, _SDPPAGES);
		$liste .= '</td><td width="50"></td>';
		$liste .= '</tr></table>';
		$limit = (($ligne_par_page * ($page-1))).",".$ligne_par_page;
		$sql = "SELECT *, gall1.album_name, gall2.album_name as album_name_travaux FROM `".$prefix.$name_table_itineraire."` LEFT JOIN ".$prefix."_gallery_album as gall1 ON gall1.albumid=".$prefix.$name_table_itineraire.".id_album LEFT JOIN ".$prefix."_gallery_album as gall2 ON gall2.albumid=".$prefix.$name_table_itineraire.".id_album_travaux LIMIT ".$limit;
/*SELECT *, gall1.album_name, gall2.album_name FROM `becms_sdp_itineraire` LEFT JOIN becms_gallery_album as gall1 ON gall1.albumid=becms_sdp_itineraire.id_album LEFT JOIN becms_gallery_album as gall2 ON gall2.albumid=becms_sdp_itineraire.id_album_travaux LIMIT 0,20*/
		$results = $db->sql_query($sql);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._SDPLISTNOM.'</th>
					<th class="systemTabHeader">'._SDPLISTCOMMUNE.'</th>
					<th class="systemTabHeader">'._SDPLISTETAT.'</th>
					<th class="systemTabHeader">'.'Albums'.'</th>
                    <th class="systemTabHeader">'.'Gomtrie'.'</th>
	    			<th class="systemTabHeader">'._SDPACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($db->sql_numrows ($results) != 0) {
			while ( $ligne = $db->sql_fetchrow ($results) ) {
				$barDef = array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=sdp&action=edit_itineraire&onglet=itineraire&page=".$page."&Id=".$ligne["id"],"comment"=>_EDIT, "status"=>"ON"),
						"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=sdp&action=delete_itineraire&onglet=itineraire&page=".$page."&Id=".$ligne["id"],"comment"=>_DELETE,"status"=>"ON"));
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$longlim = 80;
				$nom = strFrenchAndCorsican($ligne["nom_french"], $ligne["nom_corsican"]);
				if (strlen($nom) > $longlim) {
					$liste .= substr($nom, 0, $longlim)."...";
				} else {
					$liste .= $nom;
				}
				$liste .= '</td><td align="center">';
				if (strlen($ligne["commune"]) > $longlim) {
					$liste .= substr($ligne["commune"], 0, $longlim)."...";
				} else {
					$liste .= $ligne["commune"];
				}
				$liste .= '</td><td align="center">';
				if( $ligne['en_travaux'] ) {
					$liste .= "En travaux";
				} else {
					$liste .= "";
				}
				$liste .= '</td><td align="center">';
				$liste .= $ligne["album_name"];
				$liste .= ($ligne["album_name"]!="" && $ligne["album_name_travaux"]!= "") ? ", " : "";
				$liste .= $ligne["album_name_travaux"];
				$liste .= '</td><td align="center">';
				$liste .= (($ligne["geom"] != "" && $ligne["geom_centre"] != "") ? "&bull;" : "");
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			$liste .= '</table>';
			$liste .= '<div><a href="system.php?op=sdp&action=add_itineraire&onglet=itineraire&page='.$page.'">'._SDPADDITINERAIRE.'</a></div>';
			return $liste;
		}
	}
	
	function listSites($page) {
		global $prefix, $db, $onglet;
		global $name_table_site, $name_table_itineraire;
		
		$sql = "SELECT count(id) FROM `".$prefix.$name_table_site."` ";
		$result = $db->sql_query ( $sql );
		list($nbreFiches) = $db->sql_fetchrow($result);
		$ligne_par_page = 20;
		if ($page == "-1") {
			$page = ceil($nbreFiches / $ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbreFiches, $page, $ligne_par_page, "?op=sdp&action=list_site&onglet=".$onglet, _SDPFOUND, _SDPNOTFOUND, _SDPPAGES);
		$liste .= '</td><td width="50"></td>';
		$liste .= '</tr></table>';
		$limit = (($ligne_par_page * ($page-1))).",".$ligne_par_page;
		$sql = "SELECT *, album_name FROM `".$prefix.$name_table_site."` LEFT JOIN ".$prefix."_gallery_album ON ".$prefix."_gallery_album.albumid=".$prefix.$name_table_site.".id_album ORDER BY id_itineraire LIMIT ".$limit;
		$results = $db->sql_query($sql);
		$liste .= '
				<table class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._SDPLISTNOM.'</th>
					<th class="systemTabHeader">'._SDPLISTNOMITINERAIRE.'</th>
					<th class="systemTabHeader">'._SDPLISTCOMMUNE.'</th>
                    <th class="systemTabHeader">'.'Album photo'.'</th>
                    <th class="systemTabHeader">Gomtrie</th>
	    			<th class="systemTabHeader">'._SDPACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($db->sql_numrows ($results) != 0) {
			while ( $ligne = $db->sql_fetchrow ($results) ) {
				$barDef = array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=sdp&action=edit_site&onglet=site&page=".$page."&Id=".$ligne["id"],"comment"=>_EDIT, "status"=>"ON"),
						"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=sdp&action=delete_site&onglet=site&page=".$page."&Id=".$ligne["id"],"comment"=>_DELETE,"status"=>"ON"));
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$longlim = 80;
				$nom = strFrenchAndCorsican($ligne["nom_french"], $ligne["nom_corsican"]);
				if (strlen($nom) > $longlim) {
					$liste .= substr($nom, 0, $longlim)."...";
				} else {
					$liste .= $nom;
				}
				$liste .= '</td>';
				
				$sql = "SELECT * FROM ".$prefix.$name_table_itineraire." WHERE id=".$ligne['id_itineraire'];
				$result = $db->sql_query($sql);
				if ($db->sql_numrows ($result) != 0) {
					$ligne_itin = $db->sql_fetchrow ($result);
					$liste .= '<td align="center">';
					$nom_itin = strFrenchAndCorsican($ligne_itin["nom_french"], $ligne_itin["nom_corsican"]);
					if (strlen($nom_itin) > $longlim) {
						$liste .= substr($nom_itin, 0, $longlim)."...";
					} else {
						$liste .= $nom_itin;
					}
					$liste .= '</td><td align="center">';
					if (strlen($ligne_itin["commune"]) > $longlim) {
						$liste .= substr($ligne_itin["commune"], 0, $longlim)."...";
					} else {
						$liste .= $ligne_itin["commune"];
					}
				} else {
					$liste .= '<td align="center">';
					$liste .= '</td><td align="center">';
				}
				$liste .= '</td><td align="center">';
				$liste .= $ligne["album_name"];
				$liste .= '</td><td align="center">';
				$liste .= (($ligne["geom"] != "" && $ligne["geom_centre"] != "") ? "&bull;" : "");
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add", "Bar d'action", $barDef, "img", "", true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			$liste .= '</table>';
			$liste .= '<div><a href="system.php?op=sdp&action=add_site&onglet=site&page='.$page.'">'._SDPADDSITE.'</a></div>';
			return $liste;
		}
	}
	
	function createMenuAlbum($name, $id_album) {
		global $db, $prefix;
		$sortie = "";
		$results = $db->sql_query("select albumid, album_name from ".$prefix."_gallery_album order by album_name asc");
		if ($db->sql_numrows ($results) != 0) {
			$sortie .= '<select name="'.$name.'" />';
			$sortie .= '<option value="">Choisissez un album</option>';
			while(list($albumid, $album_name) = $db->sql_fetchrow($results)) {
				if( $id_album == $albumid ) {
					$select = 'selected="selected"';
				} else {
					$select = "";
				}
				$sortie .= '<option value="'.$albumid.'" '.$select.'>'.$album_name.'</option>';
			}
			$sortie .= '</select>';
		}
		return $sortie;
	}
	
	function createMenuDownload($name, $id_download) {
		global $db, $prefix;
		$sortie = "";
		$results = $db->sql_query("select lid, title from ".$prefix."_downloads_downloads");
		if ($db->sql_numrows ($results) != 0) {
			$sortie .= '<select name="'.$name.'" />';
			$sortie .= '<option value="">Choisissez un fichier</option>';
			while(list($lid, $title) = $db->sql_fetchrow($results)) {
				if( $id_download == $lid ) {
					$select = 'selected="selected"';
				} else {
					$select = '';
				}
				$sortie .= '<option value="'.$lid.'" '.$select.'>'.$title.'</option>';
			}
			$sortie .= '</select>';
		}
		return $sortie;
	}
	
	function createMenuItineraire($name, $id_itineraire) {
		global $db, $prefix;
		global $name_table_itineraire;
		$sortie = "";
		$sql = "select id, nom_french, nom_corsican from ".$prefix.$name_table_itineraire;
		$results = $db->sql_query($sql);
		if ($db->sql_numrows ($results) != 0) {
			$sortie .= '<select name="'.$name.'" />';
			$sortie .= '<option value="">Choisissez un sentier</option>';
			while(list($id, $nom_french, $nom_corsican) = $db->sql_fetchrow($results)) {
				if( $id_itineraire == $id ) {
					$select = 'selected="selected"';
				} else {
					$select = "";
				}
				$sortie .= '<option value="'.$id.'" '.$select.'>'.strFrenchAndCorsican($nom_french, $nom_corsican).'</option>';
			}
			$sortie .= '</select>';
		}
		return $sortie;
	}
	
	function save_itineraire($itineraires) {
		global $prefix, $db;
		global $name_table_itineraire;
		//print_r($itineraires);
		$itineraires = array_map(array('utilFuncs_sdp', 'conditionnertodb'), $itineraires);
		//print_r($itineraires);
		$list_champs = "";
		$list_valeurs = "";
		if ( $itineraires["id"] == "-1" || $itineraires["id"] == "" || $itineraires["id"] == "0") {
			$list_champs = "";
			$list_valeurs = "";
			foreach($itineraires as $key => $value) {
				if( $key != "id" ) {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO ".$prefix.$name_table_itineraire." (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		} else {
			$list_champs = "";
			$list_valeurs = "";
			foreach($itineraires as $key => $value) {
				if( $key != "id" ) {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE ".$prefix.$name_table_itineraire." SET ".$list_champs." WHERE `id` = '".$itineraires["id"]."';";
		}	
		//die($sql);
		/*if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		} else {
			return false;
		}*/
		return $db->sql_query($sql);
	}
	
	function save_site($site) {
		global $prefix, $db;
		global $name_table_site;
		global $audio_french, $audio_italian, $audio_corsican, $audio_english;
		
		//fichiers audio
		include("core/conf/uploadconfig.php");
		$chemin = $uploadFolder."/../sdp";
		//virer l'audio courant si il existe
		if ( $site["id"] != "-1" && $site["id"] != "" && $site["id"] != "0") {
		    $sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE id=".$site["id"];
			$results = $db->sql_query($sql);
			if ($db->sql_numrows ($results) != 0) {
				$theSite = $db->sql_fetchrow ($results);
				if ($theSite["audio_french"] != "" && $audio_french == "") {
                    unlink($theSite["audio_french"]);
                }
                if ($theSite["audio_italian"] != "" && $audio_italian == "") {
                    unlink($theSite["audio_italian"]);
                }
                if ($theSite["audio_corsican"] != "" && $audio_corsican == "") {
                    unlink($theSite["audio_corsican"]);
                }
                if ($theSite["audio_english"] != "" && $audio_english == "") {
                    unlink($theSite["audio_english"]);
                }
			}
		}
		else {
		    $theSite = array();
		    $theSite["audio_french"] = "";
		    $theSite["audio_italian"] = "";
		    $theSite["audio_corsican"] = "";
		    $theSite["audio_english"] = "";
		}
		//uploader l'audio
		$site["audio_french"] = $audio_french;
		$audiosSaved = utilFuncs_sdp::uploadFiles($_FILES["fichier_audio_french"], $chemin);
		if (count($audiosSaved) > 0 ) {
            $fichier_audio_french = $audiosSaved[0];
            $site["audio_french"] = $fichier_audio_french;
            if ($theSite["audio_french"] != "" && $audio_french != "") {
                unlink($theSite["audio_french"]);
            }
		}
		$site["audio_italian"] = $audio_italian;
		$audiosSaved = utilFuncs_sdp::uploadFiles($_FILES["fichier_audio_italian"], $chemin);
		if (count($audiosSaved) > 0 ) {
            $fichier_audio_italian = $audiosSaved[0];
            $site["audio_italian"] = $fichier_audio_italian;
            if ($theSite["audio_italian"] != "" && $audio_italian != "") {
                unlink($theSite["audio_italian"]);
            }
		}
		$site["audio_corsican"] = $audio_corsican;
		$audiosSaved = utilFuncs_sdp::uploadFiles($_FILES["fichier_audio_corsican"], $chemin);
		if (count($audiosSaved) > 0 ) {
            $fichier_audio_corsican = $audiosSaved[0];
            $site["audio_corsican"] = $fichier_audio_corsican;
            if ($theSite["audio_corsican"] != "" && $audio_corsican != "") {
                unlink($theSite["audio_corsican"]);
            }
		}
		$site["audio_english"] = $audio_english;
		$audiosSaved = utilFuncs_sdp::uploadFiles($_FILES["fichier_audio_english"], $chemin);
		if (count($audiosSaved) > 0 ) {
            $fichier_audio_english = $audiosSaved[0];
            $site["audio_english"] = $fichier_audio_english;
            if ($theSite["audio_english"] != "" && $audio_english != "") {
                unlink($theSite["audio_english"]);
            }
		}
		
		//print_r($site);
		$site = array_map(array('utilFuncs_sdp', 'conditionnertodb'), $site);
		//print_r($site);
		$list_champs = "";
		$list_valeurs = "";
		if ( $site["id"] == "-1" || $site["id"] == "" || $site["id"] == "0") {
			$list_champs = "";
			$list_valeurs = "";
			foreach($site as $key => $value) {
				if( $key != "id" ) {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO ".$prefix.$name_table_site." (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		} else {
			$list_champs = "";
			$list_valeurs = "";
			foreach($site as $key => $value) {
				if( $key != "id" ) {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE ".$prefix.$name_table_site." SET ".$list_champs." WHERE `id` = '".$site["id"]."';";
		}
		//die($sql);
		/*if( $db->sql_query($sql)) {
		 return $db->sql_nextid();
		} else {
		return false;
		}*/
		return $db->sql_query($sql);
	}
	
	function edit_itineraire($id, $itineraire = array()) {
		global $onglet, $db, $prefix, $page;
		global $name_table_itineraire;
		global $header_system;
		
		$header_system = '
<script type="text/javascript" src="javascripts/turf.min.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width, height) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:height, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
    function getCarto() {
        var elt = document.getElementById("geom");
        if (elt.value != "") {
        var geom = JSON.parse(elt.value);
            return geom;
        }
        else {
            var elt_latitude = document.getElementById("itineraire[latitude]");
            var elt_longitude = document.getElementById("itineraire[longitude]");
            if (elt_latitude.value != "" && elt_longitude.value != "") {
                var geom_point = turf.featureCollection([turf.point([elt_longitude.value, elt_latitude.value])]);
                return geom_point;
            }
            else {
                return null;
            }
        }
    }
    function setCarto(geom) {
        /* Pour dsactiver les btises de windows_js */
        if(window.Prototype) {
            delete Object.prototype.toJSON;
            delete Array.prototype.toJSON;
            delete Hash.prototype.toJSON;
            delete String.prototype.toJSON;
        }

        //console.log(geom);
        var geom_text = JSON.stringify(geom);
        var elt = document.getElementById("geom");
        elt.value = geom_text;

        var geom_center = turf.featureCollection([turf.center(geom)]);
        var geom_center_text = JSON.stringify(geom_center);
        var elt_centre = document.getElementById("geom_centre");
        elt_centre.value = geom_center_text;
    }
</script>
';
		
		echo '<script type="text/javascript" src="javascripts/initfck.js"></script>
			<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
			<script type="text/javascript">
				//<![CDATA[
				function changeEnTravaux(checked) {
					if(  checked ) {
						document.getElementById("lat").style.display = "table-row";
						document.getElementById("long").style.display = "table-row";
					} else {
						document.getElementById("lat").style.display = "none";
						document.getElementById("long").style.display = "none";
					}
				}
				
				function clickEnTravaux(checked, latitude, longitude) {
					var html_lat, html_long;
					if(checked) {
						html_lat = "<td class=\"label\">'._SDPEDITLATITUDE.'</td>";
						html_lat += "<td width=\"10\"></td>";
						html_lat += "<td class=\"saisie_long_lang2\">";
						html_lat += "<input type=\"text\" name=\"itineraire[latitude]\" value=\"" + latitude + "\" class=\"saisie\">";
						html_lat += "</td>";
								
						html_long = "<td class=\"label\">'._SDPEDITLONGITUDE.'</td>";
						html_long += "<td width=\"10\"></td>";
						html_long += "<td class=\"saisie_long_lang2\">";
						html_long += "<input type=\"text\" name=\"itineraire[longitude]\" value=\"" + latitude + "\" class=\"saisie\">";
						html_long += "</td>";
					} else {
						html_lat = "";
						html_long = "";
					}
					document.getElementById("lat").innerHTML = html_lat;
					document.getElementById("long").innerHTML = html_long;
				}
				//]]>
			</script>';
		
		if ($itineraire["id"] != "") {
		    $id = $itineraire["id"];
		}

		if( $id == "" )
			$id = "-1";
		if( $id != "-1" ) {
			$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE id=".$id;
			$results = $db->sql_query($sql);
			if ($db->sql_numrows ($results) != 0) {
				$theItineraire = $db->sql_fetchrow ($results);
			}
		} else {
			$itineraire = array_map(array('utilFuncs_sdp', 'conditionnerFORM'), $itineraire);
			$theItineraire = $itineraire;
		}
		
		if( $theItineraire['en_travaux'] == 0 ) {
			$styleGeo = ' style = "display: none"';
			$select = "";
		} else {
			$styleGeo = '';
			$select = 'checked=checked';
		}
		//$enTravaux = '<input type="checkbox" value="1" name="itineraire[en_travaux]" '.$select.' onChange="changeEnTravaux(this.checked);" />';
		$enTravaux = '<input type="checkbox" value="1" name="itineraire[en_travaux]" '.$select.' onChange="changeEnTravaux(this.checked);" />';
		
		$sortie = "";
		$sortie .= '<form name="save_itineraire" action="system.php?op=sdp&action=save_itineraire&onglet='.$onglet.'&page='.$page.'" method="POST" onsubmit_deactivated="return submit_form(this)" enctype="multipart/form-data">';
		$sortie .= '<center><div class="fiche_generique">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<fieldset><legend>'._SDPEDITFILE.'</legend>';
		$sortie .= '
			<table class="editsdp" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="label">'._SDPDEDITNOMFRENCH.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[nom_french]" value="'.$theItineraire["nom_french"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPDEDITDESCFRENCH.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_french" style="width: 500px" class="saisie_long_lang" name="itineraire[description_french]" rows="6" cols="40">'.$theItineraire["description_french"].'</textarea>
					<script type="text/javascript">editEleven("description_french")</script></td>
				</tr>
				<tr>
					<td class="label">'._SDPDEDITNOMCORSICAN.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[nom_corsican]" value="'.$theItineraire["nom_corsican"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPDEDITDESCCORSICAN.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_corsican" style="width: 500px" class="saisie_long_lang" name="itineraire[description_corsican]" rows="6" cols="40">'.$theItineraire["description_corsican"].'</textarea>
					<script type="text/javascript">editEleven("description_corsican")</script></td>
				</tr>
                <tr>
					<td class="label">'.'Nom italien : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[nom_italian]" value="'.$theItineraire["nom_italian"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'.'Description italien : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_italian" style="width: 500px" class="saisie_long_lang" name="itineraire[description_italian]" rows="6" cols="40">'.$theItineraire["description_italian"].'</textarea>
					<script type="text/javascript">editEleven("description_italian")</script></td>
				</tr>
                <tr>
					<td class="label">'.'Nom anglais : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[nom_english]" value="'.$theItineraire["nom_english"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'.'Description auglais : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_english" style="width: 500px" class="saisie_long_lang" name="itineraire[description_english]" rows="6" cols="40">'.$theItineraire["description_english"].'</textarea>
					<script type="text/javascript">editEleven("description_english")</script></td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITCOMMUNE.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[commune]" value="'.$theItineraire["commune"].'" class="saisie">
					</td>
				</tr>
                <tr>
					<td class="label">'.'Tlphone Office de Tourisme : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[tel_ot]" value="'.$theItineraire["tel_ot"].'" class="saisie">
					</td>
				</tr>
                <tr>
					<td class="label">'.'Mail Office de Tourisme'.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[mail_ot]" value="'.$theItineraire["mail_ot"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITLONGUEUR.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[longueur]" value="'.$theItineraire["longueur"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITDIFFICULTE.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[difficulte_french]" value="'.$theItineraire["difficulte_french"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">Difficult corse :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[difficulte_corsican]" value="'.$theItineraire["difficulte_corsican"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">Difficult italien :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[difficulte_italian]" value="'.$theItineraire["difficulte_italian"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">Difficult anglais :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[difficulte_english]" value="'.$theItineraire["difficulte_english"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITETAT.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[etat_french]" value="'.$theItineraire["etat_french"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">tat corse :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[etat_corsican]" value="'.$theItineraire["etat_corsican"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">tat italien :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[etat_italian]" value="'.$theItineraire["etat_italian"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">tat anglais :</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[etat_english]" value="'.$theItineraire["etat_english"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITALBUM.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.createMenuAlbum("itineraire[id_album]", $theItineraire["id_album"]).'
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITALBUMTRAVAUX.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.createMenuAlbum("itineraire[id_album_travaux]", $theItineraire["id_album_travaux"]).'
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITIDMETEO.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[id_meteo]" value="'.$theItineraire["id_meteo"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITIDDOWNLOAD.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.createMenuDownload("itineraire[id_download]", $theItineraire["id_download"]).'
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITENTRAVAUX.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.$enTravaux.'</td>
				</tr>
				<tr id="lat" '.$styleGeo.'>
					<td class="label">'._SDPEDITLATITUDE.' (optionnel)</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" id="itineraire[latitude]" name="itineraire[latitude]" value="'.$theItineraire['latitude'].'" class="saisie">
					</td>
				</tr>
				<tr id="long" '.$styleGeo.'>
					<td class="label">'._SDPEDITLONGITUDE.' (optionnel)</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" id="itineraire[longitude]" name="itineraire[longitude]" value="'.$theItineraire['longitude'].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITCOMMENTAIRE.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="commentaire" style="width: 500px" class="saisie_long_lang" name="itineraire[commentaire]" rows="6" cols="40">'.$theItineraire["commentaire"].'</textarea>
					<script type="text/javascript">editEleven("commentaire")</script></td>
				</tr>
				<tr>
					<td class="label">Visite virtuelle</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="itineraire[visite]" value="'.$theItineraire["visite"].'" class="saisie">
					</td>
				</tr>
                <tr>
					<td class="label">Trac de l\'itinraire *</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
                    <textarea style="width: 500px" id="geom" class="saisie_long_lang" name="itineraire[geom]" rows="6" cols="40">'.$theItineraire["geom"].'</textarea><br>
                    <textarea style="width: 500px" id="geom_centre" class="saisie_long_lang" name="itineraire[geom_centre]" rows="6" cols="40">'.$theItineraire["geom_centre"].'</textarea><br>
					<a href="system.php?op=sdp&action=edit_carto" title="dition du trac" onclick="ouvre_dialogue(this.title, this.href, 800, 900); return false">Ouvrir diteur cartographique</a>
					</td>
				</tr>
			</table>';
		$sortie .= '</fieldset>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._SDPEDITSAVEITINERAIRE.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$id.'" name="itineraire[id]">';
		
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div></center>';
		$sortie .= "</form>";
		return $sortie;
	}
	
	function edit_site($id, $site = array()) {
		global $onglet, $db, $prefix, $page;
		global $name_table_site;
		global $header_system;
		
		$header_system = '
<script type="text/javascript" src="javascripts/turf.min.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width, height) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:height, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
    function getCarto() {
        var elt = document.getElementById("geom");
        if (elt.value != "") {
        var geom = JSON.parse(elt.value);
            return geom;
        }
        else {
            var elt_latitude = document.getElementById("site[latitude]");
            var elt_longitude = document.getElementById("site[longitude]");
            if (elt_latitude.value != "" && elt_longitude.value != "") {
                var geom_point = turf.featureCollection([turf.point([elt_longitude.value, elt_latitude.value])]);
                return geom_point;
            }
            else {
                return null;
            }
        }
    }
    function setCarto(geom) {
        /* Pour dsactiver les btises de windows_js */
        if(window.Prototype) {
            delete Object.prototype.toJSON;
            delete Array.prototype.toJSON;
            delete Hash.prototype.toJSON;
            delete String.prototype.toJSON;
        }

        //console.log(geom);
        var geom_text = JSON.stringify(geom);
        var elt = document.getElementById("geom");
        elt.value = geom_text;

        var geom_center = turf.featureCollection([turf.center(geom)]);
        var geom_center_text = JSON.stringify(geom_center);
        var elt_centre = document.getElementById("geom_centre");
        elt_centre.value = geom_center_text;
    }
</script>

<script>
    function del_audio(langue) {
        if (confirm("En tes-vous sr ?")) {
            var elt = document.getElementById("audio_"+langue);
            if (elt != null) {
                elt.value = "";
            }
            elt2 = document.getElementById("player_audio_"+langue);
            if (elt2 != null) {
                elt2.style.display = "none";
            }
        }
    }
</script>
';
		
		echo '<script type="text/javascript" src="javascripts/initfck.js"></script>
		<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>';
	
		if( $id == "" )
			$id = "-1";
		if( $id != "-1" ) {
			$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE id=".$id;
			$results = $db->sql_query($sql);
			if ($db->sql_numrows ($results) != 0) {
				$theSite = $db->sql_fetchrow ($results);
			}
		} else {
			$site = array_map(array('utilFuncs_sdp', 'conditionnerFORM'), $site);
			$theSite = $site;
		}
		
		/* audios */
		if ($theSite["audio_french"] != "") {
		    $audio_french = '
                    <audio controls id="player_audio_french">
                      <source src="'.$theSite["audio_french"].'" type="audio/mpeg">
                      <p>Votre navigateur ne prend pas en charge l\'audio HTML. Voici un <a href="'.$theSite["audio_french"].'">lien vers le fichier audio</a> pour le tlcharger.</p>
                    </audio><br>
                    <a href="#" onclick="return del_audio(\'french\');">Supprimer ce fichier audio</a><br>
                    Remplacer le fichier audio :<br>';
		}
		else {
		    $audio_french = 'Ajouter un fichier audio :<br>';
		}
		$audio_french .= '<input type="hidden" id="audio_french" name="audio_french" value="'.$theSite["audio_french"].'"><input type="file" name="fichier_audio_french[]" value="">';
		
		if ($theSite["audio_corsican"] != "") {
		    $audio_corsican = '
                    <audio controls id="player_audio_corsican">
                      <source src="'.$theSite["audio_corsican"].'" type="audio/mpeg">
                      <p>Votre navigateur ne prend pas en charge l\'audio HTML. Voici un <a href="'.$theSite["audio_corsican"].'">lien vers le fichier audio</a> pour le tlcharger.</p>
                    </audio><br>
                    <a href="#" onclick="return del_audio(\'corsican\');">Supprimer ce fichier audio</a><br>
                    Remplacer le fichier audio :<br>';
		}
		else {
		    $audio_corsican = 'Ajouter un fichier audio :<br>';
		}
		$audio_corsican .= '<input type="hidden" id="audio_corsican" name="audio_corsican" value="'.$theSite["audio_corsican"].'"><input type="file" name="fichier_audio_corsican[]" value="">';
		
		if ($theSite["audio_italian"] != "") {
		    $audio_italian = '
                    <audio controls id="player_audio_italian">
                      <source src="'.$theSite["audio_italian"].'" type="audio/mpeg">
                      <p>Votre navigateur ne prend pas en charge l\'audio HTML. Voici un <a href="'.$theSite["audio_italian"].'">lien vers le fichier audio</a> pour le tlcharger.</p>
                    </audio><br>
                    <a href="#" onclick="return del_audio(\'italian\');">Supprimer ce fichier audio</a><br>
                    Remplacer le fichier audio :<br>';
		}
		else {
		    $audio_italian = 'Ajouter un fichier audio :<br>';
		}
		$audio_italian .= '<input type="hidden" id="audio_italian" name="audio_italian" value="'.$theSite["audio_italian"].'"><input type="file" name="fichier_audio_italian[]" value="">';
		
		if ($theSite["audio_english"] != "") {
		    $audio_english = '
                    <audio controls id="player_audio_english">
                      <source src="'.$theSite["audio_english"].'" type="audio/mpeg">
                      <p>Votre navigateur ne prend pas en charge l\'audio HTML. Voici un <a href="'.$theSite["audio_english"].'">lien vers le fichier audio</a> pour le tlcharger.</p>
                    </audio><br>
                    <a href="#" onclick="return del_audio(\'english\');">Supprimer ce fichier audio</a><br>
                    Remplacer le fichier audio :<br>';
		}
		else {
		    $audio_english = 'Ajouter un fichier audio :<br>';
		}
		$audio_english .= '<input type="hidden" id="audio_english" name="audio_english" value="'.$theSite["audio_english"].'"><input type="file" name="fichier_audio_english[]" value="">';

		$sortie = "";
		$sortie .= '<form name="save_site" action="system.php?op=sdp&action=save_site&onglet='.$onglet.'&page='.$page.'" method="POST" onsubmit="return submit_form(this)" enctype="multipart/form-data">';
		$sortie .= '<center><div class="fiche_generique">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<fieldset><legend>'._SDPEDITFILE.'</legend>';
		$sortie .= '
			<table class="editsdp" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="label">'._SDPDEDITNOMFRENCH.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="site[nom_french]" value="'.$theSite["nom_french"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPDEDITDESCFRENCH.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_french" style="width: 500px" class="saisie_long_lang" name="site[description_french]" rows="6" cols="40">'.$theSite["description_french"].'</textarea>
					<script type="text/javascript">editEleven("description_french")</script></td>
				</tr>
				<tr>
					<td class="label">'._SDPDEDITNOMCORSICAN.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="site[nom_corsican]" value="'.$theSite["nom_corsican"].'" class="saisie">
					</td>
				</tr>
                <tr>
				<tr>
					<td class="label">'._SDPDEDITDESCCORSICAN.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_corsican" style="width: 500px" class="saisie_long_lang" name="site[description_corsican]" rows="6" cols="40">'.$theSite["description_corsican"].'</textarea>
					<script type="text/javascript">editEleven("description_corsican")</script></td>
				</tr>
                <tr>
					<td class="label">'.'Nom italien : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="site[nom_italian]" value="'.$theSite["nom_italian"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'.'Description italien : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_italian" style="width: 500px" class="saisie_long_lang" name="site[description_italian]" rows="6" cols="40">'.$theSite["description_italian"].'</textarea>
					<script type="text/javascript">editEleven("description_italian")</script></td>
				</tr>
                <tr>
					<td class="label">'.'Nom anglais : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" name="site[nom_english]" value="'.$theSite["nom_english"].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'.'Description auglais : '.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_english" style="width: 500px" class="saisie_long_lang" name="site[description_english]" rows="6" cols="40">'.$theSite["description_english"].'</textarea>
					<script type="text/javascript">editEleven("description_english")</script></td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITITINERAIRE.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.createMenuItineraire("site[id_itineraire]", $theSite["id_itineraire"]).'
					</td>
				</tr>		
				<tr>
					<td class="label">'._SDPEDITALBUM.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.createMenuAlbum("site[id_album]", $theSite["id_album"]).'
					</td>
				</tr>
                <tr>
					<td class="label">Audio franais : </td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.$audio_french.'
					</td>
				</tr>
                <tr>
					<td class="label">Audio italien : </td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.$audio_italian.'
					</td>
				</tr>
                <tr>
					<td class="label">Audio corse : </td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.$audio_corsican.'
					</td>
				</tr>
                <tr>
					<td class="label">Audio anglais : </td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					'.$audio_english.'
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITLATITUDE.' (optionnel)</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" id="site[latitude]" name="site[latitude]" value="'.$theSite['latitude'].'" class="saisie">
					</td>
				</tr>
				<tr>
					<td class="label">'._SDPEDITLONGITUDE.' (optionnel)</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<input type="text" id="site[longitude]" name="site[longitude]" value="'.$theSite['longitude'].'" class="saisie">
					</td>
				</tr>
                <tr>
					<td class="label">Position du POI *</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
                    <textarea style="width: 500px" id="geom" class="saisie_long_lang" name="site[geom]" rows="6" cols="40">'.$theSite["geom"].'</textarea><br>
                    <textarea style="width: 500px" id="geom_centre" class="saisie_long_lang" name="site[geom_centre]" rows="6" cols="40">'.$theSite["geom_centre"].'</textarea><br>
					<a href="system.php?op=sdp&action=edit_carto" title="dition du POI" onclick="ouvre_dialogue(this.title, this.href, 800, 900); return false">Ouvrir diteur cartographique</a>
					</td>
				</tr>
			</table>';
		$sortie .= '</fieldset>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._SDPEDITSAVESITE.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$id.'" name="site[id]">';
	
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div></center>';
		$sortie .= "</form>";
		return $sortie;
	}
	
	function deleteItineraire($id, $confirm = "n") {
		global $db, $prefix, $page;
		global $name_table_itineraire;
		if( $id != "" && $id != "-1" ) {
			if ($confirm == "y"){
				$sql = "DELETE FROM ".$prefix.$name_table_itineraire." WHERE id=".$id.";";
				$db->sql_query($sql);
				header("Location: system.php?action=list_itineraire&op=sdp&onglet=itineraire&page=".$page);
			} else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._SDP_ITINERAIRE_DELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=sdp&action=delete_itineraire&onglet=itineraire&Id='.$id.'&page='.$page.'&ok=y">';
				$sortie .= "["._YES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._NO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
	}
	
	function deleteSite($id, $confirm = "n") {
		global $db, $prefix, $page;
		global $name_table_site;
		if( $id != "" && $id != "-1" ) {
			if ($confirm == "y"){
				$sql = "DELETE FROM ".$prefix.$name_table_site." WHERE id=".$id.";";
				$db->sql_query($sql);
				header("Location: system.php?action=list_site&op=sdp&onglet=site&page=".$page);
			} else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._SDP_SITE_DELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=sdp&action=delete_site&onglet=site&Id='.$id.'&page='.$page.'&ok=y">';
				$sortie .= "["._YES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._NO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
	}
	
	function edit_carto() {
	    global $module_name;
	    
	    $sortie = '
<!DOCTYPE HTML>
<html lang="fr">
	<head>
		<meta http-equiv="content-type" content="text/html;charset=utf-8">
		<title>Document</title>
		<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
		<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
		<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>

        <link rel="stylesheet" href="javascripts/leaflet/leaflet.css" />
        <link rel="stylesheet" href="javascripts/leaflet.fullscreen/leaflet.fullscreen.css" />
        <script src="javascripts/leaflet/leaflet.js"></script>
        <script src="javascripts/Leaflet.Editable.js"></script>
        <script src="javascripts/leaflet.filelayer/togeojson.js"></script>
        <script src="javascripts/leaflet.filelayer/jszip.js"></script>
        <script src="javascripts/leaflet.filelayer/leaflet.filelayer2.js"></script>
        <script src="javascripts/leaflet.fullscreen/Leaflet.fullscreen.js"></script>

        <style type="text/css">
              body { margin:0; padding:0; }
              #map { position:absolute; top:0; bottom:0; right: 0; left: 0; width:100%; }
              .leaflet-control-filelayer a {border-radius : 2px}
        </style>

        <script type="text/javascript">
            function setCarto(geom) {
            	window.parent.setCarto(geom);
            	window.parent.win.close();
            }
            function cancelCarto() {
                window.parent.win.close();
            }
        </script>

	</head>

	<body style="background-color: #F2F2E6">
	';
		$sortie .= '<div id="map"></div>';
		
		
		$sortie .= '
<script type="text/javascript">
    var couleur_noedit = "DarkRed";
    var startPoint = [42.2, 9];
    var map = L.map("map", {editable: true, doubleClickZoom: false}).fitWorld().setView(startPoint, 9);

    map.options.minZoom = 5;

    map.addControl(new L.Control.Fullscreen({
        title: {
            "false": "Plein cran",
            "true": "Rduire"
        }
    }));
    
    /* fonds de carte */
	var fonds_carto = {};	
	fonds_carto["Outdoors"]=  L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckacgndr602if1iloq3zpxoif/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
		        tileSize: 512,
		    	maxZoom: 20,
		    	zoomOffset: -1,
		        attribution: "Mapbox",
		        noWrap: true
		      });
	fonds_carto["Satellite monde"] = L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckadls8ql0l7k1ilo0lps4swq/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
		        tileSize: 512,
		    	maxZoom: 20,
		    	zoomOffset: -1,
		        attribution: "Mapbox",
		        noWrap: true
		      });
	fonds_carto["Light"] = 	L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckadl6ni406ou1irtli71fwll/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
		        tileSize: 512,
		    	maxZoom: 20,
		    	zoomOffset: -1,
		        attribution: "Mapbox",
		        noWrap: true
		      });
    fonds_carto["Open Street Map"] = L.tileLayer("http://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png", {
			    attribution: \'&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors\'
			});
	fonds_carto["Open Street Map 2"] = L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
			    attribution: \'&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors\'
			});
	fonds_carto["Opentopo Map"] = L.tileLayer("https://c.tile.opentopomap.org/{z}/{x}/{y}.png", {
			    attribution: "&copy; OpenStreetMap contributors, SRTM | map style:  OpenTopoMap (CC-BY-SA)"
			});

    fonds_carto["Outdoors"].addTo(map)
	L.control.layers(fonds_carto).addTo(map);
    

    L.NewMarkerControl = L.Control.extend({

        options: {
            position: "topleft"
        },

        onAdd: function (map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Nouveau point";
            link.innerHTML = "&#128842;";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function () {
                        map.editTools.startMarker();
                      });

            return container;
        }
    });


    L.NewLineControl = L.Control.extend({

        options: {
            position: "topleft"
        },

        onAdd: function (map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Nouveau trac";
            //link.innerHTML = "&#9736;";
            link.innerHTML = "/\\\\/";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function () {
                        map.editTools.startPolyline();
                      });

            return container;
        }
    });

    L.NewPolygonControl = L.Control.extend({

        options: {
            position: "topleft"
        },

        onAdd: function (map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Nouveau polygone";
            link.innerHTML = "&#9186;";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function () {
                        map.editTools.startPolygon();
                      });

            return container;
        }
    });

    map.addControl(new L.NewMarkerControl());
    map.addControl(new L.NewLineControl());
    map.addControl(new L.NewPolygonControl());

    /*var deleteShape = function (e) {
      if ((e.originalEvent.ctrlKey || e.originalEvent.metaKey) && this.editEnabled()) this.editor.deleteShapeAt(e.latlng);
    };*/

    var processMarker = function (e) {
        // Shift : suppression
        if ((e.originalEvent.shiftKey) && this.editEnabled()) {
            map.editTools.featuresLayer.eachLayer(function(layer) {
                if (layer._leaflet_id === e.target._leaflet_id) {
                    map.editTools.featuresLayer.removeLayer(layer);
                }
            });
        }
    }

    var processPolygon = function (e) {
        // Shift : suppression  - Alt : trou
        if ((e.originalEvent.shiftKey) && this.editEnabled()) this.editor.deleteShapeAt(e.latlng);
        if ((e.originalEvent.altKey) && this.editEnabled()) this.editor.newHole(e.latlng);;
    };

    var processPolyline = function (e) {
        // Shift : suppression
        if ((e.originalEvent.shiftKey) && this.editEnabled()) this.editor.deleteShapeAt(e.latlng);
    };

    var toggleEditPoly = function (e) {
        if (typeof e.target.setStyle != "undefined") {
            e.target.toggleEdit();
            if (e.target.editEnabled()) {
                e.target.setStyle({color: "#3388ff"});
            }
            else {
                e.target.setStyle({color: couleur_noedit});
            }
        }
    }

    var edit_icon = L.Icon.extend({
        options :{
      		iconUrl:       "javascripts/leaflet/images/marker-icon.png",
      		shadowUrl:     "javascripts/leaflet/images/marker-shadow.png",
      		iconSize:    [25, 41],
      		iconAnchor:  [12, 41],
      		popupAnchor: [1, -34],
      		tooltipAnchor: [16, -28],
      		shadowSize:  [41, 41]
        }
  	});
    var noedit_icon = L.Icon.extend({
        options :{
      		iconUrl:       "javascripts/leaflet/images/marker-icon-noedit.png",
      		shadowUrl:     "javascripts/leaflet/images/marker-shadow.png",
      		iconSize:    [25, 41],
      		iconAnchor:  [12, 41],
      		popupAnchor: [1, -34],
      		tooltipAnchor: [16, -28],
      		shadowSize:  [41, 41]
        }
  	});

    var toggleEditMarker = function (e) {
        if (typeof e.target.options.icon.options.className == "undefined") { //seul moyen que j\'ai trouv pour diffrencier Marker et PolyX sur le PREMIER double clic !
            e.target.toggleEdit();
            if (e.target.editEnabled()) {
                e.target.setIcon(new edit_icon);
            }
            else {
                e.target.setIcon(new noedit_icon);
            }
        }
    }

    map.on("layeradd", function (e) {
        //if (e.layer instanceof L.Path) e.layer.on("click", L.DomEvent.stop).on("click", deleteShape, e.layer);
        if (e.layer instanceof L.Marker) e.layer.on("click", L.DomEvent.stop).on("click", processMarker, e.layer);
        if (e.layer instanceof L.Polygon) e.layer.on("click", L.DomEvent.stop).on("click", processPolygon, e.layer);
        if (e.layer instanceof L.Polyline && !(e.layer instanceof L.Polygon)) e.layer.on("click", L.DomEvent.stop).on("click", processPolyline, e.layer);

        if (e.layer instanceof L.Path) e.layer.on("dblclick", L.DomEvent.stop).on("dblclick", toggleEditPoly, e.layer);
        if (e.layer instanceof L.Marker) e.layer.on("dblclick", L.DomEvent.stop).on("dblclick", toggleEditMarker, e.layer);

    });

    map.on("editable:vertex:ctrlclick editable:vertex:metakeyclick", function (e) {
        //Command - Control : continuer la ligne
        e.vertex.continue();
    });

    map.on("dblclick", function (e) {
        L.DomEvent.preventDefault(e.originalEvent); 
    });

    var controlFL = L.Control.fileLayerLoad({
        // Allows you to use a customized version of L.geoJson.
        // For example if you are using the Proj4Leaflet leaflet plugin,
        // you can pass L.Proj.geoJson and load the files into the
        // L.Proj.GeoJson instead of the L.geoJson.
        layer: L.geoJson,
        // See http://leafletjs.com/reference.html#geojson-options
        layerOptions: {style: {color: couleur_noedit}},
        // Add to map after loading (default: true) ?
        addToMap: false,
        // File size limit in kb (default: 1024) ?
        fileSizeLimit: 1024,
        // Restrict accepted file formats (default: .geojson, .json, .kml, and .gpx) ?
        /*formats: [
            ".geojson",
            ".kml"
        ]*/
    }).addTo(map);

    controlFL.loader.on("data:loaded", function (event) {
        event.layer.eachLayer(function(layer) {
            if (layer.feature.geometry.type == "Point") {
                layer.setIcon(new noedit_icon);
            }
            layer.addTo(map.editTools.featuresLayer);
        });

        // Add to map layer switcher
        //layerswitcher.addOverlay(event.layer, event.filename);
    });


    L.NewSendCartoControl = L.Control.extend({
        options: {
            position: "bottomleft"
        },

        onAdd: function(map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Valider";
            link.innerHTML = "&#10004;";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function (e) {
                          getAllShapes();
                      });

            return container;
        }
    });
    map.addControl(new L.NewSendCartoControl());
    
    function getAllShapes() {
        
        //var geom = map.editTools.featuresLayer.toGeoJSON(); // non utilisable car l\'diteur conserve des features sans coordonnes -> il faut contrler individuellement!!!

        var geom = {
            "type": "FeatureCollection",
            "features": []
        };

        map.editTools.featuresLayer.eachLayer(function(layer) {
            //affiche les coords des objets nouvellement crs en liminant ceux qui ont t supprims
            var forme = layer.toGeoJSON();

            /*if (forme.geometry.type == "Point" || forme.geometry.type == "LineString" || forme.geometry.type == "Polygon") { // non utilisable car l\'diteur conserve des features sans coordonnes -> il faut contrler individuellement!!!
               geom.features.push(forme);
            }*/

            if (forme.geometry.type == "Point") {
                //console.log(forme.geometry.type);
                //console.log(forme);
                geom.features.push(forme);
            }
            if (forme.geometry.type == "LineString") {
                if (forme.geometry.coordinates.length > 0) {
                    //console.log(forme.geometry.type);
                    //console.log(forme);
                    geom.features.push(forme);
                }
            }
            if (forme.geometry.type == "Polygon") {
                if (forme.geometry.coordinates[0].length > 1) {
                    //console.log(forme.geometry.type);
                    //console.log(forme);
                    geom.features.push(forme);
                }
            }
        });

        //console.log(geom);

        setCarto(geom);
    }

    L.NewCloseEditorControl = L.Control.extend({
        options: {
            position: "bottomleft"
        },

        onAdd: function(map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Annuler";
            link.innerHTML = "&#10008;";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function (e) {
                          cancelCarto();
                      });

            return container;
        }
    });
    map.addControl(new L.NewCloseEditorControl());

    L.NewHelpEditorControl = L.Control.extend({
        options: {
            position: "bottomleft"
        },

        onAdd: function(map) {
            var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
                link = L.DomUtil.create("a", "", container);

            link.href = "#";
            link.title = "Aide";
            link.innerHTML = "&#65533;";
            L.DomEvent.on(link, "click", L.DomEvent.stop)
                      .on(link, "click", function (e) {
                            var aide = " Manipulation des objets :\n";
                            aide += " - double clic : bascule edition/statique\n";
                            aide += " - shift clic : suppression si mode dition actif\n";
                            aide += " - contrle/commande clic : ajout de point sur extrmit du trac\n";
                            aide += " - alt clic : trou dans polygone";
                            alert(aide);
                      });

            return container;
        }
    });
    map.addControl(new L.NewHelpEditorControl());



    /* import donnes */
    var zones = window.parent.getCarto();
    if (zones != null) {
        var geom_init = L.geoJSON(zones, {
    		style: function (feature) {
    			return {
    	            color: couleur_noedit,
    	        };
    		},
    		pointToLayer: function(feature, latlng) {
                var markericon = new noedit_icon;
                return L.marker(latlng, {icon: markericon});
            },
            onEachFeature : function (feature, layer) {
                layer.addTo(map.editTools.featuresLayer);
            }
    	});
        map.fitBounds(geom_init.getBounds());
    }
</script>
';
		
        $sortie .= '
	</body>
</html>';
        
        $sortie = utf8_encode($sortie);
		return $sortie;
	}
	
	function process_sdp() {
		global $onglet, $action, $page, $module_name, $Id, $ok;
		global $itineraire, $site;
		
		if (!isset($onglet) || $onglet == "") {
			$onglet = "itineraire";
		}
		
		if (!isset($action) || $action == "") {
			$action = "list_itineraire";
		}
		
		if (!isset($page) || $page == "") {
			$page = "1";
		}
		
		if( !isset($Id) || $Id == "" ) {
			$id = "-1";
		}
		
		$sortie = "";
		$operationOnglet = "";
		
		if( !(isset($itineraire['en_travaux'])) ) {
			$itineraire['en_travaux'] = "0";
		}
		
		switch ($action) {
			case "list_itineraire":
				$sortie .= listItineraires($page);
				$operationOnglet = _SDPLISTITINERAIRE;
				break;
			case "add_itineraire":
			case "edit_itineraire":
				$sortie .= edit_itineraire($Id);
				$operationOnglet = _SDPEDITFICHEITINERAIRE;
				break;
			case "save_itineraire":
				if (save_itineraire($itineraire)) {
					header("Location: system.php?action=list_itineraire&op=sdp&onglet=itineraire&page=".$page);
				} else {
					$sortie = '<div align="center">&nbsp;<br /><b>'._SDPNOTSAVED.'</b><br />&nbsp;</div>';
					$sortie .= edit_itineraire("", $itineraire);
					$operationOnglet = _SDPEDITFICHEITINERAIRE;
				}
				break;
			case "delete_itineraire":
				$sortie .= deleteItineraire($Id, $ok);
				$operationOnglet = _SDPDELETEFICHEITINERAIRE;
				break;
			case "list_site":
				$sortie .= listSites($page);
				$operationOnglet = _SDPLISTSITE;
				break;
			case "add_site":
			case "edit_site":
				$sortie .= edit_site($Id);
				$operationOnglet = _SDPEDITFICHESITE;
				break;
			case "save_site":
				if (save_site($site)) {
					header("Location: system.php?action=list_site&op=sdp&onglet=site&page=".$page);
				} else {
					$sortie = '<div align="center">&nbsp;<br /><b>'._SDPNOTSAVED.'</b><br />&nbsp;</div>';
					$sortie .= edit_site("", $site);
					$operationOnglet = _SDPEDITFICHESITE;
				}
				break;
			case "delete_site":
				$sortie .= deleteSite($Id, $ok);
				$operationOnglet = _SDPDELETEFICHESITE;
				break;
			case "edit_carto":
			    $sortie = edit_carto();
				header('Content-Type: text/html; charset=utf-8');
				echo $sortie;
				die();
				break;
		}
		
		$ongletDef = array("itineraire"=> array( "text"=>_SDPONGLETLISTITINERAIRE, "url"=>"system.php?action=list_itineraire&op=sdp&onglet=itineraire"),
				"site"=> array( "text"=>_SDPONGLETLISTSITE, "url"=>"system.php?action=list_site&op=sdp&onglet=site"));
		
		include("system/header_system.php");
		echo '<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css" />';
		GraphicAdmin(_SDPMODULE);
		OpenOngletTable();
		displayOngletBar($onglet, $operationOnglet, $ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}
	
	switch ($op) {
		case "sdp":
			process_sdp();
			break;
	}
} else {
	display_denied();
}
?>