//<![CDATA[
function decodeLine(encoded) {
    var len = encoded.length;
    var index = 0;
    var array = [];
    var lat = 0;
    var lng = 0;
    try
    {
        while (index < len) {
            var b;
            var shift = 0;
            var result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lat += dlat;

            shift = 0;
            result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lng += dlng;

            array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
        }
    } catch(ex)
    {
    	alert("error " + ex);
        //error in encoding.
    }
    return array;
}

var ZOOM_MAX = 22;
var altZoomList = [ // Altitude <-> Zoom level
                    30000000, 24000000, 18000000, 10000000, 4000000, 1900000, 1100000, 550000, 280000,
                    170000, 82000, 38000, 19000, 9200, 4300, 2000, 990, 570, 280, 100, 36, 12, 0 ];

function ZoomToAlt(zoom) {
    return altZoomList[zoom < 0 ? 0 : zoom > 21 ? 21 : zoom];
}

/*function zoomMapToEarth(level) {
	return (591657550.500000 / 2^(level-1)) / 1000000;
}*/

function getEarth(id, idItineraire) {
	if (GBrowserIsCompatible()) {
		if (cartes == null) {
			cartes = GetXMLSymbols(id, idItineraire);
		}
		var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML, "carte");
		var zoomclic = eval(getXMLvalue(racine_carte, "zoomclic"));
		var zoominit = eval(getXMLvalue(racine_carte, "zoominit"));
		latitudeinit = eval(getXMLvalue(racine_carte, "latitudeinit"));
		longitudeinit = eval(getXMLvalue(racine_carte, "longitudeinit"));
		options["print"] = eval(getXMLvalue(racine_carte, "option_print") == "1");
		options["bulle"] = getXMLvalue(racine_carte, "option_bulles");
		options["bordure"] = eval(getXMLvalue(racine_carte, "option_bordure") == "1");
		options["polygones"] = eval(getXMLvalue(racine_carte,
				"option_polygones") == "1");
		options["lieux"] = eval(getXMLvalue(racine_carte, "option_pictos") == "1");
		options["obs"] = eval(getXMLvalue(racine_carte, "option_legende") == "1");
		options["type_map"] = getXMLvalue(racine_carte, "option_type_map");
		options["mini_vue"] = eval(getXMLvalue(racine_carte, "option_mini_map") == "1");
		options["titre"] = eval(getXMLvalue(racine_carte, "option_titre") == "1");
		options["commentaire"] = eval(getXMLvalue(racine_carte,
				"option_commentaire") == "1");
		options["seuil_texte"] = eval(getXMLvalue(racine_carte,
				"option_seuil_texte"));
		options["controles"] = eval(getXMLvalue(racine_carte,
				"option_controles") == "1");
		taille_hv = getXMLvalue(racine_carte, "option_taille");
		var sep_taille = new RegExp("[/]+", "g");
		var map_hv = String(taille_hv).split(sep_taille);
		options["map_h"] = String(map_hv[0]) + "px";
		options["map_v"] = String(map_hv[1]) + "px";
		options["zoom_min"] = eval(getXMLvalue(racine_carte, "option_zoom_min"));
		options["zoom_max"] = eval(getXMLvalue(racine_carte, "option_zoom_max"));
		
		var divMap = document.getElementById(id_div_map);
		if( divMap == null )
			return false;
		var reg_taille = new RegExp("([0-9]+)([/]+)([0-9])+", "g");
		if (String(taille_hv).match(reg_taille)) {
			divMap.style.width = options["map_h"];
			divMap.style.height = options["map_v"];
		}
		
		earth.getOptions().setFlyToSpeed(0.2);
		
		var lookAt = earth.createLookAt('');
		lookAt.setLatitude(latitudeinit);
		lookAt.setLongitude(longitudeinit);
		lookAt.setRange(ZoomToAlt(zoominit));
		lookAt.setAltitudeMode(earth.ALTITUDE_ABSOLUTE);
		earth.getView().setAbstractView(lookAt);
		
		function createMarker(point, message, commentaire, chemicone, fiche, target) {
			var placemark = earth.createPlacemark('');
			
			var style = earth.createStyle('');
			
			var icon = earth.createIcon('');
			icon.setHref(options["http_host"] + chemicone);
			
			style.getIconStyle().setIcon(icon);
			placemark.setStyleSelector(style);
			
			placemark.setGeometry(point);
	
			if (options["bulle"] != "") {
				var saut = new RegExp("(\n|\r)", "g");
				commentaire = commentaire.replace(saut, "<br />");
				google.earth.addEventListener(placemark, 'click', function() {
					var cont_mess = "";
					if (fiche != "") {
						if (message != "") {
							var link_mess = "<p class=\"linkalert\"><a href=\"" + fiche + "\" target=\"" + target
										+ "\">Pour en savoir plus...</a></p></div>";
						}
					} else {
						if (message != "") {
							var link_mess = "";
						}
					}
					cont_mess = "<div class=\"illustalert\"><img src=\"" + chemicone
							+ "\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"
							+ message
							+ "</h1><p class=\"messalert\">"
							+ commentaire
							+ "</p>"
							+ link_mess
							+ "</div>";
					
					// Affichage du texte
					var balloon = earth.createHtmlStringBalloon('');
					balloon.setFeature(placemark);
					balloon.setContentString(cont_mess);
					earth.setBalloon(balloon);
				});
			}
			return placemark;
		}
		
		function afficheLieux() {
			var points = getXMLchild(racine_carte, "points");
			if (points != null) {
				var point_courant = getXMLchild(points, "point");
				while (point_courant) {
					var point = earth.createPoint('');
					point.setLatitude(eval(getXMLvalue(point_courant, "latitude")));
					point.setLongitude(eval(getXMLvalue(point_courant, "longitude")));
					var message = getXMLvalue(point_courant, "lieu");
					var chemicone = getXMLvalue(point_courant, "picto");
					var commentaire = getXMLvalue(point_courant, "commentaire_point");
					var fiche = getXMLvalue(point_courant, "lien");
					var target = getXMLvalue(point_courant, "cible");
					var tempMark = createMarker(point, message, commentaire, chemicone, fiche, target);
					if (tempMark != null) {
						earth.getFeatures().appendChild(tempMark);
					}
					point_courant = next_sibling(point_courant);
				}
			}
		}
		
		function createZonePolygon(points, couleur, epaisseur, opacite,
				visibilite, plein, fiche, target) {
			var opacite = ((opacite * 100) * 255) / 100;
			opacite = Math.round(opacite);
			opacite = opacite.toString(16);
			if( opacite == "0" ) opacite = "00";
			
			couleur = couleur.substr(1);
			var r = couleur.substr(0, 2);
			var g = couleur.substr(2, 2);
			var b = couleur.substr(4, 2);
			
			couleur = b + g + r;
			
			var polygonPlacemark = earth.createPlacemark('');
			var polygon = earth.createPolygon('');
			polygonPlacemark.setGeometry(polygon);
			var outer = earth.createLinearRing('');
			polygon.setOuterBoundary(outer);
			
			var coords = outer.getCoordinates();
	
			for( var i = 0; i < points.length; i++ ) {
				coords.pushLatLngAlt(points[i].lat(), points[i].lng(), 0);
			}
			
			epaisseur *= 2;
			
			polygonPlacemark.setStyleSelector(earth.createStyle(''));
			var lineStyle = polygonPlacemark.getStyleSelector().getLineStyle();
			lineStyle.setWidth(epaisseur);
			
			var polyStyle = polygonPlacemark.getStyleSelector().getPolyStyle();
			polyStyle.setOutline(true);
			
			if( plein == "1" ) {
				polyStyle.setFill(true);
				lineStyle.getColor().set("ff" + couleur);
				polyStyle.getColor().set(opacite + couleur);
			} else {
				polyStyle.setFill(false);
				lineStyle.getColor().set(opacite + couleur);
			}
			
			if (fiche != "" && plein == "1") {
				google.earth.addEventListener(polygonPlacemark, 'click', function() {
					if (target == "") {
						window.location.href = fiche;
					} else {
						window.open(fiche, target, '');
					}
				});
			}
			
			return polygonPlacemark;
		}
		
		function createZoneLine(points, couleur, epaisseur, opacite,
				visibilite, plein, fiche, target) {
			var opacite = ((opacite * 100) * 255) / 100;
			opacite = Math.round(opacite);
			opacite = opacite.toString(16);
			if( opacite == "0" ) opacite = "00";
			
			couleur = couleur.substr(1);
			var r = couleur.substr(0, 2);
			var g = couleur.substr(2, 2);
			var b = couleur.substr(4, 2);
			
			couleur = b + g + r;
			
			epaisseur *= 2;
			
			var polygonPlacemark = earth.createPlacemark('');
			var lineString = earth.createLineString('');
			polygonPlacemark.setGeometry(lineString);
			
			var coords = lineString.getCoordinates();
	
			for( var i = 0; i < points.length; i++ ) {
				coords.pushLatLngAlt(points[i].lat(), points[i].lng(), 0);
			}
			
			polygonPlacemark.setStyleSelector(earth.createStyle(''));
			var lineStyle = polygonPlacemark.getStyleSelector().getLineStyle();
			lineStyle.setWidth(epaisseur);
			lineStyle.getColor().set(opacite + couleur);
			
			return polygonPlacemark;
		}
		
		function afficherPolygones() {
			var polygones = getXMLchild(racine_carte, "polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones, "polygone");
				while (polygone_courant) {
					var couleur = getXMLvalue(polygone_courant, "couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant, "epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant, "opacite"));
					var points = getXMLvalue(polygone_courant, "polyencode");
					var visibilite = getXMLvalue(polygone_courant, "polyvisibilite");
					var fiche = getXMLvalue(polygone_courant, "lien_polygone");
					var target = getXMLvalue(polygone_courant, "cible_polygone");
					var plein = getXMLvalue(polygone_courant, "plein");
					var array_points = decodeLine(points);
					var tempZone = null;
					if( array_points.length > 1 && array_points[0].equals(array_points[array_points.length-1]) ) {
						tempZone = createZonePolygon(array_points, couleur,
								epaisseur, opacite, visibilite, plein, fiche,
								target);
					} else {
						tempZone = createZoneLine(array_points, couleur,
								epaisseur, opacite, visibilite, plein, fiche,
								target);
					}
					if (tempZone != null) {
						earth.getFeatures().appendChild(tempZone);
					}
					polygone_courant = next_sibling(polygone_courant);
				}
			}
		}
		
		var style = null;
		
		function createSite(point, lieu, chemicone, id, image, en_travaux) {
			var placemark = earth.createPlacemark('placemark' + id);
	
			var icon = earth.createIcon('');
			icon.setHref(options["http_host"] + chemicone);
			
			if( !style ) {
				style = earth.createStyle('stylePlacemark');
			}
			style.getIconStyle().setIcon(icon); //apply the icon to the style
			placemark.setStyleSelector(style);
	
			placemark.setGeometry(point);
			
			if( en_travaux == "0" ) {
				google.earth.addEventListener(placemark, 'click', function() {
					var balloon = earth.createHtmlStringBalloon('');
					balloon.setFeature(placemark); // optional
					var cont_mess = "";
					if( options["rewrite"] ) {
						var lien_lieu = lieu;
						lien_lieu = lien_lieu.substring(0, 128);
						lien_lieu = lien_lieu.replace(/ /g, "-");
						lien_lieu = escape(lien_lieu);
						var url = options["lienSite"].replace("<!--nom-->", lien_lieu);
						url = url.replace("<!--id-->", id);
					} else {
						var url = options["lienSite"].replace("<!--id-->", id);
					}
					url = encodeURI(url);
					var link_mess = '<p><a href="' + url + '"><img src="' + options["icon_plus_infos"] + '" alt="Pour en savoir plus..." /></a></p>';
					var image_mess = "";
					if( image != "" ) {
						image_mess = '<div align="center"><img src="' + image + '" width="100px" alt="" /></div>';
					}
					cont_mess = image_mess + '<div><p>' + lieu + '</p>' + link_mess + '</div>';
					balloon.setContentString(cont_mess);
					earth.setBalloon(balloon);
				});
			}
			return placemark;
		}
		
		function afficheSites() {
			var points = getXMLchild(racine_carte, "symboles");
			if (points != null) {
				var point_courant = getXMLchild(points, "symbole");
				
				if( !point_courant ) {
					//document.getElementById('message_itineraire').innerHTML = "Aucun site associ�";
					alert("Aucun site associé a vos critères de recherche");
				}
				var nbPoint = 0;
				while (point_courant) {
					var point = earth.createPoint('');
					point.setLatitude(eval(getXMLvalue(point_courant, "latitude_symb")));
					point.setLongitude(eval(getXMLvalue(point_courant, "longitude_symb")));
					var id = getXMLparam(point_courant, "id_symb");
					var lieu = getXMLvalue(point_courant, "lieu_symb");
					var chemicone = getXMLvalue(point_courant, "picto_symb");
					var image = getXMLvalue(point_courant, "image_symb");
					var en_travaux = getXMLvalue(point_courant, "en_travaux_symb");
					var tempMark = createSite(point, lieu, chemicone, id, image, en_travaux);
					if (tempMark != null) {
						//arrayPlacemark.push(earthEx.dom.buildPointPlacemark([point.getLatitude(), point.getLongitude()]));
						arrayPlacemark.push(tempMark);
						//earth.getFeatures().appendChild(tempMark);
					}
					point_courant = next_sibling(point_courant);
					nbPoint++;
				}
			}
			return nbPoint;
		}
		
		/**
		 * Permet de zommer en fonction de la latitude et longitude (min|max) des points
		 */
		function zoomCarte(nbPoints) {
			var symb_min_max = getXMLchild(racine_carte, "symbole_max_min");
			if( symb_min_max != null ) {
				var lat_max = getXMLvalue(symb_min_max, "max_lat_symb");
				var lat_min = getXMLvalue(symb_min_max, "min_lat_symb");
				var long_max = getXMLvalue(symb_min_max, "max_long_symb");
				var long_min = getXMLvalue(symb_min_max, "min_long_symb");
                
                var latitudezonemin = lat_min;
                var latitudezonemax = lat_max;
                var longitudezonemin = long_min;
                var longitudezonemax = long_max;
                
                var domPlacemark = [];
                for(var i = 0; i < arrayPlacemark.length; i++) {
                	domPlacemark.push(earthEx.dom.buildPlacemark(arrayPlacemark[i]));
                }
                
                var folder = earthEx.dom.addFolder(domPlacemark);
                var bounds = earthEx.dom.computeBounds(folder);
                earthEx.view.setToBoundsView(bounds, { aspectRatio: 1, defaultRange: 200 });
			}
		}
		
		if (options["polygones"]) {
			afficherPolygones();
		}
		if (options["lieux"]) {
			//afficheTextes();
			afficheLieux();
		}
		nbPoints = afficheSites();
		zoomCarte(nbPoints);
		initTour();
	} else {
		alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre � jour.");
	}
}

function createKmlTour() {
	var kml = '<?xml version="1.0" encoding="UTF-8"?>';
	kml += '<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2">';
	kml += '<gx:Tour>';
	kml += '<name>Play me!</name>';
	kml += '<gx:Playlist>';
	
	for(var i = 0; i < arrayPlacemark.length; i++) {
		kml += '<gx:FlyTo>';
		kml += '<gx:duration>5.0</gx:duration>';
		kml += '<Camera>';
		kml += '<longitude>' + arrayPlacemark[i].getGeometry().getLongitude() + '</longitude>';
		kml += '<latitude>' + arrayPlacemark[i].getGeometry().getLatitude() + '</latitude>';
		kml += '<altitude>60</altitude>';
		
		if( i+1 < arrayPlacemark.length ) {
			var x = arrayPlacemark[i+1].getGeometry().getLatitude() - arrayPlacemark[i].getGeometry().getLatitude();
			var y = arrayPlacemark[i+1].getGeometry().getLongitude() - arrayPlacemark[i].getGeometry().getLongitude();
			var a = Math.atan(y/x);
			a *= 180 / Math.PI; 
			if (x < 0) a += 180;
			else if (y < 0) a += 360;
			kml += '<heading>' + a + '</heading>';
		}
		
		kml += '<tilt>40</tilt>';
		kml += '<altitudeMode>relativeToGround</altitudeMode>';
		kml += '</Camera>';
		kml += '</gx:FlyTo>';
		kml += '<gx:Wait>';
		kml += '<gx:duration>1.0</gx:duration>';
		kml += '</gx:Wait>';
	}
	kml += '</gx:Playlist>';
	kml += '</gx:Tour>';
	kml += '</kml>';
	return kml;
}

function initTour() {
	var kml = createKmlTour();
	var object = earth.parseKml(kml);
	if( object.getType() == 'KmlTour' ) {
		tour= object;
	}
}

function enterTour() {
    if (!tour) {
       alert('No tour found!');
       return;
    }
    earth.getTourPlayer().setTour(tour);
}

function playTour() {
	earth.getTourPlayer().play();
 }
 function pauseTour() {
	 earth.getTourPlayer().pause();
 }
 function resetTour() {
	 earth.getTourPlayer().reset();
 }
 function exitTour() {
	 earth.getTourPlayer().setTour(null);
 }
	
function init() {
	google.earth.createInstance('map3d', initCB, failureCB);
}

function initCB(instance) {
	earth = instance;
	earth.getWindow().setVisibility(true);
	
	// add a navigation control
	earth.getNavigationControl().setVisibility(earth.VISIBILITY_AUTO);
	
	// add some layers
	earth.getLayerRoot().enableLayerById(earth.LAYER_BORDERS, true);
	//earth.getLayerRoot().enableLayerById(earth.LAYER_ROADS, true);
		  
	/*var lookAt = earth.createLookAt('');
	lookAt.setLatitude(42);
	lookAt.setLongitude(9);
	lookAt.setRange(150000.0);
	earth.getView().setAbstractView(lookAt);*/
	earthEx = new GEarthExtensions(earth);
	getEarth(options["id_carte"], options["id_itineraire"]);
}

function failureCB(errorCode) {
}

function GetXMLSymbols(id, idItineraire) {
	var sortie = "";
	var param = "";
	
	if (id != null && id != "") {
		param += "&Idc=" + id;
	}
	
	if(idItineraire != null && idItineraire != "") {
		param += "&idItineraire=" + idItineraire;
	}
	
	var sources_cartes = "modules.php?name=sdp&sop=map_pict_XML_fiche_itineraire" + param;
	var cartes = GetAJAXData(sources_cartes);
	return cartes;
}

function pointSuivant() {
	if( indexPoint+1 < arrayPlacemark.length ) {
		indexPoint++;
		var point = arrayPlacemark[indexPoint].getGeometry();
		var camera = earth.getView().copyAsCamera(earth.ALTITUDE_RELATIVE_TO_GROUND);
		camera.setLatitude(point.getLatitude());
		camera.setLongitude(point.getLongitude());
		camera.setAltitude(60);
		earth.getView().setAbstractView(camera);
	}
}

function pointPrecedent() {
	if( indexPoint-1 >= 0 ) {
		indexPoint--;
		var point = arrayPlacemark[indexPoint].getGeometry();
		var camera = earth.getView().copyAsCamera(earth.ALTITUDE_RELATIVE_TO_GROUND);
		camera.setLatitude(point.getLatitude());
		camera.setLongitude(point.getLongitude());
		camera.setAltitude(60);
		earth.getView().setAbstractView(camera);
	}
}

google.load("earth", "1", {"other_params":"sensor=false"});
google.setOnLoadCallback(init);
var id_div_map = "map3d";
var earth = null;
var cartes = null;
var zoomMax = 12;
var arrayPlacemark = [];
var earthEx = null;
var tour = null;
var indexPoint = -1;
//]]>