<?php
/**
* Classes d'accs  la base de donnes pour la gestion des petites annonces.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleAnnonce
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleAnnonce
*/
class BD_cbnc_data {
	var $My_SQL = array();
	
	function BD_cbnc_data() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["users"] = $prefix."_users";
		$this->My_SQL["data"] = $prefix."_cbnc_observations";
	}
	
	/*
	 * CREATE TABLE `becms_cbnc_observations` (
`Id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`nom_latin` VARCHAR( 200 ) NOT NULL ,
`nom_francais` VARCHAR( 200 ) NOT NULL ,
`nom_corse` VARCHAR( 200 ) NOT NULL ,
`date_obs` DATE NOT NULL ,
`id_observateur` INT NOT NULL ,
`commune` VARCHAR( 100 ) NOT NULL ,
`lieu_dit` VARCHAR( 100 ) NOT NULL ,
`latitude` DECIMAL( 15, 12 ) NOT NULL ,
`longitude` DECIMAL( 15, 12 ) NOT NULL ,
`altitude` INT NOT NULL ,
`milieu` TEXT NOT NULL ,
`population` INT NOT NULL ,
`especes_compagnes` TEXT NOT NULL ,
`phenologie` VARCHAR( 100 ) NOT NULL ,
`valide` TINYINT NOT NULL DEFAULT '0',
`niveau` TINYINT NOT NULL ,
INDEX ( `nom_latin` , `nom_francais` , `nom_corse` , `date_obs` , `id_observateur` , `commune` , `latitude` , `longitude` , `valide` , `niveau` )
) TYPE = MYISAM CHARACTER SET latin1 COLLATE latin1_general_ci COMMENT = 'Contient les fiches d''observation pour le CBNC';
	 */

	function saveObs($obs) {
		$db=$this->My_SQL["maBase"];
		$obs = array_map(array('utilFuncs_cbnc_data', 'conditionnertodb'), $obs);
		$list_champs = "";
		$list_valeurs = "";
		if ($obs["Id"] == "-1") {
			foreach($obs as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["data"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($obs as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["data"]."` SET ".$list_champs." WHERE `Id` = '".$obs["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
	
	
	function get_id_new_obs() {
		$db=$this->My_SQL["maBase"];
		return $db->sql_nextid();
	}
	
	function getObs($the_type="files", $Id="",$valide="", $espece ="", $zone=array(), $limit="", $niveau="") {
		$db=$this->My_SQL["maBase"];	
		$obss = array();
		$cond = "";
		if ($Id != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`".$this->My_SQL["data"]."`.`Id`='".$Id."'";
		}
		if ($valide != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`".$this->My_SQL["data"]."`.`valide`='".$valide."'";
		}
		if ($niveau != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`".$this->My_SQL["data"]."`.`niveau`<='".$niveau."'";
		}
		if ($the_type == "files") {
			$oderby = " ORDER BY `".$this->My_SQL["data"]."`.`date_obs` DESC";
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["data"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($obss, $ligneCourante);
				}
			}
			return $obss;
		}
		else {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["data"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
	function delObs($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["data"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}

}	
?>