<?php
/**
 * Fonctions publique d'interface entre le CMS et le module de gestion des clients.
 *
 * Ces fonctions sont publiques.
 * @package becmsSimpleClient
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (preg_match("#connector_lib.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }
global $language, $module_name;
require_once 'modules/'.$module_name.'/system/language/lang-'.$language.'.php';
//require_once("lib_db.php");



class obsconnector {
	
	function getObsTEXT() {
		$sgbd = new BD_cbnc_data();
		$obss = $sgbd->getObs("files","","1");

		$dataTEXT = "";
		$dataTEXT .= "Espce";
		$dataTEXT .= "\t"."Date";
		$dataTEXT .= "\t"."Observateur";
		$dataTEXT .= "\t"."Lieu";
		$dataTEXT .= "\t"."Latitude";
		$dataTEXT .= "\t"."Longitude";
		$dataTEXT .= "\t"."Milieu";
		$dataTEXT .= "\t"."Population";
		$dataTEXT .= "\t"."Phnologie";
		$dataTEXT .= "\n";
		foreach($obss as $obs) {
			$nom = $obs["nom_latin"];
			$nom .= ($obs["nom_francais"] != "" && $nom != "") ? "/".$obs["nom_francais"] : $obs["nom_francais"];
			$nom .= ($obs["nom_corse"] != "" && $nom != "") ? "/".$obs["nom_corse"] : $obs["nom_corse"];
			$dataTEXT .= $nom;
			$dataTEXT .= "\t".utilFuncs_cbnc_data::date2JMA($obs["date_obs"]);
			$dataTEXT .= "\t".$obs["nom_observateur"];
			$lieu = $obs["commune"];
			$lieu .= ($obs["lieu_dit"] != "" && $lieu != "") ? "/".$obs["lieu_dit"] : $obs["lieu_dit"];
			$dataTEXT .= "\t".$lieu;
			$dataTEXT .= "\t".$obs["latitude"];
			$dataTEXT .= "\t".$obs["longitude"];
			$dataTEXT .= "\t".str_replace("\n"," - ",str_replace("\r","",$obs["milieu"]));
			$dataTEXT .= "\t".$obs["population"];
			$dataTEXT .= "\t".$obs["phenologie"];
			
			$dataTEXT .= "\n";
		}
		return $dataTEXT;
	}

	/**
	 * Renvoie l'intgralit des clients enregistrs sous forme de rfrence  un fichier Excel binaire.
	 *
	 * @return string Texte contenant la liste des clients trouvs.
	 */
	function getObsEXCEL() {
		$sgbd = new BD_cbnc_data();
		$obss = $sgbd->getObs("files","","1");

		set_time_limit(10);

		require_once "php_writeexcel/class.writeexcel_workbook.inc.php";
		require_once "php_writeexcel/class.writeexcel_worksheet.inc.php";
		$fname = tempnam("/tmp", "Export.xls");
		$workbook = new writeexcel_workbook($fname);
		$worksheet =& $workbook->addworksheet('Clients');
		$worksheet->set_column('A:I', 32);
//		$worksheet->set_column('A:B', 32);
//		$worksheet->set_column('I:I', 32);
		$entete  =& $workbook->addformat(array(
		font		=> 'Arial',
		bg_color	=> 'grey',
		bold    => 1,
		color   => 'white',
		size    => 12,
		merge   => 1,
		bold    => 1
		));
		$donnee  =& $workbook->addformat(array(
		font		=> 'Arial',
		bold    => 0,
		color   => 'black',
		size    => 10,
		merge   => 1,
		text_h_align => 0,
		num_format => '@'
		));

		
		$texte = array("Espce","Date","Observateur","Lieu","Latitude","Longitude","Milieu","Population","Phnologie");
		$worksheet->write_row('A1', $texte, $entete);

		$compteur = 2;
		foreach($obss as $obs) {
			$nom = $obs["nom_latin"];
			$nom .= ($obs["nom_francais"] != "" && $nom != "") ? "/".$obs["nom_francais"] : $obs["nom_francais"];
			$nom .= ($obs["nom_corse"] != "" && $nom != "") ? "/".$obs["nom_corse"] : $obs["nom_corse"];
			$lieu = $obs["commune"];
			$lieu .= ($obs["lieu_dit"] != "" && $lieu != "") ? "/".$obs["lieu_dit"] : $obs["lieu_dit"];
			
			$texte = array(
			$nom,
			utilFuncs_cbnc_data::date2JMA($obs["date_obs"]),
			$obs["nom_observateur"],
			$lieu,
			$obs["latitude"],
			$obs["longitude"],
			str_replace("\n"," - ",str_replace("\r","",$obs["milieu"])),
			$obs["population"],
			$obs["phenologie"]
			);
			$worksheet->write_row('A'.$compteur, $texte, $donnee);
			//$worksheet->write_string('C'.$compteur, $client["codepostal"], $donnee);
			$compteur++;
		}
		$workbook->close();
		return $fname;
	}
}

?>