<?php
global $prefix, $db, $nukeurl, $currentlang;
global $sql_create_table_temp, $module_name;

require_once ("modules/$module_name/system/params.php");
require_once ("modules/$module_name/system/functions.php");
require_once ("modules/$module_name/system/xmlparser.php");

require_once ("core/becms_mainlib_lib.php");

$nomsFichiers = dezip_file($url_serie_kmz);
$fichier_source = $dirtemp.$nomsFichiers[0];

global $serie, $contentTag;
global $bool_placemark, $bool_style;

$contentTag = "";
$serie = array();
$bool_placemark = false;
$style = array();
$bool_style = false;
$bool_multigeom = false;
$content_multigeom = "";

$sortie_result = "";

if (file_exists ( $fichier_source )) {
	$sortie_result .= "begin parsing : " . $fichier_source;
	if (! empty_data_file ( $fichier_source )) {
		viderDbSerie();
		parse_file ( $fichier_source, "openTagSerie", "closeTagSerie", "contentTagSerie" );
		viderDbSerieStyle();
		parse_file ( $fichier_source, "openTagStyle", "closeTagStyle", "contentTagStyle" );
	}
	$sortie_result .=  "end parsing : " . $fichier_source;
	unlink($fichier_source);
}

/*
function openTagSerie($parseur, $nomBalise, $tableauAttributs) {
	global $bool_placemark;
	global $contentTag;
	
	$contentTag = "";
	
	if ($nomBalise == strtoupper ( "Placemark" )) {
		$bool_placemark = true;
	} 
}

function closeTagSerie($parseur, $nomBalise) {
	global $serie, $bool_placemark;
	global $rub_serie;
	global $contentTag;
	
	if ($bool_placemark) {
		if ($contentTag != "" && isset ($rub_serie [$nomBalise])) {
			if ($rub_serie [$nomBalise] == "id_style") {
				$contentTag = str_replace("#", "", $contentTag);
			}
			$serie[$rub_serie[$nomBalise]] .= convertToDB($contentTag);
		}
	} 
	if ($bool_placemark && $nomBalise == strtoupper ("Placemark")) {
		$bool_placemark = false;
		//traiter la description avant l'enregistrement
		$valeursplusserie = parse_description($serie[$rub_serie["DESCRIPTION"]]);
		foreach ($valeursplusserie as $key=>$value) {
			$serie[$key] = $value;
		}
		$valeursplusserie = array();
		
		//print_r($serie);
		//print_r($valeursplusserie);
		//echo "\n------------------------------------------------------------------------------------\n";
		echo "Enregistrement ".$serie["nom"]."\n";
		$result = saveDbSerie($serie);
		if ($result === false) {
			echo "====================================> Erreur";
		}
		
		//array_splice ($serie, 0, count ($serie));
		$serie = array();
	}
}

function contentTagSerie($parseur, $texte) {
	global $bool_placemark;
	global $contentTag;
	if ($bool_placemark) {
		$contentTag .= $texte;
	}
}

function openTagStyle($parseur, $nomBalise, $tableauAttributs) {
	global $bool_style;
	global $contentTag;
	global $style;
	global $rubstyle;
	
	
	if ($bool_style) {
		$contentTag .= '<'.$nomBalise.'>';
	}
	else {
		$contentTag = "";
	}
	
	if ($nomBalise == strtoupper ( "Style" )) {
		$bool_style = true;
		$contentTag = "";
		$style[$rubstyle["ID"]] = $tableauAttributs["ID"];
	}
	
}

function closeTagStyle($parseur, $nomBalise) {
	global $style, $bool_style;
	global $contentTag;
	global $rubstyle;
	
	if ($bool_style) {
		if ($nomBalise == strtoupper ( "Style" )) {
			$style[$rubstyle["CONTENT"]] = trim($contentTag);
			$bool_style = false;
			
			echo "Enregistrement ".$style["id_style"]."\n";
			$result = saveDbSerieStyle($style);
			if ($result === false) {
				echo "====================================> Erreur";
			}
			//print_r($style);
			$style = array();
		}
		else {
			$contentTag .= '</'.$nomBalise.'>';
		}
	}
}

function contentTagStyle($parseur, $texte) {
	global $bool_style;
	global $contentTag;
	if ($bool_style) {
		$contentTag .= $texte;
	}
}

function parse_description($texte = "") {
	global $rub_suppl_serie;
	//on parse le tableau HTML sous forme de titre/valeur
	$sortie = array();
	foreach ($rub_suppl_serie as $label=>$valeur) {
		if (preg_match("#<td>".$label."</td>[^<]*<td>([^<]*)</td>#ims", $texte,$matches)) {
			$sortie[$valeur] = $matches[1];
		}
	}
	return $sortie;
}*/

function openTagSerie($parseur, $nomBalise, $tableauAttributs) {
	global $bool_placemark, $bool_multigeom;
	global $contentTag, $content_multigeom;
	
	$contentTag = "";
	
	if ($nomBalise == "Placemark") {
		$bool_placemark = true;
	}
	if ($bool_multigeom) {
		$content_multigeom .= '<'.$nomBalise.'>';
	}
	else {
		$content_multigeom = "";
	}
	if ($nomBalise == "MultiGeometry") {
		$bool_multigeom = true;
	} 
}

function closeTagSerie($parseur, $nomBalise) {
	global $serie, $bool_placemark, $bool_multigeom;
	global $rub_serie;
	global $contentTag, $content_multigeom;
	global $sortie_result;
	
	if ($bool_placemark) {
		if ($contentTag != "" && isset ($rub_serie [$nomBalise])) {
			if ($rub_serie [$nomBalise] == "id_style") {
				$contentTag = str_replace("#", "", $contentTag);
			}
			$serie[$rub_serie[$nomBalise]] .= convertToDB($contentTag);
		}
	} 
	if ($bool_placemark && $nomBalise == "Placemark") {
		$bool_placemark = false;
		//traiter la description avant l'enregistrement
		$valeursplusserie = parse_description($serie[$rub_serie["description"]]);
		foreach ($valeursplusserie as $key=>$value) {
			$serie[$key] = $value;
		}
		$valeursplusserie = array();
		
		//print_r($serie);
		//print_r($valeursplusserie);
		//echo "\n------------------------------------------------------------------------------------\n";
		$sortie_result .=  "Enregistrement ".$serie["nom"]."\n";
		$result = saveDbSerie($serie);
		if ($result === false) {
			$sortie_result .=  "====================================> Erreur";
		}
		
		//array_splice ($serie, 0, count ($serie));
		$serie = array();
	}
	if ($bool_multigeom) {
		if ($nomBalise == "MultiGeometry") {
			$serie[$rub_serie["$nomBalise"]] = trim($content_multigeom);
			$bool_multigeom = false;
		}
		else {
			$content_multigeom .= '</'.$nomBalise.'>';
		}
	}
}

function contentTagSerie($parseur, $texte) {
	global $bool_placemark, $bool_multigeom;
	global $contentTag, $content_multigeom;
	if ($bool_placemark) {
		$contentTag .= $texte;
	}
	if ($bool_multigeom) {
		$content_multigeom .= $texte;
	}
}

function openTagStyle($parseur, $nomBalise, $tableauAttributs) {
	global $bool_style;
	global $contentTag;
	global $style;
	global $rubstyle;
	
	
	if ($bool_style) {
		$contentTag .= '<'.$nomBalise.'>';
	}
	else {
		$contentTag = "";
	}
	
	if ($nomBalise ==  "Style") {
		$bool_style = true;
		$contentTag = "";
		$style[$rubstyle["id"]] = $tableauAttributs["id"];
	}
}

function closeTagStyle($parseur, $nomBalise) {
	global $style, $bool_style;
	global $contentTag;
	global $rubstyle;
	global $sortie_result;
	
	if ($bool_style) {
		if ($nomBalise == "Style") {
			$style[$rubstyle["content"]] = trim($contentTag);
			$bool_style = false;
			
			$sortie_result .=  "Enregistrement ".$style["id_style"]."\n";
			$result = saveDbSerieStyle($style);
			if ($result === false) {
				$sortie_result .=  "====================================> Erreur";
			}
			//print_r($style);
			$style = array();
		}
		else {
			$contentTag .= '</'.$nomBalise.'>';
		}
	}
}

function contentTagStyle($parseur, $texte) {
	global $bool_style;
	global $contentTag;
	if ($bool_style) {
		$contentTag .= $texte;
	}
}

function parse_description($texte = "") {
	global $rub_suppl_serie;
	//on parse le tableau HTML sous forme de titre/valeur
	$sortie = array();
	foreach ($rub_suppl_serie as $label=>$valeur) {
		if (preg_match("#<td>".$label."</td>[^<]*<td>([^<]*)</td>#ims", $texte,$matches)) {
			$sortie[$valeur] = $matches[1];
		}
	}
	return $sortie;
}
?>