<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   									*/
/* Baliste "Catalogue Metier" Module . Stephan ACQUATELLA 2007		*/
/* Project: Environmental Corsican Observatory       		  	*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/**
* @package catalogueMetier
* @version 1.0
* @author Stephan Acquatella <stephan@balistis.com>
* @copyright Copyright  2006, Stephan Acquatella
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/


// Init Part
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

//require_once("core/mainfile.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

/**
 * main function called per default
 *
 */
function main($search_theme,$search_cat, $search_metacat,$level, $sty="" ){
echo "<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>";
include ('header.php');
$mycontent="<script type=\"text/javascript\"> var ol_width = 600;</script>";
$mycontent.="<SCRIPT language=\"JavaScript\" src=\"javascripts/overlib.js\"></SCRIPT>\n";
echo $mycontent;

echo '<h1>'._CM_TITLE.'</h1>';


echo "<div align=\"center\">";	
echo '<fieldset><legend>'._CM_SUBTITLE.'</legend>';
searchHeader($search_theme,$search_cat,$search_metacat, $level);
echo '</fieldset>';
echo "</div>";
echo "<div align=\"center\">";
//listCategory($search_theme,$search_cat, $level, $sty);
listMetacategory($search_theme,$search_cat, $search_metacat, $level, $sty );
echo "</div>";
echo "</div>";
$bardef=array("back"=>"javascript:window.history.back()");
buttonBar ($bardef);
echo "</div>";
include ('footer.php');
} 
/**
* searchHeader ()
* display search header
* @param
* @return
* @see
*/
function searchHeader($search_theme,$search_cat,$search_metacat, $level) {
global $sitename, $prefix, $db, $module_name;

// -------- Ajax Need --------------
echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/glm-ajax.js\"></SCRIPT>\n";
echo "<SCRIPT language=\"JavaScript\" src=\"modules/$module_name/js/lib_metier.js\"></SCRIPT>\n";


echo "<div id=\"cm_search\">";
echo "<form id=\"cm_search_form\" action=\"modules.php?name=$module_name\" method=\"POST\">";
echo "<input type=\"hidden\" name=\"op\" value=\"\">";
//echo "<input type=\"hidden\" name=\"sty\" id=\"sty\" value=\"One\">";
// -- menu --- 
/*echo "<div class=cm_header_menu>";
//echo "<a class=\"cm_menuItem\" href=\"index.php\">"._CM_GOHOME."</a>";
echo _CM_OVERLINK."\n";
echo "</div>";*/
// -- 
echo "<table><tr>";
echo "<td class=\"label\"><p>"._CM_METACATEGORY."</p></td><td><select id=\"search_metacat_id\" name=\"search_metacat\" class=\"saisiepub\" onChange=\"getSelectContent2(this);\">";
$result=$db->sql_query("SELECT id , nom FROM ".$prefix."_metier_metacat");
echo "<option value=\"0\">"._CM_ALL_METACAT."</option>";
while(list($id,  $nom) = $db->sql_fetchrow($result)) {
	$isSelected = "";
	if ($id == $search_metacat) $isSelected="selected=\"selected\"";
	echo "<option value=\"$id\" $isSelected>$nom</option>";
}
echo "</select></td>";
echo "</tr><tr>";

$defaultAjaxCode2="<select id=\"search_cat_id\" name=\"search_cat\" class=\"saisiepub\" onChange=\"getSelectContent(this);\">";
if (empty($search_metacat)) $search_metacat=0;
if ($search_metacat==0) {
	$defaultAjaxCode2.= "<option value=\"$idMetier_Cat\" $isSelected >"._CM_ALL_CAT."</option>";
} 
else {
	$result=$db->sql_query("SELECT idMetier_Cat , Cat_nom FROM ".$prefix."_metier_cat WHERE id_metacat='$search_metacat'");
	$defaultAjaxCode2 .=  "<option value=\"0\">"._CM_ALL_CAT."</option>";
	while(list($idMetier_Cat,  $Cat_nom) = $db->sql_fetchrow($result)) {
		$isSelected = "";
		if ($idMetier_Cat == $search_cat) $isSelected="selected=\"selected\"";
		$defaultAjaxCode2 .= "<option value=\"$idMetier_Cat\" $isSelected>$Cat_nom</option>";
	}
}
$defaultAjaxCode2.="</select>";
echo "<td class=\"label\"><p>"._CM_CATEGORY."</p></td><td>";
echo "<div id=\"AjaxContent2\">";
echo $defaultAjaxCode2;
echo "</div>";
echo "</td>";
echo "</tr><tr>";


$defaultAjaxCode="<select id=\"search_theme_id\" name=\"search_theme\" class=\"saisiepub\">";
if (empty($search_cat)) $search_cat=0;

if ($search_cat==0) {
	$defaultAjaxCode.= "<option value=\"$idMetier_Theme\" $isSelected >"._CM_ALL_THEME."</option>";
} else {
	$defaultAjaxCode .=  "<option value=\"0\">"._CM_ALL_THEME."</option>";
	$result=$db->sql_query("SELECT idMetier_Theme, Theme_nom, Cat_id FROM ".$prefix."_metier_theme WHERE Cat_id='$search_cat'");
	while(list($idMetier_Theme,  $Theme_nom) = $db->sql_fetchrow($result)) {
		$isSelected = "";
		if ($idMetier_Theme == $search_theme) $isSelected="selected=\"selected\"";
		$defaultAjaxCode.= "<option value=\"$idMetier_Theme\" $isSelected >$Theme_nom</option>";
	}
}
$defaultAjaxCode.="</select>";
echo "<td class=\"label\"><p>"._CM_THEME."</p></td><td>";
echo "<div id=\"AjaxContent\">";
	echo $defaultAjaxCode;
echo "</div></td>";
echo "</tr><tr>";
echo "<td class=\"label\"><p style=\"text-align: left\">"._CM_TRAINING_LEVEL."</p></td><td><ul class=\"cm_search_levelUl\">";
$result=$db->sql_query("SELECT idMetier_Niveaux, Niveau_nom ,Niveau_descri FROM ".$prefix."_metier_niveaux WHERE Niveau_type='0' ");
 while(list($idMetier_Niveaux,  $Niveau_nom , $Niveau_descri) = $db->sql_fetchrow($result)) {
 	if ($Niveau_descri!=""){
 	$popupinfo="onmouseover=\"return overlib('".fixJSQuotes($Niveau_descri)."',WIDTH, 150, CENTER);\" onmouseout=\"return nd()\" ";
 	} else { $popupinfo="";}
 	$isSelected = "";
	if ($idMetier_Niveaux == $level) $isSelected="checked=\"checked\"";
 	echo "<li><div class=\"cm_radio\" $popupinfo ><label for=\"level_id$idMetier_Niveaux\">$Niveau_nom</label><br><input class=\"cm_bradio\" id=\"level_id$idMetier_Niveaux\" name=\"level\" value=\"$idMetier_Niveaux\" type=\"radio\" $isSelected></li></div>";
 }
$isSelected = ""; 
if ($level == -1) $isSelected=" checked=\"checked\"";
echo "<li><div class=\"cm_radio_alllevel\"><label for=\"level_id\">"._CM_ALLLEVEL."</label><br><input class=\"cm_bradio\"  id=\"level_id\" name=\"level\" value=\"-1\" type=\"radio\" $isSelected></li></div>"; 
echo "</ul>";
echo "</td>";
echo "</tr></table>";

echo "<br />";
echo '<input type="button" value="'._CM_SUBMIT.'" onclick="cm_search_form.submit()">';
echo '&nbsp;&nbsp;&nbsp;&nbsp;';
echo '<input type="button" value="'._CM_CLEAN.'" onclick="initSearch()">';

/*echo "<img src=\"".getTextImage2("brecherche.gif","",false)."\" onclick=\"cm_search_form.submit()\" alt=\""._CM_SUBMIT."\" title=\""._CM_SUBMIT."\">"; 
echo "<img src=\"".getTextImage2("binitital.gif","",false)."\" onclick=\"initSearch()\" alt=\""._CM_CLEAN."\" title=\""._CM_CLEAN."\">";*/

echo "</form></div>\n";
}

function listMetacategory($search_theme,$search_cat, $search_metacat, $level, $sty, $sortBy=1 ) {
	global $sitename, $prefix, $db, $module_name;
	$count=0;
	if (isset($search_metacat)&&($search_metacat!=0)) {
		$where=" WHERE id='$search_metacat'";
	}
	$result=$db->sql_query("SELECT id , nom FROM ".$prefix."_metier_metacat $where" );
	while(list($id,  $nom ) = $db->sql_fetchrow($result)) {
		echo "<h2>$nom</h2>";
		listCategory($search_theme,$search_cat, $id, $level, $sty, $sortBy=1 );
	}
}

/**
* listCategory()
* display category list
* @param sortBy : data sorted by competence or organism type
* @return
* @see
*/
function listCategory($search_theme,$search_cat, $search_metacat, $level, $sty, $sortBy=1 ) {
	global $sitename, $prefix, $db, $module_name;
	$count=0;
	if (isset($search_cat)&&($search_cat!=0)) {
		$where=" WHERE idMetier_Cat='$search_cat'";
	}
	if (isset($search_metacat) && ($search_metacat!=0)) {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= " id_metacat='$search_metacat'";
	}

	$result=$db->sql_query("SELECT idMetier_Cat , Cat_nom, Cat_img FROM ".$prefix."_metier_cat $where" );

	while(list($idMetier_Cat,  $Cat_nom, $Cat_img) = $db->sql_fetchrow($result)) {
		/*if ($Cat_img=="") {
		 $theCatimg=getTextImage2("defaultCat.png","");
		}
		else {
		 $theCatimg="<img src=\"$Cat_img\" border=0>";
		}*/
		echo "<table class=\"cm_list_category\"><tr>\n";
		//echo "<td class=\"cm_imgcat\">$theCatimg</td>\n";
		echo "<td><h3>$Cat_nom</h3>";
		echo listTheme($idMetier_Cat, $search_theme, $search_metacat, $level, $sty);
		echo "</td>";
		echo "</tr>";
		echo "</table>\n";
		$count++;
	}
}
/**
* listTheme()
* display list of existinf theme for a category
* @param int category id
* @return
* @see
*/
function listTheme($catId, $search_theme,$metacatid, $level, $sty) {
	global  $prefix, $db, $module_name;
	if (isset($search_theme)&&($search_theme!=0)) {
		$thessql="SELECT idMetier_Theme, Theme_nom, Cat_id FROM ".$prefix."_metier_theme WHERE idMetier_Theme='$search_theme'";
	}
	else {
		$thessql="SELECT idMetier_Theme, Theme_nom, Cat_id FROM ".$prefix."_metier_theme WHERE Cat_id='$catId'";
	}
	$result=$db->sql_query($thessql);
	$thelist="";
	$count=0;
	$thelist.= "<ul class=\"cm_list_theme\">\n";
	while(list($idMetier_Theme,  $Theme_nom) = $db->sql_fetchrow($result)) {
		$themeLink="modules.php?name=$module_name&search_theme=$idMetier_Theme&search_cat=$catId&search_metacat=$metacatid&sty=$sty&level=-1";
		$thelist.= "<li><a href=\"$themeLink\">$Theme_nom</a> \n".listWork($idMetier_Theme, $level, $sty)."</li>";
		$count++;
	}
	$thelist.= "</ul>\n";
	if ($count==0) $thelist="";
	return $thelist;
}
/**
* listLevel()
* list existing level
* @param
* @return
* @see
*/
function listLevel($MetierTheme_id) {

}
/**
 * listWork()
 * list work for a specified theme
 * @param integer theme ID
 *
 *
 */
function listWork($MetierTheme_id, $level, $sty){
global $sitename, $prefix, $db, $module_name;
$result=$db->sql_query("SELECT idMetier_Fiche, Fiche_nom, Fiche_descri FROM ".$prefix."_metier_fiche WHERE MetierTheme_id='$MetierTheme_id'");
$thelist="";
$count=0;
$thelist.= "<ul class=\"cm_list_work\">\n";
while(list($idMetier_Fiche, $Fiche_nom, $Fiche_descri) = $db->sql_fetchrow($result)) {
	if ((!empty($level)) && ($level <> -1)){
		$resultLevel=$db->sql_query("SELECT niveau_id FROM ".$prefix."_metier_liste_niveaux where metier_id='$idMetier_Fiche'");
		list($niveau_id)=$db->sql_fetchrow($resultLevel);
	} 
	if ((!empty($level)) && (($level == $niveau_id) || ( $level== -1))){	
	$thelist.= "<li><a href=\"modules.php?name=catalogueMetier&sop=viewWork&idwork=$idMetier_Fiche&sty=$sty\" >$Fiche_nom</a></li>";	
	$count++;
	}
}
$thelist.= "</ul>\n";
if ($count == 0) $thelist="";
return $thelist;
}


function activelinks($texte) {
	$texte = preg_replace("#(http://\S+)#im", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $texte);
	$texte = preg_replace("#^([^/]*)(www\S+)#im", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $texte);
	return $texte;
}
/**
* viewTrade()
* view Trade data
* @param integer workID 
* @return
* @see
*/
function viewTrade($idwork, $sty="") {
global $sitename, $prefix, $db, $admin, $module_name;
include ('header.php');
// not clean. have to change css file 
if ($sty=="") {$thestyle="cm_ficheguidemetierprotect"; $colorFrise=""; $backicone="retourorange.gif";}
if ($sty=="One"){ $thestyle="cm_ficheguidemetierprev"; $colorFrise="bleu"; $backicone="retourbleu.gif";}
if ($sty=="Two"){ $thestyle="cm_ficheguidemetieramen"; $colorFrise="vert"; $backicone="retourvert.gif";}
$result = $db->sql_query("select idMetier_Fiche,MetierCat_id,MetierTheme_id,Fiche_nom,Fiche_descri,Fiche_admission,Fiche_corse_Dipl_1,Fiche_corse_Dipl_2,Fiche_corse_Dipl_3,Fiche_corse_Dipl_4,Fiche_corse_lieu_1,Fiche_corse_lieu_2,Fiche_corse_lieu_3,Fiche_corse_lieu_4,Fiche_Dipl_1,Fiche_Dipl_2,Fiche_Dipl_3,Fiche_Dipl_4,Savoir_1,Savoir_2,Fiche_type, Fiche_image from ".$prefix."_metier_fiche where idMetier_Fiche='$idwork'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
list($idMetier_Fiche,$MetierCat_id,$MetierTheme_id,$Fiche_nom,$Fiche_descri,$Fiche_admission,$Fiche_corse_Dipl_1,$Fiche_corse_Dipl_2,$Fiche_corse_Dipl_3,$Fiche_corse_Dipl_4,$Fiche_corse_lieu_1,$Fiche_corse_lieu_2,$Fiche_corse_lieu_3,$Fiche_corse_lieu_4,$Fiche_Dipl_1,$Fiche_Dipl_2,$Fiche_Dipl_3,$Fiche_Dipl_4,$Savoir_1,$Savoir_2,$Fiche_type, $Fiche_image)= $db->sql_fetchrow($result);
if ($Fiche_image==""){
	$theFicheImg=getTextImage2("defaut.jpg","",false);
} 
else {
	$theFicheImg=$Fiche_image;
}
// get theme name
$result3=$db->sql_query("SELECT Theme_nom FROM ".$prefix."_metier_theme WHERE idMetier_Theme='$MetierTheme_id'");
list($Theme_nom)=$db->sql_fetchrow($result3);
// get Niveaux
$result2 = $db->sql_query("select niveau_id from ".$prefix."_metier_liste_niveaux where metier_id='$idMetier_Fiche'");
	if (!$result2) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
$result3=$db->sql_query("SELECT Cat_nom FROM ".$prefix."_metier_cat WHERE idMetier_Cat='$MetierCat_id'");
list($Cat_nom)=$db->sql_fetchrow($result3);
$count=1;
$prefOr="";
while(list($niveau_id) = $db->sql_fetchrow($result2)) {
	    if ($count > 1) $prefOr=""._OR;
	    $Stlevel.= $prefOr." ".$niveau_id;
	    $count++;
	    }
	    
	    //activation des liens
	    
	    
echo '<h1>'._CM_TITLE.'</h1>';
echo '<h2 style="text-transform: uppercase;padding-top: 5px; height: 23px;_height:28px">'.$Fiche_nom.'</h2>';

echo "<div class=\"cm_chapitre\">"
."<ul>"
."<li><a href=\"modules.php?name=catalogueMetier&search_cat=$MetierCat_id&sty=$sty\">$Cat_nom</a>"
."<ul>"
."<li><a href=\"modules.php?name=catalogueMetier&search_theme=$MetierTheme_id&search_cat=$MetierCat_id&sty=$sty&level=-1\">$Theme_nom</a></li>"
."</ul>"
."</li>"
."</ul>"
."</div>";

echo "<table class=\"cm_fiche\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
."<tbody>"
."<tr>"
."<td colspan=\"2\"><h3>Description</h3></td>"
."<td></td>"
."</tr>"
."<tr>"
."<td class=\"cm_cale1\"> </td>"
."<td class=\"cm_traitleft\" colspan=\"2\" valign=\"top\">"
."<img src=\"".$theFicheImg."\" alt=\"\" class=\"cm_illust\" border=\"0\" height=\"145\" width=\"198\">"
."<div class=\"cm_marge\">"
."      <p>".activelinks($Fiche_descri)."</p>"
."</div>"
."</td>"
."</tr>"
."</tbody>"
."</table>";



echo "<table class=\"cm_fiche\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
."  <tbody>"
."    <tr>"
."      <td  width=\"48%\"><h2>Niveau requis : $Stlevel</h2></td>"
."      <td width=\"4%\"> </td>"
."      <td width=\"48%\"><h2>Conditions d'admission</h2></td>"
."    </tr>"
."    <tr>"
."      <td valign=\"top\">"
."      <h2>Formation en corse</h2>";
if ($Fiche_corse_Dipl_1<>""){
	echo "<h3>Diplome pr&eacute;par&eacute; :</h3><ul>";

	echo "<li>".activelinks($Fiche_corse_Dipl_1).".<br>"
	."<b>O&ugrave; : ".activelinks($Fiche_corse_lieu_1)."</b>"
	."</li>";

	if ($Fiche_corse_Dipl_2<>""){
		echo "<li>".activelinks($Fiche_corse_Dipl_2).".<br>"
		."<b>O&ugrave; : ".activelinks($Fiche_corse_lieu_2)."</b>"
		."</li>";
	}
	if ($Fiche_corse_Dipl_3<>""){
		echo "<li>".activelinks($Fiche_corse_Dipl_3).".<br>"
		."<b>O&ugrave; : ".activelinks($Fiche_corse_lieu_3)."</b>"
		."</li>";
	}
	if ($Fiche_corse_Dipl_4<>""){
		echo "<li>".activelinks($Fiche_corse_Dipl_4).".<br>"
		."<b>O&ugrave; : ".activelinks($Fiche_corse_lieu_4)."</b>"
		."</li>";
	}
	echo "</ul>";
}
echo "      <div class=\"cm_horscorse\">"
."      <h2>Formation hors de corse</h2>"
."      <h3>Diplome pr&eacute;par&eacute; :</h3>";

if ($Fiche_Dipl_1<>"") {
	echo "<ul><li>".activelinks($Fiche_Dipl_1)."</li>";
	if ($Fiche_Dipl_2<>"") echo "<li>".activelinks($Fiche_Dipl_2)."</li>";
	if ($Fiche_Dipl_3<>"") echo " <li>".activelinks($Fiche_Dipl_3)."</li>";
	if ($Fiche_Dipl_4<>"") echo "<li>".activelinks($Fiche_Dipl_4)."</li>";
	echo "</ul>";
}
echo "      </div>"
."      </td>"
."      </td><td>"
."      <td class=\"cm_traitleft\" colspan=\"2\" valign=\"top\">"
."      <div class=\"cm_admission\">"
."      <p>".activelinks($Fiche_admission)." </p>"
."      </div>"
."      <div class=\"cm_asavoir\">"
."      <h2>A savoir</h2>"
."      <p>".activelinks($Savoir_1)."</p>"
."      <p>".activelinks($Savoir_2)."</p>"
."      </div>"
."      </td>"
."    </tr>"
."  </tbody>"
."</table>"
."</div>";
echo "</div>";
//adminEditButton("system.php?op=metierEdit&onglet=Metier&idMetier_Fiche=$idwork&editForm=1");
/*
 echo "<a href=\"modules.php?name=catalogueMetier&sop=printTrade&amp;idwork=$idwork&amp;sty=$sty\" target=\"_blanck\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\" width=\"18\" height=\"20\"></a>";
echo " <a href=\"modules.php?name=balisteEcmspdf&sop=viewMetier&amp;idwork=$idwork&pdfname=FicheMetier\"><img src=\"images/spacer.gif\" border=\"0\" Alt=\""._PDF."\" width=\"10\" height=\"10\"></a>";
*/
$bardef=array("back"=>"javascript:window.history.back()");
buttonBar ($bardef);

include ('footer.php');
}
/**
* printTrade($acid)
* format work page for an HTML print
* @param integer work id
* @param 
* @return
* @see
*/
function printTrade($idwork, $sty="",$ok=1) {
global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $module_name,$admin ;

$printPage="<html>"
 	."<head>"
 	."<title>$sitename</title>"
 	."<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n\n\n"
 	."</head>"
    ."<body bgcolor=\"#FFFFFF\" text=\"#000000\" >"
    ."<table border=\"0\"><tr><td>"
    ."<table border=\"0\" width=\"640\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>"
    ."<table border=\"0\" width=\"640\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>"
    ."<center>"
    ."<img src=\"images/$site_logo\" border=\"0\" alt=\"\"><br><br>"
    ."<font class=\"content\"> ";


// not clean. have to change css file 
if ($sty=="") {$thestyle="cm_ficheguidemetierprotect"; $colorFrise=""; $backicone="retourorange.gif";}
if ($sty=="One"){ $thestyle="cm_ficheguidemetierprev"; $colorFrise="bleu"; $backicone="retourbleu.gif";}
if ($sty=="Two"){ $thestyle="cm_ficheguidemetieramen"; $colorFrise="vert"; $backicone="retourvert.gif";}
$result = $db->sql_query("select idMetier_Fiche,MetierCat_id,MetierTheme_id,Fiche_nom,Fiche_descri,Fiche_admission,Fiche_corse_Dipl_1,Fiche_corse_Dipl_2,Fiche_corse_Dipl_3,Fiche_corse_Dipl_4,Fiche_corse_lieu_1,Fiche_corse_lieu_2,Fiche_corse_lieu_3,Fiche_corse_lieu_4,Fiche_Dipl_1,Fiche_Dipl_2,Fiche_Dipl_3,Fiche_Dipl_4,Savoir_1,Savoir_2,Fiche_type, Fiche_image from ".$prefix."_metier_fiche where idMetier_Fiche='$idwork'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
list($idMetier_Fiche,$MetierCat_id,$MetierTheme_id,$Fiche_nom,$Fiche_descri,$Fiche_admission,$Fiche_corse_Dipl_1,$Fiche_corse_Dipl_2,$Fiche_corse_Dipl_3,$Fiche_corse_Dipl_4,$Fiche_corse_lieu_1,$Fiche_corse_lieu_2,$Fiche_corse_lieu_3,$Fiche_corse_lieu_4,$Fiche_Dipl_1,$Fiche_Dipl_2,$Fiche_Dipl_3,$Fiche_Dipl_4,$Savoir_1,$Savoir_2,$Fiche_type, $Fiche_image)= $db->sql_fetchrow($result);
if ($Fiche_image==""){
	$theFicheImg=getTextImage2("defaut.jpg","",false);
} else {
	$theFicheImg=$Fiche_image;
}
// get theme name
$result3=$db->sql_query("SELECT Theme_nom FROM ".$prefix."_metier_theme WHERE idMetier_Theme='$MetierTheme_id'");
list($Theme_nom)=$db->sql_fetchrow($result3);
// get Niveaux
$result2 = $db->sql_query("select niveau_id from ".$prefix."_metier_liste_niveaux where metier_id='$idMetier_Fiche'");
	if (!$result2) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
$result3=$db->sql_query("SELECT Cat_nom FROM ".$prefix."_metier_cat WHERE idMetier_Cat='$MetierCat_id'");
list($Cat_nom)=$db->sql_fetchrow($result3);
$count=1;
$prefOr="";
while(list($niveau_id) = $db->sql_fetchrow($result2)) {
	    if ($count > 1) $prefOr=""._OR;
	    $Stlevel.= $prefOr." ".$niveau_id;
	    $count++;
	    }
$printPage.= "<div class=\"$thestyle\">"
//."<a href=\"javascript: history.go(-1)\" title=\""._CM_GOBACK."\">"
//."<img width=\"50\" height=\"16\" border=\"0\" align=\"right\" src=\"".getTextImage2("$backicone","",false)."\" alt=\"\"/></a>"
."<h1>$Fiche_nom</h1>";
// -- menu --- 
//$printPage.= "<div class=cm_header_menu>";
//echo "<a class=\"cm_menuItem\" href=\"index.php\">"._CM_GOHOME."</a>";
//echo "<a class=\"cm_menuItem\" href=\"modules.php?name=Search\">"._CM_GOSEARCH."</a>";
//$printPage.= _CM_OVERLINK."\n";
//$printPage.= "</div>";
$printPage.= "<div class=\"cm_chapitre\">"
."<ul>"
."<li><a href=\"modules.php?name=catalogueMetier&search_cat=$MetierCat_id&sty=$sty\">$Cat_nom</a>"
."<ul>"
."<li><a href=\"modules.php?name=catalogueMetier&search_theme=$MetierTheme_id&search_cat=$MetierCat_id&sty=$sty&level=-1\">$Theme_nom</a></li>"
."</ul>"
."</li>"
."</ul>"
."</div>"
."<div><img src=\"".getTextImage2("frise$colorFrise.gif","",false)."\" alt=\"\" border=\"0\" height=\"23\" width=\"257\"></div>"
."<table class=\"cm_fiche\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"584\">"
."<tbody>"
."<tr>"
."<td class=\"cm_titre\" colspan=\"2\">Description</td>"
."<td></td>"
."</tr>"
."<tr>"
."<td class=\"cm_cale1\"> </td>"
."<td class=\"cm_traitleft\" colspan=\"2\" valign=\"top\">"
."<img src=\"".$theFicheImg."\" alt=\"\" class=\"cm_illust\" border=\"0\" height=\"145\" width=\"198\">"
."<div class=\"cm_marge\">"
."      <p>$Fiche_descri</p>"
."</div>"
."</td>"
."</tr>"
."<tr>" 
."<td class=\"cm_cale1\"><img src=\"".getTextImage2("spacer.gif","",false)."\"  alt=\"\" border=\"0\" height=\"1\" width=\"15\"></td>"
."<td class=\"cm_traitleft\"><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"240\"></td>"
."<td><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"329\"></td>"
."</tr>"
."</tbody>"
."</table>"
."<table class=\"cm_fiche\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"456\">"
."  <tbody>"
."    <tr>"
."      <td class=\"cm_titre\">Niveau requis : $Stlevel</td>"
."      <td class=\"cm_traitsup\"> </td>"
."      <td class=\"cm_titre\">Conditions d'admission</td>"
."      <td> </td>"
."    </tr>"
."    <tr>"
."      <td colspan=\"2\" valign=\"top\">"
."<div class=\"cm_formcorse\"> <img src=\"".getTextImage2("chataigne$colorFrise.gif","",false)."\" class=\"cm_imgdroit\" border=\"0\" height=\"173\" width=\"60\">"
."      <h2>Formation en corse</h2>"
."      <ul>";
if ($Fiche_corse_Dipl_1<>""){
$printPage.= "<li>$Fiche_corse_Dipl_1.<br>"
	."<b>O&ugrave; : $Fiche_corse_lieu_1</b>"
	."</li>";
}
if ($Fiche_corse_Dipl_2<>""){
$printPage.= "<li>$Fiche_corse_Dipl_2.<br>"
	."<b>O&ugrave; : $Fiche_corse_lieu_2</b>"
	."</li>";
}
if ($Fiche_corse_Dipl_3<>""){
$printPage.= "<li>$Fiche_corse_Dipl_3.<br>"
	."<b>O&ugrave; : $Fiche_corse_lieu_3</b>"
	."</li>";
}
if ($Fiche_corse_Dipl_4<>""){
$printPage.= "<li>$Fiche_corse_Dipl_4.<br>"
	."<b>O&ugrave; : $Fiche_corse_lieu_4</b>"
	."</li>";
}
$printPage.= "</ul>"
."      </div>"
."      <div class=\"cm_horscorse\">"
."      <h2>Formation hors de corse</h2>"
."      <h3>Diplome pr&eacute;par&eacute; :</h3>"
."      <ul>";
if ($Fiche_Dipl_1<>"") $printPage.= "<li>$Fiche_Dipl_1</li>";
if ($Fiche_Dipl_2<>"") $printPage.= "<li>$Fiche_Dipl_2</li>";
if ($Fiche_Dipl_3<>"") $printPage.= " <li>$Fiche_Dipl_3</li>";
if ($Fiche_Dipl_4<>"") $printPage.= "<li>$Fiche_Dipl_4</li>";
$printPage.= "</ul>"
."      </div>"
."      </td>"
."      <td class=\"cm_traitleft\" colspan=\"2\" valign=\"top\">"
."      <div class=\"cm_admission\">"
."      <p>$Fiche_admission </p>"
."      </div>"
."      <div class=\"cm_asavoir\">"
."      <h2>A savoir</h2>"
."      <p>$Savoir_1</p>"
."      <p>$Savoir_2</p>"
."      </div>"
."      </td>"
."    </tr>"
."    <tr>"
."      <td><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"255\"></td>"
."      <td><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"37\"></td>"
."      <td><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"255\"></td>"
."      <td><img src=\"".getTextImage2("spacer.gif","",false)."\" alt=\"\" border=\"0\" height=\"1\" width=\"37\"></td>"
."    </tr>"
."  </tbody>"
."</table>"
."</div>";
$printPage.= " <br><center> 
    <font class=\"cm_print_footer\">
    "._COMESFROM." $sitename ::: 
    <a href=\"$nukeurl\">$nukeurl</a><br><br>
    </font></center>
    </td></tr></table>
    </body>
    </html>";

if ($ok) {
	echo $printPage;
}else{
	return $printPage;
}
}

/**
 * displayAlphabet()
 *
 * @param datatype paramname description
 * @return datatype description
 */
 function displayAlphabet($thelink){
 $acteurLink=$thelink."&myfilter=";

 $alpha= "<div align=right>"
 ."<a href=\"".$acteurLink."A\">A </a>"
 ."<a href=\"".$acteurLink."B\">B </a>"
 ."<a href=\"".$acteurLink."C\">C </a>"
 ."<a href=\"".$acteurLink."D\">D </a>"
 ."<a href=\"".$acteurLink."E\">E </a>"
 ."<a href=\"".$acteurLink."F\">F </a>"
 ."<a href=\"".$acteurLink."G\">G </a>"
 ."<a href=\"".$acteurLink."H\">H </a>"
 ."<a href=\"".$acteurLink."I\">I </a>"
 ."<a href=\"".$acteurLink."J\">J </a>"
 ."<a href=\"".$acteurLink."K\">K </a>"
 ."<a href=\"".$acteurLink."L\">L </a>"
 ."<a href=\"".$acteurLink."M\">M </a>"
 ."<a href=\"".$acteurLink."N\">N </a>"
 ."<a href=\"".$acteurLink."O\">O </a>"
 ."<a href=\"".$acteurLink."P\">P </a>"
 ."<a href=\"".$acteurLink."Q\">Q </a>"
 ."<a href=\"".$acteurLink."R\">R </a>"
 ."<a href=\"".$acteurLink."S\">S </a>"
 ."<a href=\"".$acteurLink."T\">T </a>"
 ."<a href=\"".$acteurLink."U\">U </a>"
 ."<a href=\"".$acteurLink."V\">V </a>"
 ."<a href=\"".$acteurLink."X\">X </a>"
 ."<a href=\"".$acteurLink."Y\">Y </a>"
 ."<a href=\"".$acteurLink."Z\">Z </a>"
 ."</div>";
 return $alpha;
 }

/**
 * getThemeselect()
 * return select code for Ajax call
 * 
 */
 function getThemeSelect($catId, $search_theme){
 global $db, $prefix; 
 $returnAjaxCode="<select id=\"search_theme_id\" name=\"search_theme\" class=\"saisiepub\">";
 if ($catId==0){
 	  // if all catagory selected return automaticaly all theme only
 	  $returnAjaxCode.="<option value=\"0\" selected >"._CM_ALL_THEME."</option>";
	} else {
    // build list for a selected category
    $returnAjaxCode.="<option value=\"0\" selected >"._CM_ALL_THEME."</option>";
 		$result=$db->sql_query("SELECT idMetier_Theme, Theme_nom, Cat_id FROM ".$prefix."_metier_theme WHERE Cat_id='$catId'");
 		while(list($idMetier_Theme,  $Theme_nom) = $db->sql_fetchrow($result)) {
			$isSelected = "";
			if ($idMetier_Theme == $search_theme) $isSelected="selected=\"selected\"";
				$returnAjaxCode.="<option value=\"$idMetier_Theme\" $isSelected >$Theme_nom</option>";
			}
		}
		$returnAjaxCode.= "</select>";
		$returnAjaxCode = utf8_encode($returnAjaxCode);
 		echo $returnAjaxCode;
 	}
 
function getCatSelect($id, $search_cat){
 global $db, $prefix; 
 $returnAjaxCode="<select id=\"search_cat_id\" name=\"search_cat\" class=\"saisiepub\" onChange=\"getSelectContent(this);\">";
 if ($id==0){
 	  // if all catagory selected return automaticaly all theme only
 	  $returnAjaxCode.="<option value=\"0\" selected >"._CM_ALL_CAT."</option>";
	} else {
    // build list for a selected category
    $returnAjaxCode.="<option value=\"0\" selected >"._CM_ALL_CAT."</option>";
 		$result=$db->sql_query("SELECT idMetier_Cat, Cat_nom, id_metacat FROM ".$prefix."_metier_cat WHERE id_metacat='$id'");
  		while(list($idMetier_Cat,  $Cat_nom) = $db->sql_fetchrow($result)) {
			$isSelected = "";
			if ($idMetier_Cat == $search_cat) $isSelected="selected=\"selected\"";
				$returnAjaxCode.="<option value=\"$idMetier_Cat\" $isSelected >$Cat_nom</option>";
			}
		}
		$returnAjaxCode.= "</select>";
		$returnAjaxCode = utf8_encode($returnAjaxCode);
 		echo $returnAjaxCode;
 	}

/**
 * fixJSQuotes
 * solve cote issue when a string is provided as javascript function parameter.
 * @param string text to clean
 * @return js clean code
 */
/*function fixJSQuotes($what = "") {
	$what = str_replace("'", "\'", $what);
    $what = str_replace('"', "&quot;", $what);
    return $what;
}*/

/**
 * getTextImage2()
 * Find an image by is name first in current theme, if image is not found find it in defaut module image folder (images/<modulename>/)
 * is no image is found display Text. Veri usefull for using img in translation file.
 * @param imageName like img.gif or img.jpg
 * @param text if image is not found.
 * @return string correct img html tag (<img src=..) if image is found else return text provided as parameter.
 */
function getTextImage2($myimg, $mytext, $tagOn=true){
global $Default_Theme,$name;
    $mythemeimgpath="themes/$Default_Theme/images/$myimg";
    $mydefaultimgpath="modules/$name/images/$myimg";
    if (!empty($myimg) && (file_exists($mythemeimgpath))) {
    	if ($tagOn) return "<img src=\"$mythemeimgpath\" border=0 alt=\"$mytext\" title=\"$mytext\" >";
    	else return $mythemeimgpath;
    } else if (!empty($myimg) && (file_exists($mydefaultimgpath))) {
    	if ($tagOn) return "<img src=\"$mydefaultimgpath\" border=0 alt=\"$mytext\" title=\"$mytext\" >";
    	else return $mydefaultimgpath;
    } else {
    	return $mytext;
    }
}


/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
switch($sop) {

    case "viewWork":
    viewTrade($idwork, $sty);
    break;
    
    case "getThemeSelect":
    getThemeSelect($catId, $search_theme);
    break;
    case "getCatSelect":
    getCatSelect($id,$search_cat);	
    	break;
    
    case "printTrade":
    printTrade($idwork, $sty ,$ok=1);
    break;    

    default:
    main($search_theme,$search_cat, $search_metacat, $level, $sty);
    break;
}

?>