<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */                                           
/*                                                                      */
/*   																	*/
/* Balsite "Annuaire de Acteur" Module . Stephan ACQUATELLA 2004		*/
/* Project: Environmental Corsican observatory       					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }


if (checkModuleRight("becmsOrgDirectory")) {
setPath(_TXT_Modules,0);
setPath(_ANNUAIRE_AC,1);
/************************** Onglet definition ***********************/
$ongletDef=array("acteur"=> array( "text"=>_ACTEUR,
                                   "url"=>"system.php?op=annuaireActeur&onglet=acteur"),
                 "contact"=> array( "text"=>_ACT_CONTACT,
                                   "url"=>"system.php?op=annuaireActeur&onglet=contact"),          
                 "competence"=> array( "text"=>_ACT_DOMAINE,
                                   "url"=>"system.php?op=annuaireActeur&onglet=competence"),
                 "status"=> array( "text"=>_ACT_STATUS,
                                   "url"=>"system.php?op=annuaireActeur&onglet=status"),
                 "type"=> array( "text"=>_ACT_TYPE,
                                   "url"=>"system.php?op=annuaireActeur&onglet=type"),
                 "import"=> array( "text"=>_ACT_IMPORT,
                                   "url"=>"system.php?op=annuaireActeur&onglet=import")
                                   );
/**
* annuaireActeur()
* Display list of exixting element trought tabs
* @param onglet need to be displayed
* @param acteur id
* @return
* @see
*/
function annuaireActeur($onglet, $editid, $editForm, $myfilter="",$myfiltertwo="") {
global $prefix, $db, $language, $multilingual,$ongletDef, $SkinPath, $db, $prefix, $op,$selectuser;
    include("system/header_system.php");
    GraphicAdmin(_ACTEURADMIN);
    $barDef=array(	"view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif","url"=>"","comment"=>_PREVIEW, "status"=>"ON"),
    					"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "url"=>"","comment"=>_EDIT, "status"=>"ON"),
  			      	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png", "url"=>"","comment"=>_DELETE,"status"=>"ON"));
    //$onglet="acteur";
    if (!isset($onglet)) {
	    $onglet=acteur;
	}
    switch ($onglet) {
	/* -----------------------------------------------------------------*/
	/*              List of All blocks									*/ 
	/* -----------------------------------------------------------------*/
	// ############################## ACTEUR ####################################
	  case "acteur":
	    $thefilter="";
	    if ($myfilter!="") 		$thefilter="WHERE type_acteur='$myfilter'";
	    if (( $myfiltertwo != "Other" ) && ( $myfiltertwo != "All" ) ) {
			$thefilter .= ($thefilter == "") ? " WHERE " : " AND ";
			$thefilter .= "nom_acteur LIKE '".$myfiltertwo."%'";
		} 
		else if ($myfiltertwo == "Other") {
			$thefilter .= ($thefilter == "") ? " WHERE " : " AND ";
			$thefilter .= "nom_acteur REGEXP \"^\[1-9]\"";
		}
	    if ($selectuser != "") {
	    		$thefilter .= ($thefilter == "") ? " WHERE" : " AND ";
	    		$thefilter .= " informant='".$selectuser."'";
	    }
	    OpenSysTable();
	    $result = $db->sql_query("select actid, nom_acteur, type_acteur, date_acteur, informant, pays_acteur from ".$prefix."_annuaireacteur_acteur $thefilter order by nom_acteur");
   
	if ($onglet=="") $onglet="sections"; 
	    OpenOngletTable();
		displayOngletBar("acteur",_ACTEURADMIN,$ongletDef);
		//displayAlphabet("system.php?op=annuaireActeur&onglet=acteur");

		$result2 = $db->sql_query("SELECT aid FROM ".$prefix."_authors ORDER BY aid ASC");
		$menuuser = "";
		if ($db->sql_numrows($result2) != 0) {
			$menuuser = '<select size="1" name="selectuser" onchange="this.form.submit()">';
			$menuuser .= '<option value="">'._ACTLISTEFILTERUSER."</option>";
			while (list($user) = $db->sql_fetchrow($result2)) {
				$selected = ($selectuser == $user) ? " selected=\"selected\"" : "";
				$menuuser .= '<option value="'.$user.'"'.$selected.'>'.$user."</option>";
			}
			$menuuser .= "</select>";
		}
		
		$filter = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		//$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter);
		//$sortie .= '</td><td width="30">&nbsp;</td><td>';
		$filter .= '<form name="formfilter" action="system.php" method="POST">';
		$filter .= '<input type="hidden" name="myfiltertwo" value="'.$myfiltertwo.'">';
		//$liste .= '<input type="hidden" name="page" value="'.$page.'">';
		$filter .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
		$filter .= '<input type="hidden" name="op" value="'.$op.'">';
		$filter .= $menuuser;
		$filter .= "</form>";
		$filter .= '</td><td width="30">&nbsp;</td><td style="padding: 10px 0 10px 0">';
		$filter .= displayAlphabet("system.php?op=annuaireActeur&onglet=acteur");
		$filter .= '</td></tr></table>';	
		echo $filter;
		
		
		echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader ><b>"._ACTEUR_NAME."</b></td>"
		."<td class=systemTabHeader ><b>"._COUNTRY_ACTEUR."</b></td>"
	    	."<td class=systemTabHeader align=\"center\"><b>"._ACTEUR_TYPE."</b></td>"
	    	."<td class=systemTabHeader align=\"center\"><b>"._ACTEUR_DATE."</b></td>"
		."<td class=systemTabHeader align=\"center\"><b>"._AUTHOR."</b></td>"
	    	."<td class=systemTabHeader align=\"center\"><b>"._FUNCTIONS."</b></td>"
	    	."</tr>";
		
		$pos=0;
		while(list($actid, $nom_acteur, $type_acteur, $date_acteur, $informant, $country) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){
				$thestyle="listTableOdd";
			}
			else {
				$thestyle="listTableNone";
			}
			$myresult = $db->sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
			list($type_organisme) = $db->sql_fetchrow($myresult);
			$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&myfilter=$actid\" >";
			echo "<tr class=\"$thestyle\">"
			."<td align=\"left\">$sectionLink $nom_acteur</a></td>"
			."<td align=\"center\">$country</a></td>"
			."<td align=\"center\">$type_organisme</td>"
			."<td align=\"center\">$date_acteur</td>"
			."<td align=\"center\">$informant</td>";
			echo "<td  nowrap align=\"center\">";
			$barDef["view"]["url"]="modules.php?name=becmsOrgDirectory&sop=viewActeur&actid=".$actid;
			$barDef["edit"]["url"]="system.php?op=acteurEdit&onglet=acteur&actid=$actid&editForm=1&myfiltertwo=$myfiltertwo&selectuser=$selectuser";
			$barDef["delete"]["url"]="system.php?op=acteurDelete&amp;actid=$actid&amp;ok=0&myfiltertwo=$myfiltertwo&selectuser=$selectuser";
			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";
			$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenSysTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un nouvel Acteur</a>";
	    
	    echo acteurEdit($editid,$editForm,1);
		
		CloseSysTable();
	    
	    
      break;
      // ############################## CONTACT ####################################
      case "contact":
        
        $thefilter="";
	    if ($myfilter!="") 		$thefilter=" WHERE acteur_actid='$myfilter'";
	    if (( $myfiltertwo != "Other" ) && ( $myfiltertwo != "All" ) ) {
			$thefilter .= ($thefilter == "") ? " WHERE " : " AND ";
			$thefilter .= "nom_contact LIKE '".$myfiltertwo."%'";
		} 
		else if ($myfiltertwo == "Other") {
			$thefilter .= ($thefilter == "") ? " WHERE " : " AND ";
			$thefilter .= "nom_contact REGEXP \"^\[1-9]\"";
		}
	    if ($selectuser != "") {
	    		$thefilter .= ($thefilter == "") ? " WHERE" : " AND ";
	    		$thefilter .= " informant='".$selectuser."'";
	    }
	    
	    OpenSysTable();
	    OpenOngletTable();
		displayOngletBar("contact",_ACTEURADMIN,$ongletDef);
		//displayAlphabet("system.php?op=annuaireActeur&onglet=contact");
		
		$result = $db->sql_query("select contactid, nom_contact, prenom_contact, acteur_actid, role_contact, informant from ".$prefix."_annuaireacteur_contact $thefilter order by nom_contact");
  	
	    $result2 = $db->sql_query("SELECT aid FROM ".$prefix."_authors ORDER BY aid ASC");
		$menuuser = "";
		if ($db->sql_numrows($result2) != 0) {
			$menuuser = '<select size="1" name="selectuser" onchange="this.form.submit()">';
			$menuuser .= '<option value="">'._ACTLISTEFILTERUSER."</option>";
			while (list($user) = $db->sql_fetchrow($result2)) {
				$selected = ($selectuser == $user) ? " selected=\"selected\"" : "";
				$menuuser .= '<option value="'.$user.'"'.$selected.'>'.$user."</option>";
			}
			$menuuser .= "</select>";
		}
		
		$filter = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		//$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter);
		//$sortie .= '</td><td width="30">&nbsp;</td><td>';
		$filter .= '<form name="formfilter" action="system.php" method="POST">';
		$filter .= '<input type="hidden" name="myfiltertwo" value="'.$myfiltertwo.'">';
		//$liste .= '<input type="hidden" name="page" value="'.$page.'">';
		$filter .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
		$filter .= '<input type="hidden" name="op" value="'.$op.'">';
		$filter .= $menuuser;
		$filter .= "</form>";
		$filter .= '</td><td width="30">&nbsp;</td><td style="padding: 10px 0 10px 0">';
		$filter .= displayAlphabet("system.php?op=annuaireActeur&onglet=contact");
		$filter .= '</td></tr></table>';	
		echo $filter;
	   
		echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader >"._CONTACT_NAME."</td>"
	    	."<td class=systemTabHeader align=\"center\">"._ACTEUR_NAME."</td>"
	    	."<td class=systemTabHeader align=\"center\">"._CONTACT_ROLE."</td>"
		."<td class=systemTabHeader align=\"center\">"._AUTHOR."</td>"
	    	."<td class=systemTabHeader align=\"center\">"._FUNCTIONS."</td>"
	    	
	    	."</tr>";
		
		$pos=0;
		while(list($contactid, $nom_contact, $prenon_contact, $acteur_actid, $role_contact, $informant) = $db->sql_fetchrow($result)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$myresult = $db->sql_query("select nom_acteur from ".$prefix."_annuaireacteur_acteur where actid='$acteur_actid'");
		list($nom_acteur) = $db->sql_fetchrow($myresult);
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&contactid=$contactid\" >";
		$iconeacteur="<img src=\"images/smallicone/user.png\">";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\">$iconeacteur $nom_contact $prenon_contact</td>"
		."<td align=\"left\">$nom_acteur</td>"
		."<td align=\"center\">$role_contact</td>"
		."<td align=\"center\">$informant</td>";
		echo "<td align=\"center\" nowrap>";
			$barDef["view"]["url"]="modules.php?name=becmsOrgDirectory&sop=viewActeur&actid=".$acteur_actid;
			$barDef["edit"]["url"]="system.php?op=contactEdit&amp;onglet=contact&contactid=$contactid&editForm=1&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser";
			$barDef["delete"]["url"]="system.php?op=contactDelete&amp;contactid=$contactid&amp;ok=0&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
			
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un nouveau contact</a>";
	    
		echo contactEdit($editid,$editForm,1);
		
		CloseOngletTable();
	    
	    
      break;
      // ############################## COMPETENCE ####################################
      case "competence":
	    OpenSysTable();
	    $result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
	    
		OpenOngletTable();
		displayOngletBar("competence",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._DOMAINE_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
	    	
	    $pos=0;	
	    while(list($domid, $domainename) = $db->sql_fetchrow($result)) {
	    if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=competence&domid=$domid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\" > $domainename</td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;&onglet=competence&editid=$domid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=competenceDelete&amp;domid=$domid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;&onglet=competence&editid=$domid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=competenceDelete&amp;domid=$domid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";
		$pos++;
		} // End While
		echo "</table>";	
		
        CloseOngletTable();
	    CloseSysTable();
	     OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un domaine de competence</a>";
	    
		echo competenceEdit($editid,$editForm,1);
		
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
			
		
		 CloseOngletTable();
		
      break;
      // ############################## STATUS ####################################
      case "status":
	    OpenSysTable();
	    $result = $db->sql_query("select statusid, statusname from ".$prefix."_annuaireacteur_liste_status order by statusname");
	    
	    OpenOngletTable();
		displayOngletBar("status",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._STATUS_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
		$pos=0;
		while(list($statusid, $statusname) = $db->sql_fetchrow($result)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=activite&activiteid=$statusid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\"> $statusname</td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;onglet=status&editid=$statusid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=statusDelete&amp;statusid=$statusid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;onglet=status&editid=$statusid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=statusDelete&amp;statusid=$statusid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un status</a>";
	    
		echo statusEdit($editid,$editForm,1);
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		 CloseOngletTable();
	    
      break;
       // ############################## TYPE ####################################
      case "type":
	    OpenSysTable();
	    
	    $result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
	    
	    OpenOngletTable();
		displayOngletBar("type",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._TYPE_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
		
		$pos=0;
		while(list($typid, $type_organisme) = $db->sql_fetchrow($result)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=acteur&myfilter=$typid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\" >$sectionLink $type_organisme</a></td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;onglet=type&editid=$typid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=typeDelete&amp;typid=$typid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;onglet=type&editid=$typid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=typeDelete&amp;typid=$typid&amp;ok=0\">"._DELETE."</a> ] </td></tr>";
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un type d'organisme</a>";
		
		echo typeEdit($editid,$editForm,1);
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		CloseOngletTable();
	    
	    
      break;
      // ############################## IMPORT ####################################
      case "import":
	    OpenSysTable();
	    
	    OpenOngletTable();
		displayOngletBar("import",_ACTEURADMIN,$ongletDef);
		
		$sortie = '<form name="importfact" action="system.php?op=annuactimport" method="POST" enctype="multipart/form-data">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<b>'._ACT_IMPORTALERTS."</b>";
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= _ACT_FILETOIMPORT.'<input type="file" name="file_acteurs" size="25">';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ACT_IMPORTBTN.'" name="valid">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		echo $sortie;
        CloseOngletTable();
	    CloseSysTable();
      break;
      
    }// end switch 
   
    include("system/footer_system.php");
}
/**
* acteurEdit()
* Modify fiche datas
* @param acteur id
* @param $editForm if value= 1 form is opened for edition, if value =0 creation mode. Default value 0.
* @param $asHtml if value=0 the form is display by the function. If value =1 metho retrun html code. Default value is 0.
* @return html code of the form : only if asHtml parm is 1.
* @see
*/
function acteurEdit($actid, $editForm=0, $asHtml=0) {
global $prefix, $db,$ongletDef,$admincontrolannuacteurs,$aid, $admin,$max_taille_logoact_h,$max_taille_logoact_v, $myfiltertwo, $selectuser;
$domaineArray=array();
if ($editForm){
// get information about Acteur
$result = $db->sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, type_acteur, status_acteur, mission_acteur, carte_acteur, informant, pays_acteur, region_acteur, projets_acteur  from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
	if (!$result) {
		print_r ( $db->sql_error () );
    		die('Invalid query');
	}
	list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur,$type_acteur, $status_acteur, $mission_acteur, $carte_acteur, $informant, $pays_acteur, $region_acteur, $projets_acteur) = $db->sql_fetchrow($result);

	//vrif droits utilisateur sur article
    if ($admincontrolannuacteurs) {
	    if ($aid != $informant && !is_super($admin)) {
	    		display_denied();
	    		return;
	    }
    }
    //fin vrif

// get domaine
$result2 = $db->sql_query("select domaine_domid  from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
while(list($domaine_domid) = $db->sql_fetchrow($result2)) {
	    $domaineArray[]= $domaine_domid;
	    }
}
$acteurForm= "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
		."<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n"
		."<center>"._ADD_NEW_ACTEUR."</center><br>"
	    ."<center><form action=\"system.php\" method=\"post\" name=\"acteur_edit_form\">"
	    ."<input type=\"hidden\" name=\"actid\" value=\"$actid\">"
		."<input type=\"hidden\" name=\"op\" value=\"acteurSave\">"
		."<input type=\"hidden\" name=\"myfiltertwo\" value=\"$myfiltertwo\">"
		."<input type=\"hidden\" name=\"selectuser\" value=\"$selectuser\">"
		."<table class=systemTab>"
		."<tr><td>"._NAME_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"nom_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_acteur\"></td>"
		."<td rowspan=\"13\" align=\"center\" valign=\"top\">"._DOMAINE_ACTEUR."<br> <select name=\"domaine_acteur[]\" size=\"16\" multiple=\"yes\">";
		
		$myresult = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
		$isSelected="";
		while(list($domid, $domainename) = $db->sql_fetchrow($myresult)) {
			if (in_array($domid,$domaineArray)) 
				$isSelected="selected"; 
			else 
				$isSelected="";
			$acteurForm.= "<option value=\"$domid\" $isSelected>$domainename</option>";
		}
		$acteurForm.= "</select>"
		."</td>"
		."</tr>"
		."<tr><td>"._SIGLE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"sigle_acteur\" size=\"40\" maxlength=\"40\" value=\"$sigle_acteur\"></td>"
		."</tr>"
		."<tr><td>"._REF_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"ref_acteur\" size=\"40\" maxlength=\"40\" value=\"$ref_acteur\"></td>"
		."</tr>"
		."<tr><td>"._ADRESSE_ACTEUR."</td> "
		."<td><!--<input type=\"text\" name=\"adresse_acteur\" size=\"40\" maxlength=\"255\" value=\"$adresse_acteur\">-->
				<textarea cols=\"40\" name=\"adresse_acteur\" rows=\"3\" maxlength=\"255\">$adresse_acteur</textarea></td>"
		."</tr>"
		."<tr><td>"._POSTALCODE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"codepostal_acteur\" size=\"40\" maxlength=\"40\" value=\"$codepostal_acteur\"></td>"
		."</tr>"
		."<tr><td>"._CITY_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"ville_acteur\" size=\"40\" maxlength=\"80\" value=\"$ville_acteur\"></td>"
		."</tr>"
		."<tr><td>"._COUNTRY_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"pays_acteur\" size=\"40\" maxlength=\"80\" value=\"$pays_acteur\"></td>"
		."</tr>"
		."<tr><td>"._REGION_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"region_acteur\" size=\"40\" maxlength=\"80\" value=\"$region_acteur\"></td>"
		."</tr>"
		."<tr><td>"._TELEPHONE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"telephone_acteur\" size=\"40\" maxlength=\"40\" value=\"$telephone_acteur\"></td>"
		."</tr>"
		."<tr><td>"._FAX_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"fax_acteur\" size=\"40\" maxlength=\"40\" value=\"$fax_acteur\"></td>"
		."</tr>"
		."<tr><td>"._EMAIL_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"email_acteur\" size=\"40\" maxlength=\"80\" value=\"$email_acteur\"></td>"
		."</tr>"
		."<tr><td>"._WEB_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"web_acteur\" size=\"40\" maxlength=\"255\" value=\"$web_acteur\"></td>"
		."</tr>"
		."<tr><td>"._PRESIDENT_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"nom_president_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_president_acteur\"></td>"
		."</tr>"
		."<tr><td>"._DIRECTEUR_ACTEUR."</td> "
		."<td colspan=2><input type=\"text\" name=\"nom_directeur_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_directeur_acteur\"></td>"
		."</tr>"
		."<td>"._TYPE_ACTEUR."</td>"
		."<td colspan=2> <select name=\"type_acteur\" >";
		$isSelected="";
		$myresult = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
		while(list($typid, $type_organisme) = $db->sql_fetchrow($myresult)) {
		if ($type_acteur==$typid) $isSelected="selected"; else $isSelected="";
		$acteurForm.= "<option value=\"$typid\" $isSelected>$type_organisme</option>";
		}
		$acteurForm.= "</select>"
		."</td></tr>"
		."<td >"._STATUS_ACTEUR." </td>"
		."<td colspan=2> <select name=\"status_acteur\" >";
		$isSelected="";
		$myresult = $db->sql_query("select statusid, statusname from ".$prefix."_annuaireacteur_liste_status order by statusname");
		while(list($statusid, $statusname) = $db->sql_fetchrow($myresult)) {
			if ($status_acteur==$statusid) $isSelected="selected"; else $isSelected="";
			$acteurForm.= "<option value=\"$statusid\" $isSelected >$statusname</option>";
		}
		$acteurForm.= "</select>"
		."</td></tr>"
		."<tr><td>"._MISSION_ACTEUR."</td> "
		."<td colspan=2> <textarea name=\"mission_acteur\" cols=\"80\" rows=\"10\">$mission_acteur</textarea> </td>"
		."</tr>"
		."<tr><td>"._PROJET_ACTEUR."</td> "
		."<td colspan=2> <textarea name=\"projets_acteur\" cols=\"80\" rows=\"10\">$projets_acteur</textarea> </td>"
		."</tr>"
		."<tr><td>"._CARTE_ACTEUR."</td> "
		."<td><input type=\"text\" id=\"myfield\" name=\"carte_acteur\" size=\"40\" maxlength=\"80\" value=\"$carte_acteur\"></td>"
		."<td>";
		//$acteurForm.= "<input type=\"button\" id=\"ins_map\" value=\"Parcourir ...\" Onclick=\"javascript:insert('download')\">";
		/*$acteurForm.= '
<script type="text/javascript">
function  SetUrl( url ) {
	window.document.forms["acteur_edit_form"].elements["carte_acteur"].value = url;
}
function OpenFileBrowser( url, width, height ) {
	var iLeft = ( screen.availWidth  - width ) / 2 ;
	var iTop  = ( screen.availHeight - height ) / 2 ;

	var sOptions = "toolbar=no,status=no,resizable=yes,dependent=yes,scrollbars=yes" ;
	sOptions += ",width=" + width ;
	sOptions += ",height=" + height ;
	sOptions += ",left=" + iLeft ;
	sOptions += ",top=" + iTop ;

	fenetre = window.open( url, \'FCKBrowseWindow\', sOptions ) ;
	if (! fenetre) {
		alert("Veuillez autorisez les fentres pop-up sur cette page SVP");
	}
}
</script>
';*/
		
	$racineflux = urlencode("http://".$_SERVER["SERVER_NAME"].substr($_SERVER["REQUEST_URI"],0,strpos($_SERVER["REQUEST_URI"],"system.php")));
	$acteurForm .= '
	<script type="text/javascript">
	function SetUrl(url) {
		window.document.forms["acteur_edit_form"].elements["carte_acteur"].value = url;
	}
	
	function openFileManager() {
		var width = screen.width * 0.7;
		var height = screen.height * 0.7;
		var iLeft = ( screen.width  - width ) / 2 ;
		var iTop  = ( screen.height - height ) / 2 ;
	
		var sOptions = "toolbar=no,status=no,resizable=yes,dependent=yes,scrollbars=yes" ;
		sOptions += ",width=" + width ;
		sOptions += ",height=" + height ;
		sOptions += ",left=" + iLeft ;
		sOptions += ",top=" + iTop ;
	
		url= "javascripts/fckeditor/editor/filemanager/browser/default/browser.html?Type=Image&Connector='.$racineflux.'javascripts%2Ffckeditor%2Feditor%2Ffilemanager%2Fconnectors%2Fphp%2Fconnector.php";
		
		fenetre = window.open( url, \'FCKBrowseWindow\', sOptions ) ;
		if (! fenetre) {
			alert("Veuillez autorisez les fentres pop-up sur cette page SVP");
		}
	}
	</script>
	';
		//$acteurForm .= '<input id="btnBrowse" onclick="OpenFileBrowser(\'javascripts/fckeditor/editor/filemanager/browser/default/browser.html?Connector=connectors/php/connector.php&Type=Image\',eval(screen.availWidth * 0.7),eval(screen.availHeight * 0.7))" type="button" value="Parcourir le serveur" />';
		$acteurForm .= '<input id="btnBrowse" onclick="openFileManager()" type="button" value="Parcourir le serveur" />';
		$acteurForm .= '<input id="txtWidth" type="hidden" value="'.$max_taille_logoact_h.'" />';
		$acteurForm .= '<input id="txtHeight" type="hidden" value="'.$max_taille_logoact_v.'" />';
		$acteurForm.= "</td>"
		."</tr>"
		."<tr>"
		."<SCRIPT language=\"JavaScript\" src=\"javascripts/selectbox.js\"></SCRIPT>\n"
		."<td rowspan=\"2\">"._ACTIVITE_ACTEUR."</td>"
		."<td><input type=\"text\" id=\"add_activite\" size=\"60\" maxlength=\"255\" value=\"\"></td>"
		."<td align=\"left\"><input type=\"button\" name=\"add_button\" value=\"Ajouter\" Onclick=\"javascript:addOption(document.getElementById('activite_act'),document.getElementById('add_activite').value,document.getElementById('add_activite').value,false) \"></td>"
		."<tr>"
		."<td class=inputFormL valign=\"top\" ><select id=\"activite_act\" name=\"activite_acteur[]\" size=\"8\" multiple=\"yes\">";
		$myresult = $db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid' order by com_activite");
		while(list($activite) = $db->sql_fetchrow($myresult)) {
			$acteurForm.= "<option value=\"$activite\" >$activite</option>";
		}
		$acteurForm.="</select>"
		."</td><td>"
		."<input type=\"button\" id=\"del_button\" value=\"Effacer\" Onclick=\"javascript:removeSelectedOptions(document.getElementById('activite_act'))\"></td>"
		."</tr>";
		$acteurForm .= "<tr>"
		."<td>"._AUTHOR."</td>";
		
		if (!isset($actid) || $actid == "") {
			$informant = $aid;
		}
		
		if (is_super($admin)) {
			$acteurForm .= "<td colspan=\"2\">"."<input size=\"60\" type=\"text\" value=\"".$informant."\" name=\"informant\">"."</td>";
		}
		else {
			$acteurForm .= "<td colspan=\"2\">".$informant."<input type=\"hidden\" value=\"".$informant."\" name=\"informant\"></td>";
		}
		$acteurForm .= "</tr>";
		$acteurForm .= "</table>"
		."\n <br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\" Onclick=\"javascript:selectAllOptions(document.getElementById('activite_act'))\"> [ <a href=\"system.php?op=acteurDelete&actid=".$actid."&ok=0\">"._DELETE."</a> ]"
		."</form></center>"
		."</DIV>";
if ($asHtml) {
   return $acteurForm;
}else {
	include("system/header_system.php");
    GraphicAdmin(_ACTEURADMIN);
    OpenOngletTable();
    
	echo "<div align=\"right\">";
		displayOngletBar('acteur',_ACTEURADMIN,$ongletDef);
		echo "</div>";
	 	echo $acteurForm;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else
}
/**
* contactEdit()
* Modify contact data's
* @param conatct id
* @return
* @see
*/
function contactEdit($contactid, $editForm=0, $asHtml=0) {
	global $prefix, $db,$ongletDef, $admincontrolannuacteurs, $aid, $admin, $myfilter, $myfiltertwo, $selectuser;
	if ($editForm){
		// get information about Acteur
		$result = $db->sql_query("select contactid, acteur_actid, nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact,  fax_contact, email_contact, web_contact, titre_contact, domaine_contact, position_contact, role_contact, informant  from ".$prefix."_annuaireacteur_contact where contactid='$contactid'");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		list($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact,  $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact,$informant)= $db->sql_fetchrow($result);
		//vrif droits utilisateur sur article
	    if ($admincontrolannuacteurs) {
		    if ($aid != $informant && !is_super($admin)) {
		    		display_denied();
		    		return;
		    }
	    }
    //fin vrif
	}
	if ($editForm==0) $contactid=""; // force id to null
	$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_CONTACT."</center><br>"
	    ."<center><form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"contactid\" value=\"$contactid\">"
		."<input type=\"hidden\" name=\"op\" value=\"contactSave\">"
		."<input type=\"hidden\" name=\"myfilter\" value=\"$myfilter\">"
		."<input type=\"hidden\" name=\"myfiltertwo\" value=\"$myfiltertwo\">"
		."<input type=\"hidden\" name=\"selectuser\" value=\"$selectuser\">"
		."<table class=systemTab>"
		."<tr><td>"._NAME_CONTACT."</td> "
		."<td><input type=\"text\" name=\"nom_contact\" size=\"40\" maxlength=\"40\" value=\"$nom_contact\"></td>"
		."<td rowspan=\"11\" align=\"center\" valign=\"top\">"._ACTEUR_CONTACT."<br> <select name=\"acteur_actid\" size=\"16\">";

	$myresult = $db->sql_query("select actid, nom_acteur from ".$prefix."_annuaireacteur_acteur order by nom_acteur");
	while(list($actid, $nom_acteur) = $db->sql_fetchrow($myresult)) {
		$isSelected="";
		if ($actid==$acteur_actid) $isSelected="selected";
		$formframe.= "<option value=\"$actid\" $isSelected>$nom_acteur</option>";
	}
	$formframe.= "</select>"
		."</td></tr>"
		."<tr><td>"._SURNAME_CONTACT."</td> "
		."<td><input type=\"text\" name=\"prenom_contact\" size=\"40\" maxlength=\"40\" value=\"$prenom_contact\"></td>"
		."</tr>"
		."<tr><td>"._PHONENUMBER_CONTACT."</td> "
		."<td><input type=\"text\" name=\"telephone_contact\" size=\"40\" maxlength=\"40\" value=\"$telephone_contact\"></td>"
		."</tr>"
		."<tr><td>"._MOBILEPHONE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"telephone_mobile_contact\" size=\"40\" maxlength=\"40\" value=\"$telephone_mobile_contact\"></td>"
		."</tr>"
		."<tr><td>"._FAX_CONTACT."</td> "
		."<td><input type=\"text\" name=\"fax_contact\" size=\"40\" maxlength=\"40\" value=\"$fax_contact\"></td>"
		."</tr>"
		."<tr><td>"._EMAIL_CONTACT."</td> "
		."<td><input type=\"text\" name=\"email_contact\" size=\"40\" maxlength=\"150\" value=\"$email_contact\"></td>"
		."</tr>"
		."<tr><td>"._WEB_CONTACT."</td> "
		."<td><input type=\"text\" name=\"web_contact\" size=\"40\" maxlength=\"40\" value=\"$web_contact\"></td>"
		."</tr>"
		."<tr><td>"._TITLE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"titre_contact\" size=\"40\" maxlength=\"40\" value=\"$titre_contact\"></td>"
		."</tr>"
		."<tr><td>"._DOMAINE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"domaine_contact\" size=\"40\" maxlength=\"40\" value=\"$domaine_contact\"></td>"
		."</tr>"
		."<tr><td>"._POSITION_CONTACT."</td> "
		."<td><input type=\"text\" name=\"position_contact\" size=\"40\" maxlength=\"40\" value=\"$position_contact\"></td>"
		."</tr>"
		."<tr><td>"._ROLE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"role_contact\" size=\"40\" maxlength=\"40\" value=\"$role_contact\"></td>"
		."</tr>"
		."</table>"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=contactDelete&amp;contactid=$contactid&amp;ok=0\">"._DELETE."</a> ]"
		."</form></center>"
		."</DIV>";
	if ($asHtml) {
		return $formframe;
	}
	else {
		include("system/header_system.php");
		GraphicAdmin(_ACTEURADMIN);
		OpenOngletTable();
		echo "<div align=\"right\">";
		displayOngletBar('contact',_ACTEURADMIN,$ongletDef );
		echo "</div>";
		echo $formframe;
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
		echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 CloseOngletTable();
	 include("system/footer_system.php");
	}// if else
}
/**
* competenceEdit()
* Modify Competences data's
* @param competence id
* @return
* @see
*/
function competenceEdit($domid,$editForm=0, $asHtml=0) {
global $prefix, $db;
if ($editForm){
// get information about Acteur
$result = $db->sql_query("select  domainename  from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
list($domainename)= $db->sql_fetchrow($result);
}
if ($editForm==0) $domid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_COMPETENCE."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"domid\" value=\"$domid\">"
		."<input type=\"hidden\" name=\"op\" value=\"competenceSave\">"
		.""._DOMAINE_NAME." "
		."<input type=\"text\" name=\"domainename\" size=\"40\" maxlength=\"255\" value=\"$domainename\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=competenceDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    echo "<table width=\"100%\" border=\"0\">"
		."<tr>"
        ."<td height=\"139\" align=\"center\" valign=\"top\" bgcolor=\"#ece9d8\">"
		."<div align=\"right\">";
		displayOnglet('competence',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	echo "</td></tr></table>";
	 include("system/footer_system.php");
}// if else	

}

/**
* statusEdit()
* Modify Status data's 
* @param statusid id
* @return
* @see
*/
function statusEdit($statusid,$editForm=0, $asHtml=0) {
global $prefix, $db;
if ($editForm){
// get information about Acteur
$result = $db->sql_query("select  statusname  from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
list($statusname)= $db->sql_fetchrow($result);
}
if ($editForm==0) $statusid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_STATUS."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"statusid\" value=\"$statusid\">"
		."<input type=\"hidden\" name=\"op\" value=\"statusSave\">"
		.""._STATUS_NAME." "
		."<input type=\"text\" name=\"statusname\" size=\"40\" maxlength=\"40\" value=\"$statusname\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=statusDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    echo "<table width=\"100%\" border=\"0\">"
		."<tr>"
        ."<td height=\"139\" align=\"center\" valign=\"top\" bgcolor=\"#ece9d8\">"
		."<div align=\"right\">";
		displayOnglet('status',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	echo "</td></tr></table>";
	 include("system/footer_system.php");
}// if else			
}
/**
* typeEdit()
* Modify type of organism data's 
* @param typid activiy id
* @return
* @see
*/
function typeEdit($typid, $editForm=0, $asHtml=0) {
global $prefix, $db;
if ($editForm){
// get information about Acteur
$result = $db->sql_query("select  type_organisme  from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
	if (!$result) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
list($type_organisme)= $db->sql_fetchrow($result);
}
if ($editForm==0) $typid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_TYPE."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"typid\" value=\"$typid\">"
		."<input type=\"hidden\" name=\"op\" value=\"typeSave\">"
		.""._TYPE_NAME." "
		."<input type=\"text\" name=\"typename\" size=\"50\" maxlength=\"255\" value=\"$type_organisme\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=typeDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    OpenOngletTable();
		echo "<div align=\"right\">";
		displayOnglet('type',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else			
}
/**
* activiteDelete()
* delete an activity
* @param activity id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function activiteDelete($activiteid, $ok=0) {
global $prefix, $db;
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_activite where activiteid='$activiteid'");        
        Header("Location: system.php?op=annuaireActeur&onglet=acteur");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._ACTIVITEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=$db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where activiteid='$activiteid'");
	list($typename) = $db->sql_fetchrow($result);
	OpenSysTable();
	echo "<center><b>"._DELACTIVITE.": $activite</b><br><br>"
	    .""._DELACTIVITEWARNING." $activite?<br>"
	    .""._DELACTIVITEWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=acteur\">"._NO."</a> | <a href=\"system.php?op=activiteDelete&activiteid=".$activiteid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* contactDelete()
* delete a contact
* @param conatct id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function contactDelete($contactid, $ok=0) {
global $prefix, $db,$myfilter, $myfiltertwo, $selectuser;
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_contact where contactid='$contactid'");
        Header("Location: system.php?op=annuaireActeur&onglet=contact&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
		OpenSysTable();
		echo "<center><font class=\"title\"><b>"._CONTACTADMIN_TXT."</b></font></center>";
		CloseSysTable();
		echo "<br>";
		$result=$db->sql_query("select nom_contact, prenom_contact from ".$prefix."_annuaireacteur_contact where contactid='$contactid'");
		list($nom_contact, $prenom_contact) = $db->sql_fetchrow($result);
		OpenSysTable();
		echo "<center><b>"._DELCONTACT."$nom_contact $prenom_contact</b><br><br>"
		    .""._DELCONTACTWARNING."<br>"
		    .""._DELCONTACTWARNING1."<br><br>"
		    ."[ <a href=\"javascript:window.history.back()\">"._NO."</a> | <a href=\"system.php?op=contactDelete&contactid=".$contactid."&ok=1&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser\">"._YES."</a> ]</center>";
		CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* competenceDelete()
* delete a competences
* @param domid domaine de competence id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function competenceDelete($domid, $ok=0) {
global $prefix, $db;
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
        $db->sql_query("delete from ".$prefix."_annuaireacteur_domaine where domaine_domid='$domid'");
        Header("Location: system.php?op=annuaireActeur&onglet=competence");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._COMPTENCEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=$db->sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
	list($domainename) = $db->sql_fetchrow($result);
	OpenSysTable();
	echo "<center><b>"._DELDOMAINE.": $domainename</b><br><br>"
	    .""._DELCOMPWARNING." $domainename?<br>"
	    .""._DELCOMPWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=competence\">"._NO."</a> | <a href=\"system.php?op=competenceDelete&domid=".$domid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* acteurDelete
* delete an acteur in DB
* @param acteur id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function acteurDelete($actid, $ok=0) {
	global $prefix, $db;
	global $admincontrolannuacteurs, $aid, $admin, $selectuser, $myfiltertwo;
	$result = $result=$db->sql_query("select informant from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
	list($informant) = $db->sql_fetchrow($result);
	if ($admincontrolannuacteurs) {
	    if ($aid != $informant && !is_super($admin)) {
	    		display_denied();
	    		return;
	    }
    }
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
        $db->sql_query("delete from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
        $db->sql_query("delete from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
        $db->sql_query("delete from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid'");
        Header("Location: system.php?op=annuaireActeur&onglet=acteur&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
    } 
    else {
        include("system/header_system.php");
        GraphicAdmin();
		OpenSysTable();
		echo "<center><font class=\"title\"><b>"._ACTEURADMIN_TXT."</b></font></center>";
		CloseSysTable();
		echo "<br>";
		$result=$db->sql_query("select nom_acteur from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
		list($nom_acteur) = $db->sql_fetchrow($result);
		OpenSysTable();
		echo "<center><b>"._DELACTEUR."$nom_acteur</b><br><br>"
		    .""._DELACTEURWARNING."<br>"
		    .""._DELACTEURWARNING1."<br><br>"
		    ."[ <a href=\"javascript:window.history.back()\">"._NO."</a> | <a href=\"system.php?op=acteurDelete&actid=$actid&ok=1&myfiltertwo=$myfiltertwo&selectuser=$selectuser\">"._YES."</a> ]</center>";
		CloseSysTable();
        include("system/footer_system.php");
    }
}

/**
* typeDelete
* delete an type in DB
* @param typid type of organism id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function typeDelete($typid, $ok=0) {
global $prefix, $db;
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");        
        Header("Location: system.php?op=annuaireActeur&onglet=type");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._TYPEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=$db->sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
	list($type_organisme) = $db->sql_fetchrow($result);
	OpenSysTable();
	echo "<center><b>"._DELDOMAINE.": $type_organisme</b><br><br>"
	    .""._DELTYPEWARNING." $type_organisme?<br>"
	    .""._DELTYPEWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=type\">"._NO."</a> | <a href=\"system.php?op=typeDelete&typid=".$typid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* statusDelete
* delete an status data in DB
* @param statusid type of organism id
* @param ok if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function statusDelete($statusid, $ok=0) {
global $prefix, $db;
    if ($ok==1) {
        $db->sql_query("delete from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'");        
        Header("Location: system.php?op=annuaireActeur&onglet=status");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._STATUSADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=$db->sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'");
	list($typename) = $db->sql_fetchrow($result);
	OpenSysTable();
	echo "<center><b>"._DELSTATUS.": $statusname</b><br><br>"
	    .""._DELSTATUSWARNING." $statusname?<br>"
	    .""._DELSTATUSWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=status\">"._NO."</a> | <a href=\"system.php?op=statusDelete&statusid=".$statusid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* acteurSave()
* save all information about an acteur in DB 
* @param acid :acteur id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function acteurSave($actid,$refid, $nom_acteur,$adresse_acteur,$ville_acteur,$codepostal_acteur,$sigle_acteur,$telephone_acteur,$fax_acteur,$email_acteur,$web_acteur,$nom_president_acteur,$nom_directeur_acteur,$type_acteur,$status_acteur,$mission_acteur,$carte_acteur,$domaine_acteur, $activite_acteur, $informant, $pays_acteur, $region_acteur, $projets_acteur) {
global $prefix, $db, $myfiltertwo, $selectuser;

// $deb=new debug;

 $refid = stripslashes(FixQuotes($refid));
 $nom_acteur = stripslashes(FixQuotes($nom_acteur));
 $adresse_acteur = stripslashes(FixQuotes($adresse_acteur));
 $ville_acteur = stripslashes(FixQuotes($ville_acteur));
 $codepostal_acteur = stripslashes(FixQuotes($codepostal_acteur));
 $sigle_acteur = stripslashes(FixQuotes($sigle_acteur));
 $telephone_acteur = stripslashes(FixQuotes($telephone_acteur));
 $fax_acteur = stripslashes(FixQuotes($fax_acteur));
 $email_acteur = stripslashes(FixQuotes($email_acteur));
 $web_acteur = stripslashes(FixQuotes($web_acteur));
 $nom_president_acteur = stripslashes(FixQuotes($nom_president_acteur));
 $nom_directeur_acteur = stripslashes(FixQuotes($nom_directeur_acteur));
 $type_acteur = stripslashes(FixQuotes($type_acteur));
 $status_acteur = stripslashes(FixQuotes($status_acteur));
 $mission_acteur = stripslashes(FixQuotes($mission_acteur));
 $carte_acteur = stripslashes(FixQuotes($carte_acteur));
 $informant = stripslashes(FixQuotes($informant));
 $pays_acteur = stripslashes(FixQuotes($pays_acteur));
 $region_acteur = stripslashes(FixQuotes($region_acteur));
 $projets_acteur = stripslashes(FixQuotes($projets_acteur));
 
 if(!$domaine_acteur) {
 	$domaine_acteur = array();
 }
 
 //$deb->log(compact("nom_contact","prenom_contact","telephone_contact"));
 
if (isset($actid)&& $actid!="") {
	// update
	$resultIn=$db->sql_query("update ".$prefix."_annuaireacteur_acteur set refid='$refid',nom_acteur='$nom_acteur', adresse_acteur='$adresse_acteur',ville_acteur='$ville_acteur',codepostal_acteur='$codepostal_acteur',sigle_acteur='$sigle_acteur',telephone_acteur='$telephone_acteur',fax_acteur='$fax_acteur',email_acteur='$email_acteur',web_acteur='$web_acteur',nom_president_acteur='$nom_president_acteur',nom_directeur_acteur='$nom_directeur_acteur',type_acteur='$type_acteur',status_acteur='$status_acteur',mission_acteur='$mission_acteur',carte_acteur='$carte_acteur', date_acteur=now(), informant='$informant', pays_acteur='$pays_acteur', region_acteur='$region_acteur', projets_acteur='$projets_acteur' where actid=$actid");    
    if (!$resultIn) {
    	print_r ( $db->sql_error () );
    	die('Invalid query');
	}
    // delete competence
    $resultDel=$db->sql_query("delete from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
    // delete activity
    $resultDel2=$db->sql_query("delete from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
    
    // recreate activity and domaines
    foreach ($domaine_acteur as $domaineid){
    $resultIn2 = $db->sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domaineid'");
	if (!$resultIn2) {
		print_r ( $db->sql_error () );
    	die('Invalid query');
	}
	list($domainename)= $db->sql_fetchrow($resultIn2);	
    $domainename = stripslashes(FixQuotes($domainename));	
    $resultIn3=$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_domaine VALUES (NULL,'$actid','$domaineid','$domainename','$nom_acteur')");
    if (!$resultIn3) {
    	print_r ( $db->sql_error () );
    	die('Invalid query');
     }
    }
    activiteSave("",$actid, $activite_acteur);
    $db->sql_query("update ".$prefix."_annuaireacteur_contact set informant='$informant' where acteur_actid=$actid");   
    
    Header("Location: system.php?op=annuaireActeur&onglet=acteur&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
 }
 else{
	// create
	$result=$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_acteur VALUES (NULL,'$refid','$nom_acteur','$adresse_acteur','$ville_acteur','$codepostal_acteur','$sigle_acteur','$telephone_acteur','$fax_acteur','$email_acteur','$web_acteur','$nom_president_acteur','$nom_directeur_acteur','$type_acteur','$status_acteur','$mission_acteur','$carte_acteur', now(), '$informant','$pays_acteur','$region_acteur','$projets_acteur');");
    if (!$result) {
    	print_r ( $db->sql_error () );
    	die('Invalid query');
    }
    $actidc = $db->sql_nextid();
    foreach ($domaine_acteur as $domaineid){
     $result2 = $db->sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domaineid'");
	 if (!$result2) {
	 	print_r ( $db->sql_error () );
    	die('Invalid query');
	 } 
	 list($domainename)= $db->sql_fetchrow($result2);	
     $domainename = stripslashes(FixQuotes($domainename));	
     $result3=$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_domaine VALUES (NULL,'$actidc','$domaineid','$domainename','$nom_acteur')");
     if (!$result3) {
     	print_r ( $db->sql_error () );
    	die('Invalid query');
     }
    }
    activiteSave("",$actidc, $activite_acteur);
    
    Header("Location: system.php?op=annuaireActeur&onglet=acteur&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
 }
}
/**
* activiteSave()
* save all information about an activiy in DB
* @param actid :Activity id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function activiteSave($activiteid,$acteur_actid, $activite_acteur) {
global $prefix, $db;

if(!$activite_acteur) {
	$activite_acteur = array();
}

if (isset($activiteids)) {
	// update
	$db->sql_query("update ".$prefix."_annuaireacteur_activite set domainename='$domainename' where comid=$domid");
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }else{
 	if(count($activite_acteur) > 0) {
		foreach ($activite_acteur as $activite){
		$activite = stripslashes(FixQuotes($activite));
	    $result=$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_activite VALUES (NULL,'$acteur_actid','$activite','com activite')");
	    if (!$result) {
	    	print_r ( $db->sql_error () );
	    	die('Invalid query');
	     }
	    }// end foreach
 	}
 } // end if esle
}
/**
* contactSave()
* save all information about a contact
* @param conid :contact id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
//include("core/becms_debug_class.php");
function contactSave($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact) {
global $prefix, $db, $myfilter, $myfiltertwo, $selectuser;

// $deb=new debug;

 $nom_contact = stripslashes(FixQuotes($nom_contact));
 $prenom_contact = stripslashes(FixQuotes($prenom_contact));
 $telephone_contact = stripslashes(FixQuotes($telephone_contact));
 $telephone_mobile_contact = stripslashes(FixQuotes($telephone_mobile_contact));
 $fax_contact = stripslashes(FixQuotes($fax_contact));
 $email_contact = stripslashes(FixQuotes($email_contact));
 $titre_contact = stripslashes(FixQuotes($titre_contact));
 $domaine_contact = stripslashes(FixQuotes($domaine_contact));
 $role_contact = stripslashes(FixQuotes($role_contact));
 
 //$deb->log(compact("nom_contact","prenom_contact","telephone_contact"));
 if ($acteur_actid != "") {
 	$result = $db->sql_query("select informant from ".$prefix."_annuaireacteur_acteur where actid='$acteur_actid'");
 	if (!$result) {
 		print_r ( $db->sql_error () );
    		die('Invalid query');
    }
 	list($informant)= $db->sql_fetchrow($result);
 	$informant = stripslashes(FixQuotes($informant));
 }
 
if (isset($contactid) && $contactid!="") {
	// update
	$db->sql_query("update ".$prefix."_annuaireacteur_contact set acteur_actid='$acteur_actid', nom_contact='$nom_contact', prenom_contact='$prenom_contact', telephone_contact='$telephone_contact', telephone_mobile_contact='$telephone_mobile_contact', fax_contact='$fax_contact', email_contact='$email_contact', web_contact='$web_contact', titre_contact='$titre_contact', domaine_contact='$domaine_contact', position_contact='$position_contact', role_contact='$role_contact', informant='$informant' where contactid=$contactid");    
    Header("Location: system.php?op=annuaireActeur&onglet=contact&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
 }else{
	// create
	$result=$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_contact VALUES (NULL,'$acteur_actid','$nom_contact','$prenom_contact','$telephone_contact','$telephone_mobile_contact','$fax_contact','$email_contact','$web_contact','$titre_contact','$domaine_contact','$position_contact','$role_contact', '$informant')");
    if (!$result) {
    	print_r ( $db->sql_error () );
    		die('Invalid query');
    }
    Header("Location: system.php?op=annuaireActeur&onglet=contact&myfilter=$myfilter&myfiltertwo=$myfiltertwo&selectuser=$selectuser");
 }
}
/**
* competenceSave()
* save all information about competences
* @param comid :competences id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function competenceSave($domid, $domainename) {
global $prefix, $db;
 $domainename = stripslashes(FixQuotes($domainename));
if (isset($domid) && $domid!="") {
	// update
	$db->sql_query("update ".$prefix."_annuaireacteur_liste_domaine set domainename='$domainename' where domid=$domid");
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }else{
	// create
	$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_domaine VALUES (NULL,'$domainename')");
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }
}

/**
* typeSave()
* save all information about organisme type
* @param typid : organism type id
* @param array typeData :Associative Array that containe field name and data value
* @return
* @see
*/
function typeSave($typid, $typename) {
global $prefix, $db;
 $typename = stripslashes(FixQuotes($typename));
if (isset($typid)&& $typid!="") {
	// update
	$db->sql_query("update ".$prefix."_annuaireacteur_liste_type set type_organisme='$typename' where typid=$typid");
    Header("Location: system.php?op=annuaireActeur&onglet=type");
 }else{
	// create
	$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_type VALUES (NULL,'$typename')");
    Header("Location: system.php?op=annuaireActeur&onglet=type");
 }
}

/**
* statusSave()
* save all information about organisme type
* @param typid : organism type id
* @param array typeData :Associative Array that containe field name and data value
* @return
* @see
*/
function statusSave($statusid, $statusname) {
global $prefix, $db;
 $statusname = stripslashes(FixQuotes($statusname));
if (isset($statusid)&& $statusid!="") {
	// update
	$db->sql_query("update ".$prefix."_annuaireacteur_liste_status set statusname='$statusname' where statusid=$statusid");
    Header("Location: system.php?op=annuaireActeur&onglet=status");
 }
 else{
	// create
	$db->sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_status VALUES (NULL,'$statusname')");
    Header("Location: system.php?op=annuaireActeur&onglet=status");
 }
}
/**
 * displayAlphabet()
 * 
 * @param datatype paramname description
 * @return datatype description
 */
 function displayAlphabetOld($thelink){
 $acteurLink=$thelink."&myfiltertwo=";
 
 echo "<div align=right>"
 ."<a href=\"".$acteurLink."A\">A </a>"
 ."<a href=\"".$acteurLink."B\">B </a>"
 ."<a href=\"".$acteurLink."C\">C </a>"
 ."<a href=\"".$acteurLink."D\">D </a>"
 ."<a href=\"".$acteurLink."E\">E </a>"
 ."<a href=\"".$acteurLink."F\">F </a>"
 ."<a href=\"".$acteurLink."G\">G </a>"
 ."<a href=\"".$acteurLink."H\">H </a>"
 ."<a href=\"".$acteurLink."I\">I </a>"
 ."<a href=\"".$acteurLink."J\">J </a>"
 ."<a href=\"".$acteurLink."K\">K </a>"
 ."<a href=\"".$acteurLink."L\">L </a>"
 ."<a href=\"".$acteurLink."M\">M </a>"
 ."<a href=\"".$acteurLink."N\">N </a>"
 ."<a href=\"".$acteurLink."O\">O </a>"
 ."<a href=\"".$acteurLink."P\">P </a>"
 ."<a href=\"".$acteurLink."Q\">Q </a>"
 ."<a href=\"".$acteurLink."R\">R </a>"
 ."<a href=\"".$acteurLink."S\">S </a>"
 ."<a href=\"".$acteurLink."T\">T </a>"
 ."<a href=\"".$acteurLink."U\">U </a>"
 ."<a href=\"".$acteurLink."V\">V </a>"
 ."<a href=\"".$acteurLink."X\">X </a>"
 ."<a href=\"".$acteurLink."Y\">Y </a>"
 ."<a href=\"".$acteurLink."Z\">Z </a>"
 ."</div>";
 }
 
function displayAlphabet($thelink) {
   /* Creates the list of letters and makes them a link. */
	global $op, $onglet,$sortby,$action,$selectuser,$myfiltertwo;
	
	$acteurLink=$thelink."&myfiltertwo=";
	
	$sortie = "";
     	$alphabet = array ("All", "A","B","C","D","E","F","G","H","I","J","K","L","M",
                          "N","O","P","Q","R","S","T","U","V","W","X","Y","Z","Other");
	$num = count($alphabet) - 1;
      	$sortie .= "<div>";
      	$sortie .= _ACTLISTEFILTER;
      	$sortie .= "[ ";
      	$counter = 0;
      	while (list(, $ltr) = each($alphabet)) {
      		$style = ($ltr==$myfiltertwo) ? " class=\"encours\"" : "";
      		$sortie .= "<A HREF=\"$acteurLink$ltr&selectuser=$selectuser\"$style>$ltr</a>";
		//$sortie .= "<A HREF=\"system.php?op=$op&action=$action&letter=$ltr&sortby=$sortby&onglet=$onglet\">$ltr</a>";
		/*if ( $counter == round($num/2) ) {
			$sortie .= " ]\n[ ";
		} 
		else*/if ( $counter != $num ) {
			$sortie .= "&nbsp;|&nbsp;";
		}
		$counter++;
	}
	$sortie .= " ]</div>";
	return $sortie;
}
 
function import_csv() {
	global $prefix,$db,$aid; 
	
	$chemin="catalog_repository";
	if ($_FILES["file_acteurs"]["name"] != "") {
		$nomDestination = $_FILES["file_acteurs"]["name"];
		if (is_uploaded_file($_FILES["file_acteurs"]["tmp_name"])) {
			$fichier = $chemin."/".$nomDestination;
			if (rename($_FILES["file_acteurs"]["tmp_name"],$fichier)) { 
				chmod($fichier,0777);
				//if ($db->sql_query("TRUNCATE ".$prefix."_chuck_norris_facts")) {
				$row = 1;
				$grille = array();
				if (($handle = fopen($fichier, "r")) !== FALSE) {
				    while (($data = fgetcsv($handle, 1000, ";","\"")) !== FALSE) {
				        /*$num = count($data);
				        echo "<p> $num fields in line $row: <br /></p>\n";
				        $row++;
				        for ($c=0; $c < $num; $c++) {
				            echo $data[$c] . "<br />\n";
				        }*/
						$grille[] = $data;
				    }
				    fclose($handle);
				}
				unlink($fichier);
//				echo "<pre>";
//				print_r($grille);
				unset($grille[0]);
				$domaines = array();
				$types = array();
				foreach ($grille as $acteur) {
					if ($acteur[17] != "") {
						$temp = explode(";",$acteur[17]);
						foreach ($temp as $elt) {
							$domaines[] = trim($elt);
						}
					}
					if ($acteur[10] != "") {
						$types[] = trim($acteur[10]);
					}
				}
				$domaines = array_map("ucfirst",$domaines);
				$domaines = array_unique($domaines);
//				print_r($domaines);
				$db->sql_query("TRUNCATE ".$prefix."_annuaireacteur_liste_domaine");
				$valeurs = "";
				foreach ($domaines as $domaine) {
					$valeurs .= ($valeurs != "") ? "," : "";
					$valeurs .= "('".str_replace("'","''", $domaine)."')";
				}
				$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_liste_domaine` (`domainename`) VALUES $valeurs;");
				$result = $db->sql_query("Select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine");
				$domaines = array();
				while ($ligne = $db->sql_fetchrow($result)) {
					$domaines[$ligne["domainename"]] = $ligne["domid"];
				}
//				print_r($domaines);
				$types = array_map("ucfirst",$types);
				$types = array_unique($types);
//				print_r($types);
				$db->sql_query("TRUNCATE ".$prefix."_annuaireacteur_liste_type");
				$valeurs = "";
				foreach ($types as $type) {
					$valeurs .= ($valeurs != "") ? "," : "";
					$valeurs .= "('".str_replace("'","''", $type)."')";
				}
				$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_liste_type` (`type_organisme`) VALUES $valeurs;");
				$result = $db->sql_query("Select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type");
				$types = array();
				while ($ligne = $db->sql_fetchrow($result)) {
					$types[$ligne["type_organisme"]] = $ligne["typid"];
				}
//				print_r($types);
				$types[""] = "";
				
				$db->sql_query("TRUNCATE ".$prefix."_annuaireacteur_acteur");
				$db->sql_query("TRUNCATE ".$prefix."_annuaireacteur_domaine");
				$db->sql_query("TRUNCATE ".$prefix."_annuaireacteur_contact");
				foreach ($grille as $acteur) {
					$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_acteur` (
`nom_acteur`,`adresse_acteur`,`codepostal_acteur`,`ville_acteur`,`pays_acteur`
,`region_acteur`,`telephone_acteur`,`fax_acteur`,`email_acteur`,`web_acteur`
,`type_acteur`,`status_acteur`,`mission_acteur`,`projets_acteur`,`sigle_acteur`
,`nom_president_acteur`,`nom_directeur_acteur`,`date_acteur`,`informant`
) 
VALUES (
'".str_replace("'","''",$acteur[0])."','".str_replace("'","''",$acteur[1])."','".str_replace("'","''",$acteur[2])."','".str_replace("'","''",$acteur[3])."','".str_replace("'","''",$acteur[4])."',
'".str_replace("'","''",$acteur[5])."','".str_replace("'","''",$acteur[6])."','".str_replace("'","''",$acteur[7])."','".str_replace("'","''",$acteur[8])."','".str_replace("'","''",$acteur[9])."',
'".$types[ucfirst(trim($acteur[10]))]."','','".str_replace("'","''",$acteur[12])."','".str_replace("'","''",$acteur[13])."','".str_replace("'","''",$acteur[14])."',
'".str_replace("'","''",$acteur[15])."','".str_replace("'","''",$acteur[16])."', now(), '".str_replace("'","''",$aid)."'
);");
					$acteurid = $db->sql_nextid();
					if ($acteur[17] != "") {
						$temp = explode(";",$acteur[17]);
//						echo "\n".$acteur[0]." : ".$acteur[17];
						foreach ($temp as $elt) {
//							echo " : ".$domaines[ucfirst(trim($elt))];
							$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_domaine` (`acteur_actid`,`domaine_domid`,`domaine`,`com_domaine`) 
VALUES ('".$acteurid."','".$domaines[ucfirst(trim($elt))]."','".str_replace("'","''",ucfirst(trim($elt)))."','".str_replace("'","''",$acteur[0])."');");
						}
					}
					if (trim($acteur[18].$acteur[19]) != "") {
						$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_contact` (`acteur_actid`,`nom_contact`,`prenom_contact`,`telephone_contact`,`email_contact`,`role_contact`,`informant`) 
VALUES ('".$acteurid."','".str_replace("'","''",$acteur[18])."','".str_replace("'","''",$acteur[19])."','".str_replace("'","''",$acteur[21])."','".str_replace("'","''",$acteur[22])."','".str_replace("'","''",$acteur[20])."','".str_replace("'","''",$aid)."');");
					}
					if (trim($acteur[23].$acteur[24]) != "") {
						$db->sql_query("INSERT INTO `".$prefix."_annuaireacteur_contact` (`acteur_actid`,`nom_contact`,`prenom_contact`,`telephone_contact`,`email_contact`,`role_contact`,`informant`) 
VALUES ('".$acteurid."','".str_replace("'","''",$acteur[23])."','".str_replace("'","''",$acteur[24])."','".str_replace("'","''",$acteur[26])."','".str_replace("'","''",$acteur[27])."','".str_replace("'","''",$acteur[25])."','".str_replace("'","''",$aid)."');");
					}
				}
				
				
//				echo "</pre>";
			}
		}
	}
	Header("Location: system.php?op=annuaireActeur");
	die();
 }

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
switch ($op) {
case "annuaireActeur":
    annuaireActeur($onglet, $editid, $editForm, $myfilter, $myfiltertwo);
    break;
case "acteurEdit":
    acteurEdit($actid, $editForm, $asHtml);
    break;
case "contactEdit":
    contactEdit($contactid, $editForm, $asHtml);
    break;
case "competenceEdit":
    competenceEdit($domid, $editForm, $asHtml);
    break;
case "activiteEdit":
    activiteEdit($actid);
    break;
case "typeEdit":
    typeEdit($typid,$editForm, $asHtml);
    break;
case "statusEdit":
    typeEdit($statusid, $editForm, $asHtml);
    break;
case "activiteDelete":
    activiteDelete($actid, $ok);
    break;
case "contactDelete":
    contactDelete($contactid, $ok);
    break;
case "competenceDelete":
    competenceDelete($domid, $ok);
    break;     
case "acteurDelete":
    acteurDelete($actid, $ok);
    break; 
case "typeDelete":
    typeDelete($typid, $ok);
    break; 
case "statusDelete":
    statusDelete($statusid, $ok);
    break; 
case "acteurSave":
    acteurSave($actid,$refid, $nom_acteur,$adresse_acteur,$ville_acteur,$codepostal_acteur,$sigle_acteur,$telephone_acteur,$fax_acteur,$email_acteur,$web_acteur,$nom_president_acteur,$nom_directeur_acteur,$type_acteur,$status_acteur,$mission_acteur,$carte_acteur,$domaine_acteur, $activite_acteur, $informant, $pays_acteur, $region_acteur, $projets_acteur);
    break; 
case "activiteSave":
    activiteSave($actid, $activiteData);
    break; 
case "contactSave":
    contactSave($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact);
    break;  
case "competenceSave":
    competenceSave($domid, $domainename);
    break;       
case "typeSave":
    typeSave($typid, $typename);
    break;  
case "statusSave":
    statusSave($statusid, $statusname);
    break; 
case "annuactimport":
	import_csv();
	break;
}

}
else {
    display_denied();
}

?>