<?php
/**
* Fonctions d'accs  la base de donnes pour manipuler l'arborescence des menus.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsDynMenu
* @version 1.2
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
* @todo Vrifier le retour des fonctions upMenu() et downMenu()
*/

/**
* Retourne le menu complet
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $menu Identifiant du menu  retourner
* @return array Tableau de trois tableaux manipuls par les fonctions d'affichage des menus
*/
function getArrayMenu($Myqsl,$menu) {
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];	
	$result=$db->sql_query("SELECT * FROM ".$MyqslTable." WHERE `idmenu`='".$menu."' ORDER BY position ASC, ID ASC");
	
	if($db->sql_numrows($result)==0 ) {
		//die ("<div align=center>Aucun menu n'est disponible</div><br><br>");
		$table = array();
		$partable = array();
		$Folder = array();
	}
	
	$i=0;
	while($Folder0 = list($ID,$Name,$Description,$CreateUser,$CreateDate,$ModifyDate,$LastVisit,$Parent,$PublicUse,$position,$URL,$Target,$nomenu,$idmenu,$picture) = $db->sql_fetchrow($result,$i)) {
		$i++;
		$Folder0["Name"] = nl2br(htmlentities($Folder0["Name"],ENT_QUOTES, "ISO-8859-1"));
		$Folder0["picture"] = $picture;
		$table[$Parent][$ID]=$Name;
		$partable[$ID]=$Parent;
		$Folder[$ID]=$Folder0;
	}
	$db->sql_freeresult($result);
	unset($Folder0);
	$sortie = array("table" => $table, "partable" => $partable, "Folder" => $Folder);
	return $sortie;
}

/**
 * Retourne le menu complet
 * @param array $Myqsl Paramtres de la base de donnes
 * @param integer $menu Identifiant du menu  retourner
 * @return array Tableau de trois tableaux manipuls par les fonctions d'affichage des menus
 */
function getArrayMenuPlan($Myqsl) {
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	
	$result=$db->sql_query("SELECT * FROM ".$MyqslTable." WHERE pos_plan > 0 ORDER BY pos_plan ASC, position ASC");

	if($db->sql_numrows($result)==0 ) {
		//die ("<div align=center>Aucun menu n'est disponible</div><br><br>");
		$table = array();
		$partable = array();
		$Folder = array();
	}

	$i=0;
	while($Folder0 = list($ID,$Name,$Description,$CreateUser,$CreateDate,$ModifyDate,$LastVisit,$Parent,$PublicUse,$position,$URL,$Target,$nomenu,$idmenu,$picture, $pos_plan) = $db->sql_fetchrow($result,$i)) {
		$i++;
		$Folder0["Name"] = nl2br(htmlentities($Folder0["Name"],ENT_QUOTES, "ISO-8859-1"));
		$Folder0["picture"] = $picture;
		$table[$Parent][$ID]=$Name;
		$partable[$ID]=$Parent;
		$Folder[$ID]=$Folder0;
	}
	$db->sql_freeresult($result);
	unset($Folder0);
	$sortie = array("table" => $table, "partable" => $partable, "Folder" => $Folder);
	return $sortie;
}

/**
* rcupration d'une ligne du menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu  retourner
* @return array Tableau de tous les composants du menu
*/
function getOneMenu($Myqsl,$numMenu,$menu) {
	$sortie = array();
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];	
	$result=$db->sql_query("SELECT * FROM ".$MyqslTable." WHERE `ID`='".$numMenu."' AND `idmenu`='".$menu."'");
	if($db->sql_numrows($result)!=0 ) {		
		$i=0;
		if ($ligne = $db->sql_fetchrow($result)) {
			$i++;
			$sortie = array("ID" => $ligne["ID"], "Name" => $ligne["Name"],"Description" => $ligne["Description"],"CreateUser" => $ligne["CreateUser"],"CreateDate" => $ligne["CreateDate"],"ModifyDate" => $ligne["ModifyDate"],"LastVisit" => $ligne["LastVisit"],"Parent" => $ligne["Parent"],"PublicUse" => $ligne["PublicUse"],"position" => $ligne["position"],"url" => $ligne["url"],"target" => $ligne["target"],"nomenu" => $ligne["nomenu"],"idmenu" => $ligne["idmenu"],"picture" => $ligne["picture"]);
		}
	}
	$db->sql_freeresult($result);
	return $sortie;
}

/**
* Teste l'existence d'un sous-menu pour la ligne du menu dsign
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu  tester
* @return bool true : avec sous-menu; false : sans sousmenu
*/
function subMenu($Myqsl,$numMenu,$menu) {
	$sortie = false;
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];	
	$result=$db->sql_query("SELECT `ID` FROM ".$MyqslTable." WHERE `Parent`='".$numMenu."' AND `idmenu`='".$menu."'");	
	if($db->sql_numrows($result)!=0 ) {
		$sortie = true;
	}
	$db->sql_freeresult($result);
	return $sortie;
}

/**
* Donne la position d'une nouvelle ligne dans un menu ou un sous-menu
* 
* Les position des lignes est relative : elle repart  un pour chaque sous-menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu auquel un sous-menu doit tre ajout
* @return integer Position de la prochaine ligne
*/
function NextSubMenuPos($Myqsl,$numMenu,$menu) {
	$sortie = 0;
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];	
	$result=$db->sql_query("SELECT Max(`position`) as Prochain FROM ".$MyqslTable." WHERE `Parent`='".$numMenu."' AND `idmenu`='".$menu."'");	
	if($db->sql_numrows($result)!=0 ) {	
		$i=0;
		$ligne = $db->sql_fetchrow($result);
		if ($ligne["Prochain"] != "") {
			$sortie = $ligne["Prochain"];
		}
		else {
			$sortie = 0;
		}
	}
	return $sortie + 1;
}

/**
* Fait remonter la ligne de menu dsigne d'une position
* 
* Les position des lignes est relative : elle repart  un pour chaque sous-menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu  monter
* @return bool true
*/
function upMenu($Myqsl,$numMenu,$menu) {
	$sortie = true;
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	$MenuCourant = getOneMenu($Myqsl,$numMenu,$menu);
	
	$sql = "SELECT `ID`,`position` FROM ".$MyqslTable." WHERE `Parent`='".$MenuCourant["Parent"]."' AND `idmenu`='".$menu."' ORDER BY `position` ASC;";	
	$result=$db->sql_query($sql);
		
	if($db->sql_numrows($result)!=0 ) {
		$oldId = "";
		$i=0;
		while ($ligneEncours = $db->sql_fetchrow($result)) {
			$i++;
			if (($ligneEncours["ID"] == $numMenu) && ($oldId != "")) {
				$sql = "UPDATE `".$MyqslTable."` SET `position` = '".$oldpos."' WHERE `ID` = '".$numMenu."' AND `idmenu`='".$menu."';";				
				if (!$db->sql_query($sql)) {
					$sortie = false;
				}
				$sql = "UPDATE `".$MyqslTable."` SET `position` = '".$ligneEncours["position"]."' WHERE `ID` = '".$oldId."' AND `idmenu`='".$menu."';";
				//if (!mysql_query($sql,$Myqsl["maBase"])) {
				if (!$db->sql_query($sql)) {
					$sortie = false;
				}
			}
			else {
				$oldId = $ligneEncours["ID"];
				$oldpos = $ligneEncours["position"];
			}
		}
	}
	return true;
}

/**
* Fait descendre la ligne de menu dsigne d'une position
* 
* Les position des lignes est relative : elle repart  un pour chaque sous-menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu  descendre
* @return bool true
*/
function downMenu($Myqsl,$numMenu,$menu) {
	$sortie = true;
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	$MenuCourant = getOneMenu($Myqsl,$numMenu,$menu);
	
	$sql = "SELECT `ID`,`position` FROM ".$MyqslTable." WHERE `Parent`='".$MenuCourant["Parent"]."' AND idmenu='".$menu."' ORDER BY `position` DESC;";	
	$result=$db->sql_query($sql);
	
	if($db->sql_numrows($result)!=0 ) {
		$oldId = "";		
		$i=0;
		while ($ligneEncours = $db->sql_fetchrow($result)) {
			$i++;
			if (($ligneEncours["ID"] == $numMenu) && ($oldId != "")) {
				$sql = "UPDATE `".$MyqslTable."` SET `position` = '".$oldpos."' WHERE `ID` = '".$numMenu."' AND `idmenu`='".$menu."';";				
				if (!$db->sql_query($sql)) {
					$sortie = false;
				}
				$sql = "UPDATE `".$MyqslTable."` SET `position` = '".$ligneEncours["position"]."' WHERE `ID` = '".$oldId."' AND `idmenu`='".$menu."';";				
				if (!$db->sql_query($sql)) {
					$sortie = false;
				}
			}
			else {
				$oldId = $ligneEncours["ID"];
				$oldpos = $ligneEncours["position"];
			}
		}
	}
	$db->sql_freeresult($result);
	return true;
}

/**
* Cration ou modification d'une ligne de menu
* 
* Si l'identifiant est gal  -1, la ligne est cre, sinon elle est modifie
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menu Tableau contenant tous les lment d'une ligne de menu
* @return bool Rsultat de l'enregistrement
*/
function saveOneMenu($Myqsl,$menu) {
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	if ($menu["ID"] != "-1") {
		$sql = "UPDATE `".$MyqslTable."` SET `Name` = '".$menu["Name"]."', `Description` = '".$menu["Description"]."', `ModifyDate` = '".$menu["ModifyDate"]."', `PublicUse` = '".$menu["PublicUse"]."', `position` = '".$menu["position"]."', `url` = '".$menu["url"]."', `target` = '".$menu["target"]."', `nomenu` = '".$menu["nomenu"]."', `idmenu` = '".$menu["idmenu"]."', `Parent` = '".$menu["Parent"]."', `picture` = '".$menu["picture"]."' WHERE `ID` = '".$menu["ID"]."';";
	}
	else {
		$sql = "INSERT INTO `".$MyqslTable."` (`Name`, `Description`, `CreateDate`, `Parent`, `PublicUse`, `position`, `url`, `target`, `nomenu`, `idmenu`, `picture`) VALUES ('".$menu["Name"]."', '".$menu["Description"]."', '".$menu["CreateDate"]."', '".$menu["Parent"]."', '".$menu["PublicUse"]."', '".$menu["position"]."', '".$menu["url"]."', '".$menu["target"]."', '".$menu["nomenu"]."', '".$menu["idmenu"]."', '".$menu["picture"]."');";
	}
	$result = $db->sql_query($sql);
	
	return $result;
}

/**
* Fait remonter la ligne de menu dsigne d'un niveau hirarchique
* 
* Les position des lignes est relative : elle repart  un pour chaque sous-menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne de menu  modifier
* @return bool Rsultat de l'enregistrement
*/
function upArboMenu($Myqsl,$numMenu,$menu) {
	
	$result = false;
	$MenuCourant = getOneMenu($Myqsl,$numMenu,$menu);
	if ($MenuCourant["Parent"] != 0) {
		$MenuParent = getOneMenu($Myqsl,$MenuCourant["Parent"],$menu);
		$position = NextSubMenuPos($Myqsl,$MenuParent["Parent"],$menu);
		$MenuCourant["Parent"] = $MenuParent["Parent"];
		$MenuCourant["position"] = $position;
		$result = saveOneMenu($Myqsl,$MenuCourant);
	}
	
	return $result;
}

/**
* Fixe le niveau hirarchique de la ligne de menu dsigne
* 
* Les position des lignes est relative : elle repart  un pour chaque sous-menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $parent Identifiant du nouveau parent de la ligne de menu
* @param integer $menu Identifiant de la ligne de menu dsigne
* @return bool Rsultat de l'enregistrement
*/

function conditionnertodblocal($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",$texte));
	}

function fixArboMenu($Myqsl,$numMenu,$parent,$menu) {
	
	$MenuCourant = getOneMenu($Myqsl,$numMenu,$menu);
	$position = NextSubMenuPos($Myqsl,$parent,$menu);
	$MenuCourant["Parent"] = $parent;
	$MenuCourant["position"] = $position;
	$MenuCourant = array_map("conditionnertodblocal",$MenuCourant);
	$result = saveOneMenu($Myqsl,$MenuCourant);
	
	return $result;
}

/**
* Renvoie toutes les lignes du menu dsign dans un tableau
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $menu Identifiant du menu dsign
* @return array Tableau contenant toutes les lignes
*/
function allArboMenu($Myqsl,$menu) {
	
	$result = array();
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	$ligne = $db->sql_query("SELECT * FROM ".$MyqslTable." WHERE `idmenu`='".$menu."' ORDER BY position ASC, ID ASC");
	if($db->sql_numrows($ligne)!=0 ) {
		$i=0;
		while ($unmenu = $db->sql_fetchrow($ligne)) {
			$i++;
			$result[$i-1]["Nom"] .= $unmenu["Name"];
			$result[$i-1]["Id"] .= $unmenu["ID"];
			$result[$i-1]["Chemin"] .= $unmenu["ID"]."|";
			$sortir= false;
			while (($unmenu["Parent"] != 0) && !$sortir) {
				$vieuxParent = $unmenu["Parent"];
				$unmenu = getOneMenu($Myqsl,$unmenu["Parent"],$menu);
				$result[$i-1]["Chemin"] .= $unmenu["ID"]."|";
			}
			$result[$i-1]["Chemin"] .= "0\n";
		}
		
	}
	return $result;
}


/**
* Suppression d'une ligne de menu et des sous menu qui lui sont attachs
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menu Tableau contenant la ligne du menu dsigne
* @return bool Rsultat de la suppression
*/
function delOneMenu($Myqsl,$menu) {
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	$result = true;
	//suppresion des enfants
	if ($menu["ID"] != "") {
		$sql = "SELECT * FROM `".$MyqslTable."` WHERE `Parent` = '".$menu["ID"]."' AND `idmenu`='".$menu["idmenu"]."';";
		$ligne = $db->sql_query($sql);		
		if($db->sql_numrows($ligne)!=0 ) {			
			$i=0;
			while ($unmenu = $db->sql_fetchrow($ligne)) {
				$i++;
				$result = $result && delOneMenu($Myqsl,array("ID" => $unmenu["ID"],"idmenu" => $menu["idmenu"]));
			}
		}
	}
	//suppression du menu
	if ($menu["ID"] != "") {
		$sql = "DELETE FROM `".$MyqslTable."` WHERE `ID` = '".$menu["ID"]."' AND `idmenu`='".$menu["idmenu"]."';";
	}
	$result = $result && $db->sql_query($sql,$Myqsl);
	
	return $result;
}

/**
* Renvoie tous les menus ou un unique menu dans un tableau
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $typem Identifiant du menu dsign
* @return array Tableau contenant le ou les menus
*/
function getFamilies($Myqsl,$typem="") {
	$sortie = array();
	$MyqslTable=$Myqsl["Famille"];
	$db=$Myqsl["maBase"];
	$sql = "SELECT * FROM `".$MyqslTable."`";
	if ($typem != "") {
		$sql .= " WHERE `Id`='".$typem."'";
	}
	
	$result=$db->sql_query($sql);	
	
	if($db->sql_numrows($result)!=0 ) {		
		$i=0;
		while ($ligne = $db->sql_fetchrow($result)) {
			$i++;
			array_push($sortie,array("Id" => $ligne["Id"], "intitule" => $ligne["intitule"],"genre" => $ligne["genre"],"langue" => $ligne["langue"]));
		}
	}
	return $sortie;
}

/**
* Cration ou modification d'un menu
* 
* Si l'identifiant est gal  -1, le menu est cr, sinon il est modifi
* @param integer $retourmenu Retourne le numro du menu modifi ou cr
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menu Tableau contenant le menu  enregistrer
* @return bool Rsultat de l'enregistrement
*/
function saveFamilyMenu(&$retourmenu,$Myqsl,$menu) {
	$MyqslTable=$Myqsl["Famille"];
	$db=$Myqsl["maBase"];
	if ($menu["Id"] != "-1") {
		$sql = "UPDATE `".$MyqslTable."` SET `intitule` = '".$menu["intitule"]."', `genre` = '".$menu["genre"]."', `langue` = '".$menu["langue"]."' WHERE `Id` = '".$menu["Id"]."';";
	}
	else {
		$sql = "INSERT INTO `".$MyqslTable."` (`intitule`, `genre`, `langue`) VALUES ('".$menu["intitule"]."', '".$menu["genre"]."', '".$menu["langue"]."');";
	}
	$result = $db->sql_query($sql);
	if ($result && $menu["Id"] == "-1") {
		//$retourmenu = mysql_insert_id($Myqsl["maBase"]);
		$retourmenu = getLastId($Myqsl);
	}
	else {
		$retourmenu = $menu["Id"];
	}
	return $result;
}

/**
* Suppression d'un menu et des lignes qui lui sont attachs
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $menu Identifiant du menu  supprimer
* @return bool Rsultat de la suppression
*/
function delFamilyMenu($Myqsl,$menu) {
	//suppression des lignes du menu
	$result2 = false;
	$MyqslTable=$Myqsl["Table"];
	$db=$Myqsl["maBase"];
	if ($menu["Id"] != "") {
		$sql = "DELETE FROM `".$MyqslTable."` WHERE `idmenu`='".$menu["Id"]."';";		
		$result1 = $db->sql_query($sql);
		if ($result1) {
			//suppression du menu
			$MyqslTable=$Myqsl["Famille"];
			$sql = "DELETE FROM `".$MyqslTable."` WHERE `Id` = '".$menu["Id"]."';";			
			$result2 = $result1 && $db->sql_query($sql);
		}
		else {
			$result2 = false;
		}
	}
	return $result2;
}

/*------------------------------------------------*/
/*     identifiant du premier menu non nul        */
/*------------------------------------------------*/
/**
* Renvoie l'identifiant du premier menu non nul
* 
* Cette fonction est pricipalement utilise aprs la suppresion d'un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return integer Identifiant du menu
*/
function firstFamilyMenu($Myqsl) {
	$MyqslTable=$Myqsl["Famille"];
	$db=$Myqsl["maBase"];
	$sql = "SELECT Min(`Id`) AS Premiermenu FROM `".$MyqslTable."`;";
	$result = $db->sql_query($sql);
	if($db->sql_numrows($result)!=0) {		
		$i=0;
		$ligne = $db->sql_fetchrow($result);
		if ($ligne["Premiermenu"] != "") {
			$sortie = $ligne["Premiermenu"];
		}
		else {
			$sortie = 0;
		}
	}
	else {
		$sortie = 0;
	}
	return $sortie;
}

/*------------------------------------------------*/
/*           Chemin jusqu' un menu               */
/*------------------------------------------------*/
/**
* Renvoie le chemin des menus pour accder  un menu particulier
* 
* Cette fonction est utilise pour la fabrication de la barre de navigation
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $numMenu Identifiant du menu
* @param integer $menu Identifiant de la ligne du menu  retourner
* @return array Tableau de l'enchainement des menus
*/
function getPathMenu($Myqsl,$numMenu,$menu) {
	$sortie = array();
	while ($menu != 0) {
		$lignem = getOneMenu($Myqsl,$menu,$numMenu);
		$menu = $lignem["Parent"];
		array_push ($sortie, $lignem);
	}
	return $sortie;
}
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($Myqsl) {
		$db=$Myqsl["maBase"];
		return $db->sql_nextid();
	}
?>