<?php
/**
* Fonctions publique d'interface entre le CMS et le module de menus.
* 
* @package becmsDynMenu
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (preg_match("#connector_lib.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

include_once("modules/becmsDynMenu/lib/g_db.php");
include_once("modules/becmsDynMenu/lib/becms_menu_class.php");

/**
* Retourne le menu complet  insrer dans le thme choisi
* 
* Les menus disponible sont les suivants :
* 1 : Hierarchique - 4 : Arborescent - 2 : Droulant Horizontal (OEC,OCIC) - 3 : Droulant Vertical - 7 : Colonne droulante verticale - 8 : Colonne droulante verticale unique (Zonza) - 6 : Colonne droule fixe verticale - 9 : Droulant Vertical Unique (Corbara,Demo)
* Peut ncessiter l'usage de l'apel  la fonction getJS() pour implmenter l'affichage de menu droulants dans IE.
* @param integer $Id Identifiant du menu
* @param integer $typeforced Type de menu fix par le thme
* @return string Menu complet format en HTML
*/
function getmenu($Id,$typeforced="") {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
		
	if ($typeforced == "") {
		$typeMenu = genreMenu($Myqsl,$Id);
	}
	else {
		$typeMenu = $typeforced;
	}
	
	
	if (file_exists("themes/".get_theme()."/style/menus")){
    		$cheminstyle = "themes/".get_theme()."/style/menus/";
    }
    elseif (file_exists("modules/becmsDynMenu/css/")) {    	
        $cheminstyle = "modules/becmsDynMenu/css/";        
    }
		
	//$cheminstyle = "themes/".get_theme()."/style/menus/";
	$fichierStyle = $cheminstyle."M".$Id."T".$typeMenu.".css";
	if (!file_exists($fichierStyle)) {
		$fichierStyle = $cheminstyle."M1T".$typeMenu.".css";
	}
	//$style=implode("",file($fichierStyle));
	$style = '<link href="'.$fichierStyle.'" rel="stylesheet" type="text/css" media="all">';
	$initForIE="";
	switch ($typeMenu) {
		case "1" :
			$menuclass = new menuHierarchique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns);
			break;
		case "2" :
			$menuclass = new menuDeroulantH();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns);
			$initForIE="\n<script type=\"text/javascript\">setHover($Id);</script>";
			break;
		case "3" :
			$menuclass = new menuDeroulantV();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns);
			$initForIE="\n<script type=\"text/javascript\">setHover($Id);</script>";
			break;
		case "4" :
			$menuclass = new menuArborescent();
			$menuclass->initMenu($Id);
			$menubrut = $menuclass->MakeTree($Myqsl,$modmenu,$icns);
			/*$temp = $menuclass->varlocal["V1"];
			if (!isset($$temp)) {
				$$temp = "";
			}			
			$menu = $menuclass->MenuArbo($Myqsl,$menubrut,$modmenu,$icns,$$temp);*/
			$temp = $GLOBALS[$menuclass->varlocal["V1"]];
			$menu = $menuclass->MenuArbo($Myqsl,$menubrut,$modmenu,$icns,$temp);
			break;
		case "6" :
			$menuclass = new menuColonneStatique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns); 
			break;
		case "7" :
			$menuclass = new menuColonneDynamique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns); 
			break;
		case "8" :
			$menuclass = new menuColonneDynamiqueUnique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns); 
			break;
		case "9" :
			$menuclass = new menuDeroulantVUnique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns);
			$initForIE="\n<script type=\"text/javascript\">setHover($Id);</script>";
			break;
		case "10" :
			$menuclass = new menuTableauHUnique();
			$menuclass->initMenu($Id);
			$menu = $menuclass->MakeTree($Myqsl,$modmenu,$icns); 
			break;
		default :
			$menu = "Menu introuvable";
			break;
	}
	return $style.$menu.$initForIE;
}
/**
* Retourne la barre de navigation  insrer dans le thme choisi
* 
* Les barres disponibles sont les suivantes :
* 1 : Colonne fixe verticale  trois niveaux (Corbara)
* @param integer $typeNavig Type de barre de navigation
* @param string $titre Titre de barre de navigation
* @return string Barre de navigation complte formate en HTML
*/
function getnavig($typeNavig,$titre,$lien="") {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
		
	$cheminstyle = "themes/".get_theme()."/style/menus/";
	$fichierStyle = $cheminstyle."N1T".$typeNavig.".css";
	/*if (!file_exists($fichierStyle)) {
		$fichierStyle = $cheminstyle."N1T".$typeNavig.".css";
	}*/
	$style = '<link href="'.$fichierStyle.'" rel="stylesheet" type="text/css" media="all">';
	
	switch ($typeNavig) {
		case "1" :
			$navigclass = new navigDerouleeV();
			$navig = $navigclass->MakePath($Myqsl,$modmenu,$icns,$titre,$lien);
			break;
		default :
			$navig= "Navigation introuvable";
			break;
	}
	return $style.$navig;
}

function getnavigatom() {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	$navigclass = new navigArray();
	return $navigclass->MakeTree($Myqsl,$modmenu,$icns);
}

/**
* Retourne le plan du site  insrer dans la page choisie
* 
* Les plans disponibles sont les suivants :
* 1 : liste ul hierarchique
* @param integer $typePlan Type de plan
* @param integer $menus Numros des menus  afficher
* @return string plan complet format en HTML
*/
function getplan($typePlan,$menus) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	if ($menus == "") {
		return "Plan introuvable";
	}
	else {
		$menusT = explode(",",$menus);
	}
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
		
	$cheminstyle = "themes/".get_theme()."/style/plans/";
	$fichierStyle = $cheminstyle."PLT".$typePlan.".css";
	/*if (!file_exists($fichierStyle)) {
		$fichierStyle = $cheminstyle."N1T".$typeNavig.".css";
	}*/
	if (file_exists($fichierStyle)) {
		$style = '<link href="'.$fichierStyle.'" rel="stylesheet" type="text/css" media="all">';
	}
	else {
		$style = '<link href="modules/becmsDynMenu/css/PLT1.css" rel="stylesheet" type="text/css" media="all">';
	}
	
	switch ($typePlan) {
		case "1" :
			$planclass = new planListe();
			$plan ="<ul class=\"bloc_plan\">";
			foreach($menusT as $menuencours){
				$planclass->initPlan($menuencours);
				$plan .= "<li class=\"bloc_plan\">";
				$plan .= $planclass->MakeTree($Myqsl,$modmenu,$icns);
				$plan .= "</li>";
			}
			$plan .= "</ul>";
			break;
		default :
			$plan= "Plan introuvable";
			break;
	}
	return $style.$plan;
}
/**
* Retourne le code pour insrer le script Javascript pour drouler certains menus sous IE.
* 
* @return string Code pour intgrer la librairie "menu_act.js".
*/
function getJS() {
	return "<script type=\"text/javascript\" src=\"modules/becmsDynMenu/lib/menu_act.js\"></script>";
}

function getmenuarray($Id) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	$menuclass = new menuElements();
	$menuclass->initMenu($Id);
	return $menuclass->MakeTree($Myqsl,$modmenu,$icns);
}

function getmenuatom($Id, $withEmptylines = false) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	$menuclass = new menuArray();
	$menuclass->initMenu($Id, $withEmptylines);
	return $menuclass->MakeTree($Myqsl,$modmenu,$icns);
}

function getmenuatomplan($Id) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;

	include("modules/becmsDynMenu/lib/g_params.php");

	$Myqsl["maBase"] = $db;

	$menuclass = new menuArrayPlan();
	$menuclass->initMenu($Id);
	return $menuclass->MakeTree($Myqsl,$modmenu,$icns);
}

function getmenulabel($Id,$numMenu) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	$menuTab = getOneMenu($Myqsl,$numMenu,$Id);
	$menuTab["Name"] = str_replace("\\n"," ",$menuTab["Name"]);
	
	return $menuTab["Name"];
}

function getmenuXML($Id) {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	$menuclass = new menuXML();
	$menuclass->initMenu($Id);
	$sortie = '<?xml version="1.0" encoding="UTF-8"?>';
	$sortie .= "\n".'<?xml-stylesheet type="text/xsl" href="modules/becmsDynMenu/lib/menu.xsl"?>';
	$sortie .= "\n".'<!DOCTYPE menus SYSTEM "modules/becmsDynMenu/lib/menu.dtd">';
	$sortie .= $menuclass->MakeTree($Myqsl,$modmenu,$icns);
	return $sortie;
}

function getfamilymenulist() {
	global $db;
	global $Myqsl;
	global $modmenu;
	global $icns;
	
	include("modules/becmsDynMenu/lib/g_params.php");
	
	$Myqsl["maBase"] = $db;
	
	return getFamilies($Myqsl);
}
?>