//<![CDATA[

//Decode points
function decodeLine(encoded) {
	var len = encoded.length;
	var index = 0;
	var array = [];
	var lat = 0;
	var lng = 0;
	try {
		while (index < len) {
			var b;
			var shift = 0;
			var result = 0;
			do {
				b = encoded.charCodeAt(index++) - 63;
				result |= (b & 0x1f) << shift;
				shift += 5;
			} while (b >= 0x20);
			var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
			lat += dlat;

			shift = 0;
			result = 0;
			do {
				b = encoded.charCodeAt(index++) - 63;
				result |= (b & 0x1f) << shift;
				shift += 5;
			} while (b >= 0x20);
			var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
			lng += dlng;

			array.push(new google.maps.LatLng((lat * 1e-5), (lng * 1e-5)));
		}
	} catch (ex) {
		alert("error in encoding");
	}
	return array;
}

function clearOverlays() {
	for (var i = 0; i < markers.length; i++) {
	   markers[i].setMap(null);
	}
	markers = [];
}

function GetMap(id, idSite, theme, circuit) {
	if( map != null ) {
		return true;
	}
	var latitudeinitauto = 0;
	var longitudeinitauto = 0;
	if (window.JSON) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id, idSite, theme, circuit);
	 	}
		var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
		var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
		latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
		longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
		options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
		options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
		options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
		options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
		options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
		options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
		options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
		options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
		options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
		options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
		options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
		options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
		taille_hv = getXMLvalue(racine_carte,"option_taille");
		
		var sep_taille=new RegExp("[/]+", "g");
		var map_hv = String(taille_hv).split(sep_taille);
		options["map_h"] = String(map_hv[0]) + "px";
		options["map_v"] = String(map_hv[1]) + "px";
		options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
		options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
		/*if (eval(getXMLvalue(racine_carte,"latitudeinitadhs")) != 0 && eval(getXMLvalue(racine_carte,"longitudeinitadhs")) != 0) {
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
		}*/
		leDiv = document.getElementById("map");
		if (leDiv == null) {
			return false;
		}
		
		//map = new GMap2(leDiv,{mapTypes: [G_NORMAL_MAP,G_HYBRID_MAP]});
		var mapOptions = {
			center: new google.maps.LatLng(latitudeinit, longitudeinit),
	        zoom: zoominit,
	        mapTypeId: google.maps.MapTypeId.ROADMAP,
	        panControl: false,
			zoomControl: false,
			scaleControl: true,
			streetViewControl: true,
			streetViewControlOptions: {
		        position: google.maps.ControlPosition.TOP_CENTER
		    }
			 
	    };
		map = new google.maps.Map(leDiv, mapOptions);


		//ajout boutons zoom
		/*function ZoomPlusControl(map) {
			var container = document.createElement("div");
			container.style.marginTop = "10px";
			container.style.marginBottom = "10px";
			container.style.marginLeft = "10px";
			var containerDiv = document.createElement("div");
			containerDiv.style.cursor = "pointer";
			container.appendChild(containerDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/zoomplus.png";
			image.title = "Augmenter le zoom de la carte";
			containerDiv.appendChild(image);
			google.maps.event.addDomListener(containerDiv, "click", function() {
		   		map.setZoom(map.getZoom()+1);
			});
			return container;
		}
		var ZoomPlusControlDiv = new ZoomPlusControl(map);
		ZoomPlusControlDiv.index = 1;
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomPlusControlDiv);
		
		function ZoomMoinsControl(map) {
			var container = document.createElement("div");
			container.style.marginTop = "10px";
			container.style.marginBottom = "10px";
			container.style.marginLeft = "10px";
			var containerDiv = document.createElement("div");
			containerDiv.style.cursor = "pointer";
			container.appendChild(containerDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/zoommoins.png";
			image.title = "Augmenter le zoom de la carte";
			containerDiv.appendChild(image);
			google.maps.event.addDomListener(containerDiv, "click", function() {
		   		map.setZoom(map.getZoom()-1);
			});
			return container;
		}
		var ZoomMoinsControlDiv = new ZoomMoinsControl(map);
		ZoomMoinsControlDiv.index = 2;
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomMoinsControlDiv);*/
		
		function ZoomControl(map) {
			var container = document.createElement("div");
			container.style.marginBottom = "5px";
			container.style.marginRight = "5px";
			container.style.cursor = "pointer";
			container.style.border = "2px solid #cdcdcd";
			container.style.borderRadius = "7px";
			container.style.backgroundColor = "#fff";
			container.style.width = "30px";
			container.style.height = "65px";
			var image1 = document.createElement('img');
			image1.src = options["icon_control_circuit"]["zoomplus"];
			image1.title = "Zoom";
			image1.style.width = "24px";
			image1.style.margin = "3px";
			container.appendChild(image1);
			var separateur = document.createElement('hr');
			separateur.style.color = "#cdcdcd";
			separateur.style.backgroundColor = "#cdcdcd";
			container.appendChild(separateur);
			var image2 = document.createElement('img');
			image2.src = options["icon_control_circuit"]["zoommoins"];
			image2.title = "Unzoom";
			image2.style.width = "24px";
			image2.style.margin = "3px";
			container.appendChild(image2);
			google.maps.event.addDomListener(image1, "click", function() {
				map.setZoom(map.getZoom()+1);
			});
			google.maps.event.addDomListener(image2, "click", function() {
				map.setZoom(map.getZoom()-1);
			});;
			return container;
		};
		var ZoomControlDiv = new ZoomControl(map);
		ZoomControlDiv.index = 6;
		map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(ZoomControlDiv);
		
		//afficher les points du fonds de carte
		function createMarker(point,message,commentaire,chemicone,fiche,target) {
			var cont_mess = "";
			if (fiche != "") {
				if (message != "") {
					var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
				}
			}
			else {
				if (message != "") {
					var link_mess = "";
				}
			}
			cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
			var infowindow = new google.maps.InfoWindow({
			      content: cont_mess,
			      maxWidth: 250
			});
			
			var echelle = map.getZoom();
			if (echelle <= 14) {
				taille = 13;
			}
			else {
				if (echelle == 15) {
					taille =17;
				}
				else {
					if (echelle == 16) {
						taille = 21;
					}
					else {
						if (echelle == 17) {
							taille = 27;
						}
						else {
							taille =32;
						}
					}
				}
			}
			largeur = taille;
			hauteur = taille;
			var image = {
			    url: chemicone,
			    scaledSize: new google.maps.Size(largeur,hauteur),
			    origin: new google.maps.Point(0,0),
			    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
			};
			var marker = new google.maps.Marker({
			      position: point,
			      map: map,
			      title: message,
			      icon: image
			});
			google.maps.event.addListener(marker, 'click', function() {
			    infowindow.open(map,marker);
			});
			return marker;
		}
		
		function afficheLieux() {
			//affiche les pictos
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				while (point_courant) {
					var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					var tempMark = createMarker(point,message,commentaire,chemicone,fiche,target)
					if (tempMark != null) {
						markers.push(tempMark);
					}
					point_courant = next_sibling(point_courant);
				}
			}
		}
		
		//afficher les textes du fonds de carte
		function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
			if (test3D(map.getMapTypeId())) {
				return null;
			}
			var echelle = map.getZoom();
			
			if (echelle < options["seuil_texte"]) {
				return null;
			}
			
			if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
				var typeCarte = "P";
			}
			else {
				var typeCarte = "S";
			}
			
			tailleTab = tailleboxtxt.split(",");
			largeur = tailleTab[0];
			hauteur = tailleTab[1];
			var image = {
			    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
			    size: new google.maps.Size(largeur,hauteur),
			    origin: new google.maps.Point(0,0),
			    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
			};
			var marker = new google.maps.Marker({
			      position: point,
			      map: map,
			      title: message,
			      icon: image
			});
			if (fiche != "") {
				google.maps.event.addListener(marker, 'click', function() {
					if (target =="") {
						window.location.href = fiche;
					}
					else {
						window.open(fiche,target,'');
					}
				});
			}
			return marker;
		}
		
		function afficheTextes() {
			//affiche les pictos
			var points = getXMLchild(racine_carte,"textes");
			if (points != null) {
				var point_courant = getXMLchild(points,"texte");
				while (point_courant) {
					var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_texte")), eval(getXMLvalue(point_courant,"longitude_texte")));
					var fiche = getXMLvalue(point_courant,"lien_texte");
					var target = getXMLvalue(point_courant,"cible_texte");
					var message = getXMLvalue(point_courant,"lieu_texte");
					var commentaire = getXMLvalue(point_courant,"commentaire_texte");
					var tailleboxtxt = getXMLvalue(point_courant,"dim_texte");
					var angletxt = getXMLvalue(point_courant,"angle_texte");
					var couleurtxt = getXMLvalue(point_courant,"couleur_texte");
					var typotxt = getXMLvalue(point_courant,"police_texte");
					var tailletxt = getXMLvalue(point_courant,"taille_texte");
					var tempMark = createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
					if (tempMark != null) {
						markers.push(tempMark);
					}
					point_courant = next_sibling(point_courant);
				}
			}
		}
		
		//afficher polygones
		function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
			if (plein == "1") {
				var polygone = new google.maps.Polygon({
				    paths: decodeLine(points),
				    strokeColor: couleur,
				    strokeOpacity: 1,
				    strokeWeight: epaisseur,
				    fillColor: couleur,
				    fillOpacity: opacite
				  });
			}
			else {
				var polygone = new google.maps.Polygon({
				    paths: decodeLine(points),
				    strokeColor: couleur,
				    strokeOpacity: opacite,
				    strokeWeight: epaisseur,
				    fillColor: couleur,
				    fillOpacity: 0
				  });
			}
			if (fiche != "" && plein == "1") {
				google.maps.event.addListener(polygone, "click", function() {
					if (target == "") {
						window.location.href = fiche;
					}
					else {
						window.open(fiche,target,'');
					}
				});
			}
			polygone.setMap(map);
			
			return polygone;
		}
		
		function afficherPolygones() {
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var point_courant = getXMLchild(polygones,"polygone");
				while (point_courant) {
					var couleur = getXMLvalue(point_courant,"couleur");
					var epaisseur = eval(getXMLvalue(point_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(point_courant,"opacite"));
					var points = getXMLvalue(point_courant,"polyencode");
					var visibilite = getXMLvalue(point_courant,"polyvisibilite");
					var fiche = getXMLvalue(point_courant,"lien_polygone");
					var target = getXMLvalue(point_courant,"cible_polygone");
					var plein = getXMLvalue(point_courant,"plein");
					var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
					if (tempZone != null) {
						markers.push(tempZone);
					}
					point_courant = next_sibling(point_courant);
				}
			}
		}
		
		//limites de commune
		function afficherCBordure() {
			return true; //pour neutraliser la fonction
			/*var bordure = new GPolyline.fromEncoded({
				color: getXMLvalue(racine_carte,"points_couleur"),
				weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
				opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
				points: getXMLvalue(racine_carte,"points_bordure"),
				levels: getXMLvalue(racine_carte,"points_visibilite"),
				numLevels: 3,
				zoomFactor: 12
			});
			map.addOverlay(bordure);*/
		}
		
		/**
		 * Permet de créer un marker pour le site
		 * 
		 * @param point le point au placer le marker
		 * @param lieu le lieu
		 * @returns {GMarker} le marker
		 */
		function createSite(point, lieu, chemicone, id, image) {
			var largeur = 33;
			var hauteur = 40;	
			
			var icone = {
			    url: chemicone,
			    scaledSize: new google.maps.Size(largeur, hauteur),
			    origin: new google.maps.Point(0,0),
			    anchor: new google.maps.Point(Math.floor(largeur/2), hauteur)
			};
			
			var marker = new google.maps.Marker({
			      position: point,
			      map: map,
			      title: lieu,
			      icon:icone
			});
			
			/*var cont_mess = "";
			var image_mess = "";
			if( image != "" ) {
				image_mess = '<div style="text-align: center"><img src="' + image + '" alt="" style="max_width: 150px; max-height: 150px;" /></div>';
			}
			cont_mess = image_mess + '<div><p class="infobulle">' + lieu + '</p></div>';
			
			var infowindow = new google.maps.InfoWindow({
			      content: cont_mess,
			      maxWidth: 250  
			});
			
			google.maps.event.addListener(marker, 'click', function() {
			    infowindow.open(map, marker);
			});*/

			return marker;
		}
		
		/**
		 * Permet d'afficher les sites
		 */
		function afficheSite() {
			var points = getXMLchild(racine_carte, "symboles");
			if (points != null) {
				var point_courant = getXMLchild(points, "symbole");
				
				if( !point_courant ) {
					//document.getElementById('message_itineraire').innerHTML = "Aucun site associ�";
					alert("Aucun site associé a vos critères de recherche");
				}
				
				while (point_courant) {
					var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
					var id = getXMLparam(point_courant, "id_symb");
					var lieu = getXMLvalue(point_courant, "lieu_symb");
					var chemicone = getXMLvalue(point_courant, "picto_symb");
					var image = getXMLvalue(point_courant, "image_symb");
					var tempMark = createSite(point, lieu, chemicone, id, image);
					if (tempMark != null) {
						markers.push(tempMark);
						map.setCenter(tempMark.getPosition());
						map.setZoom(10);
					}
					point_courant = next_sibling(point_courant);
				}
			}
		}
		
		function zoomCarte() {
			var bounds = new google.maps.LatLngBounds();
			for(var i = 0; i < markers.length; i++) {
				bounds.extend(markers[i].getPosition());
			}
			
			var zoomDefault = 12;
			if( markers.length == 1 ) {
				map.setZoom(zoomDefault);
			} else {
				map.fitBounds(bounds);
			}
			map.setCenter(bounds.getCenter());
		}
		
		if (options["polygones"]) {
			afficherPolygones();
		}
		if (options["bordure"]) {
			afficherCBordure();
		}
		if (options["lieux"]) {
			afficheTextes();
			afficheLieux();
		}
		afficheSite();
		zoomCarte();
		if (options["titre"]) {
			titrer(id,'titre')
		}
		if (options ["obs"]) {
			listLieux(id,'obs');
		}
		if (options["commentaire"]) {
			commenter(id,'commentaire');
		}
	} else {
		alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre à jour.");
	}
}

function titrer(id,zone_id) {
	if (cartes == null) {
 		cartes = GetXMLSymbols(id);
 	}
   	var racineXML = getXMLroot(cartes);
	var racine_carte = getXMLchild(racineXML,"carte");
	var titre = getXMLvalue(racine_carte,"titre");
	
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		 var leDiv = document.all[zone_id];
	}
	else {
		var leDiv =  document.getElementById(zone_id);
	}
	if (leDiv == null) {
		return false;
	}
	leDiv.innerHTML = titre;
	document.title = document.title + " - " + titre;
}

function commenter(id,zone_id) {
	if (cartes == null) {
 		cartes = GetXMLSymbols(id);
 	}
   	var racineXML = getXMLroot(cartes);
	var racine_carte = getXMLchild(racineXML,"carte");
	var commentaire = getXMLvalue(racine_carte,"page_carte");
	if (commentaire == "") {
		commentaire = getXMLvalue(racine_carte,"commentaire");
	}
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		 var leDiv = document.all[zone_id];
	}
	else {
		var leDiv =  document.getElementById(zone_id);
	}
	if (leDiv == null) {
		return false;
	}
	leDiv.innerHTML = commentaire;
}

function GetXMLSymbols(id, idSite, theme, circuit) {
	var param = "";
	
	if (id != null && id != "") {
		param += "&Idc=" + id;
	}
	
	if(idSite != null && idSite != "") {
		param += "&idSite=" + idSite;
	}
	
	if (circuit != null && circuit != "") {
		param += "&circuit=" + circuit;
	}
	
	if(theme != null && theme != "") {
		param += "&theme=" + theme;
	}
	
	var sources_cartes = "mobiles.php?name=atlas_accessit&op=map_pict_XML_fiche_site" + param;
	var cartes = GetAJAXData(sources_cartes);
	return cartes;
}

var map = null;
var cartes = null;
var markers = [];
var dialogDiv = null;

// ]]>
