<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

$pagetitle = "- "._SURVEYS."";

if(!isset($pollID)) {
	include ('header.php');
	pollList();
	include_once ('footer.php');
}
elseif(isset($forwarder)) {
	pollCollector($pollID, $voteID, $forwarder);
}
elseif($op == "results" && $pollID > 0) {
	include ("header.php");
	echo "<h1>"._CURRENTPOLLRESULTS."</h1>";
	pollResults($pollID);
	cookiedecode($user);
	if (($pollcomm) AND ($mode != "nocomments")) {
		echo "<br><br>";
		include("modules/Surveys/comments.php");
	}
	include_once ("footer.php");
}
elseif($voteID > 0) {
	pollCollector($pollID, $voteID);
}
elseif($pollID != pollLatest()) {
	include ('header.php');
	echo "<h1>"._SURVEY."</h1>";
	pollMain($pollID);
	include_once ('footer.php');
}
else {
	include ('header.php');
	echo "<h1>"._CURRENTSURVEY."</h1>";
	pollNewest();
	include_once ('footer.php');
}

/*********************************************************/
/* Functions                                             */
/*********************************************************/

function pollMain($pollID) {
	global $boxTitle, $boxContent, $pollcomm, $user, $cookie, $prefix, $db;
	if(!isset($pollID))
	$pollID = 1;
	if(!isset($url))
	$url = sprintf("modules.php?name=Surveys&amp;op=results&amp;pollID=%d", $pollID);
	$boxContent .= "<form action=\"modules.php?name=Surveys\" method=\"post\">";
	$boxContent .= "<input type=\"hidden\" name=\"pollID\" value=\"".$pollID."\">";
	$boxContent .= "<input type=\"hidden\" name=\"forwarder\" value=\"".$url."\">";
	$result = $db->sql_query("SELECT pollTitle, voters FROM ".$prefix."_poll_desc WHERE pollID=$pollID");
	list($pollTitle, $voters) = $db->sql_fetchrow($result);
	$boxTitle = _SURVEY;
	$boxContent .= '<center><table border="0" cellpadding="0" cellspacing="0" class="pollvalues">';;
	for($i = 1; $i <= 12; $i++) {
		$result = $db->sql_query("SELECT pollID, optionText, optionCount, voteID FROM ".$prefix."_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
		$object = $db->sql_fetchrow($result);
		if(count($object) > 0) {
			$optionText = $object["optionText"];
			if($optionText != "") {
				$boxContent .= "<tr><td><input type=\"radio\" name=\"voteID\" value=\"".$i."\" id=\"choix_vote_".$i."\"><label for=\"choix_vote_".$i."\">$optionText</label></td></tr>\n";
			}
		}
	}
	$boxContent .= "</table></center>";
	$boxContent .= "<br><center><input type=\"submit\" value=\""._SUBMITVOTE."\"><br />&nbsp;</center>";
	if (is_user($user)) {
		cookiedecode($user);
	}
	for($i = 0; $i < 12; $i++) {
		$result = $db->sql_query("SELECT optionCount FROM ".$prefix."_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
		$object = $db->sql_fetchrow($result);
		$optionCount = $object["optionCount"];
		$sum = (int)$sum+$optionCount;
	}
	$boxContent .= '<hr  class="surveys" />';
	$boxContent .= "<p class=\"navbar\"><a href=\"modules.php?name=Surveys&op=results&pollID=$pollID&mode=$cookie[4]&order=$cookie[5]&thold=$cookie[6]\"><b>"._POLLSRESULTS."</b></a> &bull; <a href=\"modules.php?name=Surveys\"><b>"._OTHERPOLLS."</b></a></p>";
	$boxContent .= '<hr  class="surveys" /><p class="actions">';
	if ($pollcomm) {
		list($numcom) = $db->sql_fetchrow($db->sql_query("select count(*) from ".$prefix."_pollcomments where pollID=$pollID"));
		$boxContent .= ""._VOTES.": $sum &bull; "._PCOMMENTS." $numcom";
	}
	else {
		$boxContent .= ""._VOTES." $sum";
	}
	$boxContent .= "</p>";
	$boxContent .= "</form>";
	
	echo "<br /><fieldset><legend>".$pollTitle."</legend>";
	echo $boxContent;
	echo "</fieldset>";
	//themesidebox($boxTitle, $boxContent);
}

function pollLatest() {
	global $prefix, $multilingual, $currentlang, $db;
	if ($multilingual == 1) {
		$querylang = "WHERE planguage='$currentlang' AND artid='0'";
	} else {
		$querylang = "WHERE artid='0'";
	}
	$result = $db->sql_query("SELECT pollID FROM ".$prefix."_poll_desc $querylang ORDER BY pollID DESC LIMIT 1");
	$pollID = $db->sql_fetchrow($result);
	return($pollID[0]);
}

function pollNewest() {
	$pollID = pollLatest();
	pollMain($pollID);
}

function pollCollector($pollID, $voteID, $forwarder) {
	global $HTTP_COOKIE_VARS, $prefix, $db;
	/* Fix for lamers that like to cheat on polls */
	$ip = getenv("REMOTE_ADDR");
	$past = time()-1800;
	$db->sql_query("DELETE FROM ".$prefix."_poll_check WHERE time < $past");
	$result = $db->sql_query("SELECT ip FROM ".$prefix."_poll_check WHERE (ip='$ip') AND (pollID='$pollID')");
	list($ips) = $db->sql_fetchrow($result);
	$ctime = time();
	if ($ip == $ips) {
		$voteValid = 0;
	} else {
		$db->sql_query("INSERT INTO ".$prefix."_poll_check (ip, time, pollID) VALUES ('$ip', '$ctime', '$pollID')");
		$voteValid = "1";
	}
	/* Fix end */
	/* update database if the vote is valid */
	if($voteValid>0) {
		$db->sql_query("UPDATE ".$prefix."_poll_data SET optionCount=optionCount+1 WHERE (pollID=$pollID) AND (voteID=$voteID)");
		
		if ($voteID != "") {
			$db->sql_query("UPDATE ".$prefix."_poll_desc SET voters=voters+1 WHERE pollID=$pollID");
		}
		Header("Location: $forwarder");
	}
	else {
		Header("Location: $forwarder"."&vote=novote");
	}
	/* a lot of browsers can't handle it if there's an empty page */
	echo "<html><head></head><body></body></html>";
}

function pollList() {
	global $user, $cookie, $prefix, $multilingual, $currentlang, $admin, $db;
	if (isset($cookie[4])) { $r_options .= "&amp;mode=$cookie[4]"; }
	if (isset($cookie[5])) { $r_options .= "&amp;order=$cookie[5]"; }
	if (isset($cookie[6])) { $r_options .= "&amp;thold=$cookie[6]"; }
	/*if ($multilingual == 1) {
		$querylang = "WHERE planguage='$currentlang' AND artid='0'";
		} else {
		$querylang = "WHERE artid='0'";
		}*/
	if ($multilingual == 1) {
		$querylang = "WHERE planguage='$currentlang'";
	}
	else {
		$querylang = "";
	}
	$result = $db->sql_query("SELECT pollID, pollTitle, timeStamp, voters FROM ".$prefix."_poll_desc $querylang ORDER BY timeStamp DESC");
	$counter = 0;
	//	OpenTable();
	//	OpenTable();
	echo "<h1>"._PASTSURVEYS."</h1>";
	//	CloseTable();
	echo "<br /><br />";
	echo "<ul class=\"list_poll\">";
	while($object = $db->sql_fetchrow($result)) {
		$resultArray[$counter] = array($object["pollID"], $object["pollTitle"], $object["timeStamp"], $object["voters"]);
		$counter++;
	}
	for ($count = 0; $count < count($resultArray); $count++) {
		$id = $resultArray[$count][0];
		$pollTitle = $resultArray[$count][1];
		$voters = $resultArray[$count][3];
		for($i = 0; $i < 12; $i++) {
			$result = $db->sql_query("SELECT optionCount FROM ".$prefix."_poll_data WHERE (pollID=$id) AND (voteID=$i)");
			$object = $db->sql_fetchrow($result);
			$optionCount = $object["optionCount"];
			$sum = (int)$sum+$optionCount;
		}
		if (is_admin($admin)) {
			$editing = " &bull; <a href=\"system.php?op=polledit&amp;pollID=$id\">Edit</a>";
		}
		else {
			$editing = "";
		}
		$res = $db->sql_query("select sid, title from ".$prefix."_stories where pollID='$id'");
		if ($db->sql_numrows($res)) {
			list($sid, $title) = $db->sql_fetchrow($res);
			$article = _NEWSFORPOLL." <span class=\"poll_title\"><a href=\"modules.php?name=News&file=article&sid=$sid\">$title</a></span>";
		}
		else {
			$article = "";
		}
		echo "<li><span class=\"poll_title\"><a href=\"modules.php?name=Surveys&pollID=$id\">$pollTitle</a></span> ";
		echo "<br /> $sum "._LVOTES." &bull; <span class=\"poll_title\"><a href=\"modules.php?name=Surveys&op=results&pollID=$id$r_options\">"._RESULTS."</a></span> $editing<br />$article</li>\n";
		$sum = 0;
	}
	echo "</ul>";
	/*//	OpenTable();
	echo "<center><font class=\"title\"><b>"._SURVEYSATTACHED."</b></font></center>";
	//	CloseTable();
	echo "<table border=\"0\" cellpadding=\"8\"><tr><td>";
	if ($multilingual == 1) {
		$querylang = "WHERE planguage='$currentlang' AND artid!='0'";
	} else {
		$querylang = "WHERE artid!='0'";
	}
	$counter = 0;
	$result = $db->sql_query("SELECT pollID, pollTitle, timeStamp, voters FROM ".$prefix."_poll_desc $querylang ORDER BY timeStamp DESC");
	while($object = $db->sql_fetchrow($result)) {
		$resultArray2[$counter] = array($object["pollID"], $object["pollTitle"], $object["timeStamp"], $object["voters"]);
		$counter++;
	}
	for ($count = 0; $count < count($resultArray2); $count++) {
		$id = $resultArray2[$count][0];
		$pollTitle = $resultArray2[$count][1];
		$voters = $resultArray2[$count][3];
		for($i = 0; $i < 12; $i++) {
			$result = $db->sql_query("SELECT optionCount FROM ".$prefix."_poll_data WHERE (pollID=$id) AND (voteID=$i)");
			$object = $db->sql_fetchrow($result);
			$optionCount = $object["optionCount"];
			$sum = (int)$sum+$optionCount;
		}
		echo "<strong><big>&middot;</big></strong>&nbsp;<a href=\"modules.php?name=Surveys&amp;pollID=$id\">$pollTitle</a> ";
		if (is_admin($admin)) {
			$editing = " - <a href=\"admin.php?op=polledit&amp;pollID=$id\">Edit</a>";
		} else {
			$editing = "";
		}
		$res = $db->sql_query("select sid, title from ".$prefix."_stories where pollID='$id'");
		list($sid, $title) = $db->sql_fetchrow($res);
		echo "(<a href=\"modules.php?name=Surveys&amp;op=results&amp;pollID=$id$r_options\">"._RESULTS."</a> - $sum "._LVOTES."$editing)<br>\n"
		.""._ATTACHEDTOARTICLE." <a href=\"modules.php?name=News&amp;file=article&amp;sid=$sid$r_options\">$title</a><br><br>\n";
		$sum = "";
	}
	echo "</td></tr></table>";
	//	CloseTable();
*/}

function pollResults($pollID) {
	global $resultTableBgColor, $resultBarFile, $Default_Theme, $user, $cookie, $prefix, $db, $vote;
	if(!isset($pollID)) $pollID = 1;
	$result = $db->sql_query("SELECT pollID, pollTitle, timeStamp, artid FROM ".$prefix."_poll_desc WHERE pollID=$pollID");
	$holdtitle = $db->sql_fetchrow($result);
	echo "<fieldset><legend>$holdtitle[1]</legend>";
	if ($vote == "novote") {
		echo "<p class=\"navbar\">"._NOVOTE."</p>";
		echo '<hr  class="surveys" />';
	}
	for($i = 0; $i < 12; $i++) {
		$result = $db->sql_query("SELECT optionCount FROM ".$prefix."_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
		$object = $db->sql_fetchrow($result);
		$optionCount = $object["optionCount"];
		$sum = (int)$sum+$optionCount;
	}
	echo "<table border=\"0\">";
	/* cycle through all options */
	for($i = 1; $i <= 12; $i++) {
		/* select next vote option */
		$result = $db->sql_query("SELECT pollID, optionText, optionCount, voteID FROM ".$prefix."_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
		$object = $db->sql_fetchrow($result);
		if(count($object) > 0) {
			$optionText = $object["optionText"];
			$optionCount = $object["optionCount"];
			if($optionText != "") {
				echo "<tr><td>";
				echo "$optionText";
				echo "</td>";
				if($sum) {
					$percent = 100 * $optionCount / $sum;
				} else {
					$percent = 0;
				}
				echo "<td>";
				$percentInt = (int)$percent * 4 * 1;
				$percent2 = (int)$percent;
				if(is_user($user)) {
					if($cookie[9]=="") $cookie[9]=$Default_Theme;
					if(!$file=@opendir("themes/$cookie[9]")) {
						$ThemeSel = $Default_Theme;
					} else {
						$ThemeSel = $cookie[9];
					}
				} else {
					$ThemeSel = $Default_Theme;
				}
				$l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
				$m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
				$r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
				if ($percent > 0) {
					echo "<img src=\"themes/$ThemeSel/images/leftbar.gif\" height=\"$l_size[1]\" width=\"$l_size[0]\" Alt=\"$percent2 %\">";
					echo "<img src=\"themes/$ThemeSel/images/mainbar.gif\" height=\"$m_size[1]\" width=\"$percentInt\" Alt=\"$percent2 %\">";
					echo "<img src=\"themes/$ThemeSel/images/rightbar.gif\" height=\"$r_size[1]\" width=\"$r_size[0]\" Alt=\"$percent2 %\">";
				} else {
					echo "<img src=\"themes/$ThemeSel/images/leftbar.gif\" height=\"$l_size[1]\" width=\"$l_size[0]\" Alt=\"$percent2 %\">";
					echo "<img src=\"themes/$ThemeSel/images/mainbar.gif\" height=\"$m_size[1]\" width=\"$m_size[0]\" Alt=\"$percent2 %\">";
					echo "<img src=\"themes/$ThemeSel/images/rightbar.gif\" height=\"$r_size[1]\" width=\"$r_size[0]\" Alt=\"$percent2 %\">";
				}
				printf(" %.2f %% (%d)", $percent, $optionCount);
				echo "</td></tr>";
			}
		}
	}
	echo "</table>";
	$booth = $pollID;
	
	$res = $db->sql_query("select sid, title from ".$prefix."_stories where pollID='$pollID'");
	if ($db->sql_numrows($res)) {
		list($sid, $title) = $db->sql_fetchrow($res);
		$article = " &bull; <a href=\"modules.php?name=News&file=article&sid=$sid\">"._BACKTOARTICLE."</a>";
	}
	else {
		$article = "";
	}
	echo '<hr  class="surveys" />';
	echo "<p class=\"navbar\">";
	echo "<a href=\"modules.php?name=Surveys&amp;pollID=$booth\">"._VOTING."</a>"
	." &bull; <a href=\"modules.php?name=Surveys\">"._OTHERPOLLS."</a> $article";
	echo "</p>";
	echo '<hr  class="surveys" />';
	echo "<p class=\"actions\">";
	echo ""._TOTALVOTES." $sum";
	echo "</p>";
	echo "</fieldset>";
	return(1);
}

?>