<?php
/**
* Interface d'administration du module de Sudoku.
* 
* @package Sudoku
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
//setPath(_TXT_Modules,0);
//setPath(_SIMPLECARTO,1);
require_once("modules/$module_name/lib/g_db.php");
require_once("modules/$module_name/lib/ba_adminsudoku.php");

/**
* Renvoie l'interface d'administration de ce module.
* 
* La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function editsudoku(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid;
		
	include("modules/$module_name/lib/g_params.php");
	include("system/header_system.php");
	
	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_client = "";	
	$objetSudoku = new adminSudoku();
	$script_init_client = "";
	$corpsadminclient = "";
	$message = "";
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "make_n_sudoku" :
			$corpsadminclient = $objetSudoku->make_n_sudoku($My_SQL,$vars_mod[$vars_mod["n_grilles"]]);
			$vars_mod[$vars_mod["action"]] = "list";
			$corpsadminclient .= $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
			$operationOnglet = _SUDOKUONGLETLIST;
			break;
		case "list" :
			$corpsadminclient = $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
			$operationOnglet = _SUDOKUONGLETLIST;
			break;	
		case "delete" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetSudoku->delete_sudoku($My_SQL,$vars_mod)."</div>";
				$vars_mod[$vars_mod["id_sudoku"]] = "-1";
				$form_client = $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
				$operationOnglet = _SUDOKUONGLETSUPPR;
				break;
			}
			else {
				$message = "<div class=\"resultop\">".$objetSudoku->confirm_delete($My_SQL,$vars_mod,_SUDOKUCONFSUPPR)."</div>";
				$operationOnglet = _SUDOKUONGLETSUPPR;
			}
			$script_init_client = "";
			break;
		case "edit" :
			$form_client = $objetSudoku->edit_sudoku($My_SQL,$vars_mod,$crit_find_sudoku);
			$operationOnglet = _SUDOKUONGLETEDIT;
			break;
		case "save" :
			$vars_mod[$vars_mod["id_sudoku"]] = $objetSudoku->save_sudoku($My_SQL,$new_sudoku);
			if ($vars_mod[$vars_mod["id_sudoku"]] != "-1") {
				$vars_mod[$vars_mod["id_sudoku"]] = "-1";
				$vars_mod[$vars_mod["action"]] = "list";
				$corpsadminclient = $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
				$operationOnglet = _SUDOKUONGLETLIST;
			}
			break;
		case "new" :
			$vars_mod[$vars_mod[id_client]] = "-1";
			$form_client = $objetSudoku->new_sudoku($My_SQL,$vars_mod);
			$operationOnglet = _SUDOKUONGLETMAKE;
			break;
		case "list_partie" :
			$corpsadminclient = $objetSudoku->get_list_parties_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
			$operationOnglet = _SUDOKUPARTIEONGLETLIST;
			break;
		case "delete_partie" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetSudoku->delete_partie_sudoku($My_SQL,$vars_mod)."</div>";
				$vars_mod[$vars_mod["id_partie_sudoku"]] = "-1";
				$form_client = $objetSudoku->get_list_parties_sudokus($My_SQL,$vars_mod,$crit_find_sudoku);
				$operationOnglet = _SUDOKUONGLETPARTYSUPPR;
				break;
			}
			else {
				$message = "<div class=\"resultop\">".$objetSudoku->confirm_delete($My_SQL,$vars_mod,_SUDOKUCONFSUPPR)."</div>";
				$operationOnglet = _SUDOKUCONFPARTYSUPPR;
			}
			$script_init_client = "";
			break;
	}
	
	$scriptstyle = '
	<link href="modules/'.$module_name.'/lib/style-edit-client.css" rel="stylesheet" type="text/css" media="all" />';
	
	$corpsadminclient .= $message.$form_client;
	
	if (!isset($onglet)) {
		$onglet = "sudoku";
	}
	if ($onglet == "") {
		$onglet = "sudoku";
	}
	/*$varsenplus = $objetSudoku->getVars("id_sudoku"."|onglet|".$vars_mod["action"]."|op");
	if ($varsenplus != "") {
		$varsenplus = "&".$varsenplus;
	}
	$ongletDef=array("sudoku"=> array( "text"=>_SUDOKUONGLETSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=list&op=sudoku&onglet=sudoku".$varsenplus),
                 "sudokunew"=> array( "text"=>_SUDOKUONGLETNEWSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=new&op=sudoku&onglet=sudokunew".$varsenplus),
				"partie"=> array( "text"=>_SUDOKUONGLETPARTYSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=list_partie&op=sudoku&onglet=partie".$varsenplus));*/
	$ongletDef=array("sudoku"=> array( "text"=>_SUDOKUONGLETSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=list&op=sudoku&onglet=sudoku"),
                 "sudokunew"=> array( "text"=>_SUDOKUONGLETNEWSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=new&op=sudoku&onglet=sudokunew"),
				"partie"=> array( "text"=>_SUDOKUONGLETPARTYSUDOKU,
                                   "url"=>"system.php?".$vars_mod["action"]."=list_partie&op=sudoku&onglet=partie"));

    GraphicAdmin(_SUDOKU);
	OpenOngletTable();
	displayOngletBar($onglet,_SUDOKUONGLET.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadminclient;
	CloseSysTable();
	CloseOngletTable();
    include("system/footer_system.php");    
}

/**
* Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
*/
switch ($op) {
    case "sudoku":
    		editsudoku();
    		break;
	}
}
else {
    display_denied();
}

?>