<?php
/**
 * Classes des fonctions pour manipuler les Sudokus.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package Sudokus
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
require_once("g_db.php");

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (conversion de date, ...).
 * @package becmsSimpleClient
 */
class adminSudoku {
	/**
	 * @var object Classe qui donne accs au fonctions de manipulation des sudokus.
	 */
	var $sgbd;
	/**
	 * @var object Grille 'SuDoku', caractres de "1"  "9", case $i,$j.
	 */
	var $Grille;
	/**
	 * @var object Masque de la grille: 0 = non masquable, 1 = la case peut tre masque.
	 */
	var $Masque;
	/**
	 * @var object Loterie est une chaine de caractres pour le tirage des cases restantes.
	 */
	var $loterie = "";
	/**
	 * @var object Variable collision pour tester le cas o on tirerais la mme case.
	 */
	var $collision = 0;
	/**
	 * @var object La grille est divise en 9 rgions, 9 lignes et 9 colonnes.
	 */
	var $Reg = array();
	/**
	 * @var object Les tableaux $Reg,$Lgn,$Col sont indexs 'numro,chiffre' ($n,$m m=chiffre-1).
	 */
	var $Lgn = array();
	/**
	 * @var object Les valeurs sont des chaines de caractres indiquant les positions possibles.
	 */
	var $Col = array();

	/**
	 * Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des clients.
	 */
	function adminSudoku() {
		$this->sgbd = new BD_Sudoku();
		$this->Grille = array();
		$this->Masque = array();
		$this->loterie = "";
		$this->collision = 0;
		$this->Reg = array();
		$this->Lgn = array();
		$this->Col = array();
	}

	/**
	 * Rcupre les variables envoyes par GET ou POST.
	 *
	 * Renvoie ces variables sous la forme de paramtres d'URL.
	 * @param string $sauf Liste des paramtres  ne pas rcuprer.
	 * @return string Liste des variables rcupres.
	 */
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0) {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		else {
			$args = "";
		}
		return $args;
	}

	/**
	 * Renvoie l'indexation des rsultats  afficher par page.
	 *
	 * @param array $criteres Tableau contenant les divers paramtres : .
	 * @return string Code HTML de l'index des pages  afficher.
	 */
	function getPagesIndex($vars_mod,$criteres,$nbreFiches,$found,$not_found) {
		$repParPage = $criteres["articles_par_page"];
		$p = $criteres["page_en_cours"];
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$found;
		}
		else {
			$indexPages .= $not_found;
		}
		$indexPages .= _SUDOKUPAGES;
		for ($i=1;$i<=$nbrepages;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$action = "";
				if ($vars_mod[$vars_mod["action"]] != "") {
					$action = "&".$vars_mod["action"]."=".$vars_mod[$vars_mod["action"]];
				}
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?".$this->getVars($vars_mod["page_en_cours"]."|".$vars_mod["action"]."|id_sudoku").$action."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	/**
	 * Enregistre le Sudoku transmis.
	 *
	 * La fonction renvoie l'identifiant de la fiche sudoku si l'enregsitrement s'est bien pass, et -1 sinon.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $lesudoku Tableau contenant les valeurs du sudoku  enregistrer.
	 * @return integer Identifiant de la fiche enregistre.
	 */
	function save_sudoku ($My_SQL,$lesudoku) {
		$lesudoku["date"] = $this->date2AMJ($lesudoku["date"]);
		if ($this->sgbd->saveSudoku($My_SQL,$lesudoku)) {
			if ($lesudoku["Id"] == "-1") {
				$savedIndex = $this->sgbd->getLastId($My_SQL);
			}
			else {
				$savedIndex = $lesudoku["Id"];
			}
		}
		else {
			$savedIndex = "-1";
		}
		return $savedIndex;
	}

	/**
	 * Initialisation de variables pour la cration de Sudoku.
	 */
	function initialisation() {
		$this->loterie = "";
		$this->collision = 0;
		// iniatisation, grille et masque, d'abord initialise  '0'
		for ($i=0; $i<=8; $i++){
			for ($j=0; $j<=8; $j++){
				$this->Grille[$i][$j] = "0";
				$this->Masque[$i][$j] = 0;
				$this->loterie = $this->loterie.chr(97+$i).chr(48+$j);
			}
		}
		// Au dbut toutes les positions sont possibles
		for ($n=0; $n<=8; $n++){
			for ($m=0; $m<=8; $m++){
				$this->Reg[$n][$m] = "012345678";
				$this->Lgn[$n][$m] = "012345678";
				$this->Col[$n][$m] = "012345678";
			}
		}
	}

	/**
	 * Participe  la cration du Sudoku.
	 */
	function elimination($i,$j,$m){
		// limination du chiffre en mettant les positions possibles  rien (= "")
		$n = floor($i/3)*3+floor($j/3); // rgion concerne numro $n
		$this->Reg[$n][$m] = "";
		$n = $i; // ligne concerne numro $n
		$this->Lgn[$n][$m] = "";
		$n = $j; // Colonne concerne numro $n
		$this->Col[$n][$m] = "";
		// limination slective des positions possibles dans les rgions voisines
		for($n=0; $n<=8; $n++){
			for ($p=0; $p<=8; $p++){
				// $p est la position d'une case dans une rgion
				// position de la case en coordonnes 'grille', $ic,$jc
				$ic = floor($n/3)*3+floor($p/3);
				$jc = ($n-floor($n/3)*3)*3+($p-floor($p/3)*3);
				if ($ic==$i OR $jc==$j){
					$posi = Chr(48+$p);
					$this->Reg[$n][$m] = str_replace($posi,"",$this->Reg[$n][$m]);
				}
			}
		}
		// limination slective des positions possibles dans les lignes voisines
		$posi = chr(48+$j);
		for($n=0; $n<=8; $n++){
			$this->Lgn[$n][$m] = str_replace($posi,"",$this->Lgn[$n][$m]);
		}
		// limination slective des positions possibles dans les colonnes voisines
		$posi = chr(48+$i);
		for($n=0; $n<=8; $n++){
			$this->Col[$n][$m] = str_replace($posi,"",$this->Col[$n][$m]);
		}
		// limination slective des positions possibles, lignes-colonnes/rgion
		$n = floor($i/3)*3+floor($j/3); // rgion concerne numro $n
		for($p=0; $p<=8; $p++){
			// position de la case en coordonnes 'grille', $ic,$jc
			$ic = floor($n/3)*3+floor($p/3);
			$jc = ($n-floor($n/3)*3)*3+($p-floor($p/3)*3);
			$posi = chr(48+$jc);
			$this->Lgn[$ic][$m] = str_replace($posi,"",$this->Lgn[$ic][$m]);
			$posi = chr(48+$ic);
			$this->Col[$jc][$m] = str_replace($posi,"",$this->Col[$jc][$m]);
		}
		// limination de la position occupe quelque soit le chiffre
		for($mc=0; $mc<=8; $mc++){
			// rgions (la rgion concerne, numro $n)
			$n = floor($i/3)*3+floor($j/3);
			$p = ($i-floor($i/3)*3)*3+($j-floor($j/3)*3);
			$posi = chr(48+$p);
			$this->Reg[$n][$mc] = str_replace($posi,"",$this->Reg[$n][$mc]);
			// lignes
			$posi = chr(48+$j);
			$this->Lgn[$i][$mc] = str_replace($posi,"",$this->Lgn[$i][$mc]);
			// colonnes
			$posi = chr(48+$i);
			$this->Col[$j][$mc] = str_replace($posi,"",$this->Col[$j][$mc]);
		}
	}

	/**
	 * Participe  la cration du Sudoku.
	 */
	function affectation($i,$j,$m,$D){
		if ($this->Grille[$i][$j]== "0"){
			$this->Grille[$i][$j]= chr(48+$m+1);
			$posi = chr(97+$i).chr(48+$j);
			$this->loterie = str_replace($posi,"",$this->loterie);
			$this->elimination($i,$j,$m);
			if ($D== "1") $this->Masque[$i][$j]= 1;
		}
		else{
			$this->collision++;
		}
	}

	/**
	 * Participe  la cration du Sudoku.
	 */
	function insertSudoku($My_SQL,$lesudoku) {
		$id_inserted = $this->save_sudoku ($My_SQL,$lesudoku);
		return $id_inserted;
	}

	/**
	 * Cre un certain nombre de grille de Sudoku.
	 *
	 * La fonction cre le nombre de sudokus dont le niveau sera totalement arbitraire et alatoire.
	 * Les grilles sont automatiquement enregistres dans la basede donnes;
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $nbre Nombre de Sudoku  gnrer.
	 * @return integer Identifiant de la fiche enregistre.
	 */
	function make_n_sudoku($My_SQL,$nbre=1) {
		$aujourdhui = date("d/m/Y");
		$compteurdegrille = 0;
		while($compteurdegrille<$nbre) {
			$tentative = 0;
			$tentative_max = 10;
			$niveauGrille = 0;
			$this->initialisation();
			while (strlen($this->loterie)>0 AND $tentative<$tentative_max){
				$tentative++;
				$this->initialisation();
				$iter = 0;
				$itermax = 82;
				while ($this->loterie<>"" AND $iter<$itermax){
					$iter++;
					// placement dterministe d'un chiffre dans une case
					$bingo = 0;
					for ($n=0; $n<=8; $n++){
						for ($m=0; $m<=8; $m++){
							// en premier les rgions
							if (strlen($this->Reg[$n][$m])== 1){
								$p = ord($this->Reg[$n][$m])-48;
								$i = floor($n/3)*3+floor($p/3);
								$j = ($n-floor($n/3)*3)*3+($p-floor($p/3)*3);
								$this->affectation($i,$j,$m,"1");
								$bingo = 1;
								break;
							}
							// en second les lignes
							if (strlen($this->Lgn[$n][$m])== 1){
								$p = ord($this->Lgn[$n][$m])-48;
								$i = $n;
								$j = $p;
								$this->affectation($i,$j,$m,"1");
								$bingo = 1;
								break;
							}
							// en troisime les colonnes
							if (strlen($this->Col[$n][$m])== 1){
								$p = ord($this->Col[$n][$m])-48;
								$i = $p;
								$j = $n;
								$this->affectation($i,$j,$m,"1");
								$bingo = 1;
								break;
							}
						}
						if ($bingo== 1) break;
					}
					$niveauGrille++;
					// placement par tirage au sort, si le placement dterministe n'a pas abouti
					if ($bingo== 0){
						// tirage d'une case $i,$j parmis les cases libres
						$ncase2 = strlen($this->loterie);
						$ncase = strlen($this->loterie)/2;
						$index = rand(0,$ncase-1)*2;
						$posi = substr($this->loterie,$index,2);
						// dtermination des coordonnes de la case: $i,$j
						$i = ord(substr($posi,0))-97;
						$j = ord(substr($posi,1))-48;
						// tirage d'un chiffre parmis les chiffres libres
						$liste = "";
						for ($m=0; $m<=8; $m++){
							$libre = 1;
							// rgions
							$n = floor($i/3)*3+floor($j/3);
							if ($this->Reg[$n][$m]== "") $libre = 0;
							// lignes
							$n = $i;
							if ($this->Lgn[$n][$m]== "") $libre = 0;
							// colonnes
							$n = $j;
							if ($this->Col[$n][$m]== "") $libre = 0;
							// concatnation
							if ($libre== 1) $liste = $liste.chr(48+$m);
						}
						$niveauGrille++;
						if (strlen($liste)>0){
							$m = ord(substr($liste,floor(rand(0,strlen($liste)-1))))-48;
							$this->affectation($i,$j,$m,"0");
						}
					}
				}
			}
			if (strlen($this->loterie)== 0){
				$sudoku= "";
				$mask= "";
				for ($i=0; $i<=8; $i++) {
					for ($j=0; $j<=8; $j++) {
						$sudoku.= $this->Grille[$i][$j];
						if ($this->Masque[$i][$j]== 1) $mask.= "0";
						if ($this->Masque[$i][$j]== 0) $mask.= "1";
					}
				}
				$le_sudoku = array("Id"=>"-1","niveau"=>$niveauGrille,"grille"=>$sudoku,"masque"=>$mask,"date"=>$aujourdhui);
				$id_inserted = $this->insertSudoku($My_SQL,$le_sudoku);
				if ($id_inserted != "-1") {
					$compteurdegrille++;
				}
			}
			else{
				//la gnration de la grille a chou;
			}
		}
		return $compteurdegrille." grilles ont t cres.";
	}

	/**
	 * Renvoie un tableau HTML contenant la grille de sudoku.
	 *
	 * Cette fonction permet de visualiser les grilles dans le listing.
	 * @param string $grille Chaine de caractres contenant la grille  afficher
	 * @param string $masque Chaine de caractres contenant le masque de la grille  afficher
	 * @return string Tableau HTML de la grille.
	 */
	function display_sudokus_grid($grille,$masque) {
		$sortie =  '<table class="mini_sudoku">'."\n";
		for($i=0; $i<=8; $i++) {
			$sortie .=  "<tr>"."\n";
			for($j=0; $j<=8;$j++) {
				if($j==3 || $j==6) { // on rajoute une bordure  gauche des cases de la 4 et 7me colonne
					if($i==3 || $i==6) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
					$case_class = ' class="borderLeftTop"';
					else
					$case_class = ' class="borderLeft"';
				}
				else {
					if($i==3 || $i==6) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
						$case_class = ' class="borderTop"';
					else
						$case_class = '';
				}
				if (substr($masque, $j+(9*$i), 1)== 0) {
					$sortie .= '<td'.$case_class.'>&nbsp;</td>'."\n";
				}
				else {
					$sortie .= '<td'.$case_class.'>'.substr($grille, $j+(9*$i), 1).'</td>'."\n";
				}
			}
			$sortie .= "</tr>"."\n";
		}
		$sortie .= "</table>"."\n";
		return $sortie;
	}
	
	/**
	 * Renvoie un tableau HTML contenant la grille d'une partie sudoku.
	 *
	 * Cette fonction permet de visualiser les grilles dans un listing.
	 * @param string $grille Chaine de caractres contenant la grille  afficher
	 * @param string $masque Chaine de caractres contenant le masque de la grille  afficher
	 * @return string Tableau HTML de la grille.
	 */
	function display_sudokus_partie_grid($grille,$masque) {
		$sortie =  '<table class="mini_sudoku">'."\n";
		for($i=0; $i<=8; $i++) {
			$sortie .=  "<tr>"."\n";
			for($j=0; $j<=8;$j++) {
				if($j==3 || $j==6) { // on rajoute une bordure  gauche des cases de la 4 et 7me colonne
					if($i==3 || $i==6) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
					$case_class = ' class="borderLeftTop"';
					else
					$case_class = ' class="borderLeft"';
				}
				else {
					if($i==3 || $i==6) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
						$case_class = ' class="borderTop"';
					else
						$case_class = '';
				}
				switch (substr($masque, $j+(9*$i), 1)) {
					case "0" :
						$style = ' style="color: black"';
						$read = ' readonly="readonly"';
						break;
					case "1" :
						$style = ' style="font-weight:bold; color: blue"';
						$read = '';
						break;
					case "2" :
						$style = ' style="font-weight:bold; color: red"';
						$read = '';
						break;
					case "3" :
						$style = ' style="font-weight:bold; color: green"';
						$read = '';
						break;
					case "4" :
						$style = ' style="font-weight:bold; color: orange"';
						$read = '';
						break;
					case "5" :
						$style = ' style="font-weight:bold; color: magenta"';
						$read = '';
						break;
				}
				if (substr($grille, $j+(9*$i), 1)== 0) {
					$sortie .= '<td'.$case_class.' >&nbsp;</td>'."\n";
				}
				else {
					$sortie .= '<td'.$case_class.' '.$style.'>'.substr($grille, $j+(9*$i), 1).'</td>'."\n";
				}
			}
			$sortie .= "</tr>"."\n";
		}
		$sortie .= "</table>"."\n";
		return $sortie;
	}

	/**
	 * Renvoie un tableau HTML listant tous les sudokus.
	 *
	 * Ce tableau permet de crer, modifier ou supprimer les sudokus.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Tableau HTML des sudokus.
	 */
	function get_list_sudokus ($My_SQL,$vars_mod,$criteres) {
		global $module_name;

		$nbreFiches = $this->sgbd->getNumSudokus($My_SQL);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this->getPagesIndex($vars_mod,$criteres, $nbreFiches,_SUDOKUFOUNDPAGES,_SUDOKUNOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_sudoku = $limInf.",".$criteres["articles_par_page"];

		if ($vars_mod["id_sudoku"] == "-1") {
			$id_sudoku = "";
			$critTriPlus = "";
		}
		else {
			$id_sudoku = $vars_mod["id_sudoku"];
			$critTriPlus = "";
		}

		$sudokus = $this->sgbd->getSudokus($My_SQL,$id_sudoku,$vars_mod[$vars_mod["tri"]],$limit_sudoku);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		$liste = $indexPages.'
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=sudoku&onglet=sudoku&'.$vars_mod["tri"].'=identifiant'.$critTriPlus.'">'._SUDOKUONGLETID.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=sudoku&onglet=sudoku&'.$vars_mod["tri"].'=niveau'.$critTriPlus.'">'._SUDOKUONGLETNIVEAU.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=sudoku&onglet=sudoku&'.$vars_mod["tri"].'=date'.$critTriPlus.'">'._SUDOKUONGLETDATE.'</a></th>
					<th class="systemTabHeader" width="200">'._SUDOKUONGLETGRILLE.'</th>
					<th class="systemTabHeader" width="200">'._SUDOKUONGLETSOLUTION.'</th>
					<th class="systemTabHeader">'._SUDOKUONGLETCACTION.'</th>
    				</tr>';
		$pos=0;
		if (count($sudokus) != 0) {
			foreach ($sudokus as $sudoku) {
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=sudoku&onglet=sudoku&".$vars_mod["action"]."=edit&"."id_sudoku"."=".$sudoku["Id"].$tri.$var_en_plus,"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=sudoku&onglet=sudoku&".$vars_mod["action"]."=delete&"."id_sudoku"."=".$sudoku["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));

				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;

				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td align="center">';
				$liste .= $this->conditionnerHTML($sudoku["Id"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($sudoku["niveau"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->date2JMA($sudoku["date"]);
				$liste .= '</td><td align="center" width="200">';
				$liste .= $this->display_sudokus_grid($sudoku["grille"],$sudoku["masque"]);
				$liste .= '</td><td align="center" width="200">';
				$liste .= $this->display_sudokus_grid($sudoku["grille"],str_pad("", 81, "1"));
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
		}
		$liste .= '</table>';
		return $liste;
	}
	
	/**
	 * Renvoie un tableau HTML listant toutes les parties enregistres.
	 *
	 * Ce tableau permet de crer, modifier ou supprimer les parties.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Tableau HTML des sudokus.
	 */
	function get_list_parties_sudokus ($My_SQL,$vars_mod,$criteres) {
		global $module_name,$prefix;

		$nbreFiches = $this->sgbd->getNumParties($My_SQL);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this->getPagesIndex($vars_mod,$criteres, $nbreFiches,_SUDOKUFOUNDPAGES,_SUDOKUNOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_sudoku = $limInf.",".$criteres["articles_par_page"];

		if ($vars_mod["id_sudoku"] == "-1") {
			$id_sudoku = "";
			$critTriPlus = "";
		}
		else {
			$id_sudoku = $vars_mod["id_sudoku"];
			$critTriPlus = "";
		}

		$sudokus = $this->sgbd->getPartiesSudoku($My_SQL,"","","",$vars_mod[$vars_mod["tri"]],$limit_sudoku);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		$liste = $indexPages.'
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list_partie&op=sudoku&onglet=partie&'.$vars_mod["tri"].'=utilisateur'.$critTriPlus.'">'._SUDOKUONGLETID.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list_partie&op=sudoku&onglet=partie&'.$vars_mod["tri"].'=date'.$critTriPlus.'">'._SUDOKUONGLETDATE.'</a></th>
					<th class="systemTabHeader">'._SUDOKUONGLETNIVEAU.'</th>
					<th class="systemTabHeader">'."Rsolu".'</th>
					<th class="systemTabHeader" width="200">'._SUDOKUONGLETGRILLE.'</th>
					<th class="systemTabHeader" width="200">'._SUDOKUONGLETSOLUTION.'</th>
					<th class="systemTabHeader">'._SUDOKUONGLETCACTION.'</th>
    				</tr>';
		$pos=0;
		if (count($sudokus) != 0) {
			foreach ($sudokus as $sudoku) {
				$sudokus_vierges = $this->sgbd->getSudokus($My_SQL,$sudoku["id_sudoku"]);
				$sudoku_vierge = $sudokus_vierges[0];
//				$clients = $this->sgbd_client->getClients($My_SQL,$sudoku["id_utilisateur"]);
//				$client = $clients[0];

				$client = $this->sgbd->get_user($sudoku["id_utilisateur"]);
				
				
				if ($sudoku_vierge["grille"] == $sudoku["grille_utilisateur"]) {
					$picto = "resolus.gif";
				}
				else {
					$picto = "nonresolus.gif";
				}
				$urlpicto = $vars_mod["cheminModule"].'lib/icns/'.$picto;
				
				$barDef=array("delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=sudoku&onglet=partie&".$vars_mod["action"]."=delete_partie&"."id_partie_sudoku"."=".$sudoku["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));

				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;

				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td align="center">';
				$liste .= $this->conditionnerHTML($client["uname"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->date2JMA($sudoku["date"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($sudoku_vierge["niveau"]);
				$liste .= '</td><td align="center">';
				$liste .= '<img src="'.$urlpicto.'" width="18" height="18" />';
				$liste .= '</td><td align="center" width="200">';
				$liste .= $this->display_sudokus_partie_grid($sudoku["grille_utilisateur"],$sudoku["masque_utilisateur"]);
				$liste .= '</td><td align="center" width="200">';
				$liste .= $this->display_sudokus_grid($sudoku_vierge["grille"],str_pad("", 81, "1"));
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
		}
		$liste .= '</table>';
		return $liste;
	}

	/**
	 * Demande confirmation de la suppression de l'lment dsign.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param message $message Message affich  l'utilisateur pour confirmer la suppression
	 * @return string Message  afficher en HTML.
	 */
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=sudoku&onglet=sudoku&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'."id_sudoku".'='.$vars_mod["id_sudoku"].$tri.'&'.$vars_mod["confirm"].'=y">';

			$sortie .= "["._SUDOKUCONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._SUDOKUCONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_partie") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=sudoku&onglet=partie&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'."id_partie_sudoku".'='.$vars_mod["id_partie_sudoku"].$tri.'&'.$vars_mod["confirm"].'=y">';

			$sortie .= "["._SUDOKUCONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._SUDOKUCONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		$sortie .= "</p>";
		return $sortie;
	}
	/**
	 * Supprime la grille dsigne et renvoie le rsultat de l'opration en HTML.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Rsultat de l'opration en HTML.
	 */
	function delete_sudoku($My_SQL,$vars_mod) {
		if ($this->sgbd->delSudoku($My_SQL,$vars_mod["id_sudoku"])) {
			$sortie = _SUDOKUDELOK;
		}
		else {
			$sortie = _SUDOKUDELPASOK;
		}
		return $sortie;
	}

	/**
	 * Renvoie un formulaire permettant d'diter une grille.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire d'dition de la grille.
	 */
	function edit_sudoku($My_SQL,$vars_mod,$criteres) {
		$SudokusEdit = $this->sgbd->getSudokus($My_SQL,$vars_mod["id_sudoku"]);
		$SudokuEdit = $SudokusEdit[0];

		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}

		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=sudoku&onglet=sudoku&'.$vars_mod["action"].'=save'.$var_en_plus.'" method="post">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._SUDOKUNIVEAUEDIT.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="niveau" size="16" value="'.$SudokuEdit["niveau"].'" /></td>
			</tr>
			<tr>
				<td>'._SUDOKUDATEEDIT.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="date" size="16" value="'.$this->date2JMA($SudokuEdit["date"]).'" /></td>
			</tr>
			<tr>
				<td>'._SUDOKUGRILLEEDIT.'</td>
				<td width="10"></td>
				<td align="center"><table border="0" cellpadding="0" cellspacing="0"><tr><td>'.$this->display_sudokus_grid ($SudokuEdit["grille"],$SudokuEdit["masque"]).'</td><td>'.$this->display_sudokus_grid($SudokuEdit["grille"],str_pad("", 81, "1")).'</td></tr></table></td>
			</tr>
			<tr align="center">
				<td colspan="3" rowspan="1">'._SUDOKUFIELDREQUIRED.'<br />&nbsp;<br />
				<input type="hidden" value="'.$SudokuEdit["Id"].'" name="'."id_sudoku".'">
				<input type="hidden" value="'.$SudokuEdit["grille"].'" name="grille">
				<input type="hidden" value="'.$SudokuEdit["masque"].'" name="masque">
				<input name="validform" value="'._SUDOKUSAVEEDIT.'" type="submit"></td>
			</tr>
		</table>
		</form>
		</div>
		</center>';
		return $formedit;
	}

	/**
	 * Renvoie un formulaire permettant d'diter une grille.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire d'dition de la grille.
	 */
	function new_sudoku($My_SQL,$vars_mod) {
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=sudoku&onglet=sudoku&'.$vars_mod["action"].'=make_n_sudoku'.$var_en_plus.'" method="post">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._SUDOKUNBREEDIT.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="'.$vars_mod["n_grilles"].'" size="16" value="" /></td>
			</tr>
			<tr align="center">
				<td colspan="3" rowspan="1">&nbsp;<br />
				<input name="validform" value="'._SUDOKUSAVEEDIT.'" type="submit"></td>
			</tr>
		</table>
		</form>
		</div>
		</center>';
		return $formedit;
	}
	/**
	 * Supprime la partie dsigne et renvoie le rsultat de l'opration en HTML.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Rsultat de l'opration en HTML.
	 */
	function delete_partie_sudoku($My_SQL,$vars_mod) {
		if ($this->sgbd->delPartieSudoku($My_SQL,$vars_mod["id_partie_sudoku"])) {
			$sortie = _SUDOKUDELOK;
		}
		else {
			$sortie = _SUDOKUDELPASOK;
		}
		return $sortie;
	}

	/**
	 * Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}

	/**
	 * Prpare les donnes  tre affiches en HTML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

	/**
	 * Prpare les donnes  tre envoyes aux procdures Javascript.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

	/**
	 * Prpare les donnes  tre incluses dans les formulaires.
	 * @param string $texte Texte  prparer
	 * @return string texte encod.
	 */
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

	/**
	 * Remplace une donne nulle ou vide par zero.
	 * @param string $valeur Valeur  tester.
	 * @return integer Valeur ou zero.
	 */
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
	/**
	 * Prpare les donnes  tre exportes en XML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}

	/**
	 * Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2JMA($ladate){
		if ($ladate == "0000-00-00") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}

	/**
	 * Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
}
?>