<?php
/**
* Interfaage du module avec le Front Office du CMS.
* 
* Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
* @package becmsSimpleClient
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

/**
* Structure de la tables utilise par ce module
* -- 
* -- Structure de la table `becms_clients`
* -- 
* 
* CREATE TABLE `becms_clients` (
*   `Id` int(11) NOT NULL auto_increment,
*   `civilite` int(11) NOT NULL,
*   `nom` varchar(100) collate latin1_general_ci NOT NULL,
*   `prenom` varchar(100) collate latin1_general_ci NOT NULL,
*   `societe` varchar(100) collate latin1_general_ci NOT NULL,
*   `adresse` text collate latin1_general_ci NOT NULL,
*   `codepostal` varchar(10) collate latin1_general_ci NOT NULL,
*   `ville` varchar(100) collate latin1_general_ci NOT NULL,
*   `pays` varchar(50) collate latin1_general_ci NOT NULL,
*   `tel` varchar(30) collate latin1_general_ci NOT NULL,
*   `fax` varchar(30) collate latin1_general_ci NOT NULL,
*   `portable` varchar(30) collate latin1_general_ci NOT NULL,
*   `email` varchar(100) collate latin1_general_ci NOT NULL,
*   `services` text collate latin1_general_ci NOT NULL,
*   `valide` smallint(6) NOT NULL,
*   `codeclient` varchar(100) collate latin1_general_ci NOT NULL,
*   `passwd` varchar(20) collate latin1_general_ci NOT NULL,
*   `divers` text collate latin1_general_ci NOT NULL,
*   `datenaissance` date NOT NULL,
*   PRIMARY KEY  (`Id`),
*   UNIQUE KEY `codeclient` (`codeclient`),
*   KEY `nom` (`nom`,`prenom`),
*   KEY `societe` (`societe`),
*   KEY `datenaissance` (`datenaissance`)
* ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='clients pour les services WEB 2.0 offerts par la plateforme' AUTO_INCREMENT=39 ;
* 
*/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib/g_params.php");
require_once("modules/$module_name/lib/ba_displaysudoku.php");

$My_SQL["maBase"] = $db;

/**
* Affiche la liste des grilles vierges enregistrs.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $criteres Tableau contenant les paramtres d'affichage.
*/
function displayListSudoku($My_SQL,$vars_mod,$criteres) {
	$objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$criteres);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
	
}

/**
* Rechrche les grilles vierges correspondant  la recherche et les affiche en liste.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $criteres Tableau contenant les paramtres d'affichage.
*/
function searchSudokus($My_SQL,$vars_mod,$criteres) {
	$objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_list_sudokus($My_SQL,$vars_mod,$criteres);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
	
}

/**
* Affiche la liste des grilles enregistres des clients.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $criteres Tableau contenant les paramtres d'affichage.
*/
function displayMySudokus($My_SQL,$vars_mod,$criteres) {
	$objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_my_parties_sudoku($My_SQL,$vars_mod,$criteres);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
	
}

/**
* Affiche un sudoku pour y jouer.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
*/
function displayOneSudoku($My_SQL,$vars_mod) {
    $objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_one_sudoku($My_SQL,$vars_mod);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Affiche une partie de sudoku pour continuer  y jouer.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
*/
function displayOnePartySudoku($My_SQL,$vars_mod) {
    $objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_one_party_sudoku($My_SQL,$vars_mod);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Enregistre une grille complte par un joueur pour y rejouer.
* 
* Si l'utilisateur n'est pas identifi, les formulaires d'identification seront affichs
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $myGrille Tableau contenant la grille  enregistrer
* @param array $clef Tableau contenant les identifiants du client en cours.
*/
function saveMySudoku($My_SQL,$vars_mod,$myGrille,$clef) {
    $objetSudoku = new displaySudokus();
    include ('header.php');
    if ($myGrille["id_utilisateur"] != "-1"){
    	if ($objetSudoku->save_my_sudoku($My_SQL,$vars_mod,$myGrille)) {
    		echo $objetSudoku->get_one_party_sudoku($My_SQL,$vars_mod);
	    }
    }
    else {
    	if ($_SESSION["s_id_client"] == "-1" && $clef["codeclient"] == "" && $clef["passwd"] == "") {
    		echo $objetSudoku->set_client($My_SQL,$vars_mod,"","new_client_save_sudoku","save");
    	}
    	else {
    		if ($objetSudoku->sgbd_client->exists_client($My_SQL,$clef)) {
    			$_SESSION["s_id_client"] = $objetSudoku->sgbd_client->get_client_id($My_SQL,$clef);
    			$myGrille["id_utilisateur"] = $_SESSION["s_id_client"];
    			$myGrille["id_sudoku"] = $_SESSION["s_id_sudoku"];
    			$myGrille["grille_utilisateur"] = $_SESSION["s_mygrille"];
    			$myGrille["masque_utilisateur"] = $_SESSION["s_mymask"];
    			$vars_mod[$vars_mod["id_client"]] = $_SESSION["s_id_client"];
				$vars_mod["id_sudoku"] = $_SESSION["s_id_sudoku"];
    			if ($objetSudoku->save_my_sudoku($My_SQL,$vars_mod,$myGrille)) {
    				echo $objetSudoku->get_one_party_sudoku($My_SQL,$vars_mod);
			    }
    		}
    		else {
    			echo $objetSudoku->set_client($My_SQL,$vars_mod,_CATALOGClIENTBADPASS,"new_client_save_sudoku","save");
    		}
    	}
    }
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Permet la cration d'un nouveau compte client.
* 
* Ce dialogue permet au client de crer son compte client.
* L'enregistrement de sa fiche client lui permettra d'enregistrer sa grille.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $new_client Tableau contenant les informations de la fiche client (vide pour cette fonction).
* @param string $erreur Chaine contenant les message d'erreur du non enregistrement du client.
* @param string $alerte_code Message d'erreur pour code dupliqu.
* @param string $operation Nom de l'action  effectuer sur enregistrement de du client.
*/
function newClient($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,$operation) {
	$objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,$operation);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Enregistre la cration du compte client puis de la partie de sudoku en cours.
* 
* Affiche le dialogue de saisie des coordonnes du client si il n'est pas enregistr.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $new_client Tableau contenant les rubriques du compte client.
* @param array $myGrille Tableau contenant une grille de artie de sudoku vide.
* @param string $operation_notsaved Chaine de l'opration  excuter si le client n'est pas enregistr.
*/
function saveClientSaveSudoku($My_SQL,$vars_mod,$new_client,$myGrille,$operation_notsaved) {
	$objetSudoku = new displaySudokus();
	if ($objetSudoku->save_client($My_SQL,$vars_mod,$new_client)) {
		$_SESSION["s_id_client"] = $objetSudoku->sgbd_client->getLastId($My_SQL);
    	$myGrille["id_utilisateur"] = $_SESSION["s_id_client"];
   		$myGrille["id_sudoku"] = $_SESSION["s_id_sudoku"];
  		$myGrille["grille_utilisateur"] = $_SESSION["s_mygrille"];
    	$myGrille["masque_utilisateur"] = $_SESSION["s_mymask"];
   		$vars_mod[$vars_mod["id_client"]] = $_SESSION["s_id_client"];
		$vars_mod["id_sudoku"] = $_SESSION["s_id_sudoku"];
    	if ($objetSudoku->save_my_sudoku($My_SQL,$vars_mod,$myGrille)) {
    		include ('header.php');
   			echo $objetSudoku->get_one_party_sudoku($My_SQL,$vars_mod);
   			echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
   			include ('footer.php');
	    }		
	}
	else {
		if ($objetSudoku->sgbd_client->exists_code($My_SQL,$new_client["codeclient"])) {
			$alerte_code = _CATALOGClIENTBADCODE;
		}
		else {
			$alerte_code = "";
		}
		$erreur = _CATALOGClIENTBADSAVE;
		newClient($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,$operation_notsaved);
	}
}

/**
* Permet la modification d'un compte client.
* 
* Ce dialogue permet au client de crer ou modifier son compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $new_client Tableau contenant les rubriques du compte client.
* @param string $erreur Chaine contenant les message d'erreur du non enregistrement du client.
* @param string $alerte_code Message d'erreur pour code dupliqu.
* @param string $operation Opration  excuter par le formulaire de modification du compte.
*/
function editClient($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,$operation) {
	$objetSudoku = new displaySudokus();
	if ($_SESSION["s_id_client"] != "-1") {
		$new_clients = $objetSudoku->sgbd_client->getClients($My_SQL,$_SESSION["s_id_client"]);
		$new_client = $new_clients[0];
	}
	include ('header.php');
    echo $objetSudoku->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,$operation);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Enregistre un compte client.
* 
* Ce dialogue permet au client de modifier son compte client.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $new_client Tableau contenant les rubriques du compte client.
* @param array $clef Tableau contenant les identifiants du client en cours.
*/
function saveClient($My_SQL,$vars_mod,$new_client,$clef) {
	$objetSudoku = new displaySudokus();
	$admin = new adminSudoku();
	if ($objetSudoku->save_client($My_SQL,$vars_mod,$new_client)) {
		$vars_mod[$vars_mod["id_client"]] = $objetSudoku->sgbd_client->get_client_id($My_SQL,$clef);
		$_SESSION["s_id_client"] = $vars_mod[$vars_mod["id_client"]];
		displayOneClient($My_SQL,$vars_mod);
	}
	else {
		if ($objetSudoku->sgbd_client->exists_code($My_SQL,$new_client["codeclient"])) {
			$alerte_code = _CATALOGClIENTBADCODE;
		}
		else {
			$alerte_code = "";
		}
		$erreur = _CATALOGClIENTBADSAVE;
		editClient($My_SQL,$vars_mod,$new_client,$erreur,$alerte_code,"save_client");
	}
}

/**
* Affiche les donnes publiques d'un client.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
*/
function displayOneClient($My_SQL,$vars_mod) {
    $objetSudoku = new displaySudokus();
    include ('header.php');
    echo $objetSudoku->get_one_client($My_SQL,$vars_mod);
    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Permet d'ouvrir ou de crer un compte client.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $clef Tableau contenant les identifiants du client en cours.
*/
function setClient($My_SQL,$vars_mod,$clef) {
	$objetSudoku = new displaySudokus();
    if ($clef["codeclient"] == "" && $clef["passwd"] == "") {
    	include ('header.php');
	    echo $objetSudoku->set_client($My_SQL,$vars_mod,"","edit_client","set_client");
	    echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
	    include ('footer.php');
    }
    else {
		if ($objetSudoku->sgbd_client->exists_client($My_SQL,$clef)) {
    		$_SESSION["s_id_client"] = $objetSudoku->sgbd_client->get_client_id($My_SQL,$clef);
   			$vars_mod[$vars_mod["id_client"]] = $_SESSION["s_id_client"];
			displayOneClient($My_SQL,$vars_mod);
    	}
   		else {
   			include ('header.php');
   			echo $objetSudoku->set_client($My_SQL,$vars_mod,_CATALOGClIENTBADPASS,"edit_client","set_client");
   			echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
	    	include ('footer.php');
   		}
    }
}

/**
* Permet defermer le compte client en cours.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @param array $clef Tableau contenant les identifiants du client en cours.
*/
function closeClient($My_SQL,$vars_mod,$clef) {
	$objetSudoku = new displaySudokus();
	$_SESSION["s_id_client"] = "-1";
	include ('header.php');
	echo $objetSudoku->set_client($My_SQL,$vars_mod,"","edit_client","set_client");
	echo $objetSudoku->sudoku_bar($My_SQL,$vars_mod);
	include ('footer.php');
}

/**
* Permet au client de rcuprer son identifiant et son son password.
* 
* Ce dialogue permet au client de saisir son e-mail.
* Si celui -ci est reconnu dans les comptes clients, son identifiant et son son password sont expdis.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
*/
function getIds($My_SQL,$vars_mod) {
	$objetCatalog = new displaySudokus();
    include ('header.php');
    echo $objetCatalog->get_Ids($My_SQL,$vars_mod);
    echo $objetCatalog->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}

/**
* Permet au client de rcuprer son identifiant et son son password.
* 
* Si les identifiants sont retrouvs, il sont expdis, sinon le formulaire de saisie d'e-mail est  nouveau propos.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
*/
function sendIds($My_SQL,$vars_mod) {
	$objetCatalog = new displaySudokus();
    include ('header.php');
    echo $objetCatalog->send_Ids($My_SQL,$vars_mod);
    echo $objetCatalog->sudoku_bar($My_SQL,$vars_mod);
    include ('footer.php');
}



/**
* Affiche les donnes publiques d'un client  destination de l'imprimante.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @todo Cette fonction n'est pas utilisable. Il faut l'crire pour le module sudoku.
*/
function printClient($My_SQL,$vars_mod) {
    global $site_logo,$Default_Theme, $nukeurl, $sitename, $module_name;
    
    $tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	
	if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecarto = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylecarto = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}
    
    echo "
    <html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\">
    <head>
    <title>$sitename</title>
    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
    <LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	".$stylecarto."
	</head>
    <body bgcolor=\"#FFFFFF\" text=\"#000000\">
    <table border=\"0\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
    <div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"><span class=\"title\">$title_section</span></div>
    <div class=\"zprint\">
    ";
    $objetCarte = new displayCartos();
    echo $objetCarte->get_map($My_SQL,$vars_mod,$keymap);
    echo "
    </div>
    </td></tr></table></td></tr></table>
    
    <div class=\"printFooter\">
    <div class=\"siteName\">
    "._COMESFROM." $sitename<br>
    <a href=\"$racine\">$racine</a>
    </div>
    <div class=\"pageURL\">
    "._THEURL."<br>
    <a href=\"$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."\">$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."</a>
    </div>
    </div>
    </td></tr></table>
    </body>
    </html>
    ";
}

/**
 * Appel des fonctions en fonction du paramtre $sop.
 */
switch($sop) {
    case "display":
    	displayOneSudoku($My_SQL,$vars_mod);
	    break;
	case "list":
    	displayListSudoku($My_SQL,$vars_mod,$crit_find_sudoku);
	    break;
	case "search":
    	searchSudokus($My_SQL,$vars_mod,$crit_find_sudoku);
	    break;
	case "save":
    	saveMySudoku($My_SQL,$vars_mod,$new_partie_sudoku,$clef);
	    break;
	case "new_client_save_sudoku":
		newClient($My_SQL,$vars_mod,$new_client,"","","save_client_save_sudoku");
		break;
	case "save_client_save_sudoku":
		saveClientSaveSudoku($My_SQL,$vars_mod,$new_client,$new_partie_sudoku,"save_client_save_sudoku");
		break;
	case "edit_client":
		editClient($My_SQL,$vars_mod,$new_client,"","","save_client");
		break;
	case "save_client":
		saveClient($My_SQL,$vars_mod,$new_client,$clef);
		break;
	case "set_client":
		setClient($My_SQL,$vars_mod,$clef);
		break;
	case "close_client":
		closeClient($My_SQL,$vars_mod,$clef);
		break;
	case "get_ids":
		getIds($My_SQL,$vars_mod);
		break;
	case "send_ids":
		sendIds($My_SQL,$vars_mod);
		break;
	case "display_my_grids":
		displayMySudokus($My_SQL,$vars_mod,$crit_find_sudoku);
		break;
	case "play_my_grid":
		displayOnePartySudoku($My_SQL,$vars_mod);
		break;
	case "print":
		printClient($My_SQL,$vars_mod);
	    break;
    default:
		displayListSudoku($My_SQL,$vars_mod,$crit_find_sudoku);
	    //echo "Aucune opration  effectuer n'a t choisie'";
	    break;
}

?>