<?php 
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/utils.php");

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}

function array_implode( $glue, $separator, $array ) {
	if ( ! is_array( $array ) ) return $array;
	$string = array();
	foreach ( $array as $key => $val ) {
		if ( is_array( $val ) )
			$val = implode( ',', $val );
		$string[] = "{$key}{$glue}{$val}";
		 
	}
	return implode( $separator, $string );
	 
}

function array_explode( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function docookie($setuid, $setusername, $setpass, $setstorynum, $setumode, $setuorder, $setthold, $setnoscore, $setublockon, $settheme, $setcommentmax, $groups, $url_perso="", $user_name = "", $user_firstname="") {
	$lesgroupes = array_implode("@",";",$groups);
	$info = base64_encode("$setuid:$setusername:$setpass:$setstorynum:$setumode:$setuorder:$setthold:$setnoscore:$setublockon:$settheme:$setcommentmax:$lesgroupes:$url_perso:$user_name:$user_firstname");
	setcookie("user","$info",time()+2592000);
	global $user;
	$user = $info;
}

function login_general($username, $user_password, $groupstrict="0") {
	global $setinfo, $user_prefix, $db, $module_name, $pm_login, $prefix,$simpleusersgenhomepage;
	global $withuserabt;
	global $recaptcha_secret;
	
	$param_groupstrict = "";
	if ($groupstrict != "0") {
		$param_groupstrict = "&groupstrict=".$groupstrict;
	}
	
	$response = $_POST["g-recaptcha-response"];
	
	$url = 'https://www.google.com/recaptcha/api/siteverify';
	$data = array(
			'secret' => $recaptcha_secret,
			'response' => $response
	);
	$options = array(
			'http' => array (
					'method' => 'POST',
					'content' => http_build_query($data)
			)
	);
	$context  = stream_context_create($options);
	$verify = file_get_contents($url, false, $context);
	$captcha_success=json_decode($verify);
	if ($captcha_success->success==false) {
		header("Location: mobiles.php?name=$module_name$param_groupstrict&stop=3");
		die();
	}
	else if ($captcha_success->success==true) {

		$simpleusersgenhomepageperso = "";
	
		$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
		include("config.php");
		$sql = "SELECT pass, uid, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax, user_url_login, user_name, user_firstname, user_master_id FROM ".$user_prefix."_users WHERE uname='$username'";
		$result = $db->sql_query($sql);
		$setinfo = $db->sql_fetchrow($result);
	
		if (($db->sql_numrows($result)==1) AND ($setinfo['uid'] != 1) AND (!empty($setinfo['pass']))) {
			if ($setinfo["user_url_login"] != "") {
				$simpleusersgenhomepageperso = $setinfo["user_url_login"];
			}
			$dbpass=$setinfo['pass'];
			$non_crypt_pass = $user_password;
			$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
			$new_pass = md5($user_password);
			if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
				$db->sql_query("UPDATE ".$user_prefix."_users SET pass='$new_pass' WHERE uname='$username'");
				$sql = "SELECT pass FROM ".$user_prefix."_users WHERE uname='$username'";
				$result = $db->sql_query($sql);
				$row = $db->sql_fetchrow($result);
				$dbpass = $row['pass'];
			}
			if ($dbpass != $new_pass) {
				header("Location: mobiles.php?name=$module_name$param_groupstrict&stop=1");
				return;
			}
			$datekey = date("F j");
			$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
			$code = substr($rcode, 2, 6);
			if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
				header("Location: mobiles.php?name=$module_name$param_groupstrict&stop=1");
				die();
			}
			else {
				/** vrif abonnement avant de valider le login **/
				if ($withuserabt == 1) {
				    if ($withuserabt == 1) {
				        if ($setinfo["user_master_id"] != "" && $setinfo["user_master_id"] != "0" ) {
				            $sql = "SELECT `id` FROM `".$user_prefix."_users_abt` WHERE `id_user`=".$setinfo['user_master_id']." AND `du` <= '".date("Y-m-d")."' AND `au` >= '".date("Y-m-d")."';";
				            $result5 = $db->sql_query($sql);
				            if ($db->sql_numrows($result5) == 0) {
				                Header("Location: modules.php?name=$module_name&stop=2");
				                die();
				            }
				        }
				        else {
				            $sql = "SELECT `id` FROM `".$user_prefix."_users_abt` WHERE `id_user`=".$setinfo['uid']." AND `du` <= '".date("Y-m-d")."' AND `au` >= '".date("Y-m-d")."';";
				            $result5 = $db->sql_query($sql);
				            if ($db->sql_numrows($result5) == 0) {
				                Header("Location: mobiles.php?name=$module_name&stop=2");
				                die();
				            }
				        }
				    }
				}
					
				$sql = "SELECT ".$user_prefix."_groups.id, ".$user_prefix."_groups.name FROM ".$user_prefix."_groups inner join ".$user_prefix."_users_groups on group_id=".$user_prefix."_groups.id WHERE user_id='".$setinfo['uid']."'";
				$result2 = $db->sql_query($sql);
				if ($db->sql_numrows($result2)) {
					$lesgroupes = array();
					while ($ligne = $db->sql_fetchrow($result2)) {
						if ($groupstrict=="1") { //vrification que les domaines sont nots pour ce groupe
							$sql3 = "SELECT id FROM ".$user_prefix."_domain_name_groups WHERE group_id='".$ligne["id"]."'";
							//echo $sql3."//";
							$result3 = $db->sql_query($sql3);
							if ($db->sql_numrows($result3) == 0) {
								//le groupe est valable pour tous les domaines
								$lesgroupes[$ligne["id"]] = $ligne["name"];
							}
							else {
								$sql4 = "SELECT ".$user_prefix."_domain_name.id FROM ".$user_prefix."_domain_name INNER JOIN ".$user_prefix."_domain_name_groups ON ".$user_prefix."_domain_name.id=".$user_prefix."_domain_name_groups.domain_id WHERE ".$user_prefix."_domain_name_groups.group_id='".$ligne["id"]."' AND ".$user_prefix."_domain_name.name='".$_SERVER["HTTP_HOST"]."'";
								//echo $sql4."//";
								$result4 = $db->sql_query($sql4);
								if ($db->sql_numrows($result4) > 0) {
									$lesgroupes[$ligne["id"]] = $ligne["name"];
								}
							}
						}
						else {
							$lesgroupes[$ligne["id"]] = $ligne["name"];
						}
					}
					$setinfo['groups'] = $lesgroupes;
				}
				else {
					$setinfo['groups'] = array();
				}
				docookie($setinfo['uid'], $username, $new_pass, $setinfo['storynum'], $setinfo['umode'], $setinfo['uorder'], $setinfo['thold'], $setinfo['noscore'], $setinfo['ublockon'], $setinfo['theme'], $setinfo['commentmax'], $setinfo['groups'], $simpleusersgenhomepageperso, $setinfo['user_name'], $setinfo['user_firstname']);
				$uname = $_SERVER['REMOTE_ADDR'];
				$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$uname' AND guest='1'");
				$db->sql_query("UPDATE ".$prefix."_users SET last_ip='$uname' WHERE uname='$username'");
			}
			
			ajoutStat("401 : login d'un membre gnral via SimpleUser");
	
			if ($simpleusersgenhomepageperso != "") {
				header("Location: ".$simpleusersgenhomepageperso);
				die();
			}
			if ($simpleusersgenhomepage != "") {
				if ($withrewriting)	{
					header("Location: User_mpage_".$simpleusersgenhomepage.".htm");
				}
				else {
					header("Location: mobiles.php?name=Sections&sop=viewarticle&artid=".$simpleusersgenhomepage);
				}
				die();
			}
			header("Location: index.php");
			die();
		}
		else {
			header("Location: mobiles.php?name=$module_name$param_groupstrict&stop=1");
			die();
		}
	}
}

function main($user) {
	global $stop, $module_name, $redirect, $mode, $t, $f, $gfx_chk, $simpleusersgenhomepage, $Default_Theme;
	global $bypass,$hid,$url,$mmg;
	global $scripts_extra, $withrewriting;
	global  $groupstrict;
	global $recaptcha_public;
	
	if(!is_user($user)) {
		if (isset($groupstrict)) {
			$groupstrict = "0";
		}
		$sortie = "";
		if (file_exists('themes/'.$Default_Theme.'/pattern_users_identif.php')) {
			require_once('themes/'.$Default_Theme.'/pattern_users_identif.php');
		}
		else {
			$message = '<p>Veuillez saisir vos paramtres de connexion SVP.</p>';
			if ($stop == 1) {
				$message = '<p>Identifiants incorrects ! Essayez  nouveau...</p>';
			}
			if ($stop == 2) {
				$message = '<p>Votre abonnement est expir. Veuillez le renouveler SVP.</p>';
			}
			if ($stop == 3) {
				$message = '<p>Le test "reCAPTCHA" a chou. Essayez  nouveau...</p>';
			}
			if ($stop == 4) {
				$message = '<p>Vos nouveaux identifiants viennent de vous tre expdis par courriel. Ils sont d\'ores et dj actifs, et vous pouvez les utiliser immdiatement.</p>';
			}
			
			$scripts_extra .= '
			<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
			<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
			<script type="text/javascript" src="themes/acmo/js/jquery.growl.js"></script>
			<link rel="stylesheet" href="themes/acmo/style/jquery.growl.css">
			<link rel="stylesheet" href="themes/acmo/style/contact-form.css">
			<script src="https://www.google.com/recaptcha/api.js"></script>';
			
			$formulaire = '
			<form id="contact-form" action="mobiles.php" method="post">
			<div class="contact-form-loader"></div>
			<fieldset>
			<label class="twocols">
			<champ nom="username" lib="Pseudo"></champ>
			<input type="text" name="username" placeholder="Pseudo :" value="" autocorrect="off" autocapitalize="none" />
			</label>
			<label class="twocols">
			<champ nom="user_password" lib="Mot de passe"></champ>
			<input type="password" name="user_password" placeholder="Mot de passe :" value="" autocorrect="off" autocapitalize="none" />
			</label>
			
			<div class="clear"></div>
			<div id="brecaptcha">
			<div class="g-recaptcha" data-size="compact" data-sitekey="'.$recaptcha_public.'"></div>
			<a href="#" class="btn" data-type="submit">Identification</a>
			</div>
			</fieldset>
			<input type="hidden" value="'.$module_name.'" name="name">
			<input type="hidden" value="logingen" name="op">
			<input type="hidden" value="'.$groupstrict.'" name="groupstrict">
			</form>';
			
			
			
			$sortie .= '
			<div class="container">
			<div class="row">
			<div class="grid_12">
			<h3>Espace membre</h3>
			'.$message.'
			<div class="fwn">
				<p class="fwn">N\'oubliez pas de valider le test "reCAPTCHA"  la fin du formulaire.</p>
			</div>
			'.$formulaire.'
			<p class="ta__center top_20"><a href="mobiles.php?name='.$module_name.'&op=pass_lost">'.'Mot de passe oubli ? Cliquez ici !'.'</a></p>
			<p class="ta__center"><a href="modules.php?name='.$module_name.'&op=submitusergen">'.'Crer un compte utilisateur'.'</a></p>
			</div>
			</div>
			</div>
			';
		}
		
		
		$sortie = utilFuncs_simpleUsers::conditionnerMobile($sortie);
		
		include ('header_mobile.php');
		echo $sortie;
		include ('footer_mobile.php');
	}
	elseif (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$url_perso = $userdata[12];
		if ($url_perso != "") {
			header("Location: ".$url_perso);
			die();
		}
		if ($simpleusersgenhomepage != "") {
			if ($withrewriting)	{
			    if (file_exists('themes/'.$Default_Theme.'/pattern_users_home.php')) {
			        require_once('themes/'.$Default_Theme.'/pattern_users_home.php');
			    }
			    else {
				    header("Location: User_mpage_".$simpleusersgenhomepage.".htm");
			    }
			}
			else {
				header("Location: mobiles.php?name=Sections&sop=viewarticle&artid=".$simpleusersgenhomepage);
			}
			die();
		}
		header("Location: index.php");
	}
}

function pass_lost() {
	global $stop, $module_name, $redirect, $mode, $t, $f, $gfx_chk, $simpleusersgenhomepage, $Default_Theme;
	global $bypass,$hid,$url,$mmg;
	global $scripts_extra, $withrewriting,$user;
	global $recaptcha_public;

	if(!is_user($user)) {
		$sortie = "";
		if (file_exists('themes/'.$Default_Theme.'/pattern_users_passlost.php')) {
			require_once('themes/'.$Default_Theme.'/pattern_users_passlost.php');
		}
		else {
			$message = '';
			if ($stop == 1) {
				$message = '<p>Aucun couple Pseudo/e-mail correspondant n\'a t trouv ! Essayez  nouveau...</p>';
			}
			if ($stop == 2) {
				$message = '<p>Votre abonnement est expir. Veuillez le renouveler SVP.</p>';
			}
			if ($stop == 3) {
				$message = '<p>Le test "reCAPTCHA" a chou. Essayez  nouveau...</p>';
			}
				
			$scripts_extra .= '
			<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
			<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
			<script type="text/javascript" src="themes/acmo/js/jquery.growl.js"></script>
			<link rel="stylesheet" href="themes/acmo/style/jquery.growl.css">
			<link rel="stylesheet" href="themes/acmo/style/contact-form.css">
			<script src="https://www.google.com/recaptcha/api.js"></script>';
				
			$formulaire = '
			<form id="contact-form" action="mobiles.php" method="post">
			<div class="contact-form-loader"></div>
			<fieldset>
			<label class="twocols">
			<champ nom="username" lib="Pseudo"></champ>
			<input type="text" name="username" placeholder="Pseudo :" value="" autocorrect="off" autocapitalize="none" />
			</label>
			<label class="twocols">
			<champ nom="usermail" lib="Adresse e-mail" ctl="email"></champ>
			<input type="text" name="usermail" placeholder="E-mail :" value="" autocorrect="off" autocapitalize="none" />
			</label>
				
			<div class="clear"></div>
			<div id="brecaptcha">
			<div class="g-recaptcha" data-size="compact" data-sitekey="'.$recaptcha_public.'"></div>
			<a href="#" class="btn" data-type="submit">Identification</a>
			</div>
			</fieldset>
			<input type="hidden" value="'.$module_name.'" name="name">
			<input type="hidden" value="mailpasswd" name="op">
			</form>';
				
				
				
			$sortie .= '
			<div class="container">
			<div class="row">
			<div class="grid_12">
			<h3>Espace membre</h3>
			'.$message.'
			<div class="fwn">
			<p class="fwn">N\'oubliez pas de valider le test "reCAPTCHA"  la fin du formulaire.</p>
			</div>
			<p>Veuillez entrez votre pseudo et votre e-mail (celui fourni lors de votre enregistrement) puis cliquez sur "Envoyer" pour valider. Nous vous enverrons un e-mail automatique avec vos codes d\'accs.</p>
			<p>Si vous avez chang d\'adresse de courrier lectronique depuis votre inscription, veuillez nous contacter en utilisant le formulaire de contact pour corriger cette adresse.</p>
			'.$formulaire.'
			</div>
			</div>
			</div>
			';
		}


		$sortie = utilFuncs_simpleUsers::conditionnerMobile($sortie);

		include ('header_mobile.php');
		echo $sortie;
		include ('footer_mobile.php');
	}
	elseif (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$url_perso = $userdata[12];
		if ($url_perso != "") {
			header("Location: ".$url_perso);
			die();
		}
		if ($simpleusersgenhomepage != "") {
			if ($withrewriting)	{
				header("Location: User_mpage_".$simpleusersgenhomepage.".htm");
			}
			else {
				header("Location: mobiles.php?name=Sections&sop=viewarticle&artid=".$simpleusersgenhomepage);
			}
			die();
		}
		header("Location: index.php");
	}
}

function mail_password($username, $usermail) {
	global $sitename, $simpleusersgenadminmail, $nukeurl, $user_prefix, $db, $module_name;
	global $recaptcha_secret;
	
	$response = $_POST["g-recaptcha-response"];
	
	$url = 'https://www.google.com/recaptcha/api/siteverify';
	$data = array(
			'secret' => $recaptcha_secret,
			'response' => $response
	);
	$options = array(
			'http' => array (
					'method' => 'POST',
					'content' => http_build_query($data)
			)
	);
	$context  = stream_context_create($options);
	$verify = file_get_contents($url, false, $context);
	$captcha_success=json_decode($verify);

	if ($captcha_success->success==false) {
		header("Location: mobiles.php?name=$module_name&stop=3");
		die();
	}
	else if ($captcha_success->success==true) {	
		$username = filter($username, "nohtml", 1);
		$username = substr($username, 0, 25);
		$username = htmlspecialchars($username,ENT_QUOTES,'ISO-8859-1',true);
		$sql = "SELECT uid, uname,email  FROM ".$user_prefix."_users WHERE uname='$username' AND email='$usermail'";
		$result = $db->sql_query($sql);
		if($db->sql_numrows($result) != 0) {
			//ok
			if (list($uid, $uname,$email) = $db->sql_fetchrow($result)) {
				
				ajoutStat("403 : renouvellement automatique du mot de passe de ".$uname." (uid = $uid)");
				
				$new_pass = substr(md5(time()),-8);
				$sql = "UPDATE ".$user_prefix."_users SET pass='".md5($new_pass)."' WHERE uid='$uid'";
				if ($db->sql_query($sql)) {
					//email utilisateur
					$message = _SMEMBERSNEWPASSBODY;
					$message = str_replace("<!--login-->", $uname,$message);
					$message = str_replace("<!--passwd-->", $new_pass,$message);
					if (utilFuncs_simpleUsers::send_email($email,$simpleusersgenadminmail,_SMEMBERSNEWPASSSUB,$message)) {
						header("Location: mobiles.php?name=$module_name&stop=4");
					}
					else {
						die("Erreur sur envoi de message renouvellement de mot de passe. Contactez l'administrateur du site !");
					}
				}
			}
		}
		else {
			//pas ok
			header("Location: mobiles.php?name=$module_name&op=pass_lost&stop=1");
			die();
		}
	}
	else {
		
	}
}


function logout() {
	global $prefix, $db, $user, $cookie, $redirect, $module_name;
	if (is_user($user)) {
		
		ajoutStat("402 : logout d'un membre");
		
		cookiedecode($user);
		$r_uid = $cookie[0];
		$r_username = $cookie[1];
		setcookie("user", false);
		$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$r_username'");
		$user = "";
		setcookie ("user", "", time() - 3600);
	}
	header("Location: mobiles.php?name=$module_name&stop=5");
	die();
}

function get_card_member() {
	global $prefix, $db, $user, $module_name, $Default_Theme;
	
	if(is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		
		$sortie = "";
		if (file_exists('themes/'.$Default_Theme.'/pattern_users_card_member.php')) {
			require_once('themes/'.$Default_Theme.'/pattern_users_card_member.php');
		}
		else {
			//action par defaut  programmer un jour
			$sortie = '<p>le programme par dfaut reste  faire</p>';
		}
		
		$sortie = utilFuncs_simpleUsers::conditionnerMobile($sortie);

		require_once("includes/html2pdf.php");
		$monpdf = new handle_pdf("A7", "L", "fr");
		$monpdf->affiche_pdf($sortie, "carte_membre_acmo.pdf","cmapdf", array(2,2,2,2));
		
		ajoutStat("700 : cration d'une carte de membre au format PDF");
	}
	else {
		header("Location: mobiles.php?name=".$module_name."&groupstrict=1");
		die();
	}
}

function new_user() {
	global $prefix, $db, $user, $module_name, $Default_Theme;
	
	if (file_exists('themes/'.$Default_Theme.'/pattern_users_new_user.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_users_new_user.php');
	}
	else {
		//action par defaut  programmer un jour
		$sortie = '<p>le programme par dfaut reste  faire</p>';
	}
	$sortie = utilFuncs_simpleUsers::conditionnerMobile($sortie);
	
	include ('header_mobile.php');
	echo $sortie;
	include ('footer_mobile.php');
	
}

function save_new_user($datauser) {
	global $prefix, $db, $simplenewslettergroup, $simpleusersgenadminmail;
	global $recaptcha_secret;
	global $simpleusersprivateadminmail;

	$datauser = array_map(array('utilFuncs_simpleUsers', 'conditionnertodb'), $datauser);
	$datauser = array_map('utf8_decode', $datauser);

	$r = new stdClass();

	$response = $_POST["g-recaptcha-response"];

	$url = 'https://www.google.com/recaptcha/api/siteverify';
	$data = array(
			'secret' => $recaptcha_secret,
			'response' => $response
	);
	$options = array(
			'http' => array (
					'method' => 'POST',
					'content' => http_build_query($data)
			)
	);
	$context  = stream_context_create($options);
	$verify = file_get_contents($url, false, $context);
	$captcha_success=json_decode($verify);
	if ($captcha_success->success==false) {
		//$r->error = 'Le test &quot;reCAPTCHA&quot; a &eacute;chou&eacute;. Essayez &agrave; nouveau...';
		$r->debug = utf8_encode("Test reCAPTCHA invalide");
		$r->error = utf8_encode('Le test "reCAPTCHA" a chou. Essayez  nouveau...');
		$r->result_new_user = 'false';
		$r->uid = "";
	}
	else if ($captcha_success->success==true) {
		/* cration user et lien groupe */
		$sql = "SELECT uid FROM ".$prefix."_users WHERE email='".$datauser["email"]."'";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0 ) {
			$r->debug = utf8_encode("Email dupliqu : arrt");
			$r->error = utf8_encode('Cette adresse e-mail est dj utilise. Changez-en ou identifiez-vous dans l\'espace membre pour renouveler votre abonnement.');
			$r->result_new_user = 'false';
			$r->uid = "";
		}
		else {
			/* test existance uname identique => ajout d'un numro */
			$obj_util = new utilFuncs_simpleUsers();
			$uname = substr($obj_util->normaliser(strtolower($datauser["prenom"])), 0,3).substr($obj_util->normaliser(strtolower($datauser["nom"])), 0,3);
			$sql = "SELECT uid FROM ".$prefix."_users WHERE uname='".$uname."'";
			$result = $db->sql_query($sql);
			$compteur = 0;
			while ($db->sql_numrows($result) > 0 ) {
				$compteur++;
				$sql = "SELECT uid FROM ".$prefix."_users WHERE uname='".$uname.$compteur."'";
				$result = $db->sql_query($sql);
			}
			if ($compteur > 0) {
				$uname .= $compteur;
			}
			/* cration compte */
			$datauser["adresse"] = str_replace("\n\n", "\n", str_replace("\r", "\n", trim($datauser["adresse"])));
			$user_regdate = date("M d, Y");
			$newpass = substr(md5(time().$uname), 0,8);
			$passwd = md5($newpass);
			$passwd = htmlspecialchars(stripslashes($passwd),ENT_QUOTES,'ISO-8859-1',true);
			$result = $db->sql_query("INSERT INTO ".$prefix."_users (uname, pass, user_regdate, email, user_name, user_firstname, adh_tel, adh_adresse) VALUES ('".$uname."', '".$passwd."', '".$user_regdate."', '".$datauser["email"]."', '".$datauser["nom"]."', '".$datauser["prenom"]."', '".$datauser["tel"]."', '".$datauser["adresse"]."')");
			if (!$result) {
				$error = $db->sql_error();
				$r->debug = utf8_encode("Erreur base de donnes cration compte");
				$r->error = utf8_encode('Invalid query :'.$error["message"]);
				$r->result_new_user = 'false';
				$r->uid = "";
			}
			else {
				/* lien avec groupe par dfaut (Newsletter)*/
				$uid = $db->sql_nextid();
				$result = $db->sql_query("INSERT INTO ".$prefix."_users_groups (user_id, group_id) VALUES ('".$uid."','".$simplenewslettergroup."')");
				if (!$result) {
					$error = $db->sql_error();
					$r->debug = utf8_encode("Erreur base de donnes lien compte avec groupe par dfaut");
					$r->error = utf8_encode('Invalid query :'.$error["message"]);
					$r->result_new_user = 'false';
					$r->uid = "";
				}
				else {
					/* retour opration */
					$r->error = '';
					$r->debug = utf8_encode("Nouveau pseudo : ".$uname);
					$r->result_new_user = 'true';
					$r->uid = $uid;
					/* envoi des coordonnes du compte par e-mail au destinataire pour qu'il puisse crer un abt plus tard mme en cas de problme, comme un adhrent ayant dpass la date de validit de son compte */
					$message = "Bonjour $user_firstname $user_name,\n\n";
					$message .= "Les identifiants  utiliser pour acceder  l'espace membre de notre site sont :\nPseudo : $uname\nMot de passe : $newpass\n\n";
					$message .= "Il n'est pas encore actif. Il le sera quand le rglement aura t effectu. Vous recevrez alors un autre message.\n\n";
					$message .= "Vous pourrez effectuer ce rglement plus tard si vous le dsirez. Pour cela identifiez-vous dans l'espace membre avec les valeurs ci dessus. Vous pourrez alors accder  la page permettant d'effectuer le paiment scuris.\n\n";
					$message .= "Nous vous remercions pour votre soutien.";
					if (!utilFuncs_simpleUsers::send_email($datauser["email"],$simpleusersgenadminmail,"Cration de votre compte de membre",$message)) {
						$r->debug = utf8_encode("Erreur d'envoi message");
						$r->error = utf8_encode("Erreur d'envoi du message. Contactez l'administrateur");
						$r->result_new_user = 'false';
						$r->uid = "";
					}
					utilFuncs_simpleUsers::send_email($simpleusersprivateadminmail,$simpleusersgenadminmail,"Copie de cration de compte de membre",$message);
				}
			}
		}
	}
	
	if ($r->result_new_user == 'true') {
		$prenom = utilFuncs_simpleUsers::anti_conditionnertodb($datauser["prenom"]);
		$nom = utilFuncs_simpleUsers::anti_conditionnertodb($datauser["nom"]);
		$membre = $prenom.(($prenom != "" && $nom != "") ? " " : "").$nom." (".$uid.")";
		ajoutStat("404 : cration de compte par nouvel adhrent ".$membre);
	}

	header('cache-control: no-cache'); // no-cache (important for mobile safari)
	header('content-type: application/json'); // Result content type

	echo json_encode($r);
	die();
}

function save_new_abt($dataabt) {
	global $prefix, $db, $simpleusersgenadminmail;
	global $simpleusersprivateadminmail;

	$dataabt = array_map(array('utilFuncs_simpleUsers', 'conditionnertodb'), $dataabt);
	$dataabt = array_map('utf8_decode', $dataabt);
	
	$master = true;
	$sql = "SELECT user_master_id FROM ".$prefix."_users WHERE uid='".$dataabt["id_user"]."'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
	    if ($ligne = $db->sql_fetchrow($result)) {
	        if ($ligne["user_master_id"] != "" && $ligne["user_master_id"] != 0) {
	            $master = false;
	            $old_id = $dataabt["id_user"];
	            $dataabt["id_user"] = $ligne["user_master_id"];
	        }
	    }
	}
	
	$dataabt["le"] = date("Y-m-d H:i:s");
	$sql = "SELECT id, au FROM ".$prefix."_users_abt WHERE id_user='".$dataabt["id_user"]."' AND du<='".$dataabt["le"]."' AND au >='".$dataabt["le"]."' ORDER BY au DESC LIMIT 1;";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		if ($ligne = $db->sql_fetchrow($result)) {
			list($an,$mois,$jour) = explode ("-",$ligne["au"]);
			$dataabt["du"] = date("Y-m-d",mktime(0,0,0,$mois,$jour+1,$an));
			$dataabt["au"] = date("Y-m-d",mktime(0,0,0,$mois,$jour,$an+1));
		}
	}
	else {
		$an = date("Y");
		$mois = date("n");
		$jour =date("j");
		$dataabt["du"] = date("Y-m-d",mktime(0,0,0,$mois,$jour,$an));
		$dataabt["au"] = date("Y-m-d",mktime(0,0,0,$mois,$jour-1,$an+1));
	}
	
	/*
	$annee = date("Y");
	$mois = date("n");
	$dataabt["du"] = $annee."-".$mois."-01";
	$dataabt["au"] = ($annee+1)."-".$mois."-01";
	*/

	$r = new stdClass();

	$list_champs = "";
	$list_valeurs = "";
	
	foreach($dataabt as $key => $value) {
		if ($key != "id") {
			$list_champs .= ($list_champs == "") ? "" : ", ";
			$list_champs .= "`".$key."`";
			$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
			$list_valeurs .= "'".$value."'";
		}
	}
	$sql = "INSERT INTO `".$prefix."_users_abt` (".$list_champs.")";
	$sql .= " VALUES (".$list_valeurs.");";
	$result = $db->sql_query($sql);
	if (!$result) {
		$error = $db->sql_error();
		$r->debug = utf8_encode("Erreur base de donnes enregistrement abonnement 1".$sql);
		$r->error = utf8_encode('Invalid query :'.$error["message"]);
		$r->result_new_abt = 'false';
		$r->uid = $dataabt["id_user"];
	}
	else {
		/* retour opration */
		$r->error = '';
		$r->debug = utf8_encode("Nouvel abonnement du ".$dataabt["du"]." au ". $dataabt["au"]);
		$r->result_new_abt = 'true';
		$r->uid = $dataabt["id_user"];
		/* envoi des infos abonnement par e-mail au destinataire et  l'admin */
		if (!$master) {
		    $dataabt["id_user"] = $old_id;
		}
		$sql = "SELECT email, user_name, user_firstname FROM ".$prefix."_users WHERE uid='".$dataabt["id_user"]."'";
		$result = $db->sql_query($sql);
		if($db->sql_numrows($result) != 0) {
			if (list($email, $user_name, $user_firstname) = $db->sql_fetchrow($result)) {
				$message = "Bonjour $user_firstname $user_name,\n\n";
				$message .= "Votre compte est desormais activ et sera valable pour une anne. Vous pouvez  prsent vous identifier pour accder  l'espace membre de notre site.\n\n";
				$message .= "Vous recevrez des messages automatiques de rappel de renouvellement 1 mois, 15 jours et 3 jours avant chance de l'inactivation de votre compte.\n\n";
				$message .= "Nous vous remercions encore pour votre soutien.";
				if (!utilFuncs_simpleUsers::send_email($email,$simpleusersgenadminmail,"Activation de votre compte de membre",$message)) {
					$r->debug = utf8_encode("Erreur d'envoi message");
					$r->error = utf8_encode("Erreur d'envoi du message. Contactez l'administrateur");
					$r->result_new_abt = 'false';
					$r->uid = "";
				}
				utilFuncs_simpleUsers::send_email($simpleusersprivateadminmail,$simpleusersgenadminmail,"Copie de activation de votre compte de membre",$message);
			}
		}
		else {
			$r->debug = utf8_encode("Erreur base de donnes enregistrement abonnement 2".$sql);
			$r->error = utf8_encode('Pas de fiche membre correspondante');
			$r->result_new_abt = 'false';
			$r->uid = $dataabt["id_user"];
		}
	}
	
	if ($r->result_new_abt == 'true') {
		$membre = $user_firstname.(($user_firstname != "" && $user_name != "") ? " " : "").$user_name." (".$dataabt["id_user"].")";
		ajoutStat("405 : cration ou renouvellement adhsion ".$membre." - ".utilFuncs_simpleUsers::anti_conditionnertodb($dataabt["details"]));
	}
	
	header('cache-control: no-cache'); // no-cache (important for mobile safari)
	header('content-type: application/json'); // Result content type
	
	echo json_encode($r);
	die();
}

function new_abt() {
	global $prefix, $db, $user, $module_name, $Default_Theme;

	if (file_exists('themes/'.$Default_Theme.'/pattern_users_new_abt.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_users_new_abt.php');
	}
	else {
		//action par defaut  programmer un jour
		$sortie = '<p>le programme par dfaut reste  faire</p>';
	}
	$sortie = utilFuncs_simpleUsers::conditionnerMobile($sortie);

	include ('header_mobile.php');
	echo $sortie;
	include ('footer_mobile.php');

}

function get_user($datauser) {
	global $setinfo, $user_prefix, $db, $module_name, $prefix;
	global $recaptcha_secret;
	
	$r = new stdClass();
	
	$response = $_POST["g-recaptcha-response"];
	
	$url = 'https://www.google.com/recaptcha/api/siteverify';
	$data = array(
			'secret' => $recaptcha_secret,
			'response' => $response
	);
	$options = array(
			'http' => array (
					'method' => 'POST',
					'content' => http_build_query($data)
			)
	);
	$context  = stream_context_create($options);
	$verify = file_get_contents($url, false, $context);
	$captcha_success=json_decode($verify);
	if ($captcha_success->success==false) {
		$r->debug = utf8_encode("Erreur reCAPTCHA");
		$r->error = utf8_encode('Le test de reCAPTCHA a chou. Veuillez recommencer SVP.');
		$r->result_new_abt = 'false';
		$r->uid = '';
		$r->email = '';
		$r->user_name = '';
		$r->user_firstname = '';
	}
	else if ($captcha_success->success==true) {
		$username = $datauser["uname"];
		$user_password = $datauser["pass"];
		$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
		include("config.php");
		$sql = "SELECT pass, uid, user_name, user_firstname, email FROM ".$user_prefix."_users WHERE uname='$username'";
		$result = $db->sql_query($sql);
		$setinfo = $db->sql_fetchrow($result);
		if (($db->sql_numrows($result)==1) AND ($setinfo['uid'] != 1) AND (!empty($setinfo['pass']))) {
			$dbpass=$setinfo['pass'];
			$non_crypt_pass = $user_password;
			$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
			$new_pass = md5($user_password);
			if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
				$db->sql_query("UPDATE ".$user_prefix."_users SET pass='$new_pass' WHERE uname='$username'");
				$sql = "SELECT pass FROM ".$user_prefix."_users WHERE uname='$username'";
				$result = $db->sql_query($sql);
				$row = $db->sql_fetchrow($result);
				$dbpass = $row['pass'];
			}
			if ($dbpass != $new_pass) {
				$r->debug = utf8_encode("Erreur identification 1");
				$r->error = utf8_encode('L\'identification a choue : mauvais pseudo/mot de passe. Veuillez recommencer SVP.');
				$r->result_new_abt = 'false';
				$r->uid = '';
				$r->email = '';
				$r->user_name = '';
				$r->user_firstname = '';
			}
			else {
				$r->debug = utf8_encode("Membre identifi");
				$r->error = '';
				$r->result_new_abt = 'true';
				$r->uid = $setinfo['uid'];
				$r->email = $setinfo['email'];
				$r->user_name = utf8_encode($setinfo['user_name']);
				$r->user_firstname = utf8_encode($setinfo['user_firstname']);
			}
		}
		else {
			$r->debug = utf8_encode("Erreur identification 2".$sql);
			$r->error = utf8_encode('L\'identification a choue : mauvais pseudo/mot de passe. Veuillez recommencer SVP.');
			$r->result_new_abt = 'false';
			$r->uid = '';
			$r->email = '';
			$r->user_name = '';
			$r->user_firstname = '';
		}
	}
	header('cache-control: no-cache'); // no-cache (important for mobile safari)
	header('content-type: application/json'); // Result content type
	
	echo json_encode($r);
	die();
}

function check_recaptcha() {
	global $recaptcha_secret;

	$r = new stdClass();

	$response = $_POST["g-recaptcha-response"];

	$url = 'https://www.google.com/recaptcha/api/siteverify';
	$data = array(
			'secret' => $recaptcha_secret,
			'response' => $response
	);
	$options = array(
			'http' => array (
					'method' => 'POST',
					'content' => http_build_query($data)
			)
	);
	$context  = stream_context_create($options);
	$verify = file_get_contents($url, false, $context);
	$captcha_success=json_decode($verify);
	if ($captcha_success->success==false) {
		$r->debug = utf8_encode("Erreur reCAPTCHA");
		$r->error = utf8_encode('Le test de reCAPTCHA a chou. Veuillez recommencer SVP.');
		$r->result_new_abt = 'false';
	}
	else if ($captcha_success->success==true) {	
		$r->debug = utf8_encode("Ok recaptcha");
		$r->error = "";
		$r->result_recaptcha = 'true';
	}
	header('cache-control: no-cache'); // no-cache (important for mobile safari)
	header('content-type: application/json'); // Result content type

	echo json_encode($r);
	die();
}

switch($op) {
	case "newuser":
		new_user();	
		break;
	case "save_new_user":
		save_new_user($data);
		break;
	case "save_new_abt":
		save_new_abt($data);
		break;
	case "new_abt":
		new_abt();
		break;
	case "get_user":
		get_user($data);
		break;
	case "check_recaptcha":
		check_recaptcha();
		break;
	case "cardmember":
		get_card_member();
		break;
	case "logingen":
		login_general($username, $user_password, $groupstrict);
		break;
	case "pass_lost":
		pass_lost();
		break;
	case "mailpasswd":
		mail_password($username, $usermail);
		break;
	case "logout":
		logout();
		break;
	default:
		main($user);
		break;

}
?>