<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url_2($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function array_explode_2( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function verif_user_group2($groupfix) {
	global $user, $module_name, $db, $user_prefix;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
	}
	else {
		return false;
	}
	$sql = "SELECT id from ".$user_prefix."_users_groups WHERE user_id='".$userdata[0]."' AND group_id='$groupfix';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		return true;
	}
	else {
		return false;
	}
}

function show_users($page) {
	global $db, $user_prefix, $user,$group, $module_name, $simpleuserscontact,$Default_Theme;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
	}
	else {
		die("Accs non autoris !");
	}
	$group_data_bloc = base64_decode($group);
    	$groupdata = explode(":", $group_data_bloc);
	$current_group = $groupdata[0];
    $current_group_name = $groupdata[1];
    
    if (!verif_user_group2($current_group)) die("Autorisation rfuse !");
    
	$sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_tel` , `user_name` , `user_firstname`";
	$sql .= " FROM `".$user_prefix."_users`";
	$sql .= " WHERE uid='".$userdata[0]."';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$ligneuser = $db->sql_fetchrow($result);
	}
	else {
		setcookie("group"," ");
		setcookie("user"," ");
		die("Votre compte n'existe plus !");
	}
	
	$ligne_par_page = 20;
	
    include("header.php");
		
	//Accueil de l'espace collaboratif !!!!!
	$sortie = "";
	$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
	$sortie .= "<h2>"._COMSPACE_ALLUSERS."</h2>";
    $sortieliste = "";
	//$sortie .= "<p>&nbsp;</p>";
    //$sortie .= '<table border="0" celpadding="0" cellspacing="0" width="100%"><tr><td width="49%" valign="top">';
    
    $sortiepub = '<table border="0" cellpadding="0" cellspacing = "0" class="coords">';
    
    $sortiepub .= '<tr><td>';
    $sortiepub .= _COMSPACE_PEUDO;
    $sortiepub .= '</td><td width= "20"></td><td class="coords">';
    $sortiepub .= $ligneuser["uname"];
    $sortiepub .= '</td></tr>';
    
    $sortiepub .= '<tr><td>';
    $sortiepub .= _COMSPACE_NOM;
    $sortiepub .= '</td><td width= "20"></td><td class="coords">';
    $sortiepub .= $ligneuser["user_firstname"]." ".$ligneuser["user_name"];
    $sortiepub .= '</td></tr>';
    
    $sortiepub .= '<tr><td>';
    $sortiepub .= _COMSPACE_ORG;
    $sortiepub .= '</td><td width= "20"></td><td class="coords">';
    $sortiepub .= $ligneuser["adh_entreprise"];
    $sortiepub .= '</td></tr>';
    
    $sortiepub .= '<tr><td>';
    $sortiepub .= _COMSPACE_TEL;
    $sortiepub .= '</td><td width= "20"></td><td class="coords">';
    $sortiepub .= $ligneuser["adh_tel"];
    $sortiepub .= '</td></tr>';
    
    $sortiepub .= '<tr><td>';
    $sortiepub .= _COMSPACE_EMAIL;
    $sortiepub .= '</td><td width= "20"></td><td class="coords">';
    $sortiepub .= $ligneuser["email"];
    $sortiepub .= '</td></tr>';
    
    $sortiepub .= '</table>';
    
    $sortiepub .= '<br /><div class="allelts"><a href="modules.php?name=Sections&sop=viewarticle&artid='.$simpleuserscontact.'">'._COMSPACE_CHANGE_YOUR_ACCOUNT.'</a></div>';
    
    $sortie .= '<fieldset class="publi"><legend>'._COMSPACE_YOUR_ACCOUNT.'</legend>'.$sortiepub.'</fieldset>';
    
	//$sortie .= '</td><td width="2%"></td><td width="49%" valign="top">';
	
	if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
		$icnmsg = 'themes/'.$Default_Theme.'/images/send_mail.png';
	}
	else {
		$icnmsg = 'images/smallicone/send_mail.png';
	}
    
	$sql = "SELECT COUNT(`uid`) AS nbre ";
	$sql .= " FROM `".$user_prefix."_users`";
	$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id";
	$sql .= " WHERE group_id='".$current_group."';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 0) {
		die("Problme base de donnes !!");
	}
	$ligneuser = $db->sql_fetchrow($result);
	
	$theindex = list_index($ligneuser["nbre"], $page, $ligne_par_page);
	$limite = " LIMIT ".($page-1)*$ligne_par_page.",".$ligne_par_page;
	
    $sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_tel` , `user_name` , `user_firstname`";
	$sql .= " FROM `".$user_prefix."_users`";
	$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id"; 
	$sql .= " WHERE group_id='".$current_group."' ORDER BY uname ASC".$limite.";";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while ($ligneuser = $db->sql_fetchrow($result)) {
			$story_link = '<a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligneuser["uid"].'">';
			$mailbutton = '<a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligneuser["uid"].'" title="'.'Expdier un message'.'"><img src="'.$icnmsg.'" border="0"></a>';
			$actions = '<span class="actions">&nbsp;'.$mailbutton.'</span>';
			$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligneuser["user_firstname"]." ".$ligneuser["user_name"].'</a>';
			$sortieliste .= ' - '.ucfirst($ligneuser["adh_entreprise"]).'</span>';
			$sortieliste .= '<span class="auteur">'.$ligneuser["uname"].'</span>'.'</li>';
		}
		$sortiepub = "<ul class=\"listpubli\" style=\"margin-top: 8px\">".$sortieliste."</ul>";
    		//$sortiepub .= '<div class="allelts"><a href="modules.php?name='.$module_name.'&op=allpub">'._COMSPACE_ALLELEMENTS.'</a></div>';
    		$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_USERS.'</legend>'.$theindex.$sortiepub.$theindex.'</fieldset>';
	}
	else {
		$sortie .= "<div class=\"comment\">";
		$sortie .= "Aucun membre pour ce groupe.";
		$sortie .= "</div>";
	}
	
	//$sortie .= '</td></tr></table>';
	
	
	
	echo $sortie;
   	$bardef=array("back"=>"javascript:window.history.back()",
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
		"mailto"=>"#",
		"top"=>"#top" );
	buttonBar($bardef, "align");
	include("footer.php");
}

function getXMLusers($text) {
	global $db, $user_prefix, $user,$group, $module_name, $simpleuserscontact;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
	}
	else {
		die("Accs non autoris !");
	}
	$group_data_bloc = base64_decode($group);
    	$groupdata = explode(":", $group_data_bloc);
	$current_group = $groupdata[0];
    $current_group_name = $groupdata[1];
    
    if (!verif_user_group2($current_group)) die("Autorisation rfuse !");
    
    $sortie = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
	$sortie .= '<users>'."\n";
	
	$text = "CONVERT(_utf8 '".sans_accent($text)."%' USING utf8) COLLATE utf8_general_ci";
    
	$sql = "SELECT `uid`, `uname`, `user_name` , `user_firstname`";
	$sql .= " FROM `".$user_prefix."_users`";
	$sql .= " INNER JOIN `".$user_prefix."_users_groups` on uid=user_id";
	$sql .= " WHERE (uname like ".$text." OR user_name like ".$text." OR user_firstname like ".$text.") AND group_id='".$current_group."' ORDER BY uname ASC;";

	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while ($ligneuser = $db->sql_fetchrow($result)) {
			$sortie .= '<user>'."\n";
			$sortie .= "\t".'<uname>'.utf8_encode($ligneuser["uname"]).'</uname>'."\n";
			$sortie .= "\t".'<user_name>'.utf8_encode($ligneuser["user_name"]).'</user_name>'."\n";
			$sortie .= "\t".'<user_firstname>'.utf8_encode($ligneuser["user_firstname"]).'</user_firstname>'."\n";
			$sortie .= '</user>'."\n";
		}
	}
	$sortie .= '</users>'."\n";
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Cache-Control: no-cache");
	header("Pragma: no-cache");
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

function sans_accent($chaine) {
   $accent  ="";
   $noaccent="aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby";
   return strtr(trim($chaine),$accent,$noaccent);
}

function list_index($nbreFiches, $page, $ligne_par_page) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._COMSPACE_MEMBERS_FOUND;
		$indexPages .= _COMSPACE_MEMBERS_PAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}
	
		}
	}
	else {
		$indexPages .= _COMSPACE_MEMBERS_NOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

if (!isset($page)) {
	$page = 1;
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "getXMLusers" :
		getXMLusers($auteur);
		break;
	default:
		show_users($page);
		break;
}

?>