<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url_2($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function array_explode_2( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function verif_user_group2($groupfix) {
	global $user, $module_name, $db, $user_prefix;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
	}
	else {
		return false;
	}
	$sql = "SELECT id from ".$user_prefix."_users_groups WHERE user_id='".$userdata[0]."' AND group_id='$groupfix';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		return true;
	}
	else {
		return false;
	}
}

function show_messages($page) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode_2( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
    		
		include("header.php");
		$sortie = "";
		$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
		$sortie .= "<h2>"._COMSPACE_ALLMSGPERSO."</h2>";
	
	
		if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
    		$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
    	}
    	else {
    		$icnmsg = 'images/smallicone/messaging.png';
    	}
		if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
			$icndelmsg = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
		}
		else {
			$icndelmsg = 'images/deletesmall.gif';
		}
    	
		$sortiecom = "";
 		$sortieliste = "";
 		$sortiepub = "";
 		$sql = "SELECT `to_userid`,`msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
    	$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
 		$sql .= " WHERE to_userid = '".$userdata[0]."' and valid='1' order by msg_time desc;";

 		$result = $db->sql_query($sql);
    		if ($db->sql_numrows($result) > 0) {
    			//$lignes =array();
    			$nbrefiches  = $db->sql_numrows($result);
    			while($ligne = $db->sql_fetchrow($result)) {
    				//$lignes[] = $ligne;
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					if ($ligne["to_userid"] == $userdata[0] || is_admin($admin)) {
						$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delmessage&file=messages&id='.$ligne["msg_id"].'" title="'._COMSPACE_DELMSG.'"><img src="'.$icndelmsg.'" border="0"></a>'; 
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
					else {
						$deletebutton = "";
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
					
	    			$story_link = "<a href=\"modules.php?name=".$module_name."&file=messages&op=viewmessage&id=".$ligne["msg_id"]."\">";	
    				$sortieliste .= '<li><span class="titre">'.$actions.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
    			}
    			$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
    		}
    		else {
    			$sortiepub .= "Pas de messages personnels !!";
    		}
    		//$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSO.'</legend>'.$sortiepub.'</fieldset>';
		$sortie .= $sortiepub;
	
	
		echo $sortie;
    		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
		
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function show_messages_sent($page) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
    		
    		$group_data_bloc = base64_decode($group);
    		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
    		$current_group_name = $groupdata[1];
    		
		include("header.php");
		$sortie = "";
		$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
		$sortie .= "<h2>"._COMSPACE_ALLMSGPERSOSENT."</h2>";
	
	
		if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
    		$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
    	}
    	else {
    		$icnmsg = 'images/smallicone/messaging.png';
    	}
		if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
			$icndelmsg = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
		}
		else {
			$icndelmsg = 'images/deletesmall.gif';
		}
    	
		$sortiecom = "";
 		$sortieliste = "";
 		$sortiepub = "";
 		$sql = "SELECT `msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
    	$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
 		$sql .= " WHERE from_userid = '".$userdata[0]."' order by msg_time desc;";

 		$result = $db->sql_query($sql);
    		if ($db->sql_numrows($result) > 0) {
    			//$lignes =array();
    			$nbrefiches  = $db->sql_numrows($result);
    			while($ligne = $db->sql_fetchrow($result)) {
    				//$lignes[] = $ligne;
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					/*if ($ligne["to_userid"] == $userdata[0] || is_admin($admin)) {
						$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delmessage&file=messages&id='.$ligne["msg_id"].'" title="'._COMSPACE_DELMSG.'"><img src="'.$icndelmsg.'" border="0"></a>'; 
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
					else {
						$deletebutton = "";
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}*/
					$actions = "";
					
	    			$story_link = "<a href=\"modules.php?name=".$module_name."&file=messages&op=viewmessagesent&id=".$ligne["msg_id"]."\">";	
    				$sortieliste .= '<li><span class="titre">'.$actions.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
    			}
    			$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
    		}
    		else {
    			$sortiepub .= "Pas de messages expdis !!";
    		}
    		//$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSO.'</legend>'.$sortiepub.'</fieldset>';
		$sortie .= $sortiepub;
	
	
		echo $sortie;
    		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
		
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function view_message($id) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
    		
    		$group_data_bloc = base64_decode($group);
    		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
    		$current_group_name = $groupdata[1];
    		
    		$sql = "SELECT `msg_id`, `subject`, `msg_text`,`msg_time`, `from_userid`, `uname` FROM ".$user_prefix."_priv_msgs";
    		$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
 		$sql .= " WHERE msg_id = '".$id."';";

 		$result = $db->sql_query($sql);
    		if ($db->sql_numrows($result) == 1) {
    			$ligne = $db->sql_fetchrow($result);
    			$sql = "UPDATE ".$user_prefix."_priv_msgs SET read_msg='1' WHERE msg_id='$id'";
    			$db->sql_query($sql);
    		}
    		else {
    			die ("Problme base de donnes !!");
    		}
    		
    		$aboutmsg = "Expdi le ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"],$formatdateprivspacepub)." par ".$ligne["uname"];
    		
		include("header.php");
		$sortie = "";
		$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
		$sortie .= '<div class="publi"><h2>'.$ligne["subject"].'</h2><span class="auteur">'.$aboutmsg.'</span>'.$ligne["msg_text"].'</div>';
		
		$sortie .= '<div class="actmsg"><a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligne["from_userid"].'&id_message='.$id.'">[ '._COMSPACE_ANSWERMSG.' ]</a></div>';
		
		
		
		echo $sortie;
    		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
		
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}	
}

function view_message_sent($id) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
    		
    		$group_data_bloc = base64_decode($group);
    		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
    		$current_group_name = $groupdata[1];
    		
    	$sql = "SELECT `msg_id`, `subject`, `msg_text`,`msg_time`, `from_userid`, `uname` FROM ".$user_prefix."_priv_msgs";
    	$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
 		$sql .= " WHERE msg_id = '".$id."';";
 		
 		$result = $db->sql_query($sql);

		$result = $db->sql_query($sql);
    		if ($db->sql_numrows($result) == 1) {
    			$ligne = $db->sql_fetchrow($result);
    		}
    		else {
    			die ("Problme base de donnes !!");
    		}
    		
    	$aboutmsg = "Expdi le ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"],$formatdateprivspacepub)."  ".$ligne["uname"];
    		
		include("header.php");
		$sortie = "";
		$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
		$sortie .= '<div class="publi"><h2>'.$ligne["subject"].'</h2><span class="auteur">'.$aboutmsg.'</span>'.$ligne["msg_text"].'</div>';
		
		//$sortie .= '<div class="actmsg"><a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligne["from_userid"].'&id_message='.$id.'">[ '._COMSPACE_ANSWERMSG.' ]</a></div>';
		
		
		
		echo $sortie;
    		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
		
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}	
}

function new_message($id_user="", $id_message="") {
	global $_headerContent, $group, $user,$module_name, $db, $user_prefix, $downloadprivspacecat, $admin;
	global $formatdateprivspacepub;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    	$userdata = explode(":", $user_data_bloc);
    	$userdata[11] = array_explode_2( "@",";", $userdata[11]);
		
		$group_data_bloc = base64_decode($group);
	    $groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
	    $current_group_name = $groupdata[1];
	    
	    //pour affichage du message auquel on rpond
		$themessage = "";
	    $lignemessage = array();
	    if ($id_message != "") {
	    		$sql = "SELECT `msg_id`, `subject`, `msg_text`,`msg_time`, `from_userid`, `to_userid`, `uname` FROM ".$user_prefix."_priv_msgs";
	    		$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
	 		$sql .= " WHERE msg_id = '".$id_message."';";
		    $result = $db->sql_query($sql);
		    if ($db->sql_numrows($result) > 0) {
		    		$lignemessage = $db->sql_fetchrow($result);
		    		if ($lignemessage["to_userid"] != $userdata[0]) {
		    			die("Accs non autoris !");	
		    		}
		    		$themessage .= "<br /><div class=\"publi\">";
		    		$themessage .= "<div class=\"comment\">";
				$themessage .= "<span class=\"titre\">".$lignemessage["subject"]."</span>";
				$themessage .= "<span class= \"auteur\">Post le ".utilFuncs_simpleSpace::date2JMA($lignemessage["msg_time"],$formatdateprivspacepub)." par ".$lignemessage["uname"]."</span>";
				$themessage .= "<div class=\"commentbody\">".$lignemessage["msg_text"]."</div>";
				$themessage .= "</div>";
				$themessage .= "</div>";
		    }
		    else {
		    		die("Message inexistant !");	
		    }
	    }
	    //pour user auquel on expdie le message
	    $ligneuser = array();    
	    if ($id_user != "") {
	    	$sql = "SELECT uname FROM ".$user_prefix."_users WHERE uid='".$id_user."'";
	    	$result = $db->sql_query($sql);
		    if ($db->sql_numrows($result) > 0) {
		    	$ligneuser = $db->sql_fetchrow($result);
		    }
	    	else {
		    	die("Utilisateur inexistant !");	
		    }
	    }
	    
	    $lignemessage = array_merge($lignemessage, $ligneuser);
	    if ($lignemessage["subject"]) {
	    		$lignemessage["subject"] = "Re: ".$lignemessage["subject"];
	    }
	    
	    	$_headerContent ='
<script language="Javascript" src="javascripts/control_form.js"></script>
<script language="JavaScript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
<script type="text/javascript" src="javascripts/initfck.js"></script>
';
	
		setHeader($_headerContent);
		
		$sortie = "";
		$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
		$sortie .= "<form action=\"modules.php?name=".$module_name."\" method=\"post\" onsubmit=\"return submit_form(this)\">";
    	$sortie .= '<input type="hidden" name="op" value="savemessage">';
    	$sortie .= '<input type="hidden" name="file" value="messages">';
    	$sortie .= '<input type="hidden" name="data[from_userid]" value="'.$userdata[0].'">';
    	$sortie .= '<input type="hidden" name="data[to_userid]" value="'.$id_user.'">';

    	if ($id_message == "") {
    		$sortie .= '<h2>'._COMSPACE_NEWMSG.'</h2>';
    	}
    	else {
    		$sortie .= '<h2>'._COMSPACE_ANSWRMSG.'</h2>';
    	}
    	if ($id_message != "") {
			$sortie .= '
			<fieldset class="newpub"><legend>'._COMSPACE_THEMESSAGE.'</legend>
				'.$themessage.'
			</fieldset>
			<br />';
    	}
		$sortie .= '<fieldset class="newpub"><legend>'._COMSPACE_YOURMESSAGE.'</legend>
	    <table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
	    	<tr>
	    		<td class="label"><p>Destinataire : </p></td>
	    		<td class="content">'.$ligneuser["uname"].'</td>
	    	</tr>
		    <tr>
		        <td class="label">
		        <p>'._COMSPACE_COMMSUBJECT.'</p>
		        </td>
		        <td class="content"><champ lib="'._COMSPACE_SUBJECT_VERIF.'" nom="data[subject]" lim="1,100"></champ><input type="text" name="data[subject]" value="'.$lignemessage["subject"].'" class="saisiepub" /></td>
		    </tr>
		    <tr>
		        <td class="label">
		        <p>'._COMSPACE_MSGBODY.'</p>
		        </td class="content">
		        <td><!--<champ lib="'._COMSPACE_BODYMSG_VERIF.'" nom="data[msg_text]" lim="1,4000"></champ>-->
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[msg_text]" cols="70" rows="30" name="data[msg_text]">'.$lignemessage["msg_text"].'</textarea>
<script type="text/javascript">editSix("data[msg_text]");</script></div></div></td>
		    </tr>
		</table>
		</fieldset>
	';
		$sortie .= "<div align=\"center\"><input type=\"submit\" value=\""._COMSPACE_MSG_SAVE."\"></div>";
	    	
	    	$sortie .= "</form>";
		
	    include("header.php");	
	    	echo $sortie;
	    	$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function list_index($nbreFiches, $page, $ligne_par_page) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._COMSPACE_MEMBERS_FOUND;
		$indexPages .= _COMSPACE_MEMBERS_PAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&file=users&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}
	
		}
	}
	else {
		$indexPages .= _COMSPACE_MEMBERS_NOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function save_message($data) {
	global $user, $group, $module_name, $db, $user_prefix, $admin;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    	$userdata = explode(":", $user_data_bloc);
    	$userdata[11] = array_explode_2( "@",";", $userdata[11]);
    	
    	$group_data_bloc = base64_decode($group);
    	$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
    	$current_group_name = $groupdata[1];
    	
		if ($data["to_userid"] != "") {
			$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users WHERE uid ='".$data["to_userid"]."'";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$leusers = $db->sql_fetchrow($result);
			}
	    	else {
		    	die("Utilisateur inexistant !");	
		    }
	    }
    		
    	$date = date("Y-m-d H:i");`msg_id`;
		$data = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $data);
		
    	$sql = "INSERT INTO ".$user_prefix."_priv_msgs (`subject`, `from_userid`, `to_userid`, `msg_time`, `msg_text`, `read_msg`, `valid`)";
		$sql .= " VALUES ('".$data["subject"]."', '".$userdata[0]."', '".$data["to_userid"]."', '".$date."','".$data["msg_text"]."', '0', '1')";
		$ok = $db->sql_query($sql);
		
		if (!$ok) {
			die("Erreur d'enregistrement dans la base de donnes !");
		}
		$id_mess = $db->sql_nextid();
		
		global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
		$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
		$nukeurl = format_nuke_url_2($nukeurl);
		$messlinklink = "$nukeurl/modules.php?name=$module_name&op=viewmessage&file=messages&id=".$id_mess;
		$saut = "\n";
		$sep = "--------------------------------------------------\n";
		
		$sujet = "Nouveau message personnel de ".$userdata[1];
		$message = "";
		$message .= "Un nouveau message personnel vous a t envoy par ".$userdata[1]." sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
			
		$message .= $sep;
		$message .= "Date du message : ".date("d/m/Y H:i").$saut;
		$message .= "Voir le message : ".$messlinklink.$saut;
		
		$obj_pub = new utilFuncs_simpleSpace();
		$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
		if (!$okmail) {
			die("Erreur expdition mail");
		}
		
		
		header("Location: modules.php?name=$module_name");
		die();
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}	
}

function del_message($id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db,$admin;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    	$userdata = explode(":", $user_data_bloc);

		$sql = "SELECT `to_userid`, `subject` FROM ".$user_prefix."_priv_msgs";
    	$sql .= " WHERE `msg_id` = '".$id."';";
 		
    	$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
			if (($ligne["to_userid"] != $userdata[0]) && !is_admin($admin)) {
				die("Autorisation refuse !");
			}
		}
		else {
			die("Autorisation refuse !");
		}

		if ($ok=="y") {
			//suppression messages
			//$db->sql_query("DELETE FROM ".$user_prefix."_priv_msgs WHERE msg_id='".$id."';");
			$db->sql_query("UPDATE ".$user_prefix."_priv_msgs SET valid='0' WHERE msg_id='$id'");
    		header("Location: modules.php?name=$module_name&op=space");
			die();
		}
		else {
			$group_data_bloc = base64_decode($group);
	    		$groupdata = explode(":", $group_data_bloc);
			$current_group = $groupdata[0];
	    		$current_group_name = $groupdata[1];
	    		
			$titre_group = "";
			if ($current_group_name != "") {
				$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
			}
		
			$sortie = "<h1>"._COMSPACE.$titre_group."</h1>";
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["subject"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._COMSPACE_DELMSG_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=delmessage&file=messages&id=".$id."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
			
			include("header.php");
		    echo $sortie;
			include("footer.php");	
		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

if (!isset($page)) {
	$page = 1;
}
if (!isset($id_message)) {
	$id_message = "";
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "viewmessage":
		view_message($id);
		break;
	case "viewmessagesent":
		view_message_sent($id);
		break;
	case "savemessage":
		save_message($data);
		break;
	case "newmessage":
		new_message($id_user, $id_message);
		break;
	case "delmessage":
		del_message($id,$ok);
		break;
	case "allmsgsent":
		show_messages_sent($page);
		break;
	default:
		show_messages($page);
		break;
}

?>