<?php
if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	
	require_once("modules/$module_name/utils.php");
	require_once("core/becms_ui_component.php");
	
	
	function list_enlevement($valide=1) {
		global $Default_Theme, $user_prefix, $db, $op, $action, $onglet;
		global $select;
		
		$barDef=array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "url"=>"","comment"=>_EDIT, "status"=>"ON"),
  			      		"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png", "url"=>"","comment"=>_DELETE,"status"=>"ON")
  			);
		
		
		$limit = "";
		
		$where = '';
		
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= $user_prefix."_encombrants.`valide`='".utilFuncs_lozzu::conditionnertodb($valide)."'";
		
		$dateinf = date("Y-m-d",(strtotime("last Sunday")-(14*3600*24))); //limit au lundi d'il y a quinze jours'
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= $user_prefix."_encombrants.`date_enlevement`>'".utilFuncs_lozzu::conditionnertodb($dateinf)."'";
		
		/*if ($select["user"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.id_proprio='".utilFuncs_cursinu::conditionnertodb($select["user"])."'";
		}
		if ($select["nom"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.nom LIKE '%".utilFuncs_cursinu::conditionnertodb($select["nom"])."%'";
		}
		if ($select["lof"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.lof LIKE '%".utilFuncs_cursinu::conditionnertodb($select["lof"])."%'";
		}
		if ($select["du"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.naissance >= '".utilFuncs_cursinu::conditionnertodb($select["du"])."'";
		}
		if ($select["au"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.naissance <= '".utilFuncs_cursinu::conditionnertodb($select["au"])."'";
		}
		if ($select["lignee_valide"] != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_cursinu_chien.lignee_valide='".utilFuncs_cursinu::conditionnertodb($select["lignee_valide"])."'";
		}*/
			
		$limit = '';
		
		$sql = 'SELECT `Id`, `date_enlevement`,`lieu_enlevement`,`commune_enlevement`, `nom`,`prenom`, `adresse`, `tel`, `portable`,`email`,`liste_encombrants` ';
		$sql .= ' FROM '.$user_prefix.'_encombrants';
		$sql .= $where;
		$sql .= ' ORDER BY `'.$user_prefix.'_encombrants`.`date_enlevement` DESC';
		$sql .= ' '.$limit.';';
		
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$liste .= '<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" align="left">Date d\'enlvement</th>
					<th class="systemTabHeader">Commune</th>
					<th class="systemTabHeader">Administr</th>
					<th class="systemTabHeader">Adresse</th>
					<th class="systemTabHeader">Lieu d\'enlvement</th>
					<th class="systemTabHeader">Encombrants</th>
					<th class="systemTabHeader">Tl</th>
					<th class="systemTabHeader">Portable</th>
					<th class="systemTabHeader">Courriel</th>
					<th class="systemTabHeader">Action</th>
    				</tr>';
			$pos=0;
			while ($ligne = $db->sql_fetchrow($result)) {
				if ($pos % 2 ==0){
					$thestyle="listTableOdd";
				}
				else {
					$thestyle="listTableNone";
				}
				$liste .= "<tr class=\"$thestyle\">"
					."<td nowrap=\"nowrap\" align=\"left\">".utilFuncs_lozzu::date2JMA($ligne["date_enlevement"],"d/m/Y")."</td>"
					."<td align=\"center\">".$ligne["commune_enlevement"]."</td>"
					."<td align=\"center\">".$ligne["prenom"].(($ligne["prenom"].$ligne["nom"] != '') ? " " : "").$ligne["nom"]."</td>"
					."<td align=\"center\">".nl2br($ligne["adresse"])."</td>"
					."<td align=\"center\">".nl2br($ligne["lieu_enlevement"])."</td>"
					."<td align=\"center\">".nl2br($ligne["liste_encombrants"])."</td>"
					."<td align=\"center\">".$ligne["tel"]."</td>"
					."<td align=\"center\">".$ligne["portable"]."</td>"
					."<td align=\"center\">"."<a href=\"mailto:".$ligne["email"]."\">".$ligne["email"]."</a>"."</td>"
					;
				$liste .= "<td nowrap align=\"center\">";

				/*$paramsplus = '';
				if (is_array($select)) {
					foreach($select as $key => $value) {
						if ($value != "") {
							$paramsplus .= '&select['.$key.']='.urlencode($value);
						}
					}
				}*/
				
				$barDef["edit"]["url"]="system.php?op=lozzu&action=edit_enlevement&onglet=$onglet&Id=".$ligne["Id"].$paramsplus;
				$barDef["delete"]["url"]="system.php?op=lozzu&action=delete_enlevement&onglet=$onglet&ok=0&Id=".$ligne["Id"].$paramsplus;
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","", true);
				$liste .= "</td></tr>";
				$pos++;
			}
			$liste .= '</table>';
		}
		else {
			$liste = "<p><b>Aucun enlvement prvu !</b></p>";
		}
		
		$liste .= '<a href="system.php?op=lozzu&action=new_enlevement">[+] Ajouter un enlvement</a>';
		/*$liste .= '<br/><a href="system.php?op=cursinu&action=export_list_chien'.$paramsplus.'">[+] Exporter la liste au format Excel</a>';
		$liste .= '<br/><a href="system.php?action=score_all_lignee&op=cursinu&onglet=chien">[+] Assistance  la confirmation de ligne</a>';*/
		return $liste;
	}
	
	function edit_enlevement($Id,$enlevement=array()) {
		global $module_name, $db, $user_prefix, $aid, $admin,$header_system,$onglet, $Default_Skin;
		global $select, $fromsynthese;
		
		$header_system = '
<script type="text/javascript" src="javascripts/lang/lang-french.js">
</script> <script type="text/javascript" src="javascripts/control_form.js"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js"> </script>
<script type="text/javascript">
	function control_date(formulaire) {
		if (!submit_form(formulaire)) {
			return false;
		}
		var ladate = formulaire.elements["enlevement[date_enlevement]"].value;
		var lacommune = formulaire.elements["enlevement[commune_enlevement]"].value;
		var messexp = formulaire.elements["withmail"].checked;
		var valid = formulaire.elements["enlevement[valide]"].checked;
		var email = formulaire.elements["enlevement[email]"].value;
		if (!valid && messexp) {
			alert("Vous ne pouvez pas envoyer un message de confirmation si l\'enlvement n\'est pas valid !");
			return false;
		}
		if (messexp && email == "") {
			alert("Vous ne pouvez pas envoyer un message de confirmation si l\'email est vide !");
			return false;
		}
		var url = "system.php?op=lozzu&action=valid_enlevement_planning&commune=" +lacommune+"&date="+ladate;
		var result = GetAJAXData(url);
		if (result != "ok") {
			if (!confirm("Cette date ne correspond pas avec le planning de ramassage dans cette commune.\n"+result+"\nEnregistrer tout de mme ?")) {
				return false;
			}
		}
		return true;
	}
</script>
<link rel="stylesheet" type="text/css" media="all" href="javascripts/calendar/styles/calendar-win2k-cold-1.css" title="win2k-cold-1" />
<script type="text/javascript" src="javascripts/calendar/calendar.js"></script>
<script type="text/javascript" src="javascripts/calendar/lang/calendar-fr.js"></script>
<script type="text/javascript" src="javascripts/calendar/calendar-setup.js"></script>
<script type="text/javascript">
	function setuplecalendrier(elt) {
	 	Calendar.setup({
			inputField     :    elt.id,
	    	ifFormat       :    "%d/%m/%Y",
	    	daFormat       :	"%d/%m/%Y",
	    	showsTime      :    false,
			button         :    elt.id,
			eventName      :    "focus",
	    	align          :    "Bl",
	    	singleClick    :    true
	    });
    }
</script>
';
		
		$sortie = "";
		if ($enlevement["Id"] != "") {
			$enlevement = array_map("stripslashes", $enlevement);
		}
		else {
			if ($Id == "-1") {
				$enlevement["Id"] = "-1";
				$enlevement["date_enlevement"] = date("d/m/Y");
				$enlevement["lieu_enlevement"] = "";
				$enlevement["commune_enlevement"] = "";
				$enlevement["nom"] = "";
				$enlevement["prenom"] = "";
				$enlevement["adresse"] = "";
				$enlevement["tel"] = "";
				$enlevement["portable"] = "";
				$enlevement["email"] = "";
				$enlevement["liste_encombrants"] = "";
				$enlevement["valide"] = "0";
			}
			else {
				$sql = "SELECT `Id`, `date_enlevement`,`lieu_enlevement`,`commune_enlevement`, `nom`,`prenom`, `adresse`, `tel`, `portable`,`email`,`liste_encombrants`, `valide` FROM ".$user_prefix."_encombrants WHERE Id='".$Id."'";
				$result = $db->sql_query($sql);
			    if($db->sql_numrows($result) > 0) {
			    	if ($enlevement = $db->sql_fetchrow($result)) {
			    		$enlevement["date_enlevement"] = utilFuncs_lozzu::date2JMA($enlevement["date_enlevement"],"d/m/Y");
			    	}
			    	else {
			    		die("Erreur rcup elvement");
			    	}
			    }
			    else {
					die("problme");
				}
			}
		}
		
		$menucommune = "";
		$sql = "SELECT DISTINCT `commune` FROM `becms_encombrants_planning` ORDER BY `commune` ASC;";
		$result2 = $db->sql_query($sql);
	    if($db->sql_numrows($result2) > 0) {
	    	$menucommune .= '<select size="1" name="enlevement[commune_enlevement]">';
	    	$menucommune .= '<option value="">'.'Choisissez'."</option>";
	    	while (list($commune) = $db->sql_fetchrow($result2)) {
	    		$selected = ($enlevement["commune_enlevement"] == $commune) ? " selected=\"selected\"" : "";
	    		$menucommune .= '<option value="'.$commune.'"'.$selected.'>'.$commune."</option>";
	    	}
	    	$menucommune .= "</select>";
	    }
		
		/*$bvalid = '';
		$checked = ($enlevement["lignee_valide"] == "1") ? ' checked="checked"' : "";
		$bvalid .= '<input type="radio" value="1" name="chien[lignee_valide]" id="valid1"'.$checked.'><label for="valid1">Oui</label>';
		$checked = ($enlevement["lignee_valide"] == "0") ? ' checked="checked"' : "";
		$bvalid .= '<input type="radio" value="0" name="chien[lignee_valide]" id="valid2"'.$checked.'><label for="valid2">Non</label>';*/
		
		$bvalid = '';
		$checked = ($enlevement["valide"] == "1") ? ' checked="checked"' : "";
		$bvalid .= '<input type="checkbox" value="1" name="enlevement[valide]" id="valide"'.$checked.'>';
		
		$sortie = '<center><form action="system.php" name="thedog" method="post" enctype="multipart/form-data" onsubmit="return control_date(this)">
			<table class=systemTab>
				<tr><td>Commune d\'enlvement : </td>
				<td><champ nom="enlevement[commune_enlevement]" lib="Commune"></champ>'.$menucommune.'</td></tr>
				
				<tr><td>Date de l\'enlvement : </td>
				<td><champ nom="enlevement[date_enlevement]" lib="Date enlvement" ctl="date"></champ><input type="text" name="enlevement[date_enlevement]" id="enlevement[date_enlevement]"  value="'.$enlevement["date_enlevement"].'" size="50" maxlength="50" onmouseover="setuplecalendrier(this)"></td></tr>
				
				<tr><td>Nom : </td>
				<td><champ nom="enlevement[nom]" lib="Nom"></champ><input type="text" name="enlevement[nom]" value="'.$enlevement["nom"].'" size="50" maxlength="50"></td></tr>
				
				<tr><td>Prnom : </td>
				<td><input type="text" name="enlevement[prenom]" value="'.$enlevement["prenom"].'" size="50" maxlength="50"></td></tr>
				
				<tr><td>Adresse : </td>
				<td><textarea name="enlevement[adresse]" rows="3" cols="50">'.$enlevement["adresse"].'</textarea></td></tr>
				
				<tr><td>Tlphone : </td>
				<td><input type="text" name="enlevement[tel]" value="'.$enlevement["tel"].'" size="50" maxlength="50"></td></tr>
				<tr><td>Portable : </td>
				<td><input type="text" name="enlevement[portable]" value="'.$enlevement["portable"].'" size="50" maxlength="50"></td></tr>
				<tr><td>E-mail : </td>
				<td><champ nom="enlevement[email]" lib="E-mail" ctl="email" lim="0,-1"></champ><input type="text" name="enlevement[email]" value="'.$enlevement["email"].'" size="50" maxlength="50"></td></tr>
				
				<tr><td>Lieu de l\'enlvement : </td>
				<td><textarea name="enlevement[lieu_enlevement]" rows="3" cols="50">'.$enlevement["lieu_enlevement"].'</textarea></td></tr>
				
				<tr><td>Liste des encombrants : </td>
				<td><champ nom="enlevement[liste_encombrants]" lib="Liste des encombrants"></champ><textarea name="enlevement[liste_encombrants]" rows="3" cols="50">'.$enlevement["liste_encombrants"].'</textarea></td></tr>
				
				<tr><td>Enlvement confirm : </td>
				<td>'.$bvalid.'</td>
				
				<tr><td><b>Expdier message de confirmation  l\'administr : </b></td>
				<td><input type="checkbox" value="1" name="withmail"></td>
				</tr>
				
			';
			
		$paramsplus = '';
		if (is_array($select)) {
			$select = array_map("stripslashes", $select);
			foreach($select as $key => $value) {
				if ($value != "") {
					$paramsplus .= '<input type="hidden" name="select['.$key.']" value="'.$value.'">';
				}
			}
		}
		$paramfrom ="";
		if ($fromsynthese == "1") {
			$paramfrom = '<input type="hidden" name="fromsynthese" value="1">';
		}
		$sortie .="<tr><td>"
			."<input type=\"hidden\" name=\"op\" value=\"lozzu\">"
			."<input type=\"hidden\" name=\"action\" value=\"save_enlevement\">"
			."<input type=\"hidden\" name=\"enlevement[Id]\" value=\"".$enlevement["Id"]."\">"
			.$paramsplus
			.$paramfrom
			."<input type=\"hidden\" name=\"onglet\" value=\"$onglet\">"
			."</td>"
		    ."<td><input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr>";

		$sortie .= "</table></form></center>";
		return $sortie;
	}
	
	function save_enlevement($enlevement,$withmail) {
		global $db, $user_prefix;
		global $lozzuadminmail;
		
		$date_enlev = $enlevement["date_enlevement"];
		
		$enlevement["date_enlevement"] = utilFuncs_lozzu::date2AMJ($enlevement["date_enlevement"]);
		if (!isset($enlevement["valide"])) {
			$enlevement["valide"] = "0";
		}
		if ($enlevement["lieu_enlevement"] == "") {
			$enlevement["lieu_enlevement"] = $enlevement["adresse"];
		}
		
		$ok = true;
		$enlevement = array_map(array('utilFuncs_lozzu', 'conditionnertodb'), $enlevement);
		
		$list_champs = "";
		$list_valeurs = "";
		if ($enlevement["Id"] == "-1" || $enlevement["Id"] == "" || $enlevement["Id"] == "0") {
			$list_champs = ""; $list_valeurs="";
			foreach($enlevement as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO ".$user_prefix."_encombrants (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; $list_valeurs="";
			foreach($enlevement as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE ".$user_prefix."_encombrants SET ".$list_champs." WHERE `Id` = '".$enlevement["Id"]."';";
		}
	
		$ok = $db->sql_query($sql);
		//envoi du mail  l'administr
		if ($withmail == "1" && $enlevement["email"] != "") {
			$sujet = "Confirmation d'enlvement d'encombrant";
			$message = "La Communaut de Communes Calvi Balagne est heureuse de vous confirmer la demande d'enlvement d'encombrants que vous avez effectue via son site WEB.\n\n";
			$message .= "L'enlvement sollicit par ".$enlevement["prenom"].(($enlevement["prenom"].$enlevement["nom"] != '') ? " " : "").$enlevement["nom"]." concerne le ou les encombrants suivants :\n";
			$message .= $enlevement["liste_encombrants"]."\n\n";
			$message .= "Il aura lieu le ".$date_enlev." sur la commune de ".$enlevement["commune_enlevement"]."  :\n";
			$message .= $enlevement["lieu_enlevement"]."\n\n";
			$message .= "Pour nous contacter  ce propos, vous pouvez rpondre  ce courriel en conservant le sujet et le corps du message.";
			if (!utilFuncs_lozzu::send_email($enlevement["email"], $lozzuadminmail, $sujet, $message)) {
				die("Problme d'envoi de mail de confirmation. Appelez l'admin !");
			}
		}
		
		return $ok;
	}
	
	function delete_enlevement($Id,$confirm="n") {
		global $db, $user_prefix, $onglet;
		global $select;
		
		$paramsplus = '';
		if (is_array($select)) {
			foreach($select as $key => $value) {
				if ($value != "") {
					$paramsplus .= '&select['.$key.']='.urlencode($value);
				}
			}
		}
		
		if ($Id != "") {
			if ($confirm == "y") {
				$sql = "DELETE FROM ".$user_prefix."_encombrants WHERE `Id`=".$Id.";";
				if (!$db->sql_query($sql)) {
					die("erreur sur suppresion !");
				}
				if ($onglet == "enlevement") {
					$action = "list_enlevement";
				}
				else {
					$action = "list_enlevementno";
				}
				header("Location: system.php?op=lozzu&action=".$action."&onglet=".$onglet.$paramsplus);
				die();
			}
			else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._LOZZU_CONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=lozzu&action=delete_enlevement&onglet='.$onglet.'&Id='.$Id.'&ok=y'.$paramsplus.'">';
				$sortie .= "["._YES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._NO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
	}
	
	function planning($message = "") {
		global $db, $user_prefix,$module_name;
		global $onglet;
		
		$ligne = array();
		$result = $db->sql_query("SELECT jour, commune FROM `".$user_prefix."_encombrants_planning`;");
		if ($db->sql_numrows($result) > 0) {
			while ($ligneplan = $db->sql_fetchrow($result)) {
				$ligne[$ligneplan["jour"]][$ligneplan["commune"]] = 1;
			}
		}
		
		require("modules/$module_name/system/params.php");
		//$jours = array("lundi"=>"1", "mardi"=>"2", "mercredi"=>"3", "jeudi"=>"4", "vendredi"=>"5");
		//$communes = array("Calvi","Montegrosso","Zilia","Algajola","Calenzana","Lumio","Moncale","Galeria","Manso","Aregno","Avapessa","Calenzana","Cateri","Lavatoggio","Sant Antonino");
		$communes = array_unique($communes);
		sort($communes);
		$sortie = '<p style="text-align:center">&nbsp;<br /><b>Planning du ramassage par commune</b></p>';
		if ($message != "") {
			$sortie .= '<p style="text-align:center"><br /><b>Modification du planning enregistres</b><br /></p>';
		}
		$sortie .= '<form action="system.php" name="theplanning" method="post">';
		$sortie .= '<center><table cellpadding="0" cellspaccing="0" border="0" class="planning_commune">';
		foreach ($communes as $commune) {
			$sortie .= '<tr><td><b>'.$commune.'&nbsp;&nbsp;&nbsp;:&nbsp;</b></td><td>';
			foreach ($jours as $jour => $valeur) {
				$checked = '';
				if ($ligne[$valeur][$commune] == 1) {
					$checked = ' checked="checked"';
				}
				$sortie .= '<input type="checkbox" value="'.$commune."|".$valeur.'" id="'.$commune.$valeur.'" name="planning[]"'.$checked.'><label for="'.$commune.$valeur.'">'.ucfirst($jour).'</label>&nbsp;&nbsp;&nbsp;&nbsp;';
			}
			$sortie .= '</td></tr>';
		}
		$sortie .= '</table>';
		$sortie .= '<br/>&nbsp;<br /><input type="submit" value="Enregistrer le planning" name="valid">';
		$sortie .= '<input type="hidden" name="op" value="lozzu">';
		$sortie .= '<input type="hidden" name="action" value="save_planning">';
		$sortie .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
		$sortie .= '</center></form>';
		return $sortie;
	}
	
	function save_planning($planning) {
		global $db, $user_prefix;
		$ok = true;
		if ($db->sql_query("TRUNCATE `".$user_prefix."_encombrants_planning`;")) {
			foreach ($planning as $ligne) {
				list($commune,$jour) = explode("|", $ligne);
				$sql = "INSERT INTO ".$user_prefix."_encombrants_planning (jour, commune)";
				$sql .= " VALUES ('".$jour."', '".$commune."');";
				$ok &= $db->sql_query($sql);
			}
		}
		else {
			die("Erreur de vidage de planning");
		}
		return $ok;
	}
	
	function valid_enlevement_planning($date, $commune) {
		global $prefix,$db,$aid,$module_name;
		
		list($jour,$mois,$an) = explode("/",$date);
		$joursem = date("w",mktime(0,0,0,$mois,$jour,$an));
		$sql = "SELECT Id FROM ".$prefix."_encombrants_planning WHERE jour='$joursem' AND commune='".utilFuncs_lozzu::conditionnertodb($commune)."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1) {
			return "ok";
		}
		else {
			$sql = "SELECT jour FROM ".$prefix."_encombrants_planning WHERE commune='".utilFuncs_lozzu::conditionnertodb($commune)."';";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2) > 0) {
				require("modules/$module_name/system/params.php");
				//$jours = array("lundi"=>"1", "mardi"=>"2", "mercredi"=>"3", "jeudi"=>"4", "vendredi"=>"5");
				$joursem = "";
				while (list($jour) = $db->sql_fetchrow($result2)) {
		    		$joursem .= " - ".array_search($jour,$jours)."\n";
		    	}
		    	return "Jour(s) de rammassage planifi(s) pour cette commune :\n".$joursem;
			}
			return "Aucun jour de ramassage n'est prvu pour cette commune";
		}
	}
	
	function semaine_enlevement($date="") {
		global $Default_Theme, $user_prefix, $db, $op, $action, $onglet,$module_name,$header_system;
		global $select;
		
		require("modules/$module_name/system/params.php");
		//$jours = array("lundi"=>"1", "mardi"=>"2", "mercredi"=>"3", "jeudi"=>"4", "vendredi"=>"5");
		//$communes = array("Calvi","Montegrosso","Zilia","Algajola","Calenzana","Lumio","Moncale","Galeria","Manso","Aregno","Avapessa","Calenzana","Cateri","Lavatoggio","Sant Antonino");
		//$communes = array_unique($communes);
		//sort($communes);
		
		$header_system = '
<script type="text/javascript">
	function survol_jour(id) {
		var objet = document.getElementById(id)
		objet.style["display"] = "block";
	}
	function fin_survol_jour(id) {
		var objet = document.getElementById(id)
		objet.style["display"] = "none";
	}
</script>';
		
		$planning_semaine = array();
		$sql = 'SELECT `jour`, `commune` ';
		$sql .= ' FROM '.$user_prefix.'_encombrants_planning ';
		$sql .= ' ORDER BY `commune` ASC;';
		$result2 = $db->sql_query($sql);
		if ($db->sql_numrows($result2) > 0) {
			$liste = '<table  border="0" cellpadding="0" cellspacing="0">';
			while ($ligne = $db->sql_fetchrow($result2)) {
				$planning_semaine[$ligne["jour"]."*".$ligne["commune"]] = "1";
			}
		}	
		if ($date == "") {
			$date = strtotime("last Sunday")+3600*12;
		}
		else {
			$date = strtotime("last Sunday",$date)+3600*12;
		}
	
		$limit = "";
		
		$sortie = '<p style="text-align:center"><br /><b>Enlvements de la semaine du '.date("d/m/Y",($date)+(3600*24)).' au '.date("d/m/Y",($date)+(3600*24*5)).'</b></p>';
		$sortie .= '<p style="text-align:center">&nbsp;<br /><b><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date-3600*24*6).'">&lt;&lt; Semaine prcdente</a><span style="display:inline-block;width:80px"></span><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date+3600*24*8).'">Semaine suivante &gt;&gt;</a></b></p>';
		$sortie .= '<center><table cellpadding="0" cellspaccing="0" border="0" class="synthese">';
		$sortie .= '<tr><td class="commune_sem" align="center"><b>Communes</b></td>';
		foreach ($jours as $jour => $valeur) {
			$dateencours = date("Y-m-d",($date)+(3600*24*$valeur));
			$jourencours = date("d",($date)+(3600*24*$valeur));
			$sortie .= '<td align="center" class="jour_sem"><a href="system.php?action=jour_enlevement&op='.$op.'&onglet='.$onglet.'&date='.($date+3600*24*$valeur).'" title="Planning de travail du '.$jour.'"><b>'.ucfirst($jour).' '.$jourencours.'</b></a></td>';
		}
		$sortie .= '</tr>';
		foreach ($communes as $commune) {
			$sortie .= '<tr><td class="commune_sem"><b>'.$commune.'&nbsp;:</b></td>';
			foreach ($jours as $jour => $valeur) {
				$dateencours = date("Y-m-d",($date)+(3600*24*$valeur));
				$liste = "";
				
				$where = '';
				//$where .= ($where == "") ? " WHERE " : " AND ";
				//$where .= $user_prefix."_encombrants.`valide`='1'";
				$where .= ($where == "") ? " WHERE " : " AND ";
				$where .= $user_prefix."_encombrants.`date_enlevement`='".utilFuncs_lozzu::conditionnertodb($dateencours)."'";
				$where .= ($where == "") ? " WHERE " : " AND ";
				$where .= $user_prefix."_encombrants.`commune_enlevement`='".utilFuncs_lozzu::conditionnertodb($commune)."'";
				
				$sql = 'SELECT `Id`, `date_enlevement`,`lieu_enlevement`,`commune_enlevement`, `nom`,`prenom`, `adresse`, `tel`, `portable`,`email`,`liste_encombrants`,`valide` ';
				$sql .= ' FROM '.$user_prefix.'_encombrants';
				$sql .= $where;
				$sql .= ' ORDER BY `'.$user_prefix.'_encombrants`.`date_enlevement` DESC';
				$sql .= ' '.$limit.';';

				$compteur = 0;
				$limiteparjour = 5;
				
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$stlplusplus = '';
					if ($db->sql_numrows($result) > $limiteparjour) {
						$stlplusplus = 'oversize';
					}
					$liste = '<table  border="0" cellpadding="0" cellspacing="0">';
					while ($ligne = $db->sql_fetchrow($result)) {
						$stlplus = "";
						$ongletedit = "enlevementno";
						if ($ligne["valide"] == "1") {
							$compteur++;
							$stlplus .= ($stlplus != "") ? " " :"";
							$stlplus .= 'valide';
							$ongletedit = "enlevement";
						}
						/*if ($compteur > $limiteparjour) {
							$stlplus .= ($stlplus != "") ? " " :"";  
							$stlplus .= 'oversize';
						}*/
						if ($stlplusplus != "") {
							$stlplus .= ($stlplus != "") ? " " :"";  
							$stlplus .= $stlplusplus;
						}
						if ($stlplus != "") {
							$stlplus = 'class="'.$stlplus.'"';
						}
						$liste .= '<tr>
								<td '.$stlplus.'><a href="system.php?op=lozzu&action=edit_enlevement&onglet='.$ongletedit.'&Id='.$ligne["Id"].'&fromsynthese=1">'.$ligne["prenom"].(($ligne["prenom"].$ligne["nom"] != '') ? " " : "").$ligne["nom"].' :<br />'.nl2br($ligne["liste_encombrants"]).'</a></td>	
		    				</tr>';
					}
					$liste .= '</table>';
				}
				
				
				$stlplus2 = '';
				if ($liste == "" && $planning_semaine[$valeur."*".$commune] == "1") {
					$stlplus2 = ' jourvide';
				}
				$ajoutdemande = '';
				$ajoutevt = '';
				if ($planning_semaine[$valeur."*".$commune] == "1") {
					$url_case = http_build_query(array('enlevement' => array ("Id"=>-1,"date_enlevement"=>utilFuncs_lozzu::date2JMA($dateencours,"d/m/Y"), "commune_enlevement"=>$commune)));
					
					$ajoutdemande = '<div style="display: none;text-align: center;" id="'.$dateencours.'*'.$commune.'"><a href="'.'system.php?op=lozzu&action=edit_enlevement&onglet='.$ongletedit.'&'.$url_case.'&fromsynthese=1">ajouter une demande</a></div>';
					$ajoutevt = ' onmouseover="survol_jour(\''.$dateencours.'*'.str_replace("'", "\\'", $commune).'\')" onmouseout="fin_survol_jour(\''.$dateencours.'*'.str_replace("'", "\\'", $commune).'\')"';
				}
				
				$sortie .= '<td class="'.$stlplus2.'"'.$ajoutevt.'>';
				$sortie .= $liste;
				$sortie .= $ajoutdemande;
				$sortie .= '</td>';
			}
			$sortie .= '</tr>';
		}
		$sortie .= '</table>';
		
		$sortie .= '<p style="text-align:center"><b><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date-3600*24*6).'">&lt;&lt; Semaine prcdente</a><span style="display:inline-block;width:80px"></span><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date+3600*24*8).'">Semaine suivante &gt;&gt;</a></b></p>';
		
		//$sortie .= '<p>&nbsp</p>';
		
		$sortie .= '<table cellpadding="0" cellspaccing="0" border="0" class="synthese">';
		$sortie .= '<tr>';
		$sortie .= '<td><table  border="0" cellpadding="0" cellspacing="0"><tr><td class="valide" style="width: 80px;">valide</td></tr></table></td>';
		$sortie .= '<td><table  border="0" cellpadding="0" cellspacing="0"><tr><td class="oversize" style="width: 80px;">au-del de 5</td></tr></table></td>';
		$sortie .= '<td><table  border="0" cellpadding="0" cellspacing="0"><tr><td style="width: 80px;">non confirm</td></tr></table></td>';
		$sortie .= '<td style="width: 100px;text-align: center" class="jourvide">aucune demande</td>';
		$sortie .= '</tr>';
		$sortie .= '</table>';
		
		$sortie .= '</center>';
		return $sortie;
	}
	
	function jour_enlevement($date, $withpreview = true) {
		global $Default_Theme, $user_prefix, $db, $op, $action, $onglet,$module_name;
		global $select;
		
		require("modules/$module_name/system/params.php");		
		//$jours = array("lundi"=>"1", "mardi"=>"2", "mercredi"=>"3", "jeudi"=>"4", "vendredi"=>"5");
		//$communes = array("Calvi","Montegrosso","Zilia","Algajola","Calenzana","Lumio","Moncale","Galeria","Manso","Aregno","Avapessa","Calenzana","Cateri","Lavatoggio","Sant Antonino");
		//$communes = array_unique($communes);
		//sort($communes);
		
		if ($date == "") {
			die("Page appele incorrectement !");
		}
		
		$limit = "";
		
		$sortie = '<p style="text-align:center"><br /><b>Planning du '.array_search(date("w",($date)),$jours).' '.date("d/m/Y",($date)).'</b></p>';
		if ($withpreview) {
			if (date("w",($date)) > 1) {
				$sortie .= '<p style="text-align:center">&nbsp;<br /><b><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date-3600*24*1).'">&lt;&lt; jour prcdent</a>';
			}
			else {
				$sortie .= '<p style="text-align:center">&nbsp;<br /><b><span style="display: inline-block; width: 80px"></span>';
			}
			$sortie .= '<span style="display: inline-block; width: 100px"></span>'.'<a href= "system.php?action=semaine_enlevement&op='.$op.'&onglet='.$onglet.'&date='.$date.'">retour  la synthse de la semaine</a>'.'<span style="display: inline-block; width: 100px"></span>';
			if (date("w",($date)) < 5) {
				$sortie .= '<a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date+3600*24*1).'">Jour suivant &gt;&gt;</a></b></p>';
			}
			else {
				$sortie .= '<span style="display: inline-block; width: 80px"></span></b></p>';
			}
		}
		$sortie .= '<center>';
		$nomcolonne = true;
		foreach ($communes as $commune) {
			$dateencours = date("Y-m-d",($date));
			$liste = "";
			
			$where = '';
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`valide`='1'";
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`date_enlevement`='".utilFuncs_lozzu::conditionnertodb($dateencours)."'";
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`commune_enlevement`='".utilFuncs_lozzu::conditionnertodb($commune)."'";
			
			$sql = 'SELECT `Id`, `date_enlevement`,`lieu_enlevement`,`commune_enlevement`, `nom`,`prenom`, `adresse`, `tel`, `portable`,`email`,`liste_encombrants`,`valide` ';
			$sql .= ' FROM '.$user_prefix.'_encombrants';
			$sql .= $where;
			$sql .= ' ORDER BY `'.$user_prefix.'_encombrants`.`date_enlevement` DESC';
			$sql .= ' '.$limit.';';
			
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				if ($nomcolonne) {
					$sortie .= '<table cellpadding="0" cellspaccing="0" border="0" class="planning">';
					$sortie .= '<tr><td align="center"><b>Prnom et Nom</b></td><td align="center"><b>Adresse enlvement</b></td><td align="center"><b>Encombrants</b></td><td align="center"><b>Tlephone</b></td></tr>';
					$nomcolonne = false;
				}
				$sortie .= '<tr><td colspan="4" class="commune">'.strtoupper($commune).'</td></tr>';
				while ($ligne = $db->sql_fetchrow($result)) {
					$sortie .= '<tr>';
					$sortie .= '<td>'.$ligne["prenom"].(($ligne["prenom"].$ligne["nom"] != '') ? " " : "").$ligne["nom"].'</td>';
					$sortie .= '<td>'.nl2br($ligne["lieu_enlevement"]).'</td>';
					$sortie .= '<td>'.nl2br($ligne["liste_encombrants"]).'</td>';
					$sortie .= '<td>'.$ligne["tel"].(($ligne["tel"] != '' && $ligne["portable"] != '') ? " - " : "").$ligne["portable"].'</td>';
					$sortie .= '</tr>';
				}
			}
		}
		if (!$nomcolonne) {
			$sortie .= '</table>';
		}
		else {
			$sortie .= 'Aucun enlvement prvu pour ce jour.<br />&nbsp;';
		}
		
		if ($withpreview) {
			if (date("w",($date)) > 1) {
				$sortie .= '<p style="text-align:center"><b><a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date-3600*24*1).'">&lt;&lt; jour prcdent</a>';
			}
			else {
				$sortie .= '<p style="text-align:center"><b><span style="display: inline-block; width: 80px"></span>';
			}
			$sortie .= '<span style="display: inline-block; width: 100px"></span>'.'<a href= "system.php?action=semaine_enlevement&op='.$op.'&onglet='.$onglet.'&date='.$date.'">retour  la synthse de la semaine</a>'.'<span style="display: inline-block; width: 100px"></span>';
			if (date("w",($date)) < 5) {
				$sortie .= '<a href="system.php?action='.$action.'&op='.$op.'&onglet='.$onglet.'&date='.($date+3600*24*1).'">Jour suivant &gt;&gt;</a></b></p>';
			}
			else {
				$sortie .= '<span style="display: inline-block; width: 80px"></span></b></p>';
			}
		}
		
		if ($withpreview) {
			$sortie .='<br />&nbsp <br /><a href="system.php?action=preview_jour_enlevement&op='.$op.'&date='.$date.'" target="_blank"><b>Preview pour l\'impression</b></a>';
			$sortie .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			$sortie .='<a href="system.php?action=export_planning_jour&op='.$op.'&date='.$date.'"><b>Exporter le planning au format Excel</b></a>';
		}
		
		$sortie .= '</center>';
		return $sortie;
	}
	
	function preview_jour_enlevement($date) {	
		global $module_name;
		$sortie = '
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>Planning</title>
		<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
		<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
		<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>
		<style>
			.planning td {
				page-break-inside: avoid;
			}
			.planning {
				width: 100%;
			}
			p {
				font-size: 16px;
			}
		</style>
	</head>

	<body style="background-color: #FFFFFF">
	<table border="0" cellpadding="0" cellspacing="0" align="center" class="print"><tr><td>
	';
		
	$sortie .= jour_enlevement($date,false);

	$sortie .= '
	</td></tr>
	<tr><td><table cellpadding="0" cellespacing="0" border="0" style="width: 100%"><tr><td style="font-size: 9px">Communaut de communes Calvi Balagne</td><td style="text-align: right; padding-top: 5px;font-size: 9px">Imprim le '.date("d/m/Y").' - &copy; arobase.fr</td></tr></table></td></tr>
	</table>
	</body>
</html>';
		return $sortie; 	
	}
	
	function export_planning_jour($date="") {
		global $Default_Theme, $user_prefix, $db, $op, $action, $onglet,$module_name;
		global $select;
		
		if ($date == "") {
			die("Page appele incorrectement !");
		}
	
		set_time_limit(20);
		require_once "php_writeexcel/class.writeexcel_workbook.inc.php";
		require_once "php_writeexcel/class.writeexcel_worksheet.inc.php";
		$fname = tempnam("/tmp", "Planning.xls");
		$workbook = new writeexcel_workbook($fname);
		$worksheet =& $workbook->addworksheet('Planning');
		$worksheet->set_column('A:D', 30);
		$worksheet->set_row(0, 40);
		$couleurentete = $workbook->set_custom_color(40,200,200,200);
		$entete  =& $workbook->addformat(array(
		font		=> 'Arial',
		bg_color	=> $couleurentete,
		bold    => 1,
		color   => 'black',
		size    => 12,
		merge   => 4,
		bold    => 1
		));
		$titre  =& $workbook->addformat(array(
		font		=> 'Arial',
		bold    => 1,
		color   => 'black',
		size    => 12,
		merge   => 4,
		bold    => 1,
		valign => 'vcenter'
		));
		$donnee  =& $workbook->addformat(array(
		font		=> 'Arial',
		bold    => 0,
		color   => 'black',
		size    => 10,
		merge   => 1,
		text_h_align => 0,
		num_format => '@',
		text_wrap => 1,
		valign => 'top'
		));
		$sstitre  =& $workbook->addformat(array(
		font		=> 'Arial',
		bold    => 0,
		color   => 'black',
		size    => 10,
		merge   => 1,
		num_format => '@',
		text_wrap => 1,
		align => 'center'
		));
		
		require("modules/$module_name/system/params.php");
		//$jours = array("lundi"=>"1", "mardi"=>"2", "mercredi"=>"3", "jeudi"=>"4", "vendredi"=>"5");
		//$communes = array("Calvi","Montegrosso","Zilia","Algajola","Calenzana","Lumio","Moncale","Galeria","Manso","Aregno","Avapessa","Calenzana","Cateri","Lavatoggio","Sant Antonino");
		//$communes = array_unique($communes);
		//sort($communes);
		
		$texte = array('Planning du '.array_search(date("w",($date)),$jours).' '.date("d/m/Y",($date)),"","","");
		$worksheet->write_row('A1', $texte, $titre);
		
		$texte = array("Prnom et Nom","Adresse enlvement","Encombrants","Tlephone");
		$worksheet->write_row('A2', $texte, $sstitre);
  		
		$compteur = 2;
		
		foreach ($communes as $commune) {
			$dateencours = date("Y-m-d",($date));
			$liste = "";
			
			$where = '';
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`valide`='1'";
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`date_enlevement`='".utilFuncs_lozzu::conditionnertodb($dateencours)."'";
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= $user_prefix."_encombrants.`commune_enlevement`='".utilFuncs_lozzu::conditionnertodb($commune)."'";
			
			$sql = 'SELECT `Id`, `date_enlevement`,`lieu_enlevement`,`commune_enlevement`, `nom`,`prenom`, `adresse`, `tel`, `portable`,`email`,`liste_encombrants`,`valide` ';
			$sql .= ' FROM '.$user_prefix.'_encombrants';
			$sql .= $where;
			$sql .= ' ORDER BY `'.$user_prefix.'_encombrants`.`date_enlevement` DESC';
			$sql .= ' '.$limit.';';
			
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$compteur++;
				$texte = strtoupper($commune);
				$worksheet->write_row('A'.$compteur, array($texte,"","",""), $entete);
				
				while ($ligne = $db->sql_fetchrow($result)) {
					$texte = array(
						$ligne["prenom"].(($ligne["prenom"].$ligne["nom"] != '') ? " " : "").$ligne["nom"],
						str_replace("\r","", $ligne["lieu_enlevement"]),
						str_replace("\r","",$ligne["liste_encombrants"]),
						$ligne["tel"].(($ligne["tel"] != '' && $ligne["portable"] != '') ? " - " : "").$ligne["portable"]
					);
					$compteur++;
					$worksheet->write_row('A'.$compteur, $texte, $donnee);
				}
			}
		}
		$workbook->close();
		
		header("Content-Type: application/x-msexcel; name=\"planning_enlevements.xls\"");
		header('Content-Disposition: inline; filename="Planning_'.$dateencours.'.xls"');
		$fh=fopen($fname, "rb");
		fpassthru($fh);
		unlink($fname);
	}
	
	
	function process_lozzu(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $onglet,$module_name,$action, $Id, $header_system;
		global $select, $ok;
		global $planning,$enlevement,$withmail;
		global $date, $commune, $message, $date, $fromsynthese;
		
		if (!isset($onglet) || $onglet == "") {
			$onglet = "semaine";
		}
		if (!isset($action) || $action == "") {
			$action = "semaine_enlevement";
		}
		if (!isset($withmail)) {
			$withmail = "0";
		}
		if (!isset($message)) {
			$message = "";
		}
		if (!isset($fromsynthese)) {
			$fromsynthese = "";
		}
		if (!isset($enlevement)) {
			$enlevement = array();
		}

		$sortie = "";
		$operationOnglet = "";
	
		switch ($action) {
			default:
			case "list_enlevement":
				$sortie = list_enlevement();
				$operationOnglet = _LOZZUECRANENLEVEMENT;
				break;	
			case "list_enlevementno":
				$sortie = list_enlevement(0);
				$operationOnglet = _LOZZUECRANENLEVEMENT;
				break;
			case "new_enlevement":
				$Id = "-1";
			case "edit_enlevement":
				$sortie = edit_enlevement($Id, $enlevement);
				$operationOnglet = _LOZZUECRANENLEVEMENT;
				break;
			case "save_enlevement":
				$sortie = "";
				if (save_enlevement($enlevement,$withmail)) {
					/*$sortie = '<div align="center">&nbsp;<br /><b>'._FIRESAVED.'</b><br />&nbsp;</div>';
					$sortie .= list_fire();*/
					if ($fromsynthese == "1") {
						list($jour,$mois,$an) = explode("/",$enlevement["date_enlevement"]);
						$moment = mktime(0,0,0,$mois,$jour,$an);
						header("Location: system.php?action=semaine_enlevement&op=lozzu&onglet=semaine&date=".$moment."");
						die();
					}
					else {
						$paramsplus = '';
						if (is_array($select)) {
							$select = array_map("stripslashes", $select);
							foreach($select as $key => $value) {
								if ($value != "") {
									$paramsplus .= '&select['.$key.']='.urlencode($value);
								}
							}
						}
						if ($onglet == "enlevement") {
							$action = "list_enlevement";
						}
						else {
							$action = "list_enlevementno";
						}
						header("Location: system.php?op=lozzu&action=".$action."&onglet=".$onglet.$paramsplus);
						die();
					}
				}
				else {
					$sortie = '<div align="center">&nbsp;<br /><b>Fiche non enregistre</b><br />&nbsp;</div>';
					$sortie .= edit_enlevement("",$enlevement);
				}
				$operationOnglet = _LOZZUECRANENLEVEMENT;
				break;
			case "delete_enlevement":
				$sortie = delete_enlevement($Id, $ok);
				$operationOnglet = _LOZZUECRANENLEVEMENT;
				break;
					
			case "planning":
				$sortie = planning($message);
				$operationOnglet = _LOZZUECRANPLANNING;
				break;		
			case "save_planning":
				if (save_planning($planning)) {
					header("Location: system.php?op=lozzu&action=planning&onglet=".$onglet."&message=1");
					die();
				}
				else {
					die("Problme enregistrement planning !");
				}
				break;
				
			case "valid_enlevement_planning":
				echo utf8_encode(valid_enlevement_planning($date, $commune));
				die();
				break;	
				
			case "semaine_enlevement":
				$sortie = semaine_enlevement($date);
				$operationOnglet = _LOZZUECRANSEMAINE;
				break;
			case "jour_enlevement":
				$sortie = jour_enlevement($date);
				$operationOnglet = _LOZZUECRANSEMAINE;
				break;
			case "preview_jour_enlevement":
				header('Content-Type: text/html; charset=ISO-8859-1');
				echo preview_jour_enlevement($date);
				die();
				break;
			case "export_planning_jour":
				export_planning_jour($date);
				die();
				break;	
		}

		$ongletDef=array("semaine"=> array( "text"=>_LOZZUONGLETSEMAINE, "url"=>"system.php?action=semaine_enlevement&op=lozzu&onglet=semaine"),
						"enlevement"=> array( "text"=>_LOZZUONGLETENLEVEMENT, "url"=>"system.php?action=list_enlevemens&op=lozzu&onglet=enlevement"),
						"enlevementno"=> array( "text"=>_LOZZUONGLETENLEVEMENTNO, "url"=>"system.php?action=list_enlevementno&op=lozzu&onglet=enlevementno"),
						/*,
						"lozzuadmin"=> array( "text"=>_LOZZUONGLETADMIN, "url"=>"system.php?action=admin&op=lozzu&onglet=lozzuadmin")*/);
		global $admin;
		if (is_super($admin)) {
			$ongletDef["planning"] = array( "text"=>_LOZZUONGLETPLANNING, "url"=>"system.php?action=planning&op=lozzu&onglet=planning");
		}
		$header_system .= '<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>';
		
		include("system/header_system.php");				
		GraphicAdmin(_LOZZUBD);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		echo $actionssuppl;
		CloseOngletTable();
		include("system/footer_system.php");
	}

	switch ($op) {
		case "lozzu":
			process_lozzu();
			break;
	}	
}
else {
	display_denied();
}
?>