<?php
/**
 * Interface d'administration du module de gestion des petites annonces.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleJobs
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._JOBSFOUND;
			$indexPages .= _JOBSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _JOBSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function edit_wanted($Id, $page="",$search_words="", $onglet) {
		global $module_name;
		
		$obj_cat = new BD_Jobs();
		$wanteds = $obj_cat->getWanted("files",$Id);
		$wanted = $wanteds[0];
		
		require_once("modules/SimpleMembers/lib_db.php");
		$obj_dom = new BD_Members();
		$domaines = $obj_dom->getDoms("","",$wanted["domaine"]);
		$domaine = $domaines[0]["label"];
		
		$sortie .= '<form name="editwanted" action="system.php?op=jobswanted&action=save_wanted&onglet='.$onglet.'" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDDOMAIN;
		$sortie .= '</td><td>';
		$sortie .= '<input type="hidden" value="'.$wanted["domaine"].'" name="domaine" />';
		$sortie .= '<input type="text" name="domainestr" value="'.$domaine.'" class="saisie" readonly="readonly">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDDESC;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="candidature" cols="50" rows="10" class="saisie">'.$wanted["candidature"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDCV;
		$sortie .= '</td><td>';
		if ($wanted["cv"] != "") {
			$chemin="catalog_repository/simple_jobs";
			$lien = $chemin."/".$wanted["cv"];
			$sortie .= "<a href=\"$lien\" target=\"_blank\">"._WANTEDCVUPLOADED."</a>";
		}		
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDMAIL;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="email" value="'.$wanted["email"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDDATE;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="date_inscription" value="'.utilFuncs_simpleJob::date2JMA($wanted["date_inscription"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _WANTEDVALID;
		$sortie .= '</td><td>';
		$check1 = ($wanted["valide"] == "0") ? " checked=\"checked\" " : "";
		$check2 = ($wanted["valide"] == "1") ? " checked=\"checked\" " : "";
		$sortie .= '<input type="radio" name="valide" value="1" id="radiovalid1"'.$check2.'><label for="radiovalid1">'._JOBSYES.'</label>';
		$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;";
		$sortie .= '<input type="radio" name="valide" value="0" id="radiovalid2"'.$check1.'><label for="radiovalid2">'._JOBSNO.'</label>';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._WANTEDSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$wanted["Id"].'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$wanted["clef"].'" name="clef">';
		$sortie .= '<input type="hidden" value="'.$wanted["cv"].'" name="cv">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie .= "</form>";
		
		return $sortie;
	}
	
	function save_wanted($Id, $domaine, $candidature, $cv, $date_inscription, $email, $clef, $valide) {
		global $prefix,$db,$nukeurl,$module_name;
		$date_inscription = utilFuncs_simpleJob::date2AMJ($date_inscription);
		$wanted = array(
			"Id"=>$Id,
			"domaine"=>$domaine,
			"candidature"=>$candidature,
			"cv"=>$cv,
			"date_inscription"=>$date_inscription,
			"email"=>$email,
			"clef"=>$clef,
			"valide"=>$valide
		);
		$obj_jobs = new BD_Jobs();
		if (!$obj_jobs->saveWanted($wanted)) {
			die("DB problem");
		}
		require_once("modules/SimpleMembers/lib_db.php");
		$obj_dom = new BD_Members();
		$domaines_mail = $obj_dom->getDoms("","",$wanted["domaine"]);
		$domaineMail = $domaines_mail[0]["label"];
		if ($valide == "1") {
			//expdie e-mail aux membres du domaine choisi
			$members = array();
			if ($domaine != "") {
				$resultatRecherche = $db->sql_query ("select distinct email from ".$prefix."_annuairecompetences_contact inner join ".$prefix."_annuairecompetences_struct on ".$prefix."_annuairecompetences_contact.struct_id=".$prefix."_annuairecompetences_struct.Id inner join ".$prefix."_annuairecompetences_link on becms_annuairecompetences_link.id_struct=becms_annuairecompetences_struct.Id where (id_domain-".$domaine."<100 and id_domain-".$domaine.">0) OR ".$prefix."_annuairecompetences_struct.metier=".$domaine.";");
				if ($db->sql_numrows($resultatRecherche) != 0) {
					while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
						array_push($members, $ligneCourante);
					}
				}
			}
			$cci = "";
			foreach($members as $member) {
				if ($member["email"] != "") {
					$cci .= ($cci != "") ? "; ":"";
					$cci .= $member["email"];
				}
			}
			$subject = _WANTEDMAILSUBNEWWANTED;
			$tab_serveur = parse_url($nukeurl);
			$racine = $tab_serveur["scheme"]."://";
			if ($tab_serveur["user"] != "") {
				$racine .= $tab_serveur["user"];
			}
			if ($tab_serveur["pass"] != "") {
				$racine .= ":".$tab_serveur["pass"];
			}
			if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
				$racine .= "@";
			}
			$racine .= $tab_serveur["host"];
			if ($tab_serveur["port"] != "") {
				$racine .= ":".$tab_serveur["port"];
			}
			$lien = $racine."/modules.php?name=".$module_name."&sop=list_wanted&domaine=".$domaine;
			$message = str_replace("<!--lien-->", $lien, _WANTEDMAILBODYNEWWANTED);
			$message = str_replace("<!--domaine-->", $domaineMail, $message);
			//echo $message;
			utilFuncs_simpleJob::send_email("info@fedeticc.com",$email,$subject,$message,$cci);
			//expdie un mail au candidat
			$subject = _WANTEDMAILSUBNEWWANTEDCANDIDAT;
			$message = str_replace("<!--lien-->", $lien, _WANTEDMAILBODYNEWWANTEDCANDIDAT);
			utilFuncs_simpleJob::send_email($email,"info@fedeticc.com",$subject,$message,"");
		}
		return true;
	}
	
	function delete_wanted($Id,$page,$search_words,$domaine,$onglet,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Jobs();
				if($obj_ads->delWanted($Id)) {
					$sortie = list_wanted($page,$search_words,$domaine,($onglet=="wanted"));
					$operationOnglet = _JOBSLIST;
					return (array($sortie,$operationOnglet));
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._WANTEDCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=jobswanted&action=delete_wanted&onglet='.$onglet.'&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._JOBSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._JOBSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				$operationOnglet = _JOBSLIST;
				return (array($sortie,$operationOnglet));
			}
		}
		return list_jobs($page,$search_words,$cat);
	}
	
	function list_jobs($page,$search_words="",$cat="") {
		$obj_cat = new BD_Jobs();
		$nbrefiches = $obj_cat->getJobs("count","",$cat,$search_words,"","");
		$ligne_par_page = 10;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		$liste .= '<form name="search_form" action="system.php?op=jobs&action=search_jobs&onglet=jobs" method="POST">';
		$liste .= _JOBSWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._JOBSSEARCHBTN.'">';
		$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getJobs("files","",$cat,$search_words,"",$limit);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._JOBSLISTCAT.'</th>
					<th class="systemTabHeader">'._JOBSLISTTITLE.'</th>
					<th class="systemTabHeader">'._JOBSLISTCONTENT.'</th>
					<th class="systemTabHeader">'._JOBSLISTPROFIL.'</th>
					<th class="systemTabHeader">'._JOBSLISTDATELIM.'</th>
	    				<th class="systemTabHeader">'._JOBSACTION.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=jobs&action=edit_jobs&onglet=jobs&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=jobs&action=delete_jobs&onglet=jobs&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$resultCats = $obj_cat->getCats($result["categorie"]);
			$liste .= utilFuncs_simpleJob::conditionnerHTML($resultCats[0]["categorie"]);
			$liste .= '</td><td>';
			$longlim = 80;
			if (strlen($result["intitule"]) > $longlim) {
				$i = $longlim;
				while (substr($result["intitule"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["intitule"],0,$i)."...";
			}
			else {
				$liste .= $result["intitule"];
			}
			$liste .= '</td><td>';
			$longlim = 150;
			if (strlen($result["description"]) > $longlim) {
				$i = $longlim;
				while (substr($result["description"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["description"],0,$i)."...";
			}
			else {
				$liste .= $result["description"];
			}
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_simpleJob::conditionnerHTML($result["profil"]);
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_simpleJob::date2JMA($result["date_limite"]);
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=jobs&action=add_jobs&onglet=jobs">'._JOBSADDJOB.'</a></div>';
		return $liste;
	}
	
	function edit_jobs($Id, $page,$search_words="") {
		$obj_cat = new BD_Jobs();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getJobs("files",$Id,"","","","");
			$result = $results[0];
			$Id = $result["Id"];
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$select = "";
				if ($result["categorie"] == $cat["Id"]) {
					$select = ' selected="selected"';
				}
				$menu_cat .= '<option value="'.$cat["Id"].'"'.$select.'>'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
		}
		else {
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$menu_cat .= '<option value="'.$cat["Id"].'">'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
			$durees = array(7,30,90,180,365);
			list($year,$month,$day) = explode("-",date("Y-m-d"));
			$menuduree = '<select name="date_limite" size="1" class="saisie">';
			foreach($durees as $duree) {
				$duree2 = date("d/m/Y",mktime(0,0,0,$month,($day+$duree),$year));
				$menuduree .= '<option value="'.$duree2.'">'.$duree._JOBSDAYS.'</option>';
			}
			$menuduree .= '</select>';
			$datelimite = "";
		}
		
		$sortie = '<form name="editjobs" action="system.php?op=jobs&action=save_jobs&onglet=jobs" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSCATEDIT;
		$sortie .= '</td><td>';
		$sortie .= $menu_cat;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSTITLEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="intitule" value="'.$result["intitule"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSDESCRIPTIONEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="description" cols="50" rows="10" class="saisie">'.$result["description"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSPROFILEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="profil" value="'.$result["profil"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSCONDSEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="contrat" value="'.$result["contrat"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		if ($result["date_limite"] == "0000-00-00" || $result["date_limite"] == "") {
			$sortie .= '<tr><td>';
			$sortie .= _JOBSDUREEEDIT;
			$sortie .= '</td><td>';
			$sortie .= $menuduree;
			$sortie .= '</td></tr>';
		}
		else {
			$sortie .= '<tr><td>';
			$sortie .= _JOBSDUREE2EDIT;
			$sortie .= '</td><td>';
			$sortie .= '<input type="text" name="date_limite" value="'.utilFuncs_simpleJob::date2JMA($result["date_limite"]).'" class="saisie">';
			$sortie .= '</td></tr>';
		}
		
	// complter !
		$sortie .= '<tr><td>';
		$sortie .= _JOBSMEMBER;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="membre" value="'.$result["membre"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _JOBSMAILEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="email" value="'.$result["email"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._JOBSAVEBTN.'" name="validbtn">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_jobs($Id, $categorie, $intitule, $description, $profil, $contrat, $date_limite, $membre, $email, $page,$search_words="") {
		if ($Id=="-1" || $Id == "") {
			$Id = "-1";
		}
		$date_limite = utilFuncs_simpleJob::date2AMJ($date_limite);
		$job = array(
			"Id"=>$Id,
			"categorie"=>$categorie,
			"intitule"=>$intitule,
			"description"=>$description,
			"profil"=>$profil,
			"contrat"=>$contrat,
			"date_limite"=>$date_limite,
			"membre"=>$membre,
			"email"=>$email
		);
		$obj_jobs = new BD_Jobs();
		if (!$obj_jobs->saveJobs($job)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_jobs($Id,$page,$search_words,$cat,$onglet,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Jobs();
				if($obj_ads->delJobs($Id)) {
					$sortie = list_jobs($page,$search_words,$cat);
					$operationOnglet = _JOBSLIST;
					return (array($sortie,$operationOnglet));
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._JOBSCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=jobs&action=delete_jobs&onglet=jobs&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._JOBSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._JOBSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				$operationOnglet = _JOBSLIST;
				return (array($sortie,$operationOnglet));
			}
		}
		return list_jobs($page,$search_words,$cat);
	}

	function list_categories() {
		$obj_cat = new BD_Jobs();
		$results = $obj_cat->getCats();
		$liste = '<table  class="lisTable">
			<tr class="systemTabHeader">
				<th class="systemTabHeader" style="text-align: left">'._JOBSLISTCAT.'</th>
    			<th class="systemTabHeader">'._JOBSACTION.'</th>
	    		</tr>';
		foreach($results as $result) {
			list($Id, $categorie,$image) = $result;
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=jobs&action=edit_cat&onglet=cats&Id=".$Id,"comment"=>_EDIT, "status"=>"ON"),
  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=jobs&action=delete_cat&onglet=cats&Id=".$Id,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$liste .= '<a href="system.php?op=jobs&action=list_jobs&onglet=jobs&cat='.$Id.'">';
			$liste .= utilFuncs_simpleJob::conditionnerHTML($categorie);
			$liste .= '</a>';
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=jobs&action=add_cat&onglet=cats">'._JOBSADDCAT.'</a></div>';
		return $liste;
	}

	function edit_categorie($Id) {
		$categorie = "";
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$obj_cat = new BD_Jobs();
			$results = $obj_cat->getCats($Id);
			list($Id, $categorie,$image) = $results[0];
		}
		$sortie = '<form name="editcat" action="system.php?op=jobs&action=save_cat&onglet=cats" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		$sortie .= '<tr><td>';
		$sortie .= _JOBSCATNAME;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="categorie" value="'.$categorie.'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _JOBSCATIMAGE;
		$sortie .= '</td><td>';
		$sortie .= '<SCRIPT language="JavaScript" src="javascripts/images.js"></SCRIPT>';
		//$sortie .= '<input type="text" name="image" value="'.$image.'">';
		$sortie .= '<select name="image" onChange="displayImg(\'myicon\',\'images/topics/\'+this.options[selectedIndex].value)" class="saisie">';
		$path1 = explode ("/", "images/topics/");
		$path = "$path1[0]/$path1[1]";
		$handle=opendir($path);
		$tlist2 = "";
		while ($file = readdir($handle)) {
			if(substr($file,0,1) != "!" && substr($file,0,1) != "_" && substr($file,0,1) != "." && !is_file($path . '/' . $file) && !is_link($path . '/' . $file)) {
				$path2 = $path."/".$file;
				$handle2=opendir($path2);
				while ($file2 = readdir($handle2)) {
					if(substr($file2,0,1) != "!" && substr($file2,0,1) != "_" && substr($file2,0,1) != "." && is_file($path2 . '/' . $file2)) {
						if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file2)) ) {
							$tlist2 .= $file."/$file2 ";
						}
					}
				}
				closedir($handle2);
			}
			if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file)) ) {
				$tlist .= "$file ";
			}
		}
		closedir($handle);
		$tlist = explode(" ", $tlist);
		sort($tlist);
		$tlist2 = explode(" ", $tlist2);
		sort($tlist2);
		$tlist = array_merge($tlist,$tlist2);
		for ($i=0; $i < sizeof($tlist); $i++) {
			if($tlist[$i]!="") {
				if ($image == $tlist[$i]) {
					$sel = ' selected="selected"';
				} else {
					$sel = '';
				}
				$sortie .= '<option value="'.$tlist[$i].'"'.$sel.'>'.$tlist[$i].'</option>';
			}
		}
		$sortie .= '</select>';
		if ($image == "") {
			$image = $tlist[1];
		}
		$sortie .= '&nbsp;<img src="images/topics/'.$image.'" name="myicon" align="middle">&nbsp;';
		$sortie .= '<a href="images/topics/ads_icons.php" onclick="window.open(\'images/topics/ads_icons.php\',\'catalogue\',\'menubar=no, status=no, scrollbars=yes, menubar=no, width=500, height=400\');return false" target="_blank">Voir catalogue</a>';
		$sortie .= '</td></tr>';
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ADSJOBSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		//$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		//$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}

	function save_categorie($Id,$categorie,$image) {
		$cat = array("Id"=>$Id,"categorie"=>$categorie,"image"=>$image);
		$obj_cat = new BD_Jobs();
		if (!$obj_cat->saveCat($cat)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_categorie($Id,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Jobs();
				if($obj_ads->delCat($Id)) {
					return list_categories();
				}
				else {
					die("DB problem");
				}
			}
			else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._JOBSCONFIRMDELETECAT."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=jobs&action=delete_cat&onglet=cats&Id='.$Id.'&confirm=y">';
				$sortie .= "["._JOBSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._JOBSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
		return list_categories();
	}
	
	function list_wanted($page,$search_words="",$domaine="", $valide=true) {
		require_once("modules/SimpleMembers/lib_db.php");
		$obj_dom = new BD_Members();
		
		$obj_cat = new BD_Jobs();
		$nbrefiches = $obj_cat->getWanted("count","","","",$valide);
		$ligne_par_page = 10;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		//$liste .= '<form name="search_form" action="system.php?op=jobs&action=search_jobs&onglet=jobs" method="POST">';
		//$liste .= _JOBSWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		//$liste .= ' <input name="validsearch" type="submit" value="'._JOBSSEARCHBTN.'">';
		//$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getWanted("files","","","",$valide,"",$limit);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._WANTEDLISTDOM.'</th>
					<th class="systemTabHeader">'._WANTEDLISTCONTENT.'</th>
					<th class="systemTabHeader">'._WANTEDLISTCV.'</th>
					<th class="systemTabHeader">'._WANTEDLISTDATE.'</th>
					<th class="systemTabHeader">'._WANTEDLISTMAIL.'</th>
	    				<th class="systemTabHeader">'._WANTEDLISTACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		if ($valide) {
			$ongletcourant = "wanted";
		}
		else {
			$ongletcourant = "wantedno";
		}
		
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=jobswanted&action=edit_wanted&onglet=".$ongletcourant."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=jobswanted&action=delete_wanted&onglet=".$ongletcourant."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			//$resultCats = $obj_cat->getCats($result["domaine"]);
			//$liste .= utilFuncs_simpleJob::conditionnerHTML($resultCats[0]["categorie"]);

			$domaines = $obj_dom->getDoms("","",$result["domaine"]);
			$domaine = $domaines[0]["label"];
			
			$liste .= utilFuncs_simpleJob::conditionnerHTML($domaine);
			$liste .= '</td><td>';
			$longlim = 80;
			if (strlen($result["candidature"]) > $longlim) {
				$i = $longlim;
				while (substr($result["candidature"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["candidature"],0,$i)."...";
			}
			else {
				$liste .= $result["candidature"];
			}
			$liste .= '</td><td align="center">';
			$chemin="catalog_repository/simple_jobs";
			$lien = $chemin."/".$result["cv"];
			$liste .= '<a href="'.$lien.'" target="_blank">[C.V.]</a>';
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_simpleJob::date2JMA($result["date_inscription"]);
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_simpleJob::conditionnerHTML($result["email"]);
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		return $liste;
	}
	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_jobs(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$image,$search_words,$cat, $confirm,$valid;
		global $Id, $categorie, $intitule, $description, $profil, $contrat, $date_limite, $membre, $email;
		global $Id, $domaine, $candidature, $cv, $date_inscription, $email, $clef, $valide;

		include("system/header_system.php");


		if (!isset($action) || $action == "") {
			$action = "list_cat";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
			case "list_cat" :
				$sortie = list_categories();
				$operationOnglet = _JOBSLISTCAT;
				break;
			case "edit_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _JOBSEDITCAT;
				break;
			case "save_cat" :
				if (save_categorie($Id,$categorie,$image)) {
					$sortie = list_categories();
				}
				$operationOnglet = _JOBSLISTCAT;
				break;
			case "add_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _JOBSNEWCAT;
				break;
			case "delete_cat" :
				$sortie = delete_categorie($Id,$confirm);
				$operationOnglet = _JOBSLISTCAT;
				break;
			case "list_jobs" :
				$sortie = list_jobs($page,$search_words,$cat);
				$operationOnglet = _JOBSLIST;
				break;
			case "edit_jobs" :
				$sortie = edit_jobs($Id,$page,$search_words);
				$operationOnglet = _JOBSEDIT;
				break;
			case "save_jobs" :
				if (save_jobs($Id, $categorie, $intitule, $description, $profil, $contrat, $date_limite, $membre, $email, $page,$search_words)) {
					$sortie = list_jobs($page,$search_words,$cat);
					$operationOnglet = _JOBSLIST;
				}
				break;
			case "add_jobs" :
				$sortie = edit_jobs("",$page,$search_words);
				$operationOnglet = _JOBSNEWADS;
				break;	
			case "search_jobs" :
				$sortie = list_jobs($page,$search_words,"");//sur la recherche par mot clef, la catgorie est neutralise
				$operationOnglet = _JOBSLISTFOUND;
				break;
			case "delete_jobs" :
				list($sortie,$operationOnglet) = delete_jobs($Id,$page,$cat,$search_words,$onglet,$confirm);
				break;
			case "list_wanted" :
				$sortie = list_wanted($page,$search_words,$domaine, true);
				$operationOnglet = _WANTEDLIST;
				break;
			case "list_wanted_no" :
				$sortie = list_wanted($page,$search_words,$domaine, false);
				$operationOnglet = _WANTEDLISTNO;
				break;
			case  "edit_wanted" :
				$sortie = edit_wanted($Id,$page,$search_words,$onglet);
				$operationOnglet = _WANTEDEDIT;
				break;
			case  "save_wanted" :
				if (save_wanted($Id, $domaine, $candidature, $cv, $date_inscription, $email, $clef, $valide)) {
					$sortie = list_wanted($page,$search_words,$domaine, ($onglet == "wanted"));
					$operationOnglet = _WANTEDLIST;
				}
				break;
			case "delete_wanted" :
				list($sortie,$operationOnglet) = delete_wanted($Id,$page,$domaine,$search_words,$onglet,$confirm);
				break;
			case "list_stats" :
				$sortie = list_stats();
				$operationOnglet = _ADSSTATS;
				break;
		}

		if (!isset($onglet)) {
			$onglet = "cats";
		}
		if ($onglet == "") {
			$onglet = "cats";
		}
		$ongletDef=array("cats"=> array( "text"=>_JOBSONGLETCATS, "url"=>"system.php?action=list_cat&op=jobs&onglet=cats"),
						"jobs"=> array( "text"=>_JOBSONGLETLIST, "url"=>"system.php?action=list_jobs&op=jobs&onglet=jobs"),
						"wanted"=> array( "text"=>_WANTEDONGLETLIST, "url"=>"system.php?action=list_wanted&op=jobswanted&onglet=wanted"),
						"wantedno"=> array( "text"=>_WANTEDNOONGLETLIST, "url"=>"system.php?action=list_wanted_no&op=jobswanted&onglet=wantedno")
						);

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_jobs.css\">";
		GraphicAdmin(_JOBSMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "jobs":
			process_jobs();
			break;
		case "jobswanted":
			process_jobs();
			break;
	}
}
else {
	display_denied();
}
?>