<?php
/**
* Classes d'accs  la base de donnes pour la gestion du Glossaire.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleBoard
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleBoard
*/
class BD_Gloss {
	var $My_SQL = array();
	
	function BD_Gloss() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["gloss"] = $prefix."_glossaire";
	}
	
/**
* Efface la fiche du commentaire dsigne
* @param integer $Id Identifiant ddu commentaire  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delTerme($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["gloss"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre un terme du glossaire
* 
* Si le terme existe dj, il est simplement modifi, sinon il est cr.
* @param array $terme Tableau contenant tous les champs du terme  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveTerme($terme) {
		$db=$this->My_SQL["maBase"];
		$terme = array_map(array('utilFuncs_SimpleGloss', 'conditionnertodb'), $terme);
		$list_champs = "";
		$list_valeurs = "";
		if ($terme["Id"] == "-1") {
			foreach($terme as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["gloss"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($terme as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["gloss"]."` SET ".$list_champs." WHERE `Id` = '".$terme["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des commentaires correspondants  la demande
* 
* Un tableau vide est renvoy si aucun commentaire n'est trouv.
* Si tous les critres sont vides,tous les commentairess sont renvoys.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant du commentaire  retrouver
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des commentaires retrouvs
*/	
	function getTerme($the_type="files", $Id="", $limit="") {
		$db=$this->My_SQL["maBase"];
		
		$glossaire = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["gloss"]."`.`Id`='".$Id."'";
		}
		if ($the_type == "files") {
		    $oderby = " ORDER BY `".$this->My_SQL["gloss"]."`.`terme` ASC";;
			
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT `Id`,`terme`,`definition`,`illustration`,`legende`, `radical` FROM `".$this->My_SQL["gloss"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($glossaire, $ligneCourante);
				}
			}
			return $glossaire;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["gloss"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
	function delPhotoTerme($Id) {
	    $db=$this->My_SQL["maBase"];
	    
	    $sql = "UPDATE `".$this->My_SQL["gloss"]."` SET illustration='' WHERE `Id` = '".$Id."';";
	    return $db->sql_query($sql);
	}
	
	function lastSaved() {
		$db=$this->My_SQL["maBase"];
		return $db->sql_nextid();
	}
}
?>