<?php
/**
 * Interface d'administration du module de gestion des petites annonces.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleBoard
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._FAQFOUND;
			$indexPages .= _FAQPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _FAQNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function list_faq($page,$search_words="",$valid=true) {
		if ($valid) {
			$ongletencours = "faq";
		}
		else {
			$ongletencours = "nofaq";
		}
		$obj_cat = new BD_FAQ();
		$nbrefiches = $obj_cat->getFaq("count","",$search_words,$valid);
		$ligne_par_page = 20;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		$liste .= '<form name="search_form" action="system.php?op=faq&action=search_faq&onglet='.$ongletencours.'" method="POST">';
		$liste .= _FAQWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._FAQSEARCHBTN.'">';
		$liste .= ' <input name="valid" type="hidden" value="'.(($valid===true)? "1" : "0").'">';
		$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getFaq("files","",$search_words,$valid,"",$limit);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._FAQLISTQUEST.'</th>
					<th class="systemTabHeader">'._FAQLISTREP.'</th>
					<th class="systemTabHeader">'._FAQLISTDATE.'</th>
	    				<th class="systemTabHeader">'._FAQACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=faq&action=edit_faq&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=faq&action=delete_faq&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$result["question"] = utilFuncs_SimpleFAQ::conditionnerHTML($result["commentaire"]);
			$longlim = 80;
			if (strlen($result["question"]) > $longlim) {
				$i = $longlim;
				while (substr($result["question"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["question"],0,$i)."...";
			}
			else {
				$liste .= $result["question"];
			}
			$liste .= '</td><td align="center">';
			$result["reponse"] = utilFuncs_SimpleFAQ::conditionnerHTML($result["reponse"]);
			$longlim = 80;
			if (strlen($result["reponse"]) > $longlim) {
				$i = $longlim;
				while (substr($result["reponse"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["reponse"],0,$i)."...";
			}
			else {
				$liste .= $result["reponse"];
			}
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_SimpleFAQ::date2JMA($result["dateajout"]);
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=faq&action=add_faq&onglet='.$ongletencours.'">'._FAQADDQUEST.'</a></div>';
		return $liste;
	}
	
	function edit_faq($Id, $page,$search_words="") {
		global $onglet;
		$obj_cat = new BD_FAQ();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getFaq("files",$Id);
			$result = $results[0];
			if ($result["visible"] == "1") {
				$checked = " checked=\"checked\"";
				$ongletcourant = "faq";
			}
			else {
				$checked = "";
				$ongletcourant = "nofaq";
			}
			$valid = '<input type="checkbox" value="1" name="visible" id="visible" '.$checked.'><label for="visible">'._FAQVALIDATEEDIT.'</label>';
			
		}
		else {
			$valid = '<input type="checkbox" value="1" name="visible" id="visible" checked="checked"><label for="visible">'._FAQVALIDATEEDIT.'</label>';
			$ongletcourant = $onglet;
			$result["dateajout"] = date("d/m/Y H:i:s");
		}
		$sortie = '<form name="editfaq" action="system.php?op=faq&action=save_faq&onglet='.$ongletcourant.'" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _FAQQUESTEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="commentaire" cols="50" rows="10" class="saisie">'.$result["commentaire"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _FAQDATEQUEST;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="dateajout" value="'.utilFuncs_SimpleFAQ::date2JMA($result["dateajout"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _FAQANSWEREDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="reponse" cols="50" rows="10" class="saisie">'.$result["reponse"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _FAQVALIDSTATEEDIT;
		$sortie .= '</td><td>';
		$sortie .= $valid;
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._FAQSAVEBTN.'" name="validbtn">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_faq ($Id, $commentaire, $dateajout, $reponse, $visible, $page,$search_words="") {
		if ($dateajout == "") {
			$dateajout = date("d/m/Y H:i:s");
		}
		$dateajout = utilFuncs_SimpleFAQ::date2AMJ($dateajout);
		$faq = array(
			"Id"=>$Id,
			"commentaire"=>$commentaire,
			"dateajout"=>$dateajout,
			"reponse"=>$reponse,
			"visible"=>$visible
		);
		$obj_comm = new BD_FAQ();
		if (!$obj_comm->saveFaq($faq)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_faq($Id,$page,$search_words,$onglet,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_FAQ();
				if($obj_ads->delFaq($Id)) {
					if ($onglet == "faq") {
						$sortie = list_faq($page,$search_words,true);;
						$operationOnglet = _FAQLIST;
					}
					else {
						$sortie = list_faq($page,$search_words,false);;
						$operationOnglet = _FAQLISTNO;
					}
					return (array($sortie,$operationOnglet));
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._FAQCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=faq&action=delete_faq&onglet='.$onglet.'&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._FAQYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._FAQNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				if ($onglet == "ads") {
					$operationOnglet = _FAQLIST;
				}
				else {
					$operationOnglet = _FAQLISTNO;
				}
				return (array($sortie,$operationOnglet));
			}
		}
		return list_faq($page,$search_words,(($onglet == "faq") ? true : false));
	}

	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_faq(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$image,$search_words,$cat, $confirm, $valid;
		global $Id, $commentaire, $dateajout, $reponse, $visible;

		include("system/header_system.php");

		if (!isset($onglet) || $onglet == "") {
			$onglet = "faq";
		}
		if (!isset($action) || $action == "") {
			$action = "list_faq";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
			case "list_faq" :
				$sortie = list_faq($page,$search_words,true);
				$operationOnglet = _FAQLIST;
				break;
			case "list_faq_no" :
				$sortie = list_faq($page,$search_words,false);
				$operationOnglet = _FAQLISTNO;
				break;
			case "edit_faq" :
				$sortie = edit_faq($Id,$page,$search_words);
				$operationOnglet = _FAQEDIT;
				break;
			case "save_faq" :
				if (save_faq($Id, $commentaire, $dateajout,$reponse, $visible, $page,$search_words)) {
					if ($onglet == "faq") {
						$sortie = list_faq($page,$search_words,true);
						$operationOnglet = _FAQLIST;
					}
					else {
						$sortie = list_faq($page,$search_words,false);
						$operationOnglet = _FAQLISTNO;
					}
				}
				break;
			case "add_faq" :
				$sortie = edit_faq("",$page,$search_words);
				$operationOnglet = _FAQNEWQUEST;
				break;	
			case "search_faq" :
				$sortie = list_faq($page,$search_words,(($valid=="1")? true : false));
				$operationOnglet = _FAQLISTFOUND;
				break;
			case "delete_faq" :
				list($sortie,$operationOnglet) = delete_faq($Id,$page,$search_words,$onglet,$confirm);
				break;
		}

		$ongletDef=array("faq"=> array( "text"=>_FAQONGLETLIST, "url"=>"system.php?action=list_faq&op=faq&onglet=faq"),
						"nofaq"=> array( "text"=>_FAQONGLETLISTNOVALID, "url"=>"system.php?action=list_faq_no&op=faq&onglet=nofaq"));

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_faq.css\">";
		GraphicAdmin(_FAQMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "faq":
			process_faq();
			break;
	}
}
else {
	display_denied();
}

?>