<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
$module_name = basename(dirname(__FILE__));
require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/utils.php");
require_once("modules/$module_name/connector_class.php");

function listchampions(){    
    
    global $prefix, $multilingual, $currentlang, $db, $Default_Theme, $module_name, $pagetitle;

    $pagetitle = "- Champions";

	$sql = 'SELECT 
    `'.$prefix.'_cursinu_chien`.`Id`, 
    `'.$prefix.'_cursinu_chien`.`lof`,
    `'.$prefix.'_cursinu_chien`.`icad`, 
    CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
    `'.$prefix.'_cursinu_chien`.`affixe`, 
    `'.$prefix.'_cursinu_chien`.`sexe`, 
    `'.$prefix.'_cursinu_chien`.`naissance`, 
    `'.$prefix.'_cursinu_chien`.`id_pere`, 
    `'.$prefix.'_cursinu_chien`.`id_mere`, 
    `'.$prefix.'_cursinu_chien`.`lignee_valide`, 
    `'.$prefix.'_cursinu_chien`.`verrou`,
    `'.$prefix.'_cursinu_chien`.`photo`,
    `'.$prefix.'_cursinu_chien`.`description`,
    `'.$prefix.'_cursinu_chien`.`producteur`';

    $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
    $sql .= ', `user_name`, `user_firstname`';
    $sql .= ' FROM '.$prefix.'_cursinu_chien';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentpere ON `'.$prefix.'_cursinu_chien`.id_pere=parentpere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentmere ON `'.$prefix.'_cursinu_chien`.id_mere=parentmere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_users` ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid';
    $sql .= ' WHERE `'.$prefix.'_cursinu_chien`.`champion` = 1';
    $sql .= ' ORDER BY nom_complet ASC';
    $sql .= ' '.$limit.';';
    
    $result = $db->sql_query($sql);

    $listchampion = array();
    if ($db->sql_numrows($result) > 0) {
        
        while ($ligne = $db->sql_fetchrow($result)) {
            array_push($listchampion, $ligne);
        }
    }
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_champion.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_champion.php');
	}
	else {
		$sortie = " implementer ";
	}

    $sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
	include ('header_mobile.php');
	echo $sortie;
	include ('footer_mobile.php');
	
}

function listemeschiens () {
	global $user, $module_name, $db, $prefix, $Default_Theme;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		
		$pagetitle = "- Champions";
		
		$sql = 'SELECT 
	    `'.$prefix.'_cursinu_chien`.`Id`, 
	    `'.$prefix.'_cursinu_chien`.`lof`,
	    `'.$prefix.'_cursinu_chien`.`icad`, 
	    CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
	    `'.$prefix.'_cursinu_chien`.`affixe`, 
	    `'.$prefix.'_cursinu_chien`.`sexe`, 
	    `'.$prefix.'_cursinu_chien`.`naissance`, 
	    `'.$prefix.'_cursinu_chien`.`id_pere`, 
	    `'.$prefix.'_cursinu_chien`.`id_mere`, 
	    `'.$prefix.'_cursinu_chien`.`lignee_valide`, 
	    `'.$prefix.'_cursinu_chien`.`verrou`,
	    `'.$prefix.'_cursinu_chien`.`photo`,
	    `'.$prefix.'_cursinu_chien`.`description`,
	    `'.$prefix.'_cursinu_chien`.`producteur`,
        `'.$prefix.'_cursinu_chien`.`cotation`';
	
		$sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
	    $sql .= ", `user_name`, `user_firstname`";
	    $sql .= " FROM ".$prefix."_cursinu_chien";
	    $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentpere ON `".$prefix."_cursinu_chien`.id_pere=parentpere.id";
	    $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentmere ON `".$prefix."_cursinu_chien`.id_mere=parentmere.id";
	    $sql .= " INNER JOIN `".$prefix."_users` ON ".$prefix."_cursinu_chien.id_proprio=".$prefix."_users.uid";
	    $sql .= " WHERE `".$prefix."_cursinu_chien`.`id_proprio` = '".$userdata[0]."'";
	    $sql .= " ORDER BY nom_complet ASC";
	    $sql .= " ".$limit.";";
    
	    $result = $db->sql_query($sql);
	
	    $listechiens = array();
	    if ($db->sql_numrows($result) > 0) {	        
	        while ($ligne = $db->sql_fetchrow($result)) {
	            array_push($listechiens, $ligne);
	        }
	    }
	    
	    if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_user.php')) {
	    	require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_user.php');
	    }
	    else {
	    	$sortie = "A faire !";
	    }
	    
		$sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
		include ('header_mobile.php');
		echo $sortie;
		include ('footer_mobile.php');
	}
	else {
		header("Location: mobiles.php?name=SimpleUsers");
		die();
	}
}

function get_lignee($id_chien,$for_pdf= false) {
		global $header_system, $module_name,$onglet;
		global $select, $user;
		
		$header_system = '<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>';

		$paramsplus = '';
		if (is_array($select)) {
			foreach($select as $key => $value) {
				if ($value != "") {
					$paramsplus .= '&select['.$key.']='.urlencode($value);
				}
			}
		}
		
		$cursinu = new cursinuconnector();
		$lignee = $cursinu->get_lignee($id_chien);
		$chien_fiche = $cursinu->get_genealogie($lignee);
		
		if (is_user($user)) {
			$user_data_bloc = base64_decode($user);
			$userdata = explode(":", $user_data_bloc);
			if ($userdata[0] != $lignee["id_proprio"]) {
				die("Ce chien ne vous appartient pas !");
			}
		}
		else {
			header("Location: mobiles.php?name=SimpleUsers");
			die();
		}

		$chien = array();
		foreach($chien_fiche as $key=>$value) {
			$url = 'system.php?op=cursinu&action=get_lignee&onglet='.$onglet.'&Id='.$value["Id"].$paramsplus;
			if (!$for_pdf) {
				$chien[$key] .= '<div class="h1"><a href="'.$url.'">'.$value["lof"].'</a></div>';
				$chien[$key] .= '<div><a href="'.$url.'"><b>'.$value["nom_complet"].'</b></a></div>';
			}
			else {
				$chien[$key] .= '<div class="h1">'.$value["lof"].'</div>';
				$chien[$key] .= '<div><b>'.$value["nom_complet"].'</b></div>';
			}
			if ($value["sexe"] != "") {
				$chien[$key] .= '<div>'.(($value["sexe"] == "M") ? 'Male' :'').(($value["sexe"] == "F") ? 'Femelle' : '').'</div>';
			}
			if ($value["naissance"] != "0000-00-00") {
				$chien[$key] .= '<div>'.'N le '.utilFuncs_cursinu::date2JMA($value["naissance"],"d/m/Y").'</div>';
			}
		}
		
		$chien_racine = $cursinu->get_individu($id_chien);
		if ($chien_racine["hanche_gauche"] != "" || $chien_racine["hanche_droite"] != "") {
		    $chien[1] .= '<div>Dysplasie : Gauche: '.$chien_racine["hanche_gauche"]. " - Droite : ".$chien_racine["hanche_droite"].'</div>';
		}
		if ($chien_racine["tancs"] != 0 || $chien_racine["tanct"] != 0 || $chien_racine["tancc"] != 0 || $chien_racine["tancp"] != 0) {
		    $chien[1] .= '<div>TAN : ';
		    $temp = "";
		    $temp .= ($chien_racine["tancs"] == 1) ? (($temp != "") ? ", " : "") . 'Sociabilit' : "";
		    $temp .= ($chien_racine["tanct"] == 1) ? (($temp != "") ? ", " : "") . 'Troupeau' : "";
		    $temp .= ($chien_racine["tancc"] == 1) ? (($temp != "") ? ", " : "") . 'Chasse' : "";
		    $temp .= ($chien_racine["tancp"] == 1) ? (($temp != "") ? ", " : "") . 'Polyvalent' : "";
		    $chien[1] .= $temp.'</div>';
		}
		if ($chien_racine["test_adn"] !== 1) {
		    $chien[1] .= '<div>Avec identification ADN</div>';
		}
		
		$modele = '';
		$modele .= '<table cellpadding="0" cellspacing="0" border="0" class="genealogie">
		<tr>
			<td rowspan="8" class="fond1"><div class="chien origine"><div class="fiche">$chien[1]</div></div></td>
			<td rowspan="4" class="fond2"><div class="chien"><div class="etiquette">pre</div><div class="fiche">$chien[2]</div></div></td>
			<td rowspan="2" class="fond3"><div class="chien"><div class="etiquette">grand-pre</div><div class="fiche">$chien[3]</div></div></td>
			<td><div class="chien"><div class="etiquette">arrire grand-pre</div><div class="fiche">$chien[4]</div></div></td>
		</tr>
		<tr>
			<td><div class="chien"><div class="etiquette">arrire grand-mre</div><div class="fiche">$chien[5]</div></div></td>
		</tr>
		<tr>
			<td rowspan="2"  class="fond3"><div class="chien"><div class="etiquette">grand-mre</div><div class="fiche">$chien[6]</div></div></td>
			<td><div class="chien"><div class="etiquette">arrire grand-pre</div><div class="fiche">$chien[7]</div></div></td>
		</tr>
		<tr>
			<td><div class="chien"><div class="etiquette">arrire grand-mre</div><div class="fiche">$chien[8]</div></div></td>
		</tr>
		<tr>
			<td rowspan="4"  class="fond2"><div class="chien"><div class="etiquette">mre</div><div class="fiche">$chien[9]</div></div></td>
			<td rowspan="2"  class="fond3"><div class="chien"><div class="etiquette">grand-pre</div><div class="fiche">$chien[10]</div></div></td>
			<td><div class="chien"><div class="etiquette">arrire grand-pre</div><div class="fiche">$chien[11]</div></div></td>
		</tr>
		<tr>
			<td><div class="chien"><div class="etiquette">arrire grand-mre</div><div class="fiche">$chien[12]</div></div></td>
		</tr>
		<tr>
			<td rowspan="2"  class="fond3"><div class="chien"><div class="etiquette">grand-mre</div><div class="fiche">$chien[13]</div></div></td>
			<td><div class="chien"><div class="etiquette">arrire grand-pre</div><div class="fiche">$chien[14]</div></div></td>
		</tr>
		<tr>
			<td><div class="chien"><div class="etiquette">arrire grand-mre</div><div class="fiche">$chien[15]</div></div></td>
		</tr>
		</table>
		';
		
		$modele = addslashes($modele);
    	$modele = "\$sortie=\"".$modele."\";";
    	eval($modele);
    	$sortie = stripslashes($sortie);
    	return $sortie;
}

function print_lignee_pdf($id_chien) {
	global $Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $pagebreakpdf,$module_name;

	require_once("includes/html2pdf.php");
	$monpdf = new handle_pdf("A4", "L", "fr");
	
	$sortie = '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

	<html>

	<head>

	<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">

	<title>Document</title>

	<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default_pdf.css"/>

	</head>

	<body style="background-color: #fff">
	';
	
	$sortie .= get_lignee($id_chien,true);
	
	$proprio = array();
	$sql = ' SELECT user_name, user_firstname, adh_adresse FROM '.$prefix.'_cursinu_chien INNER JOIN '.$prefix.'_users ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid WHERE Id='.$id_chien.';';
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		if ($ligne = $db->sql_fetchrow($result)) {
			$chien['user_name'] = $ligne['user_name'];
			$chien['user_firstname'] = $ligne['user_firstname'];
			$chien['adh_adresse'] = nl2br($ligne['adh_adresse']);
		}
	}
	$sortie .= '
		<div id="club">
			<div style="margin-top: 5px;">Document dlivr le '.date("d/m/Y").'</div>
		</div>
		<div id="proprio">
			<div class="chien"><div class="etiquette">propritaire</div><div class="fiche">
			<div class="h1" style="text-align: left">'.($chien["user_firstname"].(($chien["user_firstname"].$chien["user_name"] != '') ? " " : "").$chien["user_name"]).'</div>
			<div>'.$chien['adh_adresse'].'</div>
			</div></div>
		</div>
		<img src="modules/'.$module_name.'/system/images/logo.png" id="logo" />
		<div id="titre">
			Club du CURSINU<br />
			<span id="soustitre">Affili  la Socit Centrale Canine<br />Reconnue d\'utilit publique</span>
		</div>
		<div id="piedpage">
			Ces documents imprims ne sauraient, en aucun cas, remplacer ceux  dlivrs officiellement par la Socit Centrale Canine
		</div>
		<div id="copyright">
			&copy; 2017 Genea cursinu - arobase.fr
		</div>
	';
	
	$sortie .= '

	</body>

	</html>';
	//die($sortie);	
	//$monpdf->affiche_pdf(utf8_encode($sortie),'CursinuClubPass');
	$monpdf->affiche_pdf(utf8_encode($sortie), "Pedigree.pdf");
}

function searchchiens ($select) {
    global $user, $module_name, $db, $prefix, $Default_Theme;

    if (is_user($user)) {
        $user_data_bloc = base64_decode($user);
        $userdata = explode(":", $user_data_bloc);
        
        $pagetitle = "- Chiens";
        
        if (count($select) > 0 && join("",$select) != "") {
            $where = '';
            if ($select["user"] != "") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= $prefix."_cursinu_chien.id_proprio='".utilFuncs_cursinu::conditionnertodb($select["user"])."'";
            }
            if ($select["lof"] != "") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= $prefix."_cursinu_chien.lof LIKE '%".utilFuncs_cursinu::conditionnertodb($select["lof"])."%'";
            }
            if ($select["icad"] != "") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= $prefix."_cursinu_chien.icad LIKE '%".utilFuncs_cursinu::conditionnertodb($select["icad"])."%'";
            }
            if ($select["tancs"] != "" || $select["tanct"] != "" || $select["tancc"] != "" || $select["tancp"] != "") {
                $where2 = "";
                if ($select["tancs"] != "") {
                    $where2 .= ($where2 != "") ? " OR " : "";
                    $where2 .= $prefix."_cursinu_chien.tancs = '".utilFuncs_cursinu::conditionnertodb($select["tancs"])."'";
                }
                if ($select["tanct"] != "") {
                    $where2 .= ($where2 != "") ? " OR " : "";
                    $where2 .= $prefix."_cursinu_chien.tanct = '".utilFuncs_cursinu::conditionnertodb($select["tanct"])."'";
                }
                if ($select["tancc"] != "") {
                    $where2 .= ($where2 != "") ? " OR " : "";
                    $where2 .= $prefix."_cursinu_chien.tancc = '".utilFuncs_cursinu::conditionnertodb($select["tancc"])."'";
                }
                if ($select["tancp"] != "") {
                    $where2 .= ($where2 != "") ? " OR " : "";
                    $where2 .= $prefix."_cursinu_chien.tancp = '".utilFuncs_cursinu::conditionnertodb($select["tancp"])."'";
                }
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(".$where2.")";
            }
            if ($select["dysp"] != "") {
                if ($select["dysp"] == "A") {
                    $where .= ($where == "") ? " WHERE " : " AND ";
                    $where .= "(". $prefix."_cursinu_chien.hanche_droite='A' OR ".$prefix."_cursinu_chien.hanche_gauche='A')";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='B' AND ". $prefix."_cursinu_chien.hanche_gauche!='B'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='C' AND ". $prefix."_cursinu_chien.hanche_gauche!='C'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
                }
                if ($select["dysp"] == "B") {
                    $where .= ($where == "") ? " WHERE " : " AND ";
                    $where .= "(". $prefix."_cursinu_chien.hanche_droite='B' OR ".$prefix."_cursinu_chien.hanche_gauche='B')";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='C' AND ". $prefix."_cursinu_chien.hanche_gauche!='C'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
                }
                if ($select["dysp"] == "C") {
                    $where .= ($where == "") ? " WHERE " : " AND ";
                    $where .= "(". $prefix."_cursinu_chien.hanche_droite='C' OR ".$prefix."_cursinu_chien.hanche_gauche='C')";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
                }
                if ($select["dysp"] == "D") {
                    $where .= ($where == "") ? " WHERE " : " AND ";
                    $where .= "(". $prefix."_cursinu_chien.hanche_droite='D' OR ".$prefix."_cursinu_chien.hanche_gauche='D')";
                    $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
                }
                if ($select["dysp"] == "E") {
                    $where .= ($where == "") ? " WHERE " : " AND ";
                    $where .= "(". $prefix."_cursinu_chien.hanche_droite='E' OR ".$prefix."_cursinu_chien.hanche_gauche='E')";
                }
            }
            if ($select["test_adn"] != "") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= $prefix."_cursinu_chien.test_adn = '".$select["test_adn"]."'";
            }
            if ($select["cotation"] != "") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= $prefix."_cursinu_chien.cotation = '".$select["cotation"]."'";
            }
            
            if ($select["nom"] != "") {
                $where .= ($where == "") ?  " HAVING " : " HAVING ";
                $where .= "nom_complet LIKE '%".utilFuncs_cursinu::conditionnertodb($select["nom"])."%'";
            }
            
            
            $sql = 'SELECT
    	    `'.$prefix.'_cursinu_chien`.`Id`,
    	    `'.$prefix.'_cursinu_chien`.`lof`,
    	    `'.$prefix.'_cursinu_chien`.`icad`,
    	    CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
    	    `'.$prefix.'_cursinu_chien`.`affixe`,
    	    `'.$prefix.'_cursinu_chien`.`sexe`,
    	    `'.$prefix.'_cursinu_chien`.`naissance`,
    	    `'.$prefix.'_cursinu_chien`.`id_pere`,
    	    `'.$prefix.'_cursinu_chien`.`id_mere`,
    	    `'.$prefix.'_cursinu_chien`.`lignee_valide`,
    	    `'.$prefix.'_cursinu_chien`.`verrou`,
    	    `'.$prefix.'_cursinu_chien`.`photo`,
    	    `'.$prefix.'_cursinu_chien`.`description`,
    	    `'.$prefix.'_cursinu_chien`.`producteur`';
            
            $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
            $sql .= ", `user_name`, `user_firstname`";
            $sql .= " FROM ".$prefix."_cursinu_chien";
            $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentpere ON `".$prefix."_cursinu_chien`.id_pere=parentpere.id";
            $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentmere ON `".$prefix."_cursinu_chien`.id_mere=parentmere.id";
            $sql .= " LEFT JOIN `".$prefix."_users` ON ".$prefix."_cursinu_chien.id_proprio=".$prefix."_users.uid";
            $sql .= $where;
            $sql .= " ORDER BY nom_complet ASC";
            $sql .= " ".$limit.";";
            
            $result = $db->sql_query($sql);
            
            $listechiens = array();
            if ($db->sql_numrows($result) > 0) {
                while ($ligne = $db->sql_fetchrow($result)) {
                    array_push($listechiens, $ligne);
                }
            }
        }
        else {
            $listechiens = array();
        }
        
        if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_search.php')) {
            require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_search.php');
        }
        else {
            $sortie = "A faire !";
        }
        
        $sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
        include ('header_mobile.php');
        echo $sortie;
        include ('footer_mobile.php');
    }
    else {
        header("Location: mobiles.php?name=SimpleUsers");
        die();
    }
}

function print_cotation_pdf($id_chien) {
    global $Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $pagebreakpdf,$module_name;
    global $user;
    
    require_once("includes/html2pdf.php");
    $monpdf = new handle_pdf("A4", "P", "fr");
    
    $sql = 'SELECT
	    `'.$prefix.'_cursinu_chien`.`Id`,
	    `'.$prefix.'_cursinu_chien`.`lof`,
	    `'.$prefix.'_cursinu_chien`.`icad`,
	    CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
	    `'.$prefix.'_cursinu_chien`.`affixe`,
	    `'.$prefix.'_cursinu_chien`.`sexe`,
	    `'.$prefix.'_cursinu_chien`.`naissance`,
	    `'.$prefix.'_cursinu_chien`.`id_pere`,
	    `'.$prefix.'_cursinu_chien`.`id_mere`,
	    `'.$prefix.'_cursinu_chien`.`lignee_valide`,
	    `'.$prefix.'_cursinu_chien`.`verrou`,
	    `'.$prefix.'_cursinu_chien`.`photo`,
	    `'.$prefix.'_cursinu_chien`.`description`,
	    `'.$prefix.'_cursinu_chien`.`producteur`,
        `'.$prefix.'_cursinu_chien`.`id_proprio`,
	    `'.$prefix.'_cursinu_chien`.`cotation`';
    
    $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
    $sql .= ", `user_name`, `user_firstname`, `uid`, `adh_adresse` ";
    $sql .= " FROM ".$prefix."_cursinu_chien";
    $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentpere ON `".$prefix."_cursinu_chien`.id_pere=parentpere.id";
    $sql .= " LEFT JOIN `".$prefix."_cursinu_chien` as parentmere ON `".$prefix."_cursinu_chien`.id_mere=parentmere.id";
    $sql .= " INNER JOIN `".$prefix."_users` ON ".$prefix."_cursinu_chien.id_proprio=".$prefix."_users.uid";
    $sql .= " WHERE `".$prefix."_cursinu_chien`.`Id` = '".$id_chien."';";
    
    
    $result = $db->sql_query($sql);
    if ($db->sql_numrows($result) == 0) {
        die("Chien introuvable !");
    }
    $chien = $db->sql_fetchrow($result);
    
    if (is_user($user)) {
        $user_data_bloc = base64_decode($user);
        $userdata = explode(":", $user_data_bloc);
        if ($userdata[0] != $chien["id_proprio"]) {
            die("Ce chien ne vous appartient pas !");
        }
    }
    else {
        header("Location: mobiles.php?name=SimpleUsers");
        die();
    }
    
    $cotation = array("0"=>"Non cot", "1"=>"1", "2"=>"2" ,"3"=>"3","4"=>"4 - Recommand","5"=>"5 - lite B","6"=>"6 - lite A");
    
    $sortie = '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">        
	<html>        
	<head>        
	<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">        
	<title>Document</title>        
	<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default_pdf.css"/>	    
	</head>	    
	<body style="background-color: #fff">
	';
    
    $sortie .= '
		<!--<div id="club">
			<div style="margin-top: 5px;">Document dlivr le '.date("d/m/Y").'</div>
		</div>
		<div id="proprio">
			<div class="chien"><div class="etiquette">propritaire</div><div class="fiche">
			<div class="h1" style="text-align: left">'.($chien["user_firstname"].(($chien["user_firstname"].$chien["user_name"] != '') ? " " : "").$chien["user_name"]).'</div>
			<div>'.$chien['adh_adresse'].'</div>
			</div></div>
		</div>-->
		<img src="modules/'.$module_name.'/system/images/logo.png" id="logo" /><br />
		<div id="titre">
			Club du CURSINU<br />
			<span id="soustitre">Affili  la Socit Centrale Canine<br />Reconnue d\'utilit publique</span>
		</div>
        <div id="contenu">
            <h1>ATTESTATION</h1>
            <p>Je soussign Andr FERRARI, Prsident du Club du Cursinu, certifie que , aprs avoir examin les pices justificatives, Le Club a dcid, aprs enregistrement et validation par les services de la Socit Centrale Canine, d\'attribuer au chien ci-dessous dsign :</p>
            <p class="chien">'.$chien["nom_complet"].'<br / >'.(($chien["sexe"] == "M") ? "Mle" : "Femelle").' Cursinu</p>
            <p class="infos">N le : '.utilFuncs_cursinu::date2JMA($chien["naissance"], "d/m/Y").'<br />LOF : '.$chien["lof"].'<br />Identification : '.$chien["icad"].'<br />Appartenant  : '.($chien["user_firstname"].(($chien["user_firstname"].$chien["user_name"] != '') ? " " : "").$chien["user_name"]).'</p>
            <p class="chien">La qualification : '.$cotation[$chien["cotation"]].'</p>
            <p>&nbsp;</p>
            <p>Fait sur le site Internet  clubducursinu.fr  le '.date("d/m/Y").'.</p>
            <p style="padding-left: 100mm">Monsieur Andr FERRARI.</p>
        </div>
		<div id="piedpage" style="left: 0">
			Ces documents imprims ne sauraient, en aucun cas, remplacer ceux  dlivrs officiellement par la Socit Centrale Canine
		</div>
		<div id="copyright">
			&copy; 2020 Genea cursinu - arobase.fr
		</div>
	';
    
    $sortie .= '        
	</body>        
	</html>';
    //die($sortie);
    //$monpdf->affiche_pdf(utf8_encode($sortie),'CursinuClubPass');
    $monpdf->affiche_pdf(utf8_encode($sortie), "Attestation.pdf");
}

function listtan(){
    
    global $prefix, $multilingual, $currentlang, $db, $Default_Theme, $module_name, $pagetitle;
    
    $pagetitle = "- Test d'Aptitudes Naturelles";
    
    $where = "";
    $where2 = "";
    $where2 .= ($where2 != "") ? " OR " : "";
    $where2 .= $prefix."_cursinu_chien.tancs = '1'";
    $where2 .= ($where2 != "") ? " OR " : "";
    $where2 .= $prefix."_cursinu_chien.tanct = '1'";
    $where2 .= ($where2 != "") ? " OR " : "";
    $where2 .= $prefix."_cursinu_chien.tancc = '1'";
    $where2 .= ($where2 != "") ? " OR " : "";
    $where2 .= $prefix."_cursinu_chien.tancp = '1'";
    $where .= ($where == "") ? " WHERE " : " AND ";
    $where .= "(".$where2.")";
    
    $sql = 'SELECT
    `'.$prefix.'_cursinu_chien`.`Id`,
    `'.$prefix.'_cursinu_chien`.`lof`,
    `'.$prefix.'_cursinu_chien`.`icad`,
    CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
    `'.$prefix.'_cursinu_chien`.`affixe`,
    `'.$prefix.'_cursinu_chien`.`sexe`,
    `'.$prefix.'_cursinu_chien`.`naissance`,
    `'.$prefix.'_cursinu_chien`.`id_pere`,
    `'.$prefix.'_cursinu_chien`.`id_mere`,
    `'.$prefix.'_cursinu_chien`.`lignee_valide`,
    `'.$prefix.'_cursinu_chien`.`verrou`,
    `'.$prefix.'_cursinu_chien`.`photo`,
    `'.$prefix.'_cursinu_chien`.`description`,
    `'.$prefix.'_cursinu_chien`.`producteur`,
    `'.$prefix.'_cursinu_chien`.`tancs`,
    `'.$prefix.'_cursinu_chien`.`tanct`,
    `'.$prefix.'_cursinu_chien`.`tancc`,
    `'.$prefix.'_cursinu_chien`.`tancp`';
    
    $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
    $sql .= ', `user_name`, `user_firstname`';
    $sql .= ' FROM '.$prefix.'_cursinu_chien';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentpere ON `'.$prefix.'_cursinu_chien`.id_pere=parentpere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentmere ON `'.$prefix.'_cursinu_chien`.id_mere=parentmere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_users` ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid';
    $sql .= $where;
    $sql .= ' ORDER BY nom_complet ASC;';
    
    $result = $db->sql_query($sql);
    
    $listechiens = array();
    if ($db->sql_numrows($result) > 0) {
        while ($ligne = $db->sql_fetchrow($result)) {
            array_push($listechiens, $ligne);
        }
    }
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_tan.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_tan.php');
    }
    else {
        $sortie = " implementer ";
    }
    
    $sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
    include ('header_mobile.php');
    echo $sortie;
    include ('footer_mobile.php');
    
}
function listsante(){
    
    global $prefix, $multilingual, $currentlang, $db, $Default_Theme, $module_name, $pagetitle;
    
    $pagetitle = "- Sant";
    
    //Recherche dysplasie
    
    $dyspTab = array("A", "B", "C", "D", "E");
    $sexeTab = Array("F", "M");
    
    $listechiensdysp = array();
    
    foreach ($dyspTab as $unedysp) {
        foreach ($sexeTab as $lesexe) {
            $where = "";
            if ($unedysp == "A") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(". $prefix."_cursinu_chien.hanche_droite='A' OR ".$prefix."_cursinu_chien.hanche_gauche='A')";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='B' AND ". $prefix."_cursinu_chien.hanche_gauche!='B'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='C' AND ". $prefix."_cursinu_chien.hanche_gauche!='C'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
            }
            if ($unedysp == "B") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(". $prefix."_cursinu_chien.hanche_droite='B' OR ".$prefix."_cursinu_chien.hanche_gauche='B')";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='C' AND ". $prefix."_cursinu_chien.hanche_gauche!='C'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
            }
            if ($unedysp == "C") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(". $prefix."_cursinu_chien.hanche_droite='C' OR ".$prefix."_cursinu_chien.hanche_gauche='C')";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='D' AND ". $prefix."_cursinu_chien.hanche_gauche!='D'";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
            }
            if ($unedysp == "D") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(". $prefix."_cursinu_chien.hanche_droite='D' OR ".$prefix."_cursinu_chien.hanche_gauche='D')";
                $where .= " AND ". $prefix."_cursinu_chien.hanche_droite!='E' AND ". $prefix."_cursinu_chien.hanche_gauche!='E'";
            }
            if ($unedysp == "E") {
                $where .= ($where == "") ? " WHERE " : " AND ";
                $where .= "(". $prefix."_cursinu_chien.hanche_droite='E' OR ".$prefix."_cursinu_chien.hanche_gauche='E')";
            }

            $where .= ($where == "") ? " WHERE " : " AND ";
            $where .= "`".$prefix."_cursinu_chien`.`sexe`='".$lesexe."'";
            
            $sql = 'SELECT
            `'.$prefix.'_cursinu_chien`.`Id`,
            `'.$prefix.'_cursinu_chien`.`lof`,
            `'.$prefix.'_cursinu_chien`.`icad`,
            CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
            `'.$prefix.'_cursinu_chien`.`affixe`,
            `'.$prefix.'_cursinu_chien`.`sexe`,
            `'.$prefix.'_cursinu_chien`.`naissance`,
            `'.$prefix.'_cursinu_chien`.`id_pere`,
            `'.$prefix.'_cursinu_chien`.`id_mere`,
            `'.$prefix.'_cursinu_chien`.`lignee_valide`,
            `'.$prefix.'_cursinu_chien`.`verrou`,
            `'.$prefix.'_cursinu_chien`.`photo`,
            `'.$prefix.'_cursinu_chien`.`description`,
            `'.$prefix.'_cursinu_chien`.`producteur`,
            `'.$prefix.'_cursinu_chien`.`hanche_droite`,
            `'.$prefix.'_cursinu_chien`.`hanche_gauche`';
            
            $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
            $sql .= ', `user_name`, `user_firstname`';
            $sql .= ' FROM '.$prefix.'_cursinu_chien';
            $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentpere ON `'.$prefix.'_cursinu_chien`.id_pere=parentpere.id';
            $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentmere ON `'.$prefix.'_cursinu_chien`.id_mere=parentmere.id';
            $sql .= ' LEFT JOIN `'.$prefix.'_users` ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid';
            $sql .= $where;
            $sql .= ' ORDER BY nom_complet ASC;';
            
            $result = $db->sql_query($sql);
            
            if ($db->sql_numrows($result) > 0) {
                while ($ligne = $db->sql_fetchrow($result)) {
                    $listechiensdysp[$unedysp][$lesexe][] = $ligne;
                }
            }
            else {
                //$listechiens[$unedysp][$lesexe] = array();
            }
        }
    }

    // Recherche ADN
    
    $listechiensadn = array();
    
    $where = "";
    $where .= ($where == "") ? " WHERE " : " AND ";
    $where .= "`".$prefix."_cursinu_chien`.`test_adn`='1'";
    
    $sql = 'SELECT
            `'.$prefix.'_cursinu_chien`.`Id`,
            `'.$prefix.'_cursinu_chien`.`lof`,
            `'.$prefix.'_cursinu_chien`.`icad`,
            CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
            `'.$prefix.'_cursinu_chien`.`affixe`,
            `'.$prefix.'_cursinu_chien`.`sexe`,
            `'.$prefix.'_cursinu_chien`.`naissance`,
            `'.$prefix.'_cursinu_chien`.`id_pere`,
            `'.$prefix.'_cursinu_chien`.`id_mere`,
            `'.$prefix.'_cursinu_chien`.`lignee_valide`,
            `'.$prefix.'_cursinu_chien`.`verrou`,
            `'.$prefix.'_cursinu_chien`.`photo`,
            `'.$prefix.'_cursinu_chien`.`description`,
            `'.$prefix.'_cursinu_chien`.`producteur`';
    
    $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
    $sql .= ', `user_name`, `user_firstname`';
    $sql .= ' FROM '.$prefix.'_cursinu_chien';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentpere ON `'.$prefix.'_cursinu_chien`.id_pere=parentpere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentmere ON `'.$prefix.'_cursinu_chien`.id_mere=parentmere.id';
    $sql .= ' LEFT JOIN `'.$prefix.'_users` ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid';
    $sql .= $where;
    $sql .= ' ORDER BY nom_complet ASC;';
    
    $result = $db->sql_query($sql);
    
    if ($db->sql_numrows($result) > 0) {
        while ($ligne = $db->sql_fetchrow($result)) {
            $listechiensadn[] = $ligne;
        }
    }
    else {
        //$listechiens[$unedysp][$lesexe] = array();
    }
    
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_sante.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_sante.php');
    }
    else {
        $sortie = " implementer ";
    }
    
    $sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
    include ('header_mobile.php');
    echo $sortie;
    include ('footer_mobile.php');
    
}

function listcotation(){
    
    global $prefix, $multilingual, $currentlang, $db, $Default_Theme, $module_name, $pagetitle;
    
    $pagetitle = "- Sant";
    
    //Recherche dysplasie
    
    $cotTab = array("6", "5", "4", "3", "2", "1");
    $sexeTab = Array("M", "F");
    
    $listechiens = array();
    
    foreach ($sexeTab as $lesexe) {
        foreach ($cotTab as $unecote) {
            $where = "";
            $where .= ($where == "") ? " WHERE " : " AND ";
            $where .= $prefix."_cursinu_chien.cotation='".$unecote."'";
            
            $where .= ($where == "") ? " WHERE " : " AND ";
            $where .= "`".$prefix."_cursinu_chien`.`sexe`='".$lesexe."'";
            
            $sql = 'SELECT
            `'.$prefix.'_cursinu_chien`.`Id`,
            `'.$prefix.'_cursinu_chien`.`lof`,
            `'.$prefix.'_cursinu_chien`.`icad`,
            CONCAT(`'.$prefix.'_cursinu_chien`.`prefixe`, `'.$prefix.'_cursinu_chien`.`nom`, `'.$prefix.'_cursinu_chien`.`suffixe`) as nom_complet,
            `'.$prefix.'_cursinu_chien`.`affixe`,
            `'.$prefix.'_cursinu_chien`.`sexe`,
            `'.$prefix.'_cursinu_chien`.`naissance`,
            `'.$prefix.'_cursinu_chien`.`id_pere`,
            `'.$prefix.'_cursinu_chien`.`id_mere`,
            `'.$prefix.'_cursinu_chien`.`lignee_valide`,
            `'.$prefix.'_cursinu_chien`.`verrou`,
            `'.$prefix.'_cursinu_chien`.`photo`,
            `'.$prefix.'_cursinu_chien`.`description`,
            `'.$prefix.'_cursinu_chien`.`producteur`,
            `'.$prefix.'_cursinu_chien`.`hanche_droite`,
            `'.$prefix.'_cursinu_chien`.`hanche_gauche`,
            `'.$prefix.'_cursinu_chien`.`tancs`,
            `'.$prefix.'_cursinu_chien`.`tanct`,
            `'.$prefix.'_cursinu_chien`.`tancc`,
            `'.$prefix.'_cursinu_chien`.`tancp`,
            `'.$prefix.'_cursinu_chien`.`cotation`';
            
            $sql .= ', CONCAT(`parentpere`.`prefixe`,`parentpere`.`nom`,`parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
            $sql .= ', `user_name`, `user_firstname`';
            $sql .= ' FROM '.$prefix.'_cursinu_chien';
            $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentpere ON `'.$prefix.'_cursinu_chien`.id_pere=parentpere.id';
            $sql .= ' LEFT JOIN `'.$prefix.'_cursinu_chien` as parentmere ON `'.$prefix.'_cursinu_chien`.id_mere=parentmere.id';
            $sql .= ' LEFT JOIN `'.$prefix.'_users` ON '.$prefix.'_cursinu_chien.id_proprio='.$prefix.'_users.uid';
            $sql .= $where;
            $sql .= ' ORDER BY nom_complet ASC;';
            
            $result = $db->sql_query($sql);
            
            if ($db->sql_numrows($result) > 0) {
                while ($ligne = $db->sql_fetchrow($result)) {
                    $listechiens[$lesexe][$unecote][] = $ligne;
                }
            }
            else {
                //$listechiens[$unedysp][$lesexe] = array();
            }
        }
    }
    
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_cotation.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_cursinu_list_chien_cotation.php');
    }
    else {
        $sortie = " implementer ";
    }
    
    $sortie = utilFuncs_cursinu::conditionnerMobile($sortie);
    include ('header_mobile.php');
    echo $sortie;
    include ('footer_mobile.php');
    
}

if (!isset($select)) {
    $select = array();
}
else {
    $select = array_map("stripslashes", $select);
}

switch($op) {
    case "searchchiens":
        searchchiens($select);
        break;
	case "get_lignee_pdf":
		print_lignee_pdf($Id);
		die();
		break;
	case "get_cotation_pdf":
	    print_cotation_pdf($Id);
	    die();
	    break;
	case "listchampions":
        listchampions();
		break;
	case "listtan":
	    listtan();
	    break;
	case "listsante":
	    listsante();
	    break;
	case "listcotation":
	    listcotation();
	    break;
	case "listemeschiens":
	default:
		listemeschiens ();
		break;
}