<?php
/**
 * Classes des fonctions pour afficher le catalogue, saisir les comptes clients, prendre les commandes et en suivre la progression.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleCatalog
 * @version 1.0
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
require_once("g_db.php");

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (expdition de mails,...).
 * @package becmsSimpleCatalog
 */
class displayCatalog {

	/**
	 * @var object Classe qui donne accs au fonctions d'utlisation du catalogue.
	 */
	var $sgbd;
	/**
	 * Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes du catalogue.
	 */
	function displayCatalog() {
		$this->sgbd = new BD_Catalog();
		$this->sgbd_promo = new BD_Promo();
	}

	/**
	 * Rcupre les variables envoyes par GET ou POST.
	 *
	 * Renvoie ces variables sous la forme de paramtres d'URL.
	 * @param string $sauf Liste des paramtres  ne pas rcuprer.
	 * @return string Liste des variables rcupres.
	 */
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0) {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		else {
			$args = "";
		}
		return $args;
	}

	/**
	 * Renvoie la liste des articles valides du catalogue.
	 *
	 * Renvoie le code HTML de la liste des articles et le formulaire de recherche.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $criteres Tableau contenant les critres de recherche des articles.
	 * @return string Tableau HTML des articles et formulaire de recherche.
	 */
	function get_list_articles($My_SQL,$vars_mod,$criteres) {
		global $module_name, $currentlang, $withrewriting;

		$_SESSION["last_search"] = "modules.php?".$this->getVars("");

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}
		$articles = $this->sgbd->searchArticles($My_SQL,$criteres);
		if (count($articles) != 0) {
			$aujourdhui = date("Y-m-d");
			$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
			$en_periode_solde = false;
			foreach($periodes_soldes as $periode_solde) {
				if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
					$en_periode_solde = true;
				}
			}
			$nbreFiches = $articles[0]["nbreFiches"];
			$repParPage = $criteres["articles_par_page"];
			$p = $criteres["page_en_cours"];
			$nbrepages = ceil($nbreFiches/$repParPage);
			if ($p>$nbrepages) {
				$p = $nbrepages;
			}
			$limInf = ($p-1)*$repParPage;
			$indexPages .= "<div class=\"pages\">";
			if ($nbreFiches != 0) {
				$indexPages .= $nbreFiches._CATALOGARTICLESFOUNDPAGES;
			}
			else {
				$indexPages .= _CATALOGARTICLESNOTFOUNDPAGES;
			}
			$indexPages .= _CATALOGARTICLESPAGES;
			for ($i=1;$i<=$nbrepages;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					if ($withrewriting && preg_match("/.htm$/i",$_SERVER["REQUEST_URI"])) {
						$lurl = $_SERVER["REQUEST_URI"];
						$lurl = preg_replace("/_".$vars_mod["page_en_cours"].",([0-9])+/i","",$lurl);
						$lurl = preg_replace("/\.htm$/i","_".$vars_mod["page_en_cours"].",".$i.".htm");
						$indexPages .= "<a href=\"".$lurl."\">$i</a>";
					}
					else {
						$indexPages .= "<a href=\"?".$this->getVars($vars_mod["page_en_cours"])."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					}
					$indexPages .= "</div>";
				}
			}
			$indexPages .= "</div>";

			$listarticles = '<table cellpadding="0" cellspacing="0" border="0" class="listearticles">';
			$listarticles .= '<tr>';
			$listarticles .= '<td colspan="7" class="separation"><hr class="articles" /></td>';
			$listarticles .= "</tr>";
			foreach ($articles as $article) {
				$prix_affiche = number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
				if ($aujourdhui >= $article["deb_promo"] && $aujourdhui <= $article["fin_promo"]) {
					$prix_affiche = _CATALOGARTICLESPRIXPROMO.'<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").' &euro;</span>'
					.'&nbsp;&nbsp;'
					.number_format((($article["tarif_promo"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
				}
				if ($en_periode_solde && $article["taux_solde"] != 0) {
					//if ($aujourdhui >= $article["deb_solde"] && $aujourdhui <= $article["fin_solde"]) {
					$prix_affiche = _CATALOGARTICLESPRIXSOLDE."-".$article["taux_solde"].'% : '.'<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").' &euro;</span>'
					.'&nbsp;&nbsp;'
					.number_format((($article["tarif_ht"])*(1-($article["taux_solde"])/100)*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
				}
				$nbrelignestab = 1;
				if ($article["marque"] != '' && strpos($vars_mod["type_search"],"M") !== false) {
					$nbrelignestab++;
				}
				if ($article["ref_article"] != '' && strpos($vars_mod["type_search"],"R") !== false) {
					$nbrelignestab++;
				}
				if ($article["description".$suffixe] != '') {
					$nbrelignestab++;
				}

				$listarticles .= '<tr>';
				if ($article["photo"] != "") {
					$listarticles .= '<td rowspan="'.$nbrelignestab.'" valign="top"><a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'"><img src="'.$vars_mod["cheminPhotos"].'/'.$article["photo"].'" class="vignette"></a></td>';
				}
				else {
					$listarticles .= '<td rowspan="'.$nbrelignestab.'" valign="top">[n/d]</td>';
				}
				$listarticles .= '<td width="20"></td>';
				$listarticles .= '<td class="design" valign="top"><a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'">'.$article["designation".$suffixe].'</a></td>';
				$listarticles .= '<td width="20"></td>';
				$listarticles .= '<td align="right" valign="top" nowrap="nowrap">'.$prix_affiche.'</td>';
				$listarticles .= '<td width="20"></td>';
				$listarticles .= '<td valign="top" nowrap="nowrap"><a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'"><img src="'.$this->get_picto_url($vars_mod,"loupe.gif").'" alt="'._CATALOGARTICLESFICHE.'" border="0" class="noprint" /></a>';
				if ($article["options".$suffixe] == "" && $this->is_delivrable($My_SQL,$vars_mod,$article["Id"])) {
					$listarticles .= '<a href="modules.php?name='.$module_name.'&sop=add_caddie&Id='.$article["Id"].'&nbre=1&options=" title="'._CATALOGARTICLESADDCADDIE.'"><img src="'.$this->get_picto_url($vars_mod,"cart.gif").'" alt="'._CATALOGARTICLESADDCADDIE.'" border="0" class="noprint" /></a>';
				}
				$listarticles .= '</td>';
				$listarticles .= "</tr>";
				if ($article["description".$suffixe] != '') {
					if (strlen($article["description".$suffixe]) > $vars_mod["longueurtextedescr"]) {
						$pos = strpos($article["description".$suffixe], " ", $vars_mod["longueurtextedescr"]);
						$extrait = substr($article["description".$suffixe],0,$pos)."...";
					}
					else {
						$extrait = $article["description".$suffixe];
					}
					$listarticles .= '<tr>';
					$listarticles .= '<td width="20"></td>';
					$listarticles .= '<td colspan="4">'.$extrait.'</td>';
					/*$listarticles .= '<td width="20"></td>';
					 $listarticles .= '<td></td>';
					 $listarticles .= '<td width="20"></td>';*/
					$listarticles .= '<td></td>';
					$listarticles .= "</tr>";
				}
				if ($article["marque"] != '' && strpos($vars_mod["type_search"],"M") !== false) {
					$listarticles .= '<tr>';
					$listarticles .= '<td width="20"></td>';
					$listarticles .= '<td colspan="4">'._CATALOGARTICLESMARK." ".$article["marque"].'</td>';
					/*$listarticles .= '<td width="20"></td>';
					 $listarticles .= '<td></td>';
					 $listarticles .= '<td width="20"></td>';*/
					$listarticles .= '<td></td>';
					$listarticles .= "</tr>";
				}
				if ($article["ref_article"] != '' && strpos($vars_mod["type_search"],"R") !== false) {
					$listarticles .= '<tr>';
					$listarticles .= '<td width="20"></td>';
					$listarticles .= '<td colspan="4">'._CATALOGARTICLESREF." ".$article["ref_article"].'</td>';
					/*$listarticles .= '<td width="20"></td>';
					 $listarticles .= '<td></td>';
					 $listarticles .= '<td width="20"></td>';*/
					$listarticles .= '<td></td>';
					$listarticles .= "</tr>";
				}
				$listarticles .= '<tr>';
				$listarticles .= '<td colspan="7" class="separation"><hr class="articles" /></td>';
				$listarticles .= "</tr>";
			}
			$listarticles .= "</table>";
		}
		else {
			$listarticles = '<p class="alerte">'._CATALOGARTICLESNOTFIND.'</p>';
		}

		$arbo = $this->sgbd->getArborescence($My_SQL);
		$fd = $arbo[0]["arbo"];
		$fdtab = explode("\n",$fd);
		$mots_search = array();
		//$menu_mc = '<select name="categorie" size="1" onclick="val2kwz(this)" class="saisie"><option value="">Catgories prdfinies</option>';
		$menu_mc = '<select name="categorie" size="1" class="saisie"><option value=""></option>';
		foreach($fdtab as $ligne) {
			list($key,$value) = explode("|",$ligne);
			$key = preg_replace("#^(\.)#","",$key);
			$compteur = 0;
			do {
				$oldkey = $key;
				$key = preg_replace("#^(&nbsp;&nbsp;)*(\\.)#","\\1&nbsp;&nbsp;",$key);
				$compteur++;
			} while ($key != $oldkey);
			$value = str_replace('\n'," ",$value);
			$mots_search[$compteur] = $value;
			$mots_ligne = "";
			for($i=1;$i<=$compteur;$i++) {
				if ($mots_ligne != "") {
					$mots_ligne .= " ";
				}
				$mots_ligne .= $mots_search[$i];
			}
			$mots_ligne = str_replace("\n","",$mots_ligne);
			$mots_ligne = str_replace("\r","",$mots_ligne);
			//echo $key." - ".$value." - ".$compteur." - ".$mots_ligne."<br>";
			if ($criteres["categorie"] == $mots_ligne) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menu_mc .= '<option value="'.$mots_ligne.'"'.$selected.'>'.$key.'</option>';
		}
		$menu_mc .= '</select>';

		$marques = $this->sgbd->getMarques($My_SQL);
		$menu_marque = '<select name="marque" size="1" class="saisie"><option value=""></option>';
		foreach($marques as $unemarque) {
			if ($criteres["marque"] == $unemarque) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menu_marque .= '<option value="'.$unemarque.'"'.$selected.'>'.$unemarque.'</option>';
		}
		$menu_marque .= '</select>';

		$formSearch = "";
		$hiddens = "";
		$formSearch .= '
		<form name="search_article" method="post" action="modules.php?name='.$module_name.'&sop=display">
		<fieldset class="noprint"><legend>'._CATALOGARTICLESFORMSEARCH.'</legend>
		<div align="center">
		<table border="0" cellpadding="0" cellspacing="0" class="search">';
		if (strpos($vars_mod["type_search"],"C") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESMOTSCLEFS.'</td>
			<td width="20"></td>
			<td><input type="text" name="kwz" value="'.$criteres["kwz"].'" class="saisie"></td>
			<td width="20"></td>
			<td>'._CATALOGARTICLESCAT.'</td>
			<td width="20"></td>
			<td>'.$menu_mc.'</td>
			</tr>';
		}
		else {
			$hiddens .= '<input type="hidden" name="kwz" value="">';
		}
		if (strpos($vars_mod["type_search"],"R") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESREF.'</td>
			<td width="20"></td>
			<td><input type="text" name="ref" value="'.$criteres["ref"].'" class="saisie"></td>
			<td width="20"></td>';
			if (strpos($vars_mod["type_search"],"M") !== false) {
				$formSearch .= '<td rowspan="2" valign="bottom" colspan="3"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
			else {
				$formSearch .= '<td valign="bottom" colspan="3"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
		}
		else {
			$hiddens .= '<input type="hidden" name="ref" value="">';
		}
		if (strpos($vars_mod["type_search"],"M") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESMARK.'</td>
			<td width="20"></td>
			<td><!--<input type="text" name="marque" value="'.$criteres["marque"].'" class="saisie">-->'.$menu_marque.'</td>';
			if (strpos($vars_mod["type_search"],"R") !== false) {
				$formSearch .= '</tr>';
			}
			else {
				$formSearch .= '<td width="20"></td><td valign="bottom"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
		}
		else {
			$hiddens .= '<input type="hidden" name="marque" value="">';
		}

		if (!(strpos($vars_mod["type_search"],"M") !== false || strpos($vars_mod["type_search"],"R") !== false)) {
			$formSearch .= '<tr>
				<td valign="bottom" colspan="7" align="center"><input type="hidden" name="marque" value=""><input type="hidden" name="ref" value=""><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
			</tr>';
		}

		$formSearch .= '</table>'.$hiddens.'
		</div>
		</fieldset>
		</form>';

		$contenu = $stylecatalog.'
			<div class="catalog">
				<h1>'._CATALOGARTICLES.'</h1>
				'.$formSearch.'
				'.$indexPages.'
				'.$listarticles.'
				'.$indexPages.'
			</div>
<script type="text/javascript">
function val2kwz(menu) {
	menu.form.kwz.value = menu.value;
}
</script>';
			
		return $contenu;
	}

	/**
	 * Renvoie les articles valides du catalogue en grille.
	 *
	 * Renvoie le code HTML de la grille des articles et le formulaire de recherche.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $criteres Tableau contenant les critres de recherche des articles.
	 * @return string Code HTML des articles et formulaire de recherche.
	 */
	function get_grid_articles($My_SQL,$vars_mod,$criteres) {
		global $module_name, $currentlang, $withrewriting;

		$_SESSION["last_search"] = "modules.php?".$this->getVars("");

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}
		$articles = $this->sgbd->searchArticles($My_SQL,$criteres);
		if (count($articles) != 0) {
			$aujourdhui = date("Y-m-d");
			$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
			$en_periode_solde = false;
			foreach($periodes_soldes as $periode_solde) {
				if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
					$en_periode_solde = true;
				}
			}
			$nbreFiches = $articles[0]["nbreFiches"];
			$repParPage = $criteres["articles_par_page"];
			$p = $criteres["page_en_cours"];
			$nbrepages = ceil($nbreFiches/$repParPage);
			if ($p>$nbrepages) {
				$p = $nbrepages;
			}
			$limInf = ($p-1)*$repParPage;
			$indexPages .= "<div class=\"pages\">";
			if ($nbreFiches != 0) {
				$indexPages .= $nbreFiches._CATALOGARTICLESFOUNDPAGES;
			}
			else {
				$indexPages .= _CATALOGARTICLESNOTFOUNDPAGES;
			}
			$indexPages .= _CATALOGARTICLESPAGES;
			for ($i=1;$i<=$nbrepages;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					if ($withrewriting && preg_match("/.htm$/i",$_SERVER["REQUEST_URI"])) {
						$lurl = $_SERVER["REQUEST_URI"];
						$lurl = preg_replace("/_".$vars_mod["page_en_cours"].",([0-9])+/i","",$lurl);
						$lurl = preg_replace("/\.htm$/i","_".$vars_mod["page_en_cours"].",".$i.".htm");
						$indexPages .= "<a href=\"".$lurl."\">$i</a>";
					}
					else {
						$indexPages .= "<a href=\"?".$this->getVars($vars_mod["page_en_cours"])."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					}
					$indexPages .= "</div>";
				}
			}
			$indexPages .= "</div>";

			/*
			 $listarticles = '<table cellpadding="0" cellspacing="0" border="0" class="listearticles">';
			 $listarticles .= '<tr>';
			 $listarticles .= '<td colspan="7" class="separation"><hr class="articles" /></td>';
			 $listarticles .= "</tr>";
			 */
			$listarticles = '<ul class="listearticles">';
			foreach ($articles as $article) {
				$taille_vignette = 100;
				$taille_image = getimagesize($vars_mod["cheminPhotos"].'/'.$article["photo"]);
				$sup = max($taille_image[0],$taille_image[1]);
				$largeur = ceil($taille_vignette*$taille_image[0]/$sup);
				$hauteur = ceil($taille_vignette*$taille_image[1]/$sup);
				if (strlen($article["designation".$suffixe]) > $vars_mod["longueurtextedesign"]) {
					$pos = strpos($article["designation".$suffixe], " ", $vars_mod["longueurtextedesign"]);
					if ($pos == 0) {
						$extrait = $article["designation".$suffixe];
					}
					else {
						$extrait = substr($article["designation".$suffixe],0,$pos)."...";
					}
				}
				else {
					$extrait = $article["designation".$suffixe];
				}
				if ($article["options".$suffixe] == "" && $this->is_delivrable($My_SQL,$vars_mod,$article["Id"])) {
					$addcart = '<a href="modules.php?name='.$module_name.'&sop=add_caddie&Id='.$article["Id"].'&nbre=1&options=" title="'._CATALOGARTICLESADDCADDIE.'"><img src="'.$this->get_picto_url($vars_mod,"minicart.gif").'" alt="'._CATALOGARTICLESADDCADDIE.'" border="0" class="noprint" /></a>';
				}
				else {
					$addcart = "";
				}
				$listarticles .= '<li><table border="0" cellpadding="0" cellspacing="5">
				<tr><td class="vignette"><a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'"><img src="'.$vars_mod["cheminPhotos"].'/'.$article["photo"].'" width="'.$largeur.'" height="'.$hauteur.'" border="0" /></a></td></tr>
				<tr><td>
					<table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%" class="colle">
					<tr>
					<td  class="design">
						<a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'">'.$extrait.'</a>
					</td>
					<td width="15">
						<table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%" class="colle">
						<tr><td><a href="modules.php?name='.$module_name.'&sop=display_article&'.$vars_mod["id_article"]."=".$article["Id"].'" title="'._CATALOGARTICLESFICHE.'"><img src="'.$this->get_picto_url($vars_mod,"miniloupe.gif").'" alt="'._CATALOGARTICLESFICHE.'" border="0" class="noprint" /></a></td></tr>
						<tr><td>'.$addcart.'</td></tr>
						</table>
					</td>
					</tr>
					</table>
				</td></tr>
				</table>
				</li>';
			}
			$listarticles .= "</ul>";
		}
		else {
			$listarticles = '<p class="alerte">'._CATALOGARTICLESNOTFIND.'</p>';
		}

		$arbo = $this->sgbd->getArborescence($My_SQL);
		$fd = $arbo[0]["arbo"];
		$fdtab = explode("\n",$fd);
		$mots_search = array();
		//$menu_mc = '<select name="categorie" size="1" onclick="val2kwz(this)" class="saisie"><option value="">Catgories prdfinies</option>';
		$menu_mc = '<select name="categorie" size="1" class="saisie"><option value=""></option>';
		foreach($fdtab as $ligne) {
			list($key,$value) = explode("|",$ligne);
			$key = preg_replace("#^(\.)#","",$key);
			$compteur = 0;
			do {
				$oldkey = $key;
				$key = preg_replace("#^(&nbsp;&nbsp;)*(\\.)#","\\1&nbsp;&nbsp;",$key);
				$compteur++;
			} while ($key != $oldkey);
			$value = str_replace('\n'," ",$value);
			$mots_search[$compteur] = $value;
			$mots_ligne = "";
			for($i=1;$i<=$compteur;$i++) {
				if ($mots_ligne != "") {
					$mots_ligne .= " ";
				}
				$mots_ligne .= $mots_search[$i];
			}
			$mots_ligne = str_replace("\n","",$mots_ligne);
			$mots_ligne = str_replace("\r","",$mots_ligne);
			//echo $key." - ".$value." - ".$compteur." - ".$mots_ligne."<br>";
			if ($criteres["categorie"] == $mots_ligne) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menu_mc .= '<option value="'.$mots_ligne.'"'.$selected.'>'.$key.'</option>';
		}
		$menu_mc .= '</select>';

		$marques = $this->sgbd->getMarques($My_SQL);
		$menu_marque = '<select name="marque" size="1" class="saisie"><option value=""></option>';
		foreach($marques as $unemarque) {
			if ($criteres["marque"] == $unemarque) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menu_marque .= '<option value="'.$unemarque.'"'.$selected.'>'.$unemarque.'</option>';
		}
		$menu_marque .= '</select>';

		$formSearch = "";
		$hiddens = "";
		$formSearch .= '
		<form name="search_article" method="post" action="modules.php?name='.$module_name.'&sop=display_grid">
		<fieldset class="noprint"><legend>'._CATALOGARTICLESFORMSEARCH.'</legend>
		<div align="center">
		<table border="0" cellpadding="0" cellspacing="0" class="search">';
		if (strpos($vars_mod["type_search"],"C") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESMOTSCLEFS.'</td>
			<td width="20"></td>
			<td><input type="text" name="kwz" value="'.$criteres["kwz"].'" class="saisie"></td>
			<td width="20"></td>
			<td>'._CATALOGARTICLESCAT.'</td>
			<td width="20"></td>
			<td>'.$menu_mc.'</td>
			</tr>';
		}
		else {
			$hiddens .= '<input type="hidden" name="kwz" value="">';
		}
		if (strpos($vars_mod["type_search"],"R") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESREF.'</td>
			<td width="20"></td>
			<td><input type="text" name="ref" value="'.$criteres["ref"].'" class="saisie"></td>
			<td width="20"></td>';
			if (strpos($vars_mod["type_search"],"M") !== false) {
				$formSearch .= '<td rowspan="2" valign="bottom" colspan="3"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
			else {
				$formSearch .= '<td valign="bottom" colspan="3"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
		}
		else {
			$hiddens .= '<input type="hidden" name="ref" value="">';
		}
		if (strpos($vars_mod["type_search"],"M") !== false) {
			$formSearch .= '<tr>
			<td>'._CATALOGARTICLESMARK.'</td>
			<td width="20"></td>
			<td><!--<input type="text" name="marque" value="'.$criteres["marque"].'" class="saisie">-->'.$menu_marque.'</td>';
			if (strpos($vars_mod["type_search"],"R") !== false) {
				$formSearch .= '</tr>';
			}
			else {
				$formSearch .= '<td width="20"></td><td valign="bottom"><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
				</tr>';
			}
		}
		else {
			$hiddens .= '<input type="hidden" name="marque" value="">';
		}

		if (!(strpos($vars_mod["type_search"],"M") !== false || strpos($vars_mod["type_search"],"R") !== false)) {
			$formSearch .= '<tr>
				<td valign="bottom" colspan="7" align="center"><input type="hidden" name="marque" value=""><input type="hidden" name="ref" value=""><input type="submit" value="'._CATALOGARTICLESSEARCH.'"><!--<input type="button" value="'._CATALOGVIEWCADDIE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=display_caddie\'">--></td>
			</tr>';
		}

		$formSearch .= '</table>'.$hiddens.'
		</div>
		</fieldset>
		</form>';

		$contenu = $stylecatalog.'
			<div class="catalog">
				<h1>'._CATALOGARTICLES.'</h1>
				'.$formSearch.'
				'.$indexPages.'
				'.$listarticles.'
				'.$indexPages.'
			</div>
<script type="text/javascript">
function val2kwz(menu) {
	menu.form.kwz.value = menu.value;
}
</script>';
			
		return $contenu;
	}

	/**
	 * Renvoie le dtail d'un article du catalogue.
	 *
	 * Renvoie le code HTML de la liste des articles et le formulaire de recherche.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $criteres Tableau contenant les critres de recherche des articles.
	 * @return string Tableau HTML des articles et formulaire de recherche.
	 */
	function get_one_article($My_SQL,$vars_mod,$criteres) {
		global $module_name, $currentlang;
		global $pagetitle;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}
		$articles = $this->sgbd->getArticles($My_SQL,$criteres["Id"]);
		$article = $articles[0];
		
		$pagetitle = "- ".$article["designation".$suffixe];
		
		$aujourdhui = date("Y-m-d");
		$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
		$en_periode_solde = false;
		foreach($periodes_soldes as $periode_solde) {
			if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
				$en_periode_solde = true;
			}
		}
		$prix_affiche = number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
		if ($aujourdhui >= $article["deb_promo"] && $aujourdhui <= $article["fin_promo"]) {
			$prix_affiche = _CATALOGARTICLESPRIXPROMO.'<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").' &euro;</span>'
			.'&nbsp;&nbsp;'
			.number_format((($article["tarif_promo"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
		}
		if ($en_periode_solde && $article["taux_solde"] != 0) {
			//if ($aujourdhui >= $article["deb_solde"] && $aujourdhui <= $article["fin_solde"]) {
			$prix_affiche = _CATALOGARTICLESPRIXSOLDE."-".$article["taux_solde"].'% : '.'<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").' &euro;</span>'
			.'&nbsp;&nbsp;'
			.number_format((($article["tarif_ht"])*(1-($article["taux_solde"])/100)*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
		}

		$params_form = '<input type="hidden" name="'.$vars_mod["id_article"].'" value="'.$article["Id"].'">';
		$params_form .= '<input type="hidden" name="options" value="">';
		$params_form .= '<input type="hidden" name="nbre" value="1">';

		$select = '';
		if ($article["options".$suffixe] != "") {
			$options = explode("\n", $article["options".$suffixe]);
			$compteur = 0;
			foreach ($options as $option) {
				$lignes = explode("/",$option);
				if ($select != "") {
					$select .= " ";
				}
				$select .= '<select name="option_article_'.$compteur.'" size="1">';
				$select .= '<option value="'.$lignes[0].'">'.$lignes[0].'</option>';
				for ($i=1;$i<count($lignes);$i++) {
					$select .= '<option value="'.$lignes[$i].'">&nbsp;&nbsp;'.$lignes[$i].'</option>';
				}
				$select .= '</select>';
				$compteur++;
			}
		}
		$unarticles = '<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/newpop.js"></script>';
		$unarticles .= '<form name="article" method="post" action="modules.php?name='.$module_name.'&sop=add_caddie" onsubmit="return valid(this)">';
		$unarticles .= '<table cellpadding="0" cellspacing="0" border="0" class="unarticle"><tr><td valign="top">';
		$unarticles .= '<table cellpadding="0" cellspacing="0" border="0" class="casearticle"><tr>';
		if ($article["photo"] != "") {
			$unarticles .= '<td valign="top"><a href="javascript:OpenImage(\''.$article["photo"].'\')" title="'._CATALOGARTICLESFICHE.'"><img src="'.$vars_mod["cheminPhotos"].'/'.$article["photo"].'" class="photo"></a></td>';
		}
		else {
			$unarticles .= '<td>[n/d]</td>';
		}
		$unarticles .= '</tr></table>';
		$unarticles .= '</td><td valign="top" width="100%">';
		$unarticles .= '<table cellpadding="0" cellspacing="0" border="0" class="casearticle">';
		$unarticles .= '<tr>';
		$unarticles .= '<td width="20"></td>';
		$unarticles .= '<td class="design" valign="top">'.$article["designation".$suffixe].'</td>';
		$unarticles .= '<td width="20"></td>';
		$unarticles .= '<td align="right" valign="top" nowrap="nowrap">'.$prix_affiche.'</td>';
		$unarticles .= '<td width="20"></td>';
		if ($this->is_delivrable($My_SQL,$vars_mod,$article["Id"])) {
			$unarticles .= '<td valign="top">'.$params_form.'<a href="javascript:ajout_caddie();" title="'._CATALOGARTICLESADDCADDIE.'"><img src="'.$this->get_picto_url($vars_mod,"cart.gif").'" alt="'._CATALOGARTICLESADDCADDIE.'" border="0" class="noprint" /></a></td>';
		}
		else {
			$unarticles .= '<td valign="top">'._NODELIVERY.'</td>';
		}
		$unarticles .= "</tr>";
		if ($article["marque"] != '') {
			$unarticles .= '<tr>';
			$unarticles .= '<td width="20"></td>';
			$unarticles .= '<td colspan="4">'._CATALOGARTICLESMARK." ".$article["marque"].'</td>';
			/*$unarticles .= '<td width="20"></td>';
			 $unarticles .= '<td></td>';
			 $unarticles .= '<td width="20"></td>';*/
			$unarticles .= '<td></td>';
			$unarticles .= "</tr>";
		}
		if ($article["ref_article"] != '') {
			$unarticles .= '<tr>';
			$unarticles .= '<td width="20"></td>';
			$unarticles .= '<td colspan="4">'._CATALOGARTICLESREF." ".$article["ref_article"].'</td>';
			/*$unarticles .= '<td width="20"></td>';
			 $unarticles .= '<td></td>';
			 $unarticles .= '<td width="20"></td>';*/
			$unarticles .= '<td></td>';
			$unarticles .= "</tr>";
		}
		if ($article["options".$suffixe] != "") {
			$unarticles .= '<tr>';
			$unarticles .= '<td width="20"></td>';
			$unarticles .= '<td colspan="5">'._CATALOGARTICLESOPTIONS.$select.'</td>';
			$unarticles .= '</tr>';
		}
		if ($article["description".$suffixe] != '') {
			$unarticles .= '<tr><td width="20"></td><td colspan="5" class="separation"><hr /></td></tr>';
			$unarticles .= '<tr>';
			$unarticles .= '<td width="20"></td>';
			$unarticles .= '<td colspan="5">'.$article["description".$suffixe].'</td>';
			$unarticles .= "</tr>";
		}
		if ($article["list_pays"] != ""){
			$unarticles .= '<tr><td width="20"></td><td colspan="5" class="separation"><hr /></td></tr>';
			$unarticles .= "<tr>";
			$unarticles .= '<td width="20"></td>';
			$unarticles .= '<td colspan="4">'._ONLYTHESECOUNTRIES.join(", ",$this->delivrable_countries($My_SQL,$article["Id"])).'</td>';
			$unarticles .= "</tr>";
		}
		$unarticles .= '<tr><td width="20"></td><td colspan="5" class="separation"><hr /></td></tr>';
		$unarticles .= '<tr>';
		$unarticles .= '<td width="20"></td>';
		$unarticles .= '<td colspan="5"><input type="button" value="'._CATALOGARTICLEBACK.'" name="retour" onclick="window.location.href=\''.$_SESSION["last_search"].'\'" class="noprint" /></td>';
		$unarticles .= '</tr>';
		$unarticles .= '</table>';
		$unarticles .= '</td></tr></table>';
		$unarticles .= '</form>';
		$contenu = $stylecatalog.'
		<div class="catalog">
			<h1>'._CATALOGARTICLES.'</h1>
			'.$formSearch.'
			'.$unarticles.'
		</div>
<script type="text/javascript">
	function valid(formulaire) {
		var ok = true;
		var compteur=0;
		
		while (typeof(formulaire.elements["option_article_"+compteur]) != "undefined") {
			if (formulaire.elements["option_article_"+compteur].selectedIndex == 0) {
				alert("vous devez choisir une valeur pour : "+formulaire.elements["option_article_"+compteur].value);
				ok = false;
			}
			compteur++;
		}
		if (ok) {
			formulaire.options.value = "";
			var compteur=0;
			while (typeof(formulaire.elements["option_article_"+compteur]) != "undefined") {
				if (formulaire.options.value != "") {
					formulaire.options.value += "\n";
				}
				formulaire.options.value += formulaire.elements["option_article_"+compteur].options[0].value+"/"+formulaire.elements["option_article_"+compteur].value
				compteur++;
			}
		}
		return ok;
	}
	function ajout_caddie() {
		if (valid(document.article)) {;
			document.article.submit();
		}
	}
</script>';
			
		return $contenu;
	}

	/**
	 * Ajoute un article dans le caddie.
	 *
	 * Renvoie ensuite le code HTML du contenu du caddie. Ce caddie est modifiable au niveau des quantits des articles.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_line_caddie Tableau contenant le nouvel article  ajouter.
	 * @return string Formulaire HTML affichant le contenu du caddie et la posibilit de le modifier.
	 */
	function add_caddie($My_SQL,$vars_mod,$new_line_caddie) {
		global $module_name, $currentlang, $seps;
		//$_SESSION["caddie"] = "";
		if (!isset($_SESSION["caddie"])) {
			$_SESSION["caddie"] = "";
		}
		if ($new_line_caddie[$vars_mod["id_article"]] != "-1") {
			if ($_SESSION["caddie"] != "") {
				$_SESSION["caddie"] .= $seps["sep_article"];
			}
			$_SESSION["caddie"] .= $new_line_caddie[$vars_mod["id_article"]].$seps["sep_champ"].$new_line_caddie["nbre"].$seps["sep_champ"].$new_line_caddie["options"];
		}
		return $this->affiche_caddie_modif($My_SQL,$vars_mod);
	}

	/**
	 * Met  jour le caddie aprs modification.
	 *
	 * Renvoie ensuite le code HTML du contenu du caddie. Ce caddie reste modifiable au niveau des quantits des articles.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $new_caddie Chane de caractres contenant l'intgralit du caddie.
	 * @return string Formulaire HTML affichant le contenu du caddie et la posibilit de le modifier.
	 */
	function update_caddie($My_SQL,$vars_mod,$new_caddie) {
		$_SESSION["caddie"] = $new_caddie;
		//$_SESSION["caddie"] = "";
		return $this->affiche_caddie_modif($My_SQL,$vars_mod);
	}

	/**
	 * Renvoie le contenu du caddie.
	 *
	 * Ce caddie est modifiable au niveau des quantits des articles.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML affichant le contenu du caddie et la posibilit de le modifier.
	 */
	function display_caddie($My_SQL,$vars_mod) {
		return $this->affiche_caddie_modif($My_SQL,$vars_mod);
	}

	/**
	 * Renvoie le contenu du caddie modifiable.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML affichant le contenu du caddie et la posibilit de le modifier.
	 */
	function affiche_caddie_modif($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$aujourdhui = date("Y-m-d");
		$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
		$en_periode_solde = false;
		foreach($periodes_soldes as $periode_solde) {
			if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
				$en_periode_solde = true;
			}
		}
		if (!isset($_SESSION["caddie"])) {
			$_SESSION["caddie"] = "";
		}

		if ($_SESSION["caddie"] != "") {
			switch ($currentlang) {
				case "italian" :
					$suffixe = "_I";
					break;
				case "french" :
					$suffixe = "_F";
					break;
				case "spanish" :
					$suffixe = "_S";
					break;
				case "english" :
					$suffixe = "_E";
					break;
				case "german" :
					$suffixe = "_A";
					break;
			}
			$articles = explode($seps["sep_article"],$_SESSION["caddie"]);
			$inputs = '<input type="hidden" value="modif" name="op_caddie">';
			$total_tarif = 0;
			$contenu = '<table border="0" cellpadding="0" cellspacing="0" class="listearticles">';
			$contenu .= '<tr><td>';
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= 'Article';
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= 'Rfrence';
			$contenu .= '</td><td width="20"></td><td class="design" align="right" nowrap="nowrap">';
			$contenu .= 'P. U.';
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= 'Quantit';
			$contenu .= '</td><td width="20"></td><td class="design" align="right" nowrap="nowrap">';
			$contenu .= 'Montant';
			$contenu .= '</td><td width="20"></td><td class="design" align="right" nowrap="nowrap">';
			$contenu .= '</td></tr>';
			$contenu .= '<tr><td colspan="13" class="separation"><hr /></td></tr>';
			$compteur = 0;
			$livraison_possible = true;
			foreach($articles as $article) {
				list($Id,$nbre,$options_str) = explode($seps["sep_champ"],$article);
				$inputs = '<input type="hidden" value="'.$Id.'" name="caddie_Id[]"><input type="hidden" value="'.$options_str.'" name="caddie_options[]"><input value="'.$nbre.'" name="caddie_nbre[]" size="2">';
				$options_ligne = "";
				if ($options_str !="") {
					$options = explode($seps["sep_option"],$options_str);
					foreach($options as $option) {
						list($key,$value) = explode($seps["sep_valeur"],$option);
						if ($options_ligne != "") {
							$options_ligne .= " - ";
						}
						$options_ligne .= $key." : ".$value;
					}
					$options_ligne = "<br>".$options_ligne;
				}
				$articles_cat = $this->sgbd->getArticles($My_SQL,$Id);
				$article_cat = $articles_cat[0];

				if ($this->is_delivrable($My_SQL,$vars_mod,$article_cat["Id"])) {
					$marque_livraison = "";
					$btn_equiv = "";
				}
				else {
					$marque_livraison = "**";
					//recherche quivalent
					$mot_clefs = $this->sgbd->getCategories($My_SQL,$article_cat["Id"]);
					$kwz = addslashes(urlencode(join(" ",$mot_clefs)));
					$btn_equiv = '<input type="button" name="equiv" value="'._ARTICLEQUIV.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&kwz='.$kwz.'\'">';
					$livraison_possible = false;
				}

				$designation_ligne = $marque_livraison." ".$article_cat["designation".$suffixe]." ".$btn_equiv;
				if ($article_cat["marque"] != '') {
					$marque_ligne = $article_cat["marque"]." - ";
				}
				else {
					$marque_ligne = "";
				}
				if ($article_cat["ref_article"] != '') {
					$ref_ligne = $article_cat["ref_article"];
				}
				else {
					$ref_ligne = "";
				}
				if ($article["photo"] != "") {
					$photo = '<img src="'.$vars_mod["cheminPhotos"].'/'.$article_cat["photo"].'" class="vignette">';
				}
				else {
					$photo = "n/d";
				}
				$prix_affiche = number_format((($article_cat["tarif_ht"])*(1+($article_cat["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro;';
				$prix = number_format($article_cat["tarif_ht"]*(1+($article_cat["taux_tva"])/100),2);
				if ($aujourdhui >= $article_cat["deb_promo"] && $aujourdhui <= $article_cat["fin_promo"]) {
					$prix_affiche = /*_CATALOGARTICLESPRIXPROMO.*/'<span class="barre">'.number_format((($article_cat["tarif_ht"])*(1+($article_cat["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro;</span>'
					.'<br />'
					.number_format((($article_cat["tarif_promo"])*(1+($article_cat["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro;';
					$prix = $article_cat["tarif_promo"]*(1+($article_cat["taux_tva"])/100);
				}
				if ($en_periode_solde && $article_cat["taux_solde"] != 0) {
					//if ($aujourdhui >= $article_cat["deb_solde"] && $aujourdhui <= $article_cat["fin_solde"]) {
					$prix_affiche = /*_CATALOGARTICLESPRIXSOLDE."-".$article_cat["taux_solde"].'% : '.*/'<span class="barre">'.number_format((($article_cat["tarif_ht"])*(1+($article_cat["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro;</span>'
					.'<br />'
					.number_format((($article_cat["tarif_ht"])*(1-($article_cat["taux_solde"])/100)*(1+($article_cat["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro;';
					$prix = number_format(($article_cat["tarif_ht"])*(1-($article_cat["taux_solde"])/100)*(1+($article_cat["taux_tva"])/100),2);
				}
				$tarif = $prix * $nbre;
				$total_tarif += $tarif;
				//$contenu .= "<p>$photo - $designation_ligne - $marque_ligne - $ref_ligne - $options_ligne - $prix_affiche - $inputs - $tarif</p>";
				$contenu .= '<tr><td>';
				$contenu .= $photo;
				$contenu .= '</td><td width="20"></td><td class="design">';
				$contenu .= $marque_ligne.$designation_ligne.$options_ligne;
				$contenu .= '</td><td width="20"></td><td>';
				$contenu .= $ref_ligne;
				$contenu .= '</td><td width="20"></td><td align="right" nowrap="nowrap">';
				$contenu .= $prix_affiche;
				$contenu .= '</td><td width="20"></td><td align="center">';
				$contenu .= $inputs;
				$contenu .= '</td><td width="20"></td><td align="right" nowrap="nowrap">';
				$contenu .= number_format($tarif, 2 , ","," ").' &euro;';
				$contenu .= '</td><td width="20"></td><td>';
				$contenu .= '<a href="javascript:suppr_article('.$compteur.')" title="'._CATALOGARTICLESSUPPR.'">';
				$contenu .= '<img src="'.$this->get_picto_url($vars_mod,"suppr.gif").'" alt="'._CATALOGARTICLESSUPPR.'" border="0" class="noprint" />';
				$contenu .= '</a>';
				$contenu .= '</td></tr>';
				$contenu .= '<tr><td colspan="13" class="separation"><hr /></td></tr>';
				//$contenu .= '<tr><td colspan="11" class="separation"><hr /></td><td width="20"></td><td></td></tr>';
				$compteur++;
			}
			$contenu .= '<tr><td colspan="9" align="right" class="design">';
			$contenu .= _CATALOGTOTALTTCCADDIE;
			$contenu .= '</td><td width="20"></td><td class="design" align="right" nowrap="nowrap">';
			$contenu .= number_format($total_tarif, 2 , ","," ").'&nbsp;&euro;';
			$contenu .= '<td width="20"></td><td></td>';
			$contenu .= '</td></tr>';
			$contenu .= '</table>';
		}
		else {
			$contenu = '<p class="alerte">'._CATALOGEMPTYCADDIE.'</p>';
		}
		if ($_SESSION["caddie"] != "") {
			$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="actions">';
			$contenu .= '<tr><td>';
			$contenu .= '<input type="button" value="'._CATALOGCADDIEBACK.'" name="retour" onclick="window.location.href=\''.$_SESSION["last_search"].'\'" class="noprint" />';
			$contenu .= '</td><td align="right">';
			$contenu .= '<input type="submit" name="validation" value="'._CATALOGUPDATECADDIE.'" class="noprint" />';
			$contenu .= '</td></tr>';
			$contenu .= '<tr><td colspan="2" align="center">';
			if ($livraison_possible) {
				$contenu .= '<input type="button" value="'._CATALOGCADDIEEND.'" name="commande" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=set_client_caddie\'" class="noprint" >';
			}
			else {
				$contenu .= "<div style=\"width: 60%;\">&nbsp;<br />"._COMMANDNOTPOSSIBLE."</div>";
			}
			$contenu .= '</td></tr>';
			$contenu .= '</table>';
		}
		else {
			$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="actions">';
			$contenu .= '<tr><td align="center">';
			$contenu .= '<input type="button" value="'._CATALOGCADDIEBACK.'" name="retour" onclick="window.location.href=\''.$_SESSION["last_search"].'\'" class="noprint" />';
			$contenu .= '</td></tr>';
			$contenu .= '</table>';
		}

		$sortie = $stylecatalog.
		'<div class="catalog">
			<!--<h1>'._CATALOGCADDIECONTENT.'</h1>-->
			<h1>'._CATALOGCADDIEVERIF.'</h1>
			'.$this->command_bar($My_SQL,$vars_mod,0).'
			<form action="modules.php?name='.$module_name.'&sop=update_caddie" method="POST" name="caddie">
			'.$contenu.'
			</form>
		</div>
<script type="text/javascript">
	function suppr_article(ligne) {
		if (document.forms["caddie"].elements["caddie_nbre[]"].length) {
			document.forms["caddie"].elements["caddie_nbre[]"][ligne].value = "0";
		}
		else {
			document.forms["caddie"].elements["caddie_nbre[]"].value = "0";
		}
		document.forms["caddie"].submit();
	}
</script>';
		return $sortie;
	}

	/**
	 * Renvoie le contenu du caddie non modifiable.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML affichant le contenu du caddie.
	 */
	function affiche_caddie($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps, $nukeurl;

		$aujourdhui = date("Y-m-d");
		$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
		$en_periode_solde = false;
		foreach($periodes_soldes as $periode_solde) {
			if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
				$en_periode_solde = true;
			}
		}
		if (!isset($_SESSION["caddie"])) {
			$_SESSION["caddie"] = "";
		}

		if ($_SESSION["caddie"] != "") {
			switch ($currentlang) {
				case "italian" :
					$suffixe = "_I";
					break;
				case "french" :
					$suffixe = "_F";
					break;
				case "spanish" :
					$suffixe = "_S";
					break;
				case "english" :
					$suffixe = "_E";
					break;
				case "german" :
					$suffixe = "_A";
					break;
			}
			$articles = explode($seps["sep_article"],$_SESSION["caddie"]);
			$inputs = '<input type="hidden" value="modif" name="op_caddie">';
			$total_tarif = 0;
			$contenu = '<h2>'._CATALOGClIENTCOMMAND.'</h2>';
			$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="listearticles">';
			$contenu .= '<tr><td class="design" align="center" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIEARTICLE;
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIEREFERENCE;
			$contenu .= '</td><td width="20"></td><td class="design" align="right" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIEPU;
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIEQUANTITE;
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIETAUXTVA;
			$contenu .= '</td><td width="20"></td><td class="design" align="center" nowrap="nowrap">';
			$contenu .= _CATALOGCADDIETARIF;
			$contenu .= '</td></tr>';
			$contenu .= '<tr><td colspan="11" class="separation"><hr /></td></tr>';
			$total_HT = 0; $total_TVA = 0; $total_TTC = 0;
			foreach($articles as $article) {
				list($Id,$nbre,$options_str) = explode($seps["sep_champ"],$article);
				if (!$this->is_delivrable($My_SQL,$vars_mod,$Id)) {
					$racine = "";
					/*$tab_serveur = parse_url($nukeurl);
					$racine = $tab_serveur["scheme"]."://";
					if ($tab_serveur["user"] != "") {
						$racine .= $tab_serveur["user"];
					}
					if ($tab_serveur["pass"] != "") {
						$racine .= ":".$tab_serveur["pass"];
					}
					if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
						$racine .= "@";
					}
					$racine .= $tab_serveur["host"];
					if ($tab_serveur["port"] != "") {
						$racine .= ":".$tab_serveur["port"];
					}*/
					$lien = $racine."/modules.php?name=$module_name&sop=display_caddie";
					Header("Location: ".$lien);
				}
				$options_ligne = "";
				if ($options_str !="") {
					$options = explode($seps["sep_option"],$options_str);
					foreach($options as $option) {
						list($key,$value) = explode($seps["sep_valeur"],$option);
						if ($options_ligne != "") {
							$options_ligne .= " - ";
						}
						$options_ligne .= $key." : ".$value;
					}
					$options_ligne = "<br>".$options_ligne;
				}
				$articles_cat = $this->sgbd->getArticles($My_SQL,$Id);
				$article_cat = $articles_cat[0];
				$designation_ligne = $article_cat["designation".$suffixe];
				if ($article_cat["marque"] != '') {
					$marque_ligne = $article_cat["marque"]." - ";
				}
				else {
					$marque_ligne = "";
				}
				if ($article_cat["ref_article"] != '') {
					$ref_ligne = $article_cat["ref_article"];
				}
				else {
					$ref_ligne = "";
				}
				$prix_HT = $article_cat["tarif_ht"];
				if ($aujourdhui >= $article_cat["deb_promo"] && $aujourdhui <= $article_cat["fin_promo"]) {
					$prix_HT = $article_cat["tarif_promo"];
				}
				if ($en_periode_solde && $article_cat["taux_solde"] != 0) {
					//if ($aujourdhui >= $article_cat["deb_solde"] && $aujourdhui <= $article_cat["fin_solde"]) {
					$prix_HT = number_format(($article_cat["tarif_ht"])*(1-($article_cat["taux_solde"])/100),2 , ".","");
				}
				$prix_affiche = number_format($prix_HT, 2 , ","," ").' &euro;';
				$tva = number_format(($prix_HT)*(($article_cat["taux_tva"])/100),2)*$nbre;
				$prix_HT = $prix_HT * $nbre;
				$prix_TTC = $prix_HT + $tva;

				$total_HT += $prix_HT;
				$total_TVA += $tva;
				$total_TTC += $prix_TTC;

				$tarif_affiche_HT = number_format($prix_HT, 2 , ","," ").'&nbsp;&euro;';
				$tva_affiche = number_format($article_cat["taux_tva"], 2 , ","," ").' %';

				//$contenu .= "<p>$photo - $designation_ligne - $marque_ligne - $ref_ligne - $options_ligne - $prix_affiche - $inputs - $tarif</p>";
				$contenu .= '<tr><td class="design">';
				$contenu .= $marque_ligne.$designation_ligne.$options_ligne;
				$contenu .= '</td><td width="20"></td><td>';
				$contenu .= $ref_ligne;
				$contenu .= '</td><td width="20"></td><td align="right" nowrap="nowrap">';
				$contenu .= $prix_affiche;
				$contenu .= '</td><td width="20"></td><td align="center">';
				$contenu .= $nbre;
				$contenu .= '</td><td width="20"></td><td align="right" nowrap="nowrap">';
				$contenu .= $tva_affiche;
				$contenu .= '</td><td width="20"></td><td align="right" nowrap="nowrap">';
				$contenu .= $tarif_affiche_HT;
				$contenu .= '</td></tr>';
				$contenu .= '<tr><td colspan="11" class="separation"><hr /></td></tr>';
			}
				
			$total_reduc = 0;
				
			if ($_SESSION["code_s_promo"] != "") {
				$promos = $this->sgbd_promo->getPromo($My_SQL,"",$_SESSION["code_s_promo"]);
				if (count($promos) != 0) {
					$promo = $promos[0];
				}
				else {
					$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
				}
			}
			else {
				$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
			}
			if ($promo["Id"] != "-1") {
				$aujourdhui = date("Y-m-d");
				if (($promo["debut"] <= $aujourdhui && $promo["fin"] >= $aujourdhui) || ($promo["debut"] <= $aujourdhui && $promo["fin"] == "0000-00-00") || ($promo["debut"] == "0000-00-00" && $promo["fin"] >= $aujourdhui)  || ($promo["debut"] == "0000-00-00" && $promo["fin"] == "0000-00-00")) {
					if ($promo["multiple"] == "1") {
						$promovalide = true;
					}
					else {
						$comm_client_promo = $this->sgbd->getCommandes($My_SQL,"",$_SESSION["id_s_client"],"",$promo["code"]);//vrif usage unique
						if (count($comm_client_promo) == 0) {
							$promovalide = true;
						}
						else {
							$promovalide = false;
						}
					}
					if ($promovalide) {
						$pourcent = $promo["pourcent"];
						$somme = $promo["somme"];
						$noport = $promo["noport"];
						$seuil = $promo["seuil"];
					}
					else {
						$pourcent = 0;
						$somme = 0;
						$noport = 0;
						$seuil = 0;
					}
				}
				else {
					$pourcent = 0;
					$somme = 0;
					$noport = 0;
					$seuil = 0;
				}
			}
			else {
				$pourcent = 0;
				$somme = 0;
				$noport = 0;
				$seuil = 0;
			}
				
			if ($_SESSION["id_port"] != "-1") {
				$ports = $this->sgbd->getPorts($My_SQL,$_SESSION["id_port"]);
				if ($ports[0]["seuilfranco"] != 0 && $ports[0]["seuilfranco"] <= $total_HT ) {
					$port_HT = 0 ;
				}
				else {
					$port_HT = $ports[0]["tarif"];
				}
				$port_TVA = number_format($port_HT*$ports[0]["tva"]/100,2 , ".","");
				$port_TTC = $port_HT + number_format($port_HT*$ports[0]["tva"]/100,2 , ".","");
			}
			else {
				$port_HT = "-1";
				$port_TVA = 0;
				$port_TTC = 0;
			}
			if ($noport == "1") {
				if ($seuil <= $total_HT) {
					$total_reduc += $port_TTC;
					$port_HT = 0;
					$port_TVA = 0;
					$port_TTC = 0;
				}
			}
			$reduc_HT = 0;
			$reduc_TVA = 0;
			if ($pourcent != 0) {
				if ($seuil <= $total_HT) {
					$reduc_HT = "-".number_format($total_HT*$pourcent/100,2 , ".","");
					$reduc_TVA = "-".number_format($total_TVA*$pourcent/100,2 , ".","");
				}
			}
			if ($somme != 0) {
				if ($seuil <= $total_HT) {
					$reduc_HT += "-".number_format($somme,2 , ".","");
				}
			}
			$reduc_TTC = $reduc_HT + $reduc_TVA;
				
			if ($total_HT + $total_TVA + $reduc_TTC < 0) {
				$reduc_HT = -($total_HT + $total_TVA);
				$reduc_TTC = $reduc_HT + $reduc_TVA;
			}
				
			$total_reduc -= $reduc_TTC;
				
			$_SESSION["total_caddie_ht"] = $total_HT;
			$total_HT_affiche = number_format($total_HT, 2 , ","," ").'&nbsp;&euro;';
			$port_HT_affiche = number_format($port_HT, 2 , ","," ").'&nbsp;&euro;';
			$total_TVA_affiche = number_format($total_TVA + $port_TVA + $reduc_TVA, 2 , ","," ").'&nbsp;&euro;';
			$total_TTC_affiche = number_format($total_TTC + $port_TTC + $reduc_TTC, 2 , ","," ").'&nbsp;&euro;';
			$reduc_HT_affiche = number_format($reduc_HT, 2 , ","," ").'&nbsp;&euro;';
				
			$contenu .= '<tr><td colspan="10" align="right" style="padding-right: 10px">';
			$contenu .= _CATALOGTOTALHTCADDIE.'</td><td align="right" nowrap="nowrap">'.$total_HT_affiche;
			$contenu .= '</td></tr>';
			if ($reduc_HT != "0") {
				$contenu .= '<tr><td colspan="10" align="right" style="padding-right: 10px">';
				$contenu .= _CATALOGTOTALREDUCCADDIE.'</td><td align="right" nowrap="nowrap">'.$reduc_HT_affiche;
				$contenu .= '</td></tr>';
			}
			if ($port_HT != "-1") {
				$contenu .= '<tr><td colspan="10" align="right" style="padding-right: 10px">';
				$contenu .= _CATALOGTOTALPORTCADDIE.'</td><td align="right" nowrap="nowrap">'.$port_HT_affiche;
				$contenu .= '</td></tr>';
			}
			$contenu .= '<tr><td colspan="10" align="right" style="padding-right: 10px">';
			$contenu .= _CATALOGTOTALTVACADDIE.'</td><td align="right" nowrap="nowrap">'.$total_TVA_affiche;
			$contenu .= '</td></tr>';
			$contenu .= '<tr><td colspan="10" align="right" class="design" style="padding-right: 10px">';
			$contenu .= _CATALOGTOTALTTCCOMMANDE.'</td><td align="right" class="design" nowrap="nowrap">'.$total_TTC_affiche;
			$contenu .= '</td></tr>';
			$contenu .= '<tr><td colspan="11" class="separation"><hr /></td></tr>';
			if ($total_reduc != 0 && $promovalide && $promo["Id"] != "-1") {
				$contenu .= '<tr><td colspan="11" class="design" align="center">'._CATALOGPROMOTOTALREDUC.number_format($total_reduc, 2 , ","," ").'&nbsp;&euro;</td></tr>';
				$contenu .= '<tr><td colspan="11" class="separation"><hr /></td></tr>';
			}
			$contenu .= '</table>';
			//$_SESSION["paie-total"] = floor(($total_TTC + $port_TTC + $reduc_TTC)*100);
			$_SESSION["paie-total"] = number_format($total_TTC + $port_TTC + $reduc_TTC, 2 , ".","")*100;
		}
		else {
			$contenu = '<p class="alerte">'._CATALOGEMPTYCADDIE.'</p>';
		}
		return $contenu;
	}

	/**
	 * Renvoie les coordonnes du client et le contenu du caddie non modifiable.
	 *
	 * Cet cran permet d'accepter les Conditions Gnrales de Vente et de valider la commande.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @return string Formulaire HTML affichant la demande de confirmation de commande.
	 */
	function affiche_client_caddie($My_SQL,$vars_mod,$clef) {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$marques = array("","","");
		if ($_SESSION["caddie"] != "") {
			if ($_SESSION["id_port"] != "-1") {
				if ($_SESSION["id_reglement"] != "-1") {
					$marques[2] = "ici";
				}
				else {
					$marques[1] = "ici";
				}
			}
			else {
				$marques[0] = "ici";
			}
		}

		$sortie = $stylecatalog;
		$leclient = $this->affiche_client($My_SQL,$vars_mod,$clef);
		$leclient .= '<table border="0" cellpadding="0" cellspacing="0" class="listearticles"><tr><td colspan="11" class="separation"><hr /></td></tr></table>';
		$lecaddie .= $this->affiche_caddie($My_SQL,$vars_mod);

		$client = $this->get_client($My_SQL,$vars_mod,$clef);

		$ports = $this->sgbd->getPorts($My_SQL, "", $client["pays"]);
		$portsdispo = '<table border="0" cellspacing="0" cellpadding="0" class="transport">';
		$portsdispo .= '<tr><th colspan="2"></th><th>Tarif</th><th>Dlai (jours)</th></tr>';
		foreach($ports as $port) {
			if ($port["seuilfranco"] != 0) {
				$portfranco = str_replace("<!--HT-->",number_format($port["seuilfranco"], 2 , ","," ") ,_CLIENTCATALOGPORTFREE);
			}
			else {
				$portfranco = "";
			}
			if ($_SESSION["id_port"] == $port["Id"]) {
				$checked = ' checked="checked"';
			}
			else {
				$checked = '';
			}
			$portsdispo .= '<tr><td><input type="radio" name="choixport" value="'.$port["Id"].'"'.$checked.' onclick="this.form.submit()" /></td><td class="design">'.$port["designation"].$portfranco.'</td><td align="center">'.number_format(($port["tarif"]*(1+$port["tva"]/100)),2,","," ").' &euro;</td><td align="center">'.$port["delai"].'</td></tr>';
		}
		$portsdispo .= '</table>';
		if ($_SESSION["caddie"] != "") {
			$choosedeliv = '
				<h2>'._CLIENTCATALOGPORT.'</h2>
				<div align="center">
				<form method="post" action="modules.php?name='.$module_name.'&sop=set_client_caddie#ici" name="formfiche2" onsubmit="return valid2(this)">'
				.$portsdispo.
				'<!--<p>&nbsp;<br /><input type="submit" value="'._CLIENTCATALOGCHOOSEPORT.'" name="validp"></p>-->
				</form>
				</div>
				<table border="0" cellpadding="0" cellspacing="0" class="listearticles"><tr><td colspan="11" class="separation"><hr /></td></tr></table>';
		}
		else {
			$choosedeliv = '';
		}

		if ($_SESSION["id_port"] != "-1" && $_SESSION["caddie"] != "") {
			$reglementsdispo = '<table border="0" cellspacing="0" cellpadding="0" class="transport">';
			$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
				
			//A virer
			/*global $admin;
			if (is_admin($admin)) {
			$reglements[(count($reglements)-1)] = "Carte bleue de test !";
			}*/
			//fin a virer
				
			for($i=0;$i<count($reglements);$i++) {
				if ($reglements[$i] != "-") {
					if ($_SESSION["id_reglement"] == $i) {
						$checked = ' checked="checked"';
					}
					else {
						$checked = '';
					}
					$reglementsdispo .= '<tr><td><input type="radio" name="choixreglement" value="'.$i.'"'.$checked.' onclick="this.form.submit()" /></td><td class="design">'.$reglements[$i].'</td></tr>';
				}
			}
				
			$reglementsdispo .= '</table>';
			$choosereglement = '
				<h2><a name='.$marques[1].'></a>'._CLIENTCATALOGREGLEMENT.'</h2>
				<div align="center">
				<form method="post" action="modules.php?name='.$module_name.'&sop=set_client_caddie#ici" name="formfiche3" onsubmit="return valid3(this)">'
				.$reglementsdispo.
				'<!--<p>&nbsp;<br /><input type="submit" value="'._CLIENTCATALOGCHOOSEREGLEMENT.'" name="validr"></p>-->
				</form>
				</div>
				<table border="0" cellpadding="0" cellspacing="0" class="listearticles"><tr><td colspan="11" class="separation"><hr /></td></tr></table>';
		}


		if ($_SESSION["id_port"] != "-1" && $_SESSION["caddie"] != "" && $_SESSION["id_reglement"] != "-1") {
			if ($_SESSION["id_reglement"] == (count($reglements)-1)) { //Rglement Carte Bleue
				$titrepaiment = _CLIENTCATALOGPAYMENTCB;
				$url_paiement = '"modules.php?name='.$module_name.'&sop=go_to_pay"';
				if ($_SESSION["paie-refcomm"] == "") {
					$_SESSION["paie-refcomm"] = md5($client["email"].date("YzHis"));
				}
				$_SESSION["paie-porteur"] = $client["email"];
			}
			if ($_SESSION["id_reglement"] == (count($reglements)-2)) { //Rglement Paypal
				$titrepaiment = _CLIENTCATALOGPAYMENTCB;
				$url_paiement = '"modules.php?name='.$module_name.'&sop=go_to_paypal"';
				if ($_SESSION["paie-refcomm"] == "") {
					$_SESSION["paie-refcomm"] = md5($client["email"].date("YzHis"));
				}
				$_SESSION["paie-porteur"] = $client["email"];
			}
			else {
				$titrepaiment = _CLIENTCATALOGPAYMENT;
				$url_paiement = '"modules.php?name='.$module_name.'&sop=command_paid"';
			}
			$acceptecond = '
				<div class="noprint">
				<h2><a name='.$marques[2].'></a>'.$titrepaiment.'</h2>
				<p>'._CLIENTCATALOGBEFOREVALIDCGV.'</p>
				<!--<form method="post" action='.$url_paiement.' name="formfiche" onsubmit="return valid(this)">-->
				<form method="post" action='.$url_paiement.' name="formfiche" onsubmit="return valid(this)">
				<div align= "center">
				<table border="0" cellpadding="0" cellspacing="0" class="coords"><tr>
				<td>'._CLIENTCATALOGREMCOMMAND.'</td>
				</tr><tr>
				<td><textarea name="remarques" rows="4" class="saisie_grand">'.$_SESSION["lesremarques"].'</textarea></td>
				</tr></table>
				</div>
				<p class="actions"><input type="checkbox" name="validcgv" value="1"> '._CLIENTCATALOGVALIDCGV.'<br />&nbsp;<br />
				<input type="submit" value="'._CLIENTCATALOGGOTOPAY.'" name="validc"></p>
				</form>
				</div>';
		}
		else {
			$acceptecond = '';
		}

		if ($vars_mod["use_code_promo"]) {
			$descr_promo = "&nbsp;";
			if ($_SESSION["code_s_promo"] != "") {
				$promos = $this->sgbd_promo->getPromo($My_SQL,"",$_SESSION["code_s_promo"]);
				if (count($promos) != 0) {
					$promo = $promos[0];
					$aujourdhui = date("Y-m-d");
					if (($promo["debut"] <= $aujourdhui && $promo["fin"] >= $aujourdhui) || ($promo["debut"] <= $aujourdhui && $promo["fin"] == "0000-00-00") || ($promo["debut"] == "0000-00-00" && $promo["fin"] >= $aujourdhui)  || ($promo["debut"] == "0000-00-00" && $promo["fin"] == "0000-00-00")) {
						$comm_client_promo = $this->sgbd->getCommandes($My_SQL,"",$_SESSION["id_s_client"],"",$promo["code"]);//vrif usage unique
						if (count($comm_client_promo) == 0 || $promo["multiple"] == "1") {
							//decrire l'action de la promo ici
							$descr_promo = "";
							$descr_seuil = "";
							if ($promo["seuil"] != 0) {
								$descr_seuil .= str_replace("<!--seuil-->",$promo["seuil"],_CATALOGPROMOFROMMONEY);
							}
							if ($promo["pourcent"] != 0) {
								$descr_promo .= str_replace("<!--pourcent-->",$promo["pourcent"],_CATALOGPROMOPERCENT).$descr_seuil.".";
							}
							if ($promo["somme"] != 0) {
								$descr_promo .= str_replace("<!--somme-->",$promo["somme"],_CATALOGPROMOMONEYFIX).$descr_seuil.".";
							}
							if ($promo["noport"] != 0) {
								$descr_promo .= _CATALOGPROMONOPORT.$descr_seuil.".";
							}
								
						}
						else {
							$descr_promo = _CATALOGPROMOONLYONCE;
						}
					}
					else {
						$descr_promo = _CATALOGPROMOVALID;
						if ($promo["debut"] != "0000-00-00") {
							$descr_promo .= _CATALOGPROMOVALIDFROM.adminCatalog::date2JMA($promo["debut"]);
						}
						if ($promo["fin"] != "0000-00-00") {
							$descr_promo .= _CATALOGPROMOVALIDTO.adminCatalog::date2JMA($promo["fin"]);
						}
					}
				}
				else {
					$descr_promo = _CATALOGPROMOBADCODE;
				}
			}
				
			$promo = '
			<h2>'._CLIENTCATALOGPROMO.'</h2>
			<div align="center">
			<table border="0" cellpadding="0" cellspacing="0" class="promo">
			<tr>
			<td align="center"><p class="actions">'._CLIENTCATALOGIFPROMO.'<br />&nbsp;</p></td>
			</tr>
			<tr>
			<td align="center">
			<form method="post" action="modules.php?name='.$module_name.'&sop=set_client_caddie#ici" name="formfiche4">
			<table border="0" cellpadding="0" cellspacing="0" class="coords"><tr>
			<td>'._CLIENTCATALOGCODEPROMO.'</td>
			<td width="20"></td>
			<td><input type="text" name="promo_code" value="'.$_SESSION["code_s_promo"].'" class="saisie" /></td>
			<td width="20"></td>
			<td><input type="submit" value="'._CLIENTCATALOGVALIDCODEPROMO.'" name="validpromo" /></td>
			</tr></table>
			</form>
			</td>
			</tr>
			<tr><td class="design">'.$descr_promo.'</td></tr>
			</table>
			</div>
			<table border="0" cellpadding="0" cellspacing="0" class="listearticles"><tr><td colspan="11" class="separation"><hr /></td></tr></table>';
		}
		else {
			$promo = "";
		}

		$contenu = $stylecatalog.
		'<div class="catalog">
			<h1>'._CATALOGCADDIEVERIF.'</h1>
			'.$this->command_bar($My_SQL,$vars_mod).'
			'.$leclient.'
			'.$promo.'
			'.$choosedeliv.'
			'.$lecaddie.'
			'.$choosereglement.'
			'.$acceptecond.'
		</div>
<script type="text/javascript">
	function valid3(formulaire) {
		if (formulaire.choixreglement.length) {
			for (var i=0; i<formulaire.choixreglement.length; i++) {
				if (formulaire.choixreglement[i].checked) {
					return true;
				}
			}
		}
		else {
			if (formulaire.choixreglement.checked) {
				return true;
			}
		}
		alert("'._CLIENTCATALOGNOTVALIDREGLEMENT.'");
		return false;
	}
	function valid2(formulaire) {
		if (formulaire.choixport.length) {
			for (var i=0; i<formulaire.choixport.length; i++) {
				if (formulaire.choixport[i].checked) {
					return true;
				}
			}
		}
		else {
			if (formulaire.choixport.checked) {
				return true;
			}
		}
		alert("'._CLIENTCATALOGNOTVALIDPORT.'");
		return false;
	}
	function valid(formulaire) {
		if (!formulaire.validcgv.checked) {
			alert("'._CLIENTCATALOGNOTVALIDCGV.'");
			return false;
		}
		return true;
	}
</script>
';
		return $contenu;
	}

	/**
	 * Renvoie les coordonnes du compte client.
	 *
	 * Cet cran est affich juste aprs l'identification du client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @return string Code HTML affichant les coordonnes du client.
	 */
	function affiche_client_seul($My_SQL,$vars_mod,$clef) {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$sortie = $stylecatalog;
		$sortie .= $this->affiche_client($My_SQL,$vars_mod,$clef);

		$contenu = '<div class="catalog">
			<h1>'._CATALOGClIENTACCOUNT.'</h1>
			'.$sortie.'
		</div>';
		return $contenu;
	}

	/**
	 * Renvoie le nom du pays correspondant au code dans la langue courante.
	 *
	 * Cette fonction est utilise par les fonction de plus haut niveau.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param string $codePays Code du pays recherch.
	 * @return string Code Nom du pays en ASCII.
	 */
	function code2pays($My_SQL,$codePays,$idcommtemp="") {
		global $currentlang;
		if ($idcommtemp == "") {
			$langueencours = $currentlang;
		}
		else {
			$commtemps = $this->sgbd->getCommandesTemp($My_SQL,$idcommtemp);
			$commtemp = $commtemps[0];
			$langueencours = $commtemp["lang_client"];
		}
		switch ($langueencours) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}
		$payss = $this->sgbd->getPays($My_SQL,"",$codePays);
		$pays = $payss[0];
		return $pays["pays".$suffixe];
	}

	/**
	 * Renvoie un bloc HTML contenant les coordonnes du compte client.
	 *
	 * Cette fonction est utilise par les fonction de plus haut niveau.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @return string Code HTML affichant les coordonnes du client.
	 */
	function affiche_client($My_SQL,$vars_mod,$clef) {
		$client = $this->get_client($My_SQL,$vars_mod,$clef);
		if (count($client) != 0) {
			$civilites = explode("//",_CLIENTCIVILITES);
			if ($client["civilite"] != 0){
				$civilite = $civilites[$client["civilite"]]." ";
			}
			else {
				$civilite = "";
			}
			$coords_client = $civilite.$client["prenom"]." ".$client["nom"];
			if ($client["societe"] != "") {
				$coords_client .= "<br />".$client["societe"];
			}
			if ($client["adresse"] != "") {
				$coords_client .= "<br />".$client["adresse"];
			}
			$coords_client .= "<br />".$client["codepostal"]." ".$client["ville"];
			if ($client["pays"] != "") {
				$coords_client .= "<br />".$this->code2pays($My_SQL,$client["pays"]);
			}
			$contacts_client = "";
			if ($client["tel"] != "") {
				$contacts_client .= _CLIENTTELEDIT.$client["tel"];
			}
			if ($client["fax"] != "") {
				if ($contacts_client != "") {
					$contacts_client .= "<br />";
				}
				$contacts_client .= _CLIENTFAXEDIT.$client["fax"];
			}
			if ($client["portable"] != "") {
				if ($contacts_client != "") {
					$contacts_client .= "<br />";
				}
				$contacts_client .= _CLIENTPORTABLEEDIT.$client["portable"];
			}
			if ($client["email"] != "") {
				if ($contacts_client != "") {
					$contacts_client .= "<br />";
				}
				$contacts_client .= _CLIENTEMAILEDIT.$client["email"];
			}
			$sortie = '<h2>'._CATALOGClIENTCOORDS.'</h2>';
			$sortie .= '<div align="center">';
			$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="coords">';
			$sortie .= '<tr><td valign="top">';
			$sortie .= $coords_client;
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td width="1" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= $contacts_client;
			$sortie .= '</td></tr>';
			$sortie .= '</table>';
			$sortie .= '</div>';
			return $sortie;
		}
		else {
			return "Erreur : client introuvable !";
		}
	}

	/**
	 * Enregistre les modifications du compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_client Tableau contenant les rubriques du compte client.
	 * @return boolean Rsultat de l'opration.
	 */
	function save_client($My_SQL,$vars_mod,$new_client) {
		$clef = array();
		$clef["codeclient"] = "";
		$clef["passwd"] = "";
		$clef["Id"] = $new_client["Id"];
		$client = $this->sgbd->getClient($My_SQL,$clef);
		$new_client["valide"] = $client["valide"];
		$new_client["divers"] = $client["divers"];
		$new_client["categorie"] = $client["categorie"];
		$new_client["codeconfirm"] = $client["codeconfirm"];
		$new_client["pageperso"] = $client["pageperso"];
		$new_client["datenaissance"] = adminCatalog::date2AMJ($new_client["datenaissance"]);
		return $this->sgbd->saveClient($My_SQL,$new_client);
	}

	/**
	 * Renvoie un tableau contenant les rubriques du compte client.
	 *
	 * Si le champ Id vaut "-1" ou "" et si passwd ou codeclient valent "", un tableau vide est renvoy.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @return boolean Tableau contenant le code client.
	 */
	function get_client($My_SQL,$vars_mod,$clef) {
		if ($clef["Id"] != "" && $clef["Id"] != "-1") {
			return $this->sgbd->getClient($My_SQL,$clef);
		}
		else {
			if ($clef["passwd"] != "" && $clef["codeclient"] != "") {
				return $this->sgbd->getClient($My_SQL,$clef);
			}
			else {
				//erreur
				return array();
			}
		}
	}

	/**
	 * Renvoie un formulaire permettant de crer ou modifier le compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_client Tableau contenant le compte client.
	 * @param string $erreur Erreur ayant empch l'ergistrement prcdent.
	 * @param string $alerte_code Erreur ayant empch l'enregistrement prcdent.
	 * @param string $operation Code permettant de dterminer l'opration dclenche lors de la validation du formulaire.
	 * @return string Formulaire HTML permettant de modifier le compte client.
	 */
	function edit_client($My_SQL,$vars_mod,$new_client,$erreur="",$alerte_code="",$operation="save_new_client") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		/*
		 if ($new_client["Id"] != "-1" || $new_client["codeclient"] != "") {
			$operation = "save_client";
			}
			*/

		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}

		$contenu = "";
		if ($erreur != "") {
			$contenu .= '<p class="alerte">'.$erreur.'<br />&nbsp;</p>';
		}
		if ($alerte_code != "") {
			$alerte_code = '<p class="alerte">'.$alerte_code.'</p>';
		}

		$pays = $this->sgbd->getPays($My_SQL,$suffixe);
		$menuPays = '<select name="pays" size="1" class="saisie_petit" onchange="testlivraisonpays(this)">
					<option value=""></option>';
		foreach($pays as $unpays) {
			if ($unpays["code"] == $new_client["pays"]){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuPays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays".$suffixe].'</option>';
		}
		$menuPays .= '</select>';

		$new_client["datenaissance"] = adminCatalog::date2JMA($new_client["datenaissance"]);
		$civilites = explode("//",_CLIENTCIVILITES);
		$menuCivilite = '<select name="civilite" size="1">';
		for ($i=0;$i<count($civilites);$i++) {
			if ($new_client["civilite"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuCivilite .= '<option value="'.$i.'"'.$selected.'>'.$civilites[$i].'</option>';
		}
		$menuCivilite .= '</select>';

		//pays livrs javascript
		$codespayslivres = array();
		$ports = $this->sgbd->getPorts($My_SQL, "", "");
		foreach($ports as $port) {
			$tabpays = explode($seps["sep_valeur"], $port["list_pays"]);
			foreach($tabpays as $codepays) {
				array_push($codespayslivres, $codepays);
			}
		}
		$codespayslivres = array_unique($codespayslivres);
		$tab_pays_js = '			var codepayslivres = new Array;';
		$i = 0;
		foreach($codespayslivres as $code) {
			$tab_pays_js .= '
			codepayslivres['.$i.'] = "'.$code.'";';
			$i++;
		}
		if ($new_client["newsletter"] == "1" || $new_client["Id"] == "-1") {
			$checked2 = ' checked="checked"';
		}
		else {
			$checked2 = '';
		}

		$contenu .= '<div align="center">
				<table border="0" cellpadding="0" cellspacing="0" class="setclient" id="left">
			      <tr>
			        <td style="vertical-align: top;">
			        <table style="text-align: left;" border="0" cellpadding="0" cellspacing="2" class="saisie">
			        	<tr>
			              <td style="width: 80px;">'._CLIENTCIVILITE.'</td>
			              <td>'.$menuCivilite.'</td>
			            </tr>
						<tr>
			              <td style="width: 80px;">'._CLIENTNOMEDIT.'</td>
			              <td><input type="text" name="nom" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["nom"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPRENOMEDIT.'</td>
			              <td><input type="text" name="prenom" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["prenom"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTSOCIETEEDIT.'</td>
			              <td><input type="text" name="societe" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["societe"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTADRESSEEDIT.'</td>
			              <td><textarea cols="20" rows="3" name="adresse" class="saisie_petit">'.adminCatalog::conditionnerFORM($new_client["adresse"]).'</textarea></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODEPOSTALEDIT.'</td>
			              <td><input type="text" name="codepostal" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["codepostal"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTVILLEEDIT.'</td>
			              <td><input type="text" name="ville" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["ville"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPAYSEDIT.'</td>
			              <td><!--<input type="text" name="pays" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["pays"]).'" />-->'.$menuPays.'</td>
			            </tr>
			            <!--<tr>
			              <td>'._CLIENTDIVERSEDIT.'</td>
			              <td></td>
			            </tr>-->
			        </table>
			        </td>
			        <td style="width: 30px;">&nbsp;</td>
			        <td style="vertical-align: top;">
			        <table border="0" cellpadding="0" cellspacing="2" class="saisie">
			            <tr>
			              <td style="width: 80px;">'._CLIENTTELEDIT.'</td>
			              <td><input type="text" name="tel" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["tel"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTFAXEDIT.'</td>
			              <td><input type="text" name="fax" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["fax"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPORTABLEEDIT.'</td>
			              <td><input type="text" name="portable" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["portable"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTEMAILEDIT.'</td>
			              <td><input type="text" name="email" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["email"]).'" onchange="this.form.codeclient.value=this.value" /></td>
			            </tr>
			            <!--<tr>
			              <td>'._CLIENTSERVICESEDIT.'</td>
			              <td><input type="text" name="services" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["services"]).'" /></td>
			            </tr>-->
						<tr>
			              <td colspan="2">'.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTANIVERSAIREEDIT.'</td>
			              <td><input type="text" name="datenaissance" class="saisie_petit" value="'.$new_client["datenaissance"].'" /></td>
			            </tr>
						<tr>
			              <td colspan="2">'.$alerte_code.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODECLIENTEDIT.'</td>
			              <td><input type="text" name="codeclient" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["codeclient"]).'" readonly="readonly" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASSCLIENTEDIT.'</td>
			              <td><input type="password" name="passwd" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASS2CLIENTEDIT.'</td>
			              <td><input type="password" name="passwd2" class="saisie_petit" value="'.adminCatalog::conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTNEWSLETTEREDIT.'</td>
			              <td><input name="newsletter" value="1" type="checkbox"'.$checked2.' /></td>
			            </tr>
						<!--<tr>
			              <td>'._CLIENTVALIDEEDIT.'</td>
			              <td><input type="text" name="valide" value="1" type="checkbox"'.$checked.' /></td>
			            </tr>-->
			        </table>
			        </td>
			      </tr>
			      <!--<tr>
			        <td colspan="3" rowspan="1">
			        <table border="0" cellpadding="0" cellspacing="2">
			            <tr>
			              <td><textarea cols="40" rows="4" name="divers" class="saisie_long">'.adminCatalog::conditionnerFORM($new_client["divers"]).'</textarea></td>
			            </tr>
			        </table>
			        <br>
			        </td>
			      </tr>-->
			      <tr>
			        <td colspan="3" style="text-align: center">&nbsp;<br />'._CLIENTREQUIREDEDIT.'<br />&nbsp;<br /><input type="hidden" value="'.$new_client["Id"].'" name="Id"><input name="validform" value="'._CLIENTSAVEEDIT.'" type="submit"></td>
			      </tr>
			  </table>
			</div>';
		if ($operation =="save_new_client_caddie") {
			$sortie = $stylecatalog.
		'<div class="catalog">
			<h1>'._CATALOGCADDIEVERIF.'</h1>
			'.$this->command_bar($My_SQL,$vars_mod,1);
		}
		else {
			$sortie = $stylecatalog.
		'<div class="catalog">
			<h1>'._CATALOGClIENTCOORDSEDIT.'</h1>';
		}
		$sortie .= '
			<form method="post" action="modules.php?name='.$module_name.'&sop='.$operation.'" onsubmit="return valid(this);" name="f_client">
			'.$contenu.'
			</form>
		</div>
<script type="text/javascript">
'.$tab_pays_js.'
	function testlivraisonpays(menu) {
		ok = false;
		for (var i=0;i<codepayslivres.length;i++) {
			if (codepayslivres[i] == menu.value || codepayslivres[i] == "") {
				ok = true;
			}
		}
		if (!ok) {
			alert("'._CATALOGClIENTBADCOUNTRY.'");
			menu.selectedIndex = 0;
		}
		return true;	
	}
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function valid(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.nom.value == "") {
			alert("'._CLIENTVERIFNOM.'");
			return false;
		}
		if (formulaire.prenom.value == "") {
			alert("'._CLIENTVERIFPRENOM.'");
			return false;
		}
		if (formulaire.codepostal.value == "") {
			alert("'._CLIENTVERIFCODEPOSTAL.'");
			return false;
		}
		if (formulaire.adresse.value == "") {
			alert("'._CLIENTVERIFADRESSE.'");
			return false;
		}
		if (formulaire.ville.value == "") {
			alert("'._CLIENTVERIFVILLE.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._CLIENTVERIFEMAILEMPTY.'");
			return false;
		}
		/*if ((formulaire.tel.value+formulaire.fax.value+formulaire.portable.value+formulaire.email.value) == "") {
			alert("'._CLIENTVERIFCONTACT.'");
			return false;
		}*/
		if (!validMail(formulaire.email.value)) {
			alert("'._CLIENTVERIFEMAIL.'");
			return false;
		}
		if (formulaire.pays.value =="") {
			alert("'._CLIENTVERIFPAYS.'");
			return false;
		}
		if (formulaire.codeclient.value != formulaire.email.value) {
			formulaire.codeclient.value = formulaire.email.value;
		}
		if (formulaire.passwd.value == "") {
			alert("'._CLIENTVERIFPASS.'");
			return false;
		}
		if (formulaire.passwd.value != formulaire.passwd2.value) {
			alert("'._CLIENTVERIF2PASS.'");
			return false;
		}
		return ok;
	}
</script>';
		return $sortie;
	}

	/**
	 * Renvoie un formulaire permettant de s'identifier avant de poursuivre la confirmation de la commande.
	 *
	 * Si aucun compte client n'existe, il permet d'ouvrir le formulaire de cration de compte.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'identification.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function set_client_caddie($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu .= '<p style="text-align :center">'._CATALOGClIENTIDENT.'<br>&nbsp;</p>';
		$contenu .= '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=get_client_caddie" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CATALOGClIENTCHOOSE;
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td width="1" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td  class="titre">';
		$contenu .= _CATALOGClIENTNEW;
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTID.'<br />';
		$contenu .= '<input type ="text" value="" name="codeclient" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTPASSWD.'<br />';
		$contenu .= '<input type ="password" value="" name="passwd" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td width="1" rowspan="2" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTARGUE;
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client\'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		$contenu .= '</td><td align="center">';
		$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client_caddie\'">';
		$contenu .= '</td></tr align="center">';
		$contenu .= '<tr><td colspan="5" height="20"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="1" background="'.$this->get_picto_url($vars_mod,"sephor.gif").'"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="10"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre">'._CATALOGClIENTFORGET.'</td></tr>';
		$contenu .= '<tr><td colspan="5" height="5"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre"><input type="button" value="'._CATALOGClIENTFIND.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=get_ids\'"></td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="catalog">
			<!--<h1>'._CATALOGClIENTCOORDS.'</h1>-->
			<h1>'._CATALOGCADDIEVERIF.'</h1>
			'.$this->command_bar($My_SQL,$vars_mod,1).'
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Renvoie un formulaire permettant de s'identifier si un compte client existe ou d'ouvrir le formulaire de cration de compte.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'identification.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function set_client($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=get_client" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CATALOGClIENTCHOOSE;
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td width="1" background="'.$this->get_picto_url($vars_mod,"servert.gif").'">';
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td  class="titre">';
		$contenu .= _CATALOGClIENTNEW;
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTID.'<br />';
		$contenu .= '<input type ="text" value="" name="codeclient" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTPASSWD.'<br />';
		$contenu .= '<input type ="password" value="" name="passwd" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td width="1" rowspan="2" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTARGUE;
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client\'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		$contenu .= '</td><td align="center">';
		$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client\'">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td colspan="5" height="20"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="1" background="'.$this->get_picto_url($vars_mod,"sephor.gif").'"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="10"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre">'._CATALOGClIENTFORGET.'</td></tr>';
		$contenu .= '<tr><td colspan="5" height="5"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre"><input type="button" value="'._CATALOGClIENTFIND.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=get_ids\'"></td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="catalog">
			<h1>'._CATALOGClIENTCOORDS.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Renvoie un formulaire permettant de rcuprer ses identifiants sur sa messagerie.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'expdition de l'e-mail.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function get_ids($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=send_ids" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CATALOGClIENTFORGETIDENT;
		$contenu .= '</td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTMAILIDENT.'<br />';
		$contenu .= '<input type ="text" value="'.adminCatalog::conditionnerFORM($vars_mod[$vars_mod["mailclient"]]).'" name="'.$vars_mod["mailclient"].'" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="catalog">
			<h1>'._CATALOGClIENTIDENTS.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Envoie les identifiants retrouvs ou un formulaire permettant de ressaisir son email.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function send_ids($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;
		if ($vars_mod[$vars_mod["mailclient"]] != "") {
			if ($this->check_email($vars_mod[$vars_mod["mailclient"]])) {
				$ids = $this->sgbd->get_client_ids($My_SQL,$vars_mod[$vars_mod["mailclient"]]);
				if (count($ids) != 0) {
					if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
						$stylecatalog = "";
					}
					else {
						$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
					';
					}
					$message = "";
					foreach ($ids as $clientids) {
						$messagetemp = _CATALOGMESSAGEGETCLIENTIDS;
						$messagetemp = str_replace("<!--nom-->",$clientids["nom"],$messagetemp);
						$messagetemp = str_replace("<!--prenom-->",$clientids["prenom"],$messagetemp);
						$messagetemp = str_replace("<!--codeclient-->",$clientids["codeclient"],$messagetemp);
						$messagetemp = str_replace("<!--passwd-->",$clientids["passwd"],$messagetemp);
						$message .= $messagetemp."\n\n";
					}
					$sujet = _CATALOGMESSAGESUBJECTCLIENTIDS;
					if ($this->send_email($vars_mod[$vars_mod["mailclient"]],$sujet,$message)) {
						//ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CATALOGMESSAGEGETIDSOK.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="catalog">
							<h1>'._CATALOGClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
					else {
						//pas ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CATALOGMESSAGEGETIDSERROR.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="catalog">
							<h1>'._CATALOGClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
				}
				else {
					$erreur = _CATALOGMESSAGEGETIDSERROR2;
					return $this->get_ids($My_SQL,$vars_mod,$erreur);
				}
			}
			else {
				$erreur = _CATALOGMESSAGEGETIDSERROR3;
				return $this->get_ids($My_SQL,$vars_mod,$erreur);
			}
		}
		else {
			$erreur = _CATALOGMESSAGEGETIDSERROR3;
			return $this->get_ids($My_SQL,$vars_mod,$erreur);
		}
	}

	/**
	 * Renvoie la barre des tapes de la validation d'une commande.
	 *
	 * Son contenu dpend de l'tat d'avancement de la commande
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * $param integer $etape Si une tape est fixe en dpit des renseignements saisis par le client, la barre est renvoye pour cette tape.
	 * @return string Barre des tapes.
	 */
	function command_bar($My_SQL,$vars_mod,$etape="") {
		global $module_name;

		$stylebar = array(' class="current_state"',"","","","");
		if ($_SESSION["caddie"] != "") {
			$stylebar = array("",' class="current_state"',"","","");
		}
		if ($_SESSION["id_s_client"] != "" && $_SESSION["id_s_client"] != "-1") {
			$stylebar = array("","",' class="current_state"',"","");
		}
		if ($_SESSION["id_port"] != "" && $_SESSION["id_port"] != "-1") {
			$stylebar = array("","","",' class="current_state"',"");
		}
		if ($_SESSION["id_reglement"] != "" && $_SESSION["id_reglement"] != "-1") {
			$stylebar = array("","","","",' class="current_state"');
		}
		if ($etape !== "") {
			$stylebar = array("","","","","");
			$stylebar[$etape] = ' class="current_state"';
		}

		$barre = '<table cellpadding="0" cellspacing="0" border="0" class="commandstate" align="center"><tr>';
		$barre .= '<td'.$stylebar[0].'>Caddie</td>';
		$barre .= '<td class="separation"><div><hr /></div></td>';
		$barre .= '<td'.$stylebar[1].'>Identification</td>';
		$barre .= '<td class="separation"><hr /></td>';
		$barre .= '<td'.$stylebar[2].'>Livraison</td>';
		$barre .= '<td class="separation"><hr /></td>';
		$barre .= '<td'.$stylebar[3].'>Paiement</td>';
		$barre .= '<td class="separation"><hr /></td>';
		$barre .= '<td'.$stylebar[4].'>Confirmation</td>';
		$barre .= '</tr></table>&nbsp;';

		return $barre;
	}

	/**
	 * Renvoie le menu permettant d'excuter des actions lies au catalogue.
	 *
	 * Son contenu dpend de l'tat de l'identification du client
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Barre des actions.
	 */
	function catalog_bar($My_SQL,$vars_mod) {
		global $module_name;

		$barre .= '<table cellpadding="0" cellspacing="0" border="0" class="catalogbar" align="center"><tr>';
		$barre .= '<td>';
		if ($_SESSION["id_s_client"] == "") {
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=set_client">'._CATALOGBARACCOUNT.'</a>';
		}
		else {
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=close_client">'._CATALOGBARACCOUNTCLOSE.'</a>';
		}
		$barre .= '</td><td>';
		$barre .= '&nbsp;|&nbsp;';
		if ($_SESSION["id_s_client"] != "") {
			$barre .= '</td><td>';
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=edit_client">'._CATALOGBARACCOUNTCHANGE.'</a>';
			$barre .= '</td><td>';
			$barre .= '&nbsp;|&nbsp;';
		}
		$barre .= '</td><td>';
		$barre .= '<a href="modules.php?name='.$module_name.'&sop=display_caddie">'._CATALOGBARSHOWCADDIE.'</a>';
		if ($_SESSION["id_s_client"] != "") {
			$barre .= '</td><td>';
			$barre .= '&nbsp;|&nbsp;';
			$barre .= '</td><td>';
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=display_all_commands">'._CATALOGBARSAVEDCOMMAND.'</a>';
		}
		$barre .= '</td><td>';
		$barre .= '&nbsp;|&nbsp;';
		$barre .= '</td><td>';
		$barre .= '<a href="modules.php?name='.$module_name.'">'._CATALOGBARBACKTOCATALOG.'</a>';
		$barre .= '</td>';
		$barre .= '</tr></table>&nbsp;<br />';

		return $barre;
	}

	/**
	 * Expdie un e-mail de confirmation lors de la cration ou de la modification d'un compte client.
	 *
	 * Si le message n'a pu tre envoy, un message d'erreur est renvoy.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @param string $subject Sujet du message expdi.
	 * @param string $message Corps du message expdi.
	 * @return string Vide si le message a t expdi, message d'erreur sinon.
	 */
	function confirm_client($My_SQL,$vars_mod,$clef,$subject,$message) {
		$client = $this->sgbd->getClient($My_SQL,$clef);
		$message = str_replace("<!--nom-->",$client["nom"],$message);
		$message = str_replace("<!--prenom-->",$client["prenom"],$message);
		$message = str_replace("<!--codeclient-->",$client["codeclient"],$message);
		$message = str_replace("<!--passwd-->",$client["passwd"],$message);

		$email = $client["prenom"]." ".$client["nom"]." <".$client["email"].">";


		if ($this->send_email($email, $subject, $message)) {
			return "";
		}
		else {
			return '<p class="alerte">'._CATALOGMESSAGEERROR.'</p>';
		}
	}

	/**
	 * Vrification de la syntaxe d'un e-mail.
	 * @param string $adresse Adresse d'expdition de l'e-mail.
	 * @return boolean True si la syntaxe est correcte, false sinon.
	 */
	function check_email($adresse) {
		$Syntaxe='^[a-z0-9]+[a-z0-9?.+-_\']*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]{2,25}$';
		if(preg_match("#".$Syntaxe."#i",$adresse)) {
			return true;
		}
		else {
			return false;
		}
	}
	/*
	 function  checkEmail($email) {
	 if (!preg_match("/^( [a-zA-Z0-9] )+( [a-zA-Z0-9\._-] )*@( [a-zA-Z0-9_-] )+( [a-zA-Z0-9\._-] +)+$/" , $email)) {
	 return false;
	 }
	 return true;
	 }*/
	/**
	 * Expdition d'un e-mail.
	 * @param string $email Adresse d'expdition de l'e-mail.
	 * @param string $subject Sujet de l'e-mail.
	 * @param string $message Corps du massage  expdier.
	 * @return boolean True si le message a t expdi, false sinon.
	 */
	function send_email($email, $subject, $message){
		global $vars_mail;
		// En-ttes
		$headers = "From: ".$vars_mail["from"]."\n";
		$headers .= "X-Sender: ".$vars_mail["from"]."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$vars_mail["from"]."\n";
		$headers .= "Reply-To: ".$vars_mail["nom"]." <".$vars_mail["from"].">\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}

	/**
	 * Renvoie un tableau contenant la commande en cours.
	 *
	 * Cette commande est construite  partir du caddie et du compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $clef Tableau contenant les identifiants du client en cours.
	 * @param string $idcommtemp Identifiant de la commande temporaire  rcuprer
	 * @return array Tableau contenant la commande en cours.
	 */
	function caddie_to_commande($My_SQL,$vars_mod,$clef,$idcommtemp="") {
		global $module_name, $currentlang, $seps, $langue_commercant;
		$aujourdhui = date("Y-m-d");
		$periodes_soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
		$en_periode_solde = false;
		foreach($periodes_soldes as $periode_solde) {
			if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
				$en_periode_solde = true;
			}
		}
		if ($idcommtemp == "") {
			if (!isset($_SESSION["caddie"])) {
				$_SESSION["caddie"] = "";
				$caddiencours = "";
			}
			else {
				$caddiencours = $_SESSION["caddie"];
				$codepromoencours = $_SESSION["code_s_promo"];
				$idclientencours = $_SESSION["id_s_client"];
				$idportencours = $_SESSION["id_port"];
				$idreglementencours = $_SESSION["id_reglement"];
				$lesremarquesencours = $_SESSION["lesremarques"];
				$langueencours = $currentlang;
			}
		}
		else {
			$commtemps = $this->sgbd->getCommandesTemp($My_SQL,$idcommtemp);
			$commtemp = $commtemps[0];
			$caddiencours = $commtemp["caddie"];
			$codepromoencours = $commtemp["code_promo"];
			$idclientencours = $commtemp["id_client"];
			$idportencours = $commtemp["id_port"];
			$idreglementencours = $commtemp["id_reglement"];
			$lesremarquesencours = $commtemp["lesremarques"];
			$langueencours = $commtemp["lang_client"];
			$clef = array("Id"=>$commtemp["id_client"],"codeclient"=>"","passwd"=>"");
		}
		if ($caddiencours != "") {
			$articles = explode($seps["sep_article"],$caddiencours);
			$total_tarif = 0;
			$total_tva = 0;
			$contenu = "";
			switch ($langueencours) {
				case "italian" :
					$suffixe = "_I";
					break;
				case "french" :
					$suffixe = "_F";
					break;
				case "spanish" :
					$suffixe = "_S";
					break;
				case "english" :
					$suffixe = "_E";
					break;
				case "german" :
					$suffixe = "_A";
					break;
			}
			foreach($articles as $article) {
				$article = str_replace("\r","",$article);
				list($Id,$nbre,$options_str) = explode($seps["sep_champ"],$article);
				$options_ligne = "";
				if ($options_str !="") {
					$options = explode($seps["sep_option"],$options_str);
					foreach($options as $option) {
						list($key,$value) = explode($seps["sep_valeur"],$option);
						if ($options_ligne != "") {
							$options_ligne .= " - ";
						}
						$options_ligne .= $key." : ".$value;
					}
				}
				$articles_cat = $this->sgbd->getArticles($My_SQL,$Id);
				$article_cat = $articles_cat[0];

				$designation_ligne = $article_cat["designation".$suffixe];
				$designation_ligne_commercant = $article_cat["designation".$langue_commercant];
				if ($article_cat["marque"] != '') {
					$marque_ligne = $article_cat["marque"];
				}
				else {
					$marque_ligne = "";
				}
				if ($article_cat["ref_article"] != '') {
					$ref_ligne = $article_cat["ref_article"];
				}
				else {
					$ref_ligne = "";
				}
				$prix_ligne = $article_cat["tarif_ht"];
				if ($aujourdhui >= $article_cat["deb_promo"] && $aujourdhui <= $article_cat["fin_promo"]) {
					$prix_ligne = $article_cat["tarif_promo"];
				}
				if ($en_periode_solde && $article_cat["taux_solde"] != 0) {
					//if ($aujourdhui >= $article_cat["deb_solde"] && $aujourdhui <= $article_cat["fin_solde"]) {
					$prix_ligne = number_format(($article_cat["tarif_ht"])*(1-($article_cat["taux_solde"])/100),2);
				}
				$tva_ligne = number_format(($prix_ligne * ($article_cat["taux_tva"]/100)),2) * $nbre;
				$tarif_ligne = $prix_ligne * $nbre;

				$total_tarif += $tarif_ligne;
				$total_tva += $tva_ligne;

				if ($contenu != "") {
					$contenu .= $seps["sep_article"];
				}
				$contenu .= $Id;
				$contenu .= $seps["sep_champ"];
				$contenu .= $ref_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $marque_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $designation_ligne_commercant;
				$contenu .= $seps["sep_champ"];
				$contenu .= $designation_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $options_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $prix_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $nbre;
				$contenu .= $seps["sep_champ"];
				$contenu .= $tarif_ligne;
				$contenu .= $seps["sep_champ"];
				$contenu .= $article_cat["taux_tva"];
				$contenu .= $seps["sep_champ"];
				$contenu .= $tva_ligne;
			}
			$total_reduc = 0;
			if ($codepromoencours != "") {
				$promos = $this->sgbd_promo->getPromo($My_SQL,"",$codepromoencours);
				if (count($promos) != 0) {
					$promo = $promos[0];
				}
				else {
					$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
				}
			}
			else {
				$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
			}
			if ($promo["Id"] != "-1") {
				$aujourdhui = date("Y-m-d");
				if (($promo["debut"] <= $aujourdhui && $promo["fin"] >= $aujourdhui) || ($promo["debut"] <= $aujourdhui && $promo["fin"] == "0000-00-00") || ($promo["debut"] == "0000-00-00" && $promo["fin"] >= $aujourdhui)  || ($promo["debut"] == "0000-00-00" && $promo["fin"] == "0000-00-00")) {
					if ($promo["multiple"] == "1") {
						$promovalide = true;
					}
					else {
						$comm_client_promo = $this->sgbd->getCommandes($My_SQL,"",$idclientencours,"",$promo["code"]);//vrif usage unique
						if (count($comm_client_promo) == 0) {
							$promovalide = true;
						}
						else {
							$promovalide = false;
						}
					}
					if ($promovalide) {
						$pourcent = $promo["pourcent"];
						$somme = $promo["somme"];
						$noport = $promo["noport"];
						$seuil = $promo["seuil"];
					}
					else {
						$pourcent = 0;
						$somme = 0;
						$noport = 0;
						$seuil = 0;
					}
				}
				else {
					$pourcent = 0;
					$somme = 0;
					$noport = 0;
					$seuil = 0;
				}
			}
			else {
				$pourcent = 0;
				$somme = 0;
				$noport = 0;
				$seuil = 0;
			}
				
			if ($idportencours != "-1") {
				$ports = $this->sgbd->getPorts($My_SQL,$idportencours);
				if ($ports[0]["seuilfranco"] != 0 && $ports[0]["seuilfranco"] <= $total_tarif ) {
					$total_reduc += $port_HT + number_format($port_HT*$ports[0]["tva"]/100,2,".","");
					$port_HT = 0 ;
				}
				else {
					$port_HT = $ports[0]["tarif"];
				}
				$port_TVA = number_format($port_HT*$ports[0]["tva"]/100,2 , ".","");
				$port_TTC = $port_HT + number_format($port_HT*$ports[0]["tva"]/100,2,".","");
				$designport = $ports[0]["designation"];
			}
			else {
				$port_HT = 0;
				$port_TVA = 0;
				$port_TTC = 0;
				$designport = "";
			}
				
			if ($noport == "1") {
				if ($seuil <= $total_tarif) {
					$total_reduc += $port_TTC;
					$port_HT = 0;
					$port_TVA = 0;
					$port_TTC = 0;
				}
			}
			$reduc_HT = 0;
			$reduc_TVA = 0;
			if ($pourcent != 0) {
				if ($seuil <= $total_tarif) {
					$reduc_HT = "-".number_format($total_tarif*$pourcent/100,2 , ".","");
					$reduc_TVA = "-".number_format($total_tva*$pourcent/100,2 , ".","");
				}
			}
			if ($somme != 0) {
				if ($seuil <= $total_tarif) {
					$reduc_HT += "-".number_format($somme,2 , ".","");
				}
			}
			$reduc_TTC = $reduc_HT + $reduc_TVA;
				
			$total_reduc -= $reduc_TTC;
				
			if ($total_tarif + $total_tva + $reduc_TTC < 0) {
				$reduc_HT = -($total_tarif + $total_tva);
				$reduc_TTC = $reduc_HT + $reduc_TVA;
			}
				
			if ($idreglementencours != "-1") {
				$reglement = $idreglementencours;
				$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
				if ($idreglementencours == (count($reglements)-1) || $idreglementencours == (count($reglements)-2)) {
					$paye = "1";
				}
				else {
					$paye = "0";
				}
			}
			else {
				$reglement = "0";
				$paye = "0";
			}
				
			$client = $this->sgbd->getClient($My_SQL,$clef);
			$civilites = explode("//",_CLIENTCIVILITES);
			if ($client["civilite"] != 0){
				$civilite = $civilites[$client["civilite"]]." ";
			}
			else {
				$civilite = "";
			}
			$client_ligne = $civilite;
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["nom"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["prenom"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["societe"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["adresse"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["codepostal"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $client["ville"];
			$client_ligne .= $seps["sep_champ"];
			$client_ligne .= $this->code2pays($My_SQL,$client["pays"],$idcommtemp);
				
			//$statuss = explode("//",_CATALOGCOMMANDSTATUS);
				
			$new_commande = array();
			$new_commande["Id"] = "-1";
			$new_commande["id_client"] = $idclientencours;
			$new_commande["client"] = $client_ligne;
			$new_commande["date"] = $aujourdhui;
			$new_commande["commande"] = $contenu;
			$new_commande["total_ht"] = $total_tarif;
			$new_commande["port_ht"] = $port_HT;
			$new_commande["reduc_ht"] = $reduc_HT;
			$new_commande["total_reduc"] = $total_reduc;
			$new_commande["code_promo"] = $codepromoencours;
			$new_commande["total_tva"] = $total_tva + $port_TVA + $reduc_TVA;
			$new_commande["total_ttc"] = ($total_tarif + $port_HT + $total_tva + $port_TVA + $reduc_HT + $reduc_TVA);
			$new_commande["port"] = $designport;
			$new_commande["status"] = 0;
			$new_commande["paye"] = $paye;
			$new_commande["reglement"] = $reglement;
			$new_commande["remarques"] = $lesremarquesencours;
			$new_commande["numero"] = date("y-z-His");
			list($an,$jour,$heure) = explode("-",$new_commande["numero"]);
			$jour = str_pad($jour,3,"0",STR_PAD_LEFT);
			$new_commande["numero"] = $an."-".$jour."-".$heure;
			while (count($this->sgbd->getCommandes($My_SQL,"","",$new_commande["numero"])) != 0) {
				list($an,$jour,$heure) = explode("-",$new_commande["numero"]);
				$new_commande["numero"] = $an."-".$jour."-".($heure+1);
			}
		}
		else {
			//le caddie tait vide
			$new_commande = array();
		}
		return $new_commande;
	}

	/**
	 * Enregistre la commande en cours.
	 *
	 * Cette commande mmorise tous les paramtres en cas de modification des articles ou du compte client aprs sa validation.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_commande Tableau contenant la commande  mmoriser.
	 * @return string Rsultat de l'enregistrement de la commande.
	 */
	function save_commande($My_SQL,$vars_mod,$new_commande) {
		global $module_name, $currentlang, $seps;

		$sortie = '';

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$autorisation_commande = true;
		$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
		if ($vars_mod[$vars_mod["autorisation"]] != "" && $new_commande["reglement"] == (count($reglements)-1)) {
			//ok paiement scuris
			$autorisation_commande = true;
		}
		else {
			if ($vars_mod[$vars_mod["autorisation"]] == "" && $new_commande["reglement"] == (count($reglements)-1)) {
				//erreur paiement scuris
				$autorisation_commande = false;
			}
			else {
				//paiement diffr
				$autorisation_commande = true;
			}
		}
		if ($autorisation_commande == true) {
			if ($this->sgbd->saveCommande($My_SQL,$new_commande)) {
				$contenu = '<p>'.str_replace("<!--numero-->",$new_commande["numero"],_CATALOGCOMMANDGOODSAVE)."</p>";
				$contenu = str_replace("<!--nommodule-->",$module_name,$contenu);
				//Message de confirmation
				if($new_commande["Id"] == "-1") {
					$contenu .= $this->confirm_commande($My_SQL,$vars_mod,$new_commande["numero"],_CATALOGSUBJECTCONFIRMCOMMAND,_CATALOGMESSAGECONFIRMCOMMAND);
				}
				$_SESSION["caddie"] = "";
				$_SESSION["id_port"] = "-1";
				$_SESSION["id_reglement"] = "-1";
				$_SESSION["code_s_promo"] = "";
				$_SESSION["lesremarques"] = "";
				$_SESSION["paie-total"] = 0.0;
				$_SESSION["paie-refcomm"] = "";
				$_SESSION["paie-porteur"] = "";
			}
			else {
				//erreur : commande non enregistr
				$contenu = '<p class="alerte">'._CATALOGCOMMANDBADSAVE.'</p>';
			}
		}
		else {
			$contenu = '<p>'._CATALOGCOMMANDBADPAIEMENTCB."</p>";
		}

		$sortie .= $stylecatalog.
			'</h1><div class="catalog">
			<h1>'._CATALOGCOMMANDSAVED.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Expdie un e-mail de confirmation lors de l'enregistrement d'une commande.
	 *
	 * Si le message n'a pu tre envoy, un message d'erreur est renvoy (pour affichage).
	 * Un e-mail est expdi au client. Un autre e-mail est expdi au commerant.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $num_commande Numro de la commande venant d'tre enregistre.
	 * @param string $subject Sujet du message expdi.
	 * @param string $message Corps du message expdi.
	 * @return string Vide si le message a t expdi, message d'erreur sinon.
	 */
	function confirm_commande($My_SQL,$vars_mod,$num_commande,$subject,$message,$idcommtemp="") {
		global $module_name, $currentlang, $seps;
		$commandes = $this->sgbd->getCommandes($My_SQL,"","",$num_commande);
		if (count($commandes) != 0) {
			$commande = $commandes[0];
			
			if ($idcommtemp == "") {
				$codepromoencours = $_SESSION["code_s_promo"];
				$idclientencours = $_SESSION["id_s_client"];
				$idportencours = $_SESSION["id_port"];
				$idreglementencours = $_SESSION["id_reglement"];
				$lesremarquesencours = $_SESSION["lesremarques"];
			}
			else {
				$commtemps = $this->sgbd->getCommandesTemp($My_SQL,$idcommtemp);
				$commtemp = $commtemps[0];
				$codepromoencours = $commtemp["code_promo"];
				$idclientencours = $commtemp["id_client"];
				$idportencours = $commtemp["id_port"];
				$idreglementencours = $commtemp["id_reglement"];
				$lesremarquesencours = $commtemp["lesremarques"];
			}
			
			$clef = array();
			$clef["Id"] = $commande["id_client"];
			$clef["codeclient"] = "";
			$clef["passwd"] = "";
			$client = $this->sgbd->getClient($My_SQL,$clef);
			$civilites = explode("//",_CLIENTCIVILITES);
			if ($client["civilite"] != 0){
				$civilite = $civilites[$client["civilite"]]." ";
			}
			else {
				$civilite = "";
			}
			$client_str = $civilite.$client["prenom"]." ".$client["nom"];
			if ($client["societe"] != "") {
				$client_str .= "\n".$client["societe"];
			}
			if ($client["adresse"] != "") {
				$client_str .= "\n".$client["adresse"];
			}
			$client_str .= "\n".$client["codepostal"]." ".$client["ville"];
			if ($client["pays"] != "") {
				$client_str .= "\n".$this->code2pays($My_SQL,$client["pays"],$idcommtemp);
			}
			$client_str .= "\n\n"._CLIENTEMAILEDIT.$client["email"];
			if ($client["tel"] != "") {
				$client_str .= "\n"._CLIENTTELEDIT.$client["tel"];
			}
			if ($client["portable"] != "") {
				$client_str .= "\n"._CLIENTPORTABLEEDIT.$client["portable"];
			}
			if ($client["fax"] != "") {
				$client_str .= "\n"._CLIENTFAXEDIT.$client["fax"];
			}
				
			$articles = explode($seps["sep_article"],$commande["commande"]);
			$total_HT = 0;
			$total_TVA = 0;
			$tab_articles = str_pad("", 85, "-", STR_PAD_LEFT)."\n";
			foreach($articles as $article) {
				list($Id,$reference,$marque,$designation,$designationClient,$options,$prix,$nbre,$tarif_ht,$taux_tva,$tva) = explode($seps["sep_champ"],$article);

				$tab_articles .= str_pad($nbre, 5, " ", STR_PAD_RIGHT);
				$design = "";
				if ($marque != "") {
					$design .= $marque;
				}
				if ($designationClient != "") {
					if ($design != "") {
						$design .= " - ";
					}
					$design .= $designationClient;
				}
				if ($options != "") {
					if ($design != "") {
						$design .= " - ";
					}
					$design .= $options;
				}
				if (strlen($design) > 60) {
					$design = substr($design,0,57)."...";
				}
				$tab_articles .= str_pad($design, 60, " ", STR_PAD_RIGHT);
				$tab_articles .= str_pad(number_format($tarif_ht, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
				$total_HT += $tarif_ht;
				$total_TVA += $tva;
			}
				
			if ($idreglementencours != "-1") {
				$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
				$lereglement = $reglements[$commande["reglement"]];
			}
				
			if ($codepromoencours != "") {
				$promos = $this->sgbd_promo->getPromo($My_SQL,"",$codepromoencours);
				if (count($promos) != 0) {
					$promo = $promos[0];
				}
				else {
					$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
				}
			}
			else {
				$promo = array( "Id"=>"-1", "code"=>"", "debut"=>"0000-00-00", "fin"=>"0000-00-00", "pourcent"=>0, "somme"=>0, "noport"=>0, "seuil"=>0, "multiple"=>0);
			}
			if ($promo["Id"] != "-1") {
				$aujourdhui = date("Y-m-d");
				if (($promo["debut"] <= $aujourdhui && $promo["fin"] >= $aujourdhui) || ($promo["debut"] <= $aujourdhui && $promo["fin"] == "0000-00-00") || ($promo["debut"] == "0000-00-00" && $promo["fin"] >= $aujourdhui)  || ($promo["debut"] == "0000-00-00" && $promo["fin"] == "0000-00-00")) {
					if ($promo["multiple"] == "1") {
						$promovalide = true;
					}
					else {
						$comm_client_promo = $this->sgbd->getCommandes($My_SQL,"",$idclientencours,"",$promo["code"]);//vrif usage unique
						$comm_client_promo2 = $this->sgbd->getCommandes($My_SQL,"",$idclientencours,$num_commande,$promo["code"]);
						if ((count($comm_client_promo) - count($comm_client_promo2)) == 0) {
							$promovalide = true;
						}
						else {
							$promovalide = false;
						}
					}
					if ($promovalide) {
						$pourcent = $promo["pourcent"];
						$somme = $promo["somme"];
						$noport = $promo["noport"];
						$seuil = $promo["seuil"];
					}
					else {
						$pourcent = 0;
						$somme = 0;
						$noport = 0;
						$seuil = 0;
					}
				}
				else {
					$pourcent = 0;
					$somme = 0;
					$noport = 0;
					$seuil = 0;
				}
			}
			else {
				$pourcent = 0;
				$somme = 0;
				$noport = 0;
				$seuil = 0;
			}
				
			if ($idportencours != "-1") {
				$ports = $this->sgbd->getPorts($My_SQL,$idportencours);
				if ($ports[0]["seuilfranco"] != 0 && $ports[0]["seuilfranco"] <= $total_HT ) {
					$port_HT = 0 ;
				}
				else {
					$port_HT = $ports[0]["tarif"];
				}
				$port_TVA = number_format($port_HT*$ports[0]["tva"]/100,2 , ".","");
				$port_TTC = $port_HT + number_format($port_HT*$ports[0]["tva"]/100,2 , ".","");
			}
			else {
				$port_HT = "-1";
				$port_TVA = 0;
				$port_TTC = 0;
			}
				
			if ($noport == "1") {
				if ($seuil <= $total_HT) {
					$port_HT = 0;
					$port_TVA = 0;
					$port_TTC = 0;
				}
			}
			$reduc_HT = 0;
			$reduc_TVA = 0;
			if ($pourcent != 0) {
				if ($seuil <= $total_HT) {
					$reduc_HT = "-".number_format($total_HT*$pourcent/100,2 , ".","");
					$reduc_TVA = "-".number_format($total_TVA*$pourcent/100,2 , ".","");
				}
			}
			if ($somme != 0) {
				if ($seuil <= $total_HT) {
					$reduc_HT += "-".number_format($somme,2 , ".","");
				}
			}
			$reduc_TTC = $reduc_HT + $reduc_TVA;
				
			if ($total_HT + $total_TVA + $reduc_TTC < 0) {
				$reduc_HT = -($total_HT + $total_TVA);
				$reduc_TTC = $reduc_HT + $reduc_TVA;
			}
				
			$total_TVA += $port_TVA + $reduc_TVA;
				
			if ($port_HT != "-1") {
				$total_TTC = $total_HT + $port_HT + $total_TVA + $reduc_HT;
			}
			else {
				$total_TTC = $total_HT + $total_TVA + $reduc_HT;
			}
				
			$tab_articles .= str_pad("", 85, "-", STR_PAD_LEFT)."\n";
			$tab_articles .= str_pad(_CATALOGTOTALHTCADDIE, 65, " ", STR_PAD_LEFT).str_pad(number_format($total_HT, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
			if ($reduc_HT != "0") {
				$tab_articles .= str_pad(_CATALOGTOTALREDUCCADDIE, 65, " ", STR_PAD_LEFT).str_pad(number_format($reduc_HT, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
			}
			if ($port_HT != "-1") {
				$tab_articles .= str_pad(_CATALOGTOTALPORTCADDIE, 65, " ", STR_PAD_LEFT).str_pad(number_format($port_HT, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
			}
			$tab_articles .= str_pad(_CATALOGTOTALTVACADDIE, 65, " ", STR_PAD_LEFT).str_pad(number_format($total_TVA, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
			$tab_articles .= str_pad(_CATALOGTOTALTTCCOMMANDE, 65, " ", STR_PAD_LEFT).str_pad(number_format($total_TTC, 2 , ","," ")." E\n", 20, " ", STR_PAD_LEFT);
			$tab_articles .= str_pad("", 85, "-", STR_PAD_LEFT)."\n";
				
			$lien = "http://".$_SERVER["SERVER_NAME"]."/modules.php?name=".$module_name."&sop=set_client";
				
			$remarques = $lesremarquesencours;
				
			$message = str_replace("<!--nom-->",$client["nom"],$message);
			$message = str_replace("<!--prenom-->",$client["prenom"],$message);
			$message = str_replace("<!--client-->",$client_str,$message);
			$message = str_replace("<!--articles-->",$tab_articles,$message);
			$message = str_replace("<!--lien-->",$lien,$message);
			$message = str_replace("<!--numero-->",$num_commande,$message);
			$message = str_replace("<!--remarques-->",$remarques,$message);
			if ($codepromoencours != "") {
				$message = str_replace("<!--codepromo-->","\n"._CATALOGCOMMANDCODEPROMO.$codepromoencours."\n",$message);
			}
			else {
				$message = str_replace("<!--codepromo-->","",$message);
			}
				
			//echo "<hr /><pre>$message</pre><hr />";
				
				
			$email = $client["prenom"]." ".$client["nom"]." <".$client["email"].">";
				
			if ($this->send_email($email, $subject, $message)) {//expdition client
				$subject = _CATALOGSUBJECTCONFCOMMANDCOMMERCANT;
				$message = _CATALOGMESSAGECONFCOMMANDCOMMERCANT;
				//				$message = str_replace("<!--nom-->",$client["nom"],$message);
				//				$message = str_replace("<!--prenom-->",$client["prenom"],$message);
				$message = str_replace("<!--client-->",$client_str,$message);
				$message = str_replace("<!--reglement-->",$lereglement,$message);
				$message = str_replace("<!--articles-->",$tab_articles,$message);
				$message = str_replace("<!--numero-->",$num_commande,$message);
				$message = str_replace("<!--remarques-->",$remarques,$message);
				if ($codepromoencours != "") {
					$message = str_replace("<!--codepromo-->","\n"._CATALOGCOMMANDCODEPROMO.$codepromoencours."\n",$message);
				}
				else {
					$message = str_replace("<!--codepromo-->","",$message);
				}

				//echo "<hr /><pre>$message</pre><hr />";

				global $vars_mail;
				$email = $vars_mail["nom"]." <".$vars_mail["from"].">";
				if ($this->send_email($email, $subject, $message)) {//expdition commerant
					return "";
				}
				else {
					return '<p class="alerte">'._CATALOGMESSAGEERROR2.'</p>';
				}
			}
			else {
				return '<p class="alerte">'._CATALOGMESSAGEERROR.'</p>';
			}
		}
		else {
			return '<p class="alerte">'._CATALOGMESSAGEERROR.'</p>';
		}
	}

	/**
	 * Signale que la commande en cours est paye (de manire assynchrone) et enregistre.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Message  afficher.
	 */
	function paiment_accepted($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;

		$sortie = '';

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$command_verif = $this->sgbd->getCommandesTemp($My_SQL,$_SESSION["paie-refcomm"]);
		if (count($command_verif) == 0) {
			$commands = $this->sgbd->getCommandes($My_SQL,"",$_SESSION["id_s_client"],"","");
			$new_commande = $commands[0];

			$contenu = '<p>'.str_replace("<!--numero-->",$new_commande["numero"],_CATALOGCOMMANDGOODSAVE)."</p>";
			$contenu = str_replace("<!--nommodule-->",$module_name,$contenu);

			$_SESSION["caddie"] = "";
			$_SESSION["id_port"] = "-1";
			$_SESSION["id_reglement"] = "-1";
			$_SESSION["code_s_promo"] = "";
			$_SESSION["lesremarques"] = "";
			$_SESSION["paie-total"] = 0.0;
			$_SESSION["paie-refcomm"] = "";
			$_SESSION["paie-porteur"] = "";
		}
		else {
			//erreur : commande non enregistr
			$contenu = '<p class="alerte">'._CATALOGCOMMANDBADSAVE.'</p>';
		}

		$sortie .= $stylecatalog.
			'</h1><div class="catalog">
			<h1>'._CATALOGCOMMANDSAVED.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Renvoie le message affich aprs un paiement refus par la banque.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Code HTML de la page  afficher.
	 */
	function paiment_refused($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;

		$sortie = '';

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$sortie .= $stylecatalog.
			'</h1><div class="catalog">
			<h1>'._CATALOGCOMMANDSAVED.'</h1>
			<p>'.nl2br(_CATALOGCOMMANDREFUSEDPAIEMENTCB).'</p>
		</div>';
		return $sortie;
	}

	/**
	 * Renvoie le message affich aprs un paiement annul par le client.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Code HTML de la page  afficher.
	 */
	function paiment_canceled($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;

		$sortie = '';

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$sortie .= $stylecatalog.
			'</h1><div class="catalog">
			<h1>'._CATALOGCOMMANDSAVED.'</h1>
			<p>'.nl2br(_CATALOGCOMMANDCANCELPAIEMENTCB).'</p>
		</div>';
		return $sortie;
	}

	/**
	 * Retoune la liste des commandes correspondant au compte client courant.
	 *
	 * Si aucun compte client n'est ouvert, le formulaire d'identification est ouvert.
	 * Chaque ligne de la liste donne accs au dtail de la commande.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Liste des commandes enregistres.
	 */
	function display_all_commands($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;

		$sortie = '';

		if ($_SESSION["id_s_client"] != "") {
			if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
				$stylecatalog = "";
			}
			else {
				$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
			';
			}
			$commandes = $this->sgbd->getCommandes($My_SQL,"",$_SESSION["id_s_client"],"");
			$contenu = "";
			if (count($commandes) != 0) {
				$statuss = explode("//",_CATALOGCOMMANDSTATUS);
				$contenu .= '<ul>';
				foreach($commandes as $commande) {
					$contenu .= '<li><a href="modules.php?name='.$module_name.'&sop=display_one_command&'.$vars_mod["num_comm"].'='.$commande["numero"].'" title="Voir le dtail de la commande">Commande n'.$commande["numero"].' du '.adminCatalog::date2JMA($commande["date"]).' - Etat : '.$statuss[$commande["status"]].'</a></li>';
				}
				$contenu .= '</ul>';
			}
			else {
				$contenu .= '<p>'._CATALOGCOMMANDNOTFIND.'</p>';
			}
			$sortie .= $stylecatalog.
				'</h1><div class="catalog">
				<h1>'._CATALOGCOMMANDLIST.'</h1>
				'.$contenu.'
			</div>';
		}
		else {
			$sortie .= $this->set_client($My_SQL,$vars_mod);
		}
		return $sortie;
	}

	/**
	 * Imprime le contenu d'une commande.
	 *
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Code HTML de la commande  imprimer.
	 */
	function display_one_command($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;
		$sortie = '';
		if ($_SESSION["id_s_client"] != "") {
			if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
				$stylecatalog = "";
			}
			else {
				$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
			';
			}
			$commandes = $this->sgbd->getCommandes($My_SQL,"","",$vars_mod[$vars_mod["num_comm"]]);
			$contenu = "";
			if (count($commandes) != 0) {
				$commande = $commandes[0];
				$articles = explode($seps["sep_article"],$commande["commande"]);
				//$total_ht = 0;
				//$total_tva = 0;
				$tab_articles = '<table border="0" cellpadding="0" cellspacing="0" class="listearticles">';
				$tab_articles .= '<tr><td colspan="5" class="separation"><hr /></td></tr>';
				foreach($articles as $article) {
					list($Id,$reference,$marque,$designation,$designationClient,$options,$prix,$nbre,$tarif_ht,$taux_tva,$tva) = explode($seps["sep_champ"],$article);
					$tab_articles .= '<tr><td>';
					$tab_articles .= $nbre;
					$tab_articles .= '<td width="20"></td></td><td>';
					if ($marque != "") {
						$tab_articles .= $marque.' - ';
					}
					$tab_articles .= $designationClient;
					if ($options != "") {
						$tab_articles .= ' - '.$options;
					}
					$tab_articles .= '<td width="20"></td></td><td align="right">';
					$tab_articles .= number_format($tarif_ht, 2 , ","," ").'&nbsp;&euro;';
					$tab_articles .= '</td></tr>';
					//$total_ht += $tarif_ht;
					//$total_tva += $tva;
				}
				//$total_ttc = $total_ht + $total_tva;
				$tab_articles .= '<tr><td colspan="5" class="separation"><hr /></td></tr>';
				$tab_articles .= '<tr><td colspan="3" align="right">'._CATALOGTOTALHTCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
				if ($commande["reduc_ht"] != "0") {
					$tab_articles .= '<tr><td colspan="3" align="right">'._CATALOGTOTALREDUCCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["reduc_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
				}
				$tab_articles .= '<tr><td colspan="3" align="right">'._CATALOGTOTALPORTCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["port_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
				$tab_articles .= '<tr><td colspan="3" align="right">'._CATALOGTOTALTVACADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_tva"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
				$tab_articles .= '<tr><td colspan="3" align="right">'._CATALOGTOTALTTCCOMMANDE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_ttc"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
				$tab_articles .= '</table>';

				list($civilite,$nom,$prenom,$societe,$adresse,$codepostal,$ville,$pays) = explode($seps["sep_champ"],$commande["client"]);
				$civilites = explode("//",_CLIENTCIVILITES);
				if ($civilite == $civilites[0]) {
					$civilite = "";
				}
				$client = "<p>".$civilite.$prenom." ".$nom;
				if ($societe != "") {
					$client .= "<br />".$societe;
				}
				if ($adresse != "") {
					$client .= "<br />".$adresse;
				}
				$client .= "<br />".$codepostal." ".$ville;
				if ($pays != "") {
					$client .= "<br />".$pays;
				}
				$client .= "</p>";

				$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
				$statuss = explode("//",_CATALOGCOMMANDSTATUS);
				$facture = "<p>"._CATALOGCOMMANDNUMBER.$commande["numero"]."<br />";
				$facture .= _CATALOGCOMMANDDATE.adminCatalog::date2JMA($commande["date"])."<br />";
				if ($commande["code_promo"] != "") {
					$facture .= _CATALOGCOMMANDCODEPROMO.$commande["code_promo"]."<br />";
				}
				$facture .= _CATALOGClIENTACTUALPAYMENT.$reglements[$commande["reglement"]]."<br />";
				$facture .= _CATALOGCOMMANDCURRENTSTATUS.$statuss[$commande["status"]]."</p>";

				$remarques = "";
				if ($commande["remarques"] != "") {
					$remarques = "<p>".nl2br($commande["remarques"])."</p>";
				}

				$contenu = $client.$facture.$tab_articles.$remarques;
			}
			else {
				$contenu .= '<p>'._CATALOGCOMMANDNOTFIND.'</p>';
			}
			$sortie .= $stylecatalog.
				'</h1><div class="catalog">
				<h1>'._CATALOGCOMMANDDETAIL.'</h1>
				'.$contenu.'
			</div>';
		}
		else {
			$sortie .= $this->set_client($My_SQL,$vars_mod);
		}
		return $sortie;
	}

	/**
	 * Renvoie l'indentit du client pour affichage.
	 *
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $nom Tableau contenant les partie de son identit (civilit, nom et prnom).
	 * @return string Barre d'identit avec bouton de fermeture du compte.
	 */
	function display_identity_client($vars_mod,$nom) {
		global $module_name;
		$civilites = explode("//",_CLIENTCIVILITES);
		if (count($nom) != 0) {
			$sortie = '<div class="identite">';
			$sortie .= '<table border="0" cellpadding="0" cellspacing="0"><tr>';
			$sortie .= '<td><a href="modules.php?name='.$module_name.'&sop=edit_client" title="'._CATALOGBARACCOUNTCHANGE.'">'.$civilites[$nom["civilite"]].' '.$nom["prenom"].' '.$nom["nom"].'</a></td>';
			$sortie .= '<td width="10"></td>';
			$sortie .= '<td><a href="modules.php?name='.$module_name.'&sop=close_client" title="'._CATALOGBARACCOUNTCLOSE.'"><img src="'.$this->get_picto_url($vars_mod,"close.gif").'" alt="'._CATALOGBARACCOUNTCLOSE.'" border="0" /></a><td>';
			$sortie .= '</tr></table>';
			$sortie .= '</div>';
			return $sortie;
		}
		else {
			return '';
		}
	}

	/**
	 * Renvoie l'URL d'un picto.
	 *
	 * La fonction vrifie l'existance du picto dans le thme. S'il existe, son URL est envoy, sinon c'est l'URL du picto par dfaut qui est renvoy.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $picto Nom du picto  renvoyer.
	 * @return string URL du picto  afficher.
	 */
	function get_picto_url($vars_mod,$picto) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/images/".$picto)) {
			$url = "themes/".get_theme()."/images/".$picto;
		}
		else {
			$url = $vars_mod["cheminModule"].'lib/icns/'.$picto;
		}
		return $url;
	}

	/**
	 * Vrifie la compatibilit de destination d'un produit avec la destination du client en cours.
	 *
	 * Si le pays transmis est dans la liste de pays du produit, la fonction renvoie true et false sinon.
	 * Si la liste de pays du produit est vide, ou si le client n'est pas encore fix, ou si son pays n'est pas fix, la fonction renvoie toujours vrai.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param integer $id_produit Identifiant du produit  tester.
	 * @return boolean True ou false en fonction du rsultat.
	 */
	function is_delivrable($My_SQL,$vars_mod,$id_produit) {
		global $module_name;
		$resultat = true;
		if ($_SESSION["id_s_client"] != "" && $_SESSION["id_s_client"] != "-1") {
			$resultat = false;
			$clef = array();
			$clef["Id"] = $_SESSION["id_s_client"];
			$clef["codeclient"] = "";
			$clef["passwd"] = "";
			$client = $this->sgbd->getClient($My_SQL,$clef);
			$produits = $this->sgbd->getArticles($My_SQL,$id_produit);
			$produit = $produits[0];
			if ($produit["list_pays"] == "") {
				$resultat = true;
			}
			else {
				$liste_pays = explode("/",$produit["list_pays"]);
				foreach($liste_pays as $pays) {
					if (trim($client["pays"]) == $pays) {
						$resultat = true;
					}
				}
			}
		}
		return $resultat;
	}
	/**
	 * Renvoie la liste des pays pour lesquels le produit est livrable.
	 *
	 * Si la liste est vide, ne renvoie rien
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param integer $id_produit Identifiant du produit  tester.
	 * @return array Tableau contenant la liste des pays.
	 */
	function delivrable_countries($My_SQL,$id_produit) {
		global $currentlang;
		$produits = $this->sgbd->getArticles($My_SQL,$id_produit);
		$produit = $produits[0];
		if ($produit["list_pays"] == "") {
			return array();
		}
		else {
			$lespayss = array();
			$suffixe = "E";
			switch ($currentlang) {
				case "italian" :
					$suffixe = "_I";
					break;
				case "french" :
					$suffixe = "_F";
					break;
				case "spanish" :
					$suffixe = "_S";
					break;
				case "english" :
					$suffixe = "_E";
					break;
				case "german" :
					$suffixe = "_A";
					break;
			}
			$les_pays = $this->sgbd->getPays($My_SQL);
			$liste_pays = explode("/",$produit["list_pays"]);
			foreach($liste_pays as $pays) {
				foreach($les_pays as $unpays) {
					if ($unpays["code"] == $pays) {
						$les_payss[$pays] = $unpays["pays".$suffixe];
					}
				}
			}
			return $les_payss;
		}
	}
}
?>