<?php
/**
* Interface d'administration du module de catographie.
* 
* @package becmsSimpleCarto
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
//setPath(_TXT_Modules,0);
//setPath(_SIMPLECARTO,1);
require_once("modules/Sections/connector_class.php");
include("modules/$module_name/lib/g_db.php");
include("modules/$module_name/lib/ba_admincarto.php");
include_once("modules/$module_name/connector_lib.php");

/**
* Renvoie l'interface d'administration de ce module.
* 
* Les liste de cartes et de lieux, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function editcarto(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid;
	//global $FName, $FDescription, $FParentL, $FParent, $FPublicUse, $Fposition, $Furl, $Ftarget, $Fnomenu, $FID, $FId, $FIntitule, $FGenre, $newparent ;
		
	include("modules/$module_name/lib/g_params.php");
	include("system/header_system.php");
	
	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_lieu = "";
	$observations = "";
	$operationOnglet = "";
	
	$LieuEdit = array("Id"=>"","latitude"=>"","longitude"=>"","icone"=>"","lieu"=>"","fiche"=>"","target"=>"","commentaire"=>"","istext"=>"","angle"=>"","taille"=>"","typo"=>"","couleur"=>"","isbordure"=>"","bordure"=>"","b_visibilite"=>"","b_couleur"=>"","b_epaisseur"=>"","b_opacite"=>"","b_plein"=>"");
	$CarteEdit = array("Id"=>"","designation"=>"","latitudeinit"=>"","longitudeinit"=>"","zoominit"=>"0","zoomclic"=>"0","bordure"=>"","visibilite"=>"","couleur"=>"","epaisseur"=>"","opacite"=>"", "auteur"=>"", "creation"=>"", "commentaire"=>"", "page"=>"");
	
	$objetCarte = new adminCartos();
//	$objetMenu->IdMenu = $modmenu[$modmenu["Encours"]];
	
	$script_init_carto = '<script type="text/javascript">
	// <![CDATA[
		addToStart(Gload);
		addToStart(newPopUpZPop);
		addToStart(\'typepointInit(document.formfiche)\');
		//addToStop(GUnload);
	// ]]>
	</script>';
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "list" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de lieux</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMLIEUEDIT."</th></tr>";
			$form_lieu = "";
			$observations = $objetCarte->get_observations($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETLIEULIST;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " "._CARTOONGLETDE." \"".$temp["designation"]."\"";
			}
			$script_init_carto = "";
			break;
		case "edit" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de lieux</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMLIEUEDIT."</th></tr>";
			$LieuEdit = $objetCarte->get_lieu_edit($My_SQL,$vars_mod);
			$vars_mod[$vars_mod["id_carte"]] = $LieuEdit["id_carte"];
			$CarteEdit = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
			$form_lieu = $objetCarte->edit_lieu($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETLIEUEDIT;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " "._CARTOONGLETDE." \"".$temp["designation"]."\"";
			}
			$script_manip_carto = $objetCarte->lib_carto_edit_lieu_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "new" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de lieux</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMLIEUNEW."</th></tr>";
			$vars_mod[$vars_mod[id_lieu]] = "-1";
			if ($vars_mod[$vars_mod[id_carte]] == "") {
				$vars_mod[$vars_mod[id_carte]] = "-1";
			}
			$form_lieu = $objetCarte->edit_lieu($My_SQL,$vars_mod);
			$CarteEdit = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETLIEUNEW;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " "._CARTOONGLETPOUR." \"".$temp["designation"]."\"";
			}
			$script_manip_carto = $objetCarte->lib_carto_edit_lieu_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "save" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de lieux</h1>';
			$vars_mod["sortie_action"] = $objetCarte->save_lieu($My_SQL,$new_lieu);
			if ($vars_mod[$vars_mod["id_lieu"]] == "-1") {
				$vars_mod[$vars_mod["id_lieu"]] = $objetCarte->getLastId($My_SQL);
			}
			$form_lieu = $objetCarte->edit_lieu($My_SQL,$vars_mod);
			$LieuEdit = $objetCarte->get_lieu_edit($My_SQL,$vars_mod);
			$CarteEdit = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETLIEU;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " "._CARTOONGLETDE." \"".$temp["designation"]."\"";
			}
			$operationOnglet .= _CARTOONGLETAFTERSAVE;
			$script_manip_carto = $objetCarte->lib_carto_edit_lieu_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "duplicate":
			$vars_mod["sortie_action"] = $objetCarte->duppl_lieu($My_SQL,$vars_mod);
			$observations = $objetCarte->get_observations($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETLIEULIST;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " "._CARTOONGLETDE." \"".$temp["designation"]."\"";
			}
			$script_init_carto = "";
			break;
		case "delete" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de lieux</h1>';
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$vars_mod["sortie_action"] = $objetCarte->delete_lieu($My_SQL,$vars_mod);
				$vars_mod[$vars_mod["id_lieu"]] = "-1";
				$form_lieu = "";
				$observations = $objetCarte->get_observations($My_SQL,$vars_mod);
				$operationOnglet = _CARTOONGLETLIEULEFT;
				if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
					$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
					$operationOnglet .=  " "._CARTOONGLETDE." \"".$temp["designation"]."\"";
				}
			}
			else {
				$observations = $objetCarte->confirm_delete($My_SQL,$vars_mod,_CARTOCONFSUPPRLIEU);
				$operationOnglet = _CARTOONGLETLIEUCONFDEL;
			}
			$script_init_carto = "";
			break;
		case "list_carte" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de carte</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMCARTEEDIT."</th></tr>";
			$form_lieu = "";
			$observations = $objetCarte->get_cartes($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETCARTELIST;
			$script_init_carto = "";
			break;
		case "edit_carte" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de carte</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMCARTEEDIT."</th></tr>";
			$CarteEdit = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
			$form_lieu = $objetCarte->edit_carte($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETCARTEEDIT;
			if ($vars_mod[$vars_mod[id_carte]] != "" && $vars_mod[$vars_mod[id_carte]] != "-1") {
				$temp = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
				$operationOnglet .=  " \"".$temp["designation"]."\"";
			}
			$script_manip_carto = $objetCarte->lib_carto_edit_carte_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "new_carte" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de carte</h1>';
			$vars_mod["sortie_action"] = "<tr><th colspan=\"2\">"._CARTOFORMCARTENEW."</th></tr>";
			$vars_mod[$vars_mod[id_carte]] = "-1";
			$form_lieu = $objetCarte->edit_carte($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETCARTENEW;
			$script_manip_carto = $objetCarte->lib_carto_edit_carte_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "save_carte" :
			//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de carte</h1>';
			$vars_mod["sortie_action"] = $objetCarte->save_carte($My_SQL,$new_carte);
			if ($vars_mod[$vars_mod["id_carte"]] == "-1") {
				$vars_mod[$vars_mod["id_carte"]] = $objetCarte->getLastId($My_SQL);
			}
			$CarteEdit = $objetCarte->get_carte_edit($My_SQL,$vars_mod);
			$form_lieu = $objetCarte->edit_carte($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETCARTE;
			$operationOnglet .=  " "._CARTOONGLETDE." \"".$new_carte["designation"]."\"";
			$operationOnglet .= _CARTOONGLETAFTERSAVE;
			$script_manip_carto = $objetCarte->lib_carto_edit_carte_js($LieuEdit,$CarteEdit,$keymap,$vars_mod);
			break;
		case "duplicate_carte":
			$vars_mod["sortie_action"] = $objetCarte->duppl_carte($My_SQL,$vars_mod);
			$observations = $objetCarte->get_cartes($My_SQL,$vars_mod);
			$operationOnglet = _CARTOONGLETCARTELIST;
			$script_init_carto = "";
			break;
		case "delete_carte" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				//$titrepage='<h1 class="titrepage">Ajout, modification et suppression de carte</h1>';
				$vars_mod["sortie_action"] = $objetCarte->delete_carte($My_SQL,$vars_mod);
				$vars_mod[$vars_mod["id_carte"]] = "";
				$form_lieu = "";
				$observations = $objetCarte->get_cartes($My_SQL,$vars_mod);
				$operationOnglet = _CARTOONGLETCARTELEFT;
			}
			else {
				$observations = $objetCarte->confirm_delete($My_SQL,$vars_mod,_CARTOCONFSUPPRCARTE);
				$operationOnglet = _CARTOONGLETCARTECONFDEL;
			}
			$script_init_carto = "";
			break;
	}
	
	$scriptstyle = '
	<link href="modules/SimpleCarto/lib/style-edit-map.css" rel="stylesheet" type="text/css" media="all" />
	<link href="modules/SimpleCarto/lib/stl_pop.css" rel="stylesheet" type="text/css" media="all" />
	'.$script_manip_carto.'
	<script src="modules/SimpleCarto/lib/getscript_admin_commun.php" type="text/javascript"></script>
	'.$script_init_carto;
	
	$corpsadmincarto = $form_lieu.$observations;
	
	if (!isset($onglet)) {
		$onglet = "carte";
	}
	if ($onglet == "") {
		$onglet = "carte";
	}
	if ($vars_mod[$vars_mod["id_carte"]] != "-1" && $vars_mod[$vars_mod["id_carte"]] != "") {
		$carteencours = "&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]];
	}
	else {
		$carteencours = "";
	}
	$ongletDef=array("carte"=> array( "text"=>_SIMPLECARTOEDIT,
                                   "url"=>"system.php?".$vars_mod["action"]."=list_carte&op=carto&onglet=carte"),
                 "cartenew"=> array( "text"=>_SIMPLECARTONEW,
                                   "url"=>"system.php?".$vars_mod["action"]."=new_carte&op=carto&onglet=cartenew"),
                 "lieu"=> array( "text"=>_SIMPLECARTOPOINTEDIT,
                                   "url"=>"system.php?".$vars_mod["action"]."=list&op=carto&onglet=lieu".$carteencours),
                 "lieunew"=> array( "text"=>_SIMPLECARTOPOINTNEW,
                                   "url"=>"system.php?".$vars_mod["action"]."=new&op=carto&onglet=lieunew".$carteencours));

    
    GraphicAdmin(_SIMPLECARTO);
	OpenOngletTable();
	displayOngletBar("$onglet",_SIMPLECARTOONGLETS.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadmincarto;
	CloseSysTable();
	CloseOngletTable();
    include("system/footer_system.php");
    
    
}

/**
* Vrifie que le paramtre d'opration est bien "carto", sinon affiche "Access denied".
*/
switch ($op) {
    case "carto":
    		editcarto();
    	break;
	}
}
else {
   display_denied();
}

?>