<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/"> 
<html>
<head>
<title>Liste des cartes trouvées</title>
<style type="text/css" media="all">
body {
	background-color: #dfdfdf;
}

table {
	margin: 0;
	padding: 0;
	border-style: none;
	border-collapse: collapse;
}

table td {
	margin: 0;
	padding: 0;
}

table.cartes {
	border: 1px solid #717171;
	border-collapse: collapse;
	margin: 0 auto;
}

table.cartes th {
	text-align: center;
	color: #fff;
	font: bold 12px/14px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #717171;
	padding: 3px;
	border-bottom: 1px inset #fff;
	text-transform: uppercase;
}

table.cartes td {
	background-color: #fff;
	padding-right: 1px;
	padding-left: 1px;
}

table.symboles {
	border: 1px solid #fff;
}

table.symboles td {
	vertical-align: top;
	border: 1px solid #fff;
	background-color: #f3f3f3;
	padding: 2px;
}

table.points {
	width: 250px;
}

table.points th {
	text-align: left;
	color: #585858;
	font: bold 11px/14px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
	border-bottom: 1px solid #c6c6c6;
	text-transform: none;
}

table.points td {
	border-style: none;
	color: #575757;
	font: 10px/12px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
}

table.textes {
	width: 250px;
}

table.textes th {
	text-align: left;
	color: #585858;
	font: bold 11px/14px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
	border-bottom: 1px solid #c6c6c6;
	text-transform: none;
}

table.textes td {
	border-style: none;
	color: #575757;
	font: 10px/12px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
}

table.polygones {
	width: 250px;
}

table.polygones th {
	text-align: left;
	color: #585858;
	font: bold 11px/14px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
	border-bottom: 1px solid #c6c6c6;
	text-transform: none;
}

table.polygones td {
	border-style: none;
	color: #575757;
	font: 10px/12px Verdana, Arial, Helvetica, Geneva, sans-serif;
	background-color: #f3f3f3;
}
</style>
</head>
<body>
<table class="cartes">
<xsl:for-each select="cartes/carte">
<tr>
<th><xsl:value-of select="titre" /></th>
</tr>
<tr>
<td><table class="symboles">
<tr>
<xsl:apply-templates />
</tr>
</table></td>
</tr>
</xsl:for-each> 
</table>
</body>
</html>
</xsl:template>

<xsl:template match="*">
</xsl:template>

<xsl:template match="carte/points">
<td><table class="points">
<tr><th>Liste des pictos</th></tr>
<xsl:for-each select="point">
<tr>
<td><xsl:value-of select="lieu" /></td>
</tr>
</xsl:for-each>
</table></td>
</xsl:template>

<xsl:template match="carte/textes">
<td><table class="textes">
<tr><th>Liste des textes</th></tr>
<xsl:for-each select="texte">
<tr>
<td><xsl:value-of select="lieu_texte" /></td>
</tr>
</xsl:for-each>
</table></td>
</xsl:template>

<xsl:template match="carte/polygones">
<td><table class="polygones">
<tr><th>Liste des polygones</th></tr>
<xsl:for-each select="polygone">
<tr>
<td><xsl:value-of select="nom" /></td>
</tr>
</xsl:for-each>
</table></td>
</xsl:template>

</xsl:stylesheet>