<?php
/**
 * Interface d'administration du module de gestion des petites annonces.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleBoard
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._BOARDFOUND;
			$indexPages .= _BOARDPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _BOARDNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function list_commentaire($page,$search_words="",$valid=true) {
		if ($valid) {
			$ongletencours = "comment";
		}
		else {
			$ongletencours = "nocomment";
		}
		$obj_cat = new BD_Livre();
		$nbrefiches = $obj_cat->getCommentaire("count","","",$search_words,$valid);
		$ligne_par_page = 20;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		$liste .= '<form name="search_form" action="system.php?op=board&action=search_comm&onglet='.$ongletencours.'" method="POST">';
		$liste .= _BOARDWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._BOARDSEARCHBTN.'">';
		$liste .= ' <input name="valid" type="hidden" value="'.(($valid===true)? "1" : "0").'">';
		$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getCommentaire("files","","",$search_words,$valid,"","","",$limit);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._BOARDLISCOMMENTAIRE.'</th>
					<th class="systemTabHeader">'._BOARDLISWRITER.'</th>
					<th class="systemTabHeader">'._BOARDLISTDATE.'</th>
					<th class="systemTabHeader" style="text-align: left">'._BOARDLISTANSWER.'</th>
	    				<th class="systemTabHeader">'._BOARDACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=board&action=edit_comm&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=board&action=delete_comm&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$result["commentaire"] = utilFuncs_SimpleBoard::conditionnerHTML($result["commentaire"]);
			$longlim = 150;
			if (strlen($result["commentaire"]) > $longlim) {
				$i = $longlim;
				while (substr($result["commentaire"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["commentaire"],0,$i)."...";
			}
			else {
				$liste .= $result["commentaire"];
			}
			$liste .= '</td><td align="center">';
			if ($result["nomprenom"] != "") {
				$liste .= utilFuncs_SimpleBoard::conditionnerHTML($result["nomprenom"]);
			}
			else {
				$liste .= utilFuncs_SimpleBoard::conditionnerHTML(_BOARDANONYMOUS);
			}
			if ($result["email"] != "") {
				$liste .= "  - <a href=\"mailto:".$result["email"]."\">".$result["email"]."</a>";
			}
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs_SimpleBoard::date2JMA($result["dateajout"]);
			$liste .= '</td><td>';
			if (strlen($result["reponse"]) > $longlim) {
				$i = $longlim;
				while (substr($result["reponse"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["reponse"],0,$i)."...";
			}
			else {
				$liste .= $result["reponse"];
			}
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=board&action=add_comm&onglet=comment">'._BOARDADDCOMM.'</a></div>';
		return $liste;
	}
	
	function edit_commentaire($Id, $page,$search_words="") {
		$obj_cat = new BD_Livre();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getCommentaire("files",$Id);
			$result = $results[0];
			if ($result["visible"] == "1") {
				$checked = " checked=\"checked\"";
				$ongletcourant = "comment";
			}
			else {
				$checked = "";
				$ongletcourant = "nocomment";
			}
			$valid = '<input type="checkbox" value="1" name="visible" id="visible" '.$checked.'><label for="visible">'._BOARDVALIDATEEDIT.'</label>';
			
		}
		else {
			$valid = '<input type="checkbox" value="1" name="visible" id="visible" checked="checked"><label for="visible">'._BOARDVALIDATEEDIT.'</label>';
			$ongletcourant = "comment";
		}
		$sortie = '<form name="editcomm" action="system.php?op=board&action=save_comm&onglet='.$ongletcourant.'" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDAUTHOREDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="nomprenom" value="'.$result["nomprenom"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDMAILDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="email" value="'.$result["email"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDCOMMENTEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="commentaire" cols="50" rows="10" class="saisie">'.$result["commentaire"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDDATECOMM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="dateajout" value="'.utilFuncs_SimpleBoard::date2JMA($result["dateajout"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td colspan="2">';
		$sortie .= '<hr />';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDUSEREDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="auteur" value="'.$result["auteur"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDANSWEREDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="reponse" cols="50" rows="10" class="saisie">'.$result["reponse"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _BOARDVALIDSTATEEDIT;
		$sortie .= '</td><td>';
		$sortie .= $valid;
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._BOARDSAVEBTN.'" name="validbtn">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_commentaire ($Id, $nomprenom, $email, $commentaire, $dateajout, $auteur, $reponse, $visible, $page,$search_words="") {
		if ($dateajout == "") {
			$dateajout = date("d/m/Y H:i:s");
		}
		$dateajout = utilFuncs_SimpleBoard::date2AMJ($dateajout);
		$comm = array(
			"Id"=>$Id,
			"nomprenom"=>$nomprenom,
			"email"=>$email,
			"commentaire"=>$commentaire,
			"dateajout"=>$dateajout,
			"auteur"=>$auteur,
			"reponse"=>$reponse,
			"visible"=>$visible
		);
		$obj_comm = new BD_Livre();
		if (!$obj_comm->saveCommentaire($comm) ) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_commentaire($Id,$page,$search_words,$onglet,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Livre();
				if($obj_ads->delCommentaire($Id)) {
					if ($onglet == "comment") {
						$sortie = list_commentaire($page,$search_words,true);
						$operationOnglet = _BOARDLIST;
					}
					else {
						$sortie = list_commentaire($page,$search_words,false);
						$operationOnglet = _BOARDLISTNO;
					}
					return (array($sortie,$operationOnglet));
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._BOARDCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=board&action=delete_comm&onglet='.$onglet.'&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._BOARDYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._BOARDNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				if ($onglet == "ads") {
					$operationOnglet = _BOARDLIST;
				}
				else {
					$operationOnglet = _BOARDLISTNO;
				}
				return (array($sortie,$operationOnglet));
			}
		}
		return list_commentaire($page,$search_words,(($onglet == "comment") ? true : false));
	}

	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_comm(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$image,$search_words,$cat, $confirm,$valid;
		global $Id, $nomprenom, $email, $commentaire, $dateajout, $auteur, $reponse, $visible;

		include("system/header_system.php");


		if (!isset($action) || $action == "") {
			$action = "list_comm";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
			case "list_comm" :
				$sortie = list_commentaire($page,$search_words,true);
				$operationOnglet = _BOARDLIST;
				break;
			case "list_comm_no" :
				$sortie = list_commentaire($page,$search_words,false);
				$operationOnglet = _BOARDLISTNO;
				break;
			case "edit_comm" :
				$sortie = edit_commentaire($Id,$page,$search_words);
				$operationOnglet = _BOARDEDIT;
				break;
			case "save_comm" :
				if (save_commentaire($Id, $nomprenom, $email, $commentaire, $dateajout, $auteur, $reponse, $visible, $page,$search_words)) {
					if ($onglet == "comment") {
						$sortie = list_commentaire($page,$search_words,true);
						$operationOnglet = _BOARDLIST;
					}
					else {
						$sortie = list_commentaire($page,$search_words,false);
						$operationOnglet = _BOARDLISTNO;
					}
				}
				break;
			case "add_comm" :
				$sortie = edit_commentaire("",$page,$search_words);
				$operationOnglet = _BOARDNEWCOMM;
				break;	
			case "search_comm" :
				$sortie = list_commentaire($page,$search_words,(($valid=="1")? true : false));
				$operationOnglet = _BOARDLISTFOUND;
				break;
			case "delete_comm" :
				list($sortie,$operationOnglet) = delete_commentaire($Id,$page,$search_words,$onglet,$confirm);
				break;
		}

		if (!isset($onglet)) {
			$onglet = "comment";
		}
		if ($onglet == "") {
			$onglet = "comment";
		}
		$ongletDef=array("comment"=> array( "text"=>_BOARDONGLETLIST, "url"=>"system.php?action=list_comm&op=board&onglet=comment"),
						"nocomment"=> array( "text"=>_BOARDONGLETLISTNOVALID, "url"=>"system.php?action=list_comm_no&op=board&onglet=nocomment"));

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_board.css\">";
		GraphicAdmin(_BOARDMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "board":
			process_comm();
			break;
	}
}
else {
	display_denied();
}

?>