	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function GetMap(id) {
		if (GBrowserIsCompatible()) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			
			map = new GMap2(leDiv);
			//restriction des niveaux de zoom
			if ((! isNaN(options["zoom_min"] + options["zoom_max"]))) {
				var mt = map.getMapTypes();
				for (var i=0; i<mt.length; i++) {
					if (options["zoom_min"] != "") {
						mt[i].getMinimumResolution = function() {
							return options["zoom_min"]; 
						};
					}
					if (options["zoom_max"] != "") {
						mt[i].getMaximumResolution = function() {
							return options["zoom_max"];
						};
					}
				}
				//puisque G_PHYSICAL_MAP n''est pas retourn par getMapTypes()
				if (options["zoom_min"] != "") {
					G_PHYSICAL_MAP.getMinimumResolution = function() {
						return options["zoom_min"]; 
					};
				}
				if (options["zoom_max"] != "") {
					G_PHYSICAL_MAP.getMaximumResolution = function() {
						return options["zoom_max"];
					};
				}
			}
			
			if (options["controles"]) {
				//map.addControl(new GSmallMapControl());//mini controle de zoom et de navigation
				//map.addControl(new GMapTypeControl());
				map.addControl(new GLargeMapControl());
				//map.addControl(new GScaleControl()) ;
				//map.addControl(new GOverviewMapControl()) ;
			}
			var type_carte = G_HYBRID_MAP;
			if (options["type_map"] == "P") {
				type_carte = G_NORMAL_MAP;
			}
			if (options["type_map"] == "S") {
				type_carte = G_SATELLITE_MAP;
			}
			if (options["type_map"] == "R") {
				type_carte = G_PHYSICAL_MAP;
			}
			map.setCenter(new GLatLng(latitudeinit, longitudeinit), zoominit, type_carte);
		
			//ajout bouton d'impression
			if (options["print"]) {
				function PrintControl() {
				}
				PrintControl.prototype = new GControl();
				PrintControl.prototype.initialize = function(map) {
					var container = document.createElement("div");
				
					var printDiv = document.createElement("div");
					this.setButtonStyle_(printDiv);
					container.appendChild(printDiv);
					image = document.createElement('img');
					image.src = racine_lib_module+"/icns/printer.gif";
					image.title = "Imprimer carte";
					printDiv.appendChild(image);
					GEvent.addDomListener(printDiv, "click", function() {
				   		window.print();
					});
				
					map.getContainer().appendChild(container);
					return container;
				};
				
				PrintControl.prototype.getDefaultPosition = function() {
				  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(24, 290));
				};
			
				// Sets the proper CSS for the given button element.
				PrintControl.prototype.setButtonStyle_ = function(button) {
				  button.style.textDecoration = "none";
				  button.style.lineHeight = "12px";
				  button.style.color = "#0000cc";
				  button.style.backgroundColor = "white";
				  button.style.border = "1px solid black";
				  button.style.padding = "2px";
				  button.style.marginBottom = "3px";
				  button.style.textAlign = "center";
				  button.style.cursor = "pointer";
				};
			
				map.addControl(new PrintControl());
			}
			//fin bouton d'impression

			
			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = map.getZoom();
	
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.shadowSize = new GSize(22, 20);
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2),Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						if (options["bulle"] == "T") {
							marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
						}
						if (options["bulle"] == "C") {
							marker.openInfoWindowHtml('<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>',{ maxWidth:230 });
							
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = dMapDiv.firstChild.nextSibling.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
						if (options["bulle"] == "TC") {
							if (cont_mess !="") {
								var tab1 = new GInfoWindowTab("Info", cont_mess);
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>');
								var infoTabs = [tab1,tab2];
							}
							else {
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13;"></div>');
								var infoTabs = [tab2];
							}
							marker.openInfoWindowTabsHtml(infoTabs,{ maxWidth:230 });
							if (detailmap != null) {
								detailmap = null;
								dMapDiv = null;
							}
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = CopyrightDiv.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getCurrentMapType() == G_NORMAL_MAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				var icone = new GIcon();
				icone.image = racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte;
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				
				if (fiche == "") {
					var marker = new GMarker(point, icone, {clickable: false, draggable: false});
				}
				else {
					var marker = new GMarker(point, icone);
					GEvent.addListener(marker, "click", function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);
			}
			
			//crer polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new GPolygon(decodeLine(points), couleur, epaisseur, 1, couleur, opacite);
				}
				else {
					var polygone = new GPolyline.fromEncoded({
						color: couleur,
						weight: epaisseur,
						opacity : opacite,
						points: points,
						levels: visibilite,
						numLevels: 3,
						zoomFactor: 12
					});
				}
				if (fiche != "" && plein == "1") {
					GEvent.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var polygone_courant = getXMLchild(polygones,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							map.addOverlay(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			
			//ajout de membres
			function createMembre(point,infos,nom,chemicone,url) {
				//var echelle = map.getZoom();
	
				var icone = new GIcon();
				icone.image = chemicone;
				var taille = 24;
				var largeur = taille;
				var hauteur = taille;
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2) , Math.ceil(hauteur/2));
				icone.shadow = "modules/SimpleAnnuComp/images/ombre.png";
				icone.shadowSize = new GSize(32, 32);
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				
				GEvent.addListener(marker, "click", function() {
					var cont_mess = "";
					cont_mess = "<h1>" + nom + "</h1>";
					cont_mess += "<p>" + infos + "</p><p>&nbsp;</p><p>" + "<a href=\"" + url + "\">Fiche de l'annuaire</a>" + "</p>";
					marker.openInfoWindowHtml(cont_mess,{ maxWidth:150 });
				});
				return marker;
			}
			
			//affiche les membres
			function afficheMembres() {
				var points = getXMLchild(racine_carte,"membres");
				if (points != null) {
					var point_courant = getXMLchild(points,"membre");
					while (point_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude_membre")), eval(getXMLvalue(point_courant,"longitude_membre")));
						var nom = getXMLvalue(point_courant,"raison");
						var chemicone = getXMLvalue(point_courant,"picto_membre");
						var infos = getXMLvalue(point_courant,"metier");;
						var url = "modules.php?name=SimpleAnnuComp&sop=viewActeur&Id="+getXMLparam(point_courant,"Id");
						var tempMark = createMembre(point2,infos,nom,chemicone,url);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//action sur la carte
			GEvent.addListener(map, "click", function(marker, point) {
				if (marker == null) {
					map.panTo(point);
				}
			});
			
			GEvent.addListener(map, "zoomend", function() {
				/*map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficheLemmes();*/
			});
			
			GEvent.addListener(map, "moveend", function() {
				var centre = map.getCenter();
				localisation_vue(centre.lat(),centre.lng());
			});
			
			GEvent.addListener(map, "maptypechanged", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				synchro_minimap();
			});
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficheMembres();
			//legende(id,rep,'leg',expression);
			if (options["mini_vue"]) {
				minivue();
			}
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre  jour.");
		}
	}
	
	function legende(id,zone_id) {
		if (cartes == null) {
			cartes = GetXMLSymbols(id);
		}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");	
		var points = getXMLchild(racine_carte,"legendes");
		if (points != null) {
			var point_courant = getXMLchild(points,"legende");
			var observations = "";
			observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"legende\">";
			observations += "<tr><th colspan=\"2\">Lemmes</th></tr>";
			while (point_courant) {
				var chemicone = getXMLvalue(point_courant,"picto_leg");
				var lemme = getXMLvalue(point_courant,"lemme_leg");
				observations += "<tr>";
				observations += "<td>";
				observations += "<img src=\""+chemicone+"\" />";
				observations += "</td><td>";
				observations += lemme;
				observations += "</td>";
				observations += "<tr>";
				point_courant = next_sibling(point_courant);
			}
		}
		observations += "</table>";
		
  		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = observations;
	}
	
	function listLieux(id,zone_id) {
		if (options["obs"]) {
			if (cartes == null) {
				cartes = GetXMLSymbols(id);
			}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");	
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				var observations = "";
				observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"observations\">";
				observations += "<tr><th colspan=\"4\">D&eacute;tails</th></tr>";
				while (point_courant) {
					var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					
					observations += "<tr>";
					observations += "<td>";
					observations += "<img src=\""+chemicone+"\" />";
					observations += "</td><td>";
					observations += message;
					observations += "</td><td>";
					observations += commentaire;
					observations += "</td><td>";
					if (fiche != "") {
						observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
					}
					observations += "</td>";
					observations += "<tr>";
					
					point_courant = next_sibling(point_courant);
				}
			}
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones,"polygone");
				while (polygone_courant) {
					var nom =  getXMLvalue(polygone_courant,"nom");
					var details =  getXMLvalue(polygone_courant,"details");
					var couleur = getXMLvalue(polygone_courant,"couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
					var points = getXMLvalue(polygone_courant,"polyencode");
					var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
					var plein = getXMLvalue(polygone_courant,"plein");
					observations += "<tr>";
						observations += "<td>";
						observations += "<div style=\"display: block; line-height: 1px; width: 30px; height: "+epaisseur+"; background-color: "+couleur+"; filter: alpha(opacity="+eval(opacite*100)+"); -moz-opacity: "+opacite+"; opacity: "+opacite+" \"></div>";
						observations += "</td><td>";
						observations += nom;
						observations += "</td><td>";
						observations += details;
						observations += "</td><td>";
						observations += "</td>";
						observations += "<tr>";
					polygone_courant = next_sibling(polygone_courant);
				}
			}
			observations += "</table>";
			
	  		var ie = false;
			if (document.all) {
				ie = true;
			}
			if (ie) {
				 var leDiv = document.all[zone_id];
			}
			else {
				var leDiv =  document.getElementById(zone_id);
			}
			if (leDiv == null) {
				return false;
			}
			leDiv.innerHTML = observations;
		}
	}
	
	function ajout_bouton(map_x, pos_x, texte, commentaire, latitude, longitude, zoom, etat) {
		function VillageControl() {
		}
		VillageControl.prototype = new GControl();
		VillageControl.prototype.initialize = function(map_x) {
			var container = document.createElement("div");
			
			var villageDiv2 = document.createElement("div");
			this.setButtonStyle2_(villageDiv2);
			container.appendChild(villageDiv2);
			villageDiv2.title = commentaire;
			
			var villageDiv = document.createElement("div");
			this.setButtonStyle_(villageDiv);
			villageDiv2.appendChild(villageDiv);
			villageDiv.appendChild(document.createTextNode(texte));
			//image = document.createElement('img');
			//image.src = racine_lib_module+"/icns/printer.gif";
			//image.title = "Zoom sur village";
			//villageDiv.appendChild(image);
			GEvent.addDomListener(villageDiv, "click", function() {
		   		map_x.setCenter(new GLatLng(latitude, longitude), zoom, etat);
			});
			
			map_x.getContainer().appendChild(container);
			return container;
		};
		
		VillageControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(90+((pos_x-1)*90), 7));
		};
		
		// Sets the proper CSS for the given button element.
		VillageControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "10px";
		  button.style.color = "#000000";
		  button.style.font = "small Arial";
		  button.style.fontSize = "12px";
		  button.style.borderStyle = "solid";
		  button.style.borderColor = "white rgb(176, 176, 176) rgb(176, 176, 176) white";
		  button.style.borderWidth = "1px";
		};
		VillageControl.prototype.setButtonStyle2_ = function(button) {
		  button.style.backgroundColor = "white";
		  button.style.border = "1px solid black";
		  button.style.padding = "0px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  button.style.width = "5em";
		  button.style.cursor = "pointer";
		};
		map_x.addControl(new VillageControl());
	}
	
	
	function synchro_minimap() {
		if (minimap != null) {
			minimap.setMapType(map.getCurrentMapType());
		}
	}
	
	function Rectangle(bounds, opt_weight, opt_color) {
      this.bounds_ = bounds;
      this.weight_ = opt_weight || 2;
      this.color_ = opt_color || "#ff7700";
    }
    Rectangle.prototype = new GOverlay();

    // Creates the DIV representing this rectangle.
    Rectangle.prototype.initialize = function(map) {
		var divRect = document.createElement("div");
		divRect.style.border = this.weight_ + "px solid " + this.color_;
		divRect.style.position = "absolute";
		divRect.style.overflow = "hidden";
		divRect.style.top = "0px";
		divRect.style.left = "-500px";
		map.getPane(G_MAP_MAP_PANE).appendChild(divRect);

		this.map_ = map;
		this.div_ = divRect;
    };

    // Remove the main DIV from the map pane
    Rectangle.prototype.remove = function() {
      this.div_.parentNode.removeChild(this.div_);
    };

    // Copy our data to a new Rectangle
    Rectangle.prototype.copy = function() {
      return new Rectangle(this.bounds_, this.weight_, this.color_,
                           this.backgroundColor_, this.opacity_);
    };

    // Redraw the rectangle based on the current projection and zoom level
    Rectangle.prototype.redraw = function(force) {
      // We only need to redraw if the coordinate system has changed
      if (!force) return;

      // Calculate the DIV coordinates of two opposite corners of our bounds to
      // get the size and position of our rectangle
      var c1 = this.map_.fromLatLngToDivPixel(this.bounds_.getSouthWest());
      var c2 = this.map_.fromLatLngToDivPixel(this.bounds_.getNorthEast());

      // Now position our DIV based on the DIV coordinates of our bounds
      this.div_.style.width = Math.abs(c2.x - c1.x) + "px";
      this.div_.style.height = Math.abs(c2.y - c1.y) + "px";
      //spcifique IE vince
      if (document.all) {
      	this.div_.style.width = Math.abs(c2.x - c1.x) + (this.weight_ * 2) + "px";
      	this.div_.style.height = Math.abs(c2.y - c1.y) + (this.weight_ * 2) + "px";
      }
      this.div_.style.left = (Math.min(c2.x, c1.x) - this.weight_) + "px";
      this.div_.style.top = (Math.min(c2.y, c1.y) - this.weight_) + "px";
    };
	
	function localisation_vue(latitude,longitude) {
		if (minimap != null) {
		    /*
		    //10 KM x 10 KM
		    var lngDelta = 0.0607;
	        var latDelta = 0.04493;*/
	        
	        var z_vue = map.getBounds();
	        var lngDelta = (z_vue.getNorthEast().lng() - z_vue.getSouthWest().lng())/2;
	        var latDelta = (z_vue.getNorthEast().lat() - z_vue.getSouthWest().lat())/2;
	        
	        var pointmini = new GLatLng(eval(latitude),eval(longitude));
	        var rectBounds = new GLatLngBounds(
	           new GLatLng(eval(pointmini.lat() - latDelta), eval(pointmini.lng() - lngDelta)),
	           new GLatLng(eval(pointmini.lat() + latDelta), eval(pointmini.lng() + lngDelta)));
	        moncadre = new Rectangle(rectBounds);
	        minimap.clearOverlays();
	        minimap.addOverlay(moncadre);
	   }
	};
	
	function show_minivue() {
		var minimapDiv = document.getElementById("minimap");
		if (minimapDiv == null) {
			return false;
		}
		minimapDiv.style.display='block';
	};
	
	function minivue() {
		
		//ajout bouton de revisualsation
		function OpenControl() {
		};
		OpenControl.prototype = new GControl();
		OpenControl.prototype.initialize = function(minimap) {
			var container = document.createElement("div");
			var OpenDiv = document.createElement("div");
			this.setButtonStyle_(OpenDiv);
			container.appendChild(OpenDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/show_mini.gif";
			image.title = "Afficher mini-carte";
			OpenDiv.appendChild(image);
			GEvent.addDomListener(OpenDiv, "click", function() {
		   		minimapDiv.style.display='block';
			});
		
			map.getContainer().appendChild(container);
			return container;
		};
		
		OpenControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_BOTTOM_RIGHT, new GSize(0, 0));
		};
	
		// Sets the proper CSS for the given button element.
		OpenControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "7px";
		  button.style.color = "#0000cc";
		  button.style.backgroundColor = "white";
		  //button.style.font = "small Arial";
		  button.style.border = "1px solid black";
		  //button.style.border = "none";
		  button.style.padding = "1px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  //button.style.width = "6em";
		  button.style.cursor = "pointer";
		};
		map.addControl(new OpenControl());
		//fin bouton revisualsation

		
		//affichage d'une minimap  la place du controle 
		var mapDiv = document.getElementById("map");
		if (mapDiv == null) {
			return false;
		}
		
		var minimapDiv=document.createElement('div');
		minimapDiv.setAttribute('id','minimap');
		minimapDiv.style.width='70px';
		minimapDiv.style.height='120px';
		minimapDiv.style.borderWidth = "4px 1px 1px 4px";
		minimapDiv.style.borderColor = "#ffffff #888888 #888888 #ffffff";
		minimapDiv.style.borderStyle = "solid";
		minimapDiv.style.overflow = "hidden";
		minimapDiv.style.position='absolute';
		minimapDiv.style.left='-500px';
		minimapDiv.style.top='0px';
		
		mapDiv.appendChild(minimapDiv);
		
		minimap = new GMap2(minimapDiv);
		minimap.setCenter(new GLatLng(42.17154633452751, 9.1241455078125), 6, map.getCurrentMapType());
		minimap.disableDragging();
		minimap.disableDoubleClickZoom();
		
		var miniCopyrightDiv = minimapDiv.firstChild.nextSibling;
		var miniCopyrightImg = miniCopyrightDiv.nextSibling;
		miniCopyrightDiv.style.display = "none"; 
		miniCopyrightImg.style.display = "none";
		var decalageX = mapDiv["offsetWidth"] - minimapDiv["offsetWidth"];
		var decalageY = mapDiv["offsetHeight"] - minimapDiv["offsetHeight"];
		//var x = eval(calculeX(champ) + decalageX);
		//var y =  eval(calculeY(champ) + decalageY);
		//minimapDiv.style.left=x+'px';
		//minimapDiv.style.top=y+'px';
		minimapDiv.style.left= decalageX+'px';
		minimapDiv.style.top= decalageY+'px';
		
		//fin ajout localisation
		localisation_vue(latitudeinit,longitudeinit);
		
		//ajout bouton de fermeture
		function CloseControl() {
		};
		CloseControl.prototype = new GControl();
		CloseControl.prototype.initialize = function(minimap) {
			var container = document.createElement("div");
		
			var CloseDiv = document.createElement("div");
			this.setButtonStyle_(CloseDiv);
			container.appendChild(CloseDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/miniclose.gif";
			image.title = "Fermer mini-carte";
			CloseDiv.appendChild(image);
			GEvent.addDomListener(CloseDiv, "click", function() {
		   		minimapDiv.style.display='none';
			});
		
			minimap.getContainer().appendChild(container);
			return container;
		};
		
		CloseControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_RIGHT, new GSize(0, 0));
		};
	
		// Sets the proper CSS for the given button element.
		CloseControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "7px";
		  button.style.color = "#0000cc";
		  button.style.backgroundColor = "white";
		  //button.style.font = "small Arial";
		  button.style.border = "1px solid black";
		  //button.style.border = "none";
		  button.style.padding = "1px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  //button.style.width = "6em";
		  button.style.cursor = "pointer";
		};
		minimap.addControl(new CloseControl());
		//fin bouton fermeture
	};
	
	function titrer(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var titre = getXMLvalue(racine_carte,"titre");
		
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = titre;
	}
	
	function commenter(id, zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var commentaire = getXMLvalue(racine_carte,"page_carte");
		if (commentaire == "") {
			commentaire = getXMLvalue(racine_carte,"commentaire");
		}
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = commentaire;
	}
	
	function GetXMLSymbols(id) {
		var sortie = "";
		if (id != "") {
			var idcarte = "&Idc="+id;
		}
		else {
			var idcarte = "";
		}
		var sources_cartes = "modules.php?name=SimpleAnnuComp&sop=map_annu_XML"+idcarte;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	//]]>