<?php

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function list_index($nbreFiches, $page, $ligne_par_page,$cat) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._CHUCKFOUND;
	}
	else {
		$indexPages .= _CHUCKNOTFOUND;
	}
	$indexPages .= _CHUCKPAGES;
	if ($min < $liminf) {
		if ($min == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$min";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$min\">$min</a>";
			$indexPages .= "</div>";
		}
		if ($min < $liminf - 1) {
			$indexPages .= "...";
		}
	}
	for ($i=$liminf;$i<=$limsup;$i++) {
		if ($i == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$i";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$i\">$i</a>";
			$indexPages .= "</div>";
		}
	}
	if ($max > $limsup) {
		if ($max > $limsup + 1) {
			$indexPages .= "...";
		}
		if ($max == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$max";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$max\">$max</a>";
			$indexPages .= "</div>";
		}

	}
	$indexPages .= "</div>";
	return $indexPages;
}

function list_by_cats() {
	global $module_name;
	$sortie = "<h1>"._ADSTITLE."</h1>";

	$ligne_par_cat = 5;

	$obj_ads = new BD_Ads();
	$results = $obj_ads->getCats();
	foreach($results as $result) {
		list($Id,$categorie,$image) = $result;
		$sortie .= '&nbsp;<br /><fieldset><legend>';
		$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">'.$categorie;
		$sortie .='</legend>';

		$result2s = $obj_ads->getAds("files","",$Id,"","","","","","0,".$ligne_par_cat);
		//print_r($result2s);
		if (count($result2s) != 0) {
			$sortie .= "<ul>";
			foreach($result2s as $result2) {
				list($Id_ads,$object) = $result2;
				$sortie .= '<li>'.$object.'</li>';
			}
			$sortie .= '<li>...</li>';
			$sortie .= '</ul>';
			$sortie .= '<hr  class="cats" />';
			$sortie .= '<p class="actions">';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=ads_for_cat&Id='.$Id.'">'._ADSALLADS.'</a>';
			$sortie .= ' &bull; ';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_ads&Id='.$Id.'">'._ADSNEWONE.'</a>';
			$sortie .= '</p>';
		}
		else {
			$sortie .= '<p>'._ADSNOADS.'</p>';
			$sortie .= '<hr  class="cats" />';
			$sortie .= '<p class="actions">';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_ads&Id='.$Id.'">'._ADSNEWONE.'</a>';
			$sortie .= '</p>';
		}
		$sortie .= '</fieldset>';
	}
	return $sortie;
}

function list_for_cat($cat,$page) {
	global $module_name;

	$ligne_par_page = 2;

	$obj_ads = new BD_Ads();
	$results = $obj_ads->getCats($cat);
	$result = $results[0];
	list($cat,$categorie,$image) = $result;
	$sortie = "<h1>".'<img src="images/topics/'.$image.'" alt="'.$categorie.'" class="ads">'.$categorie."</h1>";
	$sortie .= '&nbsp;<br />';
	//$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">';

	if ($page=="-1") {
		$page = ceil($nbrefiches/$ligne_par_page);
	}

	$aujourdhui = date("d/m/Y");

	$nbreFiches = $obj_ads->getAds("count","",$cat,$aujourdhui,$aujourdhui,"","","","");
	$indexlist = list_index($nbreFiches, $page, $ligne_par_page,$cat);

	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";

	//$sortie .= '&nbsp;<br />';
	$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
	$result2s = $obj_ads->getAds("files","",$cat,$aujourdhui,$aujourdhui,"","","",$limit);
	//print_r($result2s);
	if (count($result2s) != 0) {
		foreach($result2s as $result2) {
			list($Id_ads,$object,$content) = $result2;
			$sortie .= '<h2 class="ads">'.$object.'</h2>';
			$sortie .= '<p class="ads">'.$content.'</p>';
		}
	}
	//$sortie .= '&nbsp;<br />';
	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	return $sortie;
}

function edit_ads($cat_id) {
	global $module_name, $user;
	$obj_cat = new BD_Ads();
	$results = array();

	$menu_cat = '<select name="categorie" size="1" class="saisie">';
	$cats = $obj_cat->getCats();
	foreach($cats as $cat) {
		$selected = "";
		if ($cat["Id"] == $cat_id) {
			$selected = ' selected="selected"';
		}
		$menu_cat .= '<option value="'.$cat["Id"].'"'.$selected.'>'.$cat["categorie"].'</option>';
	}
	$menu_cat .= '</select>';

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata_tab = explode(":", $user_data_bloc);
		$redacteur = $userdata_tab[0];
	}
	else {
		$redacteur = "-1";
	}

	$menu_user = '<select name="redacteur" size="1">';
	$users = $obj_cat->get_users();
	foreach($users as $userm) {
		$selected = "";
		if ($userm["uid"] == $redacteur) {
			$selected = ' selected="selected"';
		}
		$menu_user .= '<option value="'.$userm["uid"].'"'.$selected.'>'.$userm["uname"].'</option>';
	}
	$menu_user .= '</select>';

	$sortie = '<h1>'._ADSEDIT.'</h1>';
	$sortie .= '<form name="editads" action="modules.php?name='.$module_name.'&sop=save_ads" method="POST">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._ADSFILEEDIT.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	$sortie .= '<tr><td>';
	$sortie .= _ADSOBJECTEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="object" value="'.$result["object"].'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSMESSAGEEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="content" cols="50" rows="10" class="saisie">'.$result["content"].'</textarea>';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSCATEDIT;
	$sortie .= '</td><td>';
	$sortie .= $menu_cat;
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSSAISIEEDIT;
	$sortie .= '</td><td>';
	list($t1,$t2) = explode(" ",$result["date_saisie"]);
	$t1 = utilFuncs::date2JMA($t1);
	$result["date_saisie"] = $t1." ".$t2;
	$sortie .= '<input type="text" name="date_saisie" value="'.$result["date_saisie"].'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSDEBEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="date_debut" value="'.utilFuncs::date2JMA($result["date_debut"]).'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSFINEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="date_fin" value="'.utilFuncs::date2JMA($result["date_fin"]).'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _ADSUSEREDIT;
	$sortie .= '</td><td>';
	$sortie .= $menu_user;
	$sortie .= '</td></tr>';
	$sortie .= '</table>';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie .= "</form>";
	$sortie .= '</fieldset>';
	return $sortie;
}

function displayListByCats() {
	global $module_name;
	include ('header.php');
	echo list_by_cats();
	$bardef=array("print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function displayListForCat($cat,$page) {
	global $module_name;
	include ('header.php');
	echo list_for_cat($cat,$page);
	$bardef=array("print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function addNewAds($cat) {
	global $module_name;
	include ('header.php');
	echo edit_ads($cat);
	$bardef=array("print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function print_facts($page) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db;

	if (file_exists("themes/$Default_Theme/style/Sections.css")){
		$moduleStyle= "<LINK REL=\"stylesheet\" HREF=\"themes/$Default_Theme/style/Chuck_Norris_Facts.css\" TYPE=\"text/css\">\n";
	} else if (file_exists("modules/Sections/css/default.css")) {
		$moduleStyle= "<LINK REL=\"StyleSheet\" HREF=\"modules/Chuck_Norris_Facts/css/default.css\" TYPE=\"text/css\">\n";
	} else $moduleStyle="";

	echo "
	<html>
	<head>
	<title>$sitename</title>
	<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
	<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	$moduleStyle
	</head>
	<body bgcolor=\"#FFFFFF\" text=\"#000000\">
	<table border=\"0\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
	<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
	<div class=\"zprint\">"
	.list_citations($page)
	."</div>
		</td></tr></table></td></tr></table>

		<div class=\"printFooter\">
		<div class=\"siteName\">
    "._COMESFROM." $sitename<br>
	<a href=\"$nukeurl\">$nukeurl</a>
	</div>
	<div class=\"pageURL\">
    "._THEURL."<br>
	<a href=\"$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page\">$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page</a>
	</div>
	</div>
	</td></tr></table>
	</body>
	</html>
    ";

}

if (!isset($page)) {
	$page = "1";
}
if ($page == "") {
	$page = "1";
}

switch($sop) {
	case "list":
		displayListByCats();
		break;
	case "ads_for_cat":
		displayListForCat($Id,$page);
		break;
	case "new_ads":
		addNewAds($Id);
		break;
	case "print":
		print_facts($page);
		break;
	default:
		displayListByCats();
		//echo "Aucune opration  effectuer n'a t choisie'";
		break;
}
?>