	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = google.maps.MapTypeId.HYBRID;
		if (letype == "P") {
			type_carte = google.maps.MapTypeId.ROADMAP;
		}
		if (letype == "S") {
			type_carte = google.maps.MapTypeId.SATELLITE;
		}
		if (letype == "R") {
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		if (letype == "3D") {
			//type_carte = G_SATELLITE_3D_MAP;
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		return false;
		/*if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}*/
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function clearOverlays() {
		for (var i = 0; i < markers.length; i++) {
		   markers[i].setMap(null);
		}
		markers = [];
	}
	
	function GetMap(id,idadh) {
		/*if (map != null) {
			return true;
		}*/
		if (window.JSON) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id,idadh);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			/*var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			*/
			
			//var type_carte = theMapType(options["type_map"]);
			if (options["centermap"].lat() != 0 || options["centermap"].lng() != 0) {
				var centre = options["centermap"];
			}
			else {
				var centre = new google.maps.LatLng(latitudeinit, longitudeinit);
			}
			
			var mapOptions = {
				center: centre,
		        zoom: zoominit,
		        mapTypeId: google.maps.MapTypeId.ROADMAP,
		        panControl: false,
    			zoomControl: false,
    			scaleControl: true,
    			streetViewControl: true,
    			streetViewControlOptions: {
			        position: google.maps.ControlPosition.TOP_RIGHT
			    }
		    };

			map = new google.maps.Map(leDiv, mapOptions);
			map.setTilt(45);
						
			//ajout boutons zoom
			function ZoomPlusControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoomplus.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()+1);
				});
				return container;
			}
			var ZoomPlusControlDiv = new ZoomPlusControl(map);
			ZoomPlusControlDiv.index = 1;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomPlusControlDiv);
			
			function ZoomMoinsControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoommoins.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()-1);
				});
				return container;
			}
			var ZoomMoinsControlDiv = new ZoomMoinsControl(map);
			ZoomMoinsControlDiv.index = 2;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomMoinsControlDiv);
			//fin boutons zoom
			
			if(options["displayitineraire"] == "1") {
				function ItineraireControl(map) {
					var container = document.createElement("div");
					container.style.marginTop = "10px";
					container.style.marginBottom = "10px";
					container.style.marginRight = "10px";
					container.style.backgroundColor = "#FFFFFF";
	                container.style.height = "40px";
	                container.style.width = "40px";
					var containerDiv = document.createElement("div");
					containerDiv.style.cursor = "pointer";
					container.appendChild(containerDiv);
					image = document.createElement('img');
					image.src = racine_lib_module+"/icns/btn_directions.png";
					image.style.width = "30px";
	                image.style.marginLeft = "5px";
	                image.style.marginTop = "5px";
					image.title = "Tracer l'itineraire";
					containerDiv.appendChild(image);
					google.maps.event.addDomListener(containerDiv, "click", function() {
						getCurrentPositionGps();
					});
					return container;
				}
				var ItineraireControlDiv = new ItineraireControl(map);
				ItineraireControlDiv.index = 2;
				map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(ItineraireControlDiv);
			}
			
			/**
			 * Fonction permettant de récupérer la position GPS et de tracer l'itineraire
			 */
			function getCurrentPositionGps() {
				if (navigator.geolocation) {
					navigator.geolocation.getCurrentPosition(
						successCallbackGps, 
						errorCallbackGps, 
						{
							enableHighAccuracy:true, 
							timeout:30000, 
							maximumAge:600000
						}
					);
				} else {
					alert("Votre navigateur ne prend pas en compte la géolocalisation HTML5");
				}
			}
			
			//afficher les points du fonds de carte
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = "<div style=\"overflow:hidden\"><div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				});
				
				var echelle = map.getZoom();
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficheLieux() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point,message,commentaire,chemicone,fiche,target)
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher les textes du fonds de carte
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
				if (test3D(map.getMapTypeId())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    size: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				if (fiche != "") {
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			function afficheTextes() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"textes");
				if (points != null) {
					var point_courant = getXMLchild(points,"texte");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_texte")), eval(getXMLvalue(point_courant,"longitude_texte")));
						var fiche = getXMLvalue(point_courant,"lien_texte");
						var target = getXMLvalue(point_courant,"cible_texte");
						var message = getXMLvalue(point_courant,"lieu_texte");
						var commentaire = getXMLvalue(point_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(point_courant,"dim_texte");
						var angletxt = getXMLvalue(point_courant,"angle_texte");
						var couleurtxt = getXMLvalue(point_courant,"couleur_texte");
						var typotxt = getXMLvalue(point_courant,"police_texte");
						var tailletxt = getXMLvalue(point_courant,"taille_texte");
						var tempMark = createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite
					  });
				}
				else {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: 0
					  });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				polygone.setMap(map);
				
				return polygone;
			}
			
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var point_courant = getXMLchild(polygones,"polygone");
					while (point_courant) {
						var couleur = getXMLvalue(point_courant,"couleur");
						var epaisseur = eval(getXMLvalue(point_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(point_courant,"opacite"));
						var points = getXMLvalue(point_courant,"polyencode");
						var visibilite = getXMLvalue(point_courant,"polyvisibilite");
						var fiche = getXMLvalue(point_courant,"lien_polygone");
						var target = getXMLvalue(point_courant,"cible_polygone");
						var plein = getXMLvalue(point_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							markers.push(tempZone);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}	
			
			//afficher les symboles
			function createMarkerSymb(point, chemicone) {
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(26,26),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(13, 13)
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      icon:image
				});
				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var tempMark = createMarkerSymb(point,chemicone);
							if (tempMark != null) {
								markers.push(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
			function afficherCBordure() {
				return true; //pour neutraliser la fonction
				/*var bordure = new GPolyline.fromEncoded({
					color: getXMLvalue(racine_carte,"points_couleur"),
					weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
					opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
					points: getXMLvalue(racine_carte,"points_bordure"),
					levels: getXMLvalue(racine_carte,"points_visibilite"),
					numLevels: 3,
					zoomFactor: 12
				});
				map.addOverlay(bordure);*/
			}
			
			/**
			 * Fonction callback en cas de succes lors de la récupération de la position GPS
			 * @param position le position GPS
			 */
			function successCallbackGps(position) {
				var positionGps = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
				if( options["centermap"].lat() > 0 && options["centermap"].lng() > 0 ) {
					calculateItineraire(positionGps, options["centermap"], false);
				}
				/*if(markers.length > 0) {
					var marker = markers[markers.length-1];
					if(marker instanceof google.maps.Marker) {
						var destination = marker.getPosition();
						calculateItineraire(positionGps, destination);
					}
				} else {
					alert("Il n'y a pas de destination");
				}*/
			}
			
			/**
			 * Fonction callback en cas d'erreur lors de la récupération de la position GPS
			 * @param error l'erreur
			 */
			function errorCallbackGps(error){
				switch(error.code){
					case error.PERMISSION_DENIED:
						alert("L'utilisateur n'a pas autorisé l'accès à sa position");
						break;      
					case error.POSITION_UNAVAILABLE:
						alert("L'emplacement de l'utilisateur n'a pas pu être déterminé");
						break;
					case error.TIMEOUT:
						alert("Le service n'a pas répondu à temps");
						break;
					default:
						alert("Le service n'a pas répondu à temps");
						break;
				}
			}
			
			/**
			 * Calcul et tracer de l'itineraire
			 * @param origin le point de depart
			 * @param destination le point d'arrivé
			 */
			function calculateItineraire(origin, destination, preserv) {
				if(origin && destination){
					cookieMap['origin'] = origin;
					cookieMap['destination'] = destination;
					var direction = new google.maps.DirectionsRenderer({
						map   : map,
						preserveViewport: preserv
					});
					var request = {
						origin      : origin,
						destination : destination,
						travelMode  : google.maps.DirectionsTravelMode.DRIVING // Type de transport
					};
					var directionsService = new google.maps.DirectionsService();
					directionsService.route(request, function(response, status){
						if(status == google.maps.DirectionsStatus.OK){
							direction.setDirections(response);
							var routes = response.routes;
							if(routes && routes.length > 0) {
								var legs = routes[0].legs;
	
								if( displayDist === false ) {
									var map_height = document.getElementById('gmapHotel').style.height;
									map_height = map_height.replace('px', '');
									map_height -= 30;
									document.getElementById('gmapHotel').style.height = map_height + "px";
									document.getElementById('coordMap').style.height = "50px";
									displayDist = true;
								}
								
								calculDistanceItineraire(legs);
								calculDurationItineraire(legs);
								if (typeof(setCartoAdhsSize) == "function") {
									setCartoAdhsSize();
								}
							}
						}
					});
				}
			}
			
			/**
			 * Calcul la distance du trajet par rapport a l'itineraire tracer
			 * @param legs
			 */
			function calculDistanceItineraire(legs) {
				if(legs) {
					var strDistance;
					var totalDistance = 0;
					for(var i = 0; i < legs.length; i++) {
						totalDistance += legs[i].distance.value;
					}
					if( totalDistance >= 1000 ) {
						var km = Math.floor(totalDistance / 1000);
						var m = totalDistance - (km * 1000);
						strDistance = km + " km " + m + " m";
					} else {
						strDistance = totalDistance + " m";
					}
					
					document.getElementById('distance_value_itineraire').innerHTML = "&nbsp;&nbsp;&nbsp;" + strDistance;
					document.getElementById('distance_itineraire').style.display = "table-row";
				}
			}
			
			/**
			 * Calcul le temps du trajet par rapport a l'itineraire trace
			 * @param legs
			 */
			function calculDurationItineraire(legs) {
				if(legs) {
					var strDuration = "";
					var totalDuration = 0;
					for(var i = 0; i < legs.length; i++) {
						totalDuration += legs[i].duration.value;
					}
					var reste = totalDuration;
					
					var heures = Math.floor(totalDuration / 3600);
					reste -= heures*3600;
					var minutes = Math.floor(reste/60);
					reste -= minutes*60;
					var secondes = reste;
					
					if(heures > 0) {
						strDuration += heures + " h ";
					}
					if(minutes > 0) {
						strDuration += minutes + " m ";
					}
					if(secondes > 0) {
						strDuration += secondes + " s";
					}
					
					document.getElementById('duration_value_itineraire').innerHTML = "&nbsp;&nbsp;&nbsp;" + strDuration;
					document.getElementById('duration_itineraire').style.display = "table-row";
				}
			}
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			
			//*********************************************************************************
			
			document.getElementById('distance_itineraire').style.display = "none";
			document.getElementById('duration_itineraire').style.display = "none";
			document.getElementById('coordMap').style.height = "20px";
			displayDist = false;
			
			if(cookieMap['mapType']) {
				var mapType = cookieMap['mapType'];
				map.setMapTypeId(mapType);
			}
			
			google.maps.event.addListener(map, 'bounds_changed', function() {
				var latLng = map.getCenter();
				cookieMap['zoom'] = map.getZoom();
				cookieMap['lat'] = latLng.lat();
				cookieMap['lng'] = latLng.lng();
			});
			
			google.maps.event.addListener(map, 'maptypeid_changed', function() {
				cookieMap['mapType'] = map.getMapTypeId();
			});
			
			if(cookieMap['lat'] && cookieMap['lng']) {
				var centre = new google.maps.LatLng(cookieMap['lat'], cookieMap['lng']);
				map.setCenter(centre);
			}
			
			if(cookieMap['zoom']) {
				var zoom = cookieMap['zoom'];
				map.setZoom(zoom);
			}
			
			if(cookieMap['origin'] && cookieMap['destination']) {
				calculateItineraire(cookieMap['origin'], cookieMap['destination'], true);
			}
			
			//*********************************************************************************
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre à jour.");
		}
	}
	
	function GetXMLSymbols(id,idadh) {
		var sortie = "";
		var params = "";
		if (id != "") {
			params += "&Idc="+id;
		}
		if (idadh != "") {
			params += "&id="+idadh;
		}
		var sources_cartes = "mobiles.php?name=SimpleAdherents&op=map_adh_XML"+params;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var cookieMap = [];
	var markers = [];
	var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	var displayDist = false;
	//]]>