<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");
require_once("includes/truncate_string.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function list_index($nbreFiches, $page, $ligne_par_page,$url, $txtfound=_BP_ELTS_FOUND, $txtnotfound = _BP_ELTS_NOTFOUND, $txtpage = _BP_ELTS_PAGES, $extraurl="") {
	global $withrewriting;
	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);

	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	
	$strMmg = "";
	if( preg_match("/.+_([0-9]+,[0-9]+)$/", $url, $matchs) ) {
		$strMmg = "_".$matchs[1];
		$url = preg_replace("/_[0-9]+,[0-9]+$/", "", $url);
	}
	
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches.$txtfound;
		$indexPages .= $txtpage;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$min,$extraurl);
				if ($url != "") {
					if( $withrewriting ) {
						$indexPages .= "<a href=\"$url"."_page,".$min.$strMmg.".htm"."\"$extraurl>$min</a>";
					} else {
						$indexPages .= "<a href=\"$url&page=$min"."\"$extraurl>$min</a>";
					}
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.">$min</a>";
				}
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$i,$extraurl);
				if ($url != "") {
					if( $withrewriting ) {
						$indexPages .= "<a href=\"$url"."_page,".$i.$strMmg.".htm"."\"$extraurl>$i</a>";
					} else {
						$indexPages .= "<a href=\"$url&page=$i"."\"$extraurl>$i</a>";
					}
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.">$i</a>";
				}
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$max,$extraurl);
				if ($url != "") {
					if( $withrewriting ) {
						$indexPages .= "<a href=\"$url"."_page,".$max.$strMmg.".htm"."\"$extraurl>$max</a>";
					} else {
						$indexPages .= "<a href=\"$url&page=$max"."\"$extraurl>$max</a>";
					}
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.">$max</a>";
				}	
				$indexPages .= "</div>";
			}
		}
	}
	else {
		$indexPages .= $txtnotfound;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function showadhs($metacat, $cat, $village="", $idpage="") {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $mmg, $op, $page;
	global $pagetitle, $withrewriting;
	
	$pagetitle = _ADHS_PAGETITLELIST;

	if ($idpage == "") {
		//recup menu en cours
		require_once("modules/becmsDynMenu/connector_lib.php");
		list($menu,$lignemenu) = explode(",",$mmg);
		$pageheadercontent = "<h1>".getmenulabel($menu,$lignemenu)."</h1>";
	}
	else {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		$pageheadercontent = $sectmodule->getPageContent($idpage,"", true);
	}
	//critre de selection
	$where = "";
	$having = "";
	if ($cat != "") {
		$tabcats = explode(",",$cat);
		$tabcats = array_map(array('utilFuncs_adherents', 'trimtodb'), $tabcats);
		$tabcats = array_unique($tabcats);
		$nbrecats = count($tabcats);
		$where .= ($where == "" && $nbrecats > 0) ? " WHERE " : " AND "; 
		$where2 = "";
		foreach ($tabcats as $tabcat) {
			$where2 .= ($where2 != "") ? " OR " : "";
			$where2 .= "".$user_prefix."_adherents_link_cat.id_cat='".$tabcat."'";
		}
		if ($where2 != "") {
			$where .= "($where2)";
			$having .= ($having == "") ? " HAVING " : " AND "; 
			$having .= "nbrefiche='".count($tabcats)."'";
		}
	}
	if ($metacat != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.metacat='".$metacat."'";
	}
	$where .= ($where == "") ? " WHERE " : " AND ";
	$where .= "".$user_prefix."_adherents.valide='1'";
	$whereVillage = $where; //pour be pas tenir compte du choix du village !!
	if ($village != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.commune='".$village."'";
	}
	//menu villages concernes par fiches trouves (catgorie)
	//$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_adherents INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh".$whereVillage." ORDER BY commune ASC";
	$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id, `commune` ";
   	$sql .= " FROM ".$user_prefix."_adherents";
   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
   	$sql .= $whereVillage."";
   	$sql .= " GROUP BY ".$user_prefix."_adherents.id";
   	$sql .= $having;
   	$sql .= " ORDER BY commune ASC";
   	//echo $sql;
	$result3 = $db->sql_query($sql);
	$communes = array();
	if ($db->sql_numrows($result3) > 0) {
		while ($ligne3 = $db->sql_fetchrow($result3)) {
			$communes[$ligne3["commune"]] += 1;//$ligne3["nbrefiche"];
		}
	}
	if (count($communes) > 0) {
		$menuVillages = '<select onchange="this.form.submit()" size="1" name="village">';
		$menuVillages .= '<option value="">'._ADHS_CHOOSEVILLAGE.'</option>';
		foreach($communes as $commune=>$valeur) {
			if ($commune != "") {
				$selected = "";
				if ($village == $commune) {
					$selected = " selected=\"selected\"";
				}
				$menuVillages .= "<option value=\"".$commune."\"".$selected.">".$commune." (".$valeur.")"."</option>";
			}
		}
		$menuVillages .= "</select>";
	}
	
	/*$sql = "SELECT commune, COUNT(".$user_prefix."_adherents.id) as nbre FROM ".$user_prefix."_adherents INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh".$whereVillage." GROUP BY commune ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		$menuVillages = '<select onchange="this.form.submit()" size="1" name="village">';
		$menuVillages .= '<option value="">'._ADHS_CHOOSEVILLAGE.'</option>';
		while ($ligne = $db->sql_fetchrow($result)) {
			$selected = "";
			if ($village == $ligne["commune"]) {
				$selected = " selected=\"selected\"";
			}
			//$menuVillages .= "<option value=\"".$ligne["commune"]."\"".$selected.">".$ligne["commune"]."</option>";
			$menuVillages .= "<option value=\"".$ligne["commune"]."\"".$selected.">".$ligne["commune"]." (".$ligne["nbre"].")"."</option>";
		}
		$menuVillages .= "</select>";
	}*/
	

	/*
	if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
		$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
	}
	else {
		$icn = 'images/deletesmall.gif';
	}
	if (file_exists('themes/'.$Default_Theme.'/images/edit.gif')) {
		$icn2 = 'themes/'.$Default_Theme.'/images/edit.gif';
	}
	else {
		$icn2 = 'images/edit22.gif';
	}
	*/
	if (file_exists("themes/".$Default_Theme."/pattern_adh_item.php")) {
		require_once("themes/".$Default_Theme."/pattern_adh_item.php");
	   
		include("header.php");
	    echo $sortie;
		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" ,
			"carnetvoyage"=>"@");
		buttonBar($bardef, "align");
		include("footer.php");	    		    
	}
	else {
	
		include("header.php");
		$sortie = "";
		$sortie .= $pageheadercontent;
		$sortie .= '<form action="modules.php" method="post" name="recadherents">';
		$sortie .= '<h3>'.$menuVillages.'</h3>';
		$sortie .= '<input type="hidden" name="op" value="'.$op.'" />';
		$sortie .= '<input type="hidden" name="name" value="'.$module_name.'" />';
		$sortie .= '<input type="hidden" name="cat" value="'.$cat.'" />';
		$sortie .= '<input type="hidden" name="mmg" value="'.$mmg.'" />';
		$sortie .= '<input type="hidden" name="idpage" value="'.$idpage.'" />';
		$sortie .= '</form>';
		//pagination
		if (!isset($page) || $page == "") {
			$page = 1;
		}
		$pagesize = 10;
		$min = $pagesize * ($page - 1);
		$max = $pagesize;
		$limit = " LIMIT ".$min.", ".$max;
		
		/*$sql = "SELECT DISTINCT ".$user_prefix."_adherents.id";
		$sql .= " FROM ".$user_prefix."_adherents";
		$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
		$sql .= $where.";";*/
		
		$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id";
		$sql .= " FROM ".$user_prefix."_adherents";
		$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
		$sql .= $where."";
		$sql .= " GROUP BY ".$user_prefix."_adherents.id";
	   	$sql .= $having;
		
		$result = $db->sql_query($sql);
		$nbre = $db->sql_numrows($result);
		if( $village != "" ) {
			if( $withrewriting ) {
				$village = preg_replace("/ /", "-", $village);
				$village = utilFuncs_adherents::normaliser($village);
				$strVillage = "_village,".urlencode($village);
			} else {
				$village = preg_replace("/ /", "-", $village);
				$village = utilFuncs_adherents::normaliser($village);
				$strVillage = "&village=".urlencode($village);
			}
		} else {
			$strVillage = "";
		}
		if( $metacat != "" ) {
			if( $withrewriting ) {
				$strMetacat = "_metacat,".$metacat;
			} else {
				$strMetacat = "&metacat=".$metacat;
			}
		} else {
			$strMetacat = "";
		}
		if( $cat != "" ) {
			if( $withrewriting ) {
				$strCat = "_cat,".$cat;
			} else {
				$strCat = "&cat=".$cat;
			}
		} else {
			$strCat = "";
		}
		if( $mmg != "" ) {
			if( $withrewriting ) {
				$strMmg = "_".$mmg;
			} else {
				$strMmg = "&mmg=".$mmg;
			}
		} else {
			$strMmg = "";
		}
		
		$labelCat = "";
		if( $cat != "" ) {
			$sql = "SELECT * FROM ".$user_prefix."_adherents_cat WHERE id=".$cat;
			$resultCat = $db->sql_query($sql);
			if ($db->sql_numrows ( $resultCat ) != 0) {
				$donneesCat = $db->sql_fetchrow ( $resultCat );
				$labelCat = $donneesCat['label_'.$currentlang];
			}
		}
		if( $labelCat != "" ) {
			$labelCat = preg_replace("/ /", "-", $labelCat);
			$labelCat = utilFuncs_adherents::normaliser($labelCat);
			$strLabelCat = urlencode($labelCat)."-";
		} else {
			$strLabelCat = "";
		}

		if( $withrewriting ) {
			$urlfiche = $strLabelCat."partners".$strVillage.$strMetacat.$strCat.$strMmg;
		} else {
			$urlfiche = "modules.php?name=$module_name&op=showadhs".$strVillage.$strMetacat.$strCat.$strMmg;
		}
		
		$indexpages = list_index($nbre, $page, $pagesize, $urlfiche, _ADHS_FILES_FOUND, _ADHS_FILES_NOTFOUND, _ADHS_FILES_PAGES);

		//affichage des publis
		$sortiepub = $indexpages;
	   	$sortieliste = "";
	   	/*
	   	$sql = "SELECT DISTINCT ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo` , `dateimport` ";
	   	$sql .= " FROM ".$user_prefix."_adherents";
	   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
	   	$sql .= $where."";
		$sql .= " ORDER BY classe DESC, societe ASC".$limit;
		*/
		
		$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo` , `dateimport` ";
	   	$sql .= " FROM ".$user_prefix."_adherents";
	   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
	   	$sql .= $where."";
	   	$sql .= " GROUP BY ".$user_prefix."_adherents.id";
	   	$sql .= $having;
		$sql .= " ORDER BY classe DESC, societe ASC".$limit;
		
	  	$result = $db->sql_query($sql);
	  	if ($db->sql_numrows($result) > 0) {
	  		$sortie .= '<div id="listingHebergement">';
	  		while($ligne = $db->sql_fetchrow($result)) {
	  			/*if ($ligne["user_id"] == $userdata[0] || is_admin($admin)) {
					$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_DELFILE.'"><img src="'.$icn.'" border="0"></a>'; 
					$editbutton = '<a href="modules.php?name='.$module_name.'&op=editpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_EDITFILE.'"><img src="'.$icn2.'" border="0"></a>';
					$actions = '<span class="actions">&nbsp;'.$editbutton.'&nbsp;'.$deletebutton.'</span>';
				}
				else {
					$actions = "";			
				}
	   				$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpratique&id=".$ligne["id"]."&page=".$page."\">";
	   				$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligne["titre"].'<span class="sstitle">'.truncate_string($ligne["resume"],"200").'</span></a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_adherents::date2JMA($ligne["date"],$formatdatebp).'</span>'.'</li>';
	   			}
	   			$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";*/
	   			
	   			$classe = '';
	   			if (preg_match("#^toile#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/etoile.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	  			if (preg_match("#^pi#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/epi.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	   			if (preg_match("#^clef#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	   			if ($ligne["photo"] != "") {
	   				$lesphotos = explode(",",$ligne["photo"]);
	   				$laphoto = trim($lesphotos[0]);
	   				$vignette = '<img src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=66&max_height=66" class="photo" />';
	   			}
	   			else {
		   			if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
						$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=66&max_height=66";
					}
					else {
						$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=images/nopict.gif&max_width=66&max_height=66";
					}
	   				$vignette = '<img src="'.$urlvignetteredim.'" class="photo" />';
	   			}
				
				if( $village != "" ) {
	   				if( $withrewriting ) {
						$village = preg_replace("/ /", "-", $village);
						$village = utilFuncs_adherents::normaliser($village);
	   					$strVillage = "_village,".urlencode($village);
	   				} else {
						$village = preg_replace("/ /", "-", $village);
						$village = utilFuncs_adherents::normaliser($village);
	   					$strVillage = "&village=".urlencode($village);
	   				}
	   			} else {
	   				$strVillage = "";
	   			}
	   			if( $metacat != "" ) {
	   				if( $withrewriting ) {
	   					$strMetacat = "_metacat,".$metacat;
	   				} else {
	   					$strMetacat = "&metacat=".$metacat;
	   				}
	   			} else {
	   				$strMetacat = "";
	   			}
	   			if( $cat != "" ) {
	   				if( $withrewriting ) {
	   					$strCat = "_cat,".$cat;
	   				} else {
	   					$strCat = "&cat=".$cat;
	   				}
	   			} else {
	   				$strCat = "";
	   			}
	   			if( $page != "" ) {
	   				if( $withrewriting ) {
	   					$strPage = "_page,".$page;
	   				} else {
	   					$strPage = "&page=".$page;
	   				}
	   			} else {
	   				$strPage = "";
	   			}
	   			if( $ligne["id"] != "" ) {
	   				if( $withrewriting ) {
	   					$strId = "_id,".$ligne["id"];
	   				} else {
	   					$strId = "&id=".$ligne["id"];
	   				}
	   			} else {
	   				$strId = "";
	   			}
	   			if( $mmg != "" ) {
	   				if( $withrewriting ) {
	   					$strMmg = "_".$mmg;
	   				} else {
	   					$strMmg = "&mmg=".$mmg;
	   				}
	   			} else {
	   				$strMmg = "";
	   			}
	   			
	   			if( $ligne["societe"] != "" && $withrewriting ) {
	   				$strSociete = preg_replace("/ /", "-", $ligne["societe"]);
					$strSociete = utilFuncs_adherents::normaliser($strSociete);
	   				$strSociete = urlencode($strSociete)."-";
	   			}
	   			
	   			if( $withrewriting ) {
	   				$urlfiche = $strSociete.$strLabelCat."partner".$strVillage.$strMetacat.$strCat.$strPage.$strId.$strMmg.".htm";
	   			} else {
					$urlfiche = "modules.php?name=$module_name&op=showoneadh".$strVillage.$strMetacat.$strCat.$strPage.$strId.$strMmg;
				}
	  			if ($nbre == 1) {
					Header("Location: $urlfiche");
					die();	
				}
	   			$sortie .= '
	<div class="entreeListing">
	    <div>
	    	<div class="contentHotel">
				<a class="lienVillage" href="#" onclick="document.forms[\'recadherents\'].elements[\'village\'].value=\''.addslashes($ligne["commune"]).'\';document.forms[\'recadherents\'].submit();return false">'.$ligne["commune"].'</a>
	    		<h3 class="titreListing"><a href="'.$urlfiche.'">'.$ligne["societe"].'</a><span class="classement">'.$classe.'</span></h3>
	            <p>'.truncate_string($ligne["description_".$currentlang],"300").'</p>
	            <div align="right"><a class="plusdinfo" href="'.$urlfiche.'">'._ADHS_SEEFILE.'</a></div>
	    	</div>
	    	<a href="'.$urlfiche.'">'.$vignette.'</a>
	    </div>
	</div>
	<div class="separateurHotel"></div>';	
	   		}
	   		$sortie .= '</div>';
	  	}
	  	else {
	  		$sortiepub .= "Pas de fiche trouve !!";
	  	}
		$sortie .= $indexpages;
	  		
		//$sortie .= $sortiepub;
	 		
		echo $sortie;
		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" ,
			"carnetvoyage"=>"@");
		buttonBar($bardef, "align");
		include("footer.php");
	}
}

function printPdf($id) {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang, $site_logo;
	
	require_once("includes/html2pdf.php");
	$monpdf = new handle_pdf("A4", "P", "fr");
	
	$where = "";
	if ($id != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.id='".$id."'";
	}
	
	$sql = "SELECT ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish`, `distance_french` , `distance_italian` , `distance_english` , `distance_german` , `distance_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo`, `legende` , `dateimport`,`lienlocalite` ";
	$sql .= " FROM ".$user_prefix."_adherents".$where.";";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		if ($ligne = $db->sql_fetchrow($result)) {
			$pagetitle = " - ".$ligne["societe"];
			
			$pictos = get_pictos_adh($id);
			
			$fiche = array();
			$fiche["module_name"] = $module_name;
			$fiche["default_theme"] = $Default_Theme;
			$fiche["menu_label"] = $menuLabel;
			$fiche["commune"] = $ligne["commune"];
			$fiche["unite"] = $ligne["unite"];
			$fiche["classe"] = $ligne["classe"];
			$fiche["photo"] = $ligne["photo"];
			$fiche["legende"] = $ligne["legende"];
			$fiche["periodeouverture"] = $ligne["periodeouverture_".$currentlang];
			$fiche["services"] = $ligne["services_".$currentlang];
			$fiche["actvites"] = $ligne["activites_".$currentlang];
			$fiche["distance"] = $ligne["distance_".$currentlang];
			$fiche["societe"] = $ligne["societe"];
			$fiche["adresse"] = $ligne["adresse"];
			$fiche["tel"] = $ligne["tel"];
			$fiche["fax"] = $ligne["fax"];
			$fiche["mobile"] = $ligne["mobile"];
			$fiche["web"] = $ligne["web"];
			$fiche["email"] = $ligne["email"];
			$fiche["description"] = $ligne["description_".$currentlang];
			$fiche["tarifs"] = $ligne["tarifs_".$currentlang];
			$fiche["lienlocalite"] = $ligne["lienlocalite"];
			$fiche["pictos"] = $pictos;
			$fiche["metacat"] = $ligne["metacat"];
			
			//$_catlieu = $fiche["menu_label"]._ADHS_CATINCOMM.$fiche["commune"];
			
			$_classe = '';
			if (preg_match("#^toile#",$fiche["unite"]) && $fiche["classe"] > 0) {
				for ($i=0;$i<$fiche["classe"]; $i++) {
					$_classe .= '<img src="themes/'.$fiche["default_theme"].'/images/etoile.gif" width="12" height="12" alt="*">';
				}
			}
			if (preg_match("#^pi#",$fiche["unite"]) && $fiche["classe"] > 0) {
				for ($i=0;$i<$fiche["classe"]; $i++) {
					$_classe .= '<img src="themes/'.$fiche["default_theme"].'/images/epi.gif" width="12" height="12" alt="*">';
				}
			}
			if (preg_match("#^clef#",$fiche["unite"]) && $fiche["classe"] > 0) {
				for ($i=0;$i<$ligne["classe"]; $i++) {
					$_classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
				}
			}
			$_classe = ($_classe == "" && $fiche["metacat"] == '5') ? " NC " : $_classe;
			if ($fiche["photo"] != "") {
				$lesphotos = explode(",",$fiche["photo"]);
				$laphoto = trim($lesphotos[0]);
				//$_photo = '<img class="activeslide" src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=700&max_height=275" width="700" height="275" align="bottom" border="0" />';
				$_photo = '<img src="'.$laphoto.'" width="700" height="275" align="bottom" border="0" />';
			}
			else {
				if (file_exists("themes/".$fiche["default_theme"]."/images/nopict.gif")) {
					//$urlphotoredim = "modules/".$fiche["module_name"]."/resizer.php?imgfile=../../themes/".$fiche["default_theme"]."/images/nopict.gif&max_width=700&max_height=275";
					$urlphotoredim = "themes/".$fiche["default_theme"]."/images/nopict.gif";
				}
				else {
					//$urlphotoredim = "modules/".$fiche["module_name"]."/resizer.php?imgfile=images/nopict.gif&max_width=700&max_height=275";
					$urlphotoredim = "images/nopict.gif";
				}
				$_photo = '<img src="'.$urlphotoredim.'" class="activeslide" align="bottom" border="0" width="700" height="275" />';
			}
			
			$_periode = "";
			if ($fiche["periodeouverture"] != "") {
				$fiche["periodeouverture"] = trim(strip_tags($fiche["periodeouverture"]));
				$_periode = '<h3>'._ADHS_OPENDATES.'</h3><p class="periode">'.$fiche["periodeouverture"].'</p>';
			}
			
			$pictos = "";
			if (count($fiche["pictos"]) > 0) {
				$pictos = '<div class="contentPictos">';
				foreach($fiche["pictos"] as $lepicto) {
					$pictos .= '<a class="picto" onmouseover="showPict(this);" onmouseout="hidePict(this);"><img src="'.$lepicto["picto"].'" alt="'.stripslashes($lepicto["legende"]).'" height="27" width="27"></a>';
				}
				$pictos .= '</div>';
			}
			$services = "";
			if (trim($fiche["services"]) != "") {
				$fiche["services"] = strip_tags ($fiche["services"]);
				$servicestab = explode(",", trim($fiche["services"]));
				$services = join("</li><li>",$servicestab);
				$services = '<div class="collLeft"><h3>'._ADHS_SERVICES.'</h3>'."<ul><li>".$services."</li></ul></div>";
			}
			$activites = "";
			if (trim($fiche["actvites"]) != "") {
				$fiche["actvites"] = strip_tags ($fiche["actvites"]);
				$activitestab = explode(",", trim($fiche["actvites"]));
				$activites = join("</li><li>",$activitestab);
				$activites = '<div class="collRight"><h3>'._ADHS_ACTIVITES.'</h3>'."<ul><li>".$activites."</li></ul></div>";
			}
			if ($pictos != "" || $services != "" || $activites != "") {
				$_activites_services = '<h2>'._ADHS_PRESTATION.'</h2>'.$pictos.$services.$activites;
			}
			
			$_infos_pratiques = "";
			//societe `adresse` , `tel` , `fax` , `mobile` , `email` , `web`
			$_infos_pratiques .= ($fiche["societe"]  != "") ? "<h3>".$fiche["societe"] ."</h3>" : "";
			if (trim($fiche["adresse"]) != "") {
				$fiche["adresse"] = '<p>'.trim($fiche["adresse"]).'</p>';
				$fiche["adresse"] = preg_replace("#([0-9]{5})#","<br />\\1",$fiche["adresse"]);
			}
			$_infos_pratiques .= ($fiche["adresse"] != "") ? $fiche["adresse"] : "";
			$_infos_pratiques .= ($fiche["tel"] != "" || $fiche["fax"] != "" || $fiche["mobile"] != "") ? "<p>" : "";
			$_infos_pratiques .= ($fiche["tel"] != "") ? _ADHS_SERVICES_TEL.$fiche["tel"] : "";
			$_infos_pratiques .= ($fiche["tel"] != "" && ($fiche["fax"] != "" || $fiche["mobile"] != "")) ? "<br />" : "";
			$_infos_pratiques .= ($fiche["fax"] != "") ? _ADHS_SERVICES_FAX.$fiche["fax"] : "";
			$_infos_pratiques .= ($fiche["fax"] != ""  && $fiche["mobile"] != "") ? "<br />" : "";
			$_infos_pratiques .= ($fiche["tel"] != "" || $fiche["fax"] != "" || $fiche["mobile"] != "") ? "</p>" : "";
			$_infos_pratiques .= ($fiche["mobile"] != "") ? _ADHS_SERVICES_MOB.$fiche["mobile"]."<br />" : "";
			//$_infos_pratiques .= ($fiche["tel"] != "" || $fiche["fax"] != "" ||$fiche["mobile"] != "") ? "</p>" : "";
			$_infos_pratiques .= ($fiche["email"] != "" || $fiche["web"] != "" ) ? "<p>" : "";
			$_infos_pratiques .= ($fiche["email"] != "") ? _ADHS_SERVICES_EMAIL.'<a href="mailto:'.$fiche["email"].'">'.$fiche["email"]."</a><br />" : "";
			$_infos_pratiques .= ($fiche["web"] != "") ? _ADHS_SERVICES_WEB.'<span style="word-wrap: break-word"><a href="'.$fiche["web"].'" target="_blank">'.$fiche["web"]."</a></span>" : "";
			$_infos_pratiques .= ($fiche["email"] != "" || $fiche["web"] != "" ) ? "</p>" : "";
			$_infos_pratiques = '<h2>'._ADHS_INFOSPRAT.'</h2>'.$_infos_pratiques;
			
			$coords_GPS .= ($ligne["latitude"] != "0" && $ligne["longitude"]!= "0") ? '<table id="coordMap" cellpadding="0" cellspacing="0"><tr><td rowspan="2" width="140"><h3>'._ADHS_GPS.'</h3></td><td width="50"><span>Latitude</span></td><td width="2"><span>:</span></td><td width="108">'.$ligne["latitude"].'</td></tr><tr><td><span>Longitude</span></td><td><span>:</span></td><td>'.$ligne["longitude"].'</td></tr></table>' : '';
			
			$_description = $fiche["description"];
			if (substr($_description , 0 ,1 ) != "<") {
				$_description = "<p>".$_description."</p>";
			}
			
			$_distance = $fiche["distance"];
			if (substr($_distance , 0 ,1 ) != "<") {
				$_distance = "<p>".$_distance."</p>";
			}
			
			$_societe = $fiche["societe"];
			
			$_tarifs = "";
			if ($fiche["tarifs"] != "") {
				$_tarifs .= '<h2>'._ADHS_TARIFS.'</h2>'.$fiche["tarifs"];
			}
			
			/*$_lien_village = "";
			 if ($fiche["lienlocalite"] != "") {
			$_lien_village = '<a href="'.$fiche["lienlocalite"].'" id="lieninfoVillage">'._ADHS_GOTOVILLAGE.' >></a>';
			}*/
			
			$_album_photos = "";
			if (count($lesphotos) > 0) {
				$leslegendes = explode(";", $fiche["legende"]);
				$compteur = 0;
				$_album_photos = '';
				foreach ($lesphotos as $laphoto) {
					$lalegende = trim($leslegendes[$compteur]);
					$laphoto = trim($laphoto);
					$_album_photos .= '<img src="'.$laphoto.'" alt="'.$lalegende.'" />';
					$compteur++;
				}
			}
			
			if (file_exists("themes/".$Default_Theme."/pattern_adh_print.html")) {
				$modele = implode("", file("themes/".$Default_Theme."/pattern_adh_print.html"));
				$modele = addslashes($modele);
				$modele = "\$sortie=\"".$modele."\";";
				eval($modele);
				
				$contentpages = stripslashes($sortie);
				
				$sortie = '';
				if(file_exists("themes/".$Default_Theme."/style/SimpleAdherents.css")) {
					$sortie = '<style>'.join("", file("themes/".$Default_Theme."/style/SimpleAdherents.css")).'</style>';
				}
				
				$contentpages = preg_replace("#<script.*</script>#Ums", "", $contentpages);
				$contentpages = preg_replace("#<champ.*</champ>#Ums", "", $contentpages);
				$contentpages = preg_replace("#<link.* >#Ums", "", $contentpages);
				
				$sortie .= "
					<page>
						<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
						<div class=\"zprint\">
							$contentpages
						</div>
					</page>";
				
				$sortie = utf8_encode($sortie);
				
				//echo $sortie;
				$monpdf->affiche_pdf($sortie, "Fiche.pdf");
			} else {
				$contentpages = '<h1>$_societe <span class="classement">'.$_classe.'</span></h1>
                    	<div class="entete">
                        	<div class="photoEntete">'.$_photo.'</div>
                        	<div class="texteAdherants">'.$_description.'</div>
                        </div>
					<!-- prestation / services -->
                    	<div id="services">
                            '.$_activites_services.'
                       		<div class="wash"></div>
                        </div>
                    <!-- infos pratiques / carto -->
                        <div class="collLeft">
                        	'.$_infos_pratiques.'
                        	<div class="distance">'.$_distance.'</div>
                        	<!-- <div id="gmapHotel">
	                        	<div id="map" style="width: 320px; height: 248px"></div>
                            </div> -->
                            '.$coords_GPS.'
                        </div>
                	<!-- tarifs -->
                        <div class="collRight" id="tarifs">
							'.$_tarifs.'
                            '.$_periode.'
                    	<!-- album -->
                    		'.$_album_photos.'
                        </div>';
				
				$sortie = '';
				if(file_exists("themes/".$Default_Theme."/style/SimpleAdherents.css")) {
					$sortie = '<style>'.join("", file("themes/".$Default_Theme."/style/SimpleAdherents.css")).'</style>';
				}
				
				$contentpages = preg_replace("#<script.*</script>#Ums", "", $contentpages);
				$contentpages = preg_replace("#<champ.*</champ>#Ums", "", $contentpages);
				$contentpages = preg_replace("#<link.* >#Ums", "", $contentpages);
				
				$sortie .= "
					<page>
						<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
						<div class=\"zprint\">
							$contentpages
						</div>
					</page>";
				
				$sortie = utf8_encode($sortie);
				
				//echo $sortie;
				$monpdf->affiche_pdf($sortie, "Fiche.pdf");
			}
		}
	}
}

function showoneadh($id) {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $mmg, $op, $page, $metacat, $cat, $village;
	global $_headerContent, $cartobuttons, $minicarteadhs, $cartopospicto, $cartopictowidth, $cartopictoheight, $cartopleinecran;
	global $pagetitle;
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	
	$where = "";
	if ($id != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.id='".$id."'";
	}
	else {
		Header("Location: index.php");
		die();
	}
	$sql = "SELECT ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish`, `distance_french` , `distance_italian` , `distance_english` , `distance_german` , `distance_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo`, `legende` , `dateimport`,`lienlocalite` ";
   	$sql .= " FROM ".$user_prefix."_adherents".$where.";";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		if ($ligne = $db->sql_fetchrow($result)) {
			$pagetitle = " - ".$ligne["societe"];
			
			$pictos = get_pictos_adh($id);
			
			$btns = "";
			foreach ($cartobuttons as $typedemap) {
				$btns .= ($btns == "") ? "" : ",";
				$btns .= "'".$typedemap."'";
			}
			if ($ligne["latitude"] == "") {
				$ligne["latitude"] = "0";
			}
			if ($ligne["longitude"] == "") {
				$ligne["longitude"] = "0";
			}
			
			if($cartopleinecran == "1") {
				$fullscreen = "true";
			} else {
				$fullscreen = "false";
			}
			
			$_headerContent .= '
				<!--<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>-->
				<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_autostart.js"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_XML_parser.js" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js" charset="UTF-8"></script>
		
				<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_carto_adh.js" charset="UTF-8"></script>
		
				<script type="text/javascript">
				//<![CDATA[
				var options = new Array;
				options["btnstypes"] = ['.$btns.'];
				options["anchor_picto"] = "'.$cartopospicto.'";
				options["width_picto"] = "'.$cartopictowidth.'";
				options["height_picto"] = "'.$cartopictoheight.'";
				options["fullscreen"] = '.$fullscreen.';
				options["centermap"] = new google.maps.LatLng(eval('.$ligne["latitude"].'), eval('.$ligne["longitude"].'));
				//options["zoominit"] = 9;
				var racine_lib_module = "modules/SimpleCarto/lib";
			    //]]>
			    </script>
			    <script type="text/javascript">
				// <![CDATA[
					addToStart("GetMap(\''.$minicarteadhs.'\', \''.$id.'\')");
					//addToStop(GUnload);
				// ]]>
				</script>
		
			    <link href="themes/oriente/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>
		';
			
			$sql = "SELECT ".$user_prefix."_adherents_cat.id, ".$user_prefix."_adherents_cat.label_".$currentlang." as label FROM ".$user_prefix."_adherents_cat";
			$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents_link_cat.id_cat=".$user_prefix."_adherents_cat.id";
			$sql .= " WHERE  ".$user_prefix."_adherents_link_cat.id_adh=".$id;
			$sql .= " ORDER BY label ASC";
			$result2 = $db->sql_query($sql);
			$thecats = array();
			if ($db->sql_numrows($result2) > 0) {
				while ($ligne2 = $db->sql_fetchrow($result2)) {
					$thecats[$ligne2["id"]] = $ligne2["label"];
				}
			}
			
			if (file_exists("themes/".$Default_Theme."/pattern_adh.html") && file_exists("themes/".$Default_Theme."/pattern_adh.php")) {
				include("header.php");
			
				//recup menu en cours
				require_once("modules/becmsDynMenu/connector_lib.php");
				list($menu,$lignemenu) = explode(",",$mmg);
				$menuLabel = getmenulabel($menu,$lignemenu);
				str_replace("http://", "", $ligne["web"]);
				if ($ligne["web"] != "") {
					$ligne["web"] = str_replace("http://", "", $ligne["web"]);
					$ligne["web"] = "http://".$ligne["web"];
				}
				$fiche = array();
				$fiche["module_name"] = $module_name;
				$fiche["default_theme"] = $Default_Theme;
				$fiche["menu_label"] = $menuLabel;
				$fiche["commune"] = $ligne["commune"];
				$fiche["unite"] = $ligne["unite"];
				$fiche["classe"] = $ligne["classe"];
				$fiche["photo"] = $ligne["photo"];
				$fiche["legende"] = $ligne["legende"];
				$fiche["periodeouverture"] = $ligne["periodeouverture_".$currentlang];
				$fiche["services"] = $ligne["services_".$currentlang];
				$fiche["actvites"] = $ligne["activites_".$currentlang];
				$fiche["distance"] = $ligne["distance_".$currentlang];
				$fiche["societe"] = $ligne["societe"];
				$fiche["adresse"] = $ligne["adresse"];
				$fiche["tel"] = $ligne["tel"];
				$fiche["fax"] = $ligne["fax"];
				$fiche["mobile"] = $ligne["mobile"];
				$fiche["web"] = $ligne["web"];
				$fiche["email"] = $ligne["email"];
				$fiche["description"] = $ligne["description_".$currentlang];
				$fiche["tarifs"] = $ligne["tarifs_".$currentlang];
				$fiche["lienlocalite"] = $ligne["lienlocalite"];
				$fiche["pictos"] = $pictos;
				$fiche["metacat"] = $ligne["metacat"];
				$fiche["cats"] = $thecats;
				
				require_once("themes/".$Default_Theme."/pattern_adh.php");
				
				$modele = implode("", file("themes/".$Default_Theme."/pattern_adh.html"));
			    $modele = addslashes($modele);
			    $modele = "\$sortie=\"".$modele."\";";
			    eval($modele);
			    $sortie = stripslashes($sortie);
			    
			    echo $sortie;
				
				adminEditButton("system.php?op=adherents&action=edit_adh&onglet=adhs&id=$id");
				
				$bardef=array("back"=>"javascript:window.history.back()",
					/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
					"pdf" => "modules.php?name=SimpleAdherents&amp;op=printpdf&amp;id=$id",
					"mailto"=>"#",
					"top"=>"#top" ,
					"carnetvoyage"=>"@");
				buttonBar($bardef, "align");
				include("footer.php");
			}
			else {	
				//recup menu en cours
				require_once("modules/becmsDynMenu/connector_lib.php");
				list($menu,$lignemenu) = explode(",",$mmg);
				$menuLabel = getmenulabel($menu,$lignemenu);
				
				$classe = '';
	   			if (preg_match("#^toile#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/etoile.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	  			if (preg_match("#^pi#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/epi.gif" width="12" height="12" alt="*">';
	   				}
	   			}
				if (preg_match("#^clef#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
	   				}
	   			}
				if ($ligne["photo"] != "") {
					$lesphotos = explode(",",$ligne["photo"]);
	   				$laphoto = trim($lesphotos[0]);
	   				$photo = '<img src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=300&max_height=200" class="photo" />';
	   			}
	   			else {
		   			if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
						$urlphotoredim = "modules/".$module_name."/resizer.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=300&max_height=200";
					}
					else {
						$urlphotoredim = "modules/".$module_name."/resizer.php?imgfile=images/nopict.gif&max_width=300&max_height=200";
					}
	   				$photo = '<img src="'.$urlphotoredim.'" class="photo" />';
	   			}
	   			$periode = "";
	   			if ($ligne["periodeouverture_".$currentlang] != "") {
	   				$periode = '<h3>'._ADHS_OPENDATES.'</h3>
	    				<div>'.$ligne["periodeouverture_".$currentlang].'</div>';
	   			}
	   			$services = "";
				if (trim($ligne["services_".$currentlang] != "")) {
	   				$servicestab = explode(",", trim($ligne["services_".$currentlang]));
					$services = join("</li><li>",$servicestab);
					$services = '<h3>'._ADHS_SERVICES.'</h3>'."<ul><li>".$services."</li></ul>";
	   			}
				$activites = "";
				if (trim($ligne["activites_".$currentlang]) != "") {
	   				$activitestab = explode(",", trim($ligne["activites_".$currentlang]));
					$activites = join("</li><li>",$activitestab);
					$activites = '<h3>'._ADHS_ACTIVITES.'</h3>'."<ul><li>".$activites."</li></ul>";
	   			}
	   			$info_pratiques = "";
	   			//societe `adresse` , `tel` , `fax` , `mobile` , `email` , `web`
				$info_pratiques .= ($ligne["societe"] != "") ? "<strong>".$ligne["societe"]."</strong><br />" : "";
				
				
				/* adresse !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				$info_pratiques .= ($ligne["societe"] != "") ? "<strong>".$ligne["societe"]."</strong><br />" : "";*/
				if (trim($ligne["adresse"]) != "") {
					$ligne["adresse"] = trim($ligne["adresse"]);
					$ligne["adresse"] = preg_replace("#([0-9]{5})#","<br />\\1",$ligne["adresse"]);
				}
				$info_pratiques .= ($ligne["adresse"] != "") ? $ligne["adresse"]."<br />" : "";
				
				$info_pratiques .= ($ligne["tel"] != "") ? _ADHS_SERVICES_TEL.$ligne["tel"]."<br />" : "";
				$info_pratiques .= ($ligne["fax"] != "") ? _ADHS_SERVICES_FAX.$ligne["fax"]."<br />" : "";
				$info_pratiques .= ($ligne["mobile"] != "") ? _ADHS_SERVICES_MOB.$ligne["mobile"]."<br />" : "";
				$info_pratiques .= ($ligne["web"] != "") ? _ADHS_SERVICES_WEB.'<span style="word-wrap: break-word"><a href="'.$ligne["web"].'" target="_blank">'.$ligne["web"]."</a></span><br />" : "";
				$info_pratiques .= ($ligne["email"] != "") ? _ADHS_SERVICES_EMAIL.'<a href="mailto:'.$ligne["email"].'">'.$ligne["email"]."</a><br />" : "";
	   			
				$lienvillage = "";
				if ($ligne["lienlocalite"] != "") {
					$lienvillage = '<a href="'.$ligne["lienlocalite"].'" id="lieninfoVillage">'._ADHS_GOTOVILLAGE.' >></a>';
				}
			
				include("header.php");
				$sortie = "";
		
				$sortie='
<h1>'.$ligne["societe"].'</h1>
<div>
<table cellpadding="0" cellspacing="0" border="0" style="width: 720px">
<!--- Bloc introduction --->
<tr>
<td valign="top" style="width: 314px">'.$photo.'</td>
<td width="10"></td>
<td valign="top">
    <h4><div class="classement" style="float:right;margin-right:10px">'.$classe.'</div>'.$menuLabel._ADHS_CATINCOMM.$ligne["commune"].'</h4>
    <br><div class="chapeauFiche">'.$ligne["description_".$currentlang].'</div>
    <br>
    '.$periode.'
</td>
</tr>';
			
//<!---  Bloc TARIFS --->
if ($ligne["tarifs_".$currentlang] != "") {
	//$ligne["tarifs_".$currentlang] = "<p>Tarifs non disponibles</p>";
	/*$ligne["tarifs_".$currentlang] = '
<table class="result" border="0" cellspacing="0" cellpadding="0"  width="694">
    		<caption>Camping</caption>
                <tr>
                    <th width="144" class="hidden"></th>
                    <th width="270">1 personne + Emplacement</th>
                    <th width="270">Par personnes</th>
                </tr>
                <tr>
                    <th width="144" class="ligne">Basse saison</th>
                    <td width="270">15 </td>
                    <td width="270">5 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Moyenne saison</th>
                    <td width="270">20 </td>
                    <td width="270">8 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Haute saison</th>
                    <td width="270">28 </td>
                    <td width="270">10 </td>
                </tr>
            </table>
            <table class="result" border="0" cellspacing="0" cellpadding="0" width="694">
    		<caption>Locations</caption>
                <tr>
                    <th width="144" class="hidden"></th>
                    <th width="135">Vranda 2 pers.</th>
                    <th width="135">Mini Villa 2 pers.</th>
                    <th width="135">Bungalow 2  7 pers.</th>
                    <th width="135">Bengali 4 pers.</th>
                </tr>
                <tr>
                    <th width="144" class="ligne">Basse saison</th>
                    <td width="135">623   693 </td>
                    <td width="135">875 </td>
                    <td width="135">483   1106 </td>
                    <td width="135">364 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Moyenne saison</th>
                    <td width="135">651   924 </td>
                    <td width="135">1022   1134 </td>
                    <td width="135">623   1365 </td>
                    <td width="135">483   525 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Haute saison</th>
                    <td width="135">805   833 </td>
                    <td width="135">1 253 </td>
                    <td width="135">763   1505 </td>
                    <td width="135">623 </td>
                </tr>
            </table>
            <h3>Suplments</h3>
            <ul class="listinfoFiche" style="float:left">
                <li><strong>Location consigne frigo : </strong>5 /jour - 30 /semaine</li>
                <li><strong>Location frigo sur emplacement : </strong>50 /semaine</li>
                <li><strong>Location coffre : </strong>2 /jour - 12 /semaine</li>
            </ul>
            <ul class="listinfoFiche" style="float:left">
                <li><strong>Lave-linge : </strong>6 </li>
                <li><strong>Sche-linge : </strong>63 </li>
            </ul>';*/
	
	$sortie .= '
<tr>
	<td colspan="3">
    <div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
            <h2>Les tarifs</h2>
            '.$ligne["tarifs_".$currentlang].'
            <div style="clear:both;"></div>
		</div>
	</div>
    </td>
</tr>
</table>';
}

//<!--- Colonne GAUCHE --->
$sortie .= '
<table cellpadding="0" cellspacing="0" border="0" style="width: 720px;margin-top:-10px;">
<tr>
<td style="width: 190px" valign="top">
	<!--- Bloc infos pratiques --->
	<div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
            <h2>'._ADHS_PRESTATION.'</h2>
           	'.$services.'
            '.$activites.'
		</div>
	</div>
</td>
<td width="10"></td>
<!--- Colonne DROITE --->
<td valign="top">
	<!--- Bloc infos  ne pas manquer --->
	<div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
        	<div id="gmapAdherant">
            	<!--<img src="themes/'.$Default_Theme.'/images/cartoadhs.jpg" width="280" height="250" alt=""/>-->
			<div id="map" style="width: 280px; height: 250px"></div>
                <!-- div de remplacement -->
                <!--<div style="display:block;padding:120px 50px;"><strong>Pas de coordonne disponible</strong></div>-->
            </div>
            <div id="infopratiquesAdherent">
                <h2>'._ADHS_INFOSPRAT.'</h2>
                <p style="text-align: left">'.$info_pratiques.'</p>
    		</div>
            '.$lienvillage.'
            <div style="clear:both;"></div>
		</div>
	</div>
</td>
</tr>
</table>
</div>';
			
				echo $sortie;
				
				adminEditButton("system.php?op=adherents&action=edit_adh&onglet=adhs&id=$id");				
				$bardef=array("back"=>"javascript:window.history.back()",
					/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
					"pdf" => "modules.php?name=SimpleAdherents&amp;op=printpdf&amp;id=$id",
					"mailto"=>"#",
					"top"=>"#top" ,
					"carnetvoyage"=>"@");
				buttonBar($bardef, "align");
				include("footer.php");
			}
		}
  	}
}

function get_pictos_adh($id) {
	global $db, $user_prefix,$currentlang;
	
	$sortie = array();
	
	$sql = "select label_".$currentlang." as label, picto from ".$user_prefix."_adherents_picto";
	$sql .= " inner join ".$user_prefix."_adherents_link_picto on ".$user_prefix."_adherents_link_picto.id_picto=".$user_prefix."_adherents_picto.id";
	$sql .= " where ".$user_prefix."_adherents_link_picto.id_adh='".$id."'";
	$sql .= " order by label_french asc";
	$result = $db->sql_query($sql);
  	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$sortie[] = array("legende"=>$ligne["label"], "picto"=>$ligne["picto"]);
		}
  	}
  	return $sortie;
}

function unsubscribe_newsletter() {
	global $module_name, $currentlang;
	include("header.php");
	echo "<h1>"._UNSUBSIMPLEADHS."</h1>";
	echo "<p>".nl2br(_SNLUNSUB)."<br /></p>\n";
	$content = '<script type="text/javascript" src="javascripts/lang/lang-'.$currentlang.'.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>';
	$content .= "<form action=\"modules.php?name=$module_name&op=send_unsubscribe_newsletter\" onsubmit=\"return submit_form(this)\" method=\"post\">";
	$content .= "<fieldset class=\"unsub\"><legend>"._SUBNLCOORDS."</legend>";
	$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
	$content .= '<tr><td><p>'._SUBNAMEANDFIRST2.'</p></td><td width="20"></td>';
	$content .= "<td><champ lib=\""._SUBNAMEANDFIRST."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td>';
	$content .= "<td><champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td colspan="3" align="center">';
	$content .= "<br/><input type=\"submit\" value=\""._SUBSEND."\" name=\"validsub\" id =\"validsub\"><br />";
	$content .= "</td></tr></table>";
	$content .= "</fieldset>";
	$content .= "</form>";
	echo $content;
	include("footer.php");
}

function send_unsubscribe_newsletter($nom, $email) {
	global $simplenewsletteradminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$nukeurl = format_nuke_url($nukeurl);
	$viewlink = "$nukeurl/system.php?op=adherents";
	$subject = ""._UNSUBSUBJECT."";
	$message = str_replace("<!--nom-->", $nom, _UNSUBMESSAGE);
	$message = str_replace("<!--email-->", $email, $message);
	$message = str_replace("<!--lien-->", $viewlink, $message);
	utilFuncs_adherents::send_email($simplenewsletteradminmail, $simplenewsletteradminmail,$subject,$message);
	include("header.php");
	echo "<h1>"._UNSUBSIMPLENEWSLETTER."</h1>";
	echo "<p>".nl2br(_UNSUBSENT)."</p>\n";
	include("footer.php");
}

function get_map_adh_XML() {
	global $module_name;
	
	require_once("modules/".$module_name."/system/getXMLcarto_adh.php");
	$sortie = getXMLcarto();
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

if (! isset($id)) {
	$id = "";
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "map_adh_XML":
		get_map_adh_XML();
		break;
	case "showoneadh":
		showoneadh($id);
		break;
	case "unsubscribe_nl":
		unsubscribe_newsletter();
		break;
	case "send_unsubscribe_newsletter":
		send_unsubscribe_newsletter($nom,$email);
		break;
	case "printpdf":
		printPdf($id);
		break;
	case "showadhs":
	default:
		showadhs($metacat,$cat,$village,$idpage);
		break;
}

?>