<?php

if (!preg_match("#system_mobile.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("Sections")) {
	
	function getSectionList() {
		global $db, $prefix;
		
		$sectionList = array();
		$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname not like '!%' order by secname ASC");
		while (list($secid, $secname) = $db->sql_fetchrow($result)) {
			$sectionList[]= array($secid, $secname);
		}
		$db->sql_freeresult($result);
		return $sectionList;
	}
	
	function getPageList($secid,$langRestrict=""){
		global $db, $prefix, $multilingual;
		
		$pageList = array();
		$cond = "";
		if ($secid !="") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " secid=$secid";
		}
		if ($multilingual == 1 && $langRestrict != "" && $langRestrict != "All") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " slanguage='$langRestrict'";
		}
		if ($cond != "") {
			$cond = " WHERE".$cond;
		}

		$result = $db->sql_query("select artid, title, slanguage, date, status, informant,mobile from ".$prefix."_seccont $cond  order by `date` desc;");

		while ($ligne = $db->sql_fetchrow($result)) {
			$pageList[]= array($ligne["artid"], $ligne["title"], $ligne["slanguage"], $ligne["date"], $ligne["status"], $ligne["informant"], $ligne["mobile"]);
		}
		$db->sql_freeresult($result);
		return $pageList;
	}
		
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
		}
	}
	
	function list_pages() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name;
    
	    $page_header_title = 'Liste des pages';
	    
	    include ("system/header_system_mobile.php");
	   	
	    $sortie = "";
	    
	    $sortie .= '<div class="marge">';
	    
	    $sections = getSectionList();
	    $sections[] = array("0", "Pages sans rubrique");
	    $compteur = -1;
	    foreach ($sections as $onesection) {
	    	$compteur++;
	    	$sortie .= '
<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onesection[1].'</a>
<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	    	
	    	$listepages= '';
	    	$pages = getPageList($onesection[0]);
	    	foreach ($pages as $onepage) {
	    		$pub = ($onepage[4] == "P") ? "Publie" : "Non publie";
	    		$np = ($onepage[4] == "P") ? "" : " np";
	    		$date = date2JMA($onepage[3],"d/m/Y H:i");
	    		$src_picto = ($onepage[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
	    		$picto = '<img src="'.$src_picto.'" />';
	    		$listepages .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editpage&artid='.$onepage[0].'">'.$onepage[1].' <span class="infos">'.$pub.' - '.$date.' - '.$onepage[5].''.$picto.'</span></a></li>';
	    	}
			if ($listepages != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listepages.'</ul>';
			}
	    	
			$sortie .= '
</div>
</div>';
	    }
	    
	    $sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
	    
	    $sortie .= '</div>';
    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}
	
	function getPageContent($artid){
		global $db,$prefix;
		
		if ($artid =="") {
			return "";
		}
		else {
			$cond = "";
			if ($artid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " artid=$artid";
			}
			
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}
			
			$result = $db->sql_query("select content, informant, mobile, title, status, secid, slanguage from ".$prefix."_seccont $cond;");
			if ($ligne = $db->sql_fetchrow($result)) {
				$sortie= array(
					"content" => $ligne["content"],
					"informant" => $ligne["informant"],
					"mobile" => $ligne["mobile"],
					"title" => $ligne["title"],
					"status" => $ligne["status"],
					"secid" => $ligne["secid"],
					"slanguage" => $ligne["slanguage"]
				);
			}
			$db->sql_freeresult($result);
			return $sortie; 
		}
	}
	
	/*function getSectionList(){
		global $db,$prefix;
		$result = $db->sql_query("select secid, secname from ".$prefix."_sections order by secname ASC;");
		while (list($secid, $secname) = $this->db->sql_fetchrow($result)) {
			$sectionList[]= array("secid"=>$secid, "secname"=>$secname);
		}
		$db->sql_freeresult($result);
		return $sectionList;
	}*/

	function edit_page($artid,$mobile) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system, $admincontrolsection, $Default_Theme, $Default_Theme_mobile;
		
		$contenu = array();
		$menusections = '';
		if ($artid != "") {
			$contenu = getPageContent($artid);
		}
		else {
			$contenu= array(
					"content" => "",
					"informant" => $aid,
					"mobile" => $mobile,
					"title" => "",
					"status" => "P",
					"secid" => "",
					"slanguage" => "french"
				);
		}
		
		$sections = getSectionList();
		$menusections = '<select name="data[secid]" class="saisie_text">';
		foreach($sections as $section) {
			$selected = ($section[0] == $contenu["secid"]) ? ' selected="selected"' : '';
			$menusections .= '<option value="'.$section[0].'"'.$selected.'>'.$section[1].'</option>';
		}
		$menusections .= '</select>';
		
		if ($admincontrolsection) {
		    if ($aid != $contenu["informant"] && !is_super($admin)) {
		    	display_denied();
		    	return;
		    }
	    }
    
	    $page_header_title = 'dition de page';
	    
	    require_once 'system/modules/core/becmsTinyMCEconfig.php';
	    $header_system .= '<script src="javascripts/tinymce/tinymce.min.js"></script>
		<script>'.init_becms_tinymce("mobile_article", $contenu["mobile"]).'
		</script>';
	    
	    include ("system/header_system_mobile.php");
	    	    
	    $sortie = '';
	    
	    $sortie .= '
<form action="system_mobile.php" method="post" class="nomarge">
	<div class="marge">
		Titre de la page : <input type="text" name="data[title]" value="'.str_replace('"', "&quot;", $contenu["title"]).'" class="saisie_text" />
		Rubrique : '.$menusections.'
		Publie : <input type="checkbox" value="P" name="data[status]"'.(($contenu["status"] == "P") ? ' checked="checked"' : '' ).' class="saisie_checkbox" />
	</div>
	<textarea id="article" name="data[content]">'.$contenu["content"].'</textarea>
	<div class="marge"><input type="submit" value="Enregistrer la page" class="saisie_text submit" name="valid"></div>
	<input type="hidden" name="op" value="savepage" />
	<input type="hidden" name="data[artid]" value="'.$artid.'" />
	<input type="hidden" name="data[mobile]" value="'.$contenu["mobile"].'" />
	<input type="hidden" name="data[informant]" value="'.$contenu["informant"].'" />
	<input type="hidden" name="data[slanguage]" value="'.$contenu["slanguage"].'" />
</form>';
	    
	    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}
	
	function secartsaveversion($artid) {
		global $prefix, $db, $pageversionning;
		$pageversionning=1;
		if ($pageversionning) {
			$result=$db->sql_query("select secid, title,content,counter,slanguage,date,informant,status,keywords,description,view,weight from ".$prefix."_seccont where artid='$artid'");
			list($secid, $title,$content,$counter,$slanguage,$date,$informant,$status,$keywords,$description,$view,$weight)=$db->sql_fetchrow($result);
			$db->sql_freeresult($result);
			$title = stripslashes(FixQuotes($title));
			$content = stripslashes(FixQuotes($content));
			$keywords = stripslashes(FixQuotes($keywords));
			$description = stripslashes(FixQuotes($description));
			$next_version=getnextversion($artid);
			$history_id=$artid."_".$next_version['version'];
			$new_version=$next_version['version'];
			//echo "V : ".$next_version['version']."<br>";
			//echo "::".$next_version['isnew'];
			if ($next_version['isnew']){
				//echo "new";
				//echo "<pre> INSERT INTO ".$prefix."_seccont_history VALUES ('$history_id','$artid','$secid','$title','$content','$counter','$slanguage','$date','$informant','$status', '$keywords', '$description', '$view', '$weight','$new_version')</pre>";
				$result=$db->sql_query("INSERT INTO ".$prefix."_seccont_history VALUES ('$history_id','$artid','$secid','$title','$content','$counter','$slanguage','$date','$informant','$status', '$keywords', '$description', '$view', '$weight','$new_version')");
			} else {
				//echo "update";
				$result=$db->sql_query("UPDATE ".$prefix."_seccont_history SET historyid='$history_id', artid='$artid',secid='$secid',title='$title',content='$content',counter='$counter',slanguage='$slanguage',date='$date',informant='$informant',status='$status',keywords='$keywords',description='$description',view='$view',weight='$weight',version='$new_version' where historyid='$history_id'");
			}
			if (!$result) {
				$error=$db->sql_error();
				die('Invalid query: secartsaveversion() :'.$error['message']);
			}
			return true;
		}
		return false;
	}
	
	function getnextversion($artid){
		global $prefix, $db;
		$maxVersion['version']=0;
		$maxVersion['isnew']=0;
		$result=$db->sql_query("select version, date from ".$prefix."_seccont_history where artid='$artid'");
		while (list($version, $date)=$db->sql_fetchrow($result)){
			$versionArray[$date]=$version;
			$dateArray[]=$date;
		}
		if (isset($dateArray)) {
			$maxVersion['version']=max($versionArray)+1;
			$lastDate=max($dateArray);
			$maxVersion['version']=$versionArray[$lastDate]+1;
			if (sizeof($dateArray)<=$maxVersion['version']) $maxVersion['isnew']=1; // new only if no backup exist with the same id
		}else{
			$maxVersion['version']=0;
			$maxVersion['isnew']=1;
		}

		if ($maxVersion['version']>=5) {
			$maxVersion['version']=0; // only 5 versions will be stored.
			$maxVersion['isnew']=0;
		}
		return $maxVersion;
	}

	function save_page($page) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$page = array_map("FixQuotes", $page);
		$page = array_map("stripslashes", $page);
		
		if (($page["status"]!="P")||($page["status"]=="")) $page["status"]="NP";
	
		$myservernotport="http://".$_SERVER['SERVER_NAME'];
		$page["content"] = str_replace($myservernotport,"",$page["content"]);
		$myservernotport="https://".$_SERVER['SERVER_NAME'];
		$page["content"] = str_replace($myservernotport,"",$page["content"]);
    
	    $page["mobile"] = ($page["mobile"] == "1") ? "1" : "0";
	    
	    if ($page["artid"] != "") {
		    $sql = "UPDATE ".$prefix."_seccont";
		    $sql .= " SET secid='".$page["secid"]."', title='".$page["title"]."', content='".$page["content"]."', date=now(), status='".$page["status"]."', mobile='".$page["mobile"]."', informant='".$page["informant"]."', slanguage='".$page["slanguage"]."'";
		    $sql .= " WHERE artid = ".$page["artid"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	
			secartsaveversion($page["artid"]);
	    }
	    else {
	    	$sql = "INSERT INTO ".$prefix."_seccont";
		    $sql .= " (secid, title, content, `date`, status,mobile, informant, slanguage)";
		    $sql .= "VALUES ('".$page["secid"]."','".$page["title"]."','".$page["content"]."',now(),'".$page["status"]."', '".$page["mobile"]."', '".$page["informant"]."', '".$page["slanguage"]."');"; 
	    	$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
		
		$header_system .= '
		<script>
			allerPage("system_mobile.php?op=listpages",2000);
		</script>';
		
		$page_header_title = 'Enregistrement de page';
		include ("system/header_system_mobile.php");
		
		//enregistrement dans la base de donnes  faire
		
		$sortie = '<alert class="center_v_abs">Page enregistre</alert>';

		echo $sortie;
		include ("system/footer_system_mobile.php");
	}

	if (!isset($artid)) {
		$artid = "";
	}
	if (!isset($mobile)) {
		$mobile = "0";
	}
	switch ($op) {
		case "newpage":
		case "editpage":
			edit_page($artid,$mobile);
			break;
		case "savepage":
			save_page($data);
			break;
		case "listpages":
		default:
			list_pages();
			break;
	}
}
else {
	display_denied();
}

?>