<?php
class menu_Sections {

	var $db; // db Object
	var $prefix; // db prefix
	var $multilingual; // is multilingual
	var $currentlang; // current language
	var $module_name; //current module
	var $withrewriting;//rcriture des url courtes

	/*function normaliser_nom($chaine)
	{
		$from = ' ';
		$to = 'aaaaaaaaaaaaaacceeeeeeeeiiiiiiiinnoooooooooouuuuuuuuy_';
		return strtr($chaine, $from, $to);
	}*/
	
	/**
	 * Constructor
	 */
	function menu_Sections() {
		global $db, $prefix, $multilingual, $currentlang, $withrewriting;
		$this->db=$db;
		$this->prefix=$prefix;
		$this->multilingual=$multilingual;
		$this->currentlang=$currentlang;
		$this->withrewriting = $withrewriting;
	}

	/**
	 * getSectionList()
	 * provide section as array.
	 * @return array return 2 level array with id, name
	 * Array
	 * (
	 *     [0] => Array
	 *         (
	 *             [0] => 1
	 *             [1] => Balistis
	 *         ) 	 *
	 *      [1] => Array
	 *         (
	 *             [0] => 2
	 *             [1] => Produits
	 *         )
	 * )
	 */
	function getSectionList(){
		$sectionList[]= array("0", _MENU_LABEL_SECTIONS_NOCAT);
		$result = $this->db->sql_query("select secid, secname from ".$this->prefix."_sections where secname not like '!%' order by secname ASC");
		while (list($secid, $secname) = $this->db->sql_fetchrow($result)) {
			$sectionList[]= array($secid, $secname);
		}
		$this->db->sql_freeresult($result);
		return $sectionList;
	}

	/**
	 * getPageList()
	 * provide page list for a specific section. rights are check link to the current user.
	 * @param int section ID
	 * @return array return 2 level arrau with page id, page name
	 */
	function getPageList($secid,$langRestrict=""){

		$pageList = array();
		$cond = "";
		if ($secid !="") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " secid=$secid";
		}
		if ($this->multilingual == 1 and $langRestrict != "" and $langRestrict != "All") {
			if ($cond != "") {
				$cond .= " AND";
			}
			//$cond .= " AND slanguage='$this->currentlang'";
			$cond .= " slanguage='$langRestrict'";
		}


		/*if ($cond != "") {
			$cond .= " AND";
		}
		$cond .=" status='P'";*/

		if ($cond != "") {
			$cond = " WHERE".$cond;
		}

		$result = $this->db->sql_query("select artid, title, slanguage, mobile from ".$this->prefix."_seccont $cond  order by title ASC;");

		while (list($artid, $title, $lang, $mobile) = $this->db->sql_fetchrow($result)) {
			// check rights
			if (is_user_group($view)) {
				$pageList[]= array($artid, $title, $lang, $mobile);
			}
		}
		$this->db->sql_freeresult($result);
		return $pageList;
	}

	function menu_auto() {
		$sortie = array();
		global $maxtitlerewriting;
		if (!$this->withrewriting) {
			$urlprefix = "modules.php?name=".$this->module_name."&sop=viewarticle&artid=";
			$urlmedium = "";
			$urlpostfix = "";
		}
		else {
			$urlprefix = "";
			$urlmedium = "_page_";
			$urlmedium_mobile = "_mpage_";
			$urlpostfix = ".htm";
		}
		$sections = $this->getSectionList();
		foreach ($sections as $section) {
			$sortie[] = array("label"=>$section[1],"link"=>"","language"=>"");
			$articles = $this->getPageList($section[0]);
			if ($articles != "") {
				foreach ($articles as $article) {
					$pagename = "";
					if ($this->withrewriting) {
						$pagename = normalize_name($article[1]);
						if (strlen($pagename) > $maxtitlerewriting) {
							do {
								$pagename = substr($pagename, 0, strrpos($pagename, " "));
							} while(strlen($pagename) > $maxtitlerewriting);
						}
					}
					if ($article[3] == 1) {
						$urlmediumchoisi = $urlmedium_mobile;
					}
					else {
						$urlmediumchoisi = $urlmedium;
					}
					$sortie[] = array("label"=>$article[1],"link"=>$urlprefix.$pagename.$urlmediumchoisi.$article[0].$urlpostfix,"language"=>$article[2]);
				}
			}
		}
		return $sortie;
	}
	
	function menu_auto2() {
		$sortie = array();
		$urlprefix = "";
		$sections = $this->getSectionList();
		foreach ($sections as $section) {
			$sortie[] = array("label"=>$section[1],"link"=>"","language"=>"");
			$articles = $this->getPageList($section[0]);
			if ($articles != "") {
				foreach ($articles as $article) {
					$sortie[] = array("label"=>$article[1],"link"=>$urlprefix.$article[0],"language"=>$article[2]);
				}
			}
		}
		return $sortie;
	}

	function menu_auto3() {
		$sortie = array();
		$urlprefix = "";
		$sections = $this->getSectionList();
		foreach ($sections as $section) {
			$sortie[] = array("label"=>$section[1],"link"=>$section[0],"language"=>"");
		}
		return $sortie;
	}
}
$lignes_menu = new menu_Sections();
$lignes_menu->module_name = $mod_title;
$module_menus = $lignes_menu->menu_auto();
$module_menus_ids = $lignes_menu->menu_auto2();
$module_menus_sections = $lignes_menu->menu_auto3();
$label_menu = _MENU_LABEL_SECTIONS;
$label_menu_ids = _MENU_LABEL_SECTIONS;
$label_menu_sections = _MENU_LABEL_SECTIONSRUBS;
?>