<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2006 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (preg_match("#connector_class.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

/**
 * connector class to Page module.
 * Provide Page api for over modules
 * @author stephan Acquatella
 */
class pageconnector {

	var $db; // db Object
	var $prefix; // db prefix
	var $multilingual; // is multilingual
	var $currentlang; // current language

	/**
	 * Constructor
	 */
	function __construct(){
		// get data from framwork
		global $db, $prefix, $multilingual, $currentlang;
		$this->db=$db;
		$this->prefix=$prefix;
		$this->multilingual=$multilingual;
		$this->currentlang=$currentlang;
	}

	/**
	 * getSectionList()
	 * provide section as array.
	 * @return array return 2 level array with id, name
	 * Array
	 * (
	 *     [0] => Array
	 *         (
	 *             [0] => 1
	 *             [1] => Balistis
	 *         ) 	 *
	 *      [1] => Array
	 *         (
	 *             [0] => 2
	 *             [1] => Produits
	 *         )
	 * )
	 */
	function getSectionList(){
		$result = $this->db->sql_query("select secid, secname from ".$this->prefix."_sections");
		//$sectionList = $this->db->sql_fetchrow($result);
		while (list($secid, $secname) = $this->db->sql_fetchrow($result)) {
			$sectionList[]= array($secid, $secname);
		}
		$this->db->sql_freeresult($result);
		return $sectionList;
	}

	/**
	 * getPageList()
	 * provide page list for a specific section. rights are check link to the current user.
	 * @param int section ID
	 * @return array return 2 level arrau with page id, page name
	 */
	function getPageList($secid,$langRestrict, $orderby="", $bypass=false){

		$pageList = array();
		$cond = "";
		if ($secid !="") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " secid=$secid";
		}
		if ($this->multilingual == 1 and $langRestrict != "" and $langRestrict != "All") {
			if ($cond != "") {
				$cond .= " AND";
			}
			//$cond .= " AND slanguage='$this->currentlang'";
			$cond .= " slanguage='$langRestrict'";
		}

		if (!$bypass) {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .=" status='P'";
		}

		if ($cond != "") {
			$cond = " WHERE".$cond;
		}
		if ($orderby != "") {
			$orderby = " ORDER BY ".$orderby;
		}

		$result = $this->db->sql_query("select artid, title, view from ".$this->prefix."_seccont $cond$orderby;");

		while (list($artid, $title, $view) = $this->db->sql_fetchrow($result)) {
			// check rights
			if (is_user_group($view)) {
				$pageList[]= array($artid, $title);
			}
		}
		$this->db->sql_freeresult($result);
		return $pageList;
	}

	/**
	 * getPageContent()
	 * provide content for a specific page. rights are check link to the current user.
	 * @param int artid ID
	 * @return string return content of the page
	 */
	function getPageContent($artid,$artname="",$bypass=false){
		if ($artid =="" && $artname=="") {
			return "";
		}
		else {
			$cond = "";
			if ($artid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " artid=$artid";
			}
			if ($artname !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " title='$artname'";
			}
			if (!$bypass) {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .=" status='P'";
			}
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}
			
			$result = $this->db->sql_query("select content from ".$this->prefix."_seccont $cond;");
			 
			if (list($contenu) = $this->db->sql_fetchrow($result)) {
				// check rights
				if (is_user_group($view)) {
					$sortie= $contenu;
				}
			}
			$this->db->sql_freeresult($result);
			return $sortie; 
		}
	}
	
	function getPageTitle($artid){
		if ($artid =="" && $artname=="") {
			return "";
		}
		else {
			$cond = "";
			if ($artid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " artid=$artid";
			}
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}
			
			$result = $this->db->sql_query("select title from ".$this->prefix."_seccont $cond;");
			 
			if (list($contenu) = $this->db->sql_fetchrow($result)) {
				// check rights
				if (is_user_group($view)) {
					$sortie= $contenu;
				}
			}
			$this->db->sql_freeresult($result);
			return $sortie; 
		}
	}
	function getPageStatus($artid){
		if ($artid =="" && $artname=="") {
			return "";
		}
		else {
			$cond = "";
			if ($artid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " artid=$artid";
			}
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}
			
			$result = $this->db->sql_query("select status from ".$this->prefix."_seccont $cond;");
			 
			if (list($contenu) = $this->db->sql_fetchrow($result)) {
				// check rights
				if (is_user_group($view)) {
					$sortie=$contenu;
				}
			}
			$this->db->sql_freeresult($result);
			return $sortie; 
		}
	}
	function getPageAuthor($artid){
		if ($artid =="" && $artname=="") {
			return "";
		}
		else {
			$cond = "";
			if ($artid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " artid=$artid";
			}
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}
			
			$result = $this->db->sql_query("select informant from ".$this->prefix."_seccont $cond;");
			 
			if (list($contenu) = $this->db->sql_fetchrow($result)) {
				// check rights
				if (is_user_group($view)) {
					$sortie= $contenu;
				}
			}
			$this->db->sql_freeresult($result);
			return $sortie; 
		}
	}
	function getPageRubrique($artid){
		$p = $this->prefix;

		$cond = $p."_seccont.secid = ".$p."_sections.secid AND ".$p."_seccont.artid = ".$artid ;
		$sql = "select ".$p."_seccont.secid, ".$p."_sections.secname from ".$p."_seccont,".$p."_sections where ".$cond.";";

		if ($artid !="") {
			$result = $this->db->sql_query($sql);
			$retour= array();
			while ($row = $this->db->sql_fetchrow($result)) {
				// check rights
				/*if (is_user_group($view)) {
					$sortie=$contenu;
				}*/
				$retour[0]= $row;
			}
			return $retour[0];
		}
		else {
			return "";
		}
	}
}

?>