<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// notes user search as been commented. Uncomment to use it.

if (!preg_match("#mobiles.php#i", $PHP_SELF)) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

if ($multilingual == 1) {
	$queryalang = "AND (s.alanguage='$currentlang' OR s.alanguage='')"; /* stories */
	$queryrlang = "AND rlanguage='$currentlang' "; /* reviews */
	$queryslang = "AND slanguage='$currentlang' "; /* sections */
} else {
	$queryalang = "";
	$queryrlang = "";
	$queryslang = "";
}

function conditionnerMobile($texte) {
	//$texte = str_replace("\n",'\n',$texte);
	//$texte = str_replace("\r","",$texte);
	$texte = html_entity_decode($texte,ENT_QUOTES,"ISO-8859-1");
	$texte = utf8_encode($texte);
	return $texte;
}

function getNumResults($sql) {
	global $db;
	$result = $db->sql_query($sql);
	$nbre = $db->sql_numrows($result);
	$db->sql_freeresult($result);
	return $nbre;
}

function removeSearch($tab_exp, $tab_words) {
	$tab_result = array();
	foreach ($tab_words as $word) {
		foreach($tab_exp as $ele) {
			if(preg_match("/^$word/", $ele)) {
				$tab_result[] = $word;
			}
		}
	}
	$tab_result = array_diff($tab_words, $tab_result);
	return $tab_result;
}

function mainsearch($author, $category=0, $topic, $type, $query, $days, $min, $max, $secid){
	global $searchSaveOcc, $Default_Theme;
	
	$query = utf8_decode($query);
	
	$arrayResults = array();
	
	$query = stripslashes($query);
	$pagetitle = "- "._SEARCH."";
	
	//searchHeader($author, $topic, $type, $query, $days, $min, $max,$category,$secid);
	
	$query = addslashes($query);
	if ($query != "") {
		if($searchSaveOcc == "1") {
			saveOccWordAndExpression($query, $type);
		}

		//Liste des modules implments avec pattern_search
		$listModuleUtilisable = array("stories", "sections", "agenda", "adherents");

		if(is_array($type)){
			$listType = $type;
		}else
		if($type == null){
			$listType = $listModuleUtilisable;
		}
		foreach($listType as $currentType){			
			switch ($currentType) {
				case "stories":
					if(is_active("News")){						
						$arrayResults = array_merge($arrayResults, resultSearchStorie($category,$author,$topic, $currentType, $query,$days,$max,$min));	
					}
					break;
				case "sections":
					if(is_active("Sections")){
						$arrayResults = array_merge($arrayResults, resultSearchSection($currentType, $query,$max,$min,$secid));
					}
					break;
				case "agenda":
					if(is_active("Calendrier")){
						$arrayResults = array_merge($arrayResults, resultSearchAgenda($currentType, $query,$topic,$max,$min));
					}
					break;
				case "adherents":
					if(is_active("SimpleAdherents")){
						//$arrayResults = array_merge($arrayResults, resultSearchAdherents($currentType, $query,$max,$min));
					}
					break;
			}
		}
	}
	
	$sortie = '';
	
	if (file_exists("themes/".$Default_Theme."/pattern_search.php")) {
		require_once("themes/".$Default_Theme."/pattern_search.php");
	}
	else {
		/*Faire par defaut */
	}
	
	include("header_mobile.php");
	echo conditionnerMobile($sortie);	
	include("footer_mobile.php");
}

function saveOccWordAndExpression($query, $type) {
	global $prefix, $db;
	
	$sql = "SELECT * FROM ".$prefix."_search_expressions WHERE expression='$query' AND type='$type';";
	$result = $db->sql_query($sql);
	if( $db->sql_numrows($result) > 0 ) {
		$sql = "UPDATE ".$prefix."_search_expressions SET occ = occ+1 WHERE expression='$query' AND type='$type';";
	} else {
		$sql = "INSERT INTO ".$prefix."_search_expressions (expression, type, occ) VALUES ('$query', '$type', 1);";
	}
	$db->sql_query($sql);
	
	$words = explode(" ", $query);
	$words = array_unique($words);
	foreach ($words as $word) {
		$sql = "SELECT * FROM ".$prefix."_search_mots WHERE mot='$word' AND type='$type';";
		$result = $db->sql_query($sql);
		if( $db->sql_numrows($result) > 0 ) {
			$sql = "UPDATE ".$prefix."_search_mots SET occ = occ+1 WHERE mot='$word' AND type='$type';";
		} else {
			$sql = "INSERT INTO ".$prefix."_search_mots (mot, type, occ) VALUES ('$word', '$type', 1);";
		}
		$db->sql_query($sql);
	}
}

/**
 * resultSearchStorie()
 * @param datatype paramname
 * @return datatype description
 *
 */
function resultSearchStorie($category,$author, $topic, $type, $query,$days,$max,$min){
	global $prefix, $db, $multilingual,$queryalang ;
	//echo "cat: $category, -$query- , $type, $max, $min, $offset";

	if ($author=="no") $author="";
	if ($topic=="no" || $topic <= 0) $topic="";
	if ($category == "no" || $category < 0) $categ = "";
	
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (s.title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (s.hometext, s.bodytext, s.notes) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "s.title like '%$query%' OR s.hometext like '%$query%' OR s.bodytext like '%$query%' OR s.notes like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR s.title like '%$query2%' OR s.hometext like '%$query2%' OR s.bodytext like '%$query2%' OR s.notes like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (s.title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (s.hometext, s.bodytext, s.notes) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR s.title like '%$word%' OR s.hometext like '%$word%' OR s.bodytext like '%$word%' OR s.notes like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT s.sid, s.aid, s.informant, s.title, s.time, s.hometext, s.bodytext, a.url, s.comments, s.topic, "
			. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_stories s, ".$prefix."_authors a";
	
	$where = " WHERE s.aid=a.aid $queryalang $categ AND ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) ";
	if ($author!= "") $where .= "AND s.aid='$author' ";
	if ($topic != "") $where .= "AND s.topic='$topic' ";
	if ($category != "") $where .= "AND s.catid='$category' ";
	if ($days != "" && $days!=0) $where .= "AND TO_DAYS(NOW()) - TO_DAYS(time) <= $days ";
	
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;

	if(!isset($min)){
		$min = 0;
	}
	$limit = "";
	if(isset($max) && $max > 0){
		$limit = "limit $min,$max";
	}
		
	$result = $db->sql_query($sql."$orderBy ".$limit);
	$nrows  = $db->sql_numrows($result);

	$rowRetour = array();
	if ($nrows>0) {
		
		while($ligne = $db->sql_fetchrow($result)) {			
			/***
			 * 
			 * Champs accessible sid, aid, informant, title, time, hometext, bodytext, a.url, comments, topic
			 */
			$ligne["typeSearch"] = $type;
			array_push($rowRetour, $ligne);
		}
	}
	//var_dump($rowRetour);
	return $rowRetour;

}

/**
 * resultSearchSection
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchSection($type, $query,$max,$min,$secid=""){
	global $prefix, $db, $multilingual,$queryslang, $Default_Theme ;
	global $admin;
	
	require_once("includes/truncate_string.php");
	
	$secid_link = $secid;
	
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (content) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";

	$likes = " (";
	$occ = " (";
	
	$likes .= "title like '%$query%' OR content like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR content like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (content) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR title like '%$word%' OR content like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";


	if($secid != ""){
		$conditionSecid ="";
		$listSecid = array_unique(array_map("trim", explode(",", $secid)));
		foreach($listSecid as $idSection){
			($conditionSecid != "") ? $conditionSecid .= " OR secid=".$idSection : $conditionSecid .= "secid=".$idSection;
		}
		($conditionSecid != "") ? $conditionSecid = "AND (".$conditionSecid.")":"";
	}

	
	$select = "SELECT artid, secid, title, content,date , popup, view," 
		. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
		. " FROM ".$prefix."_seccont";
	
	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) AND status='P'".$conditionSecid." $queryslang";
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;

	if(!isset($min)){
		$min = 0;
	}
	$limit = "";
	if(isset($max) && $max > 0){
		$limit = "limit $min,$max";
	}
		
	//$result = $db->sql_query($sql."  order by artid DESC limit $min,$offset");
	$result = $db->sql_query($sql."$orderBy ".$limit);
	$nrows  = $db->sql_numrows($result);

	$rowRetour = array();
	if ($nrows>0) {
		while($ligne = $db->sql_fetchrow($result)) {
			if (is_user_group($ligne["view"]) || is_admin($admin)) {
				$ligne["typeSearch"] = $type;
				array_push($rowRetour, $ligne);
			}
		}	
	}
	return $rowRetour;
}


/**
 * resultSearchAgenda
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchAgenda($type, $query,$topic, $max,$min){
	global $prefix, $db, $multilingual,$queryslang ;

	require_once("includes/truncate_string.php");

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (hometext) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "title like '%$query%' OR hometext like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR hometext like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (hometext) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR title like '%$word%' OR hometext like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT eid, title, hometext, comments, counter, topic, informant, time, eventDate, endDate, startTime, endTime, alldayevent, barcolor, withregistration, "
			. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_events";
	
	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes)";
	if ($topic != "no" && $topic!="") {
		$where = " AND topic='".$topic."'";
	}
	
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;
	
	if(!isset($min)){
	    $min = 0;
	}
	$limit = "";
	if(isset($max) && $max > 0){
	    $limit = "limit $min,$max";
	}
	$result = $db->sql_query($sql."$orderBy ".$limit);
	$nrows  = $db->sql_numrows($result);
	
	$rowRetour = array();
	if ($nrows>0) {
	    
	    while($ligne = $db->sql_fetchrow($result)) {
	        $ta = $db->sql_query("select topicname from ".$prefix."_topics where topicid='".$ligne[t]."'");
			list($topicname,$topicimage,$topictext) = $db->sql_fetchrow($ta);
			$ligne["topicname"] = $topicname;
			$ligne["topicimage"] = $topicimage;
			$ligne["topictext"] = $topictext;
	        $ligne["typeSearch"] = $type;
	        
	        array_push($rowRetour, $ligne);
	    }
	}
	return $rowRetour;
}

function resultSearchAdherents($type, $query,$max,$min){
	global $prefix, $db, $multilingual, $admin,$currentlang;
	
	require_once("includes/truncate_string.php");
		
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	/********************************************************************************************/
	/** Code commanté pour faire une recherche tenant egalement compte du nom des responsables **/
	/********************************************************************************************/
	/*$matchAgainstExpTitle = " MATCH (societe, keywords) AGAINST ('$query'";
	$matchAgainstExpContent = " MATCH (commune, responsable, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('$query'";
	if($query != $query2) {
		$matchAgainstExpTitle .= " '$query2'";
		$matchAgainstExpContent .= " '$query2'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "societe like '%$query%' OR commune like '%$query%' OR responsable like '%$query%' OR description_$currentlang like '%$query%' OR services_$currentlang like '%$query%' OR activites_$currentlang like '%$query%' OR keywords like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR societe like '%$query2%' OR commune like '%$query2%' OR responsable like '%$query2%' OR description_$currentlang like '%$query2%' OR services_$currentlang like '%$query2%' OR activites_$currentlang like '%$query2%' OR keywords like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (societe, keywords) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (commune, responsable, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('";
	
	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR societe like '%$word%' OR commune like '%$word%' OR responsable like '%$word%' OR description_$currentlang like '%$word%' OR services_$currentlang like '%$word%' OR activites_$currentlang like '%$word%' OR keywords like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}*/
	
	/********************************************************************************************/
	
	$matchAgainstExpTitle = " MATCH (societe, keywords) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (commune, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('\"$query\"'";
	if($query != $query2) {
		// Neutralisé pour eviter d'introduire des erreurs de recherche dues au HTML
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "societe like '%$query%' 
				OR commune like '%$query%' 
				OR description_$currentlang like '%$query%' 
				OR services_$currentlang like '%$query%' 
				OR activites_$currentlang like '%$query%' 
				OR keywords like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR societe like '%$query2%' 
					OR commune like '%$query2%' 
					OR description_$currentlang like '%$query2%' 
					OR services_$currentlang like '%$query2%' 
					OR activites_$currentlang like '%$query2%' 
					OR keywords like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (societe, keywords) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (commune, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR societe like '%$word%' 
					OR commune like '%$word%' 
					OR description_$currentlang like '%$word%' 
					OR services_$currentlang like '%$word%' 
					OR activites_$currentlang like '%$word%' 
					OR keywords like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT ".$prefix."_adherents.id, `societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , "
		. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
		. " FROM ".$prefix."_adherents";

	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) AND valide='1'";

	$orderBy = " ORDER BY cpt DESC, societe ASC";

	$sql = $select.$where;
	//echo $sql."$orderBy limit $min,$offset";

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	$rowRetour = array();

	$idsAdherent = array();
	if ($nrows>0) {
		while($ligne = $db->sql_fetchrow($result)) {
			$ligne["typeSearch"] = $type;
			array_push($idsAdherent, $ligne["id"]);
			array_push($rowRetour, $ligne);
		}
	}

	/* 
	Ajout information des categories
	Label, id_cat, id_adh */
	$sql = "
		SELECT ct.label_$currentlang, lk.id_cat, lk.id_adh
		FROM becms_adherents_cat ct
		LEFT OUTER JOIN becms_adherents_link_cat lk ON lk.id_cat = ct.id
		WHERE lk.id_adh		
		IN (".implode(',',$idsAdherent).")";
	
	$resultCat = $db->sql_query($sql);
	$nrows  = $db->sql_numrows($resultCat);

	$labelsCatAdherent = array();
	$countrowRetour = count($rowRetour);

	if ($nrows>0) {
		while(list($label_french, $id_cat, $id_adh) = $db->sql_fetchrow($resultCat)) {
			for($i = 0; $i < $countrowRetour; $i++){
				if($rowRetour[$i]["id"] == $id_adh){
					if(!isset($rowRetour[$i]["cat_id_cat"])){
						$rowRetour[$i]["cat_id_cat"] = $id_cat;
						$rowRetour[$i]["cat_label_$currentlang"] = $label_french;
					}else{
						$rowRetour[$i]["cat_id_cat"] .= ";".$id_cat;
						$rowRetour[$i]["cat_label_$currentlang"] .= ";".$label_french;
					}					
				}
			}
		}
	}


	return $rowRetour;
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/

switch($op) {

	case "comments":
		break;

	default:
		mainsearch($author, $category, $topic, $type, $query, $days, $min, $max, $secid);
		break;
}
?>