<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// notes user search as been commented. Uncomment to use it.

if (!preg_match("#modules.php#i", $PHP_SELF)) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

if ($multilingual == 1) {
	$queryalang = "AND (s.alanguage='$currentlang' OR s.alanguage='')"; /* stories */
	$queryrlang = "AND rlanguage='$currentlang' "; /* reviews */
	$queryslang = "AND slanguage='$currentlang' "; /* sections */
} else {
	$queryalang = "";
	$queryrlang = "";
	$queryslang = "";
}

function getNumResults($sql) {
	global $db;
	$result = $db->sql_query($sql);
	$nbre = $db->sql_numrows($result);
	$db->sql_freeresult($result);
	return $nbre;
}

/**
 * mainsearch()
 *
 *
 *
 */
function mainsearch($author, $category=0, $topic, $type, $query, $days, $min, $max, $secid,$secid_no){
	global $searchSaveOcc;
	include("header.php");
	echo "<div class=\"search\">";
	$offset=10;
	if ($type == "adherents") {
		$offset=10;
	}
	if (!isset($min)) $min=0;
	if (!isset($max)) $max=$min+$offset;
	$query = stripslashes($query);
	$pagetitle = "- "._SEARCH."";
	//OpenTable();
	if ($type == "currentstoriessonly") {
		searchHeaderNews($author, $topic, $type, $query, $days, $min, $max,$category);
	}
	else {
		searchHeader($author, $topic, $type, $query, $days, $min, $max,$category, $secid, $secid_no);
	}
	$query = addslashes($query);
	if ($query != "") {
		if($searchSaveOcc == "1") {
			saveOccWordAndExpression($query, $type);
		}
		if ($type=="stories" || $type=="currentstoriessonly" || !$type) {
			resultSearchStorie($category,$author,$topic, $type, $query,$days,$max,$min,$offset);
		} elseif ($type=="comments") {
			resultSearchComment($type, $query,$max,$min,$offset);
		} elseif ($type=="reviews") {
			resultSearchReviews($type, $query,$max,$min,$offset);
		} elseif ($type=="sections") {
			resultSearchSection($type, $query,$max,$min,$offset,$secid, $secid_no);
		} elseif ($type=="users") {
			resultSearchUsers($type, $query,$max,$min,$offset);
		} elseif ($type=="acteurs") {
			resultSearchActeurs($type, $query,$max,$min,$offset);
		} elseif ($type=="annuaire") {
			resultSearchAnnuaire($type, $query,$max,$min,$offset);
		} elseif ($type=="typology") {
			resultSearchTypology($type, $query,$max,$min,$offset);
		} elseif ($type=="adherents") {
			resultSearchAdherents($type, $query,$max,$min,$offset);
		} elseif ($type=="profil") {
			resultSearchProfil($type, $query, $max, $min, $offset);
		} elseif ($type=="agenda") {
			resultSearchAgenda($type, $query,$topic, $max,$min,$offset);
		}
	}
	//CloseTable();
	echo "</div>";
	include("footer.php");
}

function saveOccWordAndExpression($query, $type) {
	global $prefix, $db;
	
	$sql = "SELECT * FROM ".$prefix."_search_expressions WHERE expression='$query' AND type='$type';";
	$result = $db->sql_query($sql);
	if( $db->sql_numrows($result) > 0 ) {
		$sql = "UPDATE ".$prefix."_search_expressions SET occ = occ+1 WHERE expression='$query' AND type='$type';";
	} else {
		$sql = "INSERT INTO ".$prefix."_search_expressions (expression, type, occ) VALUES ('$query', '$type', 1);";
	}
	$db->sql_query($sql);
	
	$words = explode(" ", $query);
	$words = array_unique($words);
	foreach ($words as $word) {
		$sql = "SELECT * FROM ".$prefix."_search_mots WHERE mot='$word' AND type='$type';";
		$result = $db->sql_query($sql);
		if( $db->sql_numrows($result) > 0 ) {
			$sql = "UPDATE ".$prefix."_search_mots SET occ = occ+1 WHERE mot='$word' AND type='$type';";
		} else {
			$sql = "INSERT INTO ".$prefix."_search_mots (mot, type, occ) VALUES ('$word', '$type', 1);";
		}
		$db->sql_query($sql);
	}
}

/**
 * searchHeader
 * @param datatype paramname
 * @return datatype description
 */
function searchHeader($author, $topic ,$type, $query, $days, $min, $max,$category, $secid, $secid_no){
	if (function_exists("themeSearchHeader")) {
		themeSearchHeader($author, $topic ,$type, $query, $days, $min, $max,$category, $secid, $secid_no);
	}
	else {
		global $prefix, $db, $multilingual,$queryrlang, $articlecomm ;
	
		if ($topic>0) {
			$result = $db->sql_query("select topicimage, topictext from ".$prefix."_topics where topicid=$topic");
			list($topicimage, $topictext) = $db->sql_fetchrow($result);
			$db->sql_freeresult($result);
		} else {
			$topictext = ""._SEARCHSECTIONS."";
			$topicimage = "AllTopics.gif";
		}
		if ($type == "users") {
			echo "<h1>"._SEARCHUSERS."</h1>";
		} elseif ($type == "sections") {
			echo "<h1>"._SEARCHSECTIONS."</h1>";
		} elseif ($type == "acteurs") {
			echo "<h1>"._SEARCHACTEURS."</h1>";
		} elseif ($type == "annuaire") {
			echo "<h1>"._SEARCHPRODUCTS."</h1>";
		} elseif ($type == "reviews") {
			echo "<h1>"._SEARCHREVIEWS."</h1>";
		} else {
			//echo "<h1>"._SEARCHIN." $topictext</h1>";
			echo "<h1>$topictext</h1>";
		}
		//echo "<table width=\"100%\" border=\"0\"><TR><TD>";
		/*if (($type == "users") OR ($type == "sections") OR ($type == "reviews")) {
		echo "<img src=\"images/topics/AllTopics.gif\" align=\"right\" border=\"0\" alt=\"\">";
		} else {
		echo "<img src=\"images/topics/$topicimage\" align=\"right\" border=\"0\" alt=\"$topictext\">";
		}*/
	
		if ($type == "stories") {
			$styleopts = " style=\"display: none\""; //n'est pas  "" pour en neutraliser l'affichage
		} elseif ($type == "comments") {
			$styleopts = " style=\"display: none\"";
		} elseif (($type == "sections") OR ($type == "")) {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "users") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "reviews") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "acteurs") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "annuaire") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "typology") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "adherents") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "profil") {
			$styleopts = " style=\"display: none\"";
		} elseif ($type == "agenda") {
			$styleopts = " style=\"display: none\"";
		}
		
		echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
		echo "<div class=\"search_search\">";
		echo "<form action=\"modules.php?name=Search\" method=\"POST\">"
		."<p style=\"text-align: center;\">"
		._SEARCH_CRITERIA
		."<input size=\"25\" type=\"text\" name=\"query\" value=\"$query\" id=\"zquery\">&nbsp;&nbsp;"
		."<input type=\"submit\" value=\""._SEARCH."\"></p>";
	
		echo "<div class=\"search_options\">";
		echo "<div id=\"formframe\" class=\"formiframe\"".$styleopts.">\n";
		/************ Topic Selection ****************/
		$toplist = $db->sql_query("select topicid, topictext from ".$prefix."_topics order by topictext");
		echo "<p style=\"text-align: center;\">";
		echo "<select name=\"topic\" class=\"zcritere\">";
		echo "<option value=\"no\">"._ALLTOPICS."</option>\n";
		while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
			if ($topicid==$topic) { $sel = " selected=\"selected\" "; }
			echo "<option $sel value=\"$topicid\">$topics</option>\n";
			$sel = "";
		}
		$db->sql_freeresult($toplist);
		echo "</select>";
		/************ Category Selection ****************/
		echo "&nbsp;<select name=\"category\"  class=\"zcritere\">";
		echo "<option value=\"\">"._ALLCATEGS."</option>\n";
		$catlist = $db->sql_query("select catid, title from ".$prefix."_stories_cat order by title");
		while(list($catid, $title) = $db->sql_fetchrow($catlist)) {
			if ($catid==$category) { $sel = " selected=\"selected\" "; }
			echo "<option $sel value=\"$catid\">$title</option>\n";
			$sel = "";
		}
		echo "</select>";
		$db->sql_freeresult($catlist);
		/************ Authors Selection ******************/
		$thing = $db->sql_query("select aid from ".$prefix."_authors order by aid");
		echo "&nbsp;<select name=\"author\"  class=\"zcritere\">";
		echo "<option value=\"no\">"._ALLAUTHORS."</option>\n";
		while(list($authors) = $db->sql_fetchrow($thing)) {
			if ($authors==$author) { $sel = " selected=\"selected\" "; }
			echo "<option value=\"$authors\"$sel>$authors</option>\n";
			$sel = "";
		}
		echo "</select>";
		$db->sql_freeresult($thing);
		/**************  Date Selection ***************/
		echo "&nbsp;<select name=\"days\" class=\"zcritere\">"
		."<option ".(($days == 0)?"selected=\"selected\"":"")." value=\"0\">"._ALL."</option>"
		."<option ".(($days == 7)?"selected=\"selected\"" :"")." value=\"7\">1 "._WEEK."</option>"
		."<option ".(($days == 14)?"selected=\"selected\"":"")." value=\"14\">2 "._WEEKS."</option>"
		."<option ".(($days == 30)?"selected=\"selected\"":"")." value=\"30\">1 "._MONTH."</option>"
		."<option ".(($days == 60)?"selected=\"selected\"":"")." value=\"60\">2 "._MONTHS."</option>"
		."<option ".(($days == 90)?"selected=\"selected\"":"")." value=\"90\">3 "._MONTHS."</option>"
		."</select>";
		echo "</p>";
		echo "</div>";
	
	
		if ($type == "stories") {
			$sel1 = "checked";
		} elseif ($type == "comments") {
			$sel2 = "checked";
		} elseif (($type == "sections") OR ($type == "")) {
			$sel3 = "checked";
		} elseif ($type == "users") {
			$sel4 = "checked";
		} elseif ($type == "reviews") {
			$sel5 = "checked";
		} elseif ($type == "acteurs") {
			$sel6 = "checked";
		} elseif ($type == "annuaire") {
			$sel7 = "checked";
		} elseif ($type == "typology") {
			$sel8 = "checked";
		} elseif ($type == "adherents") {
			$sel9 = "checked";
		} elseif ($type == "profil") {
			$sel10 = "checked";
		} elseif ($type == "agenda") {
			$sel11 = "checked";
		} 
		
	
		$num_sec = $db->sql_numrows($db->sql_query("select * from ".$prefix."_sections"));
		$num_rev = $db->sql_numrows($db->sql_query("select * from ".$prefix."_reviews"));
	
		echo "<p style=\"text-align: center;\">";
		echo ""._SEARCHON."";
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
		if ($type == "sections") { echo "<SCRIPT language=\"JavaScript\">displayIFrame('formframe',false);</SCRIPT>\n"; }
		//echo "<input type=\"radio\" name=\"type\" value=\"stories\" $sel1 onclick=\"javascript:switchdisplayIFrame('formframe');\" id=\"brad1\"><label for=\"brad1\">"._SSTORIES."</label>";
		if (is_active("News")){
			echo "<input type=\"radio\" name=\"type\" value=\"stories\" $sel1 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad1\"><label for=\"brad1\">"._SSTORIES."</label>";
		}
		if ($articlecomm){
			echo "<input type=\"radio\" name=\"type\" value=\"comments\" $sel2 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad2\"><label for=\"brad2\">"._SCOMMENTS."</label>";
		}
		if ($num_sec > 0) {
			echo "<input type=\"radio\" name=\"type\" value=\"sections\" $sel3 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad3\"><label for=\"brad3\">"._SSECTIONS."</label>";
			echo "<input type=\"hidden\" name=\"secid\" value=\"".$secid."\">";
			echo "<input type=\"hidden\" name=\"secid_no\" value=\"".$secid_no."\">";
		}
		//echo "<input type=\"radio\" name=\"type\" value=\"users\" $sel4 onclick=\"javascript:displayIFrame('formframe',false);\"> "._SUSERS."";
		if ($num_rev > 0) {
			echo "<input type=\"radio\" name=\"type\" value=\"reviews\" $sel5 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad4\"><label for=\"brad4\">"._REVIEWS."</label>";
		}
		if (is_active("becmsOrgDirectory")){
			echo "<input type=\"radio\" name=\"type\" value=\"acteurs\" $sel6 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad5\"><label for=\"brad5\">"._SACTEURS."</label>";
		}
		if (is_active("SimpleAnnuaire")){
			echo "<input type=\"radio\" name=\"type\" value=\"annuaire\" $sel7 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad6\"><label for=\"brad6\">"._SANNUAIRE."</label>";
		}
		if (is_active("SimpleTypology")){
			echo "<input type=\"radio\" name=\"type\" value=\"typology\" $sel8 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad7\"><label for=\"brad7\">"._STYPOLOGY."</label>";
		}
		if (is_active("SimpleAdherents")){
			echo "<input type=\"radio\" name=\"type\" value=\"adherents\" $sel9 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad8\"><label for=\"brad8\">"._SADHERENTS."</label>";
		}
		if (is_active("SimpleProfil")){
			echo "<input type=\"radio\" name=\"type\" value=\"profil\" $sel10 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad9\"><label for=\"brad9\">"._SPROFIL."</label>";
		}
		if (is_active("Calendrier")){
			echo "<input type=\"radio\" name=\"type\" value=\"agenda\" $sel11 onclick=\"javascript:displayIFrame('formframe',false);\" id=\"brad10\"><label for=\"brad10\">"._SCALENDRIER."</label>";
		}
		//echo "</form></td></tr></table>";
		echo "</p>";
		echo "</div>";
		echo "</form>";
		echo "</div>";
		echo "</fieldset>";
	}
}

/**
 * resultSearchStorie()
 * @param datatype paramname
 * @return datatype description
 *
 */
function resultSearchStorie($category,$author, $topic, $type, $query,$days,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryalang ;
	//echo "cat: $category, -$query- , $type, $max, $min, $offset";

	if ($author=="no") $author="";
	if ($topic=="no" || $topic <= 0) $topic="";
	if ($category == "no" || $category < 0) $categ = "";
	
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (s.title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (s.hometext, s.bodytext, s.notes) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "s.title like '%$query%' OR s.hometext like '%$query%' OR s.bodytext like '%$query%' OR s.notes like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR s.title like '%$query2%' OR s.hometext like '%$query2%' OR s.bodytext like '%$query2%' OR s.notes like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (s.title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (s.hometext, s.bodytext, s.notes) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR s.title like '%$word%' OR s.hometext like '%$word%' OR s.bodytext like '%$word%' OR s.notes like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT s.sid, s.aid, s.informant, s.title, s.time, s.hometext, s.bodytext, a.url, s.comments, s.topic, "
			. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_stories s, ".$prefix."_authors a";
	
	$where = " WHERE s.aid=a.aid $queryalang $categ AND ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) ";
	if ($author!= "") $where .= "AND s.aid='$author' ";
	if ($topic != "") $where .= "AND s.topic='$topic' ";
	if ($category != "") $where .= "AND s.catid='$category' ";
	if ($days != "" && $days!=0) $where .= "AND TO_DAYS(NOW()) - TO_DAYS(time) <= $days ";
	
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;
	//echo $sql;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//        echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";

	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($sid, $aid, $informant, $title, $time, $hometext, $bodytext, $url, $comments, $topic) = $db->sql_fetchrow($result)) {

			$result2 = $db->sql_query("select topicname, topictext from ".$prefix."_topics where topicid=$topic");
			list($topicname, $topictext) = $db->sql_fetchrow($result2);

			$furl = "modules.php?name=News&file=article&sid=$sid&highlite=".urlencode($query);
			$datetime = formatTimestamp($time);
			$query = stripslashes($query);
			if ($informant == "") {
				$informant = $anonymous;
			}
			else {
				$informant = "<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$informant\">$informant</a>";
			}
			if ($query != "") {
				if (preg_match("#$query#i",$title)) {
					$a = 1;
				}
				$text = "$hometext$bodytext";
				if (preg_match("#$query#i",$text)) {
					$a = 2;
				}
				if (preg_match("#$query#i",$text) AND preg_match("#$query#i",$title)) {
					$a = 3;
				}
				if ($a == 1) {
					$match = _MATCHTITLE;
				} elseif ($a == 2) {
					$match = _MATCHTEXT;
				} elseif ($a == 3) {
					$match = _MATCHBOTH;
				}
				if (!isset($a)) {
					$match = "";
				} else {
					$match = "$match<br>";
				}
			}
			//printf("<tr><td class=resultLinkArticle><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			//printf("<li><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			printf("<li><a href=\"%s\"><b>%s</b></a><br>",$furl,$title);
			//echo " "._ON." ".preg_replace("#([0-9]+):([0-9]+):([0-9]+)#","\\1H\\2",$datetime)."<br>";
			echo "$match"
			.""._TOPIC.": <a href=\"modules.php?name=News&new_topic=$topic\">$topicname</a> ";
			if ($comments == 0) {
				//echo "("._NOCOMMENTS.")";
			} elseif ($comments == 1) {
				echo "($comments "._UCOMMENT.")";
			} elseif ($comments >1) {
				echo "($comments "._UCOMMENTS.")";
			}
			if (is_admin($admin)) {
				echo " [ <a href=\"admin.php?op=EditStory&amp;sid=$sid\">"._EDIT."</a> | <a href=\"admin.php?op=RemoveStory&amp;sid=$sid\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}

		echo "</ul>";
	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";

	}

	$prev=$min-$offset;
	echo "<div class=\"prevnext\">";
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchStorie()
 * @param datatype paramname
 * @return datatype description
 *
 */
function resultSearchStorieOld($category,$author, $topic, $type, $query,$days,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryalang ;
	//echo "cat: $category, -$query- , $type, $max, $min, $offset";

	if ($author=="no") $author="";
	if ($topic=="no" || $topic <= 0) $topic="";
	if ($category == "no" || $category < 0) $categ = "";

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");

	$weightExp = "10";
	$weightWord = "0.5";
	$weightOcc = "0.1";

	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);

	$words = array_merge($words, $words2);
	$words = array_unique($words);

	$matchAgainstExp = ' MATCH (s.title, s.hometext, s.bodytext, s.notes) AGAINST (\'"'.$query.'"';
	if($query != $query2) {
		$matchAgainstExp .= ' "'.$query2.'"';
	}
	$matchAgainstExp .= "' IN BOOLEAN MODE)";

	$matchAgainstWorld = " MATCH (s.title, s.hometext, s.bodytext, s.notes) AGAINST ('";
	$likes = " (";
	$occ = " (";

	$likes .= "s.title like '%$query%' OR s.hometext like '%$query%' OR s.bodytext like '%$query%' OR s.notes like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query', '')) ) / (LENGTH('$query')))";

	if($query != $query2) {
		$likes .= " OR s.title like '%$query2%' OR s.hometext like '%$query2%' OR s.bodytext like '%$query2%' OR s.notes like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$query2', '')) ) / (LENGTH('$query2')))";
	}

	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorld .= " $word*";
		$likes .= " OR s.title like '%$word%' OR s.hometext like '%$word%' OR s.bodytext like '%$word%' OR s.notes like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(s.title) - LENGTH(REPLACE(s.title, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(s.hometext) - LENGTH(REPLACE(s.hometext, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(s.bodytext) - LENGTH(REPLACE(s.bodytext, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(s.notes) - LENGTH(REPLACE(s.notes, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}

	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorld .= "' IN BOOLEAN MODE)";

	$select = "SELECT s.sid, s.aid, s.informant, s.title, s.time, s.hometext, s.bodytext, a.url, s.comments, s.topic, "
			. "(($matchAgainstExp * $weightExp) + ($matchAgainstWorld * $weightWord) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_stories s, ".$prefix."_authors a";

	$where = " WHERE s.aid=a.aid $queryalang $categ AND ($matchAgainstExp OR $matchAgainstWorld OR $likes) ";
	if ($author!= "") $where .= "AND s.aid='$author' ";
	if ($topic != "") $where .= "AND s.topic='$topic' ";
	if ($category != "") $where .= "AND s.catid='$category' ";
	if ($days != "" && $days!=0) $where .= "AND TO_DAYS(NOW()) - TO_DAYS(time) <= $days ";

	$orderBy = " ORDER BY cpt DESC";

	$sql = $select.$where;
	//echo $sql;

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//        echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";

	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($sid, $aid, $informant, $title, $time, $hometext, $bodytext, $url, $comments, $topic) = $db->sql_fetchrow($result)) {

			$result2 = $db->sql_query("select topicname, topictext from ".$prefix."_topics where topicid=$topic");
			list($topicname, $topictext) = $db->sql_fetchrow($result2);

			$furl = "modules.php?name=News&file=article&sid=$sid&highlite=".urlencode($query);
			$datetime = formatTimestamp($time);
			$query = stripslashes($query);
			if ($informant == "") {
				$informant = $anonymous;
			}
			else {
				$informant = "<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$informant\">$informant</a>";
			}
			if ($query != "") {
				if (preg_match("#$query#i",$title)) {
					$a = 1;
				}
				$text = "$hometext$bodytext";
				if (preg_match("#$query#i",$text)) {
					$a = 2;
				}
				if (preg_match("#$query#i",$text) AND preg_match("#$query#i",$title)) {
					$a = 3;
				}
				if ($a == 1) {
					$match = _MATCHTITLE;
				} elseif ($a == 2) {
					$match = _MATCHTEXT;
				} elseif ($a == 3) {
					$match = _MATCHBOTH;
				}
				if (!isset($a)) {
					$match = "";
				} else {
					$match = "$match<br>";
				}
			}
			//printf("<tr><td class=resultLinkArticle><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			//printf("<li><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			printf("<li><a href=\"%s\"><b>%s</b></a><br>",$furl,$title);
			//echo " "._ON." ".preg_replace("#([0-9]+):([0-9]+):([0-9]+)#","\\1H\\2",$datetime)."<br>";
			echo "$match"
			.""._TOPIC.": <a href=\"modules.php?name=News&new_topic=$topic\">$topicname</a> ";
			if ($comments == 0) {
				//echo "("._NOCOMMENTS.")";
			} elseif ($comments == 1) {
				echo "($comments "._UCOMMENT.")";
			} elseif ($comments >1) {
				echo "($comments "._UCOMMENTS.")";
			}
			if (is_admin($admin)) {
				echo " [ <a href=\"admin.php?op=EditStory&amp;sid=$sid\">"._EDIT."</a> | <a href=\"admin.php?op=RemoveStory&amp;sid=$sid\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}

		echo "</ul>";
	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";

	}

	$prev=$min-$offset;
	echo "<div class=\"prevnext\">";
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchStorie()
 * @param datatype paramname
 * @return datatype description
 *
 */
function resultSearchStorieOriginal($category,$author, $topic, $type, $query,$days,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryalang ;
	//echo "cat: $category, -$query- , $type, $max, $min, $offset";

	if ($author=="no") $author="";
	if ($topic=="no" || $topic <= 0) $topic="";
	if ($category == "no" || $category < 0) $categ = "";

	$query2 = htmlentities($query,ENT_NOQUOTES, "ISO-8859-1");
	$q = "select s.sid, s.aid, s.informant, s.title, s.time, s.hometext, s.bodytext, a.url, s.comments, s.topic from ".$prefix."_stories s, ".$prefix."_authors a where s.aid=a.aid $queryalang $categ";
	if ($query != "") $q .= "AND (s.title LIKE '%$query%' OR s.hometext LIKE '%$query%' OR s.bodytext LIKE '%$query%' OR s.notes LIKE '%$query%' OR s.title LIKE '%$query2%' OR s.hometext LIKE '%$query2%' OR s.bodytext LIKE '%$query2%' OR s.notes LIKE '%$query2%') ";
	if ($author!= "") $q .= "AND s.aid='$author' ";
	if ($topic != "") $q .= "AND s.topic='$topic' ";
	if ($category != "") $q .= "AND s.catid='$category' ";
	if ($days != "" && $days!=0) $q .= "AND TO_DAYS(NOW()) - TO_DAYS(time) <= $days ";


	$sql = $q;
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$t = $topic;
	//echo "//$q//";
	$q .= " ORDER BY s.time DESC LIMIT $min,$offset";
	$result = $db->sql_query($q);
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//        echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";

	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($sid, $aid, $informant, $title, $time, $hometext, $bodytext, $url, $comments, $topic) = $db->sql_fetchrow($result)) {

			$result2 = $db->sql_query("select topicname, topictext from ".$prefix."_topics where topicid=$topic");
			list($topicname, $topictext) = $db->sql_fetchrow($result2);

			$furl = "modules.php?name=News&file=article&sid=$sid&highlite=".urlencode($query);
			$datetime = formatTimestamp($time);
			$query = stripslashes($query);
			if ($informant == "") {
				$informant = $anonymous;
			}
			else {
				$informant = "<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$informant\">$informant</a>";
			}
			if ($query != "") {
				if (preg_match("#$query#i",$title)) {
					$a = 1;
				}
				$text = "$hometext$bodytext";
				if (preg_match("#$query#i",$text)) {
					$a = 2;
				}
				if (preg_match("#$query#i",$text) AND preg_match("#$query#i",$title)) {
					$a = 3;
				}
				if ($a == 1) {
					$match = _MATCHTITLE;
				} elseif ($a == 2) {
					$match = _MATCHTEXT;
				} elseif ($a == 3) {
					$match = _MATCHBOTH;
				}
				if (!isset($a)) {
					$match = "";
				} else {
					$match = "$match<br>";
				}
			}
			//printf("<tr><td class=resultLinkArticle><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			//printf("<li><a href=\"%s\"><b>%s</b></a><br>"._CONTRIBUTEDBY." $informant<br>"._POSTEDBY." <a href=\"%s\">%s</a>",$furl,$title,$url,$aid,$informant);
			printf("<li><a href=\"%s\"><b>%s</b></a><br>",$furl,$title);
			//echo " "._ON." ".preg_replace("#([0-9]+):([0-9]+):([0-9]+)#","\\1H\\2",$datetime)."<br>";
			echo "$match"
			.""._TOPIC.": <a href=\"modules.php?name=News&new_topic=$topic\">$topicname</a> ";
			if ($comments == 0) {
				//echo "("._NOCOMMENTS.")";
			} elseif ($comments == 1) {
				echo "($comments "._UCOMMENT.")";
			} elseif ($comments >1) {
				echo "($comments "._UCOMMENTS.")";
			}
			if (is_admin($admin)) {
				echo " [ <a href=\"admin.php?op=EditStory&amp;sid=$sid\">"._EDIT."</a> | <a href=\"admin.php?op=RemoveStory&amp;sid=$sid\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}

		echo "</ul>";
	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";

	}

	$prev=$min-$offset;
	echo "<div class=\"prevnext\">";
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type&amp;category=$category\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchComment
 *
 * @param  datatype paramname
 * @return datatype description
 */
function resultSearchComment($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang ;
	
	$sql = "select tid, sid, subject, date, name from ".$prefix."_comments where (subject like '%$query%' OR comment like '%$query%')";
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." order by date DESC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($tid, $sid, $subject, $date, $name) = $db->sql_fetchrow($result)) {
			$res = $db->sql_query("select title from ".$prefix."_stories where sid='$sid'");
			list($title) = $db->sql_fetchrow($res);
			$reply = $db->sql_numrows($db->sql_query("select * from ".$prefix."_comments where pid='$tid'"));
			$furl = "modules.php?name=News&amp;file=article&amp;sid=$sid#$tid";
			if(!$name) {
				$name = "$anonymous";
			} else {
				$name = "<a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$name\">$name</a>";
			}
			$datetime = utf8_decode(formatTimestamp($date));
			echo "<li><a href=\"$furl\">$subject</a><br>"._POSTEDBY." $name"
			." "._ON." $datetime<br>"
			.""._ATTACHART.": $title<br>";
			if ($reply == 1) {
				echo "($reply "._SREPLY.")";
				if (is_admin($admin)) {
					echo " [ <a href=\"admin.php?op=RemoveComment&amp;tid=$tid&amp;sid=$sid\">"._DELETE."</a> ]";
				}
				echo "</li>\n";
			} else {
				echo "($reply "._SREPLIES.")";
				if (is_admin($admin)) {
					echo " [ <a href=\"admin.php?op=RemoveComment&amp;tid=$tid&amp;sid=$sid\">"._DELETE."</a> ]";
				}
				echo "</li>\n";
			}
		}
		echo "</ul>";
		//echo "</table>";
	} else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$topic&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$topic&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchReviews
 *
 * @param  datatype paramname
 * @return datatype description
 */
function resultSearchReviews($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang ;
	
	$sql = "select id, title, text, reviewer, score from ".$prefix."_reviews where (title like '%$query%' OR text like '%$query%') $queryrlang";
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." order by date DESC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($id, $title, $text, $reviewer, $score) = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=Reviews&amp;op=showcontent&amp;id=$id";
			$pages = count(explode( "<!--pagebreak-->", $text ));
			echo "<li>";
			echo "<a href=\"$furl\">$title</a><br>"
			.""._POSTEDBY." $reviewer<br>"
			.""._REVIEWSCORE.": $score/10<br>";
			if ($pages == 1) {
				echo "($pages "._PAGE.")";
			} else {
				echo "($pages "._PAGES.")";
			}
			if (is_admin($admin)) {
				echo " [ <a href=\"modules.php?name=Reviews&amp;op=mod_review&amp;id=$id\">"._EDIT."</a> | <a href=\"modules.php?name=Reviews.php&amp;op=del_review&amp;id_del=$id\">"._DELETE."</a> ]";
			}
			print "</li>\n";
		}
		//echo "</table>";
		echo "</ul>";
	} else {
		// echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>&nbsp;&nbsp;";
	}
	echo "</div>";

}
/**
 * resultSearchSection
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchSection($type, $query,$max,$min,$offset, $secid="", $secid_no=""){
	global $prefix, $db, $multilingual,$queryslang, $Default_Theme ;
	
	require_once("includes/truncate_string.php");
	
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (content) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";

	$likes = " (";
	$occ = " (";
	
	$likes .= "title like '%$query%' OR content like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR content like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (content) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR title like '%$word%' OR content like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";

	$conditionSecid ="";
	if($secid != ""){
		$listSecid = array_unique(array_map("trim", explode(",", $secid)));
		foreach($listSecid as $idSection){
			$conditionSecid .=  ($conditionSecid != "") ? " OR secid=".$idSection : "secid=".$idSection;
		}
		$conditionSecid = ($conditionSecid != "") ? " AND (".$conditionSecid.")":"";
	}
	$conditionSecidno ="";
	if($secid_no != ""){
		$listSecid = array_unique(array_map("trim", explode(",", $secid_no)));
		foreach($listSecid as $idSection){
			$conditionSecidno .=  ($conditionSecidno != "") ? " AND secid<>".$idSection : "secid<>".$idSection;
		}
		$conditionSecidno = ($conditionSecidno != "") ? " AND (".$conditionSecidno.")":"";
	}
	
	$select = "SELECT artid, secid, title, content, popup, " 
		. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
		. " FROM ".$prefix."_seccont";
	
	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) AND status='P'".$conditionSecid.$conditionSecidno."$queryslang";
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;
	//echo $sql;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	//$result = $db->sql_query($sql."  order by artid DESC limit $min,$offset");
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);

	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	$themePopUp = (!file_exists('javascripts/windows_js/themes/'.'becms_'.$Default_Theme.'.css')) ? "becms_alphacube" : "becms_".$Default_Theme;
	echo '
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/'.$themePopUp.'.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_minifiche(titre,url) {
		win = new Window({className: "'.$themePopUp.'", title: titre, width:800, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: true, maximizable: true});
		win.showCenter(true);
	}
</script>
';
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($artid, $secid2, $title, $content, $popup) = $db->sql_fetchrow($result)) {
			//$pages = count(explode( "<!--pagebreak-->", $content ));
			$result2 = $db->sql_query("select secname from ".$prefix."_sections where secid='$secid2'");
			list($sectitle) = $db->sql_fetchrow($result2);
			$surl = "modules.php?name=Sections&amp;sop=listarticles&amp;secid=$secid2";
			//$furl = "modules.php?name=Sections&amp;sop=viewarticle&amp;artid=$artid";
			//echo "<tr><td class=resultLinkPage><a href=\"$furl\"><b>$title</b></a><br>"._INSECTION.": <a href=\"$surl\">$sectitle</a><br>";
			$content = strip_tags($content);
			$content = truncate_string($content,"200");
			if ($popup == "0") {
				$furl = "modules.php?name=Sections&sop=viewarticle&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\">$title</a><br /><p>".$content."</p>";
			}
			else {
				$furl = "modules.php?name=Sections&sop=viewarticlenotheme&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\" title=\"".str_replace("\"", "&quot;", $title)."\" onclick=\"ouvre_minifiche(this.title,this.href); return false\">$title</a><br /><p>".$content."</p>";
			}
			//echo _INSECTION.": <a href=\"$surl\">$sectitle</a>";
			 
			/*if ($pages == 1) {
				echo " ($pages "._PAGE.")";
			} else {
				echo " ($pages "._PAGES.")";
			}
			if (is_admin($admin)) {
				echo " [ <a href=\"admin.php?op=secartedit&amp;artid=$artid\">"._EDIT."</a> | <a href=\"admin.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";
			}*/
			//echo "</font><br><br></td></tr>\n";
			echo "</li>";
		}
		echo "</ul>";
	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type&amp;secid=$secid&amp;secid_no=$secid_no\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type&amp;secid=$secid&amp;secid_no=$secid_no\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchSection
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchSectionOld($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryslang, $Default_Theme ;

	require_once("includes/truncate_string.php");

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");

	$weightExp = "10";
	$weightWord = "0.5";
	$weightOcc = "0.1";

	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);

	$words = array_merge($words, $words2);
	$words = array_unique($words);

	$matchAgainstExp = ' MATCH (title, content) AGAINST (\'"'.$query.'"';
	 if($query != $query2) {
		$matchAgainstExp .= " '$query2'";
	}
	$matchAgainstExp .= "' IN BOOLEAN MODE)";

	$likes = " (";
	$occ = " (";

	$likes .= "title like '%$query%' OR content like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query', '')) ) / (LENGTH('$query')))";

	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR content like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$query2', '')) ) / (LENGTH('$query2')))";
	}

	$matchAgainstWorld = " MATCH (title, content) AGAINST ('";

	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorld .= " $word*";
		$likes .= " OR title like '%$word%' OR content like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(content) - LENGTH(REPLACE(content, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}

	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorld .= "' IN BOOLEAN MODE)";

 	$select = "SELECT artid, secid, title, content, popup, "
 		. "(($matchAgainstExp * $weightExp) + ($matchAgainstWorld * $weightWord) + (($occ / $nbWord) * $weightOcc)) AS cpt "
 		. " FROM ".$prefix."_seccont";

	$where = " WHERE ($matchAgainstExp OR $matchAgainstWorld OR $likes) AND status='P' $queryslang";
 	$orderBy = " ORDER BY cpt DESC";

	$sql = $select.$where;
	//echo $sql;

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	//$result = $db->sql_query($sql."  order by artid DESC limit $min,$offset");
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);

	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	$themePopUp = (!file_exists('javascripts/windows_js/themes/'.'becms_'.$Default_Theme.'.css')) ? "becms_alphacube" : "becms_".$Default_Theme;
	echo '
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/'.$themePopUp.'.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_minifiche(titre,url) {
		win = new Window({className: "'.$themePopUp.'", title: titre, width:800, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: true, maximizable: true});
		win.showCenter(true);
	}
</script>
';
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($artid, $secid, $title, $content, $popup) = $db->sql_fetchrow($result)) {
			//$pages = count(explode( "<!--pagebreak-->", $content ));
			$result2 = $db->sql_query("select secname from ".$prefix."_sections where secid='$secid'");
			list($sectitle) = $db->sql_fetchrow($result2);
			$surl = "modules.php?name=Sections&amp;sop=listarticles&amp;secid=$secid";
			//$furl = "modules.php?name=Sections&amp;sop=viewarticle&amp;artid=$artid";
			//echo "<tr><td class=resultLinkPage><a href=\"$furl\"><b>$title</b></a><br>"._INSECTION.": <a href=\"$surl\">$sectitle</a><br>";
			$content = strip_tags($content);
			$content = truncate_string($content,"200");
			if ($popup == "0") {
				$furl = "modules.php?name=Sections&sop=viewarticle&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\">$title</a><br /><p>".$content."</p>";
			}
			else {
				$furl = "modules.php?name=Sections&sop=viewarticlenotheme&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\" title=\"".str_replace("\"", "&quot;", $title)."\" onclick=\"ouvre_minifiche(this.title,this.href); return false\">$title</a>";
			}
			//echo _INSECTION.": <a href=\"$surl\">$sectitle</a>";

			/*if ($pages == 1) {
				echo " ($pages "._PAGE.")";
			} else {
			echo " ($pages "._PAGES.")";
			}
			if (is_admin($admin)) {
			echo " [ <a href=\"admin.php?op=secartedit&amp;artid=$artid\">"._EDIT."</a> | <a href=\"admin.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";
			}*/
			//echo "</font><br><br></td></tr>\n";
			echo "</li>";
		}
		echo "</ul>";


	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchSection
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchSectionOriginal($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryslang, $Default_Theme ;

	require_once("includes/truncate_string.php");

	$query2 = htmlentities($query,ENT_NOQUOTES, "ISO-8859-1");

	$sql = "select artid, secid, title, content, popup from ".$prefix."_seccont where (title like '%$query%' OR content like '%$query%' OR title like '%$query2%' OR content like '%$query2%') AND status='P' $queryslang";

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$result = $db->sql_query($sql."  order by artid DESC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);

	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	$themePopUp = (!file_exists('javascripts/windows_js/themes/'.'becms_'.$Default_Theme.'.css')) ? "becms_alphacube" : "becms_".$Default_Theme;
	echo '
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/'.$themePopUp.'.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_minifiche(titre,url) {
		win = new Window({className: "'.$themePopUp.'", title: titre, width:800, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: true, maximizable: true});
		win.showCenter(true);
	}
</script>
';
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($artid, $secid, $title, $content, $popup) = $db->sql_fetchrow($result)) {
			//$pages = count(explode( "<!--pagebreak-->", $content ));
			$result2 = $db->sql_query("select secname from ".$prefix."_sections where secid='$secid'");
			list($sectitle) = $db->sql_fetchrow($result2);
			$surl = "modules.php?name=Sections&amp;sop=listarticles&amp;secid=$secid";
			//$furl = "modules.php?name=Sections&amp;sop=viewarticle&amp;artid=$artid";
			//echo "<tr><td class=resultLinkPage><a href=\"$furl\"><b>$title</b></a><br>"._INSECTION.": <a href=\"$surl\">$sectitle</a><br>";
			$content = strip_tags($content);
			$content = truncate_string($content,"200");
			if ($popup == "0") {
				$furl = "modules.php?name=Sections&sop=viewarticle&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\">$title</a><br /><p>".$content."</p>";
			}
			else {
				$furl = "modules.php?name=Sections&sop=viewarticlenotheme&artid=$artid&highlite=".urlencode($query);
				echo "<li><a href=\"$furl\" title=\"".str_replace("\"", "&quot;", $title)."\" onclick=\"ouvre_minifiche(this.title,this.href); return false\">$title</a>";
			}
			//echo _INSECTION.": <a href=\"$surl\">$sectitle</a>";

			/*if ($pages == 1) {
				echo " ($pages "._PAGE.")";
			} else {
			echo " ($pages "._PAGES.")";
			}
			if (is_admin($admin)) {
			echo " [ <a href=\"admin.php?op=secartedit&amp;artid=$artid\">"._EDIT."</a> | <a href=\"admin.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";
			}*/
			//echo "</font><br><br></td></tr>\n";
			echo "</li>";
		}
		echo "</ul>";


	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchAgenda
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchAgenda($type, $query,$topic, $max,$min,$offset){
	global $prefix, $db, $multilingual,$queryslang ;

	require_once("includes/truncate_string.php");

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (title) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (hometext) AGAINST ('\"$query\"'";
	if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "title like '%$query%' OR hometext like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR hometext like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (title) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (hometext) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR title like '%$word%' OR hometext like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT eid, title, hometext, comments, counter, topic, informant, time, eventDate, endDate, startTime, endTime, alldayevent, barcolor, withregistration, "
			. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_events";
	
	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes)";
	if ($topic != "no" && $topic!="") {
		$where = " AND topic='".$topic."'";
	}
	
	$orderBy = " ORDER BY cpt DESC";
	
	$sql = $select.$where;
	//echo $sql;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($eid, $title, $hometext) = $db->sql_fetchrow($result)) {
			$hometext = strip_tags($hometext);
			$hometext = truncate_string($hometext,"200");
			$furl = "modules.php?name=Calendrier&op=viewmanif&eid=$eid&highlite=".urlencode($query);
			echo "<li><a href=\"$furl\">$title</a><br /><p>".$hometext."</p>";
			echo "</li>";
		}
		echo "</ul>";


	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchAgenda
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchAgendaOld($type, $query,$topic, $max,$min,$offset){
	global $prefix, $db, $multilingual,$queryslang ;

	require_once("includes/truncate_string.php");

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");

	$weightExp = "10";
	$weightWord = "0.5";
	$weightOcc = "0.1";

	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);

	$words = array_merge($words, $words2);
	$words = array_unique($words);

	$matchAgainstExp = ' MATCH (title, hometext) AGAINST (\'"'.$query.'"';
	if($query != $query2) {
		$matchAgainstExp .= ' "'.$query2.'"';
	}
	$matchAgainstExp .= "' IN BOOLEAN MODE)";

	$matchAgainstWorld = " MATCH (title, hometext) AGAINST ('";
	$likes = " (";
	$occ = " (";

	$likes .= "title like '%$query%' OR hometext like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query', '')) ) / (LENGTH('$query')))";

	if($query != $query2) {
		$likes .= " OR title like '%$query2%' OR hometext like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$query2', '')) ) / (LENGTH('$query2')))";
	}

	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorld .= " $word*";
		$likes .= " OR title like '%$word%' OR hometext like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(title) - LENGTH(REPLACE(title, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(hometext) - LENGTH(REPLACE(hometext, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}

	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorld .= "' IN BOOLEAN MODE)";

	$select = "SELECT eid, title, hometext, comments, counter, topic, informant, time, eventDate, endDate, startTime, endTime, alldayevent, barcolor, withregistration, "
			. "(($matchAgainstExp * $weightExp) + ($matchAgainstWorld * $weightWord) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_events";

	$where = " WHERE ($matchAgainstExp OR $matchAgainstWorld OR $likes)";
	if ($topic != "no" && $topic!="") {
		$where = " AND topic='".$topic."'";
	}

	$orderBy = " ORDER BY cpt DESC";

	$sql = $select.$where;
	//echo $sql;

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($eid, $title, $hometext) = $db->sql_fetchrow($result)) {
			$hometext = strip_tags($hometext);
			$hometext = truncate_string($hometext,"200");
			$furl = "modules.php?name=Calendrier&op=viewmanif&eid=$eid&highlite=".urlencode($query);
			echo "<li><a href=\"$furl\">$title</a><br /><p>".$hometext."</p>";
			echo "</li>";
		}
		echo "</ul>";


	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchAgenda
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchAgendaOriginal($type, $query,$topic, $max,$min,$offset){
	global $prefix, $db, $multilingual,$queryslang ;
	
	require_once("includes/truncate_string.php");
	
	$query2 = htmlentities($query,ENT_NOQUOTES, "ISO-8859-1");
	
	$where = "";
 	if ($topic != "no" && $topic!="") {
 		$where = " AND topic='".$topic."'";
 	}
	
	$sql = "select eid,	title, hometext, comments, counter, topic, informant, time, eventDate, endDate, startTime, endTime, alldayevent, barcolor, withregistration from ".$prefix."_events where (title like '%$query%' OR hometext like '%$query%' OR title like '%$query2%' OR hometext like '%$query2%')".$where;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);	
	$result = $db->sql_query($sql."  order by eventDate DESC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($eid, $title, $hometext) = $db->sql_fetchrow($result)) {
			$hometext = strip_tags($hometext);
			$hometext = truncate_string($hometext,"200");
			$furl = "modules.php?name=Calendrier&op=viewmanif&eid=$eid&highlite=".urlencode($query);
			echo "<li><a href=\"$furl\">$title</a><br /><p>".$hometext."</p>";
			echo "</li>";
		}
		echo "</ul>";


	}
	else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}
	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&topic=$topic&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}
/**
 * resultSearchUsers
 * @param datatype paramname
 * @return datatype description
 */
function resultSearchUsers($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang ;
	
	$sql = "select uid, uname, name from ".$prefix."_users where (uname like '%$query%' OR name like '%$query%' OR bio like '%$query%')";
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." order by uname ASC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($uid, $uname, $name) = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$uname";
			if ($name=="") {
				$name = ""._NONAME."";
			}
			echo "<li><a href=\"$furl\">$uname</a> ($name)";
			if (is_admin($admin)) {
				echo " [ <a href=\"admin.php?chng_uid=$uid&amp;op=modifyUser\">"._EDIT."</a> | <a href=\"admin.php?op=delUser&amp;chng_uid=$uid\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}
		echo "</ul>";
		//echo "</table>";
	} else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print ""._NEXTMATCHES."</a>";
	}
	echo "</div>";
}
/**
 * resultSearchActeurs
 * @param datatype paramname
 * @return
 */
function resultSearchActeurs($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang,$admin;
	
	/*$accent  ="";
	$noaccent="aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby";
	$query = strtr(trim($query),$accent,$noaccent);*/
		
	$query = trim($query);
	//$query2 = htmlentities($query, ENT_NOQUOTES);
	$query2 = $query;
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	//$words2 = explode(" ", $query2);
	
	//$words = array_merge($words, $words2);
	//$words = array_unique($words);
	
	$matchAgainstExpTitle = " MATCH (nom_acteur) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (mission_acteur, sigle_acteur, nom_president_acteur, nom_directeur_acteur, ville_acteur, pays_acteur, region_acteur, projets_acteur) AGAINST ('\"$query\"'";
	/*if($query != $query2) {
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}*/
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= " nom_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR mission_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR sigle_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR nom_president_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR nom_directeur_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR ville_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR pays_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR region_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci
				OR projets_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci ";
	$occ .= "FLOOR(( LENGTH(nom_acteur) - LENGTH(REPLACE(nom_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(mission_acteur) - LENGTH(REPLACE(mission_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(sigle_acteur) - LENGTH(REPLACE(sigle_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(nom_president_acteur) - LENGTH(REPLACE(nom_president_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(nom_directeur_acteur) - LENGTH(REPLACE(nom_directeur_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(ville_acteur) - LENGTH(REPLACE(ville_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(pays_acteur) - LENGTH(REPLACE(pays_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(region_acteur) - LENGTH(REPLACE(region_acteur, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(projets_acteur) - LENGTH(REPLACE(projets_acteur, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR nom_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR mission_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR sigle_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR nom_president_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR nom_directeur_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR ville_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR pays_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR region_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci
					OR projets_acteur like CONVERT(_utf8 '%$query2%' USING utf8) COLLATE utf8_general_ci ";
		$occ .= " + FLOOR(( LENGTH(nom_acteur) - LENGTH(REPLACE(nom_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(mission_acteur) - LENGTH(REPLACE(mission_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(sigle_acteur) - LENGTH(REPLACE(sigle_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(nom_president_acteur) - LENGTH(REPLACE(nom_president_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(nom_directeur_acteur) - LENGTH(REPLACE(nom_directeur_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(ville_acteur) - LENGTH(REPLACE(ville_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(pays_acteur) - LENGTH(REPLACE(pays_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(region_acteur) - LENGTH(REPLACE(region_acteur, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(projets_acteur) - LENGTH(REPLACE(projets_acteur, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (nom_acteur) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (mission_acteur, sigle_acteur, nom_president_acteur, nom_directeur_acteur, ville_acteur, pays_acteur, region_acteur, projets_acteur) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR nom_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR mission_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR sigle_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR nom_president_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR nom_directeur_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR ville_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR pays_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR region_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci 
					OR projets_acteur like CONVERT(_utf8 '%$word%' USING utf8) COLLATE utf8_general_ci ";
		$occ .= " + FLOOR(( LENGTH(nom_acteur) - LENGTH(REPLACE(nom_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(mission_acteur) - LENGTH(REPLACE(mission_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(sigle_acteur) - LENGTH(REPLACE(sigle_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(nom_president_acteur) - LENGTH(REPLACE(nom_president_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(nom_directeur_acteur) - LENGTH(REPLACE(nom_directeur_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(ville_acteur) - LENGTH(REPLACE(ville_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(pays_acteur) - LENGTH(REPLACE(pays_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(region_acteur) - LENGTH(REPLACE(region_acteur, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(projets_acteur) - LENGTH(REPLACE(projets_acteur, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT actid, nom_acteur, type_acteur, status_acteur, "
			. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
			. " FROM ".$prefix."_annuaireacteur_acteur";
	
	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) $queryslang";
	
	$orderBy = " ORDER BY cpt DESC, nom_acteur ASC";
	
	$sql = $select.$where;
	//echo $sql;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);

	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($actid, $nom_acteur, $type_acteur, $status_acteur) = $db->sql_fetchrow($result)) {
			$pages = count(explode( "<!--pagebreak-->", $content ));
			$result2 = $db->sql_query("select type_organisme  from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
			list($type_organisme) = $db->sql_fetchrow($result2);
			$surl = "modules.php?name=becmsOrgDirectory&sop=listActeur&typid=$type_acteur";
			$furl = "modules.php?name=becmsOrgDirectory&sop=viewActeur&actid=$actid";
			
			echo "<li><a href=\"$furl\">$nom_acteur</a>";
			if ($type_organisme != "") {
				echo "<br>"._INSECTION."<a href=\"$surl\">$type_organisme</a>";
			}
//			if ($pages == 1) {
//				echo "($pages "._PAGE.")";
//			} else {
//				echo "($pages "._PAGES.")";
//			}
			if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=acteurEdit&onglet=acteur&actid=$actid&editForm=1\">"._EDIT."</a> | <a href=\"system.php?op=acteurDelete&actid=$actid&ok=0\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}
		echo "</ul>";
		//echo "</table>";
	} else {
		//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

/**
 * resultSearchActeurs
 * @param datatype paramname
 * @return
 */
function resultSearchActeursOriginal($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang,$admin;
	$accent  ="";
	$noaccent="aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby";
	$query = strtr(trim($query),$accent,$noaccent);

	$sql = "select actid, nom_acteur, type_acteur, status_acteur from ".$prefix."_annuaireacteur_acteur where ("
			."nom_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
			." OR mission_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
			." OR sigle_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
			." OR nom_president_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
			." OR nom_directeur_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
					." OR ville_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
							." OR pays_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
							." OR region_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
					." OR projets_acteur like CONVERT(_utf8 '%$query%' USING utf8) COLLATE utf8_general_ci"
					.")".$queryslang;
					$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

			$result = $db->sql_query($sql." order by actid DESC limit $min,$offset");
	/*$result = $db->sql_query("select actid, nom_acteur, type_acteur, status_acteur from ".$prefix."_annuaireacteur_acteur where ("
			."nom_acteur like '%$query%'"
			." OR mission_acteur like '%$query%'"
			." OR sigle_acteur like '%$query%'"
			." OR nom_president_acteur like '%$query%'"
			." OR nom_directeur_acteur like '%$query%'"
			." OR ville_acteur like '%$query%'"
			." OR pays_acteur like '%$query%'"
			." OR region_acteur like '%$query%'"
			." OR projets_acteur like '%$query%'"
			.") $queryslang order by actid DESC limit $min,$offset");*/
	$nrows  = $db->sql_numrows($result);

	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
	echo "<ul>";
	while(list($actid, $nom_acteur, $type_acteur, $status_acteur) = $db->sql_fetchrow($result)) {
	$pages = count(explode( "<!--pagebreak-->", $content ));
			$result2 = $db->sql_query("select type_organisme  from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
			list($type_organisme) = $db->sql_fetchrow($result2);
					$surl = "modules.php?name=becmsOrgDirectory&sop=listActeur&typid=$type_acteur";
					$furl = "modules.php?name=becmsOrgDirectory&sop=viewActeur&actid=$actid";
				
			echo "<li><a href=\"$furl\">$nom_acteur</a>";
			if ($type_organisme != "") {
			echo "<br>"._INSECTION."<a href=\"$surl\">$type_organisme</a>";
	}
	//			if ($pages == 1) {
	//				echo "($pages "._PAGE.")";
	//			} else {
	//				echo "($pages "._PAGES.")";
	//			}
		if (is_admin($admin)) {
			echo "<br>[ <a href=\"system.php?op=acteurEdit&onglet=acteur&actid=$actid&editForm=1\">"._EDIT."</a> | <a href=\"system.php?op=acteurDelete&actid=$actid&ok=0\">"._DELETE."</a> ]";
		}
		echo "</li>\n";
	}
		echo "</ul>";
		//echo "</table>";
	} else {
	//echo "<tr><td><center><font class=\"option\"><b>"._NOMATCHES."</b></font></center><br><br>";
		echo "<p><b>"._NOMATCHES."</b></p>";
		//echo "</td></tr></table>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$prev&amp;query=$query&amp;type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&amp;topic=$t&amp;min=$max&amp;query=$query&amp;type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function resultSearchAnnuaire($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual, $admin;
	
	$sql = "select Id, nom, tel from ".$prefix."_annuaire where (nom like '%$query%' OR dirigeant like '%$query%' OR description like '%$query%' OR typevente like '%$query%' OR agrotourisme like '%$query%' OR produits like '%$query%' OR adresse like '%$query%')";
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." order by nom ASC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleAnnuaire&sop=viewActeur&Id=$Id";
			echo "<li><a href=\"$furl\">$nom</a>";
			if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=S_acteurEdit&onglet=acteur&Id=$Id\">"._EDIT."</a> | <a href=\"system.php?op=S_acteurDelete&Id=$Id&ok=0\">"._DELETE."</a> ]";
			}
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&amp;author=$author&topic=$t&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&author=$author&topic=$t&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function resultSearchTypology($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual,$queryrlang,$admin;
	$accent  ="";
	$noaccent="aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby";
	$query = strtr(trim($query),$accent,$noaccent);
	
	$sql = "select id, nom, usages, pays, typologie from ".$prefix."_typologies where valide='1' AND ("
	."`usages` like '%$query%'"
	." OR `nom` like '%$query%'"
	." OR `pays` like '%$query%'"
	." OR `commune` like '%$query%'"
	." OR `typologie` like '%$query%' "
	." OR `description` like '%$query%' "
	." OR `materiaux` like '%$query%' "
	." OR `fonction` like '%$query%' "
	." OR `type` like '%$query%' "
	." OR `nom_contact` like '%$query%' "
	." OR `prenom_contact` like '%$query%' "
	." OR `type` like '%$query%' "
	.") $queryslang";
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." order by nom ASC limit $min,$offset;");
	$nrows  = $db->sql_numrows($result);
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while(list($id, $nom, $usages, $pays, $typologie) = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleTypology&sop=view_typo&id=$id";
			$surl = "modules.php?name=SimpleTypology&sop=list_typo_cat&typologie=".urlencode($typologie);
			echo "<li><a href=\"$furl\">$nom</a>";
			if ($typologie != "") {
				echo "<br>"._INTYPO."<a href=\"$surl\">$typologie</a>";
			}
			/*if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=acteurEdit&onglet=acteur&actid=$actid&editForm=1\">"._EDIT."</a> | <a href=\"system.php?op=acteurDelete&actid=$actid&ok=0\">"._DELETE."</a> ]";
			}*/
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function removeSearch($tab_exp, $tab_words) {
	$tab_result = array();
	foreach ($tab_words as $word) {
		foreach($tab_exp as $ele) {
			if(preg_match("/^$word/", $ele)) {
				$tab_result[] = $word;
			}
		}
	}
	$tab_result = array_diff($tab_words, $tab_result);
	return $tab_result;
}

function resultSearchAdherents($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual, $admin,$currentlang;
	
	require_once("includes/truncate_string.php");
		
	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");
	
	$weightExpTitle = "150";
	$weightExpContent = "100";
	$weightWordTitle = "15";
	$weightWordContent = "10";
	$weightOcc = "0.01";
	
	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);
	
	$words = array_merge($words, $words2);
	$words = array_unique($words);
	
	/********************************************************************************************/
	/** Code commant pour faire une recherche tenant egalement compte du nom des responsables **/
	/********************************************************************************************/
	/*$matchAgainstExpTitle = " MATCH (societe, keywords) AGAINST ('$query'";
	$matchAgainstExpContent = " MATCH (commune, responsable, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('$query'";
	if($query != $query2) {
		$matchAgainstExpTitle .= " '$query2'";
		$matchAgainstExpContent .= " '$query2'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "societe like '%$query%' OR commune like '%$query%' OR responsable like '%$query%' OR description_$currentlang like '%$query%' OR services_$currentlang like '%$query%' OR activites_$currentlang like '%$query%' OR keywords like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query', '')) ) / (LENGTH('$query')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR societe like '%$query2%' OR commune like '%$query2%' OR responsable like '%$query2%' OR description_$currentlang like '%$query2%' OR services_$currentlang like '%$query2%' OR activites_$currentlang like '%$query2%' OR keywords like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
			+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (societe, keywords) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (commune, responsable, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('";
	
	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR societe like '%$word%' OR commune like '%$word%' OR responsable like '%$word%' OR description_$currentlang like '%$word%' OR services_$currentlang like '%$word%' OR activites_$currentlang like '%$word%' OR keywords like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(responsable) - LENGTH(REPLACE(responsable, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$word', '')) ) / (LENGTH('$word')))
			+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}*/
	
	/********************************************************************************************/
	
	$matchAgainstExpTitle = " MATCH (societe, keywords) AGAINST ('\"$query\"'";
	$matchAgainstExpContent = " MATCH (commune, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('\"$query\"'";
	if($query != $query2) {
		// Neutralis pour eviter d'introduire des erreurs de recherche dues au HTML
		//$matchAgainstExpTitle .= " '\"$query2\"'";
		$matchAgainstExpContent .= " '\"$query2\"'";
	}
	$matchAgainstExpTitle .= " IN BOOLEAN MODE)";
	$matchAgainstExpContent .= " IN BOOLEAN MODE)";
	
	$likes = " (";
	$occ = " (";
	
	$likes .= "societe like '%$query%' 
				OR commune like '%$query%' 
				OR description_$currentlang like '%$query%' 
				OR services_$currentlang like '%$query%' 
				OR activites_$currentlang like '%$query%' 
				OR keywords like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query', '')) ) / (LENGTH('$query')))";
	
	if($query != $query2) {
		$likes .= " OR societe like '%$query2%' 
					OR commune like '%$query2%' 
					OR description_$currentlang like '%$query2%' 
					OR services_$currentlang like '%$query2%' 
					OR activites_$currentlang like '%$query2%' 
					OR keywords like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query2', '')) ) / (LENGTH('$query2')))";
	}
	
	$matchAgainstWorldTitle = " MATCH (societe, keywords) AGAINST ('";
	$matchAgainstWorldContent = " MATCH (commune, description_$currentlang, services_$currentlang, activites_$currentlang) AGAINST ('";
	
	$tab_result = array();
	$nbWord = 0;
	foreach ($words as $word) {
		if(preg_match('/;/', $word)) {
			$tab = explode(';', $word);
			$tab_result = array_merge($tab_result, removeSearch($words, $tab));
		}
		$matchAgainstWorldTitle .= " $word*";
		$matchAgainstWorldContent .= " $word*";
		$likes .= " OR societe like '%$word%' 
					OR commune like '%$word%' 
					OR description_$currentlang like '%$word%' 
					OR services_$currentlang like '%$word%' 
					OR activites_$currentlang like '%$word%' 
					OR keywords like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}
	
	$tab_result = array_unique($tab_result);
	
	foreach ($tab_result as $elt) {
		$matchAgainstWorldTitle .= " -$elt*";
		$matchAgainstWorldContent .= " -$elt*";
	}
	
	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorldTitle .= "' IN BOOLEAN MODE)";
	$matchAgainstWorldContent .= "' IN BOOLEAN MODE)";
	
	$select = "SELECT ".$prefix."_adherents.id, `societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , "
		. "(($matchAgainstExpTitle * $weightExpTitle) + ($matchAgainstExpContent * $weightExpContent) + ($matchAgainstWorldTitle * $weightWordTitle) + ($matchAgainstWorldContent * $weightWordContent) + (($occ / $nbWord) * $weightOcc)) AS cpt "
		. " FROM ".$prefix."_adherents";

	$where = " WHERE ($matchAgainstExpTitle OR $matchAgainstExpContent OR $matchAgainstWorldTitle OR $matchAgainstWorldContent OR $likes) AND valide='1'";

	$orderBy = " ORDER BY cpt DESC, societe ASC";

	$sql = $select.$where;
	//echo $sql."$orderBy limit $min,$offset";

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while($ligne = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleAdherents&op=showoneadh&id=".$ligne["id"];
			echo "<li><a href=\"$furl\">".$ligne["societe"]."</a>";
			echo "<br />".truncate_string($ligne["description_".$currentlang],"200");
			/*if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=S_acteurEdit&onglet=acteur&Id=$Id\">"._EDIT."</a> | <a href=\"system.php?op=S_acteurDelete&Id=$Id&ok=0\">"._DELETE."</a> ]";
			}*/
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function resultSearchAdherentsOld($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual, $admin,$currentlang;

	require_once("includes/truncate_string.php");

	$query = trim($query);
	$query2 = htmlentities($query, ENT_NOQUOTES, "ISO-8859-1");

	$weightExp = "10";
	$weightWord = "0.5";
	$weightOcc = "0.1";

	$words = explode(" ", $query);
	$words2 = explode(" ", $query2);

	$words = array_merge($words, $words2);
	$words = array_unique($words);

	$matchAgainstExp = ' MATCH (societe, commune, description_'.$currentlang.', services_'.$currentlang.', activites_'.$currentlang.', keywords) AGAINST (\'"'.$query.'"';
	if($query != $query2) {
		$matchAgainstExp .= ' "'.$query2.'"';
	}
	$matchAgainstExp .= "' IN BOOLEAN MODE)";

	$matchAgainstWorld = " MATCH (societe, commune, description_$currentlang, services_$currentlang, activites_$currentlang, keywords) AGAINST ('";
	$likes = " (";
	$occ = " (";

	$likes .= "societe like '%$query%' OR commune like '%$query%' OR description_$currentlang like '%$query%' OR services_$currentlang like '%$query%' OR activites_$currentlang like '%$query%' OR keywords like '%$query%' ";
	$occ .= "FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query', '')) ) / (LENGTH('$query')))
	+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query', '')) ) / (LENGTH('$query')))";

	if($query != $query2) {
		$likes .= " OR societe like '%$query2%' OR commune like '%$query2%' OR description_$currentlang like '%$query2%' OR services_$currentlang like '%$query2%' OR activites_$currentlang like '%$query2%' OR keywords like '%$query2%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$query2', '')) ) / (LENGTH('$query2')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$query2', '')) ) / (LENGTH('$query2')))";
	}

	$nbWord = 0;
	foreach ($words as $word) {
		$matchAgainstWorld .= " $word*";
		$likes .= " OR societe like '%$word%' OR commune like '%$word%' OR description_$currentlang like '%$word%' OR services_$currentlang like '%$word%' OR activites_$currentlang like '%$word%' OR keywords like '%$word%' ";
		$occ .= " + FLOOR(( LENGTH(societe) - LENGTH(REPLACE(societe, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(commune) - LENGTH(REPLACE(commune, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(description_$currentlang) - LENGTH(REPLACE(description_$currentlang, '$$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(services_$currentlang) - LENGTH(REPLACE(services_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(activites_$currentlang) - LENGTH(REPLACE(activites_$currentlang, '$word', '')) ) / (LENGTH('$word')))
		+ FLOOR(( LENGTH(keywords) - LENGTH(REPLACE(keywords, '$word', '')) ) / (LENGTH('$word')))";
		$nbWord++;
	}

	$occ .= " )";
	$likes .= " )";
	$matchAgainstWorld .= "' IN BOOLEAN MODE)";

	$select = "SELECT ".$prefix."_adherents.id, `societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , "
			. "(($matchAgainstExp * $weightExp) + ($matchAgainstWorld * $weightWord) + (($occ / $nbWord) * $weightOcc)) AS cpt "
					. " FROM ".$prefix."_adherents";

	$where = " WHERE ($matchAgainstExp OR $matchAgainstWorld OR $likes) AND valide='1'";

	$orderBy = " ORDER BY cpt DESC, societe ASC";

	$sql = $select.$where;
	//echo $sql;

	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$result = $db->sql_query($sql."$orderBy limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while($ligne = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleAdherents&op=showoneadh&id=".$ligne["id"];
			echo "<li><a href=\"$furl\">".$ligne["societe"]."</a>";
			echo "<br />".truncate_string($ligne["description_".$currentlang],"200");
			/*if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=S_acteurEdit&onglet=acteur&Id=$Id\">"._EDIT."</a> | <a href=\"system.php?op=S_acteurDelete&Id=$Id&ok=0\">"._DELETE."</a> ]";
		}*/
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function resultSearchAdherentsOriginal($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual, $admin,$currentlang;
	$query2 = htmlentities($query,ENT_NOQUOTES, "ISO-8859-1");

	require_once("includes/truncate_string.php");

	$sql = "SELECT ".$prefix."_adherents.id, `societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` ";
	$sql .= " FROM ".$prefix."_adherents";
	$sql .= " WHERE (societe like '%$query%' OR commune like '%$query%' OR description_$currentlang like '%$query%' OR services_$currentlang like '%$query%' OR activites_$currentlang like '%$query%'";
	$sql .= " OR societe like '%$query2%' OR commune like '%$query2%' OR description_$currentlang like '%$query2%' OR services_$currentlang like '%$query2%' OR activites_$currentlang like '%$query2%'";
	$sql .= " OR keywords like '%$query%' OR keywords like '%$query2%')";
	$sql .= " AND valide='1'";
	//echo $sql;
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);

	$result = $db->sql_query($sql." ORDER BY classe DESC, societe ASC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while($ligne = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleAdherents&op=showoneadh&id=".$ligne["id"];
			echo "<li><a href=\"$furl\">".$ligne["societe"]."</a>";
			echo "<br />".truncate_string($ligne["description_".$currentlang],"200");
			/*if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=S_acteurEdit&onglet=acteur&Id=$Id\">"._EDIT."</a> | <a href=\"system.php?op=S_acteurDelete&Id=$Id&ok=0\">"._DELETE."</a> ]";
			}*/
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function resultSearchProfil($type, $query,$max,$min,$offset){
	global $prefix, $db, $multilingual, $admin,$currentlang, $rubpagesmillesimes;
	$query2 = htmlentities($query,ENT_NOQUOTES, "ISO-8859-1");
	
	require_once("includes/truncate_string.php");
   	
   	$sql = "SELECT ".$prefix."_profil_docs.id, ".$prefix."_profil_docs.titre, ".$prefix."_profil_millesime.id_page, ".$prefix."_profil_millesime.id as id_millesime, ".$prefix."_profil_millesime.millesime, ".$prefix."_seccont.content";
	$sql .= " FROM ".$prefix."_profil_millesime";
	$sql .= " INNER JOIN ".$prefix."_profil_docs ON ".$prefix."_profil_docs.id=".$prefix."_profil_millesime.id_doc";
	$sql .= " INNER JOIN ".$prefix."_seccont ON ".$prefix."_seccont.artid=".$prefix."_profil_millesime.id_page";
	$sql .= " WHERE (".$prefix."_seccont.content like '%$query%' OR ".$prefix."_profil_docs.titre like '%$query%' OR ".$prefix."_profil_millesime.millesime like '%$query%'";
	$sql .= " OR ".$prefix."_seccont.content like '%$query2%' OR ".$prefix."_profil_docs.titre like '%$query2%' OR ".$prefix."_profil_millesime.millesime like '%$query2%')";
	//$sql .= " AND ".$prefix."_seccont.status='P' AND ".$prefix."_seccont.secid='".$rubpagesmillesimes."'";
	$sql .= " AND ".$prefix."_seccont.status='P'";
	
	$nbreresults = getNumResults($sql." limit $min,".($offset+1));
	$nbretotal = getNumResults($sql);
	
	$result = $db->sql_query($sql." ORDER BY ".$prefix."_profil_docs.titre ASC, ".$prefix."_profil_millesime.millesime ASC limit $min,$offset");
	$nrows  = $db->sql_numrows($result);
	//echo "<br><hr noshade size=\"1\"><center><b>"._SEARCHRESULTS."</b></center><br><br>";
	//echo "<table width=\"99%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
	echo "<br /><h1>"._SEARCHRESULTS." ($nbretotal)"."</h1>";
	if ($nrows>0) {
		echo "<ul>";
		while($ligne = $db->sql_fetchrow($result)) {
			$furl = "modules.php?name=SimpleProfil&op=showonedoc&id=".$ligne["id"]."&millesime=".$ligne["id_millesime"];
			echo "<li><a href=\"$furl\">".$ligne["titre"]." (".$ligne["millesime"].")"."</a>";
			echo "<br />".truncate_string(strip_tags($ligne["content"]),"200");
			/*if (is_admin($admin)) {
				echo "<br>[ <a href=\"system.php?op=S_acteurEdit&onglet=acteur&Id=$Id\">"._EDIT."</a> | <a href=\"system.php?op=S_acteurDelete&Id=$Id&ok=0\">"._DELETE."</a> ]";
			}*/
			echo "</li>\n";
		}
		echo "</ul>";
	}
	else {
		echo "<p><b>"._NOMATCHES."</b></p>";
	}

	echo "<div class=\"prevnext\">";
	$prev=$min-$offset;
	if ($prev>=0) {
		print "<a href=\"modules.php?name=Search&min=$prev&query=$query&type=$type\">";
		print "$min "._PREVMATCHES."</a>&nbsp;&nbsp;";
	}

	$next=$min+$offset;
	if ($nbreresults > $offset) {
		print "<a href=\"modules.php?name=Search&min=$max&query=$query&type=$type\">";
		print _NEXTMATCHES."</a>";
	}
	echo "</div>";
}

function searchHeaderNews($author, $topic ,$type, $query, $days, $min, $max,$category){
	global $prefix, $db, $multilingual,$queryrlang, $articlecomm ;

	if ($topic>0) {
		$result = $db->sql_query("select topicimage, topictext from ".$prefix."_topics where topicid=$topic");
		list($topicimage, $topictext) = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
	} else {
		$topictext = ""._SEARCHSECTIONS."";
		$topicimage = "AllTopics.gif";
	}
	echo "<h1>$topictext</h1>";
	$styleopts = "";
	
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"POST\">"
	."<p style=\"text-align: center;\">"
	._SEARCH_CRITERIA
	."<input size=\"25\" type=\"text\" name=\"query\" value=\"$query\" id=\"zquery\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\"></p>";

	echo "<div class=\"search_options\">";
	echo "<div id=\"formframe\" class=\"formiframe\"".$styleopts.">\n";
	/************ Topic Selection ****************/
	echo '<input type="hidden" name="topic" value="'.$topic.'">';
	/************ Category Selection ****************/
	echo '<input type="hidden" name="category" value="0">';
	/************ Authors Selection ******************/
	echo '<input type="hidden" name="author" value="no">';
	/**************  Date Selection ***************/
	echo '<input type="hidden" name="days" value="0">';
	/**************  Search Selection ***************/
	echo '<input type="hidden" name="type" value="currentstoriessonly">';
	
	echo "</p>";
	echo "</div>";


	if ($type == "stories") {
		$sel1 = "checked";
	} elseif ($type == "comments") {
		$sel2 = "checked";
	} elseif (($type == "sections") OR ($type == "")) {
		$sel3 = "checked";
	} elseif ($type == "users") {
		$sel4 = "checked";
	} elseif ($type == "reviews") {
		$sel5 = "checked";
	} elseif ($type == "acteurs") {
		$sel6 = "checked";
	} elseif ($type == "annuaire") {
		$sel7 = "checked";
	} elseif ($type == "typology") {
		$sel8 = "checked";
	} elseif ($type == "adherents") {
		$sel9 = "checked";
	} elseif ($type == "profil") {
		$sel10 = "checked";
	} elseif ($type == "agenda") {
		$sel11 = "checked";
	}
	

	$num_sec = $db->sql_numrows($db->sql_query("select * from ".$prefix."_sections"));
	$num_rev = $db->sql_numrows($db->sql_query("select * from ".$prefix."_reviews"));

	echo "</div>";
	echo "</form>";
	echo "</div>";
	echo "</fieldset>";
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/


switch($op) {

	case "comments":
		break;

	default:
		mainsearch($author, $category, $topic, $type, $query, $days, $min, $max, $secid, $secid_no);
		break;
}
?>