<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                               */                                           
/*                                                                      */
/*   																	*/
/* Balsite QUIZ Module . Stephan ACQUATELLA 2005				     		*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied !!"); }

//$module_name = "Quiz"; // If you change the directory of the module, change it

if (checkModuleRight("Quiz")) {
setPath(_TXT_Modules,0);
setPath(_QUIZ_ADM,1,"system.php?op=QuizAdmin");
$hlpfile = "manual/faqs.html";
/************************** Onglet definition ***********************/
$ongletDef=array("quiz"=> array( "text"=>_ACTIVEQUIZ,
                                   "url"=>"system.php?op=QuizAdmin"),
                 "question"=> array( "text"=>_QUESTION,
                                   "url"=>"system.php?op=QuizAdmin&act=QuizQuestion&onglet=question"),   
                 "category"=> array( "text"=>_CATEGORY,
                                   "url"=>"system.php?op=QuizAdmin&onglet=category")  ,        
                 "stat"=> array( "text"=>_QUIZSTAT,
                                   "url"=>"system.php?op=QuizList") 
                                   );



/*********************************************************/
/* Quiz Admin Function                                   */
/*********************************************************/

/**
 * QuizAdmin()
 * Main quiz admin methode
 * @param
 * @return
 */
function QuizAdmin($onglet){
    global $db, $language, $hlpfile, $admin, $module_name, $prefix, $ongletDef, $Default_Skin;
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
	// if not arguments quiz is chosen
	if ($onglet=="") $onglet="quiz"; 
	$skinPath="system/skins/$Default_Skin"; 
	switch ($onglet) {
	/* --------------------- List of quiz--------------------------------------------*/
	case "quiz":
	
	$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif","comment"=>_PREVIEW, "status"=>"ON"),
				  "edit"=> array( "text"=>_QUIZMODIFY,"icon"=>"edit_16x16.png", "comment"=>_QUIZMODIFY, "status"=>"ON"),
  			      "addquery"=> array( "text"=>_QUIZADDQUESTION,"icon"=>"move_16x16.png","comment"=>_QUIZADDQUESTION,"status"=>"ON"),
  			      "delete"=> array( "text"=>_QUIZDELETE,"icon"=>"delete_16x16.png","comment"=>_QUIZDELETE,"status"=>"ON"));
     OpenOngletTable();
     displayOngletBar("quiz",_ACTIVEQUIZ,$ongletDef);
     
     echo "<table class=lisTable><tr class=systemTabHeader>"
	."<td class=systemTabHeader align=\"left\" width=\"10%\">"._NUMBER."</td>"
	."<td class=systemTabHeader align=\"left\" width=\"45%\">"._QUIZTITLE."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"10%\">"._CATEGORY."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"5%\">"._QUIZIMG."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"10%\">"._QUIZDATE."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"20%\">"._FUNCTIONS."</td></tr>";
       
      $result = $db->sql_query("SELECT
        $prefix"._quiz_admin.".quizID,
        $prefix"._quiz_admin.".quizTitle,
        $prefix"._quiz_admin.".timeStamp,
        $prefix"._quiz_admin.".comment,
        $prefix"._quiz_admin.".image,
        $prefix"._quiz_categories.".name
        FROM $prefix"._quiz_admin.", $prefix"._quiz_categories."
        WHERE $prefix"._quiz_admin.".cid = $prefix"._quiz_categories.".cid
        ORDER BY quizID");

        $pos=0;
          while(list($qid, $quizTitle,$quizdate,$quizcomment,$quizimg,$category) = $db->sql_fetchrow($result)) {
          if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
          if ($quizimg==""){$imgicone="<img src=\"$skinPath/icon_nochecked.png\" border=0>";} else { $imgicone="<img src=\"$skinPath/tick.png\" border=0>";} 
	      $myicon="<img src=\"$skinPath/edit.png\" height=16 border=0>";	
          $popupinfo="onmouseover=\"return overlib('<b>Comments:</b><br><br>$quizcomment', RIGHT);\" onmouseout=\"nd();\"";		
          $link_question="<a href=\"system.php?op=QuizAdmin&act=QuizQuestion&onglet=question&qid=$qid\" $popupinfo>";
         
          echo "<tr class=\"$thestyle\">"; 
          echo "<td align=\"left\" >$link_question $myicon Quiz $qid</a></td>"	    
	    	 ."<td align=\"left\" >$quizTitle</td>"
	    	 ."<td align=\"center\" >$category</td>"
	    	 ."<td align=\"center\" >$imgicone</td>"
	    	 ."<td align=\"center\" >".formatTimestamp($quizdate)."</td>"
        	 ."<td align=\"center\" >";
        	    $barDef["view"]["url"]="modules.php?op=modload&name=Quiz&file=index&qid=$qid";
        	 	$barDef["edit"]["url"]="system.php?op=QuizAdmin&act=QuizModify&qid=$qid&editForm=1";
				$barDef["addquery"]["url"]="system.php?op=QuizAdmin&act=QuizAddQuestion&qid=$qid";
				$barDef["delete"]["url"]="system.php?op=QuizAdmin&act=removePostedQuiz&qid=$qid";
				displayActionBar("add","Bar d'action",$barDef,"img");
        	 echo "</td></tr>";
            // ."[<a href=\"system.php?op=QuizAdmin&act=QuizModify&qid=$qid&editForm=1\"> "._QUIZMODIFY." </a>] | "
            // ."[<a href=\"system.php?op=QuizAdmin&act=removePostedQuiz&qid=$qid\"> "._QUIZDELETE." </a>] | "
            // ."[<a href=\"system.php?op=QuizAdmin&act=QuizAddQuestion&qid=$qid\">"._QUIZADDQUESTION." </a>]</td></tr>";
         $pos++;
          } // end while
         echo "</table>\n";  
          
      $result = $db->sql_query("select quizID, quizTitle from $prefix"._quiz_admin."");
      $result2 = $db->sql_query("select quizID, quizTitle from $prefix"._quiz_admin."");
    if ($db->sql_numrows($result) > 1) {
	  OpenOngletTable();
	  echo "<center><b>"._MOVEQUESTIONS."</b><br><br>"
	    ."<form action=\"system.php?op=QuizAdmin&act=MoveQuestions&qid=$qid&new_qid=$new_qid\" method=\"post\">"
	    .""._MOVEALLQUESTIONSFROM.": <select name=\"qid\">";
      while(list($qid, $title) = $db->sql_fetchrow($result)) {
	    	echo "<option name=\"qid\" value=\"$qid\">$title";
          }
	  echo "</select> "._TO.": <select name=\"new_qid\">";
          while(list($qid, $title) = $db->sql_fetchrow($result2)) {
	    		echo "<option name=\"new_qid\" value=\"$qid\">$title";
          }    
	  echo "</select>&nbsp;&nbsp;"
	    ."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	    ."</form></center>";
	  CloseOngletTable();
      }      
   OpenOngletTable();
   echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
   echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] "._QUIZNEW."</a>";   
   echo QuizEdit($qid,0,1);
   CloseOngletTable();
   CloseOngletTable();
   break;
    // -------------------------------------- Categories -----------------------------
    case "category":
    $barDef=array("edit"=> array( "text"=>_QUIZMODIFYCAT,"icon"=>"edit_16x16.png", "comment"=>_QUIZMODIFYCAT, "status"=>"ON"),  			     
  			      "delete"=> array( "text"=>_QUIZDELCAT,"icon"=>"delete_16x16.png","comment"=>_QUIZDELCAT,"status"=>"ON"));
     OpenOngletTable();
     displayOngletBar("$onglet",_QUIZADDCAT,$ongletDef);
   
    $result = $db->sql_query("select cid, name from $prefix"._quiz_categories."");
      
    echo "<table class=lisTable><tr class=systemTabHeader>"
	."<td class=systemTabHeader align=\"left\" width=\"80%\">"._QUIZCAT."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"20%\">"._FUNCTIONS."</td></tr>";
      
      while(list($cid, $name) = $db->sql_fetchrow($result)) {      	
      	 if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
	      $myicon="<img src=\"images/smallicone/edit.png\" height=16 border=0>";
	       echo "<tr class=\"$thestyle\">"; 
           echo "<td align=\"left\" >$name</td>"
           ."<td align=\"center\">";
           $barDef["edit"]["url"]="system.php?op=QuizAdmin&act=QuizModifyCategory&cid=$cid";			
		   $barDef["delete"]["url"]="op=QuizAdmin&act=QuizDelCategory&cid=$cid";
		   displayActionBar("add","Bar d'action",$barDef,"img");
           echo "</td></tr>";
             //."[<a href=\"system.php?op=QuizAdmin&act=QuizModifyCategory&cid=$cid\"> "._QUIZMODIFYCAT." </a>] | "
             //."[<a href=\"system.php?op=QuizAdmin&act=QuizDelCategory&cid=$cid\"> "._QUIZDELCAT." </a>] </td></tr> ";
         $pos++;
          } // end while
         echo "</table>\n";  
    
   OpenOngletTable();
   echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
   echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] "._QUIZADDCAT."</a>";
	    
    echo "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n";
    echo "<center><font class=\"option\"><b>"._QUIZADDCAT."</b></font></center><br>";
    echo "\n<center><form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='createPostedQuizCategory'>";
    echo "<font class=catdesc>";
    echo "<table class=systemTab>";
    echo "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><input type='text' class=textbox name='CatName' size=30></td>";
    echo "<tr><td><font class=catdesc>"._QUIZCOMMENT."</font></td><td><input type='text' class=textbox name='CatComment' size=30><font class=catdesc> ("._QUIZHELPOPTION.")</font></td>";
    echo "<tr><td><font class=catdesc>"._QUIZCATIMAGE."</font></td><td><input type='text' class=textbox name='CatImage' size=30><font class=catdesc> ("._QUIZHELPOPTION.")</font></td>";
    echo "<td><font class=catdesc><input type='submit' class=button value='"._QUIZADD."'></font></td></tr></table>";
    echo "</form></center>";
    CloseOngletTable();
    echo "</div>";
    CloseOngletTable();
    break;
 }// end swith
    include("system/footer_system.php");
}

/**
 * QuizQuestion
 * 
 * 
 */
function QuizQuestion($qid){
global $db, $language, $hlpfile, $admin, $qid, $number, $prefix,$ongletDef;
if (isset($qid)) {
	$quizName=getQuizName($qid);
	setPath($quizName,2);
} 
  include("system/header_system.php");
 	GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("question",_QUIZQUESTIONS." $quizName",$ongletDef);
    
    $barDef=array("edit"=> array( "text"=>_QUIZMODIFY,"icon"=>"edit_16x16.png", "comment"=>_QUIZMODIFY, "status"=>"ON"),
  			      "move"=> array( "text"=>_QUIZMOVEQUESTION,"icon"=>"move_16x16.png","comment"=>_QUIZMOVEQUESTION,"status"=>"ON"),
  			      "copy"=> array( "text"=>_QUIZCOPYQUESTION,"icon"=>"move_16x16.png","comment"=>_QUIZCOPYQUESTION,"status"=>"ON"),
  			      "delete"=> array( "text"=>_QUIZDELETE,"icon"=>"delete_16x16.png","comment"=>_QUIZDELETE,"status"=>"ON"));
    
    if (isset($qid)) {$where="WHERE qid=$qid";} else {$where="";}
    
     echo "<table class=lisTable><tr class=systemTabHeader>"
	."<td class=systemTabHeader align=\"left\" width=\"40%\">"._QUIZQUESTION."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"20%\">"._QUIZTITLE."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"20%\">"._DATE."</td>"
	."<td class=systemTabHeader align=\"center\" width=\"20%\">"._FUNCTIONS."</td></tr>";
    
    $pos=0;
    $result = $db->sql_query("SELECT pollID, pollTitle, timeStamp, qid FROM $prefix"._quiz_desc." $where");
    while(list($pollID, $pollTitle, $timeStamp, $qid) = $db->sql_fetchrow($result))
    {
    	$myresult = $db->sql_query("select quizTitle from ".$prefix._quiz_admin." where quizID='$qid'");
		list($quizTitle) = $db->sql_fetchrow($myresult);
    	 if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
	      $myicon="<img src=\"images/smallicone/edit.png\" height=16 border=0>";	
	      
        echo "<tr class=\"$thestyle\"><td align=\"left\">$myicon $pollTitle</td>";
        echo "<td align=\"center\" >$quizTitle</td>";
        echo "<td align=\"center\" >".formatTimestamp($timeStamp)."</td>";
        echo "<td align=\"center\" >";
			$barDef["edit"]["url"]="system.php?op=QuizAdmin&act=QuizModifyQuestion&pid=$pollID&qid=$qid";
			$barDef["move"]["url"]="system.php?op=QuizAdmin&act=QuizMoveQuestion&pid=$pollID&qid=$qid";
			$barDef["copy"]["url"]="system.php?op=QuizAdmin&act=QuizCopyQuestion&pid=$pollID";			
		    $barDef["delete"]["url"]="system.php?op=QuizAdmin&act=QuizDelQuestion&pid=$pollID&qid=$qid";
		   displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
       //echo "<a href=\"system.php?op=QuizAdmin&act=QuizModifyQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMODIFY." ]</a> | ";
       // echo "<a href=\"system.php?op=QuizAdmin&act=QuizDelQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZDELETE." ]</a> |";
       // echo "<a href=\"system.php?op=QuizAdmin&act=QuizMoveQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMOVEQUESTION." ] </a> |";
       // echo "<a href=\"system.php?op=QuizAdmin&act=QuizCopyQuestion&pid=$pollID\"> [ "._QUIZCOPYQUESTION." ]</a></td></tr>";
       
        $pos++;
        }
    echo "</table>";    
    CloseOngletTable();
  include("system/footer_system.php");
    
}
/*********************************************************/
/* Quiz Add Functions                                    */
/*********************************************************/
/**
 * QuizAddQuestion()
 * Quiz Add Functions   
 * @param 
 * @return
 */
function QuizAddQuestion($qid)
{
    global $db, $language, $hlpfile, $admin, $number, $prefix,$ongletDef;
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
   
    OpenOngletTable();
    displayOngletBar("question",_QUIZADDQUESTION,$ongletDef);
    
    if($number<=1) { 
    OpenOngletTable(); 
    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n";
    echo "<center>\n<form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='createPostedQuizQuestion'>";
    echo "<INPUT type='hidden' name='qid' value=\"$qid\">";
    echo "<table class=systemTab><tr><td><font class=catdesc>"._QUIZQUESTIONTITLE."</font>: <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"\"><br><br><br></td></tr></table>"
    ."<table class=systemTab><tr><td>";
    echo "<tr><td><font class=catdesc>"._QUIZCOEF."</td><td colspan=3><input type='text' class=textbox name='coef' value='1' size=3></font></td></tr>";
    echo "<tr><td><font class=catdesc>"._QUIZIMAGE."</td><td colspan=3><input type='text' id=\"myfield\" class=textbox name='image' size=50><input type=\"button\" id=\"ins_map\" value=\"Parcourir ...\" Onclick=\"javascript:insert('download')\"></font></td></tr>";
        echo "<tr><td colspan=2><font class=catdesc>"._QUIZQUESTION."</font></td><td><font class=catdesc>"._QUIZANSWER."</font></td></tr>";
    for($i = 1; $i <= 10; $i++)
    {
        echo "<tr><td><font class=catdesc>"._OPTION." $i:</font></td>";
        echo "<td><input type=\"text\" class=textbox name=\"optionText[$i]\" size=\"50\" maxlength=\"250\"></td>";
	    echo "<td><font class=catdesc><input type=\"checkbox\" class=textbox name=\"optionSort[$i]\" value=\"$i\" $sel> $optionText<br></font></td></tr>\n";
	    echo "<tr><td><font class=catdesc>"._OPTION." $i "._QUIZIMAGE."</font></td>";
		echo "<td><input type='text' id=\"myfield_$i\" class=textbox name='optionImg[$i]' size=50></td><td><img src=\"images/rte/icon_ins_image_down.gif\" id=\"ins_map\" Onclick=\"javascript:insert('download', 'myfield_$i')\"></font></td></tr>";
    }
    echo "</table><br><br>"
    ."<table class=systemTab>"
    ."<tr><td><font class=catdesc>"._QUIZCOMMENT." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"comment\"></textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFBADANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"bad\"></textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFGOODANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"good\"></textarea></td></tr>";
    echo "</table><br><br><input type=\"submit\" class=button value=\""._QUIZADDQUESTION."\">"
        ."</form></center>";
    CloseOngletTable();
    } else {
    echo "\n<form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='createPostedQuizQuestion'>";
    echo "<INPUT type='hidden' name='qid' value=\"$qid\">";
    
    for($t=1;$t<=$number;$t++) {
    OpenOngletTable();    
    echo "<class=systemTab><tr><td><font class=catdesc>"._QUIZQUESTIONTITLE."</font>: <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"\"><br><br><br></td></tr></table>"
    ."<table class=systemTab><tr><td>";
    echo "<tr><td><font class=catdesc>"._QUIZCOEF."</td><td colspan=3><input type='text' class=textbox name='coef' value='1' size=3></font></td></tr>";
    echo "<tr><td><font class=catdesc>"._QUIZIMAGE."</td><td colspan=3><input type='text' class=textbox name='image' size=50></font></td></tr>";
        echo "<tr><td colspan=2><font class=catdesc>"._QUIZQUESTION."</font></td><td><font class=catdesc>"._QUIZANSWER."</font></td></tr>";
    for($i = 1; $i <= 10; $i++)
    {
        echo "<tr><td><font class=catdesc>"._OPTION." $i:</font></td>";
		echo "<td><input type=\"text\" class=textbox name=\"optionText[$i]\" size=\"50\" maxlength=\"250\"></td>";
		echo "<td><font class=catdesc><input type=\"checkbox\" class=textbox name=\"optionSort[$i]\" value=\"$i\" $sel> $optionText<br></font></td></tr>\n";
		echo "<tr><td><font class=catdesc>"._OPTION." $i "._QUIZIMAGE."</font></td>";
		echo "<td><input type='text' id=\"myfield_$i\" class=textbox name='optionImg[$i]' size=50></td><td><img src=\"images/rte/icon_ins_image_down.gif\" id=\"ins_map\" Onclick=\"javascript:insert('download', 'myfield_$i')\"></font></td></tr>";
    }
    echo "</table><br><br>"
    ."<table class=systemTab>"
    ."<tr><td><font class=catdesc>"._QUIZCOMMENT." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"comment\"></textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFBADANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"bad\"></textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFGOODANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"60\" rows=\"2\" name=\"good\"></textarea></td></tr>";
    echo "</table><br><br>";
    CloseOngletTable();
    echo "<p><p>";
    }
    echo "<input type=\"submit\" class=button value=\""._QUIZADDQUESTIONS."\">"
        ."</form>";
    }
    CloseOngletTable();
    include("system/footer_system.php");
}
/**
 * QuizAdd()
 * @param $editForm if value= 1 form is opened for edition, if value =0 creation mode. Default value 0.
 * @param $asHtml if value=0 the form is display by the function. If value =1 metho retrun html code. Default value is 0.
 * @return html code of the form : only if asHtml parm is 1.
 */
function QuizEdit($qid,$editForm=0, $asHtml=0)
{
    global $db, $language, $hlpfile, $admin,$prefix,$ongletDef;
    
    if ($editForm){
	 // get information about Quiz
     $result = $db->sql_query("select quizTitle, comment, image, cid from $prefix"._quiz_admin." where quizID='$qid'");
    
     if (!$result) {
     	print_r($db->sql_error());
    	die('Invalid query');
	 }
	 list($quizTitle, $comment, $image, $cid) = $db->sql_fetchrow($result);
	}
    if ($editForm==0) {
          $qid=""; // force id to null
          $action="createPostedQuiz";
    }else{
          $action="modifyPostedQuiz";
     }
	 $formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
      . "\n<center><form method='post'action='system.php?op=QuizAdmin'>"
      . "<INPUT type='hidden' name='act' value='$action'>"
      . "<INPUT type='hidden' name='qid' value='$qid'>"
      . "<font class=catdesc>"
      . "<table class=systemTab>"
 	  . "<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n"
      . "<tr><td><font class=catdesc>"._QUIZTITLE."</font></td><td><input type='text' class=textbox name='quizTitle' value=\"$quizTitle\" size=30><font class=catdesc></font></td></tr>"
      . "<tr><td><font class=catdesc>"._QUIZIMAGE."</font></td><td><input type='text' id=\"myfield\" class=textbox name='image' value=\"$image\" size=30><input type=\"button\" id=\"ins_map\" value=\"Parcourir ...\" Onclick=\"javascript:insert('download')\"><br><font class=catdesc>"._QUIZHELPIMAGE."</font></td></tr>"
      . "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><font class=catdesc><SELECT class=textbox name=\"cid\">";
      $result = $db->sql_query("select cid, name from $prefix"._quiz_categories."");
      while(list($catid, $name) = $db->sql_fetchrow($result))
      {
           if ($catid==$cid) { $sel = "selected "; }
              $formframe.="<option $sel value=\"$catid\">$name</option>\n";
                  $sel = "";
       }
      $formframe.= "</font></select></td></tr>"
      . "<tr><td colspan=2><font class=catdesc>"._QUIZCOMMENT."<br></font><TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea><font class=catdesc></font></td></tr>"
      . "</table>"
      . "<br><center><input type='submit' class=button value='"._QUIZCREATE."'></center>"
      . "</form></center>"
      ."</DIV>";
     
    
    if ($asHtml) {
   		return $formframe;
	}else {
	include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
		echo "<div align=\"right\">";
		displayOngletBar('quiz',_QUIZNEW,$ongletDef );
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else
}


/*********************************************************/
/* Quiz Modify Functions                                 */
/*********************************************************/
/**
 * QuizModify()
 * Quiz Modify Functions
 * @param datatype paramname description
 * @return datatype description
 */
function QuizModify()
{
    global $db, $language, $hlpfile, $admin, $qid,$prefix,$ongletDef;

    $result = $db->sql_query("select quizTitle, comment, image, cid from $prefix"._quiz_admin." where quizID='$qid'");
    list($quizTitle, $comment, $image, $cid) = $db->sql_fetchrow($result);

    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("quiz",_QUIZMODIFY,$ongletDef);
    

    echo "\n<form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='modifyPostedQuiz'>";
    echo "<INPUT type='hidden' name='qid' value='$qid'>";
    echo "<table width='100%'>";
    echo "<tr><td><font class=catdesc>"._QUIZGENINFOS."</font></td></tr>";
    echo "<tr><td><font class=catdesc>"._QUIZTITLE."</font></td><td><input type='text' class=textbox name='quizTitle' value=\"$quizTitle\" size=30><font class=catdesc></font></td></tr>";
    echo "<tr><td><font class=catdesc>"._QUIZIMAGE."</font></td><td><input type='text' class=textbox name='image' value=\"$image\" size=30><br><font class=catdesc>"._QUIZHELPIMAGE."</font></td></tr>";
    echo "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><font class=catdesc><SELECT class=textbox name=\"cid\">";
    $result = $db->sql_query("select cid, name from $prefix"._quiz_categories."");
    while(list($catid, $name) = $db->sql_fetchrow($result))
        {
        if ($catid==$cid) { $sel = "selected "; }
            echo "<option $sel value=\"$catid\">$name</option>\n";
                $sel = "";
        }
    echo "</font></select></td></tr>";
    echo "<tr><td colspan=2><font class=catdesc>"._QUIZCOMMENT."<br></font><TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea><font class=catdesc></font></td></tr>";
    echo "</table>";
    echo "<br><font class=catdesc><center><input type='submit' class=button value='"._QUIZMODIFY."'></font></center>";
    echo "</form>";
    CloseOngletTable();
    echo "<p>";
    
    OpenOngletTable();
    echo  "<center><form method='post'action='system.php?op=QuizAdmin'>"._ADD."&nbsp;"
          ."<INPUT type='hidden' name='act' value='QuizAddQuestion'>"
          ."<INPUT type='hidden' name='qid' value='$qid'>"
          ."<INPUT type='hidden' name='number' value='$number'>"
          ."<select name=\"number\">"
	  ."<option name=\"number\" value=\"1\">1"
	  ."<option name=\"number\" value=\"2\">2"
	  ."<option name=\"number\" value=\"3\">3"
	  ."<option name=\"number\" value=\"4\">4"
	  ."<option name=\"number\" value=\"5\">5"
	  ."<option name=\"number\" value=\"10\">10"
	  ."<option name=\"number\" value=\"15\">15"
	  ."<option name=\"number\" value=\"20\">20"
          ."</select>&nbsp;"._OFQUESTIONS.""
          ."&nbsp;<input type='submit' class=button value='"._GO."'></form>";
    echo "<p><tr><td><font class=catdesc>"._QUIZQUESTIONS."</font></td></tr>";
    $result = $db->sql_query("SELECT pollID, pollTitle FROM $prefix"._quiz_desc." WHERE qid=$qid");
    while(list($pollID, $question) = $db->sql_fetchrow($result))
    {
        echo "<tr><td>";
        echo "<font class=catdesc>"._QUIZQUESTION." $pollID : ";
        echo "\"$question\" <a href=\"system.php?op=QuizAdmin&act=QuizModifyQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMODIFY." ]</a> | ";
        echo "<a href=\"system.php?op=QuizAdmin&act=QuizDelQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZDELETE." ]</a> |";
        echo "<a href=\"system.php?op=QuizAdmin&act=QuizMoveQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMOVEQUESTION." ] </a> |";
        echo "<a href=\"system.php?op=QuizAdmin&act=QuizCopyQuestion&pid=$pollID\"> [ "._QUIZCOPYQUESTION." ]</a></td></tr>";
        }

    CloseOngletTable();
    include("system/footer_system.php");
}
/**
 * QuizModifyCategory()
 * @param datatype paramname description
 * @return datatype description
 */
function QuizModifyCategory($cid){
    global $db, $language, $hlpfile, $admin, $cid,$prefix,$ongletDef;
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("category",_QUIZMODIFYCAT,$ongletDef);
  
    $result = $db->sql_query("SELECT name, comment, image from $prefix"._quiz_categories." where cid='$cid'");
    list ($name, $comment, $image) = $db->sql_fetchrow($result);

    echo "\n<center><form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='modifyPostedQuizCategory'>";
    echo "<INPUT type='hidden' name='cid' value='$cid'>";
    echo "<font class=catdesc>";
    echo "<table class=systemTab>";
    echo "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><input type='text' class=textbox name='CatName' value='$name'size=30></td>";
    echo "<tr><td><font class=catdesc>"._QUIZCOMMENT."</font></td><td><input type='text' class=textbox name='CatComment' value='$comment'size=30><font class=catdesc> (*)</font></td>";
    echo "<tr><td><font class=catdesc>"._QUIZCATIMAGE."</font></td><td><input type='text' class=textbox name='CatImage' value='$image'size=30><font class=catdesc> (*)</font></td>";
    echo "<td><font class=catdesc><input type='submit' class=button value='"._QUIZMODIFY."'></font></td></tr></table>";
    echo "</form>";
    echo "<font class=catdesc>* : "._QUIZHELPOPTION."</font>\n</center>";

    CloseOngletTable();
    include("system/footer_system.php");
}
/**
 * QuizModifyQuestion()
 * modify a question
 * @param int question id
 * @param int quiz id
 */
function QuizModifyQuestion($pid,$qid){
    global $db, $language, $hlpfile, $admin,$prefix,$ongletDef;
    $quizName=getQuizName($qid);
    setPath($quizName,2,"system.php?op=QuizAdmin&act=QuizModify&qid=$qid&editForm=1");
    setPath(_QUIZMODIFYQUESTION,3);
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("question",_QUIZMODIFYQUESTION." "._FROM." $quizName",$ongletDef);
    
    $result = $db->sql_query("select pollTitle, answer, coef, good, bad, comment, image from $prefix"._quiz_desc." where pollID='$pid'");
    list ($pollTitle,$answer,$coef,$good,$bad,$comment,$image) = $db->sql_fetchrow($result);
    $pollTitle = preg_replace("/\"/","&quot;",$pollTitle);
    if (preg_match("#,#",$answer)) {
      $array_answer = explode(',',$answer);
    }
	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n";
    echo "<form method='post'action='system.php?op=QuizAdmin'>";
    echo "<INPUT type='hidden' name='act' value='modifyPostedQuizQuestion'>";
    echo "<INPUT type='hidden' name='qid' value=\"$qid\">";
    echo "<INPUT type='hidden' name='pid' value=\"$pid\">";
    //echo "<table class=systemTab><tr><td><font class=catdesc>"._QUIZQUESTIONTITLE.": <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"$pollTitle\"></font></td></tr></table>";
    echo "<table class=listTable width=100%><tr class=systemTabHeader><td colspan=2>";
    echo " "._QUIZMODIFYQUESTION." ";
    echo "</td></tr><tr><td colspan=2>";        
    	echo "<table class=listTable><tr class=listTableNone><td>"._QUIZQUESTIONTITLE.": <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"$pollTitle\"></font></td></tr></table>";
    echo "</td></tr><tr><td>";
    	echo "<table class=listTable>";    	
    	$i=1;
    	$j=0;    	
    	echo "<tr class=listTableOdd><td colspan=2><font class=catdesc>"._QUIZTHEANSWER."</font></td><td><font class=catdesc>"._QUIZANSWER."</font></td></tr>";
    	$result = $db->sql_query("select optionText, voteID, optionImg from $prefix"._quiz_data." WHERE pollID='$pid' ORDER BY voteID");
    	$pos=3;
    	while(list($Text,$voteID, $Image) = $db->sql_fetchrow($result)) {
       		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
      		$Text = stripslashes(check_html($Text, "nohtml"));
      		echo "<tr class=$thestyle><td><font class=catdesc>"._OPTION." $i :</font></td><td><input type=\"text\" class=textbox name=\"optionText[$i]\" size=\"50\" maxlength=\"150\" value=\"$Text\"></font></td>\n";
        	if ($array_answer[$j] == $i) { $sel = "checked"; } else { $sel = "";  } 
      		echo "<td><font class=catdesc><input type=\"checkbox\" class=textbox name=\"optionSort[$i]\" value=\"$i\" $sel> $optionText<br></font></td></tr>";
      		echo "<tr class=$thestyle><td><font class=catdesc>"._OPTION." $i "._QUIZIMAGE."</font></td>";
	  		echo "<td><input type='text' id=\"myfield_$i\" class=textbox name='optionImg[$i]' value=\"$Image\" size=50></td>";
	  		echo "<td><img src=\"images/rte/icon_ins_image_down.gif\" id=\"ins_map\" Onclick=\"javascript:insert('download', 'myfield_$i')\"></font></td></tr>";
      		$i++;
      		$j++;
      		$pos++;
    	}     	
    	echo "</table>";
    echo "</td><td valign=top>";
    	echo "<table class=listTable>";
    	echo "<tr class=listTableOdd><td><font class=catdesc>"._QUIZCOEF."</td><td><input type='text' class=textbox name='coef' value='$coef' size=3></font></td></tr>";
    	echo "<tr class=listTableNone><td><font class=catdesc>"._QUIZIMAGE."</td><td><input type='text' id=\"myfield\" class=textbox name='image' value=\"$image\" size=40><input type=\"button\" id=\"ins_map\" value=\"Parcourir ...\" Onclick=\"javascript:insert('download')\"></font></td></tr>"
    	."<tr class=listTableOdd><td colspan=2>"._QUIZCOMMENT."<br>"
    	."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea></td></tr>"
    	."<tr class=listTableNone><td colspan=2>"._QUIZIFBADANSWER."<br>"
    	."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"bad\">$bad</textarea></td></tr>"
    	."<tr class=listTableOdd><td colspan=2>"._QUIZIFGOODANSWER."<br>"
    	."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"good\">$good</textarea></td></tr></table>";
    	
   echo "</td></tr></table>"; 	
   echo "<br><center><input type=\"submit\" class=button value=\""._QUIZMODIFYQUESTION."\"></center>"
    ."</form>";
    CloseOngletTable();
    include("system/footer_system.php");
}

/*********************************************************/
/* Quiz Move Functions                                   */
/*********************************************************/
/**
 * MoveQuestions()
 * 
 * 
 */
function MoveQuestions($qid, $new_qid) {
    global $hlpfile,$prefix, $db;
    $result = $db->sql_query("select qid from $prefix"._quiz_desc." WHERE qid='$qid'");
    while(list($qid) = $db->sql_fetchrow($result)) {
	$db->sql_query("update $prefix"._quiz_desc." set qid='$new_qid' WHERE qid='$qid'");
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin");
}
/**
 * QuizMoveQuestion()
 * 
 * 
 * 
 */
function QuizMoveQuestion($pid, $qid){
    global $db, $language, $hlpfile, $admin, $module_name, $prefix,$ongletDef;
    $quizName=getQuizName($qid);
    setPath($quizName,2,"system.php?op=QuizAdmin&act=QuizModify&qid=$qid&editForm=1");
    setPath(_QUIZMOVEQUESTION,3);
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("question",_QUIZMOVEQUESTION,$ongletDef);

    $result = $db->sql_query("SELECT pollID, pollTitle, qid FROM $prefix"._quiz_desc." WHERE pollID=$pid");
    list($pollID, $question, $quizid) = $db->sql_fetchrow($result);
    
    $result1 = $db->sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." WHERE quizID=$qid");
    list($quizID, $quizTitle) = $db->sql_fetchrow($result1);
    
    $result2 = $db->sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." order by quizID");
    
  
	echo "<center><br><b>"._MOVEQUESTION." ( $pollID ):<i> $question</b></i>
	    <form action=\"system.php?op=QuizAdmin&act=QuizMoveQuestionConfirm&pid=$pid&qid=$qid&newqid=$newqid\" method=\"post\">
	    "._FROMQUIZ." ( $quizID ) : $quizTitle";

        echo " "._TO.": <select name=\"newqid\">";
	while(list($quizID, $quizTitle) = $db->sql_fetchrow($result2)) {
	    echo "<option name=\"newqid\" value=\"$quizID\"> $quizTitle ("._QUIZ." $quizID)\n";
	}    
	echo "</select>&nbsp;&nbsp;<br>"
	    ."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	    ."</form></center>";
	CloseOngletTable();
    
    include("system/footer_system.php");

}
/**
 * QuizMoveQuestionConfirm()
 * 
 * 
 */
function QuizMoveQuestionConfirm($pid, $qid, $newqid) {
    global $hlpfile, $prefix, $db;
    $result = $db->sql_query("select pollID, qid from $prefix"._quiz_desc." WHERE pollID='$pid'");
    while(list($pollID, $qid) = $db->sql_fetchrow($result)) {
	$db->sql_query("update $prefix"._quiz_desc." set qid='$newqid' WHERE pollID='$pid'");
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Copy Functions                                   */
/*********************************************************/
/**
 * QuizCopyQuestion($pid)
 * Quiz Copy Functions  
 * 
 */
function QuizCopyQuestion($pid){
    global $db, $language, $hlpfile, $admin, $module_name, $prefix,$ongletDef;
    $quizName=getQuizName($qid);
    setPath($quizName,2,"system.php?op=QuizAdmin&act=QuizModify&qid=$qid&editForm=1");
    setPath(_QUIZCOPYQUESTION,3);
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("question",_QUIZCOPYQUESTION,$ongletDef);

    $result = $db->sql_query("SELECT pollID, pollTitle, qid FROM $prefix"._quiz_desc." WHERE pollID=$pid");
    list($pollID, $question, $quizid) = $db->sql_fetchrow($result);
    
    $result2 = $db->sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." order by quizID");
    
    echo "<form action=\"system.php?op=QuizAdmin&act=QuizCopyQuestionConfirm&pid=$pid&newqid=$newqid\" method=\"post\">";
	echo "<center><br><b>"._COPYQUESTION." ($pollID):<i> $question</b></i>";
    echo " "._IN.": <select name=\"newqid\">";
	while(list($quizID, $quizTitle) = $db->sql_fetchrow($result2)) {
	    echo "<option name=\"newqid\" value=\"$quizID\"> $quizTitle ("._QUIZ."$quizID)\n";
	}    
	echo "</select>&nbsp;&nbsp;"
	    ."<input type=\"submit\" value=\""._COPYQUESTION."\">"
	    ."</form></center>";
	CloseOngletTable();
    
    include("system/footer_system.php");

}
/**
 * QuizCopyQuestionConfirm()
 * 
 * 
 */
function QuizCopyQuestionConfirm($pid, $newqid) {
    global $hlpfile,$prefix, $db;
    $result = $db->sql_query("select pollID, pollTitle, timeStamp, voters, qid, answer, coef, good, bad, comment, image from $prefix"._quiz_desc." WHERE pollID='$pid'");
    list($pollID, $pollTitle, $timeStamp, $voters, $qid, $answer, $coef, $good, $bad, $comment, $image) = $db->sql_fetchrow($result);
    $db->sql_query("insert $prefix"._quiz_desc." VALUES ('NULL', '$pollTitle', '$timeStamp', '$voters', '$newqid', '$answer', '$coef', '$good', '$bad', '$comment', '$image')");
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Misc Functions                                   */
/*********************************************************/
/**
 * getnow()
 * 
 */
function getnow ()
{
    $today = getdate();
    $tday = $today[mday];
    if ($tday < 10){ $tday = "0$tday"; }
    $tmonth = $today[month];
    $ttmon = $today[mon];
    if ($ttmon < 10) { $ttmon = "0$ttmon"; }
    $tyear = $today[year];
    $thour = $today[hours];
    if ($thour < 10) { $thour = "0$thour"; }
    $tmin = $today[minutes];
    if ($tmin < 10) { $tmin = "0$tmin"; }
    $tsec = $today[seconds];
    if ($tsec < 10) { $tsec = "0$tsec"; }
    return "$tmonth $tday, $tyear @ $thour:$tmin:$tsec";
}

/*********************************************************/
/* Quiz Create Functions                                 */
/*********************************************************/

function createPostedQuiz($quizTitle,$image,$comment,$cid)
{
    global $hlpfile,$db,$administrator, $prefix;

    if(isset($emailadmin)) $emailadmin=1; else $emailadmin=0;
    if(isset($displayresults)) $displayresults=1; else $displayresults=0;
    if(isset($displayscore)) $displayscore=1; else $displayscore=0;
    if(isset($restrict)) $restrict=1; else $restrict=0;
    if(isset($log)) $log=1; else $log=0;
    if(isset($contrib)) $contrib=1; else $contrib=0;
    $expire = "$year-$month-$day $hour:$min";

    $timeStamp = time();
    $quizTitle = FixQuotes($quizTitle);
    $comment = FixQuotes($comment);
    $conditions = FixQuotes($conditions);
    if(!$db->sql_query("INSERT INTO $prefix"._quiz_admin." VALUES (NULL, '$quizTitle', '$timeStamp','$comment','$image','$cid')")) {
    	print_r($db->sql_error());
    	die('Invalid query');
	}
    
    Header("Location: system.php?op=QuizAdmin");
}
/**
 * createPostedQuizQuestion()
 * Add a new question
 * 
 */
function createPostedQuizQuestion($question, $qid, $answer, $coef, $good, $bad, $comment, $image, $optionSort,$optionText, $optionImg, $mode, $pid)
{
    global $hlpfile,$db,$mode,$pid,$prefix;

 	$good = nl2br(stripslashes(FixQuotes(check_html($good, ""))));
    $bad = nl2br(stripslashes(FixQuotes(check_html($bad, ""))));
    $comment = nl2br(stripslashes(FixQuotes(check_html($comment, ""))));
    $question = nl2br(stripslashes(FixQuotes(check_html($question, ""))));

    $timeStamp = time();

	if (strlen($optionSort) >= 2) {
       for($i = 1; $i <= sizeof($optionText); $i++) {
           if (isset($optionSort[$i])) { $optionSort[$i] = "$i,"; } else { $optionSort[$i] = ","; }
          }
        $answer = "$optionSort[1]$optionSort[2]$optionSort[3]$optionSort[4]$optionSort[5]$optionSort[6]$optionSort[7]$optionSort[8]$optionSort[9]$optionSort[10]";
        }
	if (!empty($answer))
	{		$answer = $answer; }

if(!$db->sql_query("INSERT INTO $prefix"._quiz_desc." VALUES (NULL, '$question', '$timeStamp', 0, '$qid','$answer','$coef','$good','$bad','$comment','$image')"))
        {
        	print_r($db->sql_error());
        echo "<br>";
        return;
    }
    $object = $db->sql_fetchrow($db->sql_query("SELECT pollID FROM $prefix"._quiz_desc." WHERE pollTitle='$question'"));
    $id = $object["pollID"];
    for($i = 1; $i <= sizeof($optionText); $i++)
        {
        if($optionText[$i] != "")
        {
            $optionText[$i] = FixQuotes($optionText[$i]);
        }
        if($optionImg[$i] != "")
        {
            $optionImg[$i] = FixQuotes($optionImg[$i]);
        }
        if(!$db->sql_query("INSERT INTO $prefix"._quiz_data." (pollID, optionText, optionCount, voteID, optionImg) VALUES ($id, '$optionText[$i]', 0, $i,'$optionImg[$i]')"))
        {
        	print_r($db->sql_error());
            echo "<br>";
            return;
        }
    }

    # delete contributor question if needed
    if ($mode == "contrib")
    {
         $db->sql_query("DELETE FROM $prefix"._quiz_datacontrib." WHERE pollID='$pid'");
         $db->sql_query("DELETE FROM $prefix"._quiz_descontrib." WHERE pollID='$pid'");
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizQuestion&qid=$qid");
}

/**
 * createPostedQuizCategory()
 * Add a new category
 * 
 * 
 */
function createPostedQuizCategory()
{
        global $hlpfile,$db, $CatName,$CatComment,$CatImage,$prefix;

    if(!$db->sql_query("INSERT INTO $prefix"._quiz_categories." VALUES (NULL, '$CatName','$CatComment','$CatImage')"))
        {
        	print_r($db->sql_error());
                echo "<br>";
                return;
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Delete Functions                                 */
/*********************************************************/
/**
 * QuizDelCategory()
 * Confirm category deletion Delete Functions     
 * 
 * 
 */
function QuizDelCategory($cid)
{
    global $hlpfile, $db,$prefix,$ongletDef;
    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("category",_QUIZDELCAT,$ongletDef);
   
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZDELCAT."</b></font><br><br>"
        ."<font class=catdesc>"._QUIZSURE2DELETECAT."<br><br>"
        ."[ <a href=\"system.php?op=QuizAdmin&act=removePostedQuizCategory&cid=$cid\">"._YES."</a> | <a href=\"system.php?op=QuizAdmin&act=QuizAdmin\">"._NO."</a> ]</center>";
    CloseOngletTable();
    include("system/footer_system.php");


}
/**
 * QuizDelQuestion()
 * 
 * 
 */
function QuizDelQuestion($qid,$pid) {
    global $hlpfile,$db, $hlpfile, $admin,$prefix,$ongletDef;

    include("system/header_system.php");
    GraphicAdmin(_QUIZ_ADM);
    OpenOngletTable();
    displayOngletBar("question",_QUIZDELQUESTION,$ongletDef);
   
    echo "<center><font size=\"3\"><b>"._QUIZDELQUESTION."</b></font><br><br>"
        .""._QUIZSURE2DELQUESTION." $pid?<br><br>"
        ."[ <a href=\"system.php?op=QuizAdmin&act=removePostedQuizQuestion&qid=$qid&pid=$pid\">"._YES."</a> | <a href=\"system.php?op=QuizAdmin&act=QuizModify&qid=$qid\">"._NO."</a> ]</center>";
    CloseOngletTable();
    include("system/footer_system.php");

}

function removePostedQuizCategory($cid) {
    global $hlpfile,$db,$prefix,$ongletDef;

    $db->sql_query("DELETE FROM $prefix"._quiz_categories." WHERE cid='$cid'");
    Header("Location: system.php?op=QuizAdmin&onglet=category");
}

function removePostedQuiz($qid) {
    global $hlpfile,$db,$prefix;

    $result = $db->sql_query("SELECT pollID FROM $prefix"._quiz_desc." WHERE qid='$qid'");
    while(list($pollID) = $db->sql_fetchrow($result))
    {
        $db->sql_query("DELETE FROM $prefix"._quiz_desc." WHERE pollID='$pollID'");
        $db->sql_query("DELETE FROM $prefix"._quiz_data." WHERE pollID='$pollID'");
	}

    $db->sql_query("DELETE FROM $prefix"._quiz_admin." WHERE quizID='$qid'");
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin");
}

function removePostedQuizQuestion($qid,$pid) {
    global $hlpfile,$db,$prefix;
    $db->sql_query("DELETE FROM $prefix"._quiz_desc." WHERE pollID='$pid'");
    $db->sql_query("DELETE FROM $prefix"._quiz_data." WHERE pollID='$pid'");
    Header("Location: system.php?op=QuizAdmin&act=QuizQuestion&qid=$qid");
}

/**
 * modifyPostedQuizCategory
 * 
 * 
 */
function modifyPostedQuizCategory ($cid,$CatName, $CatComment,$CatImage ){
	global $prefix, $db;
	
	if(!$db->sql_query("update $prefix"._quiz_categories." set name='$CatName', comment='$CatComment', image='$CatImage' where cid=$cid"))
        {
        	print_r($db->sql_error());
                echo "<br>";
                return;
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizAdmin&onglet=category");
}


/**
 * modifyPostedQuizQuestion
 * 
 * 
 */
function modifyPostedQuizQuestion($question, $qid, $answer, $coef, $good, $bad, $comment, $image, $optionSort,$optionText,$optionImg, $mode, $pid)
{
    global $hlpfile,$db,$mode,$pid,$prefix;

 	$good = nl2br(stripslashes(FixQuotes(check_html($good, ""))));
    $bad = nl2br(stripslashes(FixQuotes(check_html($bad, ""))));
    $comment = nl2br(stripslashes(FixQuotes(check_html($comment, ""))));
    $question = nl2br(stripslashes(FixQuotes(check_html($question, ""))));

    $timeStamp = time();

	if (strlen($optionSort) >= 2) {
                for($i = 1; $i <= sizeof($optionText); $i++) {
        if (isset($optionSort[$i])) { $optionSort[$i] = "$i,"; } else { $optionSort[$i] = ","; }
        }
        $answer = "$optionSort[1]$optionSort[2]$optionSort[3]$optionSort[4]$optionSort[5]$optionSort[6]$optionSort[7]$optionSort[8]$optionSort[9]$optionSort[10]";
        }
	if (!empty($answer))
	{		$answer = $answer; }

if(!$db->sql_query("UPDATE $prefix"._quiz_desc." set  pollTitle='$question', timeStamp='$timeStamp', voters=0, qid='$qid', answer='$answer',coef='$coef',good='$good',bad='$bad',comment='$comment',image='$image' where pollID='$pid'"))
        {
        	print_r($db->sql_error());
        echo "<br>";
        return;
    }
    $object = $db->sql_fetchrow($db->sql_query("SELECT pollID FROM $prefix"._quiz_desc." WHERE pollTitle='$question'"));
    $id = $object["pollID"];
    for($i = 1; $i <= sizeof($optionText); $i++)
        {
        if($optionText[$i] != "")
        {
            $optionText[$i] = FixQuotes($optionText[$i]);
        }
        if($optionImg[$i] != "")
        {
            $optionImg[$i] = FixQuotes($optionImg[$i]);
        }
        if(!$db->sql_query("UPDATE $prefix"._quiz_data." set  optionText='$optionText[$i]', optionCount=0, optionImg='$optionImg[$i]' WHERE  pollID='$id' AND  voteID='$i'"))
        {
        	print_r($db->sql_error());
            echo "<br>";
            return;
        }
    }

    # delete contributor question if needed
    if ($mode == "contrib")
    {
         $db->sql_query("DELETE FROM $prefix"._quiz_datacontrib." WHERE pollID='$pid'");
         $db->sql_query("DELETE FROM $prefix"._quiz_descontrib." WHERE pollID='$pid'");
    }
    Header("Location: system.php?op=QuizAdmin&act=QuizQuestion&qid=$qid");
}

/**
 * modifyPostedQuiz()
 * 
 * 
 */
function modifyPostedQuiz($qid, $quizTitle,$image,$comment,$cid) {
	global $prefix, $db;
	
	if(!$db->sql_query("update $prefix"._quiz_admin." set quizTitle='$quizTitle', comment='$comment', image='$image', cid='$cid' where quizID='$qid'"))
        {
        	print_r($db->sql_error());
             die('Invalid query');
    }
    Header("Location: system.php?op=QuizAdmin");
}
/**
 * getQuizName()
 * provide quiz name
 * param int quiz id
 */
 function getQuizName($qid){
 	global $prefix, $db;
 	$result = $db->sql_query("SELECT quizTitle FROM ".$prefix."_quiz_admin WHERE quizID='$qid'");
 	list($quizTitle)=$db->sql_fetchrow();
    return $quizTitle;
 }
/*********************************************************/
/* Quiz Act Functions                                    */
/*********************************************************/

if (!isset($act))
{
    QuizAdmin($onglet);
}
else
{
switch($act) {

    case "createPostedQuizQuestion":
    createPostedQuizQuestion($question, $qid, $answer, $coef, $good, $bad, $comment, $image, $optionSort,$optionText,$optionImg, $mode, $pid);
    break;

    case "QuizAddQuestion":
    QuizAddQuestion($qid);
    break;

    case "QuizDelQuestion":
    QuizDelQuestion($qid,$pid);
    break;

    case "QuizViewStats":
    QuizViewStats();
    break;

    case "QuizRemoveScore":
    QuizRemoveScore();
    break;

    case "QuizViewScore":
    QuizViewScore();
    break;

    case "createPostedQuiz":
    createPostedQuiz($quizTitle,$image,$comment,$cid);
    break;

    case "QuizModifyCategory":
    QuizModifyCategory($cid);
    break;

    case "QuizModifyQuestion":
    QuizModifyQuestion($pid,$qid);
    break;

    case "QuizModify":
    QuizEdit($qid,$editForm, $asHtml);
    break;

    case "QuizDelCategory":
    QuizDelCategory($cid);
    break;

    case "createPostedQuizCategory":
    createPostedQuizCategory();
    break;

    case "removePostedQuizCategory":
    removePostedQuizCategory($cid);
    break;

    case "removePostedQuiz":
    removePostedQuiz($qid);
    break;

    case "removePostedQuizQuestion":
    removePostedQuizQuestion($qid,$pid);
    break;
    
    case "modifyPostedQuizCategory":
    modifyPostedQuizCategory ($cid,$CatName, $CatComment,$CatImage );
    break;
    
    case "modifyPostedQuizQuestion":
    modifyPostedQuizQuestion($question, $qid, $answer, $coef, $good, $bad, $comment, $image, $optionSort,$optionText,$optionImg, $mode, $pid);
    break;
    
    case "modifyPostedQuiz":
    modifyPostedQuiz($qid, $quizTitle,$image,$comment,$cid); 
    break;
    
    case "QuizEdit":
    QuizEdit($qid,$editForm=0, $asHtml=0);
    break;

    case "QuizMoveQuestion":
    QuizMoveQuestion($pid, $qid);
    break;
    
    case "MoveQuestions":
    MoveQuestions($qid, $new_qid);
    break;

    case "QuizMoveQuestionConfirm":
    QuizMoveQuestionConfirm($pid, $qid, $newqid);
    break;

    case "QuizCopyQuestion":
    QuizCopyQuestion($pid);
    break;

    case "QuizCopyQuestionConfirm":
    QuizCopyQuestionConfirm($pid, $newqid);
    break;

    case "QuizQuestion":
    QuizQuestion($cid);
    break;
    
    case "QuizAdmin":
    QuizAdmin($onglet);
    break;

}
}
}

else {
    display_denied();
}

/*********************************************************/
?>
