<?php

if (!preg_match("#system_mobile.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("Sections")) {
		
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
		}
	}
	
	function getTopicList() {
		global $db, $prefix;
		
		$topicList = array();
		$result = $db->sql_query("select topicid, topicname, count(".$prefix."_stories.sid) as nbre from ".$prefix."_topics left join ".$prefix."_stories on ".$prefix."_topics.topicid=".$prefix."_stories.topic where topicname <> '' group by topicid order by topicname ASC");
		while (list($topicid, $topicname, $nbre) = $db->sql_fetchrow($result)) {
			$topicList[]= array($topicid, $topicname, $nbre);
		}
		$db->sql_freeresult($result);
		return $topicList;
	}
	
	function getAlbumList() {
		global $db, $prefix;
		
		$albumList = array();
		$result = $db->sql_query("select albumid, album_name from ".$prefix."_gallery_album order by album_name ASC");
		while (list($albumid, $album_name) = $db->sql_fetchrow($result)) {
			$albumList[]= array($albumid, $album_name);
		}
		$db->sql_freeresult($result);
		return $albumList;
	}
	
	function getActuList($topicid,$langRestrict=""){
		global $db, $prefix, $multilingual;
		
		$actuList = array();
		$cond = "";
		if ($topicid != "") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " topic=$topicid";
		}
		if ($multilingual == 1 && $langRestrict != "" && $langRestrict != "All") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " alanguage='$langRestrict'";
		}
		if ($cond != "") {
			$cond = " WHERE".$cond;
		}
	
		$result = $db->sql_query("select sid, title, time, alanguage, informant, status from ".$prefix."_stories $cond order by `time` desc;");

		while ($ligne = $db->sql_fetchrow($result)) {
			$actuList[]= array($ligne["sid"], $ligne["title"], $ligne["alanguage"], $ligne["time"], $ligne["status"], $ligne["informant"]);
		}
		$db->sql_freeresult($result);

		return $actuList;
	}
	
	function getActuContent($sid){
		global $db,$prefix;
		
		if ($sid =="") {
			return "";
		}
		else {
			$cond = "";
			if ($sid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " sid=$sid";
			}
			
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}			 	
			$result = $db->sql_query("select title,	time, hometext, bodytext, topic, aid, informant, alanguage, status, album from ".$prefix."_stories $cond;");
			if ($ligne = $db->sql_fetchrow($result)) {
				$sortie= array(
					"title" => $ligne["title"],
					"time" => $ligne["time"],
					"hometext" => $ligne["hometext"],
					"bodytext" => $ligne["bodytext"],
					"topic" => $ligne["topic"],
					"aid" => $ligne["aid"],
					"informant" => $ligne["informant"],
					"alanguage" => $ligne["alanguage"],
					"status" => $ligne["status"],
					"album" => $ligne["album"]
				);
			}
			$db->sql_freeresult($result);
			return $sortie; 
		}
	}
	
	function list_actus() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name;
    
	    $page_header_title = 'Liste des actualits';
	    
	    include ("system/header_system_mobile.php");
	   	
	    $sortie = "";
	    
	    $sortie .= '<div class="marge">';
	    
	    $topics = getTopicList();
	    
	    $nbreactus = count(getActuList("0"));
	    if ($nbreactus > 0) {
	    	$topics[] = array("0", "Actualits sans sujet",$nbreactus);
	    }
	    $compteur = -1;
	    foreach ($topics as $onetopics) {
	    	if ($onetopics[2] > 0) {
		    	$compteur++;
		    	$sortie .= '
<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onetopics[1].' ('.$onetopics[2].')'.'</a>
<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
		    	
		    	$listeactus= '';
		    	$actus = getActuList($onetopics[0]);
		    	foreach ($actus as $oneactu) {
		    		$pub = ($oneactu[4] == "P") ? "Publie" : "Non publie";
		    		$np = ($oneactu[4] == "P") ? "" : " np";
		    		$date = date2JMA($oneactu[3],"d/m/Y H:i");
		    		//$src_picto = ($oneactu[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
		    		//$picto = '<img src="'.$src_picto.'" />';
		    		$listeactus .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editactu&sid='.$oneactu[0].'">'.$oneactu[1].' <span class="infos">'.$pub.' - '.$date.' - '.$oneactu[5].''.$picto.'</span></a></li>';
		    	}
				if ($listeactus != '') {
					$sortie .= '<ul class="collection-combo-docs">'.$listeactus.'</ul>';
				}
		    	
				$sortie .= '
</div>
</div>';
	    }	
	    }
	    
	    //$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
	    
	    $sortie .= '</div>';
    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}

	function edit_actu($sid) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system, $admincontrolsection, $Default_Theme, $Default_Theme_mobile;
		
		$contenu = array();
		$menutopics = '';
		if ($sid != "") {
			$contenu = getActuContent($sid);
		}
		else {
			$contenu= array(
					"title" => "",
					"time" => date("Y-m-d H:i:s"),
					"hometext" => "",
					"bodytext" => "",
					"topic" => 0,
					"aid" => $aid,
					"informant" => $aid,
					"alanguage" => "french",
					"status" => "P",
					"album" => "-1"
				);
		}
		
		
		$topics = getTopicList();
		$menutopics = '<select name="data[topic]" class="saisie_text">';
		foreach($topics as $topic) {
			$selected = ($topic[0] == $contenu["topic"]) ? ' selected="selected"' : '';
			$menutopics .= '<option value="'.$topic[0].'"'.$selected.'>'.$topic[1].'</option>';
		}
		$menutopics .= '</select>';
		
		$albums = getAlbumList();
		$menualbums = '<select name="data[album]" class="saisie_text">';
		$menualbums .= '<option value="-1"'.$selected.'>Aucun album</option>';
		foreach($albums as $album) {
			$selected = ($album[0] == $contenu["album"]) ? ' selected="selected"' : '';
			$menualbums .= '<option value="'.$album[0].'"'.$selected.'>'.$album[1].'</option>';
		}
		$menualbums .= '</select>';
		
		/*if ($admincontrolsection) {
		    if ($aid != $contenu["informant"] && !is_super($admin)) {
		    	display_denied();
		    	return;
		    }
	    }*/
    
	    $page_header_title = 'dition d\'actualit';
	    
	    require_once 'system/modules/core/becmsTinyMCEconfig.php';
	    $header_system .= '<script src="javascripts/tinymce/tinymce.min.js"></script>
		<script>
		'.init_becms_tinymce("mobile_article",0).'
		'.init_becms_tinymce("mobile_resume",0).'
		</script>';
	    
	    include ("system/header_system_mobile.php");
	    	    
	    $sortie = '';
	    
	    $sortie .= '
<form action="system_mobile.php" method="post" class="nomarge">
	<div class="marge">
		Titre de l\'actualit : <input type="text" name="data[title]" value="'.str_replace('"', "&quot;", $contenu["title"]).'" class="saisie_text" />
		Date de l\'actualit : <input type="datetime-local" name="data[time]" value="'.date("Y-m-d\TH:i:s",strtotime($contenu["time"])).'" class="saisie_text" />
		Sujet : '.$menutopics.'
		Album associ : '.$menualbums.'
		Publie : <input type="checkbox" value="P" name="data[status]"'.(($contenu["status"] == "P") ? ' checked="checked"' : '' ).' class="saisie_checkbox" />
		<br />Rsum (chapo) : 
	</div>
	<textarea class="resume" name="data[hometext]">'.$contenu["hometext"].'</textarea>
	<div class="marge">
		Article : 
	</div>
	<textarea id="article" name="data[bodytext]">'.$contenu["bodytext"].'</textarea>
	<div class="marge"><input type="submit" value="Enregistrer l\'actualit" class="saisie_text submit" name="valid"></div>
	<input type="hidden" name="op" value="saveactu" />
	<input type="hidden" name="data[sid]" value="'.$sid.'" />
	<input type="hidden" name="data[informant]" value="'.$contenu["informant"].'" />
	<input type="hidden" name="data[aid]" value="'.$contenu["aid"].'" />
	<input type="hidden" name="data[alanguage]" value="'.$contenu["alanguage"].'" />
</form>';
	    
	    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}

	function save_actu($actu) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$actu = array_map("FixQuotes", $actu);
		$actu = array_map("stripslashes", $actu);
		
		if (($actu["status"]!="P")||($actu["status"]=="")) $actu["status"]="NP";
	
		$myservernotport="http://".$_SERVER['SERVER_NAME'];
		$actu["hometext"] = str_replace($myservernotport,"",$actu["hometext"]);
		$actu["bodytext"] = str_replace($myservernotport,"",$actu["bodytext"]);
		$myservernotport="https://".$_SERVER['SERVER_NAME'];
		$actu["hometext"] = str_replace($myservernotport,"",$actu["hometext"]);
		$actu["bodytext"] = str_replace($myservernotport,"",$actu["bodytext"]);
		
		$actu["time"] = date("Y-m-d H:i:s",strtotime($actu["time"]));
    
	    if ($actu["sid"] != "") {
		    $sql = "UPDATE ".$prefix."_stories";
		    $sql .= " SET title='".$actu["title"]."', hometext='".$actu["hometext"]."', bodytext='".$actu["bodytext"]."', time='".$actu["time"]."', status='".$actu["status"]."', topic='".$actu["topic"]."', aid='".$actu["aid"]."', informant='".$actu["informant"]."', alanguage='".$actu["alanguage"]."', album='".$actu["album"]."'";
		    $sql .= " WHERE sid = ".$actu["sid"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
	    else {
	    	$sql = "INSERT INTO ".$prefix."_stories";
		    $sql .= " (title, hometext, bodytext, time, status, topic, aid, informant, alanguage, album)";
		    $sql .= "VALUES ('".$actu["title"]."','".$actu["hometext"]."','".$actu["bodytext"]."','".$actu["time"]."','".$actu["status"]."', '".$actu["topic"]."', '".$actu["aid"]."', '".$actu["informant"]."', '".$actu["alanguage"]."', '".$actu["album"]."');"; 
	    	$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
		
		$header_system .= '
		<script>
			allerPage("system_mobile.php?op=listactus",2000);
		</script>';
		
		$page_header_title = 'Enregistrement d\'actualit';
		include ("system/header_system_mobile.php");
		
		//enregistrement dans la base de donnes  faire
		
		$sortie = '<alert class="center_v_abs">Actualit enregistre</alert>';

		echo $sortie;
		include ("system/footer_system_mobile.php");
	}

	if (!isset($sid)) {
		$sid = "";
	}
	switch ($op) {
		case "newactu":
		case "editactu":
			edit_actu($sid);
			break;
		case "saveactu":
			save_actu($data);
			break;
		case "listactus":
		default:
			list_actus();
			break;
	}
}
else {
	display_denied();
}

?>