<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Calendrier Module      	            								*/
/* Copyright (c) 2006  Stephan Acquatella								*/
/* Integration in BECMS (rewrite admin UI), add registration managment	*/
/*																		*/
/* Based on code done by Amine Laurent BENKHOUCHA 2003/2004				*/
/* http://phpnuke-france.org											*/
/* Version Amliore de Event Calendar version 2.0						*/
/* D'aprs les travaux de Rob Sutton et Aleks A.Lessmann				*/
/* Prefix and minor bugfixes by                         				*/
/* fsz dESIGN & maaX dESIGN                             				*/
/* http://www.fsz-design.de  http://www.maax-design.de  				*/
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

$index = 0;
$module_name = basename(dirname(__FILE__));

/********************************************************/

if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("Erreur:Vous ne pouvez pas acceder directement  ce fichier...");
}

function conditionnerMobile($texte) {
	//$texte = str_replace("\n",'\n',$texte);
	//$texte = str_replace("\r","",$texte);
	$texte = html_entity_decode($texte,ENT_QUOTES,"ISO-8859-1");
	$texte = utf8_encode($texte);
	return $texte;
}

class Actualite
{
	public $sid;
	public $title;
	public $time;
	public $hometext;
	public $bodytext;
	public $urlVignette;
	public $urlVignetteDefault = false;
	public $time_orig;
	public $vignette_orig;

	function __construct($sid, $title, $time,$hometext, $bodytext){
		$this->sid = $sid;
		$this->title = $title;
		$this->time = $this->beautifulDate($time);
		$this->setHometext($hometext.$bodytext);
		$this->bodytext = strip_tags($bodytext);
		$this->time_orig = $time;
		$this->hometext_orig = $hometext;
		$this->bodytext_orig = $bodytext;
	}

	public function beautifulDate($date){
		global $locale;
		$date = explode("-", $date);
		setlocale (LC_TIME,$locale,'fra');
		$temp = explode(" ", $date[2]);
		return strftime("%d %B %Y", mktime(0, 0, 0, $date[1], $temp[0], $date[0]));
	}

	/**
	 * @param string $hometext
	 */
	public function setHometext($hometext)
	{

		if (preg_match("/(<img[^>]+>)/mi",$hometext,$tabimages)) {
			$vignette = $tabimages[1];
			$hometext = preg_replace("/(<img[^>]+>)/mi","",$hometext);
			preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
			$urlvignette = $taburls[1];			
			if (file_exists($urlvignette)) {
				$this->urlVignette = "modules/becmsGallery/resizer_big.php?imgfile=../../$urlvignette&max_width=78&max_height=60";
				$this->vignette_orig = $urlvignette;
			}
			else {
				$this->urlVignetteDefault = true;
				$this->urlVignette = "themes/mobile_corte/images/drawer_header_logo.png";
				$this->vignette_orig = "themes/mobile_corte/images/drawer_header_logo.png";
			}
		}
		else {
				$this->urlVignetteDefault = true;
				$this->urlVignette = "themes/mobile_corte/images/drawer_header_logo.png";
				$this->vignette_orig = "themes/mobile_corte/images/drawer_header_logo.png";
			
		}
		$this->hometext = strip_tags($hometext);
	}
}

class ActualitePage
{
	public $sid;
	public $title;
	public $time;
	public $hometext = "";
	public $bodytext;
	public $urlVignette;

	function __construct($sid, $title, $time,$hometext, $bodytext, $album){
		$this->sid = $sid;
		$this->title = $title;
		$this->time = $this->beautifulDate($time);
		$this->time_origin = $time;
		$this->hometext_origin = $hometext;
		$this->bodytext_origin = $bodytext;
		$this->setHometext($hometext.$bodytext);
		$this->bodytext = strip_tags($bodytext);
		$this->album = $album;
	}

	/**
	 * @param string $hometext
	 */
	public function setHometext($hometext) {
		if (preg_match("/(<img[^>]+>)/mi",$hometext,$tabimages)) {
			$vignette = $tabimages[1];
			$hometext = preg_replace("/(<img[^>]+>)/mi","",$hometext);
			preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
			$urlvignette = $taburls[1];
			if (file_exists($urlvignette)) {
				//$this->urlVignette = "modules/becmsGallery/resizer_big.php?imgfile=../../$urlvignette&max_width=414&max_height=250";
				$this->urlVignette = "modules/becmsGallery/resizer.php?imgfile=../../".$urlvignette."&max_height=1280";
			}
			else {
				$this->urlVignette = null;
	
			}
		}
		else {
			$this->urlVignette = null;

		}
		
		//enlever tous les attributs de toutes les balises
		$hometext= preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $hometext);

		$this->hometext = strip_tags(
				str_replace("<tr>", "<p>",
					str_replace("</tr>", "</p>",
						str_replace("<td>", "<br>",
							str_replace("</td>", "</br>",
								$hometext
							)
						)
					)
				), '<br><b><strong><i><em><p><li><ol><ul>'
			);
	}
	
	public function beautifulDate($date){
		global $locale;
		$date = explode("-", $date);
		setlocale (LC_TIME,$locale,'fra');
		$temp = explode(" ", $date[2]);
		return strftime("%d %B %Y", mktime(0, 0, 0, $date[1], $date[2], $date[0]));
	}

}

function collectionActualite($arrayActualite) {
	$htmlRetour = '<div class="card-accueil">
			<!-- Card Content -->
			<ul class="collection-actualite " >';

	foreach($arrayActualite as $actualite){

		$htmlVignette = "";

		if($actualite->urlVignetteDefault){
			//listing avec vignette
			$htmlVignette = '<div class="case-collection-image"><img src="'.$actualite->urlVignette.'" height="60px"  style="border: 1px solid red;"></div>';
			//listing sans aucune vignette
			//$htmlVignette = "";
		}
		else {
			$htmlVignette = '<div class="case-collection-image">
						<img src="'.$actualite->urlVignette.'" height="60px">
					</div>';
		}


		$htmlRetour = $htmlRetour.'<li class="collection waves-effect waves-block goTo" url="'.normalize_name($actualite->title).'_mactu_'.$actualite->sid.'.htm" style="display:block">
				<div style="display:table; width: 100%">
					<div class="case-collection-left">
						<span class="case-collection-title">'.$actualite->title.'</span>
						<p class="case-collection-description">'.$actualite->hometext.'</p>
						<p class="case-collection-date">'.$actualite->time.'</p>
					</div>'.$htmlVignette.'
					<div class="case-collection-right">
						<a href="#!" class="secondary-content"><i class="material-icons arrow-actualite">&#xE315;</i></a>
					</div>
				</div>
			</li>';

	}

	$htmlRetour = $htmlRetour.'</ul></div>';
	return $htmlRetour;
}

function getCollectionActualite($topicid=""){
	global $db, $prefix, $currentlang;
	
	$theOrder="";
	
	$where = " WHERE status='P'";
	if ($topicid) {
		$where .= ($where == "") ? " WHERE ": " AND "; 
		$where .= "topic='".$topicid."' ";
	}
	$where .= ($where == "") ? " WHERE ": " AND "; 
	$where .= " (alanguage='$currentlang' OR alanguage='')";
	
	$collectionActualite = array();
	
	$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories ".$where." ORDER BY time DESC;");

	while ($row = $db->sql_fetchrow($result)) {
		$actualite = new Actualite($row["sid"],$row["title"],$row["time"],$row["hometext"],$row["bodytext"]);
		array_push($collectionActualite, $actualite);
	}
	return $collectionActualite;
}

function getActualitePage($sid){
	global $db, $prefix;
	$theOrder="time DESC";
	$collectionActualite = array();

	$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings, album FROM ".$prefix."_stories WHERE sid=".$sid);
	$row = $db->sql_fetchrow($result);
	//var_dump($row);
	$actualite = new ActualitePage($row["sid"],$row["title"],$row["time"],$row["hometext"],$row["bodytext"], $row["album"]);
	return $actualite;
}
function getActualite($actualite){
	$sortie = "";
	if($actualite->urlVignette != null){
		$sortie .=  '<div class="card corp-page-news accent-color">
        <!-- Card Content -->
        <div class="card-image waves-effect waves-block waves-light card-image-page-agenda">
            <img src="'.$actualite->urlVignette.'">
        </div>
        <div class="corp-page-agenda-title-area text-primary-color ">
            <p style="font-size: 16px;font-weight: 500;margin: 12px 0 0 0;">'.$actualite->time.'</p>
            <p style="font-size: 20px; font-weight: bold;margin: 5px;">'.$actualite->title.'</p>
            <p style="font-size: 16px; font-weight: 300;margin: 8px 0px 12px 0;">'.$actualite->catid.'</p>
        </div>
        <div class="card-content background-white">'.$actualite->hometext.'</div>
    </div>';
	}
	else {
		$sortie .= '<div class="card corp-page-news accent-color">
        <!-- Card Content -->
     
        <div class="corp-page-agenda-title-area text-primary-color ">
            <p style="font-size: 16px;font-weight: 500;margin:0;padding-top:10px;">'.$actualite->time.'</p>
            <p style="font-size: 20px; font-weight: bold;margin: 5px;">'.$actualite->title.'</p>
            <p style="font-size: 16px; font-weight: 300;margin: 8px 0px 12px 0;">'.$actualite->catid.'</p>
        </div>
        <div class="card-content background-white">'.$actualite->hometext.'</div>
    </div>';
	}
	return $sortie;
}

function listactus($topicid = ""){
	global $module_name, $db, $prefix,$time24Hour,$useInternationalDates,$Default_Theme;
	global $pagetitle;

	
	
	if (file_exists("themes/".$Default_Theme."/pattern_news_list.php")) {
		$tab_news = getCollectionActualite($topicid);
		require("themes/".$Default_Theme."/pattern_news_list.php");
	}
	else {
		$sortie =  collectionActualite( getCollectionActualite($topicid) );
	}
	
	$sortie = conditionnerMobile($sortie);
	
	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
}

function viewactu($sid){
	global $Default_Theme, $db, $prefix;
	global $pagetitle;
	global $meta_keyword, $meta_description, $meta_twitter_card, $meta_twitter_site, $meta_twitter_creator, $meta_og_url, $meta_og_title, $meta_og_description, $meta_og_image, $meta_og_type;
	
	$actualite = getActualitePage($sid);
	$pagetitle = "- ".$actualite->title;

	$result = $db->sql_query("select keywords, description, twitter_card, twitter_site, twitter_creator, og_url, og_title, og_description, og_image, og_type FROM ".$prefix."_stories where sid=$sid");
	list($keywords, $description, $twitter_card, $twitter_site, $twitter_creator, $og_url, $og_title, $og_description, $og_image, $og_type) = $db->sql_fetchrow($result);
	if ($keywords != "") {
		$meta_keyword = $keywords;
	}
	if ($description != "") {
		$meta_description = $description;
	}
	if ($twitter_card != "") {
		$meta_twitter_card = $twitter_card;
	}
	if ($twitter_site != "") {
		$meta_twitter_site = $twitter_site;
	}
	if ($twitter_creator != "") {
		$meta_twitter_creator = $twitter_creator;
	}
	if ($og_url != "") {
		$meta_og_url = $og_url;
	}
	if ($og_title != "") {
		$meta_og_title = $og_title;
	}
	if ($og_description != "") {
		$meta_og_description = $og_description;
	}
	if ($og_image != "") {
		$meta_og_image = $og_image;
	}
	if ($og_type != "") {
		$meta_og_type = $og_type;
	}
	
	if (file_exists("themes/".$Default_Theme."/pattern_news.php")) {		
		$sortie = "";
		require("themes/".$Default_Theme."/pattern_news.php");
	}
	else {
		$sortie =  getActualite($actualite);
	}
	$sortie = conditionnerMobile($sortie);
	
	include("header_mobile.php");
	echo $sortie;	
	include("footer_mobile.php");
}

// ------------------------------ switch part -----------------------
switch ($op) {
	case "viewactu":
		viewactu($sid);
		break;
	case "listeactus":
	default:
		listactus($new_topic);
		break;
}

?>