(function() {
var GOOGLE_PLUS_SCRIPT_URL = 'https://apis.google.com/js/client:plusone.js';
var CHANNELS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/channels';
var VIDEOS_UPLOAD_SERVICE_URL = 'https://www.googleapis.com/upload/youtube/v3/videos?uploadType=resumable&part=snippet,status';
var VIDEOS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/videos';
var CHANNELS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/channels';
var PLAYLISTS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/playlists';
var INITIAL_STATUS_POLLING_INTERVAL_MS = 15 * 1000;
var playlistId;
var channelId;

function initiateUpload(e) {
	e.preventDefault();
	getChannel();
	/*var selectElmt = document.getElementById("cat");
	var tab = selectElmt.options[selectElmt.selectedIndex].text.split("/");
	var cat = tab[tab.length-1];
	createPlaylist(cat, "test description", 'private');*/
}

function getChannel() {
	$.ajax({
		url: CHANNELS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			mine: true
		}
	}).done(function(response) {
		if( response.items.length == 1 ) {
			channelId = response.items[0].id;
			getPlayLists();
		}
	});
}

function getPlayLists() {
	var selectElmt = document.getElementById("cat");
	var tab = selectElmt.options[selectElmt.selectedIndex].text.split("/");
	var cat = "";
	if(tab.length > 1) {
		tab.shift();
		cat = tab.join(" / ");
	} else {
		cat = tab[0];
	}
	$.ajax({
		url: PLAYLISTS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			maxResults: 50,
			channelId: channelId,
			snippet: {
				title: cat
			}
		}
	}).done(function(response) {
		//alert(JSON.stringify(response));
		
		var existe = false;
		if( response ) {
			for(var i = 0; i < response.items.length; i++) {
				var title = response.items[i].snippet.title;
				if( title == cat ) {
					playlistId = response.items[i].id;
					existe = true;
					break;
				}
			}
		}
		if( existe ) {
			uploadVideo();
		} else {
			createPlaylist(cat, "", 'public');
		}
	});
}

function uploadVideo() {
	var file = $('#file').get(0).files[0];
	if (file) {
		$('#submit_btn').attr('disabled', true);

		var metadata = {
			snippet: {
				title: $('#title').val(),
				description: $('#description_youtube').val(),
				tags: $('#tags').val().split(",")
			},
			status: {
				privacyStatus: $('#status').val()
			}
		};

		$.ajax({
			url: VIDEOS_UPLOAD_SERVICE_URL,
			method: 'POST',
			contentType: 'application/json',
			headers: {
				Authorization: 'Bearer ' + accessToken,
				'x-upload-content-length': file.size,
				'x-upload-content-type': file.type
			},
			data: JSON.stringify(metadata)
		}).done(function(data, textStatus, jqXHR) {
			resumableUpload({
				url: jqXHR.getResponseHeader('Location'),
				file: file,
				start: 0
			});
		});
	}
}

function resumableUpload(options) {
	var ajax = $.ajax({
		url: options.url,
		method: 'PUT',
		contentType: options.file.type,
  		headers: {
  			'Content-Range': 'bytes ' + options.start + '-' + (options.file.size - 1) + '/' + options.file.size
  		},
  		xhr: function() {
  			var xhr = $.ajaxSettings.xhr();

  			if (xhr.upload) {
  				xhr.upload.addEventListener(
  					'progress',
  					function(e) {
  						if(e.lengthComputable) {
  							var bytesTransferred = e.loaded;
  							var totalBytes = e.total;
  							var percentage = Math.round(100 * bytesTransferred / totalBytes);

  							$('#upload-progress').attr({
  								value: bytesTransferred,
  								max: totalBytes
  							});

  							$('#percent-transferred').text(percentage);
  							$('#bytes-transferred').text(bytesTransferred);
  							$('#total-bytes').text(totalBytes);

  							$('.during-upload').show();
  						}
  					},
  					false
  				);
  			}

  			return xhr;
  		},
  		processData: false,
  		data: options.file
  	});

	ajax.done(function(response) {
		var videoId = response.id;
		$('#id_video').val(videoId);
    	//checkVideoStatus(videoId);
		addToPlaylist(videoId);
    	document.forms['theForm'].submit();
    });

	ajax.fail(function() {
		$('#submit_btn').click(function() {
			alert('Not yet implemented!');
		});
		$('#submit_btn').val('Resume Upload');
		$('#submit_btn').attr('disabled', false);
	});
}

function checkVideoStatus(videoId) {
	$.ajax({
		url: VIDEOS_SERVICE_URL,
		method: 'GET',
    	headers: {
    		Authorization: 'Bearer ' + accessToken
    	},
    	data: {
    		part: 'status,fileDetails',
    		id: videoId
    	}
	}).done(function(response) {
		alert(JSON.stringify(response));
		var fileSize = response.fileDetails.fileSize;
		alert(fileSize);
   	});
}

function createPlaylist(title, description, status) {
	var request = gapi.client.youtube.playlists.insert({
		part: 'snippet,status',
		resource: {
			snippet: {
				title: title,
				description: description
			},
			status: {
				privacyStatus: status
			}
		}
	});
	request.execute(function(response) {
		var result = response.result;
		if (result) {
			playlistId = result.id;
			uploadVideo();
		} else {
			
		}
	});
}

function addToPlaylist(id, startPos, endPos) {
	var details = {
		videoId: id,
	    kind: 'youtube#video'
	}
	if (startPos != undefined) {
		details['startAt'] = startPos;
	}
	if (endPos != undefined) {
		details['endAt'] = endPos;
	}
	var request = gapi.client.youtube.playlistItems.insert({
		part: 'snippet',
	    resource: {
	    	snippet: {
	    		playlistId: playlistId,
	    		resourceId: details
	    	}
	    }
	});
	request.execute(function(response) {
		
	});
}


$(function() {
	$.getScript(GOOGLE_PLUS_SCRIPT_URL);
	$('#submit_btn').click(initiateUpload);
  });
})();