<?php
/************************************************************************/
/* PHP-NUKE: Advanced Content Management System                         */
/* ============================================                         */
/*                                                                      */
/* Module Calendirer                                                    */
/* Copyright (c) 2002, 2003                                             */
/* Modifications et Amliorations par Amine Laurent BENKHOUCHA		*/
/* http://phpnuke-france.org						*/
/*									*/
/*									*/
/* Version Amliore de Event Calendar version 2.0			*/
/* D'aprs les travaux de Rob Sutton et Aleks A.Lessmann		*/
/* Prefix and minor bugfixes by                         		*/
/* fsz dESIGN & maaX dESIGN                             		*/
/* http://www.fsz-design.de  http://www.maax-design.de  		*/
/*									*/
/*									*/
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

$allowanonymous = 1;
$module_name = basename(dirname(__FILE__));

include("modules/$module_name/config.php");

/********************************************************/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("Erreur: Vous ne pouvez pas accder directement  ce fichier...");
}

$wysiwygEditor="fckeditor"; // must be set in preferences
include("javascripts/$wysiwygEditor/$wysiwygEditor.php");

function buildMonthSelect($month) {
	for ($i = 1; $i <= 12; $i++) {
		if ($i == $month) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i</option>\n";
	}
}

function buildDaySelect($day) {
	for ($i = 1; $i <= 31; $i++) {
		if ($i == $day) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i</option>\n";
	}
}

function buildYearSelect($year) {
	for ($i = 2001; $i <= 2030; $i++) {
		if ($i == $year) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i</option>\n";
	}
}

function buildHourSelect($hour) {
	global $time24Hour;
	if (!($time24Hour)) {
		for ($i = 1; $i <= 12; $i++) {
			if ($i == $hour) $sel = "SELECTED";
			else $sel = "";
			echo "<option $sel value=\"$i\">$i</option>\n";
		}
	} else {
		for ($i = 0; $i <= 23; $i++) {
			if ($i == $hour) $sel = "SELECTED";
			else $sel = "";
			echo "<option $sel value=\"$i\">";
			if ($i<10) echo "0";
			echo "$i</option>\n";
		}
	}
}

function buildMinSelect($min) {
	for ($i = 0; $i <= 45;) {
		echo $i;
		if (($i == $min) | (($i == 0) & ($min == "00"))) $sel = "SELECTED";
		else $sel = "";
		if ($i == 0) echo "<option $sel value=\"00\">:00</option>\n";
		else echo "<option $sel value=\"$i\">:$i</option>\n";
		$i = $i + 15;
	}
}

function buildAMPMSelect($ampm) {
	if ($ampm == "AM") $sel = "SELECTED";
	else $sel = "";
	echo "<option $sel value=\"AM\">AM</option>\n";
	if ($ampm == "PM") $sel = "SELECTED";
	else $sel = "";
	echo "<option $sel value=\"PM\">PM</option>\n";
}

function getTimeFormat($hour,$min,$ampm) {
	if (($ampm == "AM") & ($hour == "12")) {
		$hour = "00";
	} elseif (($ampm == "PM") & ($hour != "12")) {
		$hour = 12 + $hour;
	}
	$time = "$hour:$min:00";
	return $time;
}

function printJavaScript() {
	echo "<script>
          function verify() {
                var msg = \""._CALVALIDERRORMSG."\\n__________________________________________________\\n\\n\";
                var errors = \"FALSE\";
                var starthour;
                var endhour;
                var startampm;
                var endampm;
                eventDate = new Date(document.calendar.month.options[document.calendar.month.selectedIndex].value +\"/\"+ document.calendar.day.options[document.calendar.day.selectedIndex].value+\"/\"+document.calendar.year.options[document.calendar.year.selectedIndex].value);
                endDate = new Date(document.calendar.endmonth.options[document.calendar.endmonth.selectedIndex].value + \"/\" + document.calendar.endday.options[document.calendar.endday.selectedIndex].value + \"/\" + document.calendar.endyear.options[document.calendar.endyear.selectedIndex].value);

                if (document.calendar.subject.value == \"\") {
                        errors = \"TRUE\";
                        msg += \""._CALVALIDSUBJECT."\\n\";
                }
                if (eventDate.getMonth()+1 != document.calendar.month.options[document.calendar.month.selectedIndex].value) {
                        errors = \"TRUE\";
                        msg += \"** "._CALVALIDEVENTDATE."\\n\";
                }
                if (endDate.getMonth()+1 != document.calendar.endmonth.options[document.calendar.endmonth.selectedIndex].value) {
                        errors = \"TRUE\";
                        msg += \"** "._CALVALIDENDDATE."\\n\";
                }
                if (endDate.getTime() < eventDate.getTime()) {
                        errors = \"TRUE\";
                        msg += \"** "._CALVALIDDATES."\\n\";
                }
                if (errors == \"TRUE\") {
                        msg += \"__________________________________________________\\n\\n"._CALVALIDFIXMSG."\\n\";
                        alert(msg);
                        return false;
                }
          }
          </script>";
}


function defaultDisplay($type) {
	global $AllowableHTML,$module_name,$time24Hour,$useInternationalDates,$caldotcolorred,$caldotcolorgreen,$caldotcolorblue,$caldotcolorwhite,$caldotcoloryellow;
	include ('header.php');
	global $user, $cookie, $anonymous, $db, $prefix;
	printJavaScript();
	echo "<h1>"._CALSUBMITNAME."</h1>";
	echo "<p>"._CALSUBMITADVICE."<br />&nbsp;</p>";

	if (is_user($user)) getusrinfo($user);
	echo "<script type=\"text/javascript\" src=\"javascripts/fckeditor/fckeditor.js\"></script>
		<script type=\"text/javascript\" src=\"javascripts/initfck.js\"></script>";
	
	//    include('functions.php');
	echo "<form onSubmit=\"return verify();\" action=\"modules.php?op=modload&amp;name=".$module_name."&amp;file=submit\" method=\"post\" NAME=\"calendar\">";
	echo "<table class=\"saisieevent\" border=\"0\" cellpaddin=\"0\" cellspacing=\"0\" align=\"center\">";
	echo "<tr><th>"._CALYOURNAME."</th><td>";
	if (is_user($user)) {
		cookiedecode($user);
		//echo "<a href=\"modules.php?name=Your_Account\">$cookie[1]</a> [ <a href=\"modules.php?name=Your_Account&amp;op=logout\">"._CALLOGOUT."</a> ]";
		echo "<a href=\"modules.php?name=Your_Account\">$cookie[1]</a>";
	}
	else {
		echo "$anonymous [ <a href=\"modules.php?name=Your_Account\">"._NEWUSER."</a> ]";
	}
	echo "</td></tr>";

	echo "<tr>";
	echo "<th>"._CALBEDESCRIPTIVE."</th>"
	."<td><input type=\"text\" name=\"subject\" size=\"50\" maxlength=\"80\" id=\"zsubject\">"
	."</td></tr>";
	echo "<tr>";
	echo "<th>"._CALTOPIC."</th><td><select name=\"topic\" id=\"ztopic\">";
	$toplist = $db->sql_query("select topicid, topictext from $prefix"._topics." order by topictext");
	echo "<option value=\"\">"._CALSELECTTOPIC."</option>\n";
	while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
		if ($topicid==$topic) {
			$sel = "selected ";
		}
		echo "<option $sel value=\"$topicid\">$topics</option>\n";
		$sel = "";
	}
	$Date = Date("m/d/Y");
	$Date_Array = explode("/", $Date);

	echo "</select></td></tr>";

	echo "<tr>";
	echo "<th>"._CALEVENTDATETEXT."</th>";
	echo "<td>";
	if ($useInternationalDates) {
		echo "<select name=\"day\" class=\"selects\">";
		buildDaySelect($Date_Array[1]);
		echo "</select>
                <select name=\"month\" class=\"selects\">";
		buildMonthSelect($Date_Array[0]);
		echo "</select>";
	}
	else {
		echo "<select name=\"month\" class=\"selects\">";
		buildMonthSelect($Date_Array[0]);
		echo "</select>
                <select name=\"day\">";
		buildDaySelect($Date_Array[1]);
		echo "</select>";
	}
	echo " <select name=\"year\" class=\"selects\">";
	buildYearSelect($Date_Array[2]);
	echo "</select></td></tr>";
	echo "<tr>";
	echo "<th>"._CALENDDATETEXT."</th>";
	echo "<td>";
	if ($useInternationalDates) {
		echo "<select name=\"endday\" class=\"selects\">";
		buildDaySelect($Date_Array[1]);
		echo "</select>
          <select name=\"endmonth\" class=\"selects\">";
		buildMonthSelect($Date_Array[0]);
		echo "</select>";
	}
	else {
		echo "<select name=\"endmonth\" class=\"selects\">";
		buildMonthSelect($Date_Array[0]);
		echo "</select>
          <select name=\"endday\" class=\"selects\">";
		buildDaySelect($Date_Array[1]);
		echo "</select>";
	}
	echo " <select name=\"endyear\" class=\"selects\">";
	buildYearSelect($Date_Array[2]);
	echo "</select>";
	echo "</td></tr>";
	echo "<tr>";
	echo "<th>"._CALSTARTTIME."</th>";
	echo "<td>";
	echo "<select name=\"startHour\" class=\"selects\">";
	buildHourSelect(9);
	echo "</select>
          <select name=\"startMin\" class=\"selects\">";
	buildMinSelect(0);
	echo "</select>";
	if (!($time24Hour)) {
		echo "<select name=\"startampm\" class=\"selects\">";
		buildAMPMSelect("AM");
		echo "</select>";
	}
	echo "</td></tr>";
	echo "<tr>";
	echo "<th>"._CALENDTIME."</th>";
	echo "<td>";
	echo "<select name=\"endHour\" class=\"selects\">";
	buildHourSelect(11);
	echo "</select>
          <select name=\"endMin\" class=\"selects\">";
	buildMinSelect(0);
	echo "</select>";
	if (!($time24Hour)) {
		echo "<select name=\"endampm\" class=\"selects\">";
		buildAMPMSelect("AM");
		echo "</select>";
	}
	echo "</td></tr>";
	echo "<tr>";
	echo "<th></th>";
	echo "<td>";
	echo "<input name=\"alldayevent\" type=\"checkbox\" value=\"1\" id=\"alldayevent\">&nbsp;<b><label for=\"alldayevent\">"._CALALLDAYEVENT."</label></b><br>
          ("._CALTIMEIGNORED.")";
	echo "</td></tr>";
	echo "<tr>";
	echo "<th>"._CALSUBSCRIPTION."</th>";
	echo "<td>";
	echo "<input name=\"withregistration\" type=\"checkbox\" value=\"1\" id=\"withregistration\">&nbsp;<b><label for=\"withregistration\">"._CALWITHSUBCRIPTION."</label></b><br>
          ("._CALWITHSUBCRIPTIONPLUS.")";
	echo "</td></tr>";

	//    echo "<tr><th>"._CALARTICLETEXT."</th><td>
	//          ("._CALHTMLISFINE.")</td></tr>";
	//    echo "<tr><td colspan=\"2\">";
	//    echo "<textarea cols=\"50\" rows=\"12\" name=\"story\"></textarea>";
	//    echo "<br>"._CALALLOWEDHTML."<br>";
	//    while (list($key,) = each($AllowableHTML)) echo " &lt;".$key."&gt;";
	//    echo "<br>("._CALAREYOUSURE.")";
	//    echo "</td></tr>";
	//    echo "<tr>";
	//    echo "<td colspan=\"2\" style=\"text-align: center\">"._CALBARCOLORTEXT."</b>:<br>
	//          <input type=\"radio\" name=\"barcolor\" value=\"r\"><img src=\"modules/$module_name/images/ballr.gif\">&nbsp;$caldotcolorred&nbsp;&nbsp;
	//          <input type=\"radio\" CHECKED name=\"barcolor\" value=\"g\"><img src=\"modules/$module_name/images/ballg.gif\">&nbsp;$caldotcolorgreen&nbsp;&nbsp;
	//          <input type=\"radio\" name=\"barcolor\" value=\"b\"><img src=\"modules/$module_name/images/ballb.gif\">&nbsp;$caldotcolorblue&nbsp;&nbsp;
	//          <input type=\"radio\" name=\"barcolor\" value=\"w\"><img src=\"modules/$module_name/images/ballw.gif\">&nbsp;$caldotcolorwhite&nbsp;&nbsp;
	//          <input type=\"radio\" name=\"barcolor\" value=\"y\"><img src=\"modules/$module_name/images/bally.gif\">&nbsp;$caldotcoloryellow
	//          </td></tr>";
	//    echo "<tr>";
	echo "</table>";

	echo "<div class=\"dimztexte\">";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"saisieevent\" align=\"center\">";
	echo "<tr><th>"._CALARTICLETEXT."</th><td>"._CALHTMLISFINE."</td></tr>";
	echo "</table>";
	echo "<div class=\"encadreedit\"><textarea id=\"eventcontent\"cols=\"70\" rows=\"30\" name=\"story\" style=\"width: 100%\"></textarea><script type=\"text/javascript\">editSix(\"eventcontent\");</script></div>";
	echo "<div class=\"colorevent\">&nbsp;<br><b>"._CALBARCOLORTEXT."</b><br>
	<input type=\"radio\" name=\"barcolor\" value=\"r\" id=\"coul1\"><label for=\"coul1\"><img src=\"modules/$module_name/images/ballr.gif\">&nbsp;$caldotcolorred&nbsp;&nbsp;</label>
	<input type=\"radio\" name=\"barcolor\" value=\"g\" id=\"coul2\"><label for=\"coul2\"><img src=\"modules/$module_name/images/ballg.gif\">&nbsp;$caldotcolorgreen&nbsp;&nbsp;</label>
	<input type=\"radio\" name=\"barcolor\" value=\"b\" id=\"coul3\"><label for=\"coul3\"><img src=\"modules/$module_name/images/ballb.gif\">&nbsp;$caldotcolorblue&nbsp;&nbsp;</label>
	<input type=\"radio\" name=\"barcolor\" value=\"w\" id=\"coul4\"><label for=\"coul4\"><img src=\"modules/$module_name/images/ballw.gif\">&nbsp;$caldotcolorwhite&nbsp;&nbsp;</label>
	<input type=\"radio\" name=\"barcolor\" value=\"y\" id=\"coul5\"><label for=\"coul5\"><img src=\"modules/$module_name/images/bally.gif\">&nbsp;$caldotcoloryellow"."</label></div>";
	echo "</div>";


	echo "<div class=\"colorevent\">&nbsp;<br /><br /><input type=\"hidden\" name=\"type\" value=\"$type\">
	<input type=\"submit\" name=\"op2\" value=\""._CALSUBMITPREVIEW."\"> <br>("._CALSUBPREVIEW.")</div></form>";

	include ('footer.php');
}

function PreviewStory($name, $address, $subject, $day, $month, $year, $endday, $endmonth, $endyear, $story, $topic, $type, $startHour, $startMin, $startampm, $endHour, $endMin, $endampm, $alldayevent, $barcolor,$withregistration) {
	global $user, $cookie, $tipath, $bgcolor1, $bgcolor2, $anonymous, $module_name, $time24Hour, $useInternationalDates, $caldotcolorred, $caldotcolorgreen, $caldotcolorblue, $caldotcolorwhite, $caldotcoloryellow, $db, $prefix;
	include ('header.php');
	$subject = stripslashes(check_html($subject, "nohtml"));
	$story = stripslashes(check_html($story, ""));
	printJavaScript();

	echo "<h1>"._CALNEWSUBPREVIEW."</h1>";

	echo "<p>"._CALSTORYLOOK."</p>";
	echo "<hr class=\"event\">";

	if ($topic=="") {
		$topicimage="AllTopics.gif";
		$warning = "<center><blink><b>"._CALTOPICERROR."</b></blink></center>";
	}
	else {
		$warning = "";
		$result = $db->sql_query("select topicimage from $prefix"._topics." where topicid='$topic'");
		list($topicimage) = $db->sql_fetchrow($result);
	}
	echo "<p><img src=\"$tipath$topicimage\" border=\"0\" align=\"right\">
	<b>"._CALEVENTDATEPREVIEW."</b>
	$month/$day/$year - $startHour:$startMin</p>";
	themepreview($subject, $story);
	echo "<hr class=\"event\">";
	echo "$warning"
	."&nbsp;<br /><div class=\"colorevent\"><b>"._CALCHECKSTORY."</b></div>";

	echo "<br>";
	echo "<script type=\"text/javascript\" src=\"javascripts/fckeditor/fckeditor.js\"></script>
		<script type=\"text/javascript\" src=\"javascripts/initfck.js\"></script>";
	echo "<form onSubmit=\"return verify();\" action=\"modules.php?op=modload&amp;name=".$module_name."&amp;file=submit\" method=\"post\" NAME=\"calendar\">";
	echo "<table class=\"saisieevent\" border=\"0\" cellpaddin=\"0\" cellspacing=\"0\">";
	echo "<tr><th>"._CALYOURNAME."</th><td>";
	if (is_user($user)) {
		cookiedecode($user);
		//echo "<a href=\"modules.php?name=Your_Account\">$cookie[1]</a> [ <a href=\"modules.php?name=Your_Account&amp;op=logout\">"._CALLOGOUT."</a> ]";
		echo "<a href=\"modules.php?name=Your_Account\">$cookie[1]</a>";
	}
	else {
		echo "$anonymous";
	}
	echo "</tr>";
	echo "<tr><th>"._CALSUBTITLE.":</th>"
	."<td>"."<input type=\"text\" name=\"subject\" size=\"50\" maxlength=\"80\" value=\"$subject\" id=\"zsubject\"></td></tr>";
	echo "<tr><th>"._CALTOPIC."</th><td><select name=\"topic\" id=\"ztopic\">";
	$toplist = $db->sql_query("select topicid, topictext from $prefix"._topics." order by topictext");
	echo "<OPTION VALUE=\"\">"._CALSELECTTOPIC."</option>\n";
	while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
		if ($topicid==$topic) { $sel = "selected "; }
		echo "<option $sel value=\"$topicid\">$topics</option>\n";
		$sel = "";
	}
	echo "</select></td></tr>";
	echo "<tr><th>"._CALEVENTDATETEXT."</th><td>";
	if ($useInternationalDates) {
		echo "<select name=\"day\" class=\"selects\">";
		buildDaySelect($day);
		echo "</select>
          <select name=\"month\" class=\"selects\">";
		buildMonthSelect($month);
		echo "</select>";
	}
	else {
		echo "<select name=\"month\" class=\"selects\">";
		buildMonthSelect($month);
		echo "</select>
          <select name=\"day\" class=\"selects\">";
		buildDaySelect($day);
		echo "</select>";
	}
	echo " <select name=\"year\" class=\"selects\">";
	buildYearSelect($year);
	echo "</select>";
	echo "</td></tr>";
	echo "<tr><th>"._CALENDDATETEXT."</th><td>";
	if ($useInternationalDates) {
		echo "<select name=\"endday\" class=\"selects\">";
		buildDaySelect($endday);
		echo "</select>
          <select name=\"endmonth\" class=\"selects\">";
		buildMonthSelect($endmonth);
		echo "</select>";
	}
	else {
		echo "<select name=\"endmonth\" class=\"selects\">";
		buildMonthSelect($endmonth);
		echo "</select>
          <select name=\"endday\" class=\"selects\">";
		buildDaySelect($endday);
		echo "</select>";
	}
	echo " <select name=\"endyear\" class=\"selects\">";
	buildYearSelect($endyear);
	echo "</select>";
	echo "</td></tr>";

	echo "<tr><th>"._CALSTARTTIME."</th><td>
          <select name=\"startHour\" class=\"selects\">";
	buildHourSelect($startHour);
	echo "</select>
          <select name=\"startMin\" class=\"selects\">";
	buildMinSelect($startMin);
	echo "</select>";
	if (!($time24Hour)) {
		echo "<select name=\"startampm\" class=\"selects\">";
		buildAMPMSelect($startampm);
		echo "</select>";
	}
	echo "</td></tr>";
	echo "<tr><th>"._CALENDTIME."</th><td>
          <select name=\"endHour\" class=\"selects\">";
	buildHourSelect($endHour);
	echo "</select>
          <select name=\"endMin\" class=\"selects\">";
	buildMinSelect($endMin);
	echo "</select>";
	if (!($time24Hour)) {
		echo "<select name=\"endampm\" class=\"selects\">";
		buildAMPMSelect($endampm);
		echo "</select>";
	}
	$check = "";
	if ($alldayevent == "1") {
		$check = "CHECKED=TRUE";
	}
	echo "</td></tr>";
	echo "<tr><th></th><td><input name=\"alldayevent\" $check type=\"checkbox\" value=\"1\" id=\"alldayevent\">&nbsp;<b><label for=\"alldayevent\">"._CALALLDAYEVENT."</b><br />
          ("._CALTIMEIGNORED.")</td></tr>";
	
	$check = "";
	if ($withregistration == "1") {
		$check = "CHECKED=TRUE";
	}
	echo "<tr>";
	echo "<th>"._CALSUBSCRIPTION."</th>";
	echo "<td>";
	echo "<input name=\"withregistration\" $check type=\"checkbox\" value=\"1\" id=\"withregistration\">&nbsp;<b><label for=\"withregistration\">"._CALWITHSUBCRIPTION."</b><br>
          ("._CALWITHSUBCRIPTIONPLUS.")";
	echo "</td></tr>";

	echo "</table>";
	
	echo "<div class=\"dimztexte\">";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"saisieevent\">";
	echo "<tr><th>"._CALARTICLETEXT."</th><td>"._CALHTMLISFINE."</td></tr>";
	echo "</table>";
	echo "<div class=\"encadreedit\"><textarea id=\"eventcontent\" cols=\"70\" rows=\"30\" name=\"story\" style=\"width: 100%\">".$story."</textarea><script type=\"text/javascript\">editSix(\"eventcontent\");</script></div>";
	echo "<div class=\"colorevent\">&nbsp;<br><b>"._CALBARCOLORTEXT."</b><br>";
	if ($barcolor=="r") $sel="checked=\"checked\""; else $sel="";
	echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"r\" id=\"coul1\"><label for=\"coul1\"><img src=\"modules/$module_name/images/ballr.gif\">&nbsp;$caldotcolorred&nbsp;&nbsp;</label>";
	if ($barcolor=="g") $sel="checked=\"checked\""; else $sel="";
	echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"g\" id=\"coul2\"><label for=\"coul2\"><img src=\"modules/$module_name/images/ballg.gif\">&nbsp;$caldotcolorgreen&nbsp;&nbsp;</label>";
	if ($barcolor=="b") $sel="checked=\"checked\""; else $sel="";
	echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"b\" id=\"coul3\"><label for=\"coul3\"><img src=\"modules/$module_name/images/ballb.gif\">&nbsp;$caldotcolorblue&nbsp;&nbsp;</label>";
	if ($barcolor=="w") $sel="checked=\"checked\""; else $sel="";
	echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"w\" id=\"coul4\"><label for=\"coul4\"><img src=\"modules/$module_name/images/ballw.gif\">&nbsp;$caldotcolorwhite&nbsp;&nbsp;</label>";
	if ($barcolor=="y") $sel="checked=\"checked\""; else $sel="";
	echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"y\" id=\"coul5\"><label for=\"coul5\"><img src=\"modules/$module_name/images/bally.gif\">&nbsp;$caldotcoloryellow"."</div></label>";
	echo "</div>";

	echo "<div class=\"colorevent\">&nbsp;<br /><br /><input type=\"hidden\" name=\"type\" value=\"$type\">
	<input type=\"submit\" name=\"op2\" value=\""._CALSUBMITPREVIEW."\"> <input type=\"submit\" name=\"op2\" value=\""._CALSUBMITSEND."\"></div></form>";

	/*echo "<br><br><b>"._CALBARCOLORTEXT."</b>:<br>";
	 if ($barcolor=="r") $sel="CHECKED"; else $sel="";
	 echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"r\"><img src=\"modules/$module_name/images/ballr.gif\">&nbsp;$caldotcolorred&nbsp;&nbsp;";
	 if ($barcolor=="g") $sel="CHECKED"; else $sel="";
	 echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"g\"><img src=\"modules/$module_name/images/ballg.gif\">&nbsp;$caldotcolorgreen&nbsp;&nbsp;";
	 if ($barcolor=="b") $sel="CHECKED"; else $sel="";
	 echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"b\"><img src=\"modules/$module_name/images/ballb.gif\">&nbsp;$caldotcolorblue&nbsp;&nbsp;";
	 if ($barcolor=="w") $sel="CHECKED"; else $sel="";
	 echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"w\"><img src=\"modules/$module_name/images/ballw.gif\">&nbsp;$caldotcolorwhite&nbsp;&nbsp;";
	 if ($barcolor=="y") $sel="CHECKED"; else $sel="";
	 echo "<input type=\"radio\" $sel name=\"barcolor\" value=\"y\"><img src=\"modules/$module_name/images/bally.gif\">&nbsp;$caldotcoloryellow
	 <br>";
	 echo "<br><br>
	 <br><br><b>"._CALARTICLETEXT."</b>:
	 ("._CALHTMLISFINE.")<br>
	 <textarea cols=\"50\" rows=\"12\" name=\"story\">$story</textarea><br>
	 <font size=\"2\">("._CALAREYOUSURE.")</font><br><br>
	 <input type=\"hidden\" name=\"type\" value=\"$type\">
	 <input type=\"submit\" name=\"op2\" value=\""._CALSUBMITPREVIEW."\"> <input type=\"submit\" name=\"op2\" value=\""._CALSUBMITSEND."\">
	 </form>";*/

	include ('footer.php');
}

function SubmitStory($name, $address, $subject, $day, $month, $year, $endday, $endmonth, $endyear, $story, $topic, $type, $startHour, $startMin, $startampm, $endHour, $endMin, $endampm, $alldayevent, $barcolor,$withregistration) {
	global $user, $EditedMessage, $cookie, $anonymous, $notify, $notify_email, $notify_subject, $notify_message, $db, $prefix,
	$notify_from,$module_name,$time24Hour,$adminmail,$eventadminmail;

	if (is_user($user)) {
		cookiedecode($user);
		$uid = $cookie[0];
		$name = $cookie[1];
	} else {
		$uid = 1;
		$name = "$anonymous";
	}
	$subject = stripslashes(FixQuotes(check_html($subject, "nohtml")));
	$story = stripslashes(FixQuotes(check_html($story, "")));
	$newDate = "$year-$month-$day";
	$endDate = "$endyear-$endmonth-$endday";
	if ($time24Hour) {
		$startTime = "$startHour:$startMin:00";
		$endTime = "$endHour:$endMin:00";
	} else {
		$startTime = getTimeFormat($startHour,$startMin,$startampm);
		$endTime = getTimeFormat($endHour,$endMin,$endampm);
	}
	$result = $db->sql_query("insert into $prefix"._events_queue." values (NULL, '$uid', '$name', '$subject', '$story', now(), '$topic', '$newDate','$endDate','$startTime','$endTime','$alldayevent', '$barcolor', '$withregistration')");
	if(!$result) {
		die("Erreur: Base de donnes");
		exit();
	}
	else {
		//notification par e-mail au gestionaire
		if ($notify) {
			send_email($eventadminmail,$notify_email,_NEWEVENTSUB,_NEWEVENTMESS);
		}
	}

	include ('header.php');

	$result = $db->sql_query("select * from $prefix"._events_queue."");
	$waiting = $db->sql_numrows($result);

	echo "<h1>"._CALSUBSENT."</h1>";
	echo "<p>"._CALTHANKSSUB." "._CALSUBTEXT."</p>";
	echo "<p>"._CALWEHAVESUB." $waiting "._CALWAITING."</p>";

	/**** Get todays date */
	$Today_d = Date("d");
	$Today_m = Date("m");
	$Today_y = Date("Y");
	/*echo "<div align=\"center\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">
	 <tr>
	 <td rowspan=\"3\" width=\"10\" valign=\"top\"><img src=\"modules/$module_name/images/calendar.gif\"></td>
	 </tr>
	 <tr>
	 <td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">
	 <tr>
	 <td>&nbsp;&nbsp;<font size=4><b>"._CALNAME."</b></font></td>
	 <td></td>
	 </tr>
	 </table>
	 </td>
	 </tr>
	 <tr>
	 <td align=\"center\">
	 <table border=\"0\" width=\"95%\" cellpadding=\"0\" cellspacing=\"0\">
	 <tr>
	 <td width=20% valign=\"top\">
	 <strong><big></big></strong> <a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=submit\">"._CALEVENTLINK."</a><br>"*/
	echo "<form name=\"jump\">";
	echo "<h2>"._EVENTDUJOUR."</h2>
    	<select name=\"jumpmonth\">";
	buildMonthSelect($Today_m);
	echo "</select>
          <select name=\"jumpday\">";
	buildDaySelect($Today_d);
	echo "</select>
          <select name=\"jumpyear\">";
	buildYearSelect($Today_y);
	echo "</select>
         &nbsp;<input type=button value=\""._VIEWEVENTDUJOUR."\" onClick=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=' +  '&amp;Date=' + document.jump.jumpmonth.options[document.jump.jumpmonth.options.selectedIndex].value + '/' + document.jump.jumpday.options[document.jump.jumpday.options.selectedIndex].value + '/' + document.jump.jumpyear.options[document.jump.jumpyear.options.selectedIndex].value;\">";
	echo "</form>";

	include ('footer.php');
}

/**
 * Expdition d'un e-mail.
 * @param string $sender Adresse de l'expditeur de l'e-mail.
 * @param string $email Adresse d'expdition de l'e-mail.
 * @param string $subject Sujet de l'e-mail.
 * @param string $message Corps du massage  expdier.
 * @return boolean True si le message a t expdi, false sinon.
 */
function send_email($sender, $email, $subject, $message){
	// En-ttes
	$headers = "From: ".$sender."\n";
	$headers .= "X-Sender: ".$sender."\n";
	$headers .= "X-Mailer: PHP\n";
	$headers .= "X-Priority: 1\n";
	$headers .= "Return-Path: ".$sender."\n";
	$headers .= "Reply-To: ".$sender."\n";
	$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
	return mail($email, $subject, $message, $headers);
}

switch($op2) {

	case _CALSUBMITPREVIEW:
		PreviewStory($name, $address, $subject, $day, $month, $year, $endday, $endmonth, $endyear, $story, $topic, $type, $startHour, $startMin, $startampm, $endHour, $endMin, $endampm, $alldayevent, $barcolor,$withregistration);
		break;

	case _CALSUBMITSEND:
		SubmitStory($name, $address, $subject, $day, $month, $year, $endday, $endmonth, $endyear, $story, $topic, $type, $startHour, $startMin, $startampm, $endHour, $endMin, $endampm, $alldayevent, $barcolor,$withregistration);
		break;

	default:
		defaultDisplay($type);
		break;

}

?>
