<?php
//Function for ouputting the body of each RSS item displayed (inside loop)- DynamicDrive.com
//For syntax pf bpdu, see: http://simplepie.org/docs/installation/from-scratch/ and http://simplepie.org/docs/reference/
//Function by default defines 3 different body outputs (templates). Modify or add additional templates as desired

require_once("includes/truncate_string.php");

function outputbody($item, $template=""){
if ($template=="" || $template=="default"){ //DEFAULT TEMPLATE
	?>
	<DIV class="rsscontainer">
	<div class="rsstitle"><div class="rssdate"><?php echo $item->get_date(_FORMAT_DATE_RSS); ?></div><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a></div>
	<div class="rssdescription"><?php echo $item->get_description(); ?></div>
	</DIV>
	<?php
} //end default template
else if ($template=="titles"){ //"TITLES" TEMPLATE
	?>
	<DIV class="rsscontainer">
	<div class="rsstitle"><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a></div> 
	<div>Category: <?php echo $item->get_category(); ?></div>
	</DIV>
	<?php
} //end titles template
else if ($template=="titlesdates"){ //"TITLESDATES" TEMPLATE
	?>
	<DIV class="rsscontainer">
	<span class="rsstitle"><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a></span> 
	<span class="rssdate"><?php echo $item->get_date('m/d/y g:i a'); ?></span>
	</DIV>
	<?php
} //end titlesdates template
else if ($template=="titlesdatesnoimg"){ //"TITLESDATES NO IMGS" TEMPLATE
	$description = $item->get_description();
	$description = preg_replace("/(<img[^>]+>)/mi","",$description,1);
	$description = truncate_string($description,"250");
	?>
	<DIV class="rsscontainer">
	<div class="rsstitle"><div class="rssdate"><?php setlocale(LC_TIME, _FORMATLOCALE); echo strftime("%A %e %B %Y", $item->get_date(_FORMAT_DATE_RSS_DOWN)); ?></div><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a></div>
	<div class="rssdescription"><?php echo $description; ?></div>
	</DIV>
	<?php
}
else if ($template=="download"){ //DOWNLOAD TEMPLATE
	global $prefix, $db, $nukeurl,$currentlang;
	$icon_file = "";
	if (preg_match("/(&amp;|&|\\?)lid=([0-9]+)/",$item->get_permalink(),$valeurs)) {
		$result = $db->sql_query("SELECT url  FROM `becms_downloads_downloads` WHERE `lid` = ".$valeurs[2]);
		if ($db->sql_numrows($result) > 0) {
			list($urldowload) = $db->sql_fetchrow($result);
			$icon_file = get_icon_for_file($urldowload);
		}
		else {
			$icon_file = get_icon_for_file("?");
		}
	}
	if (preg_match("/(&amp;|&|\\?)sid=([0-9]+)/",$item->get_permalink())) {
		$icon_file = get_icon_for_file("news.rss");
	}
	if (preg_match("/(&amp;|&|\\?)photoid=([0-9]+)/",$item->get_permalink())) {
		$icon_file = get_icon_for_file("pict.bmp");
	}
	$icon_file = ($icon_file=="") ? get_icon_for_file("news.rss") : $icon_file;
	$description = $item->get_description();
	$description = preg_replace("/(<img[^>]+>)/mi","",$description);
	
	?>
	<DIV class="rsscontainer">
	<div class="rsstitle"><div class="rssdate"><?php setlocale(LC_TIME, _FORMATLOCALE); echo strftime("%B %Y", $item->get_date(_FORMAT_DATE_RSS_DOWN)); ?></div><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a></div>
	<div style="float: left; padding: 0 5px 0 2px"><?php echo "<img src=\"$icon_file\">"; ?></div><div class="rssdescription"><?php echo $description; ?></div>
	</DIV>
	<?php
} //end download template
else if ($template=="downloadlist"){ //DOWNLOAD TEMPLATE
	global $prefix, $db, $nukeurl,$currentlang;
	$icon_file = "";
	if (preg_match("/(&amp;|&|\\?)lid=([0-9]+)/",$item->get_permalink(),$valeurs)) {
		$result = $db->sql_query("SELECT url  FROM `becms_downloads_downloads` WHERE `lid` = ".$valeurs[2]);
		if ($db->sql_numrows($result) > 0) {
			list($urldowload) = $db->sql_fetchrow($result);
			$icon_file = get_icon_for_file($urldowload);
		}
		else {
			$icon_file = get_icon_for_file("?");
		}
	}
	if (preg_match("/(&amp;|&|\\?)sid=([0-9]+)/",$item->get_permalink())) {
		$icon_file = get_icon_for_file("news.rss");
	}
	if (preg_match("/(&amp;|&|\\?)photoid=([0-9]+)/",$item->get_permalink())) {
		$icon_file = get_icon_for_file("pict.bmp");
	}
	$icon_file = ($icon_file=="") ? get_icon_for_file("news.rss") : $icon_file;
	
	?>
	<DIV class="rsslist">
	<div class="rsstitle" style="padding-left: 25px; padding-bottom: 2px; background-image: url('<?php echo "$icon_file"; ?>'); background-repeat: no-repeat; background-position: 2px -1px;"><a href="<?php echo $item->get_permalink(); ?>" target="_new"><?php echo $item->get_title(); ?></a><span class="rssdate"> (<?php echo $item->get_date(_FORMAT_DATE_RSS); ?>)</span></div>
	</DIV>
	<?php
} //end download template
else if ($template=="videos"){
	$description = $item->get_description();
	if (preg_match("/(<img[^>]+>)/mi",$description,$tabimages)) {
		$vignette = $tabimages[1];
		$description = preg_replace("/(<img[^>]+>)/mi","",$description,1);
		preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
		$urlvignette = $taburls[1];
	}
	?>
	<DIV class="rsscontainer">
	<div style="padding-left: 90px; background-image: url('<?php echo "$urlvignette"; ?>'); background-repeat: no-repeat; background-position: 2px center;">
	<div class="rsstitle"><div class="rssdate"><?php echo $item->get_date(_FORMAT_DATE_RSS); ?></div><a href="<?php echo $item->get_permalink(); ?>"><?php echo $item->get_title(); ?></a></div>
	<div class="rssdescription" id="video_height"><?php echo $description; ?></div>
	</div>
	</DIV>
	<?php
}
else if ($template=="murimage"){
	$description = $item->get_description();
	if (preg_match("/(<img[^>]+>)/mi",$description,$tabimages)) {
		$vignette = $tabimages[1];
		$description = preg_replace("/(<img[^>]+>)/mi","",$description,1);
		preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
		$urlvignette = $taburls[1];
	}
	?>
	<DIV class="rsscontainer" style="float: left; width:84px; margin-left: 10px; height: 84px; margin-bottom: 10px; padding: 0;">
	<div class="laphoto" onclick="document.location.href='<?php echo $item->get_permalink(); ?>'" onmouseover="swapTitlePhoto(this, '<?php echo str_replace("'","\\'",$item->get_title()); ?>')" onmouseout="swapTitlePhoto(this, '')" style="cursor: pointer; background-image: url('<?php echo "$urlvignette"; ?>'); background-repeat: no-repeat; background-position: center center; width: 100%; height: 100%">
	</div>
	</DIV>
	<?php
}
else if ($template=="adherents"){
	$description = $item->get_description();
	if (preg_match("/(<img[^>]+>)/mi",$description,$tabimages)) {
		$vignette = $tabimages[1];
		$description = preg_replace("/(<img[^>]+>)/mi","",$description);
		preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
		$urlvignette = $taburls[1];
	}
	$titre = html_entity_decode($item->get_title());
	$titre = str_replace("<span>","<span class=\"classement\">",$titre);
	?>
	<div class="entreeListing">
		<div>
			<div class="contentHotel">
				<h3 class="titreListing"><a href="<?php echo $item->get_permalink(); ?>"><?php echo $titre; ?></a></h3>
				<?php echo $description; ?>
				<div align="right"><a href="<?php echo $item->get_permalink(); ?>" class="plusdinfo">Voir la fiche</a></div>
			</div>
			<a href="<?php echo $item->get_permalink(); ?>"><?php echo "<img src=\"".$urlvignette."\" class=\"photoadhs\" />"; ?></a></div>
	</div>
	<?php
}
else if ($template=="mytemplatename"){ //"mytemplatename" TEMPLATE
	?>
	//DEFINE ADDITIONAL CUSTOM TEMPLATE(s) USING SAME LOGIC STRUCTURE AS ABOVE
	//For syntax of template body, see SimplePie docs: http://simplepie.org/docs/installation/from-scratch/ and http://simplepie.org/docs/reference/
	<?php
}




else
die ("No template exists with such name!");
} //Closing function bracket
?>