/**
* Librairie permettant le lancement de fonctions javascript sur le chargement d'une page.
*
* usage : dans le fichier principal, appeler cette librairie puis faire des appels 
* addToStart et addToStop pour y ajouter les fonctions  dlencher.
*
* exemple :
* function message(){
*  alert("Message  afficher");
* }
* addToStart(message); //appel de fonction sans paramtre
* addToStart("alert('2eme message')"); //appel de fonction avec paramtre
*
* @package becmsSimpleCarto
* @version 1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

//if(typeof addToStart != 'function') {
	/**
	* Ajoute une fonction  la pile des fonctions  lancer sur le chargement d'une page
	* @param string fnc Nom de la fonction  ajouter
	*/
	function addToStart(fnc){
	  if(!window.listStart) window.listStart = new Array();
	  window.listStart.push(fnc);
	}
	/**
	* Excute une  une toutes les fonctions entres dans la pile des fonctions  lancer sur le chargement d'une page
	* Cette fonction est dclenche automatiquement dans l'vnement "onload" de la page HTML
	*/
	function start(){
	  var ls = window.listStart;
	  if(ls){
	    for(i=0; i<ls.length; i++){
	      fnc = ls[i];
	      if(typeof(fnc) == 'function'){
	        fnc();
	      } else {
	        eval(fnc);
	      }
	    }
	  }
	}
	
	window.onload = start;
	
	/**
	* Ajoute une fonction  la pile des fonctions  lancer sur la fermeture d'une page
	* @param string fnc Nom de la fonction  ajouter
	*/
	function addToStop(fnc){
	  if(!window.listStop) window.listStop = new Array();
	  window.listStop.push(fnc);
	}
	/**
	* Excute une  une toutes les fonctions entres dans la pile des fonctions  lancer sur la fermeture d'une page
	* Cette fonction est dclenche automatiquement dans l'vnement "onunload" de la page HTML
	*/
	function stop(){
	  var ls = window.listStop;
	  if(ls){
	    for(i=0; i<ls.length; i++){
	      fnc = ls[i];
	      if(typeof(fnc) == 'function'){
	        fnc();
	      } else {
	        eval(fnc);
	      }
	    }
	  }
	}
	
	window.onunload = stop;
//}