<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */                                           
/*                                                                      */
/************************************************************************/
/* 
* parseHtml.php 
* Author: Stephan Acquatella
* Email: stephan.acquatella@free.fr 
* 
* 
* What it does: 
* - parses a html string and get the value ecapsulated inside special string.
* - hierachy inside tag is not yet managed.
* - At the end, the array will look like this: 
*      ["<img src='zozo'>"][0] = "xxx" 
*      ["<img src='zozo'>"][1] = "xxx" 
*      ["<img src='zozo'>"][2] = "xxx" 
*      
* Usage Example:
* ---------------- 
* 	require("balisteParseHtml.php");
* 	// Example: 
* 	$str = "<html> <body>ssss<img src='zozo'>il faut beau <b>non</b> bien <li>oui</li><img src='zizi'> hshshshhsuzuz <img src='zozo'>coucouc<img src='zizi'> \n"; 
* 	$a_htmlParsed = array(); 
* 	$a_htmlParsed = parseHtml( $str, "<img src='zozo'>", "<img src='zizi'>" ); 
* 	// display result array
* 	$arr= array();
* 	foreach ( $a_htmlParsed as $key=>$elem){
* 	$arr = $elem;
* 	$mykey = $key;
*  		foreach ( $arr  as $key=>$elem){
*  		echo "$mykey - > $key=>$elem<br>";
*  		}
* 	}
*/ 
function parseHtml( $s_str, $tagStart, $tagStop ) 
{ 
$i_indicatorL = 0; 
$i_indicatorR = 0; 
$s_tagOption = ""; 
$i_arrayCounter = 0; 
$a_html = array(); 
// Search for a tag in string
if (is_int($i_indicatorL=strpos($s_str,$tagStart,$i_indicatorR))){
		    $i_indicatorL=$i_indicatorL+strlen($tagStart);
			}
//echo "L=".$i_indicatorL;
while( is_int($i_indicatorL)) { 
         // Get everything into tag...
         //$i_indicatorL++; 
         $i_indicatorR = strpos($s_str,$tagStop, $i_indicatorL-1); 
		 //echo "R=".$i_indicatorR;
         $s_temp = substr($s_str, $i_indicatorL, ($i_indicatorR-$i_indicatorL) );
		 $i_indicatorR=$i_indicatorR+strlen($tagStop);
		 //echo "R2=".$i_indicatorR;
		 
		 if (is_int($i_indicatorL=strpos($s_str,$tagStart,$i_indicatorR))){
		    $i_indicatorL=$i_indicatorL+strlen($tagStart);
			}
		 //echo "L2=".$i_indicatorL;
		 // add in array
		 $a_html[$tagStart][$i_arrayCounter]=$s_temp;
		 $i_arrayCounter++;
		 
} 
return $a_html; 
} 

?> 
