<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/* Pour tenir compte du problme avec Ubuntu/Debian */
if(!function_exists("imageantialias")){
	function imageantialias($ressource, $bool){
	}
}

/**
 * iptc_field()
 * return itpc code associated text
 * @param string iptc code
 * @return String associated code
 */
function iptc_field( $iptccode ){
// ref http://www.controlledvocabulary.com/pdf/IPTC_mapped_fields.pdf
	$myiptcarray=array( 
	"2#005"=> "Title",
	"2#010"=> "Urgency",
	"2#015"=> "Category",
	"2#020"=> "Supp_Categories",
	"2#025"=> "Keywords",
	"2#040"=> "Special Instruction",
	"2#055"=> "Date Created",
	"2#080"=> "Author",
	"2#085"=> "Author Position",
	"2#090"=> "City",
	"2#095"=> "State/Province",
	"2#101"=> "Country",
	"2#103"=> "Original Transmission Reference",
	"2#105"=> "Headline",
	"2#110"=> "Credit",
	"2#115"=> "Source",
	"2#116"=> "Copyright",
	"2#120"=> "Caption/Abstract",
	"2#122"=> "Writer/Editor");	
return 	$myiptcarray[$iptccode];
	
}
/**
 * output_iptc_data()
 * find iptc data inside an image
 * @tutorial 
 * $itptc=output_iptc_data( $image_path )  
 * if ($iptc){
 *  foreach (array_keys($iptc) as $s) {          
 * $c          = count  ($iptc  [$s]);
 *            for           ($i=0; $i <$c;
 * $i++)             {  echo $s.' = '.$iptc[$s] [$i].'<br>';           }  } }
 * @param string image_path Image path
 * @return string false if no iptc data else return an Array
 */
function output_iptc_data( $image_path ) {   
   $size = getimagesize( $image_path, $info);       
     if(is_array($info)) {   
       $iptc = iptcparse($info["APP13"]);
       return  $iptc;  
     }else {
     	return false;
     }           
}

/**
* imgResizer()
*
* It is an adapted version of http://sneak.co.nz/2006/10/27/dynamic-image-resizing/
* which is itself an improvement of the original script from
* Timothy Crowe's 'veryraw' website, with caching additions added by Trent Davies:
* http://veryraw.com/history/2005/03/image-resizing-with-php/
* @param string image url
* @param integer max width
* @param integer max height
* @return image stream
*/
function imgResizer($imgfile,$mmax_width,$mmax_height){
global $trace;
$max_height = 1024;
$max_width = 2048;
//$trace->trace("$imgfile");
if (isset($imgfile))
{
	$image = $imgfile;
	if (isset($mmax_width) && $mmax_width > 0 ) { $max_width = $mmax_width; }
	if (isset($mmax_height) && $mmax_height > 0) { $max_height = $mmax_height; }
	
	if (strrchr($image, '/')) {
		$filename = substr(strrchr($image, '/'), 1); // remove folder references
	} else {
		$filename = $image;
	}
	
	$size = getimagesize($image);
	$width = $size[0];
	$height = $size[1];
	
	// get the ratio needed
	$x_ratio = $max_width / $width;
	$y_ratio = $max_height / $height;
	
	// if image already meets criteria, load current values in
	// if not, use ratios to load new size info
	if (($width <= $max_width) && ($height <= $max_height) ) {
		$tn_width = $width;
		$tn_height = $height;
	} else if (($x_ratio * $height) < $max_height) {
		$tn_height = ceil($x_ratio * $height);
		$tn_width = $max_width;
	} else {
		$tn_width = ceil($y_ratio * $width);
		$tn_height = $max_height;
	}
	
	/* Caching additions by Trent Davies */
	// first check cache
	// cache must be world-readable
	$resized = 'catalog_repository/uploads/tmp/'.$tn_width.'x'.$tn_height.'-'.$filename;
	$imageModified = @filemtime($image);
	$thumbModified = @filemtime($resized);
	
	//$trace->trace("$resized");
	
	header("Content-type: image/jpeg");
	
	// if thumbnail is newer than image then output cached thumbnail and exit
	if($imageModified<$thumbModified) {
		header("Last-Modified: ".gmdate("D, d M Y H:i:s",$thumbModified)." GMT");
		readfile($resized);
		exit;
	}
	
	// read image
	$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
	//$trace->trace("$ext");
	switch ($ext) { 
		case 'jpeg':
		case 'jpg':     // jpg
			$src = imagecreatefromjpeg($image) or notfound();
			break;
		case 'png':     // png
			$src = imagecreatefrompng($image) or notfound();
			break;
		case 'gif':     // gif
			$src = imagecreatefromgif($image) or notfound();
			break;
		default:
			notfound();
	}
	
	// set up canvas
	$dst = imagecreatetruecolor($tn_width,$tn_height);
	
	imageantialias($dst, on); //only for true color without alpha
	
	// copy resized image to new canvas
	imagecopyresampled ($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
	
	/* Sharpening adddition by Mike Harding */
	// sharpen the image (only available in PHP5.1)
	/*if (function_exists("imageconvolution")) {
		$matrix = array(    array( -1, -1, -1 ),
	                    array( -1, 32, -1 ),
	                    array( -1, -1, -1 ) );
		$divisor = 24;
		$offset = 0;
	
		imageconvolution($dst, $matrix, $divisor, $offset);
	}*/
	
	// send the header and new image
	$resultOne=imagejpeg($dst, null, 90);
	$resultTwo=imagejpeg($dst, $resized, 90); // write the thumbnail to cache as well...
	
	//if ($resultOne) $trace->trace("One :: OK");
	//if ($resultTwo) $trace->trace("Two :: OK");
	
	// clear out the resources
	imagedestroy($src);
	imagedestroy($dst);
 }
}

function imgResizerWatermark($imgfile,$mmax_width,$mmax_height){
global $trace, $Default_Theme, $galleryfilewatermak;
$max_height = 1024;
$max_width = 2048;

//$trace->trace("$imgfile");
if (isset($imgfile))
{
	$image = $imgfile;
	if (isset($mmax_width) && $mmax_width > 0 ) { $max_width = $mmax_width; }
	if (isset($mmax_height) && $mmax_height > 0) { $max_height = $mmax_height; }
	
	if (strrchr($image, '/')) {
		$filename = substr(strrchr($image, '/'), 1); // remove folder references
	} else {
		$filename = $image;
	}
	
	$size = getimagesize($image);
	$width = $size[0];
	$height = $size[1];
	
	// get the ratio needed
	$x_ratio = $max_width / $width;
	$y_ratio = $max_height / $height;
	
	// if image already meets criteria, load current values in
	// if not, use ratios to load new size info
	if (($width <= $max_width) && ($height <= $max_height) ) {
		$tn_width = $width;
		$tn_height = $height;
	} else if (($x_ratio * $height) < $max_height) {
		$tn_height = ceil($x_ratio * $height);
		$tn_width = $max_width;
	} else {
		$tn_width = ceil($y_ratio * $width);
		$tn_height = $max_height;
	}
	
	/* Caching additions by Trent Davies */
	// first check cache
	// cache must be world-readable
	$resized = 'catalog_repository/uploads/tmp/'.$tn_width.'x'.$tn_height.'-w-'.$filename;
	$imageModified = @filemtime($image);
	$thumbModified = @filemtime($resized);
	
	//$trace->trace("$resized");
	
	header("Content-type: image/jpeg");
	
	// if thumbnail is newer than image then output cached thumbnail and exit
	if($imageModified<$thumbModified) {
		header("Last-Modified: ".gmdate("D, d M Y H:i:s",$thumbModified)." GMT");
		readfile($resized);
		exit;
	}
	
	// read image
	$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
	//$trace->trace("$ext");
	switch ($ext) { 
		case 'jpeg':
		case 'jpg':     // jpg
			$src = imagecreatefromjpeg($image) or notfound();
			break;
		case 'png':     // png
			$src = imagecreatefrompng($image) or notfound();
			break;
		case 'gif':     // gif
			$src = imagecreatefromgif($image) or notfound();
			break;
		default:
			notfound();
	}
	
	// set up canvas
	$dst = imagecreatetruecolor($tn_width,$tn_height);
	
	imageantialias($dst, on); //only for true color without alpha
	
	// copy resized image to new canvas
	imagecopyresampled ($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
	
	// recup watermak ! PNG obligatoire !!!
	//$watermak_file = 'themes/'.$Default_Theme.'/images/watermark.png';
	$watermak_file = $galleryfilewatermak;
	if ($watermak_file != "") {
		/*
		// premire solution : le watermark est lastique et colle aux bords de la photo
		$watermark = imagecreatefrompng($watermak_file) or notfound();
		$size = getimagesize($watermak_file);
		$width_watermark = $size[0];
		$height_watermark = $size[1];
		imagecopyresampled($dst,$watermark,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width_watermark, $height_watermark);
		*/
		// seconde solution : le watermark est mis  l'chelle proportionellement et est appliqu centr
		$watermark = imagecreatefrompng($watermak_file) or notfound();
		$size = getimagesize($watermak_file);
		$width_watermark = $size[0];
		$height_watermark = $size[1];
		
		$x_ratio = $tn_width / $width_watermark;
		$y_ratio = $tn_height / $height_watermark;
		
		$ratio = max($x_ratio,$y_ratio);
	
		$width_watermark_scale = ceil($ratio * $width_watermark);
		$height_watermark_scale = ceil($ratio * $height_watermark);
		
		$delta_x = floor(($tn_width - $width_watermark_scale)/2);
		$delta_y = floor(($tn_height - $height_watermark_scale)/2);
		
		imagecopyresampled($dst,$watermark,$delta_x,$delta_y,0,0,$width_watermark_scale, $height_watermark_scale, $width_watermark, $height_watermark);	
	}
	
	/* Sharpening adddition by Mike Harding */
	// sharpen the image (only available in PHP5.1)
	/*if (function_exists("imageconvolution")) {
		$matrix = array(    array( -1, -1, -1 ),
	                    array( -1, 32, -1 ),
	                    array( -1, -1, -1 ) );
		$divisor = 24;
		$offset = 0;
	
		imageconvolution($dst, $matrix, $divisor, $offset);
	}*/
	
	// send the header and new image
	$resultOne=imagejpeg($dst, null, 90);
	$resultTwo=imagejpeg($dst, $resized, 90); // write the thumbnail to cache as well...
	
	//if ($resultOne) $trace->trace("One :: OK");
	//if ($resultTwo) $trace->trace("Two :: OK");
	
	// clear out the resources
	imagedestroy($src);
	imagedestroy($dst);
 }
}

function imgCropper($imgfile,$mmax_width,$mmax_height){
	global $trace;
	/*$max_height = 1000;
	$max_width = 2000;
	//$trace->trace("$imgfile");
	if (isset($imgfile)) {
		$image = $imgfile;
		if (isset($mmax_width)) { if($mmax_width < 2000) $max_width = $mmax_width; }
		if (isset($mmax_height)) { if($mmax_height < 1000) $max_height = $mmax_height; }
		
		if (strrchr($image, '/')) {
			$filename = substr(strrchr($image, '/'), 1); // remove folder references
		} else {
			$filename = $image;
		}
		
		$size = getimagesize($image);
		$width = $size[0];
		$height = $size[1];
		
		$x_ratio = $max_width / $width;
		$y_ratio = $max_height / $height;
		
		if (($width <= $max_width) && ($height <= $max_height) ) {
			$tn_width = $width;
			$tn_height = $height;
		} else if (($x_ratio * $height) < $max_height) {
			$tn_height = $max_height;//ceil($x_ratio * $height);
			$tn_width = ceil($y_ratio * $width);//$max_width;
			
		} else {
			$tn_width = $max_width;//ceil($y_ratio * $width);
			$tn_height = ceil($x_ratio * $height);//$max_height;
		}
		
		$dst = imagecreatetruecolor($max_width, $max_height);

		$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
		switch ($ext) { 
			case 'jpeg':
			case 'jpg':     // jpg
				$src = imagecreatefromjpeg($image) or notfound();
				break;
			case 'png':     // png
				$src = imagecreatefrompng($image);		
				imagealphablending($src, true);
				imagealphablending($thumb, false);
				imagesavealpha($dst, true);
				//$src = imagecreatefrompng($image) or notfound();
				
				break;
			case 'gif':     // gif
				$src = imagecreatefromgif($image) or notfound();
				break;
			default:
				notfound();
		}
		imagecopyresampled($dst, $src, 0 - ($tn_width - $max_width) / 2, 0 - ($tn_height - $max_height) / 2, 0, 0, $tn_width, $tn_height, $width, $height);
		
		header("Content-type: image/jpeg");
		$resultOne=imagejpeg($dst, null, 90);
		$resultTwo=imagejpeg($dst, $resized, 90);
		
		imagedestroy($src);
		imagedestroy($dst);
	}*/

	$max_height = 1000;
	$max_width = 2000;
	if (isset($imgfile)) {
		$image = $imgfile;
		if (isset($mmax_width)) { if($mmax_width < 2000) $max_width = $mmax_width; }
		if (isset($mmax_height)) { if($mmax_height < 2000) $max_height = $mmax_height; }
		
		if (strrchr($image, '/')) {
			$filename = substr(strrchr($image, '/'), 1); // remove folder references
		}
		else {
			$filename = $image;
		}
		
		$size = getimagesize($image);
		$width = $size[0];
		$height = $size[1];
		
		// get the ratio needed
		$x_ratio = $max_width / $width;
		$y_ratio = $max_height / $height;
		$ratio = max($x_ratio,$y_ratio);
		
		$tn_width = ceil($ratio * $width);
		$tn_height = ceil($ratio * $height);
		
		$delta_x = floor(($max_width - $tn_width)/2);
		$delta_y = floor(($max_height - $tn_height)/2);
		
		// read image
		$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
		
		
		$resized = 'catalog_repository/uploads/tmp/'.$tn_width.'x'.$tn_height.'-'.$max_width.'x'.$max_height.'-'.$filename;
		$imageModified = @filemtime($image);
		$thumbModified = @filemtime($resized);
		
		//$trace->trace("$resized");
		switch ($ext) {
			case 'jpeg': 
			case 'jpg':     // jpg
				header("Content-type: image/jpeg");
				break;
			case 'png':     // png
				header("Content-type: image/png");
				break;
			case 'gif':     // gif
				header("Content-type: image/gif");
				break;
			default:
				notfound();
		}
		// if thumbnail is newer than image then output cached thumbnail and exit
		if($imageModified < $thumbModified) {
			header("Last-Modified: ".gmdate("D, d M Y H:i:s",$thumbModified)." GMT");
			readfile($resized);
			exit;
		}
		
		
		switch ($ext) {
			case 'jpeg': 
			case 'jpg':     // jpg
				$src = imagecreatefromjpeg($image) or notfound();
				break;
			case 'png':     // png
				$src = imagecreatefrompng($image) or notfound();
				break;
			case 'gif':     // gif
				$src = imagecreatefromgif($image) or notfound();
				break;
			default:
				notfound();
		}
		
		// set up canvas
		$dst = imagecreatetruecolor($max_width,$max_height);
		if ($ext == "jpg" || $ext == "jpeg") {
			imageantialias ($dst, true);
			imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
			header("Content-type: image/jpeg");
			imagejpeg($dst, null, 90);
			imagejpeg($dst, $resized, 90); //pour le cache;
		}
		if ($ext == "gif") {
			imagealphablending($dst, false);
			imageantialias ($dst, true);
			$transindex = imagecolortransparent($src);
			if($transindex >= 0) {
			  $transcol = imagecolorsforindex($src, $transindex);
			  $transindex = imagecolorallocatealpha($dst, $transcol['red'], $transcol['green'], $transcol['blue'], 127);
			  imagefill($dst, 0, 0, $transindex);
			}
			imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
			if($transindex >= 0) {
			  imagecolortransparent($dst, $transindex);
			  for($y=0; $y<$tn_height; ++$y)
			    for($x=0; $x<$tn_width; ++$x)
			      if(((imagecolorat($dst, $x, $y)>>24) & 0x7F) >= 100) imagesetpixel($dst, $x, $y, $transindex);
			}
						imagetruecolortopalette($dst, true, 255);
			imagesavealpha($dst, false);
			
			imageinterlace($dst);
			header("Content-type: image/gif");
			imagegif($dst);
			imagegif($dst, $resized); //pour le cache;
		}
		if ($ext == "png") {
			imageantialias ($dst, true);
			imagealphablending($dst, false);
			imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
			imagesavealpha($dst, true);
			header("Content-type: image/png");
			imagepng($dst);
			imagepng($dst,$resized); //pour le cache;
		}
		// clear out the resources
		imagedestroy($src);
		imagedestroy($dst);
	}
}

/**
* getfilesave()
* upload and save a file, and if photo was corretly uploaded, img were id is 'myphoto' is updated with the image
* @param $ok if ok is 1 a file has been upload, and the file is copied to tmp folder
*
*/
function getfileSave($ok=0) {
	global $bgcolor2, $bgcolor4, $currentlang, $multilingual;
	include("core/conf/uploadconfig.php");
		
	$myheaderpage= "<html><head><meta name=vs_targetSchema content=\"HTML 4.0\">\n"
	     		."<LINK rel=\"stylesheet\" type=\"text/css\" href=\"includes/styles/dialog.css\">\n"
	 	 		."<title>UPLOAD</title>\n"
	 	 		."<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n"
		 		."</head>\n"
		 		."<body topmargin=\"0\" leftmargin=\"0\" style=\"border: 0; margin: 0;\" scroll=\"no\">\n";
	$myfooterpage="</body></html>\n";
	if ($ok==1){
	     list($success,$response) = captureUpload($uploadFolder.'/tmp',false,'uploadfile');
	     if ($success) {
	     	    echo $myheaderpage;
	     	    echo _MESSAGE_UPLOAD_OK."<BR>";
	     	    echo "<input type=\"button\" onclick=\"javascript:updateImage('myphoto','$uploadFolder/tmp/$response');insertInFormField('update_photo_file','$response')\" value=\""._OK."\">";
	     	    echo "<input type=\"button\" onclick=\"javascript:window.close();\" value=\""._CANCEL."\">";
	     	    echo $myfooterpage;
	     } else {
	     		echo $myheaderpage;
	     	    echo _MESSAGE_UPLOAD_ERROR."<BR>";
	     	    echo "<div align=right><input type=\"button\" onclick=\"javascript:window.close();\" value=\""._CANCEL."\"></div>";
	     	    echo $myfooterpage;
	            }
	      //echo "$myheaderpage<br>$success<br>"
	      //."$response<br>"
	      //."$uploadFolder<br>"
	      //."$myfooterpage";
	      
	} else {
	$myform=$myheaderpage
	     ."<center><font class=\"title\"><b>"._UPLOADADMIN."</b></font></center>\n"
         ."<table border=\"0\"><tr>\n"
         ."<form action=\"system.php\" method=\"post\" ENCTYPE=\"multipart/form-data\">\n"
         ."<INPUT TYPE=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$uploadMaxSize."\">\n"
         ."<tr><td><font class=\"content\">"._FILENAME.":</font></td>\n"
         ."<td><input type=\"file\" size=40 name=\"uploadfile\"></td></tr>\n"
         ."<tr><td><font class=\"content\">\n"
         ."<tr><td>\n"
         ."<input type=\"hidden\" name=\"op\" value=\"fileSave\">\n"
         ."<input type=\"hidden\" name=\"ok\" value=\"1\">\n"         
		 ."<input type=\"submit\" value=\"Upload\"></td>\n"
         ."<td><input type=\"button\" value=\"Cancel\" OnClick=\"javascript:window.close();\"></td></tr>\n"
		 ."</form>\n"
         ."</table>\n"
	     ."<br>\n"
	     .$myfooterpage;
	  
	  echo $myform;
	}
}

?>
